/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.IsotopeDiff;
import org.openscience.cdk.tools.diff.tree.AtomTypeHybridizationDifference;
import org.openscience.cdk.tools.diff.tree.BondOrderDifference;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.DoubleDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IntegerDifference;
import org.openscience.cdk.tools.diff.tree.StringDifference;

@TestClass(value="org.openscience.cdk.tools.diff.AtomTypeDiffTest")
public class AtomTypeDiff {
    @TestMethod(value="testMatchAgainstItself,testDiff")
    public static String diff(IChemObject first, IChemObject second) {
        IDifference difference = AtomTypeDiff.difference(first, second);
        if (difference == null) {
            return "";
        }
        return difference.toString();
    }

    @TestMethod(value="testDifference")
    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof IAtomType) || !(second instanceof IAtomType)) {
            return null;
        }
        IAtomType firstElem = (IAtomType)first;
        IAtomType secondElem = (IAtomType)second;
        ChemObjectDifference totalDiff = new ChemObjectDifference("AtomTypeDiff");
        totalDiff.addChild(StringDifference.construct("N", firstElem.getAtomTypeName(), secondElem.getAtomTypeName()));
        totalDiff.addChild(BondOrderDifference.construct("MBO", firstElem.getMaxBondOrder(), secondElem.getMaxBondOrder()));
        totalDiff.addChild(DoubleDifference.construct("BOS", firstElem.getBondOrderSum(), secondElem.getBondOrderSum()));
        totalDiff.addChild(IntegerDifference.construct("FC", firstElem.getFormalCharge(), secondElem.getFormalCharge()));
        totalDiff.addChild(AtomTypeHybridizationDifference.construct("H", firstElem.getHybridization(), secondElem.getHybridization()));
        totalDiff.addChild(IntegerDifference.construct("NC", firstElem.getFormalNeighbourCount(), secondElem.getFormalNeighbourCount()));
        totalDiff.addChild(DoubleDifference.construct("CR", firstElem.getCovalentRadius(), secondElem.getCovalentRadius()));
        totalDiff.addChild(IntegerDifference.construct("V", firstElem.getValency(), secondElem.getValency()));
        totalDiff.addChild(IsotopeDiff.difference(first, second));
        if (totalDiff.childCount() > 0) {
            return totalDiff;
        }
        return null;
    }
}

