/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectFactoryClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.gtk.GInterfaceInfo;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.OS;

class AccessibleFactory {
    long handle;
    long objectParentType;
    long widgetTypeName;
    Callback atkObjectFactoryCB_create_accessible;
    Callback gTypeInfo_base_init_factory;
    Hashtable accessibles = new Hashtable(9);
    static final Hashtable Types = new Hashtable(9);
    static final Hashtable Factories = new Hashtable(9);
    static final long DefaultParentType = OS.g_type_from_name(Converter.wcsToMbcs(null, "GtkAccessible", true));
    static final byte[] FACTORY_PARENTTYPENAME = Converter.wcsToMbcs(null, "AtkObjectFactory", true);
    static final byte[] SWT_TYPE_PREFIX = Converter.wcsToMbcs(null, "SWT", false);
    static final byte[] CHILD_TYPENAME = Converter.wcsToMbcs(null, "Child", false);
    static final byte[] FACTORY_TYPENAME = Converter.wcsToMbcs(null, "SWTFactory", true);
    static final int[] actionRoles = new int[]{44, 46, 30, 12, 43, 45};
    static final int[] hypertextRoles = new int[]{30};
    static final int[] selectionRoles = new int[]{33, 60, 24, 35};
    static final int[] textRoles = new int[]{46, 30, 41, 42};
    static final Callback AtkActionCB_get_keybinding = AccessibleFactory.newCallback(AccessibleObject.class, "atkAction_get_keybinding", 2);
    static final Callback AtkActionCB_get_name = AccessibleFactory.newCallback(AccessibleObject.class, "atkAction_get_name", 2);
    static final Callback AtkComponentCB_get_extents = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_get_extents", 6);
    static final Callback AtkComponentCB_get_position = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_get_position", 4);
    static final Callback AtkComponentCB_get_size = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_get_size", 4);
    static final Callback AtkComponentCB_ref_accessible_at_point = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_ref_accessible_at_point", 4);
    static final Callback AtkHypertextCB_get_link = AccessibleFactory.newCallback(AccessibleObject.class, "atkHypertext_get_link", 2);
    static final Callback AtkHypertextCB_get_n_links = AccessibleFactory.newCallback(AccessibleObject.class, "atkHypertext_get_n_links", 1);
    static final Callback AtkHypertextCB_get_link_index = AccessibleFactory.newCallback(AccessibleObject.class, "atkHypertext_get_link_index", 2);
    static final Callback AtkObjectCB_get_description;
    static final Callback AtkObjectCB_get_index_in_parent;
    static final Callback AtkObjectCB_get_n_children;
    static final Callback AtkObjectCB_get_name;
    static final Callback AtkObjectCB_get_parent;
    static final Callback AtkObjectCB_get_role;
    static final Callback AtkObjectCB_ref_child;
    static final Callback AtkObjectCB_ref_state_set;
    static final Callback AtkSelectionCB_is_child_selected;
    static final Callback AtkSelectionCB_ref_selection;
    static final Callback AtkTextCB_get_caret_offset;
    static final Callback AtkTextCB_get_n_selections;
    static final Callback AtkTextCB_get_selection;
    static final Callback AtkTextCB_get_text;
    static final Callback AtkTextCB_get_text_after_offset;
    static final Callback AtkTextCB_get_text_at_offset;
    static final Callback AtkTextCB_get_text_before_offset;
    static final Callback AtkTextCB_get_character_at_offset;
    static final Callback AtkTextCB_get_character_count;
    static final Callback GObjectClass_finalize;
    static final Callback InitActionIfaceCB;
    static final Callback InitComponentIfaceCB;
    static final Callback InitHypertextIfaceCB;
    static final Callback GTypeInfo_base_init_type;
    static final Callback InitSelectionIfaceCB;
    static final Callback InitTextIfaceCB;
    static long ObjectIfaceDefinition;
    static final long ActionIfaceDefinition;
    static final long ComponentIfaceDefinition;
    static final long HypertextIfaceDefinition;
    static final long SelectionIfaceDefinition;
    static final long TextIfaceDefinition;

    private static Callback newCallback(Object object, String string, int n) {
        Callback callback = new Callback(object, string, n);
        if (callback.getAddress() == 0L) {
            SWT.error(3);
        }
        return callback;
    }

    private AccessibleFactory(long l) {
        this.widgetTypeName = OS.g_type_name(l);
        int n = OS.strlen(this.widgetTypeName) + 1;
        byte[] byArray = new byte[n];
        OS.memmove(byArray, this.widgetTypeName, (long)n);
        byte[] byArray2 = new byte[FACTORY_TYPENAME.length + n - 1];
        System.arraycopy(FACTORY_TYPENAME, 0, byArray2, 0, FACTORY_TYPENAME.length);
        System.arraycopy(byArray, 0, byArray2, FACTORY_TYPENAME.length - 1, n);
        if (OS.g_type_from_name(byArray2) == 0L) {
            long l2 = ATK.atk_get_default_registry();
            long l3 = ATK.atk_registry_get_factory(l2, l);
            this.objectParentType = ATK.atk_object_factory_get_accessible_type(l3);
            if (this.objectParentType == 0L) {
                this.objectParentType = DefaultParentType;
            }
            long l4 = OS.g_type_from_name(FACTORY_PARENTTYPENAME);
            this.gTypeInfo_base_init_factory = new Callback(this, "gTypeInfo_base_init_factory", 1);
            long l5 = this.gTypeInfo_base_init_factory.getAddress();
            if (l5 == 0L) {
                SWT.error(3);
            }
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.base_init = l5;
            gTypeInfo.class_size = (short)ATK.AtkObjectFactoryClass_sizeof();
            gTypeInfo.instance_size = (short)ATK.AtkObjectFactory_sizeof();
            long l6 = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(l6, gTypeInfo, GTypeInfo.sizeof);
            long l7 = OS.g_type_register_static(l4, byArray2, l6, 0);
            ATK.atk_registry_set_factory_type(l2, l, l7);
            this.handle = ATK.atk_registry_get_factory(l2, l);
        }
    }

    void addAccessible(Accessible accessible) {
        long l = accessible.getControlHandle();
        this.accessibles.put(new LONG(l), accessible);
        ATK.atk_object_factory_create_accessible(this.handle, l);
    }

    long atkObjectFactory_create_accessible(long l) {
        AccessibleObject accessibleObject;
        Accessible accessible = (Accessible)this.accessibles.get(new LONG(l));
        if (accessible == null) {
            long l2 = OS.g_object_new(this.objectParentType, 0L);
            ATK.atk_object_initialize(l2, l);
            return l2;
        }
        if (accessible.accessibleObject != null) {
            return accessible.accessibleObject.handle;
        }
        int n = OS.strlen(this.widgetTypeName);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, this.widgetTypeName, (long)n);
        long l3 = AccessibleFactory.getType(byArray, accessible, this.objectParentType, -1);
        accessible.accessibleObject = accessibleObject = new AccessibleObject(l3, l, accessible, this.objectParentType, false);
        return accessibleObject.handle;
    }

    static long getChildType(Accessible accessible, int n) {
        return AccessibleFactory.getType(CHILD_TYPENAME, accessible, DefaultParentType, n);
    }

    static long getDefaultParentType() {
        return DefaultParentType;
    }

    static long getType(byte[] byArray, Accessible accessible, long l, int n) {
        int n2;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
        accessibleControlEvent.childID = n;
        AccessibleControlListener[] accessibleControlListenerArray = accessible.getControlListeners();
        for (n2 = 0; n2 < accessibleControlListenerArray.length; ++n2) {
            accessibleControlListenerArray[n2].getRole(accessibleControlEvent);
        }
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (accessibleControlEvent.detail != 0) {
            int n6;
            for (n6 = 0; n6 < actionRoles.length; ++n6) {
                if (accessibleControlEvent.detail != actionRoles[n6]) continue;
                n2 = 1;
                break;
            }
            for (n6 = 0; n6 < hypertextRoles.length; ++n6) {
                if (accessibleControlEvent.detail != hypertextRoles[n6]) continue;
                n3 = 1;
                break;
            }
            for (n6 = 0; n6 < selectionRoles.length; ++n6) {
                if (accessibleControlEvent.detail != selectionRoles[n6]) continue;
                n4 = 1;
                break;
            }
            for (n6 = 0; n6 < textRoles.length; ++n6) {
                if (accessibleControlEvent.detail != textRoles[n6]) continue;
                n5 = 1;
                break;
            }
        } else {
            n5 = 1;
            n4 = 1;
            n3 = 1;
            n2 = 1;
        }
        String string = new String(SWT_TYPE_PREFIX);
        string = string + new String(byArray);
        if (n2 != 0) {
            string = string + "Action";
        }
        if (n3 != 0) {
            string = string + "Hypertext";
        }
        if (n4 != 0) {
            string = string + "Selection";
        }
        if (n5 != 0) {
            string = string + "Text";
        }
        long l2 = 0L;
        LONG lONG = (LONG)Types.get(string);
        if (lONG != null) {
            l2 = lONG.value;
        } else {
            long l3 = OS.g_malloc(GTypeQuery.sizeof);
            OS.g_type_query(l, l3);
            GTypeQuery gTypeQuery = new GTypeQuery();
            OS.memmove(gTypeQuery, l3, (long)GTypeQuery.sizeof);
            OS.g_free(l3);
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.base_init = GTypeInfo_base_init_type.getAddress();
            gTypeInfo.class_size = (short)gTypeQuery.class_size;
            gTypeInfo.instance_size = (short)gTypeQuery.instance_size;
            ObjectIfaceDefinition = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(ObjectIfaceDefinition, gTypeInfo, GTypeInfo.sizeof);
            byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
            l2 = OS.g_type_register_static(l, byArray2, ObjectIfaceDefinition, 0);
            OS.g_type_add_interface_static(l2, AccessibleObject.ATK_COMPONENT_TYPE, ComponentIfaceDefinition);
            if (n2 != 0) {
                OS.g_type_add_interface_static(l2, AccessibleObject.ATK_ACTION_TYPE, ActionIfaceDefinition);
            }
            if (n3 != 0) {
                OS.g_type_add_interface_static(l2, AccessibleObject.ATK_HYPERTEXT_TYPE, HypertextIfaceDefinition);
            }
            if (n4 != 0) {
                OS.g_type_add_interface_static(l2, AccessibleObject.ATK_SELECTION_TYPE, SelectionIfaceDefinition);
            }
            if (n5 != 0) {
                OS.g_type_add_interface_static(l2, AccessibleObject.ATK_TEXT_TYPE, TextIfaceDefinition);
            }
            Types.put(string, new LONG(l2));
        }
        return l2;
    }

    long gTypeInfo_base_init_factory(long l) {
        long l2 = ATK.ATK_OBJECT_FACTORY_CLASS(l);
        AtkObjectFactoryClass atkObjectFactoryClass = new AtkObjectFactoryClass();
        ATK.memmove(atkObjectFactoryClass, l2);
        this.atkObjectFactoryCB_create_accessible = new Callback(this, "atkObjectFactory_create_accessible", 1);
        long l3 = this.atkObjectFactoryCB_create_accessible.getAddress();
        if (l3 == 0L) {
            SWT.error(3);
        }
        atkObjectFactoryClass.create_accessible = l3;
        ATK.memmove(l2, atkObjectFactoryClass);
        return 0L;
    }

    static long gTypeInfo_base_init_type(long l) {
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l);
        atkObjectClass.get_name = AtkObjectCB_get_name.getAddress();
        atkObjectClass.get_description = AtkObjectCB_get_description.getAddress();
        atkObjectClass.get_n_children = AtkObjectCB_get_n_children.getAddress();
        atkObjectClass.get_role = AtkObjectCB_get_role.getAddress();
        atkObjectClass.get_parent = AtkObjectCB_get_parent.getAddress();
        atkObjectClass.ref_state_set = AtkObjectCB_ref_state_set.getAddress();
        atkObjectClass.get_index_in_parent = AtkObjectCB_get_index_in_parent.getAddress();
        atkObjectClass.ref_child = AtkObjectCB_ref_child.getAddress();
        long l2 = OS.G_OBJECT_CLASS(l);
        GObjectClass gObjectClass = new GObjectClass();
        OS.memmove(gObjectClass, l2);
        gObjectClass.finalize = GObjectClass_finalize.getAddress();
        OS.memmove(l2, gObjectClass);
        ATK.memmove(l, atkObjectClass);
        return 0L;
    }

    static long initActionIfaceCB(long l) {
        AtkActionIface atkActionIface = new AtkActionIface();
        ATK.memmove(atkActionIface, l);
        atkActionIface.get_keybinding = AtkActionCB_get_keybinding.getAddress();
        atkActionIface.get_name = AtkActionCB_get_name.getAddress();
        ATK.memmove(l, atkActionIface);
        return 0L;
    }

    static long initComponentIfaceCB(long l) {
        AtkComponentIface atkComponentIface = new AtkComponentIface();
        ATK.memmove(atkComponentIface, l);
        atkComponentIface.get_extents = AtkComponentCB_get_extents.getAddress();
        atkComponentIface.get_position = AtkComponentCB_get_position.getAddress();
        atkComponentIface.get_size = AtkComponentCB_get_size.getAddress();
        atkComponentIface.ref_accessible_at_point = AtkComponentCB_ref_accessible_at_point.getAddress();
        ATK.memmove(l, atkComponentIface);
        return 0L;
    }

    static long initHypertextIfaceCB(long l) {
        AtkHypertextIface atkHypertextIface = new AtkHypertextIface();
        ATK.memmove(atkHypertextIface, l);
        atkHypertextIface.get_link = AtkHypertextCB_get_link.getAddress();
        atkHypertextIface.get_link_index = AtkHypertextCB_get_link_index.getAddress();
        atkHypertextIface.get_n_links = AtkHypertextCB_get_n_links.getAddress();
        ATK.memmove(l, atkHypertextIface);
        return 0L;
    }

    static long initSelectionIfaceCB(long l) {
        AtkSelectionIface atkSelectionIface = new AtkSelectionIface();
        ATK.memmove(atkSelectionIface, l);
        atkSelectionIface.is_child_selected = AtkSelectionCB_is_child_selected.getAddress();
        atkSelectionIface.ref_selection = AtkSelectionCB_ref_selection.getAddress();
        ATK.memmove(l, atkSelectionIface);
        return 0L;
    }

    static long initTextIfaceCB(long l) {
        AtkTextIface atkTextIface = new AtkTextIface();
        ATK.memmove(atkTextIface, l);
        atkTextIface.get_caret_offset = AtkTextCB_get_caret_offset.getAddress();
        atkTextIface.get_character_at_offset = AtkTextCB_get_character_at_offset.getAddress();
        atkTextIface.get_character_count = AtkTextCB_get_character_count.getAddress();
        atkTextIface.get_n_selections = AtkTextCB_get_n_selections.getAddress();
        atkTextIface.get_selection = AtkTextCB_get_selection.getAddress();
        atkTextIface.get_text = AtkTextCB_get_text.getAddress();
        atkTextIface.get_text_after_offset = AtkTextCB_get_text_after_offset.getAddress();
        atkTextIface.get_text_at_offset = AtkTextCB_get_text_at_offset.getAddress();
        atkTextIface.get_text_before_offset = AtkTextCB_get_text_before_offset.getAddress();
        ATK.memmove(l, atkTextIface);
        return 0L;
    }

    static void registerAccessible(Accessible accessible) {
        if (DefaultParentType == 0L) {
            return;
        }
        long l = accessible.getControlHandle();
        long l2 = OS.G_OBJECT_TYPE(l);
        AccessibleFactory accessibleFactory = (AccessibleFactory)Factories.get(new LONG(l2));
        if (accessibleFactory == null) {
            accessibleFactory = new AccessibleFactory(l2);
            Factories.put(new LONG(l2), accessibleFactory);
        }
        accessibleFactory.addAccessible(accessible);
    }

    void removeAccessible(Accessible accessible) {
        this.accessibles.remove(new LONG(accessible.getControlHandle()));
    }

    static void unregisterAccessible(Accessible accessible) {
        long l = accessible.getControlHandle();
        long l2 = OS.G_OBJECT_TYPE(l);
        AccessibleFactory accessibleFactory = (AccessibleFactory)Factories.get(new LONG(l2));
        if (accessibleFactory != null) {
            accessibleFactory.removeAccessible(accessible);
        }
    }

    static {
        AtkObjectCB_get_name = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_name", 1);
        AtkObjectCB_get_description = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_description", 1);
        AtkObjectCB_get_n_children = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_n_children", 1);
        AtkObjectCB_get_role = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_role", 1);
        AtkObjectCB_get_parent = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_parent", 1);
        AtkObjectCB_ref_state_set = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_ref_state_set", 1);
        AtkObjectCB_get_index_in_parent = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_index_in_parent", 1);
        AtkObjectCB_ref_child = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_ref_child", 2);
        AtkSelectionCB_is_child_selected = AccessibleFactory.newCallback(AccessibleObject.class, "atkSelection_is_child_selected", 2);
        AtkSelectionCB_ref_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkSelection_ref_selection", 2);
        AtkTextCB_get_caret_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_caret_offset", 1);
        AtkTextCB_get_n_selections = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_n_selections", 1);
        AtkTextCB_get_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_selection", 4);
        AtkTextCB_get_text = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text", 3);
        AtkTextCB_get_text_after_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text_after_offset", 5);
        AtkTextCB_get_text_at_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text_at_offset", 5);
        AtkTextCB_get_text_before_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text_before_offset", 5);
        AtkTextCB_get_character_at_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_character_at_offset", 2);
        AtkTextCB_get_character_count = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_character_count", 1);
        GObjectClass_finalize = AccessibleFactory.newCallback(AccessibleObject.class, "gObjectClass_finalize", 1);
        GTypeInfo_base_init_type = AccessibleFactory.newCallback(AccessibleFactory.class, "gTypeInfo_base_init_type", 1);
        InitActionIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initActionIfaceCB", 1);
        GInterfaceInfo gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitActionIfaceCB.getAddress();
        ActionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ActionIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitComponentIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initComponentIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitComponentIfaceCB.getAddress();
        ComponentIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ComponentIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitHypertextIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initHypertextIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitHypertextIfaceCB.getAddress();
        HypertextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(HypertextIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitSelectionIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initSelectionIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitSelectionIfaceCB.getAddress();
        SelectionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(SelectionIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitTextIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initTextIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitTextIfaceCB.getAddress();
        TextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(TextIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
    }
}

