/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.visitor;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ArrowElement;
import org.openscience.cdk.renderer.elements.AtomSymbolElement;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.PathElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.elements.TextGroupElement;
import org.openscience.cdk.renderer.elements.WedgeLineElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.ReactionSceneGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public class SVGGenerator
implements IDrawVisitor {
    private RendererModel rendererModel;
    public static final String HEADER = "<?xml version=\"1.0\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"\n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"1000\" height=\"600\">";
    private final StringBuffer svg = new StringBuffer();
    private AffineTransform transform;

    public SVGGenerator() {
        this.svg.append(HEADER);
    }

    private void newline() {
        this.svg.append("\n");
    }

    public String getResult() {
        this.newline();
        this.svg.append("</svg>");
        return this.svg.toString();
    }

    public int[] transformPoint(double x, double y) {
        double[] src = new double[]{x, y};
        double[] dest = new double[2];
        this.transform.transform(src, 0, dest, 0, 1);
        return new int[]{(int)dest[0], (int)dest[1]};
    }

    @Override
    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public void visit(ElementGroup group) {
        group.visitChildren(this);
    }

    public void visit(WedgeLineElement wedge) {
        Vector2d normal = new Vector2d(wedge.y1 - wedge.y2, wedge.x2 - wedge.x1);
        normal.normalize();
        normal.scale((Double)this.rendererModel.getParameter(BasicBondGenerator.WedgeWidth.class).getValue() / (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue());
        Point2d vertexA = new Point2d(wedge.x1, wedge.y1);
        Point2d vertexB = new Point2d(wedge.x2, wedge.y2);
        Point2d vertexC = new Point2d(vertexB);
        vertexB.add(normal);
        vertexC.sub(normal);
        if (wedge.isDashed) {
            this.drawDashedWedge(vertexA, vertexB, vertexC);
        } else {
            this.drawFilledWedge(vertexA, vertexB, vertexC);
        }
    }

    private void drawFilledWedge(Point2d vertexA, Point2d vertexB, Point2d vertexC) {
        int[] pB = this.transformPoint(vertexB.x, vertexB.y);
        int[] pC = this.transformPoint(vertexC.x, vertexC.y);
        int[] pA = this.transformPoint(vertexA.x, vertexA.y);
        this.svg.append(String.format("<polygon points=\"%s,%s %s,%s %s,%s\"style=\"fill:black;stroke:black;stroke-width:1\"/>", pB[0], pB[1], pC[0], pC[1], pA[0], pA[1]));
    }

    public void visit(PathElement path) {
    }

    public void visit(LineElement line) {
        this.newline();
        int[] p1 = this.transformPoint(line.x1, line.y1);
        int[] p2 = this.transformPoint(line.x2, line.y2);
        this.svg.append(String.format("<line x1=\"%s\" y1=\"%s\" x2=\"%s\" y2=\"%s\" style=\"stroke:black; stroke-width:1px;\" />", p1[0], p1[1], p2[0], p2[1]));
    }

    private void drawDashedWedge(Point2d vertexA, Point2d vertexB, Point2d vertexC) {
        double distance = vertexB.distance(vertexA);
        double gapFactor = 0.1;
        double gap = distance * gapFactor;
        double numberOfDashes = distance / gap;
        double d = 0.0;
        int i = 0;
        while ((double)i < numberOfDashes) {
            Point2d p1 = new Point2d();
            p1.interpolate(vertexA, vertexB, d);
            Point2d p2 = new Point2d();
            p2.interpolate(vertexA, vertexC, d);
            int[] p1T = this.transformPoint(p1.x, p1.y);
            int[] p2T = this.transformPoint(p2.x, p2.y);
            this.svg.append(String.format("<line x1=\"%s\" y1=\"%s\" x2=\"%s\" y2=\"%s\" style=\"stroke:black; stroke-width:1px;\" />", p1T[0], p1T[1], p2T[0], p2T[1]));
            if (distance * (d + gapFactor) >= distance) break;
            d += gapFactor;
            ++i;
        }
    }

    public void visit(OvalElement oval) {
        this.newline();
        int[] p1 = this.transformPoint(oval.x - oval.radius, oval.y - oval.radius);
        int[] p2 = this.transformPoint(oval.x + oval.radius, oval.y + oval.radius);
        int r = (p2[0] - p1[0]) / 2;
        this.svg.append(String.format("<ellipse cx=\"%s\" cy=\"%s\" rx=\"%s\" ry=\"%s\" style=\"stroke:black; stroke-width:1px; fill:none;\" />", p1[0] + r, p1[1] + r, r, r));
    }

    public void visit(AtomSymbolElement atomSymbol) {
        this.newline();
        int[] p = this.transformPoint(atomSymbol.xCoord, atomSymbol.yCoord);
        this.svg.append(String.format("<text x=\"%s\" y=\"%s\" style=\"fill:%s\">%s</text>", p[0], p[1], this.toColorString(atomSymbol.color), atomSymbol.text));
    }

    private String toColorString(Color color) {
        if (color == Color.RED) {
            return "red";
        }
        if (color == Color.BLUE) {
            return "blue";
        }
        return "black";
    }

    public void visit(TextElement textElement) {
        this.newline();
        int[] p = this.transformPoint(textElement.xCoord, textElement.yCoord);
        this.svg.append(String.format("<text x=\"%s\" y=\"%s\">%s</text>", p[0], p[1], textElement.text));
    }

    public void visit(TextGroupElement textGroup) {
    }

    public void visit(ArrowElement line) {
        int w = (int)(line.width * (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue());
        int[] a = this.transformPoint(line.x1, line.y1);
        int[] b = this.transformPoint(line.x2, line.y2);
        this.newline();
        this.svg.append(String.format("<line x1=\"%s\" y1=\"%s\" x2=\"%s\" y2=\"%s\" style=\"stroke:black; stroke-width:" + w + "px;\" />", a[0], a[1], b[0], b[1]));
        double aW = (Double)this.rendererModel.getParameter(ReactionSceneGenerator.ArrowHeadWidth.class).getValue() / (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        if (line.direction) {
            int[] c = this.transformPoint(line.x1 - aW, line.y1 - aW);
            int[] d = this.transformPoint(line.x1 - aW, line.y1 + aW);
            this.newline();
            this.svg.append(String.format("<line x1=\"%s\" y1=\"%s\" x2=\"%s\" y2=\"%s\" style=\"stroke:black; stroke-width:" + w + "px;\" />", a[0], a[1], c[0], c[1]));
            this.newline();
            this.svg.append(String.format("<line x1=\"%s\" y1=\"%s\" x2=\"%s\" y2=\"%s\" style=\"stroke:black; stroke-width:" + w + "px;\" />", a[0], a[1], d[0], d[1]));
        } else {
            int[] c = this.transformPoint(line.x2 + aW, line.y2 - aW);
            int[] d = this.transformPoint(line.x2 + aW, line.y2 + aW);
            this.newline();
            this.svg.append(String.format("<line x1=\"%s\" y1=\"%s\" x2=\"%s\" y2=\"%s\" style=\"stroke:black; stroke-width:" + w + "px;\" />", a[0], a[1], c[0], c[1]));
            this.newline();
            this.svg.append(String.format("<line x1=\"%s\" y1=\"%s\" x2=\"%s\" y2=\"%s\" style=\"stroke:black; stroke-width:" + w + "px;\" />", a[0], a[1], d[0], d[1]));
        }
    }

    public void visit(RectangleElement rectangleElement) {
        int[] pA = this.transformPoint(rectangleElement.x, rectangleElement.y);
        int[] pB = this.transformPoint(rectangleElement.x + rectangleElement.width, rectangleElement.y);
        int[] pC = this.transformPoint(rectangleElement.x, rectangleElement.y + rectangleElement.height);
        int[] pD = this.transformPoint(rectangleElement.x + rectangleElement.width, rectangleElement.y + rectangleElement.height);
        this.newline();
        this.svg.append(String.format("<polyline points=\"%s,%s %s,%s %s,%s %s,%s %s,%s\"style=\"fill:none;stroke:black;stroke-width:1\"/>", pA[0], pA[1], pB[0], pB[1], pD[0], pD[1], pC[0], pC[1], pA[0], pA[1]));
    }

    @Override
    public void visit(IRenderingElement element) {
        if (element instanceof ElementGroup) {
            this.visit((ElementGroup)element);
        } else if (element instanceof WedgeLineElement) {
            this.visit((WedgeLineElement)element);
        } else if (element instanceof LineElement) {
            this.visit((LineElement)element);
        } else if (element instanceof ArrowElement) {
            this.visit((ArrowElement)element);
        } else if (element instanceof OvalElement) {
            this.visit((OvalElement)element);
        } else if (element instanceof TextGroupElement) {
            this.visit((TextGroupElement)element);
        } else if (element instanceof AtomSymbolElement) {
            this.visit((AtomSymbolElement)element);
        } else if (element instanceof TextElement) {
            this.visit((TextElement)element);
        } else if (element instanceof RectangleElement) {
            this.visit((RectangleElement)element);
        } else if (element instanceof PathElement) {
            this.visit((PathElement)element);
        } else {
            System.err.println("Visitor method for " + element.getClass().getName() + " is not implemented");
        }
    }

    @Override
    public void setFontManager(IFontManager fontManager) {
    }

    @Override
    public void setRendererModel(RendererModel rendererModel) {
        this.rendererModel = rendererModel;
    }
}

