/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math.qm;

import org.openscience.cdk.math.Matrix;
import org.openscience.cdk.math.Vector;
import org.openscience.cdk.math.qm.IBasis;

public class Orbitals {
    private int count_basis;
    private int count_orbitals;
    private Matrix C;
    private IBasis basis;
    private int count_electrons = 1;

    public Orbitals(IBasis basis) {
        this.basis = basis;
        this.count_orbitals = this.count_basis = basis.getSize();
        this.C = new Matrix(this.count_basis, this.count_basis);
        for (int i = 0; i < this.count_basis; ++i) {
            for (int j = 0; j < this.count_basis; ++j) {
                this.C.matrix[i][j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    public Orbitals(IBasis basis, Matrix C) {
        this.basis = basis;
        this.count_basis = basis.getSize();
        if (this.count_basis == C.rows) {
            this.C = C;
            this.count_orbitals = C.columns;
        } else {
            this.C = new Matrix(this.count_basis, this.count_basis);
            for (int i = 0; i < this.count_basis; ++i) {
                for (int j = 0; j < this.count_basis; ++j) {
                    this.C.matrix[i][j] = i == j ? 1.0 : 0.0;
                }
            }
            this.count_orbitals = this.count_basis;
        }
    }

    public void setCoefficients(Matrix C) {
        if (this.count_basis == C.rows) {
            this.C = C;
            this.count_orbitals = C.columns;
        }
    }

    public Matrix getCoefficients() {
        return this.C;
    }

    public double getValue(int index, double x, double y, double z) {
        double sum = 0.0;
        for (int i = 0; i < this.count_basis; ++i) {
            if (this.C.matrix[i][index] == 0.0) continue;
            sum += this.C.matrix[i][index] * this.basis.getValue(i, x, y, z);
        }
        return sum;
    }

    public Vector getValues(int index, Matrix m) {
        if (m.rows != 3) {
            return null;
        }
        Vector result = this.basis.getValues(0, m).mul(this.C.matrix[0][index]);
        for (int i = 1; i < this.count_basis; ++i) {
            if (this.C.matrix[i][index] == 0.0) continue;
            result.add(this.basis.getValues(i, m).mul(this.C.matrix[0][index]));
        }
        return result;
    }

    public IBasis getBasis() {
        return this.basis;
    }

    public int getCountBasis() {
        return this.count_basis;
    }

    public int getCountOrbitals() {
        return this.count_orbitals;
    }

    public void setCountElectrons(int count) {
        if (count > 0) {
            this.count_electrons = count;
        }
    }

    public int getCountElectrons() {
        return this.count_electrons;
    }
}

