/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math.qm;

import org.openscience.cdk.math.Matrix;
import org.openscience.cdk.math.Vector;
import org.openscience.cdk.math.qm.IBasis;
import org.openscience.cdk.math.qm.Orbitals;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class ClosedShellJob {
    private Orbitals orbitals;
    private Vector E;
    private static ILoggingTool log = LoggingToolFactory.createLoggingTool(ClosedShellJob.class);
    private int iterations = 0;

    public ClosedShellJob(Orbitals orbitals) {
        this.orbitals = orbitals;
    }

    public Vector getEnergies() {
        return this.E.duplicate();
    }

    private void sort(Matrix C, Vector E) {
        boolean changed;
        do {
            changed = false;
            for (int i = 1; i < E.size; ++i) {
                if (!(E.vector[i - 1] > E.vector[i])) continue;
                double value = E.vector[i];
                E.vector[i] = E.vector[i - 1];
                E.vector[i - 1] = value;
                for (int j = 0; j < C.rows; ++j) {
                    value = C.matrix[j][i];
                    C.matrix[j][i] = C.matrix[j][i - 1];
                    C.matrix[j][i - 1] = value;
                }
                changed = true;
            }
        } while (changed);
    }

    private Matrix calculateS(IBasis basis) {
        int size = basis.getSize();
        Matrix S = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                S.matrix[i][j] = basis.calcS(i, j);
            }
        }
        return S;
    }

    private Matrix calculateT(IBasis basis) {
        int size = basis.getSize();
        Matrix J = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                J.matrix[i][j] = basis.calcJ(j, i) / 2.0;
            }
        }
        return J;
    }

    private Matrix calculateV(IBasis basis) {
        int size = basis.getSize();
        Matrix V = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                V.matrix[i][j] = basis.calcV(i, j);
            }
        }
        return V;
    }

    private double[][][][] calculateI(IBasis basis) {
        int size = basis.getSize();
        double[][][][] result = new double[size][][][];
        for (int i = 0; i < size; ++i) {
            result[i] = new double[i + 1][][];
            for (int j = 0; j <= i; ++j) {
                result[i][j] = new double[size][];
                for (int k = 0; k < size; ++k) {
                    result[i][j][k] = new double[k + 1];
                    for (int l = 0; l <= k; ++l) {
                        result[i][j][k][l] = basis.calcI(i, j, k, l);
                    }
                }
            }
        }
        return result;
    }

    private Matrix calculateD(IBasis basis, Matrix C, int count_electrons) {
        int size = basis.getSize();
        int orbitals = C.getColumns();
        int occ = count_electrons / 2;
        int locc = count_electrons % 2;
        Matrix D = new Matrix(size, size);
        log.debug("D:occ=" + occ + " locc=" + locc);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int k;
                D.matrix[i][j] = 0.0;
                for (k = 0; k < orbitals && k < occ; ++k) {
                    double[] dArray = D.matrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + 2.0 * C.matrix[i][k] * C.matrix[j][k];
                }
                if (locc != 1 || k + 1 >= orbitals) continue;
                double[] dArray = D.matrix[i];
                int n = j;
                dArray[n] = dArray[n] + C.matrix[i][k + 1] * C.matrix[j][k + 1];
            }
        }
        return D;
    }

    private Matrix calculateJ(IBasis basis, double[][][][] I, Matrix D) {
        int size = basis.getSize();
        Matrix J = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            int j = 0;
            while (j < size) {
                J.matrix[i][j] = 0.0;
                for (int k = 0; k < size; ++k) {
                    for (int l = 0; l < size; ++l) {
                        if (i >= j) {
                            if (k >= l) {
                                double[] dArray = J.matrix[i];
                                int n = j;
                                dArray[n] = dArray[n] + D.matrix[k][l] * I[i][j][k][l];
                                continue;
                            }
                            double[] dArray = J.matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] + D.matrix[k][l] * I[i][j][l][k];
                            continue;
                        }
                        if (k >= l) {
                            double[] dArray = J.matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] + D.matrix[k][l] * I[j][i][k][l];
                            continue;
                        }
                        double[] dArray = J.matrix[i];
                        int n = j;
                        dArray[n] = dArray[n] + D.matrix[k][l] * I[j][i][l][k];
                    }
                }
                double[] dArray = J.matrix[i];
                int n = j++;
                dArray[n] = dArray[n] * 2.0;
            }
        }
        return J;
    }

    private Matrix calculateK(IBasis basis, double[][][][] I, Matrix D) {
        int size = basis.getSize();
        Matrix K = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                K.matrix[i][j] = 0.0;
                for (int k = 0; k < size; ++k) {
                    for (int l = 0; l < size; ++l) {
                        if (i >= j) {
                            if (k >= l) {
                                double[] dArray = K.matrix[i];
                                int n = j;
                                dArray[n] = dArray[n] + D.matrix[k][l] * I[i][j][k][l];
                                continue;
                            }
                            double[] dArray = K.matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] + D.matrix[k][l] * I[i][j][l][k];
                            continue;
                        }
                        if (k >= l) {
                            double[] dArray = K.matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] + D.matrix[k][l] * I[j][i][k][l];
                            continue;
                        }
                        double[] dArray = K.matrix[i];
                        int n = j;
                        dArray[n] = dArray[n] + D.matrix[k][l] * I[j][i][l][k];
                    }
                }
            }
        }
        return K;
    }

    private double contraction(Matrix A, Matrix B) {
        double result = 0.0;
        for (int i = 0; i < A.rows; ++i) {
            for (int j = 0; j < A.columns; ++j) {
                result += A.matrix[i][j] * B.matrix[i][j];
            }
        }
        return result;
    }

    public Orbitals calculate() {
        long time = System.currentTimeMillis();
        IBasis basis = this.orbitals.getBasis();
        int count_electrons = this.orbitals.getCountElectrons();
        Matrix C = this.orbitals.getCoefficients().duplicate();
        Matrix S = this.calculateS(basis);
        log.debug("S = \n" + S + "\n");
        log.debug("C = \n" + C + "\n");
        C = C.orthonormalize(S);
        log.debug("C' = \n" + C + "\n");
        log.debug("C't * S * C' = \n" + S.similar(C) + "\n");
        Matrix T = this.calculateT(basis);
        log.debug("T = \n" + T + "\n");
        Matrix V = this.calculateV(basis);
        log.debug("V = \n" + V + "\n");
        Matrix HAO = T.add(V);
        log.debug("HAO = \n" + HAO + "\n");
        Matrix H = HAO.similar(C);
        log.debug("H = C't * HAO * C' = \n" + H.similar(C) + "\n");
        Matrix U = H.diagonalize(50);
        this.E = H.similar(U).getVectorFromDiagonal();
        C = C.mul(U);
        this.sort(C, this.E);
        log.debug("C(neu) = \n" + C + "\n");
        log.debug("E = \n" + this.E + "\n");
        for (int j = 0; j < this.E.size; ++j) {
            log.debug("E(" + (j + 1) + ".Orbital)=" + this.E.vector[j] * 27.211 + " eV");
        }
        time = System.currentTimeMillis() - time;
        log.debug("Time = " + time + " ms");
        time = System.currentTimeMillis();
        double[][][][] I = this.iterations > 0 ? this.calculateI(basis) : (double[][][][])null;
        for (int i = 0; i < this.iterations; ++i) {
            log.debug(i + 1 + ".Durchlauf\n");
            time = System.currentTimeMillis();
            log.debug("C't * S * C' = \n" + S.similar(C) + "\n");
            log.debug("count of electrons = " + count_electrons + "\n");
            Matrix D = this.calculateD(basis, C, count_electrons);
            log.debug("D = \n" + D + "\n");
            log.debug("2*contraction(D*S) = " + this.contraction(D, S) * 2.0 + "\n");
            Matrix J = this.calculateJ(basis, I, D);
            log.debug("J = \n" + J + "\n");
            Matrix K = this.calculateK(basis, I, D);
            log.debug("K = \n" + K + "\n");
            Matrix F = HAO.add(J).sub(K);
            log.debug("F = H+J-K = \n" + F + "\n");
            H = F.similar(C);
            log.debug("H = C't * F * C' = \n" + H + "\n");
            U = H.diagonalize(50);
            this.E = H.similar(U).getVectorFromDiagonal();
            C = C.mul(U);
            this.sort(C, this.E);
            log.debug("C(neu) = \n" + C + "\n");
            log.debug("E = \n" + this.E + "\n");
            for (int j = 0; j < this.E.size; ++j) {
                log.debug("E(" + (j + 1) + ".Orbital)=" + this.E.vector[j] * 27.211 + " eV");
            }
            double energy = this.contraction(D, HAO.add(F));
            log.debug("Gesamtenergie = " + energy + " (" + energy * 27.211 + " eV)\n");
            time = System.currentTimeMillis() - time;
            log.debug("Time = " + time + " ms");
            System.gc();
        }
        return new Orbitals(basis, C);
    }
}

