/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import signature.DAGVisitor;
import signature.InvariantArray;
import signature.InvariantInt;
import signature.InvariantIntIntPair;
import signature.InvariantIntStringPair;
import signature.InvariantList;
import signature.Invariants;
import signature.VisitableDAG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAG
implements Iterable<List<Node>> {
    public Comparator<Node> nodeComparator;
    private List<List<Node>> layers = new ArrayList<List<Node>>();
    private int[] parentCounts;
    private int[] childCounts;
    private Invariants invariants;
    private List<Node> nodes = new ArrayList<Node>();
    private int vertexCount;

    public DAG(int rootVertexIndex, int graphVertexCount) {
        ArrayList<Node> rootLayer = new ArrayList<Node>();
        Node rootNode = new Node(rootVertexIndex, 0);
        rootLayer.add(rootNode);
        this.layers.add(rootLayer);
        this.nodes.add(rootNode);
        this.vertexCount = 1;
        this.parentCounts = new int[graphVertexCount];
        this.childCounts = new int[graphVertexCount];
    }

    @Override
    public Iterator<List<Node>> iterator() {
        return this.layers.iterator();
    }

    public List<Node> getRootLayer() {
        return this.layers.get(0);
    }

    public Node getRoot() {
        return this.layers.get(0).get(0);
    }

    public Invariants copyInvariants() {
        return (Invariants)this.invariants.clone();
    }

    public void initializeWithStringLabels(String[] vertexLabels) {
        this.vertexCount = vertexLabels.length;
        this.invariants = new Invariants(this.vertexCount, this.nodes.size());
        ArrayList<InvariantIntStringPair> pairs = new ArrayList<InvariantIntStringPair>();
        for (int i = 0; i < this.vertexCount; ++i) {
            String l = vertexLabels[i];
            int p = this.parentCounts[i];
            pairs.add(new InvariantIntStringPair(l, p, i));
        }
        Collections.sort(pairs);
        if (pairs.size() == 0) {
            return;
        }
        this.nodeComparator = new NodeStringLabelComparator(vertexLabels);
        int order = 1;
        InvariantIntStringPair first = (InvariantIntStringPair)pairs.get(0);
        this.invariants.setVertexInvariant(first.getOriginalIndex(), order);
        for (int i = 1; i < pairs.size(); ++i) {
            InvariantIntStringPair b;
            InvariantIntStringPair a = (InvariantIntStringPair)pairs.get(i - 1);
            if (!a.equals(b = (InvariantIntStringPair)pairs.get(i))) {
                ++order;
            }
            this.invariants.setVertexInvariant(b.getOriginalIndex(), order);
        }
    }

    public void initializeWithIntLabels(int[] vertexLabels) {
        this.vertexCount = vertexLabels.length;
        this.invariants = new Invariants(this.vertexCount, this.nodes.size());
        ArrayList<InvariantIntIntPair> pairs = new ArrayList<InvariantIntIntPair>();
        for (int i = 0; i < this.vertexCount; ++i) {
            int l = vertexLabels[i];
            int p = this.parentCounts[i];
            pairs.add(new InvariantIntIntPair(l, p, i));
        }
        Collections.sort(pairs);
        if (pairs.size() == 0) {
            return;
        }
        this.nodeComparator = new NodeIntegerLabelComparator(vertexLabels);
        int order = 1;
        InvariantIntIntPair first = (InvariantIntIntPair)pairs.get(0);
        this.invariants.setVertexInvariant(first.getOriginalIndex(), order);
        for (int i = 1; i < pairs.size(); ++i) {
            InvariantIntIntPair b;
            InvariantIntIntPair a = (InvariantIntIntPair)pairs.get(i - 1);
            if (!a.equals(b = (InvariantIntIntPair)pairs.get(i))) {
                ++order;
            }
            this.invariants.setVertexInvariant(b.getOriginalIndex(), order);
        }
    }

    public void setColor(int vertexIndex, int color) {
        this.invariants.setColor(vertexIndex, color);
    }

    public int occurences(int vertexIndex) {
        int count = 0;
        for (Node node : this.nodes) {
            if (node.vertexIndex != vertexIndex) continue;
            ++count;
        }
        return count;
    }

    public void setInvariants(Invariants invariants) {
        this.invariants.colors = (int[])invariants.colors.clone();
        this.invariants.nodeInvariants = (int[])invariants.nodeInvariants.clone();
        this.invariants.vertexInvariants = (int[])invariants.vertexInvariants.clone();
    }

    public Node makeNode(int vertexIndex, int layer) {
        Node node = new Node(vertexIndex, layer);
        this.nodes.add(node);
        return node;
    }

    public Node makeNodeInLayer(int vertexIndex, int layer) {
        Node node = this.makeNode(vertexIndex, layer);
        if (this.layers.size() <= layer) {
            this.layers.add(new ArrayList());
        }
        this.layers.get(layer).add(node);
        return node;
    }

    public void addRelation(Node childNode, Node parentNode) {
        childNode.parents.add(parentNode);
        int n = childNode.vertexIndex;
        this.parentCounts[n] = this.parentCounts[n] + 1;
        int n2 = parentNode.vertexIndex;
        this.childCounts[n2] = this.childCounts[n2] + 1;
        parentNode.children.add(childNode);
    }

    public int[] getParentsInFinalString() {
        int[] counts = new int[this.vertexCount];
        this.getParentsInFinalString(counts, this.getRoot(), null, new ArrayList<Arc>());
        return counts;
    }

    private void getParentsInFinalString(int[] counts, Node node, Node parent, List<Arc> arcs) {
        if (parent != null) {
            int n = node.vertexIndex;
            counts[n] = counts[n] + 1;
        }
        Collections.sort(node.children, this.nodeComparator);
        for (Node child : node.children) {
            Arc arc = new Arc(node.vertexIndex, child.vertexIndex);
            if (arcs.contains(arc)) continue;
            arcs.add(arc);
            this.getParentsInFinalString(counts, child, node, arcs);
        }
    }

    public int[] getOccurrences() {
        int[] occurences = new int[this.vertexCount];
        this.getOccurences(occurences, this.getRoot(), null, new ArrayList<Arc>());
        return occurences;
    }

    private void getOccurences(int[] occurences, Node node, Node parent, List<Arc> arcs) {
        int n = node.vertexIndex;
        occurences[n] = occurences[n] + 1;
        Collections.sort(node.children, this.nodeComparator);
        for (Node child : node.children) {
            Arc arc = new Arc(node.vertexIndex, child.vertexIndex);
            if (arcs.contains(arc)) continue;
            arcs.add(arc);
            this.getOccurences(occurences, child, node, arcs);
        }
    }

    public List<InvariantInt> getInvariantPairs(int[] parents) {
        ArrayList<InvariantInt> pairs = new ArrayList<InvariantInt>();
        for (int i = 0; i < this.vertexCount; ++i) {
            if (this.invariants.getColor(i) != -1 || parents[i] < 2) continue;
            pairs.add(new InvariantInt(this.invariants.getVertexInvariant(i), i));
        }
        Collections.sort(pairs);
        return pairs;
    }

    public int colorFor(int vertexIndex) {
        return this.invariants.getColor(vertexIndex);
    }

    public void accept(DAGVisitor visitor) {
        this.getRoot().accept(visitor);
    }

    public void addLayer(List<Node> layer) {
        this.layers.add(layer);
    }

    public List<Integer> createOrbit(int[] parents) {
        HashMap orbits = new HashMap();
        for (int j = 0; j < this.vertexCount; ++j) {
            List<Integer> orbit;
            if (parents[j] < 2) continue;
            int invariant = this.invariants.getVertexInvariant(j);
            if (orbits.containsKey(invariant)) {
                orbit = (List)orbits.get(invariant);
            } else {
                orbit = new ArrayList();
                orbits.put(invariant, orbit);
            }
            orbit.add(j);
        }
        if (orbits.isEmpty()) {
            return new ArrayList<Integer>();
        }
        List maxOrbit = null;
        ArrayList invariants = new ArrayList(orbits.keySet());
        Collections.sort(invariants);
        Iterator i$ = invariants.iterator();
        while (i$.hasNext()) {
            int invariant = (Integer)i$.next();
            List orbit = (List)orbits.get(invariant);
            if (maxOrbit != null && orbit.size() <= maxOrbit.size()) continue;
            maxOrbit = orbit;
        }
        return maxOrbit;
    }

    public void computeVertexInvariants() {
        HashMap<Integer, int[]> layerInvariants = new HashMap<Integer, int[]>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            int[] layerInvariantsJ;
            Node node = this.nodes.get(i);
            int j = node.vertexIndex;
            if (layerInvariants.containsKey(j)) {
                layerInvariantsJ = (int[])layerInvariants.get(j);
            } else {
                layerInvariantsJ = new int[this.layers.size()];
                layerInvariants.put(j, layerInvariantsJ);
            }
            layerInvariantsJ[node.layer] = this.invariants.getNodeInvariant(i);
        }
        ArrayList<InvariantArray> invariantLists = new ArrayList<InvariantArray>();
        Iterator i$ = layerInvariants.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            InvariantArray invArr = new InvariantArray((int[])layerInvariants.get(i), i);
            invariantLists.add(invArr);
        }
        Collections.sort(invariantLists);
        int order = 1;
        int first = ((InvariantArray)invariantLists.get((int)0)).originalIndex;
        this.invariants.setVertexInvariant(first, 1);
        for (int i = 1; i < invariantLists.size(); ++i) {
            InvariantArray b;
            InvariantArray a = (InvariantArray)invariantLists.get(i - 1);
            if (!a.equals(b = (InvariantArray)invariantLists.get(i))) {
                ++order;
            }
            this.invariants.setVertexInvariant(b.originalIndex, order);
        }
    }

    public void updateVertexInvariants() {
        int[] oldInvariants = new int[this.vertexCount];
        boolean invariantSame = true;
        while (invariantSame) {
            oldInvariants = this.invariants.getVertexInvariantCopy();
            this.updateNodeInvariants(Direction.UP);
            this.computeVertexInvariants();
            this.updateNodeInvariants(Direction.DOWN);
            this.computeVertexInvariants();
            invariantSame = this.checkInvariantChange(oldInvariants, this.invariants.getVertexInvariants());
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.nodes.get((int)i).invariant = this.invariants.getNodeInvariant(i);
        }
    }

    public boolean checkInvariantChange(int[] a, int[] b) {
        for (int i = 0; i < this.vertexCount; ++i) {
            if (a[i] == b[i]) continue;
            return true;
        }
        return false;
    }

    public void updateNodeInvariants(Direction direction) {
        int increment;
        int end;
        int start;
        if (direction == Direction.UP) {
            start = this.layers.size() - 1;
            end = -1;
            increment = -1;
        } else {
            start = 0;
            end = this.layers.size();
            increment = 1;
        }
        for (int i = start; i != end; i += increment) {
            this.updateLayer(this.layers.get(i), direction);
        }
    }

    public void updateLayer(List<Node> layer, Direction direction) {
        ArrayList<InvariantList> nodeInvariantList = new ArrayList<InvariantList>();
        for (int i = 0; i < layer.size(); ++i) {
            Node layerNode = layer.get(i);
            int x = layerNode.vertexIndex;
            InvariantList nodeInvariant = new InvariantList(this.nodes.indexOf(layerNode));
            nodeInvariant.add(this.invariants.getColor(x));
            nodeInvariant.add(this.invariants.getVertexInvariant(x));
            ArrayList<Integer> relativeInvariants = new ArrayList<Integer>();
            List<Node> relatives = direction == Direction.UP ? layerNode.children : layerNode.parents;
            for (Node relative : relatives) {
                int j = this.nodes.indexOf(relative);
                int inv = this.invariants.getNodeInvariant(j);
                int edgeColor = direction == Direction.UP ? relative.edgeColors.get(layerNode.vertexIndex).intValue() : layerNode.edgeColors.get(relative.vertexIndex).intValue();
                relativeInvariants.add(inv);
                relativeInvariants.add(this.vertexCount + 1 + edgeColor);
            }
            Collections.sort(relativeInvariants);
            nodeInvariant.addAll(relativeInvariants);
            nodeInvariantList.add(nodeInvariant);
        }
        Collections.sort(nodeInvariantList);
        int order = 1;
        int first = ((InvariantList)nodeInvariantList.get((int)0)).originalIndex;
        this.invariants.setNodeInvariant(first, order);
        for (int i = 1; i < nodeInvariantList.size(); ++i) {
            InvariantList b;
            InvariantList a = (InvariantList)nodeInvariantList.get(i - 1);
            if (!a.equals(b = (InvariantList)nodeInvariantList.get(i))) {
                ++order;
            }
            this.invariants.setNodeInvariant(b.originalIndex, order);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (List<Node> layer : this) {
            buffer.append(layer);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NodeIntegerLabelComparator
    implements Comparator<Node> {
        public int[] vertexLabels;

        public NodeIntegerLabelComparator(int[] vertexLabels) {
            this.vertexLabels = vertexLabels;
        }

        @Override
        public int compare(Node o1, Node o2) {
            int c;
            int o1n = this.vertexLabels[o1.vertexIndex];
            int o2n = this.vertexLabels[o2.vertexIndex];
            int n = o1n == o2n ? 0 : (c = o1n < o2n ? -1 : 1);
            if (c == 0) {
                if (o1.invariant < o2.invariant) {
                    return -1;
                }
                if (o1.invariant > o2.invariant) {
                    return 1;
                }
                return 0;
            }
            return c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NodeStringLabelComparator
    implements Comparator<Node> {
        public String[] vertexLabels;

        public NodeStringLabelComparator(String[] vertexLabels) {
            this.vertexLabels = vertexLabels;
        }

        @Override
        public int compare(Node o1, Node o2) {
            String o1s = this.vertexLabels[o1.vertexIndex];
            String o2s = this.vertexLabels[o2.vertexIndex];
            int c = o1s.compareTo(o2s);
            if (c == 0) {
                if (o1.invariant < o2.invariant) {
                    return -1;
                }
                if (o1.invariant > o2.invariant) {
                    return 1;
                }
                return 0;
            }
            return c;
        }
    }

    public class Arc {
        public final int a;
        public final int b;

        public Arc(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object other) {
            if (other instanceof Arc) {
                Arc o = (Arc)other;
                return this.a == o.a && this.b == o.b || this.a == o.b && this.b == o.a;
            }
            return false;
        }
    }

    public class Node
    implements VisitableDAG {
        public final int vertexIndex;
        public final List<Node> parents;
        public final List<Node> children;
        public final int layer;
        public final Map<Integer, Integer> edgeColors;
        public int invariant;

        public Node(int vertexIndex, int layer) {
            this.vertexIndex = vertexIndex;
            this.layer = layer;
            this.parents = new ArrayList<Node>();
            this.children = new ArrayList<Node>();
            this.edgeColors = new HashMap<Integer, Integer>();
        }

        public void addParent(Node node) {
            this.parents.add(node);
        }

        public void addChild(Node node) {
            this.children.add(node);
        }

        public void addEdgeColor(int partnerIndex, int edgeColor) {
            this.edgeColors.put(partnerIndex, edgeColor);
        }

        public void accept(DAGVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            StringBuffer parentString = new StringBuffer();
            parentString.append('[');
            for (Node parent : this.parents) {
                parentString.append(parent.vertexIndex).append(',');
            }
            if (parentString.length() > 1) {
                parentString.setCharAt(parentString.length() - 1, ']');
            } else {
                parentString.append(']');
            }
            StringBuffer childString = new StringBuffer();
            childString.append('[');
            for (Node child : this.children) {
                childString.append(child.vertexIndex).append(',');
            }
            if (childString.length() > 1) {
                childString.setCharAt(childString.length() - 1, ']');
            } else {
                childString.append(']');
            }
            return this.vertexIndex + " " + " (" + parentString + ", " + childString + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        DOWN;

    }
}

