/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

class MolReader
extends AtomSetCollectionReader {
    String header = "";

    MolReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("mol");
        this.reader = reader;
        boolean iHaveAtoms = false;
        try {
            while (this.readLine() != null) {
                if (this.line.startsWith("$MDL")) {
                    this.processRgHeader();
                    this.discardLinesUntilStartsWith("$CTAB");
                    this.processCtab();
                } else {
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                        if (!iHaveAtoms) {
                            this.flushLines();
                            continue;
                        }
                        break;
                    }
                    iHaveAtoms = true;
                    this.processMolSdHeader();
                    this.processCtab();
                }
                this.flushLines();
            }
        }
        catch (Exception ex) {
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
        }
        return this.atomSetCollection;
    }

    void processMolSdHeader() throws Exception {
        String thisDataSetName = this.line;
        this.header = this.header + this.line + "\n";
        this.atomSetCollection.setCollectionName(this.line);
        this.readLine();
        if (this.line == null) {
            return;
        }
        this.header = this.header + this.line + "\n";
        this.readLine();
        if (this.line == null) {
            return;
        }
        this.header = this.header + this.line + "\n";
        this.checkLineForScript();
        this.atomSetCollection.setAtomSetCollectionProperty("fileHeader", this.header);
        this.newAtomSet(thisDataSetName);
    }

    void processRgHeader() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$HDR")) {
        }
        if (this.line == null) {
            this.logger.log("$HDR not found in MDL RG file");
            return;
        }
        this.readLine();
        this.processMolSdHeader();
    }

    void processCtab() throws Exception {
        this.readLine();
        if (this.line == null) {
            return;
        }
        int atomCount = this.parseInt(this.line, 0, 3);
        int bondCount = this.parseInt(this.line, 3, 6);
        int atom0 = this.atomSetCollection.atomCount;
        this.readAtoms(atomCount);
        this.readBonds(atom0, bondCount);
        this.applySymmetry();
    }

    void flushLines() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$")) {
        }
    }

    void readAtoms(int atomCount) throws Exception {
        for (int i = 0; i < atomCount; ++i) {
            int chargeCode;
            this.readLine();
            String elementSymbol = "";
            elementSymbol = this.line.length() > 34 ? this.line.substring(31, 34).trim().intern() : this.line.substring(31).trim().intern();
            float x = this.parseFloat(this.line, 0, 10);
            float y = this.parseFloat(this.line, 10, 20);
            float z = this.parseFloat(this.line, 20, 30);
            int charge = 0;
            if (this.line.length() >= 39 && (chargeCode = this.parseInt(this.line, 36, 39)) >= 1 && chargeCode <= 7) {
                charge = 4 - chargeCode;
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.formalCharge = charge;
            this.setAtomCoord(atom, x, y, z);
        }
    }

    void readBonds(int atom0, int bondCount) throws Exception {
        for (int i = 0; i < bondCount; ++i) {
            this.readLine();
            int atomIndex1 = this.parseInt(this.line, 0, 3);
            int atomIndex2 = this.parseInt(this.line, 3, 6);
            int order = this.parseInt(this.line, 6, 9);
            if (order == 4) {
                order = 4;
            }
            this.atomSetCollection.addBond(new Bond(atom0 + atomIndex1 - 1, atom0 + atomIndex2 - 1, order));
        }
    }
}

