/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;
import org.openscience.cdk.applications.jchempaint.action.SaveAsAction;
import org.openscience.cdk.applications.jchempaint.io.JCPFileFilter;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;

public class SaveAction
extends SaveAsAction {
    private static final long serialVersionUID = -6748046051686998776L;

    public SaveAction() {
    }

    public SaveAction(JChemPaintPanel jcpPanel, boolean isPopupAction) {
        super(jcpPanel, isPopupAction);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.jcpPanel.isAlreadyAFile() == null) {
            new SaveAsAction(this.jcpPanel, false).actionPerformed(event);
        } else {
            try {
                IChemModel model = this.jcpPanel.getJChemPaintModel().getChemModel();
                File outFile = this.jcpPanel.isAlreadyAFile();
                type = JCPFileFilter.getExtension(outFile);
                if (type.equals("mol")) {
                    this.saveAsMol(model, outFile);
                } else if (type.equals("cml")) {
                    this.saveAsCML2((IChemObject)model, outFile);
                } else if (type.equals("smiles")) {
                    this.saveAsSMILES(model, outFile);
                } else if (type.equals("svg")) {
                    this.saveAsSVG(model, outFile);
                } else if (type.equals("cdk")) {
                    this.saveAsCDKSourceCode(model, outFile);
                } else {
                    String error = "Cannot save file in this format: " + type;
                    logger.error((Object)error);
                    JOptionPane.showMessageDialog(this.jcpPanel, error);
                    return;
                }
                this.jcpPanel.getJChemPaintModel().resetIsModified();
            }
            catch (Exception ex) {
                String error = "Error while writing file: " + ex.getMessage();
                logger.error((Object)error);
                logger.debug((Object)ex);
                JOptionPane.showMessageDialog(this.jcpPanel, error);
            }
        }
    }
}

