/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.dialogs.ChemObjectPropertyDialog;
import org.openscience.cdk.applications.swing.editor.AtomEditor;
import org.openscience.cdk.applications.swing.editor.BondEditor;
import org.openscience.cdk.applications.swing.editor.ChemObjectEditor;
import org.openscience.cdk.applications.swing.editor.PseudoAtomEditor;
import org.openscience.cdk.applications.swing.editor.ReactionEditor;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;

public class EditChemObjectPropsAction
extends JCPAction {
    private static final long serialVersionUID = 7123137508085454087L;

    public void actionPerformed(ActionEvent event) {
        if (this.jcpPanel.getJChemPaintModel() != null) {
            JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
            IChemObject object = this.getSource(event);
            logger.debug((Object)"Showing object properties for: ", (Object)object);
            PseudoAtomEditor editor = null;
            if (object instanceof PseudoAtom) {
                editor = new PseudoAtomEditor();
            } else if (object instanceof Atom) {
                editor = new AtomEditor();
            } else if (object instanceof Reaction) {
                editor = new ReactionEditor();
            } else if (object instanceof IBond) {
                editor = new BondEditor();
            }
            if (editor != null) {
                editor.setChemObject((IChemObject)((ChemObject)object));
                ChemObjectPropertyDialog frame = new ChemObjectPropertyDialog(jcpmodel, (ChemObjectEditor)editor);
                frame.pack();
                frame.show();
            }
        }
    }
}

