% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sectors_segmentation.R
\name{sectors_segmentation}
\alias{sectors_segmentation}
\title{Do sectors segmentation}
\usage{
sectors_segmentation(a, angle_width, return_angle = FALSE)
}
\arguments{
\item{a}{\linkS4class{SpatRaster} built with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{angle_width}{Numeric vector of length one. Angle in degrees able to
divide the angle range into a whole number of segments.}

\item{return_angle}{Logical vector of length one. If it is \code{FALSE}, all
the pixels that belong to a segment are labeled with an ID number.
Otherwise, the angle mean of the segment is assigned to the pixels.}
}
\value{
An object from the class \linkS4class{SpatRaster} with segments
shaped like pizza slices.
}
\description{
Segment a hemispherical view by slicing the azimuth angle from zero
to 360º in equals intervals.
}
\examples{
z <- zenith_image(600, lens())
a <- azimuth_image(z)
sectors <- sectors_segmentation(a, 15)
plot(sectors == 1)
}
\seealso{
Other Segmentation Functions: 
\code{\link{chessboard}()},
\code{\link{mask_hs}()},
\code{\link{mask_sunlit_canopy}()},
\code{\link{polar_qtree}()},
\code{\link{qtree}()},
\code{\link{rings_segmentation}()},
\code{\link{sky_grid_segmentation}()}
}
\concept{Segmentation Functions}
