% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataclasses.R
\name{sample_single}
\alias{sample_single}
\title{Create object of \code{sample_single} class}
\usage{
sample_single(
  ids,
  beta = NA,
  sigma = NA,
  theta = NA,
  failed = any(is.na(beta)),
  ids_samp = ids
)
}
\arguments{
\item{ids}{Vector of characters containing the ids of the subjects included in the original dataset.}

\item{beta}{Numeric vector of estimated regression coefficients.}

\item{sigma}{List of estimated covariance matrices (one for each level of \code{vars$group}).}

\item{theta}{Numeric vector of transformed covariances.}

\item{failed}{Logical. \code{TRUE} if the model fit failed.}

\item{ids_samp}{Vector of characters containing the ids of the subjects included in the given sample.}
}
\value{
A named list of class \code{sample_single}. It contains the following:
\itemize{
\item \code{ids} vector of characters containing the ids of the subjects included in the original dataset.
\item \code{beta} numeric vector of estimated regression coefficients.
\item \code{sigma} list of estimated covariance matrices (one for each level of \code{vars$group}).
\item \code{theta} numeric vector of transformed covariances.
\item \code{failed} logical. \code{TRUE} if the model fit failed.
\item \code{ids_samp} vector of characters containing the ids of the subjects included in the given sample.
}
}
\description{
Creates an object of class \code{sample_single} which is a named list
containing the input parameters and validate them.
}
