#[derive(Clone, Copy, Debug, Eq, PartialEq)]
pub enum Lang {
	Ara,
	Cmn,
	Deu,
	Eng,
	Fra,
	Hin,
	Ita,
	Jpn,
	Kor,
	Nld,
	Por,
	Rus,
	Spa,
	Swe,
	Tur,
	Vie,
}


impl Lang {
    pub fn three_letter_code(self)-> &'static str {
        match self {
			Lang::Ara => "ara",
			Lang::Cmn => "cmn",
			Lang::Deu => "deu",
			Lang::Eng => "eng",
			Lang::Fra => "fra",
			Lang::Hin => "hin",
			Lang::Ita => "ita",
			Lang::Jpn => "jpn",
			Lang::Kor => "kor",
			Lang::Nld => "nld",
			Lang::Por => "por",
			Lang::Rus => "rus",
			Lang::Spa => "spa",
			Lang::Swe => "swe",
			Lang::Tur => "tur",
			Lang::Vie => "vie",
		}	}
}


pub const LANGUAGES: [Lang; 16] = [
	Lang::Ara, Lang::Cmn, Lang::Deu, Lang::Eng, Lang::Fra, Lang::Hin, Lang::Ita, Lang::Jpn, Lang::Kor, Lang::Nld, Lang::Por, Lang::Rus, Lang::Spa, Lang::Swe, Lang::Tur, Lang::Vie, ];

pub const WEIGHTS: [f32; 65536] = [
	-0.004738, -0.002283, -0.536394, 0.588218, -0.103133, -0.000536, -2.135800, -0.002866, -0.001199, -0.364569, -0.339155, -0.000544, 0.838150, 1.530471, 0.564755, -0.030377, 
	-0.217440, -0.024371, -1.002733, -2.551400, 0.423398, -0.005288, -0.547941, -0.061095, -0.016818, 2.178775, 2.383309, -0.005639, -1.539094, 0.968187, -0.084521, 0.102674, 
	-0.027929, -0.005154, -0.754897, -0.622250, 1.488355, -0.000897, 1.431854, -0.012952, -0.003208, -0.661397, 1.654986, -0.001019, -2.685460, 0.016522, 0.274130, -0.090683, 
	-0.059851, -0.021808, -2.188168, -2.741032, 3.433206, -0.006669, 2.669606, -0.027827, -0.014656, -3.189003, 3.815695, -0.006951, -3.200279, 3.005974, -1.362448, -0.105789, 
	-0.009084, -0.006918, 1.349991, -0.514524, -0.554165, -0.002180, 3.123214, -0.009876, -0.004902, 0.197617, -0.777542, -0.002586, -3.914151, -1.091472, 2.254877, -0.038298, 
	-0.053672, -0.021499, -3.405199, 0.042621, 1.027741, -0.006237, 0.469703, -0.029770, -0.014187, -2.112178, -1.043548, -0.006643, -0.241161, 3.330174, 2.273864, -0.210008, 
	-0.002240, -0.001652, 5.009315, 0.249283, -0.304959, -0.000608, -1.059998, -0.002229, -0.001315, -2.297369, 0.988049, -0.000654, -1.859120, -0.375495, -0.331068, -0.009941, 
	-0.023031, -0.009616, -1.949751, -2.250495, -0.731024, -0.003967, 2.943336, -0.012742, -0.006612, 0.756470, -1.860265, -0.133538, 3.190918, 0.712061, -0.469275, -0.152468, 
	-0.005734, -0.004559, -2.896732, -1.205479, 0.116740, -0.000940, 1.580867, -0.005881, -0.002687, 4.639816, 1.868465, -0.001040, -4.452545, 1.044096, -0.566621, -0.107768, 
	-0.022355, -0.006643, -0.297402, 1.792260, -0.165594, -0.002209, -0.155995, -0.009541, -0.004729, 2.175042, 0.799918, -0.002195, -2.593727, -0.454337, -1.046618, -0.005873, 
	-0.005924, -0.002097, -0.305265, 0.735963, 2.386515, -0.000860, -1.064819, -0.002977, -0.001652, -0.968092, -0.815193, -0.000924, -0.491095, 0.898325, -0.268887, -0.093018, 
	-0.012262, -0.004665, 0.327073, -1.736164, -0.191133, -0.001093, -0.472050, -0.007061, -0.000421, 2.779409, 0.529953, -0.001203, 0.673683, -0.943592, -0.791564, -0.148908, 
	-0.009803, -0.005626, 0.166783, -1.641844, 1.594910, -0.001663, -0.719171, -0.013021, -0.003453, -0.540977, 0.567200, -0.001783, -0.086983, 0.056645, 0.695333, -0.056546, 
	-0.006488, -0.006524, 2.810956, 0.552291, -1.525909, -0.002556, 0.854191, -0.007075, -0.004558, -0.275558, -2.212266, -0.002796, 0.732392, -1.655390, 0.795480, -0.046191, 
	-0.016542, -0.005360, 5.935653, -0.110753, 0.101055, -0.001513, -0.503118, -0.006748, -0.003355, -2.341468, 0.176359, -0.001624, -1.095420, -1.203371, -0.887890, -0.035903, 
	-0.046567, -0.004711, -0.041183, -1.015541, -0.441045, -0.001052, 2.884974, -0.005201, -0.002722, -0.342572, 3.053029, -0.001170, -3.241714, -0.430442, -0.291200, -0.072883, 
	-0.102723, -0.048956, 2.542482, -0.830775, -1.856011, -0.016243, 0.997757, -0.063544, -0.033242, -1.459703, 3.662018, -0.021702, 0.746929, -3.842723, 0.655183, -0.328747, 
	-0.013795, -0.004798, 3.072814, -0.104907, -1.811822, -0.001621, -0.422489, -0.013410, -0.003922, -2.470334, 3.342627, -0.001745, -2.620730, 1.906744, -0.824201, -0.028411, 
	-0.021595, -0.020691, 0.062963, -2.240222, -4.551283, -0.004788, 2.552086, -0.015458, -0.010409, 0.876192, 3.451613, -0.004933, -1.117007, 0.022379, 1.264484, -0.243330, 
	-0.004259, -0.003538, -0.184080, -0.279928, -0.688498, -0.001173, 0.393083, -0.002527, -0.001787, 0.643261, -0.609785, -0.001181, -1.420253, -0.435979, 2.623044, -0.026400, 
	-0.007918, -0.001426, 0.026781, -0.485152, -1.083933, -0.000996, -0.226261, -0.020552, -0.002297, 1.909611, -0.127296, -0.001073, -0.747496, -0.383457, 1.161937, -0.010474, 
	-0.006229, -5.166190, -1.510739, 7.843135, 0.027457, -0.002856, 1.071624, 5.378653, -0.004414, -3.649280, -2.366214, -0.002934, -2.737585, 0.864837, 0.440597, -0.179862, 
	-0.091961, -0.020553, 0.419343, 3.194992, 2.998963, -0.005131, -0.537567, -0.025392, -0.013889, -4.514828, -0.218891, -0.005458, -0.992144, -1.364379, 1.333771, -0.156875, 
	-0.010830, -0.008545, -0.508426, -0.736678, 0.297421, -0.002416, 2.856663, -0.024662, -0.005121, -0.190153, -5.092726, -0.002524, 2.878217, 0.815718, -0.051977, -0.213961, 
	-0.021358, -0.016391, -1.233729, 3.726138, -3.865244, -0.004206, -3.109074, -0.017533, -0.009199, 2.599301, 2.566201, -0.004430, 1.949604, -0.254874, -2.120103, -0.185101, 
	-0.189302, -0.068499, -2.780924, -3.714510, 7.104244, -0.023577, 1.468049, -0.135211, 0.241151, -0.445162, -4.885441, -0.024515, 2.574845, 1.162442, -0.550880, 0.267289, 
	-0.010635, -0.006498, 0.919163, -0.129309, 0.931932, -0.001750, -1.397151, -0.007563, -0.003826, 1.405220, 0.413244, -0.001890, -1.452072, -0.274159, -1.011154, 0.626448, 
	-0.004223, -0.003516, 5.099502, -3.349086, 0.021912, -0.001623, -0.425196, -0.004749, -0.002511, -0.830091, -1.040140, -0.001642, -0.224179, -0.390955, 1.206104, -0.049607, 
	-0.016648, -0.004820, 0.810551, -0.317700, 0.427346, -0.001369, -1.439537, -0.004580, -0.003051, 0.391593, 0.379357, -0.001506, -3.277215, 0.001322, 1.820575, 1.235682, 
	-0.002351, -0.004246, 0.460427, -4.137918, -0.351622, -0.000879, -0.858417, -0.007085, -0.002931, 4.440261, -0.825201, -0.001035, 0.811318, 0.599573, -0.091679, -0.028216, 
	-0.060432, 0.159147, -0.822793, 12.951859, -1.037237, -0.008903, -2.663783, -0.126232, -0.020468, -3.712470, -1.000780, -0.143160, 1.422985, -3.666974, -1.193405, -0.077354, 
	-0.006031, -0.002570, -0.676425, 0.522765, 0.611874, -0.000972, 0.552380, -0.006439, -0.001939, 0.652360, -0.091959, -0.001034, -1.232188, 0.340959, -0.506905, -0.153875, 
	-0.005507, -0.002609, -0.239476, 2.909955, -0.194310, -0.001130, -1.761647, -0.003031, -0.001993, 1.072602, 1.432113, -0.001184, -1.556118, -0.503994, -1.109674, -0.033994, 
	-0.050204, -0.026804, -0.476244, 0.942414, 4.409197, -0.009095, -3.462564, -0.040343, -0.019693, -1.534854, 2.938529, -0.009709, 1.611481, -2.462442, -0.901446, -0.908223, 
	-0.003562, -0.003138, -1.168002, 0.767117, -2.334633, -0.001188, 0.115979, -0.021962, -0.002560, -0.212045, -1.244519, -0.001303, 1.539165, 1.592481, 1.014847, -0.036676, 
	-0.055696, -0.007975, -0.337025, -0.885109, 0.782583, -0.002889, -1.987791, -0.010767, -0.005006, -1.028999, -1.583451, -0.002908, 4.500371, -0.518327, -0.542306, 1.685296, 
	-0.006794, -0.009415, -1.194933, 0.903831, -0.545522, -0.001242, -0.644138, -0.024279, -0.005478, -1.879933, 2.725626, -0.001546, -0.565713, 0.572837, 0.705467, -0.028767, 
	-0.067205, -0.033371, -1.548872, -1.604706, 3.363726, -0.006094, 3.105423, -0.036226, -0.013675, 3.090308, 2.870492, -0.006618, -3.210948, -2.985893, -2.150141, -0.766202, 
	-0.109484, 1.807450, 0.282513, -1.009327, -0.266083, -0.003009, 1.212321, -1.772833, -0.005095, -0.397060, 2.787405, -0.003087, -2.219360, -0.080122, -0.172119, -0.052110, 
	-0.012840, -0.004614, 3.300700, -0.247817, -1.810022, -0.002578, -1.814419, -0.033280, -0.004246, -0.323703, 2.782472, -0.002659, -1.539644, -1.526506, 1.346767, -0.107611, 
	-0.256476, -0.084127, 1.130861, -3.804801, 14.896765, -0.013121, 2.086102, -0.113981, -0.038946, 0.102678, -0.832399, -0.143800, -8.079488, -1.227319, -2.873815, -0.748133, 
	-0.091596, -0.027884, 1.268331, 2.108810, 1.109847, -0.007461, 2.097447, -0.054492, -0.019301, -0.577690, -0.482372, -0.007742, -2.168894, -0.005448, -2.811509, -0.330048, 
	-0.097750, -0.035320, 3.190572, 0.960497, -2.621569, -0.005371, -1.001992, -0.032459, -0.015715, -1.943381, 2.649427, -0.006107, 0.867226, -0.764497, -0.792120, -0.351440, 
	-0.010625, -0.007117, 0.509840, -1.327300, 2.131350, -0.001414, -0.639525, -0.006024, -0.003430, -0.969417, 4.068422, -0.001543, -2.586228, -1.367018, 0.251514, -0.041487, 
	-0.080092, -0.043549, -0.770147, 1.577965, -3.853362, -0.014967, -0.663480, -0.061163, -0.028903, -0.582746, -0.680088, -0.144963, 3.583721, -0.808513, 3.175023, -0.604736, 
	-0.019796, -0.020285, 0.466880, -0.151090, 0.174270, -0.003915, -3.581146, -0.022448, -0.010966, 7.140763, 0.395395, -0.003964, -4.365841, -0.743782, 0.845924, -0.099998, 
	-0.024806, -0.009578, 1.220150, 1.135045, 0.873266, -0.001736, 1.297305, -0.008952, -0.005123, -1.060076, -0.575642, -0.001882, -3.098275, 0.489172, -0.183253, -0.045614, 
	-0.055858, -0.033432, -1.491468, -0.783957, -0.402138, -0.005044, -0.657331, -0.047236, -0.026855, 1.625125, 0.313977, -0.005823, -3.365440, 3.026510, 2.063190, -0.154218, 
	-0.002025, -0.001818, -0.239986, -0.285917, -0.111552, -0.000476, 0.962576, -0.002583, -0.001411, 1.197032, -0.636506, -0.000589, -0.235815, -0.220963, -0.412027, -0.007940, 
	-0.023684, -0.013023, -1.323319, -0.926246, -1.638487, -0.003233, 2.052185, -0.013833, -0.007065, 2.046531, 2.163804, -0.003235, -0.042886, -2.366704, 0.257158, -0.157963, 
	-0.009749, -0.009023, 1.753856, 2.286242, -0.165618, -0.001750, -1.792372, -0.015724, -0.005550, 0.174841, 0.429820, -0.002703, -1.059712, -0.912400, -0.619241, -0.050917, 
	-0.023699, -0.008852, -3.970186, 6.583955, -2.316146, -0.003185, -2.291767, -0.008242, -0.005400, 1.155493, -2.092090, -0.003230, 3.974797, 0.210191, -1.059566, -0.142074, 
	-0.012569, -0.005550, -2.037070, -0.380019, -0.514585, -0.001476, -2.162633, -0.003755, -0.002784, 5.000736, 2.102860, -0.001605, -0.575625, -0.660955, -0.722830, -0.022139, 
	-0.011528, -0.003708, -0.874811, -0.508374, 0.810737, -0.001258, -2.773607, -0.012663, -0.002969, -1.416275, -1.853357, -0.001431, 3.143359, 2.881534, 0.638633, -0.014282, 
	-0.008468, -0.004866, -1.047388, 1.998670, -0.942226, -0.001438, 0.428480, -0.011571, -0.003549, -1.004710, -1.207584, -0.001588, 0.849718, 1.895105, -0.892043, -0.046542, 
	-0.269410, -0.114318, -2.291114, -0.456257, -7.708698, -0.199110, -4.933687, -0.120183, -0.092283, 0.652854, -1.860842, -0.197281, -1.053612, 1.353404, -4.157226, 21.447762, 
	-0.007460, -0.004285, 0.577074, -1.365298, -0.176556, -0.001520, -1.092104, -0.003342, -0.002615, 3.729230, -0.732878, -0.001557, 0.215438, -0.195582, -0.908047, -0.030497, 
	-0.169477, -0.089075, 0.298980, -0.691595, 5.466862, -0.022853, -5.277117, -0.168710, -0.055171, 1.052492, 1.303511, -0.024176, -1.781663, 1.665685, -0.649254, -0.858437, 
	-0.017699, -0.007144, 0.257109, 0.466818, 2.292586, -0.002260, 1.454027, -0.008987, -0.004656, -0.167533, 7.670435, -0.002383, -10.939933, -1.044635, 0.120857, -0.066602, 
	-0.026317, -0.003936, -1.024314, 1.373977, 0.613784, -0.001522, -0.542509, -0.004671, -0.002477, -0.141997, -0.798973, -0.005992, 1.131745, -0.197577, -0.338472, -0.030749, 
	-0.005802, -0.005468, -0.258675, 2.856612, -0.228912, -0.002435, 1.186511, -0.018252, -0.004525, -0.872304, -3.324491, -0.002418, -1.567033, 1.062792, 1.269351, -0.084950, 
	-0.013375, -0.008491, -0.187517, 0.297748, -1.250880, -0.001487, -0.903207, -0.016019, -0.005489, 2.431119, -0.355183, -0.001593, -1.201588, 2.402579, -1.099620, -0.086996, 
	-0.023493, -0.015451, 3.212150, -0.168684, -4.025758, -0.003806, 5.658455, -0.015698, -0.009022, -0.570070, 1.095755, -0.004073, -3.824118, 0.436838, -1.570810, -0.172215, 
	-0.005205, 0.480513, -0.211959, -1.063002, -1.056853, -0.002024, 3.375841, -0.469797, -0.003808, -0.453101, 0.725474, -0.002044, -1.421311, -0.057745, 0.193294, -0.028273, 
	-0.002703, -0.001781, -0.527592, 0.059041, -0.278771, -0.000319, -0.433111, -0.001342, -0.000921, -0.107131, -0.534771, -0.000336, -0.417644, 1.265883, 0.989225, -0.007726, 
	-0.010470, -0.003971, 0.254755, 3.033476, -0.478317, -0.001460, -3.445170, -0.007243, -0.002821, 2.240286, 2.791953, -0.001519, -2.936213, -0.633381, -0.760637, -0.039269, 
	-0.005348, -0.006233, -0.330853, -1.447011, 1.066707, -0.001043, -0.352082, -0.007102, -0.002824, 0.034648, -0.772832, -0.001107, 0.552654, 1.090855, 0.201462, -0.019890, 
	-0.011843, -0.012011, -0.530331, 2.944815, -0.555524, -0.003112, 1.158615, -0.013013, -0.007091, -1.072758, -0.527089, -0.003553, -0.224705, -0.792877, -0.246515, -0.103008, 
	-0.122541, -0.077016, 2.731543, 0.143151, 3.247381, -0.019595, -0.018277, -0.110700, -0.043119, -3.229869, 1.143290, -0.020943, -6.070735, 1.332938, 2.165204, -1.050712, 
	-0.023403, -0.015730, -2.400729, -3.560493, 6.310248, -0.002722, -5.319736, -0.043189, -0.011258, 0.421611, 1.240774, -0.007493, 4.843179, -0.113755, -1.041028, -0.276275, 
	-0.065131, -0.029392, 2.082156, 2.515127, -3.417261, -0.007734, -0.074591, -0.025245, -0.016060, -1.048154, 2.200532, -0.008005, 0.924869, -2.857077, 0.576222, -0.750256, 
	-0.062633, -0.024647, -1.271290, -1.220944, -1.210740, -0.006975, 3.197335, -0.036564, -0.016766, -0.594257, -0.521067, -0.007546, 4.026709, -3.386950, 1.491236, -0.354900, 
	-0.020045, -0.007228, -1.697986, 1.017681, -1.091449, -0.001531, 0.411344, -0.004938, -0.003298, 0.673134, 1.610599, -0.001639, -1.681463, 1.622434, -0.805015, -0.020601, 
	-0.017457, -0.001608, -0.427349, -0.036687, -0.154601, -0.000631, -1.220481, -0.001899, -0.001284, -0.387126, -1.053981, -0.000654, 4.057720, -0.561124, -0.188813, -0.004028, 
	-0.012326, -0.004473, 0.503791, 0.519382, -0.888740, -0.001007, 0.549328, -0.008131, -0.002550, -0.877131, 0.773837, -0.001079, -2.356447, 0.657117, 1.227305, -0.078877, 
	-0.112803, -0.050048, 1.046863, -0.244710, 1.288846, -0.011521, 2.500403, -0.061148, -0.028716, -1.748437, -1.745856, -0.029948, -2.339534, -1.559507, 2.066493, 1.029623, 
	-0.005704, -0.002242, 0.172726, 0.107230, -1.368682, -0.000625, 1.729842, -0.003562, -0.001476, -0.666918, -3.416947, -0.000671, 3.679271, -0.159717, -0.056678, -0.005844, 
	-0.010472, -0.004307, 0.084942, 0.264219, -1.303872, -0.001023, -0.785666, -0.009344, -0.002805, -0.264886, -1.124646, -0.001133, 3.856616, 0.082001, -0.744642, -0.034983, 
	-0.037969, -0.013394, 0.491381, 0.573773, 2.295542, -0.004257, 0.895827, -0.022946, -0.009436, 0.260345, 0.195404, -0.133908, -1.763395, -1.598249, -1.033971, -0.094747, 
	-0.005522, -0.006519, 1.750364, 0.133734, -2.116325, -0.001209, 0.218328, -0.003613, -0.002185, -1.320743, -6.090168, -0.001269, 6.978644, 0.295211, 0.396699, -0.225427, 
	-0.015547, -0.006728, -0.195020, 0.496845, 0.467662, -0.002756, -3.557204, -0.007801, -0.004844, -0.559500, 8.914365, -0.003172, -5.996032, 0.404530, 0.090547, -0.025345, 
	-0.020381, -0.006678, -0.970898, 0.616976, -0.491121, -0.001763, 0.007193, -0.007948, -0.004184, -0.776003, 1.424245, -0.001870, 1.865495, -0.902880, -0.646504, -0.083679, 
	-0.004386, -0.005153, -0.032046, -1.510284, -0.715555, -0.000700, -1.601377, -0.006721, -0.002409, -0.048738, -5.369340, -0.000776, 9.443852, -0.047626, -0.040860, -0.057879, 
	-0.000747, -0.000696, 0.495091, 0.023515, 0.702441, -0.000425, -0.266628, -0.001233, -0.000606, -0.651927, -0.045595, -0.000435, -0.076391, -0.042807, -0.131108, -0.002449, 
	2.250269, -0.071758, 5.739036, 3.527501, 8.912328, -0.023732, -10.554991, -0.172839, -0.049756, 7.029331, -9.270930, -0.024383, -9.454547, 4.388124, -1.876926, -0.346727, 
	-0.027630, -0.019366, 2.444405, -3.107190, -3.709352, -0.007934, 1.084399, -0.028535, -0.013922, -0.284985, 0.039861, -0.008228, -0.868192, 5.556088, -0.877773, -0.171645, 
	-0.003970, -0.003164, -0.450020, 1.357724, -1.475539, -0.001184, 3.365049, -0.003662, -0.002353, 0.950448, -3.906230, -0.001209, 1.295426, -0.672650, -0.416013, -0.032653, 
	-0.039523, -0.018185, -1.856372, 4.571500, 0.006505, -0.005045, 0.711532, -0.028456, -0.010958, 1.398996, -3.466598, -0.005341, 1.028321, -1.287529, -0.332032, -0.666816, 
	-0.168193, 0.986040, -1.317840, 0.894805, 0.596714, -0.036049, -4.437285, -0.072977, -0.058791, 0.253201, -0.476542, -0.037151, 4.981494, -2.250721, 0.823911, 0.319384, 
	-0.010340, -0.014032, -1.762625, 1.135822, -0.937545, -0.002132, 1.025066, -0.015268, -0.006576, -1.710098, 0.380058, -0.002446, 0.180641, 1.045799, 0.847920, -0.154244, 
	-0.013458, -0.009101, 0.261232, -2.818933, 0.324017, -0.001799, 2.586010, -0.007893, -0.004959, -0.965294, 2.023189, -0.002005, -0.558422, -0.058388, -0.614018, -0.140178, 
	-0.025822, -0.002291, 2.960847, -2.104969, -0.574428, -0.001343, 0.397234, -0.003174, -0.002103, 0.424022, -1.394914, -0.001332, 1.756308, -0.451301, -0.950196, -0.026539, 
	-0.003039, -0.004248, -0.597909, -0.244410, -0.196575, -0.000701, -2.382653, -0.003627, -0.003264, -0.533731, -0.430758, -0.000714, 2.775134, 2.065646, -0.401360, -0.037790, 
	-0.024425, -0.016954, -1.321311, -1.264227, -0.122666, -0.004498, -2.076138, -0.024404, -0.010240, 4.768403, -2.301005, -0.004902, 0.938444, 2.246028, -0.683028, -0.099076, 
	-0.023413, -0.006911, -0.445950, 0.164706, 1.282233, -0.001757, -0.988173, -0.011006, -0.004339, 0.689176, 1.302007, -0.001957, -0.666959, -1.054330, -0.207400, -0.025927, 
	-0.006488, -0.001407, -0.263407, 0.168105, -0.470239, -0.000663, -0.747914, -0.001967, -0.001095, 0.348945, 4.066142, -0.000685, -2.489201, -0.177385, -0.391227, -0.031513, 
	-0.002377, -0.002225, 1.180695, -0.705330, -2.406520, -0.000804, 2.902879, -0.003465, -0.001605, 0.350092, 0.579367, -0.000813, -1.064801, -0.313686, -0.498631, -0.012776, 
	-0.004179, -0.001535, 0.906609, -1.356217, -1.081886, -0.000624, -0.998299, -0.001946, -0.001094, 0.705817, -0.042674, -0.000624, 1.145775, 0.039384, 0.696860, -0.005365, 
	-0.008985, 0.003418, -0.227664, 0.550739, -1.484531, -0.002943, -2.341548, -0.036181, 0.161360, 1.286220, -2.110712, -0.003045, 2.887591, -0.193510, 1.548426, -0.028635, 
	-0.001581, -0.000583, -0.471990, 0.355574, -0.097565, -0.000113, 0.146431, -0.000464, -0.000433, 0.117503, 0.134711, -0.000120, -0.174683, -0.117748, 0.120243, -0.009182, 
	-0.040563, -0.016056, 3.418023, -3.204135, -0.524639, -0.002748, -4.157901, -0.011572, -0.006528, -0.551494, -1.457745, -0.003013, 6.036802, 0.583465, 0.145686, -0.207580, 
	-0.005882, -0.003643, 0.549396, 0.228039, -1.033421, -0.000790, 0.057802, -0.003802, -0.002308, -2.142808, 1.958019, -0.000878, -0.257450, 1.683969, -0.982272, -0.043972, 
	-0.049633, -0.018781, 6.939494, -1.070178, -1.066118, -0.008222, 1.746864, -0.045752, -0.015793, -4.139852, 4.529674, -0.008593, -7.838618, 4.346101, -2.836333, -0.464262, 
	-0.023210, -0.015726, -0.235707, 0.504992, -1.780360, -0.002548, 0.340804, -0.009826, -0.006726, -0.246634, 0.594384, -0.002883, -1.177260, -0.764170, 2.780488, 0.044383, 
	-0.116875, -0.021598, 3.157380, 0.195274, -6.152460, -0.004541, 7.193334, -0.031912, -0.003121, 1.822586, 1.545574, -0.005044, -1.411969, -1.982699, -4.002673, -0.181256, 
	-0.002826, 0.007194, 2.476106, -0.204065, 1.232513, -0.000719, -1.184765, -0.009147, -0.001079, -1.015734, -2.412449, -0.000736, 1.641194, -0.110165, -0.396010, -0.019312, 
	-0.021196, -0.019300, 2.167197, 0.709825, -1.507729, -0.003787, 1.506943, -0.026103, -0.011660, 1.178217, -3.556803, -0.004174, 0.968491, -1.269016, 0.208533, -0.319436, 
	-0.010873, -0.012008, 0.641422, 1.619788, 0.173525, -0.001346, 3.322450, -0.017490, -0.005623, -1.426519, 2.745943, -0.001658, -3.569427, -1.941180, -1.494466, -0.022537, 
	-0.866144, -0.448328, 8.005336, 1.340066, -6.563628, -0.091126, -6.292846, -0.587164, -0.221692, -2.320322, 18.217272, -0.109399, -17.961706, 2.262426, 1.550339, 4.086918, 
	-0.031789, -0.003734, -0.277378, -1.206433, 0.788476, -0.002204, -3.751098, -0.010489, -0.003120, -0.175569, 1.777068, -0.002381, 3.656323, -0.355852, -0.031623, -0.370197, 
	-0.027988, -0.009997, -2.477477, -0.322437, -0.788512, -0.003002, -0.847351, -0.022796, -0.006068, 0.809654, -2.456761, -0.003170, 2.037921, 3.084674, 1.093402, -0.060092, 
	-0.002046, -0.001197, 0.027431, -0.488680, 0.949427, -0.000452, -0.627296, -0.001063, -0.000801, 0.499265, -1.258879, -0.000453, 1.242717, -0.082405, -0.250675, -0.004893, 
	-0.035462, -0.007699, 2.469531, -0.136188, -0.826252, -0.004164, -0.201450, -0.008408, -0.005291, -2.589207, -0.711694, -0.004504, 1.470052, 1.624313, -0.970192, -0.063384, 
	-0.001232, -0.000777, -0.154557, 0.329947, -0.439453, -0.000450, 0.378051, -0.001192, -0.000666, -0.406811, -0.286237, -0.000458, 0.329695, 0.607943, -0.351102, -0.002701, 
	-0.000869, -0.000451, 0.228368, -0.039461, -0.240567, -0.000192, -2.525081, -0.002051, -0.000373, -0.099376, -0.701688, -0.000200, 3.338500, -0.107804, 0.165219, -0.013975, 
	-0.009523, -0.009522, 5.176901, -1.995532, -1.853307, -0.003065, 1.328917, -0.016019, -0.006609, 1.971622, -3.085006, -0.003141, 2.113185, -1.550190, -1.912703, -0.146008, 
	-0.077142, -0.040673, 5.117168, 1.666053, -5.081882, -0.014772, 1.868836, -0.036147, -0.024213, 3.215336, 2.265003, -0.015204, -2.258614, -3.695472, -2.495432, -0.392844, 
	-0.021142, -0.003322, -0.214624, 1.527386, 0.293261, -0.000939, 6.980172, -0.006331, -0.002196, -1.106719, -3.699874, -0.000988, -3.506726, -0.440243, 0.213855, -0.011570, 
	-0.005127, -0.003525, 0.105292, 0.171895, -0.011548, -0.001111, -2.653847, -0.004865, -0.002463, 1.185104, 0.182674, -0.001031, 0.536580, 0.187532, 0.354646, -0.040207, 
	-0.100983, -0.036515, -3.093497, 3.148085, -1.599178, -0.016831, -5.264585, -0.042646, -0.026758, 4.572323, 5.646055, -0.017856, -1.006144, -4.530956, 2.307769, 0.061716, 
	-0.098496, -0.026560, -1.427096, -0.105636, -4.984683, -0.006946, -2.481516, -0.073993, -0.019394, -1.835215, 8.441178, -0.007725, 0.923654, 6.112181, -3.653876, -0.755878, 
	-0.024888, -0.002555, 0.406278, 0.737062, -2.227123, -0.000901, -0.252925, -0.004071, -0.002523, -0.726481, 1.062860, -0.000949, 0.763486, 0.069685, 0.267584, -0.064540, 
	-0.011011, -0.004165, 1.883936, 1.556370, -0.682125, -0.001444, 0.166525, -0.008815, -0.003296, -1.598714, -0.663102, -0.001552, 1.063573, -0.957542, -0.661945, -0.076691, 
	-0.015786, -0.015345, -0.275855, -1.120244, -1.696198, -0.002546, -0.338160, -0.029000, -0.009595, -1.500072, -0.277546, -0.003134, -2.722587, 5.899346, 2.180820, -0.074098, 
	-0.006174, -0.006927, 0.072495, -1.480250, 2.114127, -0.001669, -0.255068, -0.004181, -0.006809, -0.696308, 2.495382, -0.001762, -1.739668, 0.056224, -0.482481, -0.056930, 
	-0.088119, -0.027870, -1.708508, 1.025773, 4.554480, -0.005714, -2.292962, -0.038197, -0.015625, -1.218695, -2.788879, -0.006238, 1.618832, 2.437716, -1.164910, -0.281085, 
	-0.009936, -0.004758, 4.831820, 0.183087, 0.347665, -0.002247, -0.279997, -0.006867, -0.004003, -0.947642, -0.806082, -0.002238, -1.501301, -1.174023, -0.531395, -0.092083, 
	-0.019604, -0.010638, 3.256937, 1.605546, -2.136824, -0.002878, -2.110406, -0.009155, -0.005844, 0.698906, 3.054939, -0.003131, -3.417514, -1.734050, 1.182648, -0.348933, 
	-0.037370, 0.244859, -0.048333, -1.953454, -1.335039, -0.002686, 2.836262, -0.095207, -0.007972, 0.145464, -2.677032, -0.002730, 1.282857, -1.484764, 3.274593, -0.139447, 
	-0.290125, -0.137924, 0.751750, -3.532390, -2.272955, -0.041789, 2.232952, -0.300392, -0.100312, 2.506783, -1.990063, -0.173530, -1.119210, 1.608914, 4.890234, -2.031941, 
	-0.116533, -0.068646, 3.926301, 4.731314, -9.711224, -0.024606, -5.949595, -0.198923, -0.050182, 16.839384, -2.956128, -0.157148, 0.810085, -5.810028, -0.677392, -0.586680, 
	-0.010080, -0.002694, 1.855006, 0.887216, 2.386442, -0.000723, 0.044432, -0.026203, -0.002033, -2.987870, 1.177277, -0.000777, -2.255985, -0.540152, -0.506958, -0.016898, 
	-0.037270, -0.012326, -0.479718, -1.706707, -1.375510, -0.004420, 1.275810, -0.028088, 0.079701, 0.846482, 2.812135, -0.008922, -1.926541, 1.799162, -1.045295, -0.188491, 
	-0.014043, -0.010120, -1.574011, 6.377290, -2.114490, -0.003680, 1.234804, -0.028002, -0.007627, -2.113268, -1.799060, -0.003813, -2.808257, 1.753014, 1.567183, -0.455920, 
	-0.010164, -0.003457, -0.125181, -1.504040, -3.343873, -0.001078, -0.267735, -0.006456, -0.002720, 1.017916, -1.553699, -0.001193, 5.373778, 1.528268, -1.013692, -0.086675, 
	-0.040523, -0.431344, 0.938461, 1.615686, -3.584806, -0.002245, 1.747870, 0.423769, -0.001262, 0.901978, 0.511728, -0.002128, 0.226024, -1.778341, -0.395677, -0.129190, 
	-0.064248, -0.040117, 1.635958, 2.352219, -3.319812, -0.021688, -0.516336, -0.044645, -0.030746, 5.797564, 0.542772, -0.022080, -4.674093, -1.110478, -0.227310, -0.256960, 
	-0.006487, -0.002931, 2.680297, 0.567093, 1.150052, -0.001095, -2.287604, -0.003192, -0.001974, -2.573173, 0.407618, -0.001096, -0.126484, -0.556566, 0.783661, -0.028118, 
	-0.048184, -0.004029, -0.677530, -0.993208, 0.610513, -0.000785, 1.325206, -0.003919, -0.002183, -1.120538, -1.711482, -0.000858, 0.866576, 1.099374, 0.674972, -0.013926, 
	-0.053532, -0.037307, -0.324489, -4.018717, 3.474199, -0.008800, -4.336625, -0.035435, -0.020689, 5.426941, 2.420696, -0.009152, -2.466128, 2.153148, -1.505865, -0.658245, 
	-0.008837, -0.005126, -0.871673, 1.339949, -0.703534, -0.000797, -1.037390, -0.005287, -0.002554, -0.452638, 6.375333, -0.000889, -2.507959, -0.925147, -0.189574, -1.003875, 
	-0.083372, -0.036292, 0.129770, -2.601734, 2.519291, -0.007950, 0.908345, -0.068938, -0.021062, -2.595344, -0.300269, -0.008867, -0.624885, 4.495567, -2.696306, 0.992046, 
	-0.014537, -0.008179, 1.308074, 0.300028, -0.993063, -0.001890, -1.020348, -0.009945, -0.004894, -2.051321, -0.696859, -0.001991, 2.266813, 0.936613, 0.093377, -0.101880, 
	-0.029483, 0.000117, -0.054420, -0.666396, 0.390032, -0.002164, -1.089942, -0.181675, -0.009673, -1.446716, 0.817730, -0.002408, -1.905769, 5.430533, -1.192750, -0.057014, 
	-0.007063, -0.008100, -0.019001, 0.450182, 0.693134, -0.001457, -0.991809, -0.017731, -0.004706, -2.194153, 2.636359, -0.001662, -0.878107, -0.149096, 0.681777, -0.188567, 
	-0.012824, -0.006025, -2.350296, -1.619080, -0.612407, -0.002496, -2.863602, -0.004619, -0.003960, 8.945829, -1.410225, -0.002635, 2.607215, -2.383259, -0.244325, -0.037291, 
	-0.003142, -0.003411, 0.858461, 0.319929, -2.779393, -0.000887, -2.770287, -0.005931, -0.002245, -0.987163, -2.910581, -0.000980, 6.710567, 0.471792, 1.159039, -0.055769, 
	-0.130273, 0.125081, -1.740378, -3.872447, -0.513082, -0.016531, 0.612160, -0.138804, -0.035490, 18.096319, -2.784848, -0.017456, -2.639804, -5.734686, -0.724327, -0.485434, 
	-0.026141, -0.015322, 6.822074, -4.690550, -2.163240, -0.008482, 2.247245, -0.020484, -0.012543, 3.738007, -2.509528, -0.008565, -1.508853, -1.392815, -0.333448, -0.117355, 
	-0.056228, -0.033064, 1.187311, -1.821230, 0.399895, -0.008254, -1.688005, -0.037259, -0.019072, -1.050173, 2.806229, -0.008844, 5.821551, -4.627347, -1.547038, 0.681527, 
	-0.015267, -0.004040, -0.382793, 1.626906, -2.742357, -0.001799, 1.110032, -0.003295, -0.003048, -0.557224, 0.115643, -0.001852, 1.352494, -0.287775, -0.159091, -0.046535, 
	-0.170832, -0.096016, -2.850913, -2.745018, 0.315649, -0.100023, -3.265652, -0.103317, -0.078615, -1.278274, -10.652380, -0.102874, -5.052508, -8.409821, 18.649570, 15.941024, 
	-0.004177, -0.002855, -0.424881, 0.062133, -0.548057, -0.000894, 0.528502, -0.002148, -0.001695, 2.410068, 0.393257, -0.000968, -2.878076, -0.367051, 0.972553, -0.135711, 
	-0.003513, -0.002775, 0.192396, -0.693800, 0.289444, -0.000664, 2.168713, -0.007837, -0.002010, -0.282473, -3.135622, -0.001003, 1.161769, -0.119832, 0.472492, -0.035285, 
	-0.008749, -0.003835, -0.366505, -0.436402, -2.176633, -0.002273, -1.008139, -0.009041, -0.003575, -1.174406, 4.628802, -0.002326, -0.281007, 1.231452, -0.370335, -0.017028, 
	-0.008509, -0.005812, 6.182683, 0.588196, -2.063717, -0.002191, -2.790555, -0.013687, -0.004563, 1.594046, 1.125707, -0.002339, -2.364083, -2.633144, 0.444744, -0.046777, 
	-0.006277, -0.005176, 0.931594, -1.154270, -0.857364, -0.001471, 2.588190, -0.007326, -0.003192, -0.033753, 4.685606, -0.001590, -7.267194, 2.446516, -1.285098, -0.029195, 
	-0.030114, -0.001134, 0.088560, -0.156027, -0.144880, -0.000353, -0.036338, -0.001637, -0.000867, 0.116909, 2.294226, -0.000583, -1.933238, -0.033876, -0.157743, -0.002906, 
	-0.369405, -0.148428, -1.830009, -4.292759, -4.591609, -0.047263, 2.830555, -0.194568, -0.088770, -3.426098, 11.620347, -0.062794, -1.197156, -3.191142, 7.115577, -2.126478, 
	-0.181390, -0.074754, -2.879838, -3.619007, 3.487860, -0.013189, 7.089620, -0.070200, -0.032645, -3.632938, -4.849838, -0.014275, 4.486145, -0.406515, 1.705254, -0.994291, 
	-0.002363, -0.002035, -0.353417, -1.022546, -0.295810, -0.000633, -0.424625, -0.002248, -0.001386, 1.044043, 0.534337, -0.000701, -0.333409, -0.181116, 1.047920, -0.006010, 
	-0.015029, -0.009936, -2.824911, -2.697258, 1.654970, -0.005169, 3.911827, -0.025273, -0.012184, 1.217265, -3.617364, -0.005613, -2.562464, -3.268038, 8.556973, -0.297796, 
	-0.013654, -0.003257, 0.093405, 1.091436, -0.823596, -0.001153, -2.015771, -0.017834, -0.002669, 0.904638, 2.339789, -0.001178, -1.201760, -0.172522, -0.154142, -0.021733, 
	-0.058554, -0.015015, 0.184520, 3.056540, -2.390287, -0.003488, -0.818488, -0.068186, -0.010505, -3.115533, 4.013496, -0.003876, -0.257256, 0.233508, -0.609021, -0.137854, 
	-0.036092, -0.022368, -2.145082, 0.060441, -0.496561, -0.006911, -1.297980, -0.054697, -0.016282, -1.454522, 2.342161, -0.007547, 5.382358, -1.979670, -0.062204, -0.205042, 
	-0.019247, -0.003690, 2.037592, -0.209018, -0.399057, -0.001310, -0.070411, -0.009974, -0.003030, -0.379083, 1.664884, -0.001410, -2.163241, -0.823296, 0.462768, -0.082478, 
	-0.066284, -0.021904, -2.746239, 6.536174, 1.378888, -0.007081, -1.574577, -0.025669, -0.014732, -0.889976, -0.350724, -0.007435, 1.745799, -1.824962, -2.006070, -0.125209, 
	-0.008037, -0.004844, -0.795930, 0.713489, -2.645841, -0.001233, -4.948240, -0.005482, -0.003193, 0.327173, 6.342662, -0.001366, -1.895543, 3.437562, -0.485310, -0.025866, 
	-0.043014, -0.012728, -1.452035, 6.503367, -1.387673, -0.003632, -1.786146, -0.023222, -0.008243, -6.255119, 2.774292, -0.003911, -7.023144, 10.025102, -0.962683, -0.341210, 
	-0.430848, -0.148723, -2.731119, -0.400912, -3.132094, -0.035876, 5.397817, -0.287288, -0.088690, 0.036886, 6.050939, -0.039280, 1.378764, -3.094249, -3.453786, 0.978459, 
	-0.007373, -0.018252, -1.450968, 3.557013, 0.647491, -0.001349, 0.246687, -0.010727, -0.004461, 0.912025, -1.988409, -0.001528, -0.931303, -0.812903, -0.084359, -0.051584, 
	-0.031267, -0.010257, 3.646063, -0.579675, -2.473992, -0.002389, 0.637322, -0.011634, -0.005980, 0.469121, -2.528442, -0.002834, 4.390924, -2.152830, -1.258101, -0.086027, 
	-0.016555, -0.005019, 0.802940, 1.883065, 1.620076, -0.001348, -2.273978, -0.008685, -0.003135, -1.642909, -0.612975, -0.001425, -1.265629, 2.151965, -0.526131, -0.100256, 
	-0.006060, -0.007121, 0.882928, 0.848343, -2.198440, -0.001314, -0.085001, -0.006127, -0.003775, -1.973740, -1.268514, -0.001400, 0.109158, -0.737219, 4.461564, -0.013280, 
	-0.713547, -0.887161, 2.109278, -1.044480, 4.150667, -0.340360, -1.218050, -1.122667, -0.644054, 0.418804, -1.230261, -0.697210, -0.893946, 2.112547, -0.624468, 0.624908, 
	-0.014305, -0.006509, 2.438235, 2.736261, -2.666121, -0.001799, -0.586038, -0.004636, -0.003788, -1.704265, 1.002134, -0.001882, -2.545922, -0.377288, 1.816333, -0.080410, 
	-0.018174, 0.235913, -0.903006, 2.748850, 0.377721, -0.001678, 1.999846, -0.083313, -0.004088, -1.385324, -3.345879, -0.001368, 0.375870, -0.851700, -0.215409, 1.071740, 
	-0.025196, -0.009727, 1.034093, -1.754956, -1.352916, -0.001174, 2.941505, -0.017219, -0.005380, -0.345165, 3.453193, -0.001377, -3.812574, -0.368643, 0.331779, -0.066243, 
	-0.008889, -0.006920, -1.446816, 0.771410, -0.295181, -0.001478, -0.425664, -0.006194, -0.004003, -1.048057, 0.941853, -0.001623, -1.256920, 3.811173, -0.988216, -0.034476, 
	-0.018312, -0.011960, -1.633350, 1.850183, -1.279502, -0.002253, -1.829862, -0.016765, -0.007148, -0.825048, -2.099363, -0.002335, 1.127514, 3.283173, 1.569645, -0.104615, 
	-0.006966, -0.003166, -0.553753, -0.553526, -0.386262, -0.001031, 1.498227, -0.004143, -0.002246, -0.199695, 6.015682, -0.001113, -5.422902, -0.798541, 0.484202, -0.064767, 
	-0.013377, -0.007377, 1.189653, 0.548970, 3.914685, -0.002523, 4.536098, -0.022420, -0.004860, 0.481161, -2.949565, -0.002634, -5.016626, -1.940322, -0.645861, -0.065001, 
	-0.007460, -0.005482, -2.790239, 4.431157, -0.284703, -0.003705, 0.823232, -0.005826, -0.004540, 0.190438, -0.533047, -0.003764, -1.544116, -0.014927, -0.166533, -0.080484, 
	-0.007515, -0.004067, -0.798722, -0.009340, -0.828044, -0.002299, -0.934720, -0.007275, -0.003508, 0.869330, -1.840475, -0.002376, 1.281461, -0.953430, 3.278375, -0.037396, 
	-0.015046, 0.004346, 2.032444, -0.773934, 0.663868, -0.001352, -1.524455, -0.022603, -0.003284, -3.532204, 3.433502, -0.001491, -1.676109, 0.932285, 0.579894, -0.095860, 
	-0.006558, -0.003002, -0.600040, -0.493053, -1.369313, -0.001068, -3.244677, -0.010386, -0.002941, -0.136125, 1.108594, -0.001148, 4.851188, -0.007474, -0.012680, -0.071316, 
	-1.419516, -0.249225, 0.108484, 3.557925, 0.686697, -0.115466, -2.371713, -1.023191, -0.343494, 0.435673, 0.728639, -0.381785, 0.398888, 1.056297, 0.828954, -1.897167, 
	-0.008148, -0.007292, 5.629883, 1.118208, -2.974420, -0.003037, -2.148499, -0.007918, -0.005459, -0.953264, -3.313493, -0.003111, 3.221392, -0.585051, 0.181970, -0.141760, 
	-0.029458, -0.007801, -0.290357, -0.761355, -3.059665, -0.002711, -1.030317, -0.029944, -0.006634, 1.091125, 6.850621, -0.002818, -2.875058, 1.439595, -1.230549, -0.054674, 
	-0.027422, -0.007970, -0.103076, 2.630101, -3.902191, -0.001450, -1.001107, -0.019457, -0.004525, -1.835256, 2.325457, -0.001636, 3.321552, -1.641786, 0.312217, -0.043451, 
	-0.001981, -0.001431, -0.245932, -1.228090, 0.376717, -0.000916, 0.139600, -0.001740, -0.001184, 0.320137, 0.897246, -0.000942, -1.694219, -0.158976, 1.617905, -0.016195, 
	-0.128193, -0.009369, 1.975094, 0.941808, -3.220851, -0.002253, -0.342138, -0.032983, -0.006472, 0.316827, 3.412186, -0.002588, -0.619457, -2.649984, -0.084933, 0.453307, 
	-0.018629, -0.011780, -0.297004, 0.448938, 3.442254, -0.004898, -3.004328, -0.010195, -0.007257, -0.935414, -0.237189, -0.004983, -3.378300, -1.162630, 5.467197, -0.285782, 
	-0.041163, -0.020732, -3.125406, -4.570704, -0.656447, -0.007952, 1.092705, -0.025015, -0.013143, -0.802883, -0.728838, -0.008245, 4.124267, 1.057113, 2.335960, 1.390486, 
	-0.015306, -0.012432, -2.059649, 1.911412, 3.989458, -0.002974, 0.137877, -0.013318, -0.007229, 0.883146, -3.079463, -0.003093, -5.322453, 5.990712, -2.121310, -0.275377, 
	-0.016315, 0.506608, 0.766279, 0.053024, 2.313736, -0.001624, 0.024248, -0.324896, -0.002900, -1.438002, 2.052193, -0.001652, -4.092828, -0.402093, -0.230137, 0.794358, 
	-0.056521, -0.017616, -1.888440, -1.644603, 8.121449, -0.012345, -9.159069, -0.028045, -0.013705, -2.205346, 20.698135, -0.012588, -16.659750, -1.305170, 0.308474, 3.875141, 
	-0.003252, -0.001466, -0.235503, -0.647725, 0.096498, -0.000444, -0.869963, -0.008729, -0.001038, 1.042103, 2.295942, -0.000476, -2.029818, -0.406573, 0.779784, -0.009341, 
	-0.001884, -0.001041, 0.049206, 0.815717, -0.048092, -0.000486, 1.225258, -0.003974, -0.001020, -0.585891, -0.417338, -0.000515, 0.061145, -1.393609, 0.311898, -0.009372, 
	-0.056571, -0.009772, 0.710815, 0.149331, 2.512538, -0.001525, -3.455204, -0.014624, -0.005622, -2.020520, -2.009521, -0.001701, 3.317079, 1.295820, -0.345975, -0.064548, 
	-0.000720, -0.000467, 0.129554, -0.133300, -0.243327, -0.000370, 0.010244, -0.000588, -0.000402, -0.019559, -0.876718, -0.000376, 1.266143, 0.086306, -0.215367, -0.001051, 
	-0.037072, -0.009800, -0.536717, -2.774411, -1.629518, -0.002785, -0.980050, -0.010451, -0.005887, 2.782073, 2.082057, -0.007473, 0.230011, -0.635189, 1.594119, -0.058907, 
	-0.001656, -0.000677, 0.191940, -0.145248, -0.119914, -0.000232, 0.428157, -0.000691, -0.000439, -0.038139, 2.322653, -0.000236, -2.793631, -0.151761, 0.415192, -0.105317, 
	-0.019403, -0.009438, -1.154505, 1.176483, -0.288733, -0.001837, -1.283917, -0.008563, -0.005018, 1.659955, 2.023456, 0.022356, -2.072114, -0.896854, 0.885853, -0.027721, 
	-0.008562, -0.008807, -0.216555, 2.680887, 0.288466, -0.003982, 1.488686, -0.010563, -0.007069, -1.582444, -4.600223, -0.004140, 2.778219, -0.779090, 0.199919, -0.214742, 
	-0.008164, 0.000780, -0.274060, -1.900997, -1.725246, -0.002606, -1.180003, -0.043194, -0.006929, 2.821076, 3.698398, -0.002981, -1.892094, -0.556875, 1.204107, -0.131211, 
	-0.011927, -0.007968, -0.385576, 0.686350, 3.163480, -0.002908, 1.928550, -0.010075, -0.005639, -3.835333, 2.267678, -0.003028, -4.034789, 0.771700, -0.481504, -0.039009, 
	-0.022789, -0.014759, -1.456534, -0.524245, -0.792502, -0.005123, 0.561406, -0.017856, -0.009929, -2.313772, 2.430061, -0.009776, 0.016998, 0.633034, 1.596744, -0.070957, 
	-0.004169, -0.002522, 0.356700, 1.601758, -1.423420, -0.001004, -2.646396, -0.003040, -0.001739, -0.593283, -1.442589, -0.000873, 5.325579, -0.152244, -1.235869, 0.223109, 
	-0.024429, -0.006894, -1.001446, 0.383916, 1.304236, -0.001898, 2.035307, -0.017374, -0.005028, 0.831096, -4.840883, -0.006393, 2.613486, -0.854689, -0.374313, -0.034692, 
	-0.107531, -0.046196, -2.184061, -4.851073, 4.057637, -0.009646, 7.785919, -0.030794, -0.018761, -3.265457, -0.550582, -0.010130, 4.137992, -5.490099, 1.050442, -0.467659, 
	-0.020847, -0.016652, 3.411883, 10.543173, -4.297118, -0.008048, -1.353370, -0.033016, -0.013672, -0.284101, -5.905599, -0.008266, -0.002424, 0.021148, -1.788471, -0.244620, 
	-0.026014, -0.010313, 1.629752, 0.547856, 3.377374, -0.002736, -0.581262, -0.022019, -0.006946, -1.644254, -2.141020, -0.002982, 0.381056, -1.817149, 0.720100, -0.401442, 
	-0.003757, -0.003870, -2.528091, 0.545598, -0.533832, -0.001481, -1.107784, -0.009083, 0.041757, 1.474282, 2.723724, -0.001461, -1.552075, -0.227932, 1.337781, -0.153777, 
	-0.006348, -0.002980, -0.649671, -0.951839, -0.526185, -0.001384, 1.912638, -0.007331, -0.003136, 2.699682, -2.330260, -0.001358, -0.381963, 1.436736, -1.153592, -0.033009, 
	-0.013401, -0.030014, -2.504503, -1.810486, -2.974115, -0.003375, -3.198702, -0.067770, -0.019029, 1.462643, 0.146179, -0.004754, 1.062246, 7.390903, -1.558860, 2.123037, 
	-0.048911, -0.016576, -1.042887, 2.123327, 3.052297, -0.004791, 3.049892, -0.021422, -0.010199, -1.493952, -3.308564, -0.005185, -0.602222, -0.113550, -1.151719, -0.405537, 
	-0.021709, -4.881053, -1.884806, -1.454878, -2.030623, -0.003686, 1.593972, 5.272593, -0.010423, -0.882081, 4.703102, -0.004368, -3.776854, -0.978587, 4.416312, -0.056911, 
	-0.008080, -0.002615, 0.479812, -0.490233, -0.551961, -0.000694, 3.408181, -0.003114, -0.001688, -0.125678, 0.157243, -0.000750, -1.760639, -0.549371, -0.523375, -0.027038, 
	-0.058236, -0.031680, -1.611551, -0.580369, 0.078258, -0.004604, 0.570120, -0.050190, -0.013408, 3.113451, 0.689289, -0.004998, -3.962783, 0.805713, 1.211939, -0.150950, 
	-0.004139, -0.002385, 0.539497, 4.016546, -2.141412, -0.001044, -0.976062, -0.002599, -0.001749, -0.873945, -2.007744, -0.001077, -0.075606, -0.729154, 2.275408, -0.014534, 
	-0.010690, 0.423296, 1.092648, -2.868572, -1.815986, -0.002530, -0.569310, -0.420945, -0.005598, 0.903109, 9.800191, -0.002672, -7.083814, 0.329971, 0.392555, -0.161655, 
	-0.017262, -0.002310, -0.541121, -0.116726, -0.463902, -0.000556, 3.476144, -0.002114, -0.001301, 1.583924, -0.619455, -0.000600, -2.122890, -0.726843, -0.436972, -0.008016, 
	-0.098209, -0.035693, -0.701208, 1.876456, 0.753630, -0.011842, -4.729670, -0.070881, -0.025298, 2.848693, -2.341134, -0.012288, -2.168773, 6.199634, -0.469016, -1.014401, 
	-0.047281, -0.022078, 0.611739, 0.595497, 3.832615, -0.005235, -0.400488, -0.015883, -0.010291, 1.748510, -2.445022, -0.005731, -1.247673, -1.651751, -0.602891, -0.334039, 
	-0.039597, -0.013108, 0.933094, -0.431677, 1.535958, -0.005025, -0.593660, -0.012271, -0.008823, -0.125572, 2.227534, -0.005442, -2.120307, -1.876999, 0.633900, -0.098004, 
	-0.077573, -0.059913, 0.561877, 3.489285, 2.548299, -0.012543, -0.440655, -0.094766, -0.029520, 0.117677, -6.463253, -0.013607, 3.299634, 0.827234, -2.672970, -0.979206, 
	-0.004675, -0.001943, -0.389657, -1.131067, -0.288521, -0.001278, -3.162439, -0.002711, -0.001620, -0.184928, -1.440717, -0.001305, 5.919147, 0.741622, -0.038309, -0.011598, 
	-0.041990, -0.005863, -1.177492, 4.250290, -2.087724, -0.001529, 3.857543, -0.009850, -0.003369, -0.056699, -7.086119, -0.001629, 2.896160, 0.073099, -0.469835, -0.134994, 
	-0.004779, 1.088324, 0.563102, -0.021393, -0.083711, -0.002177, -0.677163, -1.027847, -0.003320, -0.205551, -0.373473, -0.002221, 0.743894, -0.250472, 0.272474, -0.015685, 
	-0.033031, -0.012752, 0.762352, 3.819612, -3.955582, -0.003078, -1.954371, -0.016413, -0.007054, -1.379987, 0.737891, -0.003267, 2.634055, -0.881386, 0.387374, -0.094364, 
	-0.007660, -0.004983, 0.270661, 2.247686, -0.806911, -0.001503, 0.358686, -0.008616, -0.003469, -1.684401, 2.007545, -0.001686, -1.548489, -0.170576, -0.515826, -0.130459, 
	-0.010789, -0.008050, -0.434329, 0.256695, -3.556612, -0.000924, 4.182309, -0.009805, -0.003158, -0.698229, 0.188509, -0.001018, 3.001097, -0.182762, -2.641367, -0.081567, 
	-0.016619, 0.724248, -2.033216, -1.411210, -2.348660, -0.008108, 6.803563, -0.688942, -0.010878, 1.855947, -3.138101, -0.008180, -0.398325, -0.919399, 1.807233, -0.209353, 
	-0.041015, -0.002816, 3.211176, 0.638780, -0.266363, -0.001036, -1.509404, -0.021674, -0.002651, -2.784787, -0.749881, -0.001178, 0.634348, 1.391893, -0.461364, -0.034028, 
	-0.016281, -0.007163, -0.023957, 2.662511, -1.479737, -0.002254, 5.302473, -0.009391, -0.004990, 0.304221, -3.649515, -0.002422, -2.726821, 0.693802, -0.908741, -0.131736, 
	-0.036088, -0.020321, 1.360850, -0.882392, -1.632802, -0.004179, -4.707023, -0.044979, -0.009032, 2.102273, 4.922926, -0.004378, 1.165733, -1.947038, -0.138186, -0.125366, 
	-0.004009, -0.003997, -0.375935, 6.318251, 0.684938, -0.001147, -0.059902, -0.004802, -0.002818, -1.640165, -1.434891, -0.001236, -2.900557, -0.219546, -0.324237, -0.029946, 
	-0.015549, -0.014500, 7.794273, -1.834365, -1.664852, -0.008627, 0.204106, -0.014634, -0.011328, -3.640353, 0.702036, -0.008798, -1.324235, 1.359122, -1.410529, -0.111767, 
	-0.028675, -0.015036, -1.655189, -0.603516, 3.794806, -0.003512, -0.021296, -0.017265, -0.009205, -2.277640, -2.804245, -0.003842, 1.227813, 5.247199, -2.758118, -0.072279, 
	-0.012248, -0.009369, -0.224816, 0.285699, 1.316797, -0.002061, -1.081263, -0.018999, -0.005228, -0.283986, 1.934795, -0.002219, -0.318015, -0.453749, -1.024183, -0.101154, 
	-0.039347, -0.018217, -3.433662, -1.789521, -2.355645, -0.007219, -1.736933, -0.019828, -0.012413, -2.449074, 1.250233, -0.007446, 3.433878, 7.192796, 0.343057, -0.350660, 
	-0.013024, -0.003937, -0.239135, 0.948670, -1.403739, -0.000844, 1.888169, -0.006837, -0.002734, -1.133290, -3.824714, -0.000963, 2.947530, 1.387367, -0.506987, -0.035532, 
	-0.001001, -0.000598, -0.164919, 0.096045, -0.170638, -0.000265, -0.186282, -0.000809, -0.000452, -0.206771, 0.151167, -0.000275, -0.261211, 0.831494, -0.080717, -0.004766, 
	-0.007715, -0.007436, -2.003612, 0.775834, 1.764707, -0.001024, -1.809581, -0.006507, -0.003196, -0.016066, -1.532550, -0.001124, 1.939363, 1.958308, -1.013829, -0.035572, 
	-0.003865, 0.218280, 0.327604, 2.371969, -0.713456, -0.000896, -0.819322, -0.207949, -0.002557, -0.864678, 0.071740, -0.000961, -0.423539, 0.954250, -0.697042, -0.209579, 
	-0.067266, -0.009731, 1.097280, 2.934698, -0.013104, -0.003257, 1.640227, -0.014223, -0.006473, -2.092182, -4.331481, -0.003424, 1.380639, 0.224273, -0.300091, -0.435885, 
	-0.031738, -0.009706, -1.620671, 0.512127, 0.621941, -0.004562, -2.598753, -0.010986, -0.006999, -2.869712, 3.904386, -0.004002, -2.914616, 7.328043, -2.107228, -0.187523, 
	-0.909995, 0.099319, 1.846047, -3.067407, 0.454644, -0.065983, 3.227375, -0.884696, -0.217626, 0.344147, -2.329376, -0.200826, 1.494155, -2.976398, 2.782814, 0.403806, 
	-0.155338, -0.068738, 0.485174, 12.101122, -9.008478, -0.023895, 3.060436, -0.102643, -0.043796, -1.659883, -8.837307, -0.024433, 1.271190, -0.957857, 4.751129, -0.786681, 
	-0.016864, -0.009780, 0.197116, -1.336743, 5.955578, -0.003329, 0.399245, -0.019890, -0.006586, -2.196529, -1.788274, -0.007872, 1.531503, -1.262917, -1.324419, -0.110240, 
	-0.029755, -0.021187, 0.565636, -0.165402, -1.629552, -0.005781, -2.364608, -0.015058, -0.010085, 0.447336, -0.902027, -0.006065, -2.118530, 0.467186, 6.027462, -0.239568, 
	2.364669, 0.225233, -1.731901, -0.745844, -0.437195, -0.002824, 1.691120, -0.085421, -0.010471, -0.012779, 4.853722, -0.002536, -5.618744, -1.196417, -0.134892, 0.844281, 
	-0.003415, -0.000750, -0.204486, -0.622422, -0.633051, -0.000526, -0.166272, -0.001146, -0.000677, -0.473229, 1.923100, -0.000537, -1.596383, 0.714675, 1.066864, -0.001745, 
	-0.009746, -0.010994, -0.212300, 3.253309, 2.892184, -0.001800, -5.454825, -0.011703, -0.005578, 1.052832, -0.659907, -0.001993, 1.381415, -0.677720, -1.384307, -0.148867, 
	-0.018943, -0.007905, -2.775418, -1.638411, -2.180918, -0.001747, 2.973696, -0.010783, -0.004974, 4.051983, -0.705811, -0.001934, 0.732452, -0.862422, 0.649049, -0.197915, 
	-0.041781, -0.015491, -2.003054, -3.809576, -0.372726, -0.005353, -1.899701, -0.053315, -0.012675, 2.613244, -0.053269, -0.005864, 6.162311, 0.687042, -0.985000, -0.204793, 
	-0.003893, -0.002658, 2.900318, -1.573361, -0.270396, -0.000780, 1.193922, -0.002481, -0.001633, 0.247860, 0.941040, 0.000108, -1.962861, -1.112088, -0.735077, 0.381980, 
	-0.172289, 1.368819, 3.482711, -1.568224, -2.647420, -0.020889, -5.042074, -1.447216, -0.038431, 6.553744, -0.176729, -0.021804, -5.381171, 5.577123, -0.067340, -0.398809, 
	-0.029919, -0.014980, 3.262036, -0.256140, -1.101287, -0.003626, -2.884379, -0.030265, -0.007278, -0.006132, 2.126168, -0.003785, 1.469013, -1.855018, -1.048489, 0.384082, 
	-0.026718, 0.310570, 0.689432, -0.724896, -2.285651, -0.001144, 0.063893, -0.138572, -0.002793, 1.970736, -0.917375, -0.001264, 1.433155, 0.291070, -0.628442, -0.032000, 
	-0.025600, -0.013684, -2.456203, -1.093753, -0.696705, -0.002574, -3.380886, -0.032172, -0.006949, 0.044810, 6.611688, -0.002668, -1.414396, 3.547928, -0.802157, -0.276680, 
	-0.004430, -0.001362, -0.106503, -0.137591, 0.380442, -0.000452, -0.830951, -0.006244, -0.000818, -0.262373, -0.123223, -0.000468, 0.981721, -0.138174, 0.273803, -0.023377, 
	-0.036391, -0.016186, -2.262916, 3.913003, 4.502234, -0.003041, -6.148323, -0.035924, -0.009381, 5.855015, -9.013915, -0.003421, 5.699657, -2.298167, -0.037369, -0.104874, 
	-0.001436, -0.001373, -0.546941, -0.012510, -0.321141, -0.000299, -0.019592, -0.002299, -0.000795, 1.801574, 0.387199, -0.000322, -0.799609, -0.401330, -0.066247, -0.014880, 
	-0.068370, 0.128069, -0.108808, 2.130091, 1.227143, -0.007856, -2.013947, -0.305955, -0.026053, -0.063765, -3.164708, -0.012302, -0.045983, -1.115697, 3.893881, -0.445739, 
	-0.004068, -0.001732, -0.319631, 0.422602, 0.351890, -0.001087, 1.284306, -0.028540, -0.002469, -0.657110, -0.009090, -0.001191, -0.786160, -0.521506, 0.291040, -0.017253, 
	-0.081760, -0.025067, -3.745501, 0.979510, 3.763319, -0.008116, 2.180575, -0.027292, -0.015252, -0.184510, 1.682216, -0.008391, -2.909272, -0.332313, -1.176727, -0.091418, 
	-0.028257, -0.015576, -1.362823, 2.734304, -1.895956, -0.003418, 2.349117, -0.023802, -0.008891, 4.399693, -0.837738, -0.003742, -2.633000, 0.364562, -1.726541, -1.307931, 
	-0.002224, -0.001713, -0.497129, 2.492868, -0.937060, -0.000495, 2.922975, -0.042784, -0.002544, -1.146562, -0.271773, -0.000605, -1.752047, -0.302650, -0.437264, -0.020993, 
	-0.012231, -0.006941, -0.107129, -1.100339, 0.166009, -0.001413, -0.830136, -0.028081, -0.004162, 0.820644, -0.251374, -0.001506, 1.960177, -1.397946, -0.324419, 1.118846, 
	-0.001978, -0.001234, -0.495448, 0.298095, -0.503521, -0.000622, 1.535701, -0.001095, -0.000873, 0.711747, -0.354558, -0.000632, -1.001373, -0.097395, -0.077638, -0.009175, 
	-0.146213, -0.043159, 6.034509, 0.258740, 0.478906, -0.015638, 0.360454, -0.046897, -0.027309, -0.663620, -5.276948, -0.016243, 3.142423, -0.347891, -3.223096, -0.468017, 
	-0.019946, -0.011606, -1.864893, 0.084927, 1.556487, -0.002029, -2.171483, -0.007546, -0.005487, 4.317881, 0.102599, -0.002232, -3.807816, 3.096563, -0.921146, -0.344272, 
	-0.054419, -0.039137, -0.338350, 0.547984, 2.361119, -0.008119, 1.159544, -0.055204, -0.020932, -1.485947, 2.836745, -0.009021, 2.886912, -2.706863, -4.559886, -0.514426, 
	-0.001250, -0.001053, 0.172284, -0.099549, -0.334439, -0.000307, -0.209825, -0.000619, -0.000877, 0.180564, -0.236062, -0.000318, -0.051887, -0.099834, 0.540629, 0.142543, 
	-0.161608, -0.074583, 1.952403, -2.054027, -0.679118, -0.017605, -1.495132, -0.224006, -0.049760, -1.777566, 1.373196, -0.025010, 3.461657, -1.116161, 1.922906, -1.035587, 
	-0.027557, -0.015980, -0.397882, 0.132958, 2.440458, -0.015343, 0.253746, -0.021888, -0.012288, -0.951420, 1.785249, 0.056058, -1.741332, -2.855331, -0.984956, 2.355508, 
	-0.035422, -0.030702, -0.831228, -0.589644, 0.075882, -0.006394, -0.025812, -0.036781, -0.016056, 1.015808, 0.561248, -0.006954, 1.701135, 2.992925, -3.706504, -1.061501, 
	-0.009117, -0.002281, 1.292607, 1.444297, -0.219408, -0.000773, 0.589645, -0.001493, -0.001179, -0.293287, -0.819458, 0.000147, -0.956946, -0.956924, -0.041138, -0.024691, 
	-0.047845, -0.012272, -0.839196, 6.262983, -1.084126, -0.004071, -3.567462, -0.013649, -0.007745, -4.416447, 1.439300, -0.004238, 1.602232, -2.768794, 3.618215, -0.156888, 
	-0.017149, -0.003950, -0.428494, 1.403394, -0.764067, -0.001438, 0.370728, -0.007819, -0.005082, -0.931505, -3.979700, -0.001543, 3.368302, 0.047554, 1.003782, -0.053013, 
	-0.000694, -0.000785, -0.353756, 0.878209, 0.093067, -0.000262, 0.231446, -0.001129, -0.000588, -0.404206, -0.421120, -0.000275, 0.473890, -0.165155, -0.322315, -0.006325, 
	-0.004643, -0.002719, -0.646031, 3.968321, -2.022394, -0.001265, 2.124853, -0.004127, -0.002252, -1.679102, 0.550485, -0.001288, -1.004766, -0.639534, -0.538974, -0.096565, 
	-0.007643, -0.004451, 1.214532, -2.469597, -1.669960, -0.001024, -0.181517, -0.004532, -0.002095, 0.952366, 2.918863, -0.001063, -1.111447, 1.207064, -0.811814, -0.027683, 
	-0.016291, -0.001823, 0.348863, 1.598633, -1.049088, -0.000758, -1.099960, -0.002038, -0.001154, -0.727339, -1.141368, -0.000899, 2.630088, -0.097297, -0.385103, -0.054467, 
	-0.016940, -0.007938, 1.507860, 1.989696, -0.999098, -0.002357, 3.738177, -0.023746, -0.005566, 0.223825, -0.643797, -0.131861, -4.851370, -0.636642, -0.055651, -0.084593, 
	-0.021982, -0.007435, 0.491510, 0.297697, -1.001548, -0.002962, -0.660197, -0.013945, -0.005704, -1.424440, 2.790154, -0.003078, -3.912747, 1.152081, 2.380581, -0.057984, 
	-0.044553, -0.008749, -1.780060, 2.111760, -2.238727, -0.001709, -0.037647, -0.013168, -0.005134, -0.009749, 2.877086, -0.001863, -0.249801, -0.819399, 0.278421, -0.056708, 
	-0.030343, -0.017751, -0.314666, -1.003136, 1.347056, -0.005917, -1.429315, -0.023547, -0.011856, -1.054524, 1.554741, -0.010224, -0.664591, 0.652830, 1.151686, -0.140441, 
	-0.078588, -0.039657, 2.369068, -2.253654, -2.314448, -0.020118, -0.959027, -0.095325, -0.034742, -0.889213, -4.695968, -0.021180, -4.198367, 7.565183, 5.025931, 0.640105, 
	-0.015545, -0.023259, -0.641020, -1.745556, -0.933169, -0.002388, 0.239562, -0.060790, -0.015804, -3.365762, 3.115528, -0.003550, -2.720376, 6.971624, -1.053744, 0.254248, 
	-0.009694, -0.003560, -1.199715, -1.261945, -1.252234, -0.001569, -1.084045, -0.005985, -0.002851, 2.166004, 2.134897, -0.001571, 1.304427, 0.673845, -1.419347, -0.036658, 
	-0.300209, -0.130905, -2.652633, -0.677310, -3.627788, -0.044148, 2.352225, -0.165676, -0.082703, 1.212576, -3.276433, -0.047124, -0.167063, 4.087601, 4.150514, -0.630924, 
	-0.013934, -0.006065, 0.797380, -0.272282, -2.594679, -0.002539, -0.374307, -0.014084, -0.004362, 0.108043, 6.209822, -0.002624, -2.099920, -0.806160, -0.880543, -0.043745, 
	-0.004837, -0.002765, -0.809680, 3.881834, -2.197627, -0.000783, -0.968416, -0.008696, -0.001898, -0.436151, 0.985933, -0.000827, 0.941982, -0.718403, -0.625176, -0.034490, 
	-0.007094, -0.008589, -1.258285, 0.102609, 0.278299, -0.001939, -0.193073, -0.008126, -0.004470, -1.201323, -1.891095, -0.002127, 3.159651, -0.457102, 2.123982, -0.631318, 
	-0.010136, -0.004413, 0.212622, -0.313159, -0.061563, -0.000924, -0.373214, -0.005754, -0.001918, 0.021495, 2.291110, -0.000969, -2.102046, -0.481604, 0.869416, -0.038942, 
	-0.004331, -0.002376, -0.626895, 2.428642, -0.465425, -0.001126, 1.176656, -0.003225, -0.001851, -1.551244, -0.971317, -0.001180, 0.332393, 0.299627, -0.577174, -0.031173, 
	-0.002950, -0.001675, 0.398952, 0.677800, 0.816482, -0.000536, 0.240421, -0.001773, -0.001001, -0.768758, -0.787082, -0.000558, -0.404681, -0.061566, -0.599475, 0.496401, 
	-0.012828, 3.647098, -0.077118, 2.707537, 0.743809, -0.006314, -0.635295, -3.479337, -0.008127, -0.572820, 0.235336, -0.006376, -2.019874, -0.280584, -0.206775, -0.028330, 
	-0.002651, -0.001722, 1.530674, 0.178383, -0.324109, -0.000849, 1.876065, -0.001815, -0.001301, -1.403170, -0.778910, -0.000865, -0.902488, -0.232417, 0.087594, -0.022420, 
	-0.006012, -0.004431, 1.026082, -0.083102, -1.444166, -0.002631, -0.504211, -0.004316, -0.003531, -0.942907, 0.092346, -0.002693, -0.888773, 1.466268, 1.377746, -0.075669, 
	-0.020322, -0.001858, 0.708875, -1.364482, -1.694994, -0.003390, 1.907851, -0.020643, -0.007253, 4.837539, 0.949901, -0.008068, -2.061656, -2.195931, -0.891594, -0.133976, 
	-0.006580, -0.005320, -1.322810, -1.589652, 3.759365, -0.001047, -0.935334, -0.007015, -0.003146, 1.942947, 0.676407, -0.001142, -0.881836, -0.551036, -1.022710, -0.051091, 
	-0.034825, -0.015609, -0.410909, -2.073126, -1.007085, -0.004470, 1.647872, -0.015241, -0.009115, 0.724890, 0.990832, -0.004684, 2.948818, -1.662012, -0.981421, -0.093914, 
	-0.008600, -0.005897, -1.341495, 1.673644, -1.165491, -0.001431, -2.441411, -0.009047, -0.003414, 2.328644, 0.233944, -0.001551, -0.150280, -0.145405, -0.192653, 1.230444, 
	-0.016050, -0.009866, -0.986899, 0.286544, 0.040827, -0.005656, -2.108457, -0.026451, 0.101844, -0.410204, 2.450621, -0.005890, -0.292079, -1.086865, 2.108378, -0.039796, 
	-0.056480, -0.004502, -0.538277, 2.782008, -0.386507, -0.000708, -0.386142, -0.003706, -0.001917, -1.171778, 1.157701, -0.000782, -2.473047, -0.477111, 1.572884, -0.011637, 
	-0.068502, -0.029126, -2.846102, -2.920371, 3.409751, -0.006564, 3.388491, -0.037450, -0.016163, -0.957954, -0.077613, -0.015159, 6.035585, -2.413240, -3.191464, -0.254119, 
	-0.023775, -0.015165, 0.004362, 1.979572, -1.810803, -0.003217, -0.672942, -0.014581, -0.007816, -0.386284, 0.782437, -0.003519, 0.156749, -1.649406, 1.866944, -0.202557, 
	-0.000097, -0.000120, -0.008679, 0.257495, 0.035410, -0.000041, 1.501476, -0.000094, -0.000079, -0.096081, -0.809713, -0.000041, -0.842917, -0.004805, -0.030650, -0.001066, 
	-0.006802, -0.004225, -2.070135, 4.019990, 0.444074, -0.001506, 2.541955, -0.008265, -0.003291, -2.221438, -0.360027, -0.001724, -1.605942, 0.813243, -1.127104, -0.408802, 
	-0.027980, -0.000693, -0.604409, -0.374663, 0.767469, -0.000268, 0.777572, -0.001552, -0.000492, 0.960045, -0.086504, -0.000279, -1.277132, -0.045805, -0.075559, -0.009750, 
	-0.012068, -0.004279, -0.685336, -0.071653, 4.994944, -0.001156, 0.254630, -0.006208, -0.002807, -2.110806, -1.341991, -0.001255, -0.360818, -0.252215, -0.346553, -0.052430, 
	-0.022704, -0.018738, 1.336837, 1.868526, -1.250628, -0.001742, -4.477665, -0.008419, -0.005736, 1.989868, -0.524631, -0.001965, 4.992517, -3.347580, -0.365544, -0.162394, 
	-0.027845, -0.016385, 3.831008, 2.685702, -4.608173, -0.007438, -5.656944, -0.049161, -0.014092, -3.974431, 2.599572, -0.007895, 11.106817, -3.851573, -1.851614, -0.157548, 
	-0.603655, -0.204999, 0.731039, -0.160150, 0.667215, 0.132241, -0.137976, -0.317575, -0.123976, -0.914532, 0.679234, -0.065955, -1.350246, -0.341405, 4.233473, -2.222733, 
	-0.002676, -0.002713, -3.317934, -0.912468, 1.180210, -0.000862, -0.627444, -0.004934, -0.002416, 3.648147, 1.543078, -0.000962, -0.533424, -0.505452, -0.448985, -0.011167, 
	-0.013015, -0.012268, -0.770809, 1.011827, -5.398418, -0.002541, 0.413119, -0.015091, -0.006565, -1.403361, 2.815755, -0.002794, 5.421401, -0.983444, -0.936850, -0.116946, 
	-0.176521, 0.056069, 0.622812, 1.084128, 3.682055, -0.023323, 0.333199, -0.282614, -0.049654, 1.213230, -5.514254, -0.030274, 0.558171, -0.630281, -1.408836, 0.566094, 
	-0.113330, 0.551839, -0.890528, 6.046382, -1.833559, -0.014377, -1.266787, -0.734464, -0.042841, 0.373430, 4.340580, -0.146000, -2.031384, -1.431766, -2.159567, -0.647627, 
	-0.038000, -0.010632, 0.631491, -2.308260, -1.875924, -0.002648, -3.192771, -0.012041, -0.006728, 4.644449, 2.786089, -0.002750, 0.201271, -2.142886, 1.427903, -0.098564, 
	-0.007871, -0.003770, 0.115006, -1.364055, 0.102521, -0.001069, 1.887773, -0.012862, -0.002494, -0.457056, -0.894214, -0.001124, 2.961365, -1.265404, -0.967711, -0.089036, 
	-0.001945, -0.001537, -0.803308, -0.481958, -1.354597, -0.000466, 2.133200, -0.002330, -0.001079, 0.556669, 2.641781, -0.000476, -3.030114, 0.330001, 0.021539, -0.005378, 
	-0.023947, -0.005033, 1.549326, -1.535542, -2.717544, -0.002218, 3.208204, -0.020443, -0.004182, 0.802229, -4.043991, -0.002278, 0.648145, -0.034558, 2.249962, -0.068131, 
	-0.002090, -0.002764, -0.993605, 0.524442, -1.609086, -0.000761, -0.692232, -0.007875, -0.001896, -0.338437, 3.745473, -0.000835, -1.571562, 0.212057, 0.769669, -0.030497, 
	-0.007100, 0.004552, 0.081246, 0.980254, -1.903868, -0.001675, -1.094121, -0.030541, -0.003018, -1.373084, -2.983558, -0.001762, 3.397862, -0.584945, 3.575554, -0.055795, 
	-0.002766, -0.001834, -1.356376, 3.330853, -0.294534, -0.000571, -0.091953, -0.001655, -0.001091, 0.632563, -2.013295, -0.000590, 0.496403, -0.102195, -0.400794, -0.192166, 
	-0.079444, -0.027774, -1.650393, 1.289317, 0.743058, -0.006961, 2.264964, -0.040878, -0.018176, -3.263249, 0.089863, -0.007580, 1.393428, 0.320933, -0.721562, -0.285548, 
	-0.003639, -0.003369, -0.948603, 1.068746, 0.142299, -0.000607, -0.997794, -0.008484, -0.002376, 0.912135, 2.281766, -0.000801, -1.814278, -0.457418, -0.152607, -0.014971, 
	-0.132563, -0.035863, -2.494532, 4.674799, -6.157680, -0.012352, 6.990924, -0.047340, -0.022028, -1.986322, -2.791230, 0.031764, 1.304678, -4.202669, 5.238442, -0.358030, 
	-0.012868, -0.004744, -0.605174, 0.484448, -0.750681, -0.002130, -0.568516, -0.032099, -0.004512, -0.496818, 4.667797, -0.002258, -1.636169, 0.007424, -1.011112, -0.032588, 
	-0.005514, -0.007191, -1.457879, 4.655698, -1.675545, -0.000809, -0.849289, -0.005954, -0.002850, 0.771237, 1.602652, -0.000939, -2.189631, -0.413664, -0.375894, -0.044427, 
	-0.012191, -0.007101, -0.026274, 0.154144, 4.355091, -0.002095, 6.391137, -0.018578, -0.004432, 1.167524, -2.161241, -0.002200, -8.312212, -0.958695, -0.375878, -0.186998, 
	-0.019870, -0.011878, -1.548240, 3.409797, -1.609312, -0.002964, -4.331434, -0.021570, -0.007785, 0.599608, -0.584146, -0.003306, 5.197822, -0.530678, -0.421456, -0.114586, 
	-0.002840, -0.003699, 0.688316, -0.064014, -0.282594, -0.001005, 0.375576, -0.002517, -0.002141, -0.862093, 1.309060, -0.001080, -2.127967, -0.507294, 1.522187, -0.037894, 
	5.472033, -0.667158, -1.304096, -0.987738, 1.245465, -0.239777, -2.539074, -0.816864, -0.446266, -0.055153, -0.972429, -0.227309, 1.886120, -0.287549, 0.687305, -0.747511, 
	-0.010976, -0.007258, 2.854366, 1.229245, -1.164906, -0.003313, -0.695313, -0.009118, -0.005624, -0.478857, -2.445726, -0.003402, 1.646112, 0.901259, -1.989339, 0.182849, 
	-0.045274, -0.033169, 2.605462, -1.647329, -1.446264, -0.006539, 0.362516, -0.058622, -0.016470, -2.150706, 4.188128, -0.006981, 0.990500, -0.221818, -1.931540, -0.581893, 
	-0.012759, -0.004552, -0.294883, 2.727758, -0.713353, -0.000903, 1.121032, -0.006314, -0.002695, -1.093156, 0.422833, -0.000978, -2.300723, 0.810682, -0.539898, -0.112092, 
	-0.002731, -0.002703, -0.192573, -0.291004, 2.102288, -0.000700, -3.726113, -0.003755, -0.001612, 0.692480, 5.512791, -0.000780, -3.568371, -0.159308, -0.328390, -0.029521, 
	-0.147755, -0.047525, 6.129716, 1.042094, -5.894218, -0.007487, -3.458050, -0.056081, -0.021879, 1.953088, 6.795559, -0.008902, -1.272322, -1.151528, -3.013168, -0.841540, 
	-0.035329, -0.011447, 0.049716, -0.143793, -1.379729, -0.001233, -1.093508, -0.014866, -0.005490, 2.096623, 1.036943, -0.001445, 1.349873, -0.304980, -1.584106, 0.042772, 
	-0.180771, 0.484759, -1.172624, 1.435014, -1.447363, -0.015739, 0.991381, -0.176338, -0.040758, -6.592028, -0.481789, -0.021613, 5.187074, -1.355983, 4.029894, -0.643116, 
	-0.018764, -0.005846, -0.246963, -1.758547, -2.515394, -0.002486, -0.151792, -0.007197, -0.004667, 1.381729, 6.760805, -0.002575, -2.292007, -0.634173, -0.433461, -0.068662, 
	-0.002880, -0.002284, 0.260353, -0.211906, -2.094713, -0.000610, -0.730593, -0.002460, -0.001365, -1.258972, 1.931942, -0.000634, 2.120598, 0.261014, -0.229322, -0.038168, 
	2.214902, -0.071180, 3.437869, 1.089417, -1.232889, -0.017250, -1.802012, -0.102075, -0.042351, -0.098546, -1.885536, -0.019139, -3.178611, 4.338140, -1.686394, -0.944344, 
	-0.005707, 5.375078, 2.043467, 1.997596, -1.448824, -0.002710, -1.931108, -4.930883, -0.004910, -0.330655, -1.482227, -0.002795, 2.389923, -1.609915, -0.028655, -0.027676, 
	-0.003528, 0.160861, -0.943347, -2.187965, -0.267297, -0.001904, 0.505045, -0.156634, -0.002602, 3.582009, 0.387385, -0.001940, -0.329335, -0.456028, -0.248140, -0.036580, 
	-0.044741, -0.032236, -0.414653, 0.470564, 0.352995, -0.006948, -0.160820, -0.046014, -0.018663, -2.132999, 1.414848, -0.007601, -2.797767, 2.593674, 1.078579, -0.248218, 
	-0.022141, -0.014892, -0.023087, -2.285875, 6.545696, -0.001971, -4.388767, -0.008506, -0.005457, -3.894243, 1.467703, -0.002129, 0.584917, 2.553615, -0.245824, -0.259040, 
	-0.045575, -0.015185, -0.462680, 1.732302, 4.106479, -0.005687, 0.922907, -0.017787, -0.010867, -0.361196, -1.708623, -0.006156, -2.422741, -2.899484, 1.311578, -0.117286, 
	-0.000225, -0.000932, -0.581189, 0.174707, -0.138785, -0.000125, -0.095333, -0.000608, -0.000446, -0.114321, -0.308808, -0.000147, 0.427921, 0.687163, -0.048373, -0.000498, 
	-0.032743, -0.014441, -0.069123, -1.203475, 3.199073, -0.003566, -3.269191, -0.032714, -0.010506, -0.028598, 0.997405, -0.003784, -1.326195, 2.594045, -1.142818, 0.346630, 
	-0.017554, 0.359196, -1.045413, 0.892801, 0.337524, -0.001448, 0.139990, -0.205175, -0.005246, -1.398197, 1.972318, 0.047782, -2.073259, 1.584641, -0.477876, -0.110085, 
	-0.004119, -0.005716, 1.644398, -1.177599, 0.072490, -0.001587, 1.794962, -0.009471, -0.003775, 1.470282, -2.432193, -0.001713, -0.421865, -1.160578, 0.357046, -0.120563, 
	-0.003809, -0.001159, -0.037665, -1.636061, -0.351247, -0.000558, -2.233991, -0.001153, -0.000860, 1.636555, 1.019566, -0.000573, 1.713202, -0.242881, 0.149226, -0.008591, 
	-0.185447, -0.071375, 3.696761, 1.766110, -1.199012, -0.013584, 3.553063, -0.195398, -0.041477, 0.643265, 4.681391, -0.015253, -6.399855, -1.102058, -5.318487, 0.201356, 
	-0.017004, -0.005024, 2.321724, -1.628597, 2.404202, -0.002288, -2.308226, -0.012308, -0.003864, -1.692488, -2.415931, -0.002378, 1.730469, 1.769105, -0.082715, -0.054677, 
	-0.004293, -0.002676, -0.361751, 1.010180, -0.297015, -0.000831, 0.458691, -0.005515, -0.001997, -0.818708, 3.137252, -0.000867, -2.097288, -0.203374, -0.791485, -0.020324, 
	-0.012792, -0.004440, 0.625105, 1.612839, 1.292359, -0.002198, -1.904432, -0.004351, -0.003214, -1.003860, -1.330249, -0.002218, -1.205580, -0.000908, 1.992599, -0.048661, 
	-0.003314, -0.000785, 0.455544, -0.886592, -0.827778, -0.000321, -0.298023, -0.002836, -0.000803, -0.252270, 1.696943, -0.000344, 0.048714, -0.059087, 0.133655, -0.002704, 
	-0.015047, -0.011240, -2.628808, 2.277584, 0.158862, -0.003821, 0.163946, -0.017053, -0.008067, -1.874747, -0.686259, -0.003979, 2.648679, -0.843017, 0.944796, -0.101831, 
	-0.042442, -0.039105, 1.146128, 2.458570, 0.783162, -0.015086, 1.958965, -0.064506, -0.027989, -6.674396, -3.544293, -0.144842, 2.977692, -0.401087, 2.034174, -0.404945, 
	-0.011241, -0.012300, -0.972725, -0.112075, -1.774987, -0.001065, 3.195859, -0.049278, -0.008205, -1.064883, 5.123786, -0.001701, -1.816426, -0.408523, -2.065801, -0.020434, 
	-0.161147, -0.038641, -1.626934, 0.577878, 1.285864, -0.010968, -2.270019, -0.102049, -0.025582, 1.751705, 0.856432, -0.011985, -0.419995, 0.246661, 0.394526, -0.445746, 
	-0.010874, -0.010032, 0.318287, 1.340753, -3.868956, -0.002952, 3.288522, -0.008668, -0.005886, -0.867971, 2.916878, -0.002948, -3.951597, 0.064862, 0.919661, -0.119078, 
	-0.003227, -0.001769, 1.008673, -0.570729, 0.123762, -0.000639, 1.427196, -0.001363, -0.001044, -0.659620, -0.587288, -0.009453, -0.447458, -0.686383, 0.466764, -0.057423, 
	-0.009534, -0.010327, 1.035460, -0.921085, -0.636749, -0.001225, 0.493515, -0.003892, -0.003235, -0.847096, -1.580230, -0.001330, 4.568665, -1.453220, -0.605988, -0.023730, 
	-0.012496, -0.011839, 2.716630, -3.266204, -0.033675, -0.005638, -1.438049, -0.014372, -0.007713, -0.969560, -2.065633, -0.005871, 7.098702, -1.102692, -1.297663, 0.416074, 
	-0.017612, -0.008676, -4.244507, -2.652577, -1.546704, -0.002326, 4.044987, -0.011965, -0.005448, 5.789906, -1.141693, -0.002478, 0.524445, -0.661077, -0.009214, -0.055062, 
	-0.003606, -0.003044, 1.962146, -1.061529, 2.481692, -0.001364, -1.419899, -0.006104, -0.002248, -1.167692, -0.250504, -0.001442, -1.169989, -0.750258, 1.401922, -0.008082, 
	-0.211441, -0.132791, -1.765480, 1.875232, 0.595434, -0.030206, -0.338031, -0.201378, 0.480740, 0.578702, 0.021408, -0.290389, 2.450093, -1.141711, -0.236352, -1.653832, 
	-0.013713, -0.004893, 1.502392, -1.065974, 1.262492, -0.001206, -1.678187, -0.009917, -0.003169, -1.076213, 1.747822, -0.001298, -1.286913, 1.882722, -1.215804, -0.038140, 
	-0.006248, -0.006097, 2.100280, -1.751332, -0.433685, -0.002329, 2.226180, -0.008024, -0.004606, 1.877341, 0.718905, -0.002478, -2.666372, -0.277259, -1.680818, -0.083459, 
	-0.055789, -0.023932, 8.715153, -0.595554, -0.654658, -0.016380, -0.268180, -0.090628, -0.022113, -0.724363, -0.008624, -0.017426, -3.265107, -3.815145, 1.361019, -0.518274, 
	-0.002062, -0.001414, 0.212534, 0.202543, -0.686361, -0.000614, -1.166998, -0.001619, -0.000992, -0.468548, -0.573233, -0.000638, 2.655122, -0.173295, -0.048269, 0.053844, 
	-0.001695, -0.001286, -0.956649, -0.097896, 1.368703, -0.000463, -0.305729, -0.001001, -0.000751, 0.020137, 0.527046, -0.000478, -1.049731, 0.759498, -0.246537, -0.013168, 
	-0.007244, -0.004920, -0.483243, -0.372099, -0.828496, -0.000884, 1.991908, -0.002920, -0.002206, 1.302551, 2.008479, -0.000922, -4.225432, 0.556656, 0.139758, -0.070986, 
	-0.023139, -4.307848, 4.885698, -4.586192, -3.010359, -0.004952, 3.113677, 4.428025, -0.009181, 0.723459, 2.308489, -0.005227, -1.269544, 0.117470, -2.060452, -0.299922, 
	-0.006076, -0.002704, -0.494126, 1.213096, 0.351405, -0.000919, -2.234956, -0.003802, -0.002761, -0.075925, 2.349693, -0.000978, -0.645448, -0.303165, -0.063514, -0.079820, 
	-0.004583, -0.002507, 1.672278, -1.360373, 0.826160, -0.000540, 2.629646, -0.007661, -0.001561, -1.087494, -3.753766, -0.000580, 0.570027, -0.875892, 0.113133, 1.283713, 
	-0.018143, -0.015558, -0.724519, -2.688694, -0.463340, -0.002298, 2.634568, -0.022195, -0.007605, 1.794321, 0.469237, -0.002574, -1.076699, 0.754750, -0.360004, -0.271248, 
	-0.006383, -0.003195, -0.123875, -0.253494, 1.263784, -0.001358, 0.653908, -0.004333, -0.002312, -1.525660, -1.059605, -0.001347, -2.227165, 1.107690, 2.203330, -0.019985, 
	-0.008243, -0.007878, -1.179852, -2.204152, 3.808088, -0.001910, -2.877651, -0.004549, -0.003583, -0.908250, 4.278467, -0.001974, -1.270162, 1.541394, -1.011832, -0.147913, 
	-0.000763, -0.000451, 0.173963, -0.541062, -0.226922, -0.000558, -0.773671, -0.000506, -0.000407, -0.034980, 0.204754, -0.000562, 1.290891, -0.045781, -0.058991, 0.015047, 
	-0.004034, -0.003531, 2.083454, -0.145833, -0.170400, -0.001138, -4.426487, -0.004159, -0.002493, -0.992032, 0.980309, -0.001185, 1.481503, 1.696335, -0.411174, -0.079135, 
	-0.013678, -0.007560, -1.461524, 0.028674, -0.891441, -0.005054, -1.617260, -0.013164, -0.007487, 1.099445, -3.458170, -0.005149, 1.692163, -0.113569, 3.066239, 1.707537, 
	-0.002299, -0.001597, 1.077829, -0.905134, -0.298102, -0.000605, -0.288519, -0.006426, -0.001304, -1.649164, 0.500365, -0.000619, 1.156302, 0.714867, -0.286376, -0.009217, 
	-0.073515, -0.031429, 0.697083, 0.926973, -0.215838, -0.019312, -2.627955, -0.072177, -0.031364, -1.331502, 0.577603, -0.019978, -0.083864, -0.757915, 2.134468, 0.928722, 
	-0.048345, -0.015385, -1.303097, 1.285982, 2.773499, -0.004152, 0.411957, -0.022577, -0.010012, 1.276879, -0.348716, -0.004370, 0.355938, -1.539909, -2.583776, -0.223917, 
	-0.036861, -0.008619, 7.152455, -0.822202, -0.925889, -0.004444, 1.535782, -0.013937, -0.007370, -4.878983, -0.317848, -0.004547, -0.734627, -0.890709, -0.019337, -0.022862, 
	-0.006697, -0.004090, 4.470824, -1.199109, -2.102350, -0.001329, -1.028875, -0.004207, -0.002562, -1.741881, -1.911265, -0.001390, 3.059209, -0.692481, 1.186886, -0.020682, 
	-0.012812, -0.014808, -0.294697, -0.373780, 1.628423, -0.001663, -0.220398, -0.006026, -0.004606, 0.539485, -1.854821, -0.001749, 2.969909, -1.348137, -0.925811, -0.078508, 
	-0.006275, -0.001733, 0.900960, 0.091024, -0.675556, -0.000740, -1.449098, -0.008002, -0.001818, 0.150434, 2.795282, -0.000840, -2.249003, -0.159835, 0.729490, -0.114290, 
	-0.078006, -0.022881, -0.134470, 0.659810, 4.190112, -0.005355, -0.044457, -0.096034, -0.013921, -3.063734, 4.029669, -0.135275, -6.866602, -0.192597, 2.027391, -0.253649, 
	-0.011095, 0.242945, -2.859188, 3.320336, 0.119771, -0.002875, 0.233243, -0.090643, -0.005918, 0.964651, -4.030988, -0.002494, 0.921173, -1.384206, 1.250384, 1.334903, 
	-0.288161, -0.089768, 4.280745, -1.683194, -2.512847, -0.023530, 1.401634, -0.132602, -0.053771, -2.529876, 1.559544, -0.024635, 1.505512, 0.902624, -1.871984, -0.439693, 
	-0.044115, -0.009426, -1.873685, 3.008915, 3.782685, -0.003268, -0.091554, -0.012151, 0.014700, -1.219344, 3.756384, -0.007779, -4.411933, -1.148054, -1.709326, -0.032050, 
	-0.083026, -0.028538, -0.385144, 1.748046, -1.766622, -0.009660, -1.663457, -0.040579, -0.020191, -2.015863, 1.310162, -0.010284, 1.070744, 0.416729, 0.363481, 1.114201, 
	-0.268661, -0.055678, 15.241530, -8.375957, -1.438078, -0.028357, -1.186493, -0.099545, -0.048959, 0.778198, 13.740603, -0.033671, -9.202020, -5.402197, -3.069388, -0.551326, 
	-0.052286, -0.018528, -4.122146, 5.784183, -2.265862, -0.004945, -4.074944, -0.031465, -0.012765, -0.197109, -1.134693, -0.005240, 2.684850, -3.537389, 3.776838, 3.211502, 
	-0.002047, -0.001108, 0.479434, -1.434970, -0.188801, -0.000491, 0.839232, -0.001779, -0.000996, 1.349241, 0.352872, -0.000471, -0.597195, -0.054946, -0.704851, -0.033124, 
	-0.052684, -0.002956, -1.064560, -2.899888, -0.050890, -0.007172, 6.319139, -0.048104, -0.013130, 1.719636, 4.019475, -0.007492, -3.783525, -2.832506, -1.123585, -0.171758, 
	-0.010888, -0.005828, 2.744262, 1.665566, 0.242870, -0.001350, 4.425665, -0.006974, -0.003954, 0.463042, -4.279441, -0.001436, -3.524287, -1.078836, -0.455347, -0.173064, 
	-0.060110, -0.002591, -0.230800, -0.036002, 0.003909, -0.000918, -0.624101, -0.003835, -0.001734, 0.207383, 1.805114, -0.000963, -0.350185, -0.321460, -0.367207, -0.016500, 
	-0.003623, -0.003246, 0.053327, -0.600560, 1.541609, -0.000851, 1.051682, -0.003470, -0.002189, -0.606664, -2.676322, -0.000977, 2.318702, -0.831521, 0.230359, -0.466255, 
	-0.009365, -0.004527, -1.405538, 0.582840, 2.685158, -0.001684, -1.755553, -0.020948, -0.003432, 0.564315, -3.728579, -0.001772, 4.709832, -1.178956, -0.402761, -0.029032, 
	-0.066285, -0.009177, -1.007498, -0.846014, -2.005031, -0.001798, 1.565327, -0.015271, -0.005404, -0.940764, 1.435343, -0.001935, -2.461761, -0.578707, 5.000353, -0.061378, 
	-0.044776, -0.018198, -0.812547, 2.931268, 0.313898, -0.006955, -0.570338, -0.029344, -0.013340, 0.293044, 5.942221, -0.136957, -6.644909, -0.464978, -0.822801, 0.084710, 
	-0.048883, -0.011563, 0.109217, 0.775603, 0.030027, -0.001798, 0.711067, -0.007145, -0.004443, -0.045524, 0.554640, -0.001924, -4.269146, -0.067137, 2.521054, -0.244045, 
	-0.005182, -0.002092, 0.394304, -2.054609, -0.351590, -0.000710, 1.793810, -0.007855, -0.001511, 1.140125, -1.552605, -0.000704, 0.679108, 0.050442, -0.067814, -0.013115, 
	-0.009365, -0.005108, 0.337688, -0.917325, -1.078508, -0.002300, 2.794589, -0.009972, 0.004793, -1.218136, -4.566836, -0.002328, 3.205264, 2.146569, -0.582429, -0.096595, 
	-0.019359, -0.020018, 7.748187, -2.644310, -0.278560, -0.003951, -0.697984, -0.013441, -0.008407, 1.876213, -3.490486, -0.004318, -1.335766, -0.657643, 0.056208, -0.506364, 
	-3.514255, -0.189655, -0.388264, 1.202057, -4.153483, -3.381461, 2.308033, -0.303629, -0.145603, -1.707275, -2.027694, 14.799976, 4.470316, -0.493391, -2.800431, -3.675239, 
	-0.015751, -0.007176, 0.100096, 0.732452, 2.078129, -0.002491, 1.394396, -0.008955, -0.005287, 3.381112, -3.063329, -0.002840, -1.759048, -1.656761, -1.055515, -0.109032, 
	-0.003678, -0.003132, -0.368868, 1.922708, 0.476505, -0.001065, -1.112596, -0.003175, -0.002556, -1.030704, -1.313045, -0.001089, 0.879327, -0.244823, 0.839434, -0.033243, 
	-0.025607, -0.016992, 1.430526, 0.089894, 1.577681, -0.003674, -2.975009, -0.016537, -0.009633, 2.215714, -2.032699, 0.020380, 2.459566, -1.452034, -1.142838, -0.118737, 
	-0.053506, 0.039301, 4.572386, 0.186108, 1.244395, -0.013175, 0.054206, -0.049290, -0.024675, -3.507486, -5.975873, -0.013573, 3.597167, 2.541158, -1.282133, -1.315010, 
	-0.030727, -0.008715, -1.329246, -0.702669, 0.983754, -0.001225, -2.634512, -0.005882, -0.003611, -0.734748, 1.255094, -0.001344, 2.633699, 0.147576, 0.540348, -0.107794, 
	-0.045231, 0.176642, -0.602176, -5.051791, -0.337687, -0.010791, -4.472202, -0.071018, -0.015437, 6.519923, 1.341445, -0.010937, 2.987520, -2.344013, 2.213579, -0.277825, 
	-0.030985, -0.008337, -0.536102, -0.270565, -0.206163, -0.001741, -0.825693, -0.014551, -0.005039, 1.139216, 2.107332, -0.001944, -0.724914, -0.553510, 0.065641, -0.132645, 
	-0.020178, -0.002687, 1.504809, 2.273062, 0.339271, -0.000875, 1.061237, -0.002426, -0.001707, -3.128793, -1.774133, -0.000900, -0.423889, 0.149994, 0.091583, -0.064370, 
	-0.007121, -0.003740, 0.550610, -1.882377, 1.065112, -0.001275, -0.736448, -0.011795, -0.002580, 0.302204, 1.981730, -0.001327, -1.275365, -0.475394, 0.543504, -0.045739, 
	-0.012121, -0.006050, -1.581436, -1.727355, -2.389565, -0.003038, 4.852352, -0.018763, -0.005575, 1.445978, 0.374040, -0.003707, -1.780189, -0.481618, 1.392240, -0.055193, 
	-0.081193, -0.010054, -1.327715, -4.145413, 9.843712, -0.005114, -0.008349, -0.017123, -0.008442, 3.370001, -3.084531, -0.005209, -2.887673, -0.380854, -1.080392, -0.171651, 
	-0.040336, -0.009716, 3.447352, 2.181306, -3.100616, -0.002458, -1.676907, -0.012303, -0.006550, 0.158533, -0.202907, -0.002607, 1.006961, -1.943637, 0.253298, -0.049413, 
	-0.064298, -0.034183, -0.120711, -3.264335, -3.120549, -0.014666, -0.435394, -0.103829, 0.136458, 4.309128, 2.687251, -0.015858, -3.462079, -0.468905, 4.334567, -0.362595, 
	-0.015858, -0.003276, 4.244209, -1.736762, -1.186781, -0.001335, -1.309151, -0.003387, -0.002315, -1.655235, -0.908288, -0.001375, 0.879329, 0.008219, 1.745148, -0.053141, 
	-0.051482, -0.022135, -0.962933, 9.386890, -3.711574, -0.009347, -1.037718, -0.036074, -0.016410, 4.157194, -1.856647, -0.009484, -3.396986, -2.456115, 0.215548, -0.192728, 
	-0.008254, -0.007658, -1.739956, -1.148226, 0.419787, -0.001719, 1.915858, -0.006728, -0.004954, -0.509321, -0.331716, -0.001724, -1.893533, 2.785591, 0.736109, -0.203555, 
	-0.046845, -0.001594, -0.563428, 1.204603, 1.019769, -0.000551, -0.782964, -0.003507, -0.001250, -0.146427, -0.534169, -0.000579, 0.738930, -0.284172, -0.587709, -0.010108, 
	-0.092500, -0.021777, -3.787443, 2.654971, 1.046601, -0.005449, -1.151290, -0.029808, -0.013406, 2.306173, 0.620205, -0.005860, -0.811474, 0.058693, -0.567134, -0.200500, 
	-0.035973, -0.003526, 0.890433, 0.284500, -1.249787, -0.001081, 2.248599, -0.004641, -0.002187, -0.526729, 2.422679, -0.001117, -3.415163, -0.421683, -0.161337, -0.022989, 
	-0.029793, -0.028796, 2.790920, -2.429363, -1.872189, -0.008829, -4.656368, -0.045446, -0.017632, 2.205823, 2.678458, -0.009249, 3.991027, 1.526182, -3.880617, -0.214127, 
	-0.016177, 0.003252, -0.385094, 1.391016, 5.854859, -0.003293, -1.776059, -0.031021, -0.008355, 2.375805, 2.002469, -0.003482, -5.371820, -2.278702, -1.652809, -0.100590, 
	-0.004437, -0.002391, -0.002207, -1.438028, -0.440348, -0.000828, 0.203660, -0.002526, -0.001574, -1.777967, 0.176158, -0.000882, 0.477734, 2.267249, 0.556047, -0.009663, 
	-0.012839, -0.013653, 1.264305, -0.401689, -2.235154, -0.002731, 3.570019, -0.010038, -0.007518, -0.362755, -2.933060, 0.045918, 2.597919, -0.105095, -1.126863, -0.266765, 
	-0.008906, -0.006458, 2.753322, 2.226830, -0.639672, -0.002953, -2.682259, -0.009239, -0.004906, -4.355246, 1.767288, -0.003013, 0.822887, -2.670971, 2.886338, -0.073042, 
	-0.005797, -0.007985, 9.587193, -0.957928, -0.715588, -0.002546, -1.497027, -0.007846, -0.004758, -2.381886, 1.332142, -0.002602, -2.413889, -1.636022, -1.162648, -0.122813, 
	-0.026682, -0.010006, 0.547941, -1.510687, -1.671601, -0.002409, 0.619803, -0.013859, -0.005831, 0.935258, -0.024302, -0.002601, -2.674731, 1.022210, 2.906255, -0.088759, 
	-0.003516, -0.004453, 1.275426, -0.639119, 0.582287, -0.001367, -0.552632, -0.005236, -0.002713, -0.884409, -0.230460, -0.001416, -0.478532, 0.780643, 0.200345, -0.034846, 
	-0.003793, -0.002908, -2.381456, 0.853018, 1.170674, -0.000921, -0.105999, -0.005411, -0.002013, 2.549734, -3.833789, -0.000974, 2.069696, -1.054383, 0.764130, -0.015605, 
	-0.135985, -0.086358, -3.044044, -2.340200, -2.554254, -0.024103, 3.011077, -0.131383, -0.059053, -0.847718, 2.999749, -0.026641, 6.186653, 0.933578, -3.486788, -0.394531, 
	-0.011841, -0.008363, -0.824657, -1.027771, 2.815034, -0.002362, 5.082283, -0.013285, -0.006171, -1.463817, -3.496600, -0.002650, -0.129925, 0.900369, -1.712109, -0.098135, 
	-0.028097, -0.018809, -2.921605, -2.353313, -6.946203, -0.005204, -4.764102, -0.036277, -0.012485, 1.037962, 2.884658, -0.005615, 5.079723, 5.425148, 3.048629, -0.384408, 
	-0.034671, -0.021970, -4.120460, -1.785410, 1.106988, -0.007784, -0.593193, -0.042518, -0.015957, 3.479066, -5.148826, -0.008424, 1.636805, 4.034475, 2.028564, -0.506687, 
	-0.009576, -0.005140, 0.623257, -2.451519, -2.069076, -0.001980, 5.618892, -0.005041, -0.003312, 4.482226, -1.650580, -0.002011, -2.938868, -0.740555, -0.762097, -0.084620, 
	-0.005453, -0.002411, 4.821122, -0.420451, -0.259237, -0.000730, -1.848899, -0.003318, -0.001620, -2.064940, 2.051594, -0.005168, -0.431229, -1.849319, 0.032818, -0.012760, 
	-0.008652, -0.009752, 1.221132, 0.056680, 3.339697, -0.001525, -2.103909, -0.028018, -0.005842, -1.479629, 3.992509, -0.001820, -3.436913, -0.682034, -0.780541, -0.071383, 
	-0.012246, -0.004125, 1.699139, -0.246337, 1.339121, -0.001151, -3.142685, -0.004003, -0.002532, -2.051247, -0.214529, -0.001223, 4.721682, -1.759187, -0.154777, -0.165900, 
	-0.009106, -0.006280, 4.555786, -0.517132, -3.218894, -0.001780, -3.040375, -0.006113, -0.004048, 1.206136, 3.235922, -0.001959, -0.275976, -1.267166, -0.591857, -0.057157, 
	-0.075904, -0.032458, 3.960969, -2.229702, -1.859907, -0.012732, 0.766148, -0.051705, -0.023734, 1.637657, -5.472133, -0.013360, 1.650185, 1.849646, 0.285466, -0.378434, 
	-0.013685, -0.011308, 1.404831, 1.362550, -0.940064, -0.002498, -1.391858, -0.008571, -0.006121, 3.812892, -1.537387, -0.132002, -2.757881, -0.649088, 1.137662, -0.267471, 
	-0.011497, -0.002163, -1.099817, 0.383875, -1.467681, -0.000715, -0.840364, -0.003129, -0.001552, 0.421560, -1.840295, -0.000769, 3.895125, -0.723745, 1.363411, -0.072243, 
	-0.006992, -0.012226, 2.880271, -1.459667, -1.067719, -0.002560, 1.528394, -0.018432, -0.003006, 1.086729, -1.547240, -0.002568, -1.579594, -0.409095, -0.556192, 1.169897, 
	-0.061964, -0.025873, -3.986719, 1.546530, -0.460976, -0.008414, 2.070122, -0.037196, -0.017514, -1.779655, 4.103384, -0.008846, -2.649013, -0.116105, 1.516584, -0.084345, 
	-0.044164, 0.364224, 3.530150, -1.702609, -4.365023, -0.008149, -0.755190, -0.046975, -0.016134, -0.825302, 1.461049, -0.138020, 2.683696, -0.700332, 0.956733, -0.393952, 
	-0.021134, -0.011344, -0.631543, 0.091354, -1.916793, -0.003928, -0.573690, -0.032988, 0.145475, 1.818197, 3.187107, -0.004057, -1.003243, -0.227208, -0.934359, 0.118152, 
	-0.010022, -0.005230, 0.988170, 2.298616, -0.791929, -0.001380, -0.539187, -0.006364, -0.003373, 2.134943, -2.144104, -0.001479, -0.115249, -0.631844, -1.139056, -0.032513, 
	-0.023952, -0.013417, -0.341965, -1.482717, -1.693549, -0.003067, 3.043756, -0.023381, -0.007276, 1.223890, 5.306205, -0.003511, -3.792135, -0.797316, -1.180451, -0.211112, 
	-0.050167, 3.826079, 1.802711, -1.829900, 1.202490, -0.007738, -0.957047, -3.904949, -0.018909, -1.628404, -0.745400, -0.008392, 0.852998, 1.438078, 0.232094, -0.203544, 
	-0.020680, -0.002936, 0.304011, -0.304209, -1.040782, -0.001063, 0.870344, -0.004176, -0.001879, -0.262994, 4.723497, -0.001066, -4.524529, -0.326427, 0.605344, -0.012455, 
	-0.042118, -0.028229, -0.307696, 0.099593, 3.961500, -0.007017, 5.076303, -0.055541, -0.016870, 0.003385, -3.246101, -0.007539, -6.776625, 1.115163, 0.500803, -0.269011, 
	-0.013908, -0.008007, -0.903290, 0.353433, 2.201843, -0.001889, -0.847283, -0.009513, -0.004097, -0.431800, -0.502311, -0.002087, -1.554075, 2.319672, -0.522208, -0.074478, 
	-0.011052, -0.009694, 2.153223, 0.099972, -0.410631, -0.003331, 1.372673, -0.015236, -0.006529, -1.010741, -0.308178, -0.010811, 0.656127, -1.465736, -0.841013, -0.189043, 
	-0.008836, 0.253419, -0.577390, 8.767726, -4.052155, -0.002578, -4.194924, -0.263390, -0.004534, -1.335775, 4.160959, 0.022081, -3.371159, 0.082272, 0.583340, -0.059056, 
	-0.005664, -0.003168, -0.781872, -0.694832, -1.228985, -0.002029, -0.433420, -0.003418, -0.002597, 1.114491, 2.043099, -0.002086, -0.783515, -0.101643, 0.942247, -0.056606, 
	-0.024794, 3.378325, 0.761966, 5.447462, 0.486763, -0.003906, -1.737000, -3.312991, -0.008382, -2.107484, -3.718711, -0.002478, 0.318646, 1.988414, -1.199296, -0.266533, 
	-0.023636, -0.007728, 0.892574, 3.566851, 0.018868, -0.003133, -2.713959, -0.009270, -0.005433, 0.051166, 2.038952, -0.003300, -1.667225, -1.174604, -0.971319, 0.011195, 
	-0.026393, -0.019589, 6.349733, -3.651182, -1.037825, -0.009348, -1.501408, -0.024685, -0.015184, -2.121782, 8.974673, -0.027186, -5.829272, -0.783817, -0.107835, -0.168902, 
	-0.047279, -0.015046, 0.915971, -1.772541, 1.068471, -0.002509, 1.953205, -0.016115, -0.008359, 0.265916, 0.638823, -0.002595, -2.760301, 1.564054, -1.644275, -0.137421, 
	-0.039591, -0.008591, 1.779234, 4.639881, -1.578931, -0.002892, 1.883699, -0.012735, -0.006407, -2.748335, -2.553068, -0.003507, 1.076524, -2.216849, -0.146767, -0.061667, 
	-0.001881, -0.000579, -2.057282, -0.003575, 0.777591, -0.000294, 0.068366, -0.000564, -0.000429, 2.873591, -0.246923, -0.000300, -1.338890, -0.013475, -0.045723, -0.009633, 
	-0.021004, -0.009395, 0.261322, 5.244719, -1.448734, -0.004288, -2.257958, -0.012503, -0.006947, 0.110151, -3.451056, -0.008724, 5.228721, -0.807307, -2.670511, -0.146486, 
	-0.044929, -0.028218, -4.798470, 4.649381, 2.023291, -0.015797, 3.885348, -0.032164, -0.021674, -3.682587, -7.295820, -0.016040, -2.482444, 4.088903, 4.149525, -0.378305, 
	-0.005457, -0.002670, 0.384612, -1.087173, 0.862687, -0.000851, 0.069076, -0.009484, -0.002230, -0.571475, -0.650618, -0.000988, -0.836004, 2.020565, -0.155052, -0.014937, 
	-0.030397, -0.038843, 2.619010, -2.311560, -4.221865, -0.011721, -3.503151, -0.044267, -0.020384, 11.293670, 0.963942, -0.012464, -1.247637, -2.116721, -1.077432, -0.240179, 
	-0.091243, -0.031996, -2.194331, 0.875610, -4.833509, -0.009296, 2.438162, -0.043428, -0.021957, 3.594677, 4.870831, -0.017100, -2.187983, -1.247903, -1.092564, -0.007970, 
	-0.014797, -0.011010, -0.334574, 0.573881, 0.298477, -0.001570, -4.406453, -0.010663, -0.004771, -1.599627, 0.152311, -0.001799, 5.514533, 1.805316, -2.110224, 0.150967, 
	-0.002044, -0.002555, -0.187245, 1.419870, -0.564129, -0.000558, -0.172233, -0.001782, -0.000851, -0.100591, -1.021549, -0.000562, -1.260155, -0.154799, 2.060965, -0.011781, 
	-0.011047, -0.002037, -0.325709, -0.057284, -0.564717, -0.001296, -1.270730, -0.002704, -0.001801, -0.270204, -4.581575, -0.001330, 5.955039, -0.174057, 1.312843, -0.003392, 
	-0.006550, -0.006583, -0.375724, -0.373193, -2.649103, -0.001873, -1.136324, -0.008988, -0.005415, 2.728549, 4.442087, -0.001853, -2.336135, 0.902942, -1.079607, -0.092230, 
	-0.064370, -0.013796, -1.517351, -1.810402, -1.204780, -0.008181, 12.626980, -0.015530, -0.011846, 2.486064, -2.847690, -0.008951, -6.399006, 0.583578, -1.506471, -0.288246, 
	-0.024254, 0.038459, -0.176238, 3.136791, -1.411259, -0.004005, 1.918526, -0.068967, -0.009264, 1.870993, -0.775109, -0.004162, -3.516207, 2.305480, -3.127837, -0.152946, 
	-0.048047, -0.020467, 2.088888, -1.049755, 0.963120, -0.006495, -2.655489, -0.062172, -0.013311, 3.622133, -4.886190, -0.011316, 1.326368, 1.695380, -0.781164, -0.161483, 
	-0.010174, -0.009156, 1.138316, -1.491367, -0.670024, -0.003011, -1.810258, -0.008586, -0.006013, -3.508265, 0.779504, -0.003391, 3.989500, 1.740398, -0.066614, -0.060857, 
	-0.177480, -0.106685, -0.251711, -1.200610, -0.177094, -0.030357, -0.134472, -0.136931, -0.067982, -2.715913, 2.899022, -0.033215, 3.743439, 3.380307, -5.692860, 0.702541, 
	-0.096158, -0.021849, -2.666112, 4.182645, 0.258294, -0.012546, 3.079912, -0.303036, -0.026816, -1.794854, 1.288798, -0.013384, -4.250118, -0.627675, 1.327519, -0.324619, 
	-0.012262, -0.009704, -2.108507, -4.062966, 0.198673, -0.002775, 1.177822, -0.007135, -0.004931, 7.395339, -3.006432, -0.002923, 0.251749, -0.639908, 0.897053, -0.063095, 
	-0.017445, -0.008045, 1.700898, 0.933278, 1.481173, -0.002068, -0.061951, -0.008602, -0.005057, -0.980631, 2.478588, -0.002198, -4.438581, 0.281691, -1.233143, -0.117907, 
	-0.027175, -0.012436, -0.565776, 0.556007, 7.347945, -0.003808, -3.037622, -0.016746, -0.007989, 0.576980, -2.042185, -0.003979, 0.613377, -3.196372, -0.074302, -0.105918, 
	-0.008180, -0.004147, -1.403962, -1.375857, 0.094121, -0.001556, -6.249963, -0.007408, -0.003323, 4.201324, -0.008432, -0.001658, 7.739143, -2.507543, -0.434320, -0.028238, 
	-0.037836, -0.019638, 1.129187, 4.282719, -1.005407, -0.005640, -4.147370, -0.027445, -0.012806, 0.362768, 2.134687, -0.005997, -0.925075, 1.370371, -2.797825, -0.294694, 
	-0.087959, -0.008183, -1.042212, -0.834364, -1.349359, -0.002078, 2.028937, -0.009725, -0.004597, -1.018975, 1.471880, -0.002224, -0.010702, 1.301407, -0.382294, -0.049551, 
	-0.026333, -0.019801, -0.740107, -0.691414, 0.512703, -0.003346, -7.660325, -0.024288, -0.012060, 2.629603, 0.705243, -0.003702, 6.375964, 1.177228, -1.939644, -0.279721, 
	-0.006840, -0.005563, -0.181010, -0.203318, -0.805338, -0.001333, -0.224027, -0.009382, -0.004042, 2.198053, 4.869429, -0.001385, -4.892527, -1.319659, 0.712203, -0.125261, 
	-0.006674, -0.004378, 0.249052, -1.177451, -1.285611, -0.001740, 3.574485, -0.005210, -0.003540, 0.445901, -0.616119, -0.001825, -1.844464, -0.141166, 0.863603, -0.044864, 
	-0.007588, -0.004096, 0.170276, -0.728150, -0.323378, -0.001659, 1.946325, -0.009177, -0.003646, -0.330779, -2.026147, -0.001705, -0.399072, -0.127321, 1.868107, -0.021990, 
	-0.201891, 0.594988, -3.263566, 4.938870, -1.469536, -0.013296, 0.583791, -0.093285, -0.031734, -1.589206, -2.186316, -0.014168, 0.501679, 1.679378, -0.043500, 0.607792, 
	-0.038230, -0.013702, -1.586983, -1.156678, -3.147406, -0.004620, 6.642888, -0.023359, -0.019700, -0.394451, -0.587123, -0.004910, -2.951284, 3.665992, -1.925257, 1.544823, 
	-0.012886, -0.005875, -1.312088, 0.640320, 1.842050, -0.001520, 1.479689, -0.005240, -0.003512, 0.256447, -0.479367, -0.001448, -1.992319, 0.208035, -0.559501, -0.052785, 
	-0.120112, 2.550184, 1.727321, 0.562979, 2.442310, -0.020244, -4.134977, -2.693574, 0.490844, -0.540577, 0.357008, -0.020555, -3.220049, 3.914529, -0.613553, -0.681535, 
	-0.010062, -0.006796, 2.102677, -2.085272, 0.169736, -0.003871, -1.959338, -0.012505, -0.004980, -2.809700, 3.677017, -0.003893, 1.123324, -0.896910, 0.495794, 0.224780, 
	-0.024191, -0.002154, -0.537660, 0.412256, 3.693640, -0.000687, -0.862964, -0.018511, -0.001557, -0.372916, -3.074976, -0.000742, 0.367809, -0.204170, 0.643619, -0.016795, 
	-0.048121, -0.014314, -1.328515, 3.422580, 1.691525, -0.003405, 3.572975, -0.011534, -0.007332, -0.848873, 0.049619, -0.003832, -2.687730, -1.960182, -1.465060, -0.357800, 
	-0.001663, -0.001527, -0.925895, -0.217258, -0.152882, -0.000759, -1.091339, -0.001384, -0.001082, 3.106772, -0.255840, -0.000800, 1.447217, -1.467623, -0.411975, -0.023963, 
	-0.005809, -0.003195, -0.715143, -0.156764, -0.730516, -0.001117, -1.932709, -0.006984, -0.002636, 0.645120, 2.689816, -0.001207, -0.298299, -0.273524, 0.814653, -0.021684, 
	-0.004711, 0.359711, -0.272507, 0.207384, 2.706335, -0.001854, -1.376268, -0.354885, -0.002978, 0.367577, 2.033792, -0.001971, -3.949015, -0.958140, 1.288197, -0.040666, 
	-0.048127, -0.007854, -1.481413, 2.758764, 0.038657, -0.002347, 1.700554, -0.008884, -0.005106, -0.719530, -3.884540, -0.002420, -1.672752, 0.581531, 2.798410, -0.044947, 
	-0.002142, -0.001252, -0.989808, -3.257482, 2.232859, -0.000630, -1.063394, -0.002294, -0.000969, 3.705696, -0.740300, -0.000648, 0.351321, -0.108854, -0.108456, -0.013647, 
	-0.319226, -0.060302, 6.357170, -7.263749, -8.006686, -0.019097, 6.096794, -0.132682, -0.042481, 1.173538, 3.601665, -0.020509, 0.614792, 1.087655, -2.615870, -0.451010, 
	-0.019721, -0.020191, -1.115485, -1.286019, -3.564040, -0.003669, 4.234142, -0.014493, -0.007251, 0.311778, -1.481932, -0.004321, 0.154516, -1.147602, 3.687721, 0.276567, 
	-0.014522, -0.007817, 0.538879, 1.518327, -0.633327, -0.002483, 0.082044, -0.011257, -0.004778, -1.483713, 1.822648, -0.002631, -0.644900, -1.328802, 0.394158, -0.221825, 
	-0.016187, -0.011428, 5.919061, 2.406533, -1.356856, -0.006268, -1.134878, -0.013377, -0.008781, -1.966854, -0.872505, 0.018018, -1.561947, -0.157052, -1.115275, -0.122205, 
	-0.043167, -0.023319, -0.696942, -1.078331, 4.915903, -0.005415, 2.404940, -0.023869, -0.012414, -1.903034, -6.469923, -0.005710, 3.235927, 1.782467, -2.026083, -0.051029, 
	-0.003883, -0.006469, 5.381804, -2.934604, -1.538882, -0.001198, 1.650851, -0.006492, -0.004149, -0.511239, -2.037794, -0.001223, 1.464875, -1.549197, 0.180147, -0.082548, 
	-0.021696, -0.005286, -2.930607, 1.107114, -2.205040, -0.002672, -2.600447, -0.066336, -0.004961, 6.169183, 4.451842, -0.002782, -2.686174, -0.506514, -0.613985, -0.081639, 
	-0.030110, -0.021512, 2.517354, 3.848089, -1.917752, -0.005775, 1.043343, -0.020002, -0.011186, 1.406237, -1.187252, -0.135597, -3.572351, 0.919111, -2.714623, -0.117972, 
	-0.033536, -0.003230, -0.872773, -1.832916, 1.753320, -0.000837, -3.537055, -0.005703, -0.002485, 0.114382, -0.107207, -0.000892, 3.813129, 0.225810, 0.507979, -0.017985, 
	-0.009890, -0.005189, -0.180152, -0.272408, -0.961919, -0.000643, -0.110107, -0.004986, -0.002572, -1.368383, 1.228976, -0.000721, -1.347223, 3.120858, -0.047193, -0.038448, 
	-0.235123, 0.278762, 4.325235, 0.533692, 0.655662, -0.031219, 0.512316, -0.441111, -0.066948, -7.286776, 1.836703, -0.032976, 1.581065, -6.220827, 5.780525, -1.188979, 
	-0.013798, -0.014500, -0.024242, -1.386148, -3.012046, -0.005008, 3.875760, -0.015077, -0.009208, 1.641904, -2.363707, -0.005280, 1.444031, -0.579819, 0.656959, -0.189821, 
	-0.001055, -0.001153, 2.604932, -1.961420, -0.179484, -0.000651, 0.240916, -0.001621, -0.000963, -0.075629, -0.205628, -0.000667, -0.156263, -0.948324, 0.738522, -0.051512, 
	-0.004928, -0.006022, -0.489148, 0.979877, -0.079935, -0.000716, -1.605837, -0.010649, -0.002739, -0.609418, -0.594948, -0.000841, -0.146659, 2.241198, 0.368011, -0.037247, 
	-0.031151, -0.003137, 0.561772, -1.372468, 0.336536, -0.000889, -1.040724, -0.003577, -0.001976, 2.226433, -0.699716, -0.130333, -0.813232, 0.420334, 0.576271, -0.024142, 
	-0.004376, -0.006697, -0.766264, -0.241245, -0.692117, -0.001413, -1.816654, -0.007380, -0.003809, -0.479941, 1.338510, -0.001552, 1.355878, 2.365297, -0.952334, -0.085902, 
	-0.013405, -0.010830, 2.842205, 0.459281, -1.022527, -0.002314, 4.940132, -0.008581, -0.004799, -2.423892, 6.295051, -0.002386, -9.279955, -1.140147, -0.455091, -0.172743, 
	-0.035886, -0.011355, 0.574330, -0.913033, -2.158689, -0.003362, 2.688520, -0.024962, -0.008237, 0.118728, -2.777499, -0.003496, 4.225376, 0.159134, -1.595026, -0.234542, 
	-0.011866, -0.008256, -1.171916, 0.248043, 2.204586, -0.001791, 0.009422, -0.012227, -0.004894, -0.964162, 0.691272, -0.001937, 0.275798, -0.879667, -0.312340, -0.060063, 
	-0.025687, 0.000120, -0.605355, 1.398578, -0.516713, -0.002506, -0.167690, -0.022037, -0.004879, -0.717474, -0.908506, 0.013957, -0.575472, 3.046260, -0.570641, -0.341956, 
	-0.012955, -0.007210, 0.622946, 1.197041, -2.018170, -0.002007, -2.059486, -0.007799, -0.004310, 0.042186, -1.428248, -0.002143, -1.297222, 1.146791, 3.977676, -0.147090, 
	-0.007382, -0.005533, -0.212099, 0.317955, 2.159862, -0.001105, -0.255304, -0.006409, -0.003772, 0.258099, 0.641823, -0.001229, -3.338336, -0.263651, 0.741551, -0.024470, 
	-0.059226, -0.018788, 0.097078, 0.390065, -3.399076, -0.005374, -4.014176, -0.035160, -0.012997, -1.116810, 5.970634, -0.007440, 4.423737, -1.183008, -0.816232, -0.213226, 
	-0.016196, -0.006845, 0.017283, 0.366800, -4.266310, -0.002284, 2.617170, -0.006293, -0.003878, 2.230769, -2.693401, -0.002329, 2.855413, -1.060180, 0.049447, -0.079166, 
	-0.079471, -0.012363, -0.846202, -0.991403, 0.779622, -0.004538, 2.314383, -0.035396, -0.012783, -3.315331, 1.515911, -0.005035, -2.373829, 2.870147, 0.082416, 0.113871, 
	-0.008049, -0.004336, -1.195494, 1.786359, -1.272831, -0.002327, -0.844779, -0.009182, -0.003630, 3.674662, 3.048838, -0.002364, -4.262851, 0.059854, -0.933922, -0.029948, 
	-0.016405, -0.007699, -1.026080, 0.702793, -3.633540, -0.001673, 6.561362, -0.007151, -0.005104, -2.516144, 3.121074, -0.001786, -6.024247, 3.575973, -0.627131, -0.094241, 
	-0.002679, -0.001625, 0.096059, 0.222775, -0.022697, -0.000630, -1.618891, -0.001334, -0.001158, 1.237680, -0.199511, -0.000644, 1.168317, -1.366246, 0.494890, -0.004305, 
	-0.072319, -0.033910, -2.706263, 0.325760, -3.405423, -0.009888, -3.472600, -0.064630, -0.021971, 1.405516, 1.042114, -0.010317, 3.373658, 1.106958, 3.079332, -0.536017, 
	-0.020504, -0.019327, -0.952148, 1.533571, -4.907911, -0.004192, -1.836165, -0.027385, -0.012053, 0.013213, 4.060159, -0.004456, 1.354368, 1.257125, -0.933038, 0.498745, 
	-0.041680, -0.021528, 6.504794, -1.101818, -1.433474, -0.003412, -1.817801, -0.035484, -0.011596, 2.931936, -3.256911, -0.003910, -3.611796, 1.618642, -1.823174, 2.107212, 
	-0.441901, 0.349753, -1.849220, 2.797524, 4.353435, -0.057898, 0.958161, -0.395531, -0.127480, -1.211081, 3.631299, -0.066063, -2.488519, -1.943712, -1.202852, -2.305914, 
	-0.030463, -0.007279, -2.564811, 0.632175, 1.990779, -0.002830, -4.521070, -0.058764, -0.008330, 1.607566, -0.146010, -0.003292, 2.723902, -1.639297, 2.087920, -0.060195, 
	-0.007422, -0.004156, -0.579038, -0.594706, -0.481116, -0.001410, -1.953863, -0.010256, -0.003047, -0.261771, -1.558069, -0.001372, 2.563920, 3.486254, -0.569441, -0.024507, 
	-0.033672, -0.013291, 5.246942, -0.216961, -2.351342, -0.001948, -0.285284, -0.028333, -0.007503, -3.273411, 4.999055, -0.006711, -2.402294, 0.590656, -1.931526, -0.284377, 
	1.431423, -0.776237, 2.090206, 3.972594, 1.088241, -0.337364, -0.276503, -1.299701, -0.662993, -0.095221, -3.207231, -0.720613, -2.406283, 2.940133, -0.926542, -0.813910, 
	-0.007601, -0.007455, -1.423252, -3.980852, 0.222237, -0.001835, 2.133251, -0.006328, -0.003862, 2.883828, -0.025200, -0.001893, -2.696460, 1.424587, 1.893606, -0.402771, 
	-0.004990, -0.002105, 2.386974, -1.210834, -0.448868, -0.000863, 4.542473, -0.004344, -0.002048, -1.825859, -2.660389, -0.000757, -0.256842, -0.026379, -0.470802, -0.014366, 
	-0.159870, -0.083722, 0.861067, 0.540167, 0.638375, -0.024825, 0.583086, -0.100991, -0.051402, -1.741454, 3.815925, -0.031465, -4.891116, -4.588656, 4.390691, 0.844189, 
	-0.443613, 0.181166, -0.689481, 1.983181, -3.832608, -0.048799, -0.972243, -0.367087, -0.119454, -0.998654, 0.834644, -0.053662, 5.766187, -1.273869, 1.715568, -1.681276, 
	-0.015737, -0.006244, -0.043722, 0.281051, 0.109891, -0.001677, -2.743710, -0.008506, -0.004192, -0.777918, 2.876167, -0.001779, 0.140940, 0.249100, -0.015163, -0.038499, 
	-0.003758, -0.001996, -1.448569, -0.873657, -0.170837, -0.000542, 1.767740, -0.003375, -0.001263, 1.721589, 1.612056, -0.000584, -2.670093, 0.186129, -0.094842, -0.017996, 
	-0.012028, -0.008746, -2.032589, -1.426465, -0.943859, -0.002864, 1.480894, -0.007298, -0.005246, 7.259459, -0.669776, -0.002969, -4.242787, 2.123007, -1.353166, -0.155566, 
	-0.013890, -0.006512, -1.047591, -1.178742, -1.753386, -0.002687, -2.188868, -0.007902, -0.004802, 0.227401, -1.495767, -0.002830, 5.167694, 2.760849, -0.253592, -0.199373, 
	-0.026605, -0.007974, -1.201608, 0.484259, -0.083406, -0.001995, -4.189837, -0.012013, -0.005361, -0.007882, 1.459714, -0.002069, 3.547600, 0.070191, 0.215511, -0.238525, 
	-0.015367, -0.009657, 0.531361, 0.619905, 0.753282, -0.001981, 1.296693, -0.011824, -0.005523, 0.471750, -2.812144, -0.002148, 0.884821, -0.711690, -0.816104, -0.171373, 
	-0.010345, -0.006017, 0.046501, 1.314828, -2.108688, -0.002176, -1.649677, -0.010078, -0.004612, 0.924671, -1.239861, -0.002293, 1.703770, 0.226792, 0.926090, -0.108904, 
	-0.008464, -0.010673, -0.174116, -0.599031, -1.490661, -0.003076, 2.724550, -0.005321, -0.004506, -0.016166, 0.443858, -0.003077, -2.771351, 1.242745, 0.682281, -0.006991, 
	-0.024559, -0.012377, 1.434813, 0.826859, 2.195836, -0.008119, -3.855881, -0.013803, -0.007770, 2.035953, -2.975061, -0.008350, 1.361516, -0.979025, -1.162892, 1.192858, 
	-0.019005, -0.014489, -0.455217, 0.254954, 0.800197, -0.002477, 1.743024, -0.019861, -0.007052, -1.507434, -2.155721, -0.002646, -0.733666, 3.555645, -2.086061, 0.649810, 
	-0.054144, -0.017609, -1.000670, 1.396434, -1.322409, -0.008512, -1.138567, -0.090863, 0.555166, -0.665511, 1.215845, -0.008711, -2.499299, 0.890601, 2.914697, -0.166448, 
	-0.002177, -0.001349, 1.238022, 0.690339, -1.670315, -0.000497, -0.514185, -0.001418, -0.000929, 0.334610, -0.052141, -0.000554, 1.575837, -1.379866, -0.193741, -0.021635, 
	-0.008288, -0.006570, -0.018849, 1.317093, 0.622777, -0.001698, 5.111219, -0.005190, -0.003745, 0.707815, -5.309014, -0.001845, -0.193881, -0.397672, -1.590078, -0.222072, 
	-0.169534, -0.058803, -1.584277, 4.259752, -0.360159, -0.026967, 2.276674, -0.112147, -0.043129, -1.672320, -2.803789, -0.027711, -0.807614, -1.416745, 1.674642, 0.872127, 
	-0.003967, -0.003312, -1.687769, -0.576826, -0.546150, -0.001743, 0.644816, -0.004166, -0.002717, 1.287645, 1.569230, -0.001784, 0.586073, -0.560579, -0.668666, -0.030083, 
	-0.006315, -0.003794, -0.830715, -0.201591, 1.336827, -0.001243, 1.384332, -0.007651, -0.002755, -0.516118, -0.710061, -0.001311, -0.453619, -1.276686, 1.489592, -0.198893, 
	-0.011707, -0.004002, -0.126982, 0.535782, -1.764701, -0.001484, 1.039312, -0.008214, -0.003055, 0.131435, -3.866252, -0.001555, 0.230659, 1.328635, 2.573179, -0.051049, 
	-0.002072, -0.001887, 2.009592, 0.418807, -0.009152, -0.001001, 0.104646, -0.001692, -0.001476, -0.841034, 0.908906, -0.001018, -1.149594, -0.713811, -0.705521, -0.013694, 
	-0.007097, -0.005538, 0.104252, 0.813255, 0.045181, -0.001775, 0.116297, -0.005366, -0.003536, -0.027960, 1.181662, -0.001773, -1.496450, -0.586356, -0.128008, 0.003213, 
	-0.218963, -0.018798, 7.546469, -1.488413, -0.605246, -0.006425, -1.913046, -0.045933, -0.015710, -0.375082, 0.295949, -0.011302, -2.609424, 1.603593, -1.878348, -0.259321, 
	-0.009869, -0.003025, -0.067103, 0.503049, -1.814215, -0.002077, 6.025714, -0.009862, -0.003675, -0.595525, 1.242529, -0.006541, -4.660101, -0.631169, 0.082220, -0.050350, 
	-0.006518, -0.003819, 0.814406, 0.992190, -1.443018, -0.000980, -0.185463, -0.003679, -0.001995, -0.996369, -0.169724, -0.001031, 0.759442, -2.235285, 2.431604, 0.050239, 
	-0.046020, -0.023268, -0.075137, 0.788002, -0.056352, -0.005051, -0.887729, -0.025236, -0.013728, -1.862962, 2.172243, -0.005367, 2.888009, -0.777409, -1.726668, -0.343326, 
	-0.035807, -0.010756, 0.201361, -3.137602, -2.798036, -0.001538, 1.473980, -0.017576, -0.006482, -1.191792, 3.001326, -0.001883, 3.843260, -1.503382, 0.291518, -0.106590, 
	-0.019111, 0.667555, -0.833373, -1.338410, -0.114724, -0.002814, 1.319976, -0.644085, -0.004840, 0.939784, -2.185361, -0.002995, 0.340283, 2.529462, -0.627234, -0.024113, 
	-0.001504, -0.000837, -0.124893, 0.137619, -0.053158, -0.000233, -0.138716, -0.000573, -0.000387, -0.135481, 0.006749, -0.000241, -0.032931, 0.131035, 0.234318, -0.020769, 
	-0.023204, -0.007874, 0.164173, 0.370235, 2.209896, -0.003445, -3.999886, -0.025991, -0.006498, -0.767323, 1.439383, -0.003688, 1.703565, -2.409785, 1.457284, -0.096840, 
	-0.010446, -0.011231, -1.057059, 1.854041, 3.609420, -0.001820, -0.484201, -0.009097, -0.004863, -0.121726, 2.557209, -0.001940, -4.298198, -1.210396, -0.755336, -0.054358, 
	2.275867, -0.012176, -1.665167, 4.855751, -2.939954, -0.003417, -2.734334, -0.011970, -0.007430, -2.005166, -2.950447, -0.003841, 5.091498, -1.626549, 1.884671, -0.147334, 
	-0.002718, 0.363208, -0.154699, 0.272166, -0.644999, -0.000791, 0.455668, -0.201291, -0.003443, -0.517720, -1.451150, -0.000937, 2.231290, -0.247593, -0.088503, -0.008488, 
	-0.993775, -0.444722, -6.247944, -11.213655, -2.687280, -0.145210, 11.122340, -0.563116, -0.276010, -9.508726, 10.259665, -0.170472, 9.552246, 2.432506, -0.643424, -0.472423, 
	-0.032199, -0.004267, -0.498192, 0.606864, 2.444655, -0.001299, 1.687305, -0.004231, -0.002531, -0.670890, -5.348201, -0.001350, 1.652277, 0.544279, -0.355533, -0.016687, 
	-0.042539, 0.388297, 2.722656, -1.282935, 0.725719, -0.001536, -0.685181, -0.015463, -0.002534, -1.254065, 1.127105, -0.001591, -1.633592, -0.498243, 0.489788, -0.035886, 
	-0.024444, -0.007151, -0.585867, -0.817568, 0.418120, -0.001338, 4.180698, -0.004669, -0.003237, -0.198610, -1.951131, -0.001419, 0.034886, -0.378630, -0.601199, -0.058442, 
	-0.603686, -0.237344, -3.377645, -4.516893, -12.013351, -0.105649, 12.355157, -0.307754, -0.165822, -10.175381, 15.733088, -0.122528, 8.573750, -9.014424, -1.220481, 5.198964, 
	-0.006530, -0.006042, 0.273492, -0.853942, -1.106083, -0.000740, 0.993240, -0.013818, -0.003285, 1.622847, -1.880247, -0.000939, 2.068461, -0.544118, -0.522075, -0.020219, 
	-0.077397, -0.030806, -2.153245, 0.820968, -0.428073, -0.006071, -0.751297, -0.080268, -0.017818, 1.741907, -2.675813, -0.006679, 4.842825, -1.679583, 0.636474, -0.135124, 
	-0.061093, -0.020268, -3.442460, -2.797000, 6.238063, -0.004523, 0.163776, -0.034178, -0.011469, -2.606969, 4.594300, -0.004952, -0.954017, 1.605410, -2.508680, -0.155941, 
	-0.004625, -0.005925, 0.120296, -0.420292, 0.580517, -0.001994, 1.671726, -0.005215, -0.003759, 1.820198, -1.454562, -0.002082, 0.076083, -2.207197, -0.141159, -0.022011, 
	-0.009503, -0.004665, 0.383101, -1.983725, 2.312416, -0.001304, 2.996986, -0.006533, -0.003009, -1.123675, -3.799033, -0.001286, 0.305189, 0.162185, 0.815347, -0.042492, 
	-0.009256, -0.006643, 1.452878, -0.687427, 1.312255, -0.001883, -2.955737, -0.011190, -0.004158, -0.451137, 0.748635, -0.002074, 1.493840, -0.563915, -0.259011, -0.055177, 
	-0.018119, -0.013433, -1.771770, -0.655557, -1.086880, -0.002346, -2.787613, -0.012964, -0.006705, -1.500933, 4.975634, -0.002616, 0.249573, 0.793831, 1.503526, 0.336372, 
	-0.009225, -0.004250, -0.304592, -0.189617, -0.916759, -0.001062, 0.688833, -0.047063, -0.006136, -2.015659, 1.441245, -0.003554, 0.230367, 0.750601, 0.430962, -0.044090, 
	-0.042299, -0.017174, 0.879598, -1.196084, 1.293278, -0.002893, -2.059836, -0.017287, -0.007964, 2.762507, 6.907275, -0.003308, -6.986715, -1.142463, -0.055452, -0.311182, 
	-0.007382, -0.003498, -0.570294, -0.966048, -0.058775, -0.001052, -0.295253, -0.002924, -0.002111, 1.901683, -0.468791, -0.001081, 0.523053, -0.359956, 0.361059, -0.048631, 
	-0.078311, -0.031798, -1.265210, -4.135734, 8.653445, -0.012211, 7.061931, -0.060186, -0.023825, -2.984092, -12.445214, -0.012643, 6.752846, -2.497876, 0.625517, 0.453362, 
	-0.021778, -0.009623, 0.091658, -2.493042, -0.148043, -0.003072, -3.937476, -0.029853, -0.007004, -5.166179, 2.618973, -0.003259, 5.964386, 4.443402, -1.236602, -0.062492, 
	-0.009945, -0.003032, -0.215704, 3.593088, 0.753183, -0.000841, 1.063982, -0.004544, -0.002102, 0.901238, -2.852363, -0.000909, -1.326599, -1.108561, -0.757641, -0.029251, 
	-0.008087, -0.003925, 0.128900, 0.458929, -0.810368, -0.001649, 1.309850, -0.004051, -0.002824, 0.588916, 3.912646, -0.001613, -4.438186, -0.846996, -0.180262, -0.101278, 
	-0.008805, -0.001334, -0.145992, 0.311210, 0.165612, -0.000373, 0.175978, -0.002582, -0.000776, -0.216290, -0.544440, -0.000390, 0.152243, 0.404873, -0.255125, -0.033808, 
	-0.822977, -0.338554, -1.716161, 3.415172, 0.763891, -0.122363, -2.844745, -0.551433, -0.237600, 0.833327, 0.710987, -0.063844, -1.850648, 1.246990, 3.609364, -2.031407, 
	-0.052411, -0.029732, -0.597547, 2.872077, -0.980559, -0.011618, -3.384950, -0.039774, -0.018004, -0.202730, 2.489530, -0.012533, -0.947786, -2.316102, 2.696842, 0.535296, 
	-0.001562, -0.005446, -0.884288, -1.233182, -1.628317, -0.000450, -0.435991, -0.003790, -0.002447, 1.323537, -0.808831, -0.000564, 0.528619, 3.625627, -0.352858, -0.120056, 
	-0.014877, -0.003436, -0.972362, 4.806794, -1.979918, -0.001320, 0.400838, -0.006628, -0.002765, -1.551502, -1.629905, -0.001294, 0.889050, -0.280352, 0.373471, -0.025792, 
	-0.006688, 0.852031, -0.472435, 0.248358, 1.028872, -0.002384, -1.007323, -0.832259, -0.003945, -1.702762, -1.237228, -0.002429, 1.776734, 1.841971, -0.452817, -0.027696, 
	-0.027515, -0.009512, -0.642266, 1.374833, 2.226935, -0.003682, -0.916077, -0.018373, -0.006777, -3.010935, 1.602499, -0.003874, -2.155749, 3.127116, -1.442094, -0.094531, 
	-0.009703, -0.003602, 1.107045, -2.929131, 4.275358, -0.001881, -1.350346, -0.005500, -0.002762, 0.584110, 0.185509, -0.001922, -1.884857, 0.028298, 0.022743, -0.013359, 
	-0.001151, -0.001411, 0.885834, 1.037329, -0.523359, -0.000697, 0.051619, -0.001046, -0.001035, -0.949053, -0.295433, -0.000702, 0.031509, -0.023311, -0.204517, -0.004577, 
	-0.005341, -0.003051, 0.701759, 0.450780, -1.356278, -0.001064, 2.304385, -0.003897, -0.001820, -0.493177, -0.215534, -0.001126, -1.670249, -0.054209, 0.398505, -0.049681, 
	-0.005668, -0.002417, 0.641187, -1.058217, -0.923076, -0.000835, 0.478361, -0.008252, 0.001129, 0.341364, -0.274022, -0.000826, -1.554156, -0.223051, 2.635691, -0.047211, 
	-0.144080, -0.108544, -2.273371, -4.583364, 0.114280, -0.008274, 5.156903, -0.033570, -0.032948, 1.288216, -3.893013, -0.009300, 1.296516, 4.439487, -3.796364, 2.587427, 
	-0.027322, -0.011040, 0.467227, 4.765302, 2.804011, -0.004043, -7.677009, -0.059763, -0.010886, 1.282180, -2.604429, -0.006659, 1.784184, 0.420120, -1.087159, -0.034714, 
	-0.012309, -0.009005, -1.613897, 2.884471, -0.251418, -0.001868, 0.776456, -0.006051, -0.004056, -0.337410, -0.319138, -0.001972, -2.818110, -0.075178, 1.901903, -0.112418, 
	-0.022828, -0.003412, 0.928999, -0.919244, -0.523865, -0.001165, 1.069699, -0.002838, -0.002359, 1.912079, -2.222039, -0.001209, -0.083342, -0.404379, 0.312696, -0.036793, 
	-0.002525, 0.004985, -0.569528, -0.738523, -0.548690, -0.000965, -3.565454, -0.026779, -0.002736, 3.249776, 4.015452, -0.001024, -0.472555, -0.677642, -0.594856, -0.068937, 
	-0.011046, -0.001778, 0.699431, -0.715810, -0.162049, -0.001005, -0.565032, -0.007213, -0.001506, -1.212156, 0.203283, -0.001012, -0.555179, 1.763606, 0.598291, -0.030824, 
	-0.006925, -0.003470, -0.681111, -1.104837, -0.914348, -0.001577, 3.817310, -0.007133, -0.002752, -0.636749, -2.883285, -0.001634, 0.155169, 3.119421, -0.775129, -0.072949, 
	-0.000899, -0.000270, -0.266089, -0.321485, 0.352103, -0.000113, -0.587875, -0.002227, -0.000237, 0.239006, 0.776015, -0.000124, -0.341378, 0.137850, 0.019506, -0.003786, 
	-0.004958, -0.003526, 0.871705, 2.163536, -0.109253, -0.001106, -1.286992, -0.004136, -0.002255, -1.469742, -1.050653, -0.001104, 2.217311, -0.848349, -0.333632, -0.136847, 
	-0.011203, -0.010958, -0.140283, -0.211472, 2.500028, -0.003116, -2.261891, -0.006917, -0.005482, -1.872763, -0.734791, -0.003306, 0.098093, -0.517951, 3.226988, -0.044976, 
	-0.007005, -0.003632, -1.812637, 0.801399, -1.654102, -0.002577, -0.784307, -0.003978, -0.003262, 5.550758, 0.381052, -0.002629, -1.004819, -0.417088, -1.016798, -0.020376, 
	-0.007434, -0.005892, -1.025884, -0.914959, -0.650203, -0.000890, 0.300754, -0.013793, -0.003449, -0.326875, -0.875529, 0.047804, 0.763800, -0.859083, 3.794436, -0.222803, 
	-0.013546, 1.207972, 0.833990, 1.146284, 0.233985, -0.001851, -2.199422, -1.209656, -0.003886, -1.043785, 1.881084, -0.001462, -1.003956, -0.718551, 0.964437, -0.071637, 
	-0.010037, -0.005527, -0.588566, 3.854277, -0.032162, -0.001052, -1.099415, -0.007727, -0.003626, -4.183409, -1.038108, -0.001064, 1.464112, 2.580058, -0.822530, -0.105226, 
	-0.009949, -0.001859, 1.331788, -1.126526, -1.932189, -0.000751, 2.459027, -0.018329, -0.001495, -0.549160, -2.358317, -0.000769, 2.448921, -0.103196, -0.113517, -0.023679, 
	-0.011984, -0.003567, 1.566762, -0.456340, 0.836477, -0.000870, -0.888234, -0.002616, -0.001746, 0.127078, -1.296643, -0.000852, 0.559621, -1.154647, 0.783859, -0.056298, 
	-0.017496, 0.008140, 1.288339, 1.357981, -0.564126, -0.002025, 2.917709, -0.020375, -0.004153, -1.542612, -2.088675, -0.002132, -1.508858, 1.187167, -0.626452, -0.382431, 
	-0.016219, -0.006605, 5.128505, -1.472183, -2.282380, -0.002331, 0.361463, -0.010602, -0.005571, 0.892458, -1.992239, -0.002421, 3.899520, -2.167759, -2.254921, -0.068714, 
	-0.025026, -0.003053, -1.539988, 2.051679, -1.554426, -0.002550, -1.074302, -0.004901, -0.002462, -0.093435, -3.127870, -0.002733, 2.020322, 2.295589, 1.113326, -0.050171, 
	-0.064521, -0.023490, -1.611574, -3.028845, 5.288982, -0.005938, -2.275592, -0.030901, -0.014074, -1.910707, 0.655926, -0.010777, -2.268912, 7.256668, -1.643445, -0.312799, 
	-0.027256, 0.379696, -0.394061, -1.907408, 6.231265, -0.004314, -0.278934, -0.042472, -0.008928, -1.323936, 0.117582, -0.004612, -0.557362, -0.886553, -1.177013, -0.115694, 
	-0.048860, -0.014732, 1.055931, 0.336990, -2.744183, -0.003926, -3.410134, -0.037728, -0.009585, 1.949487, -2.739307, -0.004250, 4.973790, -0.812859, 1.067310, 0.442055, 
	-0.010263, -0.007806, -0.991707, 1.159418, -0.307581, -0.001506, 0.911208, -0.009405, -0.004069, -1.801007, -0.217711, -0.001631, -0.096852, 1.184896, 0.289674, -0.095656, 
	-0.002483, -0.002520, 1.835963, 0.715086, -0.925598, -0.000873, -0.051552, -0.005311, -0.002126, -0.795030, -0.590388, -0.000894, 0.743709, -0.403877, -0.492236, -0.021869, 
	-0.004637, -0.003752, -0.178457, 0.656620, -0.389021, -0.000641, 2.412964, -0.004987, -0.002139, 0.843816, -3.016355, -0.000683, 0.079866, -0.211241, -0.148447, -0.032906, 
	-0.017670, -0.005858, -3.628414, -0.128475, 1.133309, -0.002168, 3.842811, -0.007869, -0.004059, 3.738038, -4.878733, -0.002269, 0.448966, 0.359647, -0.907944, 0.060688, 
	-0.008595, -0.003679, 0.389172, -1.608086, -1.906125, -0.000748, 3.385426, -0.018720, -0.001761, -0.424640, 0.153857, -0.000800, -0.965136, -0.198075, 1.324743, -0.116835, 
	-0.004455, -0.004952, -1.372437, 0.322469, -3.161856, -0.001368, -0.434977, -0.018740, -0.004956, 0.168629, -1.010268, -0.001448, 3.606277, 0.970532, 1.020591, -0.073038, 
	-0.034134, -0.007771, 0.310475, -0.528449, 0.926226, -0.002842, 3.910269, -0.014659, -0.005349, -1.128671, -1.807930, -0.003098, -0.569656, -0.420917, -0.437863, -0.185630, 
	-0.045905, -0.019487, -2.004585, -3.995748, -2.755651, -0.005596, 1.537488, -0.017283, -0.010446, 2.055299, 2.215392, -0.005643, 3.457709, 0.099110, -0.060335, -0.444320, 
	-0.082069, -0.011755, 3.885071, -2.941308, -2.118223, -0.004205, 1.568965, -0.012816, -0.007766, 0.589558, -2.025559, -0.004413, 4.449479, -1.488215, -1.661412, -0.135332, 
	-0.003686, -0.002207, 0.202732, 0.940861, 2.933406, -0.001066, -1.257123, -0.002748, -0.001607, 0.132664, -1.423805, -0.001093, -0.904395, -0.566214, -0.002331, -0.043389, 
	-0.004683, -0.004275, -0.421180, -0.560566, 0.605928, -0.000869, -1.493547, -0.008782, -0.002932, 1.799075, -1.024167, -0.000962, 1.087411, -0.088992, 0.146082, -0.027542, 
	-0.009236, -0.004226, -0.667983, 3.956848, -2.329251, -0.001533, 0.762069, -0.005485, -0.003084, 0.630823, 2.818109, -0.001625, -4.243978, -0.282902, -0.577315, -0.041231, 
	-0.050408, -0.011168, -1.861138, -0.554656, -0.724242, -0.002531, -1.480861, -0.010605, -0.006500, -0.379388, 2.386192, -0.003017, 4.745498, -0.627434, -1.336275, -0.083466, 
	-0.006390, -0.003634, -0.241163, -0.179680, -1.568413, -0.001574, -1.633575, -0.004276, -0.002860, -0.230110, -0.380456, 0.023069, 4.348955, -0.363643, 0.256048, -0.012297, 
	-0.015707, -0.019115, 0.279140, 2.296636, -1.097979, -0.012059, -2.109030, -0.126152, 0.784154, -0.417113, -1.203707, -0.012215, 2.497550, -0.732320, -0.090584, -0.021498, 
	-0.010015, -0.005687, 0.579501, -0.604885, -0.705587, -0.000636, 2.547188, -0.003192, -0.002133, -1.409361, 2.884555, -0.000695, -2.536492, -0.224552, -0.384100, -0.123910, 
	-0.002532, -0.005617, -0.640016, 0.083089, -0.548381, -0.000860, 1.840255, -0.004220, -0.003799, -0.499633, 1.690245, -0.000907, -3.389123, 1.820237, -0.284976, -0.053760, 
	-0.009540, -0.002570, 1.420124, 2.438184, 0.626273, -0.001425, 0.648571, -0.003536, -0.002309, -1.509468, -3.627687, -0.001454, 0.459570, -0.116831, -0.302852, -0.015051, 
	-0.038108, -0.011900, 3.394106, 2.676373, 1.429828, -0.002879, 0.143054, -0.020719, -0.008680, -5.410723, -3.256519, -0.003100, 1.464549, 0.308986, -0.474030, -0.190239, 
	-0.005527, -0.004068, -0.613533, -1.617143, -0.637726, -0.001095, -0.812729, -0.007460, -0.003061, 4.005402, -1.974644, -0.001168, 1.029926, 0.869084, -0.215589, -0.010670, 
	-0.021073, -0.009835, 4.664906, 0.545814, -1.955724, -0.001893, -0.169859, -0.034463, -0.006270, -1.527825, 4.007367, -0.002230, -3.335758, -1.785576, -0.317511, -0.050069, 
	-0.118408, -0.012592, 0.205788, 3.748468, -0.741435, -0.004036, -4.640129, -0.017185, -0.008106, 0.070401, 2.069315, -0.008690, -0.782267, -0.258386, 0.656779, -0.159519, 
	-0.008888, -0.002297, 0.560630, -0.204034, 1.511197, -0.000751, -1.352897, -0.011408, -0.002063, -2.229048, 0.211419, -0.000808, -1.244818, 3.212337, -0.413704, -0.024868, 
	-0.012470, -0.008387, 0.291229, 0.097899, -1.838577, -0.003285, 3.337912, -0.006356, -0.004984, 0.531572, -6.529897, -0.003368, 6.364979, -2.558545, 0.414272, -0.071991, 
	-0.120064, -0.013333, 1.249398, -1.158762, 1.460584, -0.005969, 5.143847, -0.031276, 0.075836, -1.218019, 0.778623, -0.006126, -5.286752, -1.816069, 1.024036, -0.075953, 
	-0.000536, -0.000534, -0.170611, -0.362429, -0.553908, -0.000125, -0.500294, -0.000866, -0.000342, 1.074774, -0.822896, -0.000132, 1.505566, -0.021331, -0.143261, -0.003075, 
	-0.006738, -0.005324, -0.305898, -0.926142, -3.625552, -0.001617, 0.070191, -0.003470, -0.002687, 2.132391, -1.864685, -0.001677, 5.174457, -0.342724, -0.214627, -0.075897, 
	-0.000765, -0.000462, 1.129643, -0.109844, 0.018290, -0.000200, -0.099265, -0.000436, -0.000335, -0.276479, -0.056345, -0.000207, 0.014778, -0.736687, 0.123091, -0.004776, 
	-0.006899, 1.215127, -0.102241, 0.855598, 0.631884, -0.004113, -0.697789, -1.062966, -0.039878, -0.465748, 0.442836, -0.004134, -0.920248, -0.610793, 0.799268, -0.029904, 
	-0.013114, -0.011532, -2.379792, 1.260562, -1.205464, -0.008232, -0.765455, -0.016584, -0.010098, -1.449087, -0.204640, -0.008311, -1.631475, 7.450954, -0.898965, -0.108767, 
	1.705440, 0.238833, 1.159689, -1.099572, -3.101326, 0.142970, -2.701591, -0.769801, -0.117502, 5.104971, 4.371354, -0.184032, -0.470649, -3.893707, 1.731727, -2.116804, 
	-0.063942, -0.018482, -0.956952, 4.252805, -0.084440, -0.004933, 4.489052, -0.035131, -0.011249, -1.626051, -2.366059, -0.012417, 2.028926, -4.044866, -1.302335, -0.243927, 
	-0.030543, -0.011348, -2.299142, 0.185004, -0.900412, -0.002756, 5.725377, -0.008832, -0.006065, -0.860370, 3.174422, -0.002869, -4.652557, -0.283944, -0.693720, 0.667754, 
	-0.007946, -0.004192, -0.629556, -1.077103, 1.107878, -0.000769, -0.534178, -0.002761, -0.001942, 1.372143, 0.346551, -0.000900, 0.074590, -0.820381, 0.255985, -0.077421, 
	-0.040887, -0.004680, 4.276946, -3.381138, 0.564947, -0.006900, -0.653861, -0.038708, -0.013153, -0.206116, -2.878553, -0.007227, 7.900241, -3.799610, -1.479636, -0.231663, 
	-0.085263, -0.054942, 5.717066, 4.768610, 2.832905, -0.013423, 3.507928, -0.064515, -0.030472, -2.530037, -0.887630, -0.014435, -6.455360, -2.300318, -3.019356, -1.370760, 
	-0.048389, -0.026070, -2.356550, -1.188569, 2.793514, -0.005345, 2.489214, -0.040999, -0.014884, -2.619456, 1.991554, -0.005941, 1.391434, -0.407860, -1.695101, -0.256552, 
	-0.091991, -0.018019, 2.031210, 4.834777, -1.554741, -0.004490, 0.386053, -0.021268, -0.010135, -2.841093, -4.328886, -0.004913, 3.902941, -0.832072, -1.651104, 0.203729, 
	0.001227, -0.001575, -0.076720, -0.132634, 0.375382, -0.001037, -1.754204, -0.001846, -0.000966, -0.187564, 2.750972, -0.001073, -1.495202, 0.625593, -0.090876, -0.009477, 
	-0.054923, -0.023667, -2.039778, 3.128552, -2.964645, -0.009452, 8.182374, -0.042427, -0.018162, -0.127456, 3.446575, -0.009946, -4.828147, -0.029139, -4.440598, -0.169161, 
	2.271472, -0.023501, 0.285543, -0.572471, 2.300795, -0.003624, -1.965845, -0.040532, -0.013199, -1.482657, 0.561297, -0.004013, -3.064409, 1.082686, -0.763407, 1.431865, 
	-0.015886, 2.029788, -0.197536, -1.968335, 8.869392, -0.003917, -1.831640, -2.003401, -0.006024, -0.477033, -0.006909, -0.004311, -5.616160, -0.932266, 2.390950, -0.226713, 
	-0.044556, -0.039089, -1.485625, 2.484483, -0.059328, -0.006883, 1.658157, -0.031530, -0.024406, -2.363306, -1.798684, -0.007557, 0.770499, 0.729761, 0.223043, -0.004980, 
	-0.015406, -0.005618, 0.047552, 0.499077, -2.098762, -0.002426, -2.283817, -0.026595, -0.004996, -0.386082, 0.213945, -0.002584, 0.042824, 1.905417, 2.313379, -0.195908, 
	-0.026765, -0.014439, -3.295251, -0.696541, 1.527379, -0.003122, -0.072871, -0.067552, -0.013404, -3.900733, 2.612320, -0.004865, -0.721724, 3.048698, 1.783888, -0.155018, 
	-0.009100, -0.012600, -1.030030, 0.122830, -0.729921, -0.001697, -1.393489, -0.009175, -0.005626, 4.603004, -0.231188, -0.001866, -0.304429, -0.176235, -0.750449, -0.070027, 
	-0.100314, -0.060605, -0.073255, -0.169081, -0.182743, -0.010642, 2.899398, -0.413675, -0.033079, -2.558010, 0.164261, -0.011848, 4.933151, -3.848513, 0.058765, -0.593808, 
	-0.035452, -0.004031, 1.893208, 0.382454, -0.596428, -0.000805, -0.758300, -0.004772, -0.002199, -0.027333, 2.881876, -0.000877, -2.680195, -0.258260, -0.733884, -0.055002, 
	-0.124782, 0.332840, -0.511205, 0.195150, 3.704858, -0.011474, 1.457217, -0.101478, -0.030811, -3.236696, 1.989619, -0.012656, -1.093454, 2.994429, -4.886537, -0.665019, 
	-0.004118, -0.002148, 0.401093, 2.259120, -0.365871, -0.001021, -0.231460, -0.010556, -0.001667, -1.291469, -0.776450, -0.001049, 0.881653, -0.930987, 0.173246, -0.098317, 
	-0.134232, -0.041847, -2.784220, 1.354270, 1.084099, -0.013382, -0.818744, -0.079500, -0.027149, 1.237203, 3.938253, -0.023268, -3.614085, -1.233752, 1.749081, -0.592728, 
	-0.052829, -0.036744, -0.966214, 1.222798, 1.855311, -0.004192, -0.990568, -0.035924, -0.014051, 1.427693, -1.158955, -0.004696, -2.476974, -0.022734, 1.805125, -0.547046, 
	-0.006788, -0.000936, -0.482062, -2.339154, 8.826301, -0.001852, -1.123350, -0.005549, -0.002483, -1.614693, 1.364696, -0.001850, -4.081998, -0.213925, -0.207552, -0.108804, 
	-0.090863, -0.019617, -0.763053, -0.545020, 0.963519, -0.010185, -2.909646, -0.057610, -0.014887, 0.167271, 2.408393, -0.010847, -0.179439, -2.336160, 3.592792, -0.194647, 
	-0.000700, -0.000179, 0.120646, 0.205711, -0.070513, -0.000134, -0.255819, -0.000274, -0.000171, -0.256086, 0.487417, -0.000136, -0.252685, -0.007323, 0.038477, -0.008232, 
	-0.005198, -0.003867, -0.511567, 1.690988, -0.308962, -0.001387, 2.351564, -0.020897, 0.133684, -0.126447, -1.829736, -0.001479, -0.615553, -1.083600, 0.362524, -0.030067, 
	-0.039926, -0.001153, -0.916761, 0.729161, 0.489153, -0.000402, 0.446784, -0.001200, -0.000705, 0.120385, -0.548784, -0.000416, -0.021407, -0.172218, -0.061657, -0.020854, 
	-0.018600, -0.011314, -0.871742, -1.219903, 2.672226, -0.002074, -3.037983, -0.009620, -0.005231, -1.048673, -0.162536, -0.002513, 3.946454, 1.224903, -1.396870, -0.056524, 
	-0.146624, -0.068839, -1.796496, 1.920268, 12.117084, -0.013547, 0.754448, -0.099535, -0.044447, -3.254216, -4.014945, -0.014837, -4.037767, 2.332300, -2.448547, -1.184299, 
	-0.002816, -0.001638, 0.803418, -0.490090, 0.397460, -0.000645, 0.748343, -0.003932, -0.001433, -0.939065, -0.537365, -0.000678, -0.984705, -0.696086, 1.727169, -0.017934, 
	-0.047512, -0.016718, 2.142622, -1.741776, -1.698702, -0.004555, 1.012460, -0.033018, -0.010871, 0.333414, 1.665250, -0.004900, -3.372825, -0.391239, 0.591069, 1.577301, 
	-0.012432, 0.235593, -0.432612, 3.032929, -0.087943, -0.004544, 3.509462, -0.083415, -0.005889, -0.990097, -0.362212, -0.004205, -3.962985, -0.766573, -1.120749, 1.055672, 
	-0.024350, -0.002242, -0.212116, 0.202094, -1.528158, -0.000637, -0.522226, -0.002045, -0.001265, 1.158657, 2.317408, -0.000715, -0.956232, -0.120923, -0.301490, -0.005759, 
	-0.018748, -0.010561, -2.637252, 1.046190, 0.429196, -0.003661, 1.918630, -0.017035, -0.007685, -0.064706, 2.257451, -0.003841, -2.026049, 0.036507, -0.488857, -0.409580, 
	-0.009080, -0.012354, -0.589779, 0.163657, -1.642526, -0.002688, -0.850630, -0.011551, -0.006688, 2.355669, -6.793646, -0.002877, 6.721540, 0.040648, 0.845431, -0.205128, 
	-0.023405, -0.025884, 4.233759, 3.475157, -3.840900, -0.005563, -3.852069, -0.024887, -0.012619, 0.059512, 1.937042, -0.005971, -1.191887, -0.158877, -0.194305, -0.369104, 
	-0.068991, -0.022317, -1.746370, -0.206270, 1.666895, -0.007440, -2.649028, -0.034562, -0.016383, 0.008156, 1.926263, -0.007711, -2.555361, -1.944282, 6.179097, -0.521696, 
	3.509274, -0.669478, -1.687798, -0.908368, 5.665855, -0.219443, 4.291790, -0.925650, -0.430636, 0.252667, 0.256852, -0.621649, 4.465239, -5.526096, -3.050965, -4.401595, 
	-0.015845, -0.016509, -0.540423, -1.355563, -5.052195, -0.002068, 4.098237, -0.006767, -0.005222, 3.060389, -1.601812, -0.002153, 0.817585, 1.501324, -0.063689, -0.815290, 
	-0.016764, -0.003625, -0.722652, -0.023573, -0.898537, -0.000511, -0.409814, -0.008687, -0.002430, -0.432271, 0.105931, -0.000612, 1.407079, 0.462603, 0.679367, -0.135505, 
	-0.006952, -0.007543, -1.885777, 0.345593, -0.084150, -0.002150, -0.067197, -0.008580, -0.004157, 0.649284, -0.422107, -0.002167, -2.058973, 2.481785, 1.160235, -0.087145, 
	-0.091499, -0.028096, -2.072454, 8.992620, -0.203133, -0.007239, -2.648577, -0.038115, -0.017903, 5.434905, -5.714128, -0.007941, 2.539709, -3.014824, -2.033031, -1.090293, 
	-0.013413, -0.006619, -0.667268, -1.261996, 1.113624, -0.000979, -0.834666, -0.005783, -0.003411, -0.513240, 1.606208, -0.001107, -0.927584, 1.329233, 0.247156, -0.060154, 
	-0.011010, -0.018189, -0.512660, -4.529851, 1.213527, -0.003098, 1.485625, -0.009450, -0.007398, -1.009291, -0.224430, -0.003402, -2.635107, 4.263628, 2.153591, -0.152484, 
	-0.027968, -0.011350, 0.805951, -1.018685, -2.461808, -0.002878, -1.502549, -0.016513, -0.006679, -1.481578, 11.097885, -0.003548, -4.250044, 0.247331, -1.161033, -0.206535, 
	-0.004768, -0.002246, -1.222791, -0.259930, 0.289746, -0.000753, 0.362201, -0.002709, -0.001586, 1.660288, -2.924781, -0.000798, 1.825831, 0.726515, -0.372547, -0.071673, 
	-0.029662, -0.006198, -0.301937, -0.859540, 2.121001, -0.001924, -4.674282, -0.014882, -0.004294, 0.321679, 8.893114, -0.002061, -4.530906, -1.053252, 0.304202, -0.161057, 
	-0.005084, -0.003232, -0.443567, 2.608046, -0.931698, -0.001229, 0.801536, -0.004770, -0.002533, -0.860748, 0.829955, -0.001307, -2.004985, 0.208545, -0.159355, -0.029575, 
	-0.017354, -0.001438, -0.484767, 0.075778, 2.548779, -0.000734, 1.318469, -0.070275, -0.002305, -0.492030, 0.542336, -0.000822, -2.665962, -0.136523, -0.601252, -0.011899, 
	-0.002283, -0.001569, -1.023493, 1.394360, -0.135871, -0.000553, -2.540009, -0.001452, -0.000980, -0.794715, 2.120231, -0.000492, -1.504726, 2.673585, -0.170771, -0.011261, 
	-0.035126, -0.006509, 1.109011, -0.963128, 1.980569, -0.001537, -4.153224, -0.006802, -0.003996, 0.907305, -3.321374, -0.010444, 4.178296, -0.816450, 0.991211, 0.152199, 
	-0.120035, -0.075807, -1.198358, 2.995483, -4.246757, -0.021932, 2.288506, -0.139372, -0.054583, 1.326215, 1.456711, -0.028051, 0.330783, 0.075426, -1.659961, -0.928268, 
	-0.005532, -0.006347, -1.574856, -1.146448, -0.716273, -0.001610, 2.042352, -0.005145, -0.003332, 1.575887, -1.808735, -0.001684, -2.255744, -0.528188, 2.257088, 2.178567, 
	-0.073766, 3.585814, -0.544420, 2.117934, -0.700757, -0.010454, 4.824713, -3.489326, -0.030343, -1.667033, 2.316484, -0.011181, -4.030397, -0.765664, -0.976701, -0.544905, 
	-0.053392, -0.017773, -1.881845, -0.801875, -2.905480, -0.005555, -3.805777, -0.041681, -0.011900, -1.615922, 4.291252, -0.005857, 0.240068, 8.351589, -1.283373, -0.452480, 
	-0.109494, -0.049724, 0.064087, 5.620276, -2.301270, -0.009988, -0.932055, -0.055927, -0.027952, 2.234139, -1.812923, -0.017826, 0.058269, -1.602376, -0.538478, -0.518758, 
	-0.065236, 8.484220, -3.097538, 5.579015, -1.655701, -0.049661, -3.416371, -4.519482, -0.177483, -2.311249, 0.199300, -0.050266, -0.041998, -0.146123, 0.546629, 0.721944, 
	-0.003470, -0.004020, -0.867829, 1.990857, 0.305864, -0.001749, -0.523562, -0.011016, -0.003367, 1.167641, -0.542864, -0.001781, -0.764623, -0.467598, -0.237890, -0.034592, 
	-0.176224, -0.071697, -0.783201, 1.478715, 1.103896, -0.027063, -1.537246, -0.164650, -0.053587, -0.814694, 2.400983, -0.034134, 2.411504, 0.053019, -3.616833, -0.168787, 
	-0.008420, -0.009666, 0.032955, 0.903339, -0.487284, -0.001976, 1.006750, -0.013389, -0.005581, 0.675168, -0.221129, -0.002328, -0.635564, -0.033381, -0.993199, -0.206296, 
	-0.009068, -0.003789, 2.965871, 2.133094, -0.083098, -0.000587, -1.443491, -0.006389, -0.002368, -1.061869, 1.481219, -0.000703, -2.199405, -0.788588, -0.962248, -0.018584, 
	-0.005115, -0.003823, -1.802080, -2.216697, -0.236043, -0.000969, -2.383276, -0.004399, -0.002227, 2.312791, 0.059569, -0.001027, 2.976007, 1.472318, -0.048372, -0.116658, 
	-0.044560, -0.013036, 3.962065, -0.871550, -0.655241, -0.004167, 1.709521, -0.019630, -0.008142, -3.343484, 0.067579, -0.004341, 0.135060, 0.062745, -0.747589, -0.225227, 
	-0.012478, -0.005660, 2.681856, -1.584162, -0.560188, -0.002039, -0.680162, -0.005515, -0.003630, -0.160998, 0.288905, -0.002089, -2.612208, 1.190613, 0.742182, 0.725574, 
	-0.034600, -0.006306, 0.063813, -2.919411, -1.933901, -0.002141, 4.540473, -0.010617, -0.004675, 3.914283, -1.176247, -0.002227, -0.946558, -0.667525, -0.772300, -0.042061, 
	-1.150911, -0.687039, -1.326070, -1.432909, 1.839076, -0.231857, -0.531375, -0.812755, -0.444568, 3.004668, -2.242365, -0.179978, -1.634722, 1.832950, 0.146073, 3.851783, 
	-0.013092, -0.009046, 2.400667, -2.170378, 0.416913, -0.002562, -3.034797, -0.018865, -0.006640, 0.786169, 1.349434, -0.002691, -2.507859, -1.586097, 4.482974, -0.084129, 
	-0.002435, 0.621818, -0.060451, 0.993268, -0.331595, -0.001125, -0.317700, -0.602482, -0.001724, -0.231825, -0.401064, -0.001149, -0.244049, -0.128534, 0.728520, -0.019471, 
	-0.027467, -0.009500, 4.490859, 2.583159, -2.321151, -0.003238, 1.236121, -0.016099, -0.007221, -0.808982, -1.707639, -0.003376, 0.189973, -0.635481, -2.903773, -0.056186, 
	-0.021166, -0.015896, 0.135300, 0.324021, 4.135314, -0.002520, -0.142877, -0.040551, -0.005559, -0.220951, -4.637018, -0.002748, 2.284867, -1.952617, 0.274648, -0.112248, 
	-0.047178, -0.009113, 0.405124, -0.273540, -0.077811, -0.001237, 0.321806, -0.005620, -0.003548, -1.539193, -0.922864, -0.001338, 0.894451, 1.001936, 0.346670, -0.088546, 
	-0.001069, -0.001086, -0.313335, 0.312226, 0.735560, -0.000346, 0.920290, -0.002564, -0.000858, -0.092691, 0.076968, -0.000391, -1.361526, -0.203577, -0.052317, -0.015283, 
	-0.013437, -0.007536, -0.376925, 0.321062, -0.224320, -0.002624, -0.511333, -0.009397, -0.004124, -0.874848, 0.151728, -0.002706, -1.835516, -0.974998, 4.485295, -0.120321, 
	-0.060654, 0.217009, 2.804263, -0.053957, 0.441382, -0.005744, -1.831310, -0.111286, -0.012744, 2.946648, 1.430476, -0.005730, -0.169611, -5.206547, -1.052414, 0.670220, 
	-0.024352, -0.005955, -0.383856, -0.454977, -0.583288, -0.001022, 0.027635, -0.004112, -0.002939, -0.931663, 5.076358, -0.001153, -5.398470, 0.832415, 1.896146, -0.040766, 
	-0.144885, -0.023793, 1.899802, 0.735362, 2.325577, -0.008777, -1.736587, -0.019673, -0.014225, -2.988559, -3.047353, -0.009335, -3.179763, 0.877129, 5.527746, -0.192665, 
	-0.008794, -0.002033, -0.677229, -0.150533, -1.027232, -0.000862, -1.886389, -0.002158, -0.001516, -0.209289, 1.528730, -0.000885, 2.788453, -0.288468, -0.040948, -0.020848, 
	-0.025039, -0.011613, 3.227163, -1.712529, 1.589160, -0.003811, 1.489044, -0.030337, -0.007651, 2.444260, -5.111872, -0.004059, -0.085523, -2.084044, 0.492544, -0.165691, 
	-0.002268, -0.001973, 0.703792, -0.201540, 1.151099, -0.000746, 0.540304, -0.004803, -0.001521, -1.540074, -0.479441, -0.000805, -1.163955, 0.445338, 0.587688, -0.031095, 
	-0.022233, -0.003836, -0.345117, -0.427102, 1.041474, -0.001003, 1.953973, -0.003255, -0.001886, -0.972453, 0.105987, -0.001051, -1.749700, -0.138970, 0.621053, -0.055883, 
	-0.004105, -0.002793, -1.198943, -0.322117, 1.533552, -0.000894, -2.873456, -0.003428, -0.005676, 3.706110, -2.398202, -0.000867, 2.126172, -0.157936, -0.360411, -0.037005, 
	-0.031954, -0.005923, 1.164233, 0.313816, 0.542413, -0.003105, -2.047627, -0.152938, -0.008597, 1.240705, 1.985272, -0.003298, -1.801023, -0.344508, -0.560759, -0.286708, 
	-0.000428, -0.000460, 0.095551, 0.078298, -0.106942, -0.000224, -0.228885, -0.000544, -0.000371, -0.121960, -0.033601, -0.000214, 0.336802, -0.017406, 0.004029, -0.003647, 
	-0.022187, 0.706130, -0.383290, 3.292702, 0.503614, -0.003472, 0.141610, -0.687258, -0.006072, -1.571443, 1.351652, -0.003600, -3.302899, -1.584825, 1.744862, -0.175524, 
	-0.050393, -0.017717, -1.592733, -2.246939, -1.590259, -0.002996, -3.399082, -0.074664, -0.010453, 0.646752, 3.888280, -0.003768, 2.874436, -2.364535, 4.151147, -0.207076, 
	-0.006916, -0.005597, -0.343558, -0.060513, 2.764488, -0.000676, -2.734070, -0.002093, -0.001697, 0.104278, 1.483617, -0.000718, -1.920385, 0.018628, 0.736115, -0.030905, 
	-0.030681, 0.555888, -0.305952, 0.302508, 0.153897, -0.000375, -1.156375, -0.077089, -0.001062, -0.988103, 2.969613, -0.000394, -2.616848, 0.846273, 0.355615, -0.006914, 
	-0.040652, -0.007258, -0.918736, -0.016494, 5.622524, -0.002824, -0.370667, -0.010463, -0.005239, 0.627186, -0.977439, -0.003005, -1.797258, -1.753054, -0.300314, -0.046307, 
	-0.012200, -0.008471, -0.716455, -0.908717, -0.250204, -0.001181, -0.719186, -0.004810, -0.003023, 1.858053, 0.820779, -0.001132, 1.326643, -0.892506, -0.362172, -0.125419, 
	-0.006462, -0.005055, -0.030428, 3.137565, -0.741323, -0.000765, -1.691892, -0.010851, -0.003392, -0.668880, -0.642431, -0.000949, -0.248659, 2.342230, -1.404390, -0.024317, 
	-0.001610, -0.000868, -0.146315, -0.286383, 0.842410, -0.000442, -0.469944, -0.001038, -0.000702, 0.029597, -1.872479, -0.000439, 1.905107, -0.088416, 0.109725, -0.018203, 
	-0.030391, -0.019155, 2.967357, -1.075025, -1.557572, -0.005425, -3.003520, -0.026196, -0.012382, -1.602741, 0.869440, -0.005776, 5.241803, -0.460155, -1.028844, -0.251419, 
	-0.005615, -0.004394, -1.086610, 1.229007, 0.745194, -0.002405, -1.489330, -0.005924, -0.003307, -1.175971, 2.733634, -0.002485, -0.002328, -1.512781, 0.629896, -0.046580, 
	-0.009506, -0.005889, -1.085699, -1.548007, -2.170471, -0.003067, 0.977346, -0.006625, -0.004040, 4.917150, -0.301820, -0.003169, -2.297542, -0.241409, 1.926590, -0.143841, 
	-0.005197, -0.002483, -0.081205, -0.910381, -0.863652, -0.000732, -1.103050, -0.006843, -0.001798, -0.467321, -0.597125, -0.000793, 2.524788, -0.403993, 1.940300, -0.020515, 
	-0.006989, -0.005516, -0.120843, 0.734140, 0.241624, -0.001252, 0.780237, -0.006044, -0.002975, -0.769014, -1.299198, -0.001382, 1.127287, -0.547915, -0.055680, -0.066480, 
	-0.208207, -0.079139, -6.177836, 7.929498, 13.475353, -0.030141, -6.148259, -0.092131, -0.052906, 4.204302, 8.711187, -0.039733, -10.952711, -4.958421, -4.660407, -0.920449, 
	-0.031830, -0.007918, 0.990881, 0.072218, -1.251347, -0.002420, 3.328533, -0.005147, -0.004205, 0.838115, -0.685345, -0.002504, -2.637218, -0.761984, 0.221436, -0.061264, 
	-0.010565, -0.008556, -2.334758, -0.961075, -1.903460, -0.002319, -1.722738, -0.075852, -0.006277, 4.646393, -0.783988, -0.002535, 4.045481, -0.107244, -0.740532, -0.031976, 
	-0.042517, -0.036777, -1.699441, -0.387073, 2.711763, -0.005709, 3.225863, -0.043227, -0.016261, -3.234766, -2.233295, -0.140558, 1.994440, 0.301804, -0.166261, -0.227985, 
	-0.143348, -0.050720, 1.160968, 1.674414, 2.877353, -0.009203, -4.682460, -0.072066, -0.026091, 4.185145, -3.703604, -0.010145, 2.927176, -2.950233, -0.327322, -0.849864, 
	-0.010073, -0.007309, -1.422399, -2.473247, 0.567868, -0.001576, -4.487232, -0.051435, -0.007862, 0.198570, 1.433890, -0.004137, 6.868413, 0.318600, -0.799471, -0.122601, 
	-0.015925, -0.006926, -0.529431, -2.273892, 2.950673, -0.000937, -2.119063, -0.007241, -0.003525, -1.033861, 2.757401, -0.001068, -0.844234, 1.114834, 0.090437, -0.077242, 
	-0.012216, -0.008374, 1.815654, 1.374810, -0.006814, -0.002978, 1.081400, -0.012773, -0.005709, 0.168382, -1.700412, -0.003093, -1.396126, 0.032264, -1.556726, 0.232710, 
	-0.007165, -0.002555, 0.107032, 0.441084, -1.140525, -0.001071, -1.853324, -0.002818, -0.001849, 1.128927, 0.641783, -0.001083, 0.758033, -0.569262, 0.019397, 0.483396, 
	-0.016371, -0.022688, -1.638714, -0.485731, 0.281918, -0.004872, -0.634529, -0.023151, -0.012235, -0.141047, -3.898545, -0.004977, -0.913514, 2.982345, 3.291763, 1.240349, 
	-0.017109, -0.012935, -3.177077, -1.523866, -0.794378, -0.007183, -0.339482, -0.016886, -0.010355, 10.332577, 0.077166, -0.007339, -0.011337, -0.423545, -3.839004, -0.229248, 
	-0.170780, 0.210531, -1.276466, -1.791515, -1.873197, -0.010656, 0.322877, -0.077219, -0.027275, -0.379155, 2.840439, -0.011294, 1.241513, 1.077338, -0.747227, 0.672085, 
	-0.025935, -0.019777, 0.672305, 0.876323, -0.170095, -0.006413, 0.671188, -0.034472, -0.012946, -0.583569, 0.920074, -0.011099, 0.996618, -2.278613, -0.491189, -0.502399, 
	-0.009934, -0.008278, 1.357045, -1.822170, -3.036514, -0.002070, -2.145120, -0.020405, -0.005018, -0.126977, 3.778306, -0.002380, 4.219255, -0.251464, -1.849162, -0.075113, 
	-0.005779, -0.001100, -0.547014, 0.671426, 0.069124, -0.000602, 0.184087, -0.018560, -0.001380, 1.452220, -0.242073, -0.000628, -1.494530, 0.228878, -0.257513, -0.036557, 
	-0.003457, -0.002788, 0.317094, -0.048999, -1.292486, -0.000699, 1.177567, -0.002799, -0.001671, -1.123569, -0.232726, -0.000724, 1.059716, -0.560674, 0.748877, -0.032661, 
	-0.003439, -0.001655, 0.326436, 0.100918, -0.134394, -0.000256, -0.095739, -0.001797, -0.000889, 1.297900, -0.835984, -0.000323, -0.100357, -1.148284, 0.601354, -0.003491, 
	-0.022236, -0.026420, 1.255618, -2.240023, 2.029770, -0.005008, -1.953682, -0.013316, -0.013536, 1.926217, -1.598281, 0.018728, -2.169362, 5.598691, -2.676344, -0.110814, 
	-0.030317, -0.014831, -3.172966, 3.158527, -0.802775, -0.004169, -3.256473, -0.019122, -0.009236, 1.181553, -0.036293, -0.004443, 0.384751, 2.493661, 0.332838, -0.200705, 
	-0.006735, -0.007954, 2.128371, 1.200148, -0.848066, -0.001578, -0.662115, -0.009680, -0.003789, -0.038686, 1.450207, -0.001668, -2.993865, 1.011520, -1.197959, -0.018153, 
	-0.045207, -0.034904, 9.660920, -2.504421, -4.682104, -0.021043, -4.879821, -0.045421, -0.027360, -5.825171, -4.325361, -0.021618, 0.669469, -8.232983, 21.632666, -1.317642, 
	-0.004791, -0.002406, 0.961089, -0.618090, 0.943765, -0.001053, 4.379101, -0.002780, -0.001900, -1.429526, -0.558582, -0.001076, -4.380596, 1.097148, -0.203761, -0.176542, 
	-0.005794, -0.006808, -2.979604, 1.877179, 3.633688, -0.001850, -4.361365, -0.009581, -0.004941, 4.927004, -1.984239, -0.002057, -2.316400, 1.650876, -0.359833, -0.056275, 
	-0.034256, -0.009083, 2.382563, 0.422915, 0.054727, -0.002097, -3.443704, -0.037022, -0.006556, 3.345057, 1.451786, -0.002331, -2.926043, -0.439369, -0.191667, -0.564920, 
	-0.066204, -0.034519, -2.351108, 2.608609, 2.199587, -0.014881, -1.465908, -0.056996, -0.025057, -2.981454, -3.631319, -0.024156, -0.432213, -0.610583, 7.339914, -0.453712, 
	-0.007931, 1.350505, 1.663844, -1.849691, 0.286296, -0.001333, -2.724734, -1.325075, -0.006033, 0.294000, 1.119052, -0.001384, 0.846960, -0.888753, 1.272687, -0.028411, 
	-0.010963, -0.009153, -3.150613, -4.176040, 0.133846, -0.004477, 1.637276, -0.010893, -0.006758, 7.278426, -2.308629, -0.004581, 1.804024, 0.014081, -1.094761, -0.090786, 
	-0.103252, -0.021874, 0.681887, 3.352231, -1.085461, -0.012975, 0.412377, -0.353984, -0.027290, -1.389312, -2.917763, -0.013768, 1.766349, 0.264116, -0.247609, -0.303671, 
	-0.005064, -0.007841, -0.536674, 1.072852, -0.656735, -0.000842, 0.662983, -0.003988, -0.002625, -0.036180, 3.413247, -0.000840, -2.214468, -0.528801, -1.020379, -0.134645, 
	-0.021217, -0.012951, 8.547660, 1.579624, -3.414232, -0.005138, -0.280583, -0.021066, -0.009053, -4.855400, 0.350446, -0.005301, 0.490699, -3.248837, 0.983087, -0.077740, 
	-0.007576, -0.003416, -1.096751, -2.511308, 3.787890, -0.001466, -0.085535, -0.010271, -0.002883, -1.674641, 1.929456, -0.001528, -3.256642, 2.014481, 0.963369, -0.043179, 
	-0.023147, -0.016392, 2.052408, -1.527226, -0.478770, -0.003198, -0.763401, -0.024960, -0.013165, -1.533426, 1.034406, -0.003652, 0.053281, 2.291191, 0.039604, -1.083552, 
	-0.059743, -0.026613, 0.490382, -1.597396, 0.779109, -0.006733, 0.509246, -0.043736, -0.018290, 2.754280, 1.011002, -0.007350, -2.231891, -1.086993, -0.219944, -0.245329, 
	-0.033130, -0.027602, 2.963271, -3.995462, -2.187898, -0.004407, 3.297833, -0.041920, -0.013458, -1.703313, 1.694884, -0.004543, 1.315015, -2.444928, 1.090523, 0.095135, 
	-0.000621, -0.000532, -0.101033, -0.002637, 0.458973, -0.000374, -0.512010, -0.001204, -0.000512, -0.110157, 3.298788, -0.000373, -2.937720, -0.091435, 0.010323, -0.009474, 
	-0.031159, -0.008021, -0.037353, -0.289245, 0.778489, -0.001764, 0.939356, -0.007059, -0.004632, 2.629492, -1.877467, -0.010617, -1.967712, -0.266003, 0.287312, -0.133618, 
	-0.034559, -0.018937, -2.209634, -1.262979, 0.224136, -0.002062, 0.086563, -0.019276, -0.007697, 1.332718, 4.435071, -0.002306, -1.829609, 0.312721, -0.946046, -0.058105, 
	-0.035377, -0.004890, -0.896504, 0.956407, -0.255473, -0.000955, -0.405472, -0.004551, -0.002694, 0.422104, -4.453799, -0.001076, 3.477729, 1.323468, -0.094362, -0.024555, 
	-0.039463, -0.010594, -1.419370, -1.346919, -3.479413, -0.002080, 0.832589, -0.006308, -0.004364, 1.442535, 1.395808, -0.002209, 0.534623, 3.388626, -0.960699, -0.322764, 
	-0.003785, -0.002879, -0.622070, 0.053239, -1.889342, -0.000634, 0.882846, -0.003126, -0.001597, 0.361124, 2.323533, -0.000675, -0.923619, 0.757303, -0.900937, -0.029383, 
	-0.037383, -0.021241, 1.886863, 6.443688, -1.766813, -0.007282, -2.364199, -0.030166, -0.014206, -1.740767, -1.275396, -0.012232, 2.194641, 0.061169, -3.145102, -0.171575, 
	-0.018005, -0.006562, -1.161417, -2.772924, 3.499677, -0.001575, -0.548710, -0.006945, -0.004125, -0.936862, 0.153698, -0.001655, 2.461896, -0.794590, 0.442127, -0.304028, 
	-0.247240, 0.278999, -3.744670, -3.069123, 4.179314, -0.026206, 1.480810, -0.309938, -0.055850, 4.734323, 0.969713, -0.027723, 3.102750, -4.374469, -5.302407, 2.411720, 
	-0.000396, -0.000180, 0.032155, 0.070712, -0.134752, -0.000113, -0.479864, -0.000148, -0.000146, -0.051254, 0.123378, -0.000112, 0.458544, -0.016338, -0.000352, -0.001133, 
	-0.242033, 0.139712, -0.025052, -2.146642, 0.787948, -0.034568, -2.527037, -0.179631, -0.062271, -2.113009, 0.764972, -0.036500, 2.607630, -2.463182, 4.858505, 0.671160, 
	-0.054323, -13.554746, -2.902126, -0.722605, 0.595466, -0.009964, -3.455666, 13.651424, -0.019813, -1.351498, -5.848726, -0.010536, 4.591392, 7.660354, 0.991537, 0.439831, 
	-0.009695, -0.007652, -2.374326, -0.549859, -0.966989, -0.003701, -2.271775, -0.009055, -0.005850, 0.506939, 1.284652, -0.003657, -1.787854, 2.319702, 4.065690, -0.186569, 
	-0.051779, -0.025486, -1.880366, -1.347416, 1.352521, -0.003434, -1.022683, -0.032908, -0.010848, -1.476157, -1.837850, -0.003827, 6.687201, -1.475245, -0.003325, 1.131600, 
	-0.035164, 0.001618, -1.612681, 0.669284, -3.998737, -0.002382, 4.148331, -0.024667, -0.007631, 0.022629, -2.689632, -0.131755, 6.403339, -0.965685, -1.606813, -0.170055, 
	-0.056529, 1.396047, 1.449714, -1.897929, -4.374981, -0.006062, 3.604528, -1.019247, -0.017940, 0.022504, -0.698182, -0.006310, -0.134852, 0.042428, 1.885092, -0.188281, 
	-0.012838, -0.007395, -0.435540, -1.681895, -0.198513, -0.001856, 0.550883, -0.028487, -0.004798, 0.312669, 1.747153, -0.002024, 0.548313, -2.225524, 0.967553, 0.472300, 
	-0.012585, -0.007736, -0.614354, -0.035196, -2.424033, -0.003333, 0.300741, -0.010377, -0.006281, 3.427075, 0.070492, -0.003474, -0.711362, -0.999052, 1.120361, -0.090887, 
	-0.019146, -0.011717, -1.146740, 0.902684, 2.848278, -0.004815, -3.389307, -0.049673, -0.008831, 3.412243, 0.354552, -0.004975, -3.531470, 0.914626, -0.115136, -0.150574, 
	-0.034238, -0.015176, 2.072771, 0.286753, -1.293261, -0.005074, 1.730583, -0.021083, -0.010178, 4.420465, -2.215399, -0.005405, -3.112147, 0.311088, -1.955759, -0.153941, 
	-0.008237, -0.004840, 1.177312, 1.173259, -0.848764, -0.001227, -0.382814, -0.004108, -0.002693, -1.775433, -0.809854, -0.001311, -0.115157, 2.947399, -1.311737, -0.031796, 
	-0.005205, -0.003925, -0.309957, -2.066166, -0.663875, -0.001542, 0.325421, -0.003357, -0.002477, -0.374773, -3.818938, -0.001590, 3.401046, 3.095152, 0.456190, -0.026004, 
	-0.104250, -0.070130, 1.892629, -2.925829, -3.376521, -0.032740, 1.565143, -0.089199, -0.052947, 4.350140, -1.781226, -0.033652, -2.353444, -2.997209, 3.568144, 2.441092, 
	-0.021802, -0.012055, 1.497235, 6.875902, -2.162169, -0.007905, -4.008895, -0.012584, -0.009638, -0.842197, -1.029456, -0.137466, -1.522591, 0.834858, 0.020313, 0.538450, 
	-0.009065, -0.003594, -0.490182, 0.805340, 0.071400, -0.001175, 0.535911, -0.026716, -0.002765, -0.928812, 0.337197, -0.001253, 0.506044, 0.110315, -0.797124, -0.105520, 
	-0.048802, -0.027849, -2.409822, 0.684825, 2.142707, -0.007707, -1.517111, -0.023562, -0.013860, 3.430991, 4.666317, -0.008006, -5.217766, 1.867126, -2.868030, -0.649452, 
	-0.002484, -0.001046, -1.912811, 1.563800, 0.222320, -0.000534, 0.319854, -0.004730, -0.001082, 0.262545, 0.259320, -0.000533, -0.329509, 0.129406, -0.500238, -0.004279, 
	-0.013816, -0.006731, -0.816958, 1.238762, -3.506942, -0.002284, -0.405434, -0.006295, -0.004427, -0.184226, 2.591299, -0.002363, 0.422327, 0.165390, 0.617316, -0.085617, 
	-0.047472, -0.027279, -3.316485, -1.555364, -1.297624, -0.005193, -4.278307, -0.052359, -0.014387, -3.521127, 5.440291, 0.018984, 1.624526, 2.409931, 4.630955, -0.009090, 
	-0.005547, -0.001388, 0.172431, 1.480323, -0.405636, -0.000355, -0.113690, -0.009256, -0.001098, -1.603262, -2.617803, -0.000409, 3.241227, -1.535746, 1.406392, -0.006185, 
	-0.006380, -0.003479, -1.096159, 1.260600, 0.146376, -0.001108, 2.091333, -0.004741, -0.002359, 1.367706, -2.995221, -0.001151, -0.937317, -0.520668, 0.740978, -0.038408, 
	-0.216223, -0.143582, 4.971742, 1.769365, -3.176697, -0.052384, 4.990377, -0.169572, -0.098487, -4.347117, -11.067283, -0.313542, 4.426454, -0.884004, 0.975815, 3.335137, 
	-0.112131, -0.016856, 3.573489, -0.038885, 5.501059, -0.007240, 0.846492, -0.100078, -0.014127, 0.117837, -1.624536, -0.007697, -7.424906, -0.714943, 0.239761, -0.217238, 
	-0.331579, -0.157667, -1.702579, 3.543648, 3.588092, -0.055346, -2.852810, -0.258853, -0.117215, -0.521272, 0.431628, -0.057940, -0.487589, -0.526743, 0.130482, -0.624255, 
	-0.007449, -0.002448, -0.006931, 0.944617, -0.530045, -0.000337, -0.889131, -0.008536, -0.001838, -0.476711, 2.002161, -0.000443, -1.316073, -0.238979, 0.537142, -0.005001, 
	-0.004699, -0.002739, -1.130993, -0.166373, 2.184516, -0.001192, -2.101325, -0.002809, -0.001902, 0.616869, 2.533923, -0.001268, -1.762545, 0.717733, -0.781773, -0.095423, 
	-0.005827, -0.004056, -0.948542, 0.967182, -0.149048, -0.001386, -0.263524, -0.005437, -0.002749, 1.525264, 2.047226, -0.001592, -2.614655, -0.258533, -0.230641, -0.053683, 
	-0.041065, -0.015176, 0.499666, -1.319755, 0.020838, -0.004742, 1.011849, -0.021951, -0.008768, -0.484489, 2.951195, -0.004935, -3.196099, 0.809714, -0.095592, -0.100688, 
	-0.072403, -0.019048, -0.884799, -1.060973, -0.933096, -0.009281, 4.654520, -0.028310, -0.013549, -2.310323, 5.171284, -0.009617, -1.872789, -1.961893, -2.900659, 2.250936, 
	-0.026156, -0.002453, -0.306139, 1.403671, 1.260852, -0.004373, 1.942290, -0.019006, -0.008927, -3.380473, -9.812067, -0.004549, 8.854781, 0.221479, 0.642447, -0.761377, 
	-0.002839, -0.004561, -0.311648, -1.566285, 2.408952, -0.000756, -0.401826, -0.003830, -0.002331, 0.354415, 0.340251, -0.000813, -0.873862, -1.190214, 1.300698, -0.045349, 
	-0.491492, -0.195387, -1.094770, -0.502070, -4.193511, -0.055158, 4.000800, -0.411266, -0.121430, -0.856924, -0.047766, -0.059005, 3.577583, -0.300380, 1.726150, -0.975378, 
	-0.016247, -0.005627, 0.025321, -1.294608, -1.592364, -0.002121, 1.474877, -0.008890, -0.004369, 6.268680, 0.595115, -0.002303, -1.851682, -1.683040, -1.879866, -0.022876, 
	-0.003114, -0.002752, -1.122227, 1.042278, -0.134157, -0.000645, -0.871532, -0.004681, -0.001921, 1.452834, -0.596023, -0.000691, 0.363239, -0.317367, 0.030782, 0.165977, 
	-0.003416, -0.002687, 0.302578, 2.380231, -1.422980, -0.000943, -3.346956, -0.003219, -0.001926, -1.848964, -0.080346, -0.001006, 2.339879, -0.730216, 2.442214, -0.022241, 
	-0.009688, -0.004111, -1.500950, -1.838784, -1.978569, -0.001249, 1.400284, -0.004298, -0.002468, 3.443431, -3.709531, -0.001282, 3.776649, 0.419712, 0.025778, -0.014925, 
	-0.009011, -0.006552, 2.114102, -0.772058, 1.920170, -0.000951, -2.532205, -0.006134, -0.002864, -0.455091, -1.639160, -0.001145, 1.007174, -0.042181, 0.439039, -0.013130, 
	-0.007224, -0.006147, -2.318582, -0.767901, 0.964423, -0.003189, -0.939246, -0.009315, -0.004701, 3.941692, 0.097825, -0.003264, -3.754899, 0.003240, 2.879179, -0.071891, 
	-0.009964, -0.008140, 0.808457, -1.519997, -1.032358, -0.002618, 5.410116, -0.006954, -0.005239, -0.974265, -1.899338, -0.002615, -1.024836, 4.003774, -3.562920, -0.173103, 
	-0.000631, -0.000556, -0.328295, -0.586039, -0.160784, -0.000443, -0.073857, -0.000579, -0.000521, 1.294073, -0.024076, -0.000403, -0.059271, -0.088755, 0.031990, -0.001852, 
	-0.013590, -0.006930, 0.757828, 2.054788, -0.756718, -0.001595, 1.588830, -0.007940, -0.004395, -0.216008, -0.490357, -0.001729, -0.578173, -1.078387, -0.703152, -0.542473, 
	-0.006555, -0.010053, -0.827017, 1.164949, 0.376086, -0.001542, 2.638670, -0.011113, -0.005002, -2.337155, -1.007573, -0.001652, -2.508041, 2.702343, -0.085162, -0.081183, 
	-0.006567, -0.004742, -0.932056, 5.444956, -1.852869, -0.001494, 0.355111, -0.011226, -0.003056, -2.105004, 0.624332, -0.002065, -1.111547, 0.623423, -0.969635, -0.047561, 
	-0.042095, -0.016994, -1.114204, 0.800854, -2.039612, -0.004877, 2.185764, -0.027907, -0.011811, -0.825630, 0.349551, -0.005288, 2.476092, -0.731539, -0.845440, -0.146866, 
	-0.011462, -0.008238, -0.712046, 0.357642, -1.890525, -0.003578, 2.379627, -0.013448, -0.005844, -1.555572, -1.086176, -0.003712, -1.323511, 4.471010, -0.526977, -0.067189, 
	-0.043664, -0.021019, -0.520732, -1.068689, -3.492962, -0.005318, 0.512419, -0.041176, -0.011373, -2.933875, 6.872124, -0.005593, 1.336296, -1.625864, 1.361063, -0.311637, 
	-0.036440, -0.009101, -0.065758, -0.040857, -0.515921, -0.001599, 1.365642, -0.007122, -0.003860, 0.221948, -0.717886, -0.001655, 0.489719, -0.703623, 0.122786, -0.096272, 
	5.929921, -0.049420, 0.776732, -4.417556, -3.306183, -0.025602, -1.891422, -0.449502, -0.053069, -2.432825, 2.941263, -0.031023, 6.060013, -1.914532, -0.017283, -1.119512, 
	-0.001020, -0.001485, -0.612033, -0.034292, -0.919399, -0.000216, 0.297305, -0.000884, -0.000560, 1.255988, -2.355586, -0.000229, 2.362453, 0.071753, -0.050214, -0.011581, 
	-0.029169, -0.006941, 0.285944, -0.751711, -2.523942, -0.001733, 1.418573, -0.014929, -0.006443, 4.204456, -1.869900, -0.001912, 1.331990, -1.660738, -0.090374, -0.283171, 
	-0.024970, -0.016663, 2.370169, 1.496119, 6.297885, -0.006169, -5.084162, -0.014710, -0.010300, -0.022556, -3.085063, -0.006424, -2.846715, 0.943584, 0.215068, -0.205093, 
	-0.004686, -0.005205, 1.346302, 1.867543, -1.339811, -0.001052, -0.653254, -0.003086, -0.002358, 0.723762, 1.056035, -0.001115, -2.283454, -1.079443, 0.429792, -0.049970, 
	-0.003615, -0.001334, -0.240283, -0.516667, 0.018553, -0.000405, -0.646198, -0.002972, -0.001001, 1.608494, 0.324600, -0.000436, -0.019713, -0.831873, 0.332832, -0.019981, 
	-0.032695, -0.016067, -1.835573, -1.446426, 2.006341, -0.003564, 2.804048, -0.039641, -0.011331, -0.111937, -3.612720, -0.003920, 3.111199, -0.799566, 0.112722, -0.120869, 
	-0.091664, -0.049320, 0.279151, 1.346215, -2.245104, -0.020864, -1.583960, -0.095375, -0.044450, 1.130524, 3.078429, -0.030890, 2.157651, 1.595660, -4.549708, -0.876295, 
	-0.019512, -0.005449, -1.808175, 1.782798, 1.168560, -0.002144, -4.763691, -0.006976, -0.003825, -1.944619, -0.908152, -0.002225, 3.326812, -0.402661, 2.011201, 1.578057, 
	-0.006213, -0.003353, 0.242052, -0.706917, 0.606909, -0.001256, 1.957792, -0.009331, -0.002495, -0.715084, -1.958870, -0.001313, 0.593086, -0.281463, 0.303984, -0.017527, 
	-0.010686, -0.008330, 1.257904, 0.951323, 0.209428, -0.002948, 0.665293, -0.008527, -0.005539, -1.210296, -0.502693, -0.003185, -3.778541, -0.188235, 2.966392, -0.331361, 
	-0.004367, -0.005402, 0.881796, 0.476256, 1.725883, -0.000677, -1.237177, -0.004691, -0.002256, 0.518366, -2.464208, -0.000752, -1.655978, 1.712654, 0.174167, -0.113615, 
	-0.006371, -0.004625, -0.988535, -1.417358, -0.867981, -0.001249, -1.521544, -0.037937, -0.003230, 4.126393, 2.689029, -0.001271, -1.303119, 0.537063, -1.180722, -0.018543, 
	-0.003086, -0.003113, -1.400674, 0.306273, 1.681309, -0.001045, -0.200947, -0.004209, -0.002119, 1.562840, -0.994958, -0.001107, -0.264535, -0.406617, -0.526637, 0.258627, 
	-0.006844, -0.004969, -1.520611, -0.661264, -0.091333, -0.001818, -1.022359, -0.004890, -0.003005, -0.277243, -0.811821, -0.001880, 1.220378, 3.398903, -0.190578, -0.020666, 
	-0.013490, -0.009210, -1.196127, -0.617252, 3.129640, -0.002094, 2.160899, -0.011605, -0.005763, 0.331587, -2.944800, -0.002306, -0.533176, -0.829963, 0.615977, -0.072317, 
	-0.007679, -0.005300, -1.248571, -0.226819, 0.253364, -0.002286, 0.206415, -0.006668, -0.003534, 4.246148, 4.383917, -0.006714, -5.875036, -1.501984, -0.193371, -0.011882, 
	-0.009117, -0.003908, -1.632870, 3.830430, -1.810940, -0.002055, -1.250052, -0.013698, -0.003298, 1.362784, -4.531714, -0.002119, 5.021069, -0.273478, -0.792187, 0.111154, 
	-0.005126, -0.004435, -0.011721, 0.641103, 1.656076, -0.001072, -0.738142, -0.005127, -0.002485, -0.474325, -3.093355, -0.001143, 1.488469, 0.988473, -0.390322, -0.046867, 
	-0.001781, -0.000956, 0.214314, 0.091432, -0.264394, -0.000708, 0.944386, -0.001417, -0.000887, 0.061112, -0.026111, -0.000716, -1.127139, -0.098866, 0.221926, -0.010195, 
	-0.023011, -0.007788, -1.675412, 0.699700, 1.451292, -0.001558, -1.503917, -0.005856, -0.002947, -0.246490, 0.051767, -0.001605, 2.357161, -1.011448, -0.449651, 0.369763, 
	-0.002489, -0.003344, -0.328485, -0.762304, 3.771712, -0.000660, -0.379819, -0.003387, -0.001703, -0.637191, 0.147970, -0.000731, -1.819797, -0.938369, 0.971078, -0.012482, 
	3.123985, -0.359571, 2.003002, -4.253380, -5.433338, -0.098123, -1.428709, -0.487865, -0.224095, 3.470968, 0.192807, -0.116015, -2.725825, 4.773541, 2.909098, -1.346479, 
	-0.000746, -0.000630, 0.036837, 0.432696, -0.646716, -0.000411, 0.852776, -0.005044, -0.000697, -0.203743, -0.160733, -0.000433, -0.050126, -0.054687, -0.192394, -0.005949, 
	-0.016240, 0.042118, -0.180894, 5.366827, -2.007697, -0.004816, -3.463551, -0.065667, -0.008269, 1.056305, -0.705916, -0.004977, 0.227124, -0.871790, 0.728857, -0.091414, 
	-0.071477, -0.010439, -1.078617, -0.935513, 3.382082, -0.002274, -1.127827, -0.012567, -0.006303, 2.521049, -3.789230, -0.002561, 2.394040, -2.089030, 1.810452, -0.981787, 
	-0.005028, -0.009108, 5.540922, -2.628234, 2.584188, -0.001195, -0.250207, -0.010559, -0.004730, -1.129054, -0.430637, -0.001536, -1.965401, -0.466557, -1.182025, -0.040840, 
	-0.006628, -0.002876, 0.078529, -0.200969, 0.358406, -0.001173, 3.065443, -0.002797, -0.002089, -0.842704, -1.419336, -0.001208, -0.292005, -0.400031, -0.318004, -0.012558, 
	-0.044004, -0.007959, -2.434602, 0.000714, 7.280746, -0.001998, 7.612284, -0.011696, -0.004926, -2.335539, -3.997459, -0.002097, -7.060321, 1.187221, -0.157356, -0.023008, 
	-0.007096, -0.007724, -0.193050, 0.251810, 2.610567, -0.002219, 0.080364, -0.009282, -0.004365, -1.849640, -2.558415, -0.002341, 1.105126, 1.194789, -0.552087, -0.056436, 
	-0.052461, -0.007274, -2.330934, 6.179140, 6.565306, -0.002477, -2.389718, -0.010637, -0.005178, -2.736342, -2.491313, -0.002581, -6.731225, 0.509708, 3.563751, -0.057765, 
	-0.009678, -0.005714, -1.956130, 0.403241, -0.972974, -0.001626, -0.638899, -0.010096, -0.004957, -0.822189, 3.720890, -0.000803, -4.329519, 2.390080, 2.267953, -0.029580, 
	-0.243276, -0.149304, 6.537527, 10.941951, -1.880016, -0.089449, -3.019214, -0.171967, -0.121191, 6.756148, -5.845926, -0.404589, -7.096928, -5.586991, -1.815503, 2.188732, 
	-0.021788, -0.015419, -0.971946, -4.948156, -1.312874, -0.003037, 1.169669, -0.030084, -0.009206, 1.504833, 2.869289, -0.003414, 0.372138, 0.268464, 1.161808, -0.030276, 
	-0.049406, -0.008148, 1.254549, 2.525937, -3.349115, -0.002086, 3.873640, -0.012340, -0.005638, -1.952738, 1.048529, -0.002368, -1.039700, -2.224673, 0.051478, -0.107920, 
	-0.077364, 0.204569, 4.891850, 7.196664, -2.390497, -0.017075, -1.091213, -0.148226, -0.035977, 4.628957, -4.819091, -0.017927, -4.057420, 1.124994, -2.574245, -2.817997, 
	-0.001384, -0.000814, -0.018747, -0.757495, -0.749421, -0.000337, 2.438583, -0.001556, -0.000650, 0.019625, -0.692943, -0.000351, -0.818152, 0.116217, 0.544482, -0.077057, 
	-0.038797, -0.014387, -1.067840, 3.779152, -3.353672, -0.004014, 0.507794, -0.018853, -0.008958, -0.288234, 6.966080, -0.004229, -0.610253, -3.856567, -1.914906, -0.072316, 
	-0.007231, -0.005385, -0.171137, -0.676144, -0.056787, -0.002158, -1.292137, -0.004245, -0.003309, -1.186989, 0.978760, -0.006658, 0.012066, 1.687307, 0.287015, 0.447033, 
	-0.001452, -0.001216, 0.374286, 0.489559, -0.871188, -0.000363, -0.660819, -0.001786, -0.000752, -0.594333, 0.058692, -0.000347, 1.068212, -0.238996, 0.397939, -0.017438, 
	-0.087213, -0.048621, 12.333636, -4.866174, -7.831748, -0.026793, 1.035934, -0.053869, -0.037461, -9.362761, -2.210578, -0.027694, -8.491181, 26.682178, -5.699230, -1.308426, 
	-0.076653, -0.018529, -2.326755, 2.787254, -2.134432, -0.005226, 3.429759, -0.043640, -0.013151, -1.929155, -8.233210, -0.005546, 9.670418, -2.903554, 0.927826, 0.874594, 
	-0.019347, -0.005586, -1.010490, -0.500171, 0.411158, -0.002931, -2.001387, -0.005610, -0.004152, 0.377767, -3.153867, -0.002983, 4.742975, -0.879379, 2.082981, -0.028978, 
	-0.002883, 1.204342, 0.686617, 0.254340, 1.481936, -0.000299, 2.382142, -1.200224, -0.000985, -1.317908, -2.255482, -0.000301, -0.536942, -0.530260, -0.391590, 0.227495, 
	-0.008805, 0.002206, 1.251735, 1.378467, -1.273132, -0.002615, -1.015153, -0.019362, -0.004922, -1.103503, 1.692053, -0.002783, -0.206963, -0.486844, -0.326240, 0.125861, 
	-0.003417, -0.004326, 1.156591, -1.633918, -1.067055, -0.000967, -0.138238, -0.004655, -0.002153, 2.937907, -0.169999, -0.001003, -1.604447, 0.055703, 0.530088, -0.050110, 
	-0.012047, -0.009832, 1.401400, -0.203243, -1.856398, -0.002124, -0.945651, -0.009199, -0.005332, -1.418870, -0.781132, -0.002283, 3.567789, -0.081157, 0.069608, 0.288472, 
	-0.003658, -0.003890, 0.685009, -0.714202, -1.985135, -0.001448, -0.976372, -0.005185, -0.002389, -0.037718, -2.114137, -0.001517, 1.912661, -0.790949, 4.093939, -0.055009, 
	-0.010144, 0.606153, 0.586599, 0.483817, 0.060490, -0.001940, -0.546094, -0.590198, -0.002781, -1.417816, 1.588190, -0.001944, -1.078102, 0.234022, -0.310732, 0.400482, 
	-0.001877, -0.001963, 0.466028, -0.729474, -0.202879, -0.001284, -1.436405, -0.003379, -0.001828, 2.659367, -1.465558, -0.001327, 1.154064, -0.103390, -0.318849, -0.011246, 
	-0.055391, -0.008951, -1.676555, 1.475419, -0.750356, -0.001373, 0.519385, -0.005430, -0.003533, -0.121024, 3.903833, -0.001459, -2.865584, -0.483982, 0.164407, -0.089407, 
	-0.005709, -0.000274, -0.060479, 0.149808, -0.019132, -0.000159, 0.637640, -0.000789, -0.000275, -0.010369, 0.260573, -0.000160, -0.896834, -0.038117, -0.012439, -0.003283, 
	-0.259277, -0.080753, 3.065692, 0.188039, 4.205414, 0.170557, 1.637786, -0.113979, -0.049919, -2.492956, -1.126915, -0.025586, -2.963138, -5.199124, 4.095462, -1.051302, 
	-0.004929, -0.003458, -0.856903, -1.807234, -2.027016, -0.001105, 0.755662, -0.004020, -0.002143, 1.775660, 6.022095, -0.001174, -2.182633, -1.365237, -0.264066, -0.033500, 
	-0.003424, -0.001949, -0.051449, -1.508716, 0.434572, -0.000427, -0.285736, -0.003166, -0.001254, 1.582666, -0.028809, -0.000475, -0.267920, 0.285334, -0.100435, -0.048813, 
	-0.012966, -0.004798, -1.355818, 0.773706, -0.976293, -0.001246, 1.031445, -0.003431, -0.002434, 0.119490, 1.173611, -0.001253, 0.175952, -0.357540, -0.376308, -0.182118, 
	-0.014226, -0.003744, 0.371891, 0.702791, -0.737996, -0.001799, -0.454564, -0.004533, -0.002647, -1.037047, -0.189931, -0.001820, -0.611917, 2.759552, -0.730399, -0.043612, 
	-0.005234, -0.002700, -0.700867, 1.931503, 1.154843, -0.001079, -1.920829, -0.004748, -0.001991, -1.393304, -2.630978, -0.001143, 3.992042, 0.390871, -0.744542, -0.061843, 
	-0.006075, -0.003918, -1.957788, -2.627348, 0.372504, -0.001754, 1.396487, -0.004440, -0.003406, 7.146854, -1.331475, -0.001759, -1.138162, -2.127738, 0.350550, -0.062534, 
	-0.020012, -0.008706, 3.979450, 0.126575, -0.641044, -0.003463, 0.865383, -0.016957, -0.006487, -1.567804, -0.503921, -0.003652, -2.161664, 0.660466, -0.576537, -0.121627, 
	-0.010984, -0.005366, -0.688813, -1.222602, -1.432675, -0.002563, 6.711545, -0.006215, -0.004194, -0.714999, -3.576354, -0.002636, 2.018254, -0.262587, -0.645802, -0.154007, 
	-0.072884, -0.025557, -0.103212, -2.493599, 1.011146, -0.006791, -0.442961, -0.041238, -0.015521, -1.235250, 1.576818, -0.007249, 2.599131, -1.418331, 0.026625, 0.648872, 
	-0.006879, -0.002504, 0.011613, 1.702625, -0.565664, -0.000973, 2.904549, -0.004975, -0.001777, 0.398323, -2.431137, -0.000668, -2.525359, -0.309359, 0.875568, -0.043383, 
	-0.078090, -0.022060, -0.450545, -4.716501, 1.841889, -0.006939, 0.906117, -0.027220, -0.015485, -2.113556, -1.304209, -0.007351, 6.097436, -1.991287, 2.079670, -0.191868, 
	-0.025635, -0.014854, 1.436452, -1.163979, -1.544012, -0.002918, 2.209263, -0.015720, -0.007485, -2.841889, 3.355835, -0.003260, 0.610705, 0.256531, -2.003801, -0.245234, 
	-0.115057, -0.072225, 3.116154, 14.423705, -2.278047, -0.026734, -2.285003, -0.080873, -0.046797, 5.484889, -7.417104, -0.027611, -10.962553, 7.388993, -6.198875, -0.902863, 
	-0.019217, -0.009657, 0.262304, 0.108603, -1.888296, -0.003326, -2.229932, -0.019104, -0.006609, 5.487175, 1.512677, -0.003510, -1.707650, -0.253020, -1.141694, -0.088744, 
	-0.034587, -0.015435, -0.365671, -2.316038, -1.950982, -0.004698, 4.496709, -0.102195, -0.012684, -0.709249, 0.723829, -0.005042, 2.584199, -1.509011, -0.651915, -0.127230, 
	-0.004318, -0.002269, 0.338257, 0.834857, -1.752541, -0.001241, 2.300305, -0.003479, -0.001976, -1.485203, -3.145020, -0.001273, 3.537402, -0.187936, -0.409894, -0.015672, 
	-0.007741, -0.002117, 0.166381, -0.440984, -0.588282, -0.000392, -1.305852, -0.005307, -0.001531, 0.797621, -1.385434, -0.000451, 2.809803, -0.406206, 0.383107, -0.012616, 
	-0.011986, -0.007429, -2.019031, 1.492004, -0.661510, -0.001891, 1.754804, -0.007835, -0.004574, -0.287325, -2.697150, -0.002073, 3.576741, -0.494610, -0.545440, -0.082696, 
	-0.005897, -0.003480, -1.488118, -0.178597, -1.078559, -0.001284, -0.608749, -0.003049, -0.002226, 0.645024, -0.925251, -0.001284, 0.157523, 2.388394, 1.199895, -0.094341, 
	-0.013310, -0.006891, -0.044474, -1.332455, -0.058501, -0.001682, -2.276337, -0.016139, -0.004669, 0.997261, 1.530972, -0.001868, -0.131341, -0.418835, 2.184910, -0.406641, 
	-0.010622, -0.006468, -0.848066, 0.219148, -1.194889, -0.002703, 3.222680, -0.065325, 0.399038, 1.799194, -2.342726, -0.002575, -0.836231, -0.447441, 0.349220, -0.232234, 
	-0.067065, -0.030355, -0.099923, -0.219816, 2.313573, -0.010915, -0.618340, -0.045632, -0.022376, -1.465836, 1.597139, -0.011816, 1.901112, -2.843958, 0.600572, -0.976366, 
	-0.002301, -0.002133, -0.257859, -1.282159, -2.348160, -0.000566, -0.083098, -0.002391, -0.001420, 2.414023, 2.691926, -0.000630, -1.093691, -0.261567, 0.235353, -0.005327, 
	-0.040805, 2.253425, -2.390820, 0.643988, 7.676299, -0.003573, -1.805322, -2.215295, -0.006341, -0.739153, -1.862941, -0.003685, -3.634166, 0.959917, 1.360888, -0.192415, 
	-0.007887, -0.004046, -1.148767, -1.564652, -2.568726, -0.001094, 2.429416, -0.006180, -0.002765, 1.709709, -0.989049, -0.001250, 2.459616, -0.118460, -0.143673, -0.042194, 
	-0.165620, -0.017556, -2.648895, -0.546934, 10.443949, -0.006691, -3.448423, -0.037466, -0.012900, -1.923496, 0.031000, -0.006994, -2.852914, 0.263313, 1.011721, -0.082093, 
	-0.003647, -0.002508, -0.480775, -1.100229, -0.585559, -0.001240, 1.111204, -0.002848, -0.001872, 2.811677, -0.367895, -0.001264, -0.407305, -0.355984, -0.583845, -0.027910, 
	-0.014805, -0.017496, 1.289570, 0.369380, -2.394552, -0.002795, -2.581317, -0.039330, -0.009849, -1.259130, 5.494128, -0.003285, 1.873307, -1.671913, -0.976582, -0.055330, 
	-0.037144, -0.004963, 1.116816, 3.156521, -1.655490, -0.001676, -2.162142, -0.032263, -0.004460, -0.652579, 0.811944, -0.001808, -1.744817, 0.466997, 0.844215, -0.099151, 
	-0.090860, -0.012982, -2.062671, -1.290830, -0.692621, -0.003755, 1.481619, -0.028775, -0.007962, 3.922958, 1.440048, -0.003979, -1.870997, -0.314176, -0.856163, 0.391147, 
	-0.040072, -0.006668, 0.014111, -2.084629, 2.545906, -0.002210, -0.703659, -0.012641, -0.005367, -0.382541, 1.632521, -0.002402, -0.371359, 0.336904, -0.789513, -0.128380, 
	-0.057576, -0.020820, 5.308815, 0.249097, 6.956141, -0.011826, -5.965432, -0.030060, -0.016857, 0.880947, -3.068870, -0.012302, -2.239445, -0.848326, -1.274654, 0.151167, 
	-0.005639, -0.001137, 0.192319, 0.093783, -0.748228, -0.000496, -0.467315, -0.003260, -0.001089, 1.383381, -0.536503, -0.000513, -0.215351, 0.346959, -0.029368, -0.007543, 
	-0.109432, -0.028428, 0.805575, -1.557942, -0.052400, -0.004395, 0.496806, -0.042070, -0.014183, 0.537419, -1.962932, -0.009351, 3.089655, -0.995454, 0.031335, -0.184204, 
	-0.005958, -0.003298, 0.070124, 0.448560, -0.702837, -0.000757, 2.013879, -0.003243, -0.001799, -1.377217, -2.492553, -0.000837, -1.327386, 1.992043, 1.411502, -0.020224, 
	-0.030638, -0.009490, -0.064290, -0.569379, -2.762275, -0.001468, -1.467856, -0.011849, -0.004681, 0.084374, 2.169755, -0.001595, 3.091197, -0.273690, 0.012457, -0.160571, 
	-0.055002, -0.045500, 4.629764, -3.738793, 2.809765, -0.010224, 2.696850, -0.080236, -0.025722, 2.738032, -7.563989, -0.011600, -3.778080, 5.020907, -2.215253, -0.370917, 
	-0.014198, -0.009911, 3.493188, 0.112202, 0.037940, -0.003402, -1.117125, -0.008459, -0.007484, -1.964637, -3.809747, -0.003441, 1.622546, -1.166412, 2.903503, -0.064562, 
	-0.054112, -0.032272, -1.173696, -1.827544, 2.194941, -0.006546, 5.684677, -0.033007, -0.020517, 1.597439, -4.373627, -0.007386, -2.986206, -0.439794, 1.644398, -0.166748, 
	-0.005016, -0.003475, -0.067805, 0.480509, -0.603148, -0.000431, -0.913447, -0.005833, -0.002792, -0.120643, -4.438380, -0.000524, 6.240427, -0.169379, -0.381238, -0.008824, 
	-0.004621, -0.006593, 0.529750, 0.089151, -1.941940, -0.001662, 0.516911, -0.007828, -0.006469, 0.338364, 1.299163, -0.001841, -1.039690, 0.275935, 0.012187, -0.050817, 
	-0.045595, -0.039226, -2.649108, -2.233848, -3.956374, -0.008689, 9.290318, -0.044910, -0.019576, 0.825515, 0.547196, -0.009474, 0.780105, 0.892596, -3.102811, -0.226117, 
	-0.015597, -0.013257, -0.407149, 1.433074, 1.681907, -0.001662, 3.521683, -0.007553, -0.005081, -2.307836, 0.807590, -0.001812, -4.716955, 1.632208, -1.501056, -0.098506, 
	-0.113879, 0.196369, -3.971222, 1.689849, 1.931989, -0.012335, 2.763404, -0.137662, -0.029693, -5.061055, -1.259471, -0.012942, 2.912946, -0.250633, 0.791284, 0.563050, 
	-0.025069, -0.011656, 0.892782, -2.659714, 3.419365, -0.004333, 7.508327, -0.017052, -0.007513, -0.367105, -2.088901, -0.004473, -3.034768, -3.486675, -0.118116, 0.004900, 
	-0.002301, -0.001719, -0.277559, -1.321845, -0.730229, -0.000532, 0.436779, -0.002265, -0.001194, 0.308001, -3.139987, -0.000573, 4.098865, 0.846466, -0.202174, -0.009733, 
	-0.039064, -0.017318, -0.486275, -2.145514, -0.561480, -0.004778, 1.237749, -0.064816, -0.012512, -0.772526, 3.834784, -0.009483, -3.212571, -1.288734, 3.692275, -0.149738, 
	-0.004806, -0.001531, -0.646449, 0.289767, -0.388291, -0.001190, -0.170557, -0.001595, -0.001233, -0.719668, 0.516518, -0.001201, -0.071555, 1.408349, -0.227197, 0.020640, 
	-0.081560, -0.044993, 2.181371, 4.287687, -3.019649, -0.015288, -3.833432, -0.051252, -0.022587, -0.025342, 1.088388, -0.015973, -0.632762, 1.339476, -2.290081, 1.135996, 
	-0.002984, -0.001535, -0.294950, -0.313477, -0.308878, -0.000463, 0.005344, -0.001171, -0.000844, 0.136068, 0.781085, -0.000470, -1.258325, 1.030788, 0.253680, -0.023868, 
	-0.011061, -0.005195, -0.423459, -0.066559, 0.506090, -0.001784, 1.071290, -0.005922, -0.003451, -0.391894, 4.190910, -0.001921, -5.163210, -0.964070, 0.329056, 0.941181, 
	-0.010394, -0.006347, -1.220332, 1.913434, 1.118129, -0.001125, -1.478687, -0.005625, -0.002992, -2.018044, -0.661276, -0.001270, 0.889956, -0.899551, 2.455358, -0.071234, 
	-0.004876, -0.002623, 1.360363, -0.026838, -0.722447, -0.000799, -0.445955, -0.002024, -0.001476, 0.994510, -1.152576, -0.000828, 0.781834, 0.031527, -0.797498, -0.010293, 
	-0.133767, -0.063663, -0.368327, -2.118334, 2.470416, -0.011353, -3.635471, -0.171885, -0.024344, 0.797070, 2.557694, -0.012641, -0.328898, 1.280030, -0.947339, 0.710812, 
	-0.139176, -0.022996, -3.204842, 2.406904, 4.294181, -0.012919, -2.670329, -0.073216, -0.025742, -4.490589, -4.878741, -0.013785, 7.381315, 7.159290, -5.260369, -0.448987, 
	1.932415, -0.138533, -4.232714, -0.829722, -5.694671, -0.032103, 7.981184, -0.232161, -0.075267, -4.995373, 7.762408, -0.034070, 12.647344, -5.870305, -8.556679, 0.368246, 
	-0.009581, -0.002952, -1.461762, 2.039091, 0.392665, -0.001140, 1.791354, -0.012835, -0.002349, -0.603000, -1.155818, -0.001195, -1.382199, 0.544430, -0.107856, -0.026853, 
	-0.056338, -0.005831, 0.819996, -0.709421, -1.213222, -0.001190, 0.666768, -0.008050, -0.003496, -0.623637, 0.764184, -0.001332, -1.129713, 1.119962, 0.447102, -0.065782, 
	-0.543037, -0.228298, -5.637278, -0.093369, -3.430113, -0.115812, 17.271906, -0.370961, -0.157355, -6.392486, -1.311804, -0.248643, -6.699932, -1.330903, 3.188808, 6.099275, 
	-0.007054, -0.002846, 0.198766, -0.853380, -1.284970, -0.001328, -0.418961, -0.007942, -0.002336, -0.193955, 2.343643, -0.001372, -1.397185, 0.196807, 1.443583, -0.011471, 
	-0.008569, -0.002729, 1.180305, -0.064961, -0.273206, -0.000709, 3.000787, -0.004567, -0.001642, 0.133151, 2.004262, -0.005143, -4.035229, -1.890951, -0.010166, -0.020634, 
	-0.000803, -0.001182, -0.668988, -0.878672, -0.235207, -0.000411, 1.268868, -0.001002, -0.000761, 2.273366, 1.337894, -0.000429, -3.344919, -0.177065, 0.315615, 0.113696, 
	-0.024457, -0.013828, -1.068397, 0.763638, -0.997515, -0.002851, 6.359458, -0.018724, -0.006780, 0.941010, -8.209973, -0.003055, 4.646557, -0.667269, -1.637088, -0.060726, 
	-0.087343, -0.007508, 0.234218, -2.694079, -3.886092, -0.001567, 0.296224, -0.009499, -0.004218, 2.215018, 2.797089, -0.001684, 4.831155, -2.606391, -1.001480, -0.073844, 
	-0.004650, -0.006738, -0.183773, 1.601480, 0.880141, -0.000715, -0.375059, -0.003314, -0.002110, -0.714520, -0.353130, -0.001140, 0.361925, -0.367749, -0.973678, 0.143030, 
	-0.041446, -0.033112, 2.836203, -3.052652, 4.556697, -0.010196, -1.864172, -0.057251, -0.018985, -1.324484, -1.689344, -0.139870, -1.001847, -0.698799, 2.023809, 0.515450, 
	-0.009322, -0.003415, 1.154897, -0.465300, -0.167963, -0.000839, -0.435605, -0.004016, -0.002146, -1.698547, 0.294323, -0.000877, 0.004529, 1.605385, -0.253943, -0.017162, 
	-0.017825, -0.008615, -1.436134, -1.073506, -2.271565, -0.002098, -1.701540, -0.028446, -0.006210, 0.864127, 10.177937, -0.002267, -3.876299, -1.561550, 0.957307, -0.013317, 
	-0.003018, 0.945389, 0.814348, -0.138172, -0.740124, -0.002059, -0.157220, -0.900750, -0.002563, -0.371653, -1.303916, -0.002085, 2.475531, -0.177308, -0.423492, -0.012907, 
	-0.076391, 0.509616, 3.353759, -2.912125, -3.932545, -0.020879, 3.184933, -0.122031, -0.026072, 1.504742, -3.384905, -0.021728, -4.654730, 1.528682, 4.073347, 0.996327, 
	-0.013363, -0.002973, -0.209204, -0.777952, -2.348342, -0.001171, -1.648437, -0.036091, -0.003291, -0.473464, -0.775474, 0.047608, 6.062014, -0.280668, 0.486799, -0.025989, 
	-0.036124, -0.010831, -1.375317, 2.524816, 0.099206, -0.026269, -2.223224, -0.016647, -0.009999, 2.442625, -1.542448, -0.027910, 0.314134, -0.293223, -0.806556, 0.987767, 
	-0.049981, -0.026328, -0.412596, 1.311372, -1.735978, -0.007799, -3.608371, -0.059122, -0.017139, -0.351327, 3.833480, -0.008403, 1.247379, -1.266204, 1.247901, -0.096883, 
	-0.004734, -0.004663, -0.411373, 0.726448, 1.136604, -0.000769, 2.655546, -0.005481, -0.002117, -0.516671, -7.543261, -0.000852, 4.054396, 0.030956, -0.100376, -0.013653, 
	-0.378802, -0.242153, -5.499063, -2.603365, -2.765615, -0.028595, 3.379653, -0.115737, -0.075115, 1.762321, 3.443035, -0.030392, 2.360730, -1.680572, 3.331549, -0.857879, 
	-0.002767, -0.001203, -0.193290, 1.648562, 2.483651, -0.000500, -0.150801, -0.001555, -0.000838, -0.799244, 0.484251, -0.000503, -3.246408, -0.432968, 0.247327, -0.033716, 
	-0.013198, -0.011451, -2.698191, -2.874627, -0.680295, -0.004376, 9.142752, -0.025837, -0.007867, -1.050944, -1.177915, -0.004534, -1.420881, 0.564894, 0.987047, -0.724579, 
	-0.046935, -0.008962, -0.778438, 0.424431, 8.190907, -0.006850, -3.126709, -0.029941, -0.015017, 1.364109, -2.572363, 0.016905, -1.668667, 0.940352, -2.390028, -0.292791, 
	-0.002866, -0.001524, -0.110189, -2.163048, 0.105531, -0.000318, -0.410326, -0.000893, -0.000760, 0.806217, 0.357436, -0.000349, 0.333533, 0.314988, 0.777111, -0.004544, 
	-0.017982, 0.001792, 0.457890, -2.471506, 0.459594, -0.002135, 0.141188, -0.039120, -0.006556, 0.197919, 0.589501, -0.002424, -0.079744, 1.665684, -0.854917, -0.039184, 
	-0.402467, -0.119714, 3.592850, -1.860965, -2.694048, -0.036956, -0.950146, -0.209206, -0.080290, 0.726479, 4.582281, -0.052782, -2.777930, -1.387669, 2.207262, -0.536699, 
	-0.002479, -0.001315, 1.080368, -0.853888, 0.325904, -0.000294, -0.598843, -0.001199, -0.000707, 0.761305, -0.625539, -0.000341, 0.277198, -0.181461, -0.173788, -0.004922, 
	-0.002009, -0.002046, 0.231094, -0.257516, -1.170967, -0.000504, 1.188152, -0.001644, -0.001011, -0.254409, 3.386982, -0.000539, -3.219935, -0.131944, 0.271709, -0.035414, 
	-0.051885, -0.016092, 1.593680, -2.211367, 0.150532, -0.003621, 0.031679, -0.019761, -0.008959, 1.230770, -2.000555, -0.004121, 3.570038, -1.934062, -1.385961, 1.059685, 
	-0.004854, -0.004974, -1.813863, -0.698300, -1.039122, -0.001242, -1.496301, -0.007306, -0.002994, 2.875077, -1.980435, -0.001435, 4.257955, -1.019231, 0.066491, 0.870535, 
	-0.017416, -0.005393, 0.183254, -0.505325, 5.722674, -0.001639, -2.640707, -0.007718, -0.003449, -1.488682, -3.002034, -0.001675, 0.523735, -0.064737, 1.361705, -0.052593, 
	-0.002700, -0.002071, -0.074633, 0.840545, -0.576270, -0.000760, -1.286119, -0.001416, -0.001018, -0.111453, 0.276565, -0.000802, 0.052459, -0.071259, 1.081251, -0.122320, 
	-0.014851, 0.046542, 1.137387, 3.373746, -4.869040, -0.002775, -1.647185, -0.083398, -0.006622, 4.731452, 1.323651, -0.002723, -1.770915, -1.148265, -0.975560, -0.091441, 
	-0.019053, -0.004360, -0.935571, -1.152171, -2.350082, -0.001113, -0.843538, -0.009367, -0.002841, 3.244667, 0.281840, -0.001254, 1.319336, -0.505022, 1.075977, -0.097447, 
	-0.007715, -0.003066, -3.587843, -0.409774, -1.424889, -0.000971, 1.782737, -0.008891, -0.002191, 4.414371, 4.205455, -0.001038, -4.149154, -0.437422, -0.357613, -0.011996, 
	-0.031197, -0.018838, -4.484817, -0.664042, -2.226426, -0.005486, -1.104919, -0.026554, -0.011033, -1.048745, 2.775332, -0.005862, 4.295045, 3.884164, -0.983142, -0.343480, 
	-0.038547, 0.692488, -0.083053, -1.794431, -2.765570, -0.009665, 1.869814, -0.268395, -0.020377, -3.037645, -0.362418, -0.010076, -0.806336, 2.743660, 1.026425, 2.864127, 
	-0.002421, -0.001604, -0.516324, -0.880530, -0.129081, -0.001067, -0.028002, -0.001782, -0.001450, 3.512604, 0.848232, -0.001084, -0.953794, -1.557956, -0.258877, -0.026863, 
	-0.014214, -0.005310, -0.870271, 3.595276, -0.833867, -0.001625, -2.325649, -0.003510, -0.003232, -0.658899, 0.491275, -0.001716, -1.775485, 2.584739, -0.156871, -0.020642, 
	-0.018450, -0.010894, 1.343421, -0.985971, -2.682932, -0.002345, -2.143276, -0.016805, -0.007406, 1.537970, 4.492007, -0.002582, 1.642813, -2.573547, -0.359931, -0.212074, 
	-0.013185, -0.012099, -0.539001, -0.163017, 1.013431, -0.002910, -2.864729, -0.012044, -0.006022, 1.624842, -0.303347, -0.003055, 0.763445, 0.070085, 0.685144, -0.237538, 
	-0.001684, -0.001013, -0.335601, -0.209773, 0.812682, -0.000537, 0.562597, -0.003462, -0.000901, -0.542450, -0.616671, -0.000553, -0.441203, -0.242247, 1.032634, -0.011820, 
	-0.110789, -0.040754, -0.517415, -0.485840, -0.422937, -0.017307, 0.431630, -0.139200, 0.247343, 1.043908, -0.393405, -0.018095, 0.523080, 0.539954, -1.618172, 0.977999, 
	-0.150663, -0.028142, 2.315163, 1.285966, 3.078272, -0.007318, 5.244560, -0.045712, -0.017701, -1.450570, -3.801529, -0.007819, -0.821262, -4.540836, -0.736229, -0.316178, 
	-0.007338, -0.006561, 6.375344, 0.031115, -2.776253, -0.002497, 0.931199, -0.013689, -0.004442, -0.960704, 4.261029, -0.002580, -4.992724, -2.292944, -0.479026, -0.059928, 
	-0.038635, -0.004058, 0.707758, -1.367032, 0.975249, -0.001480, -0.537698, -0.026599, -0.003739, -2.869986, 6.396625, -0.005921, -5.210067, 2.321528, -0.111271, -0.224673, 
	-0.045857, 0.203607, 0.029853, -0.336600, -0.548872, -0.003042, -0.990272, -0.214034, -0.005872, -1.220283, 1.474944, -0.003164, -0.347403, -1.271176, 3.355665, -0.077491, 
	-0.003609, -0.001705, -0.379242, -0.337800, 0.037623, -0.000443, 0.031250, -0.002826, -0.001393, -0.115725, 0.981556, 0.048354, -0.222583, -0.005939, -0.015628, -0.011889, 
	-0.000947, -0.001105, 0.045879, -0.324429, -0.484960, -0.000357, -0.769352, -0.001746, -0.000713, 0.489135, 0.454135, -0.000367, -0.045626, -0.157173, 0.803649, -0.006023, 
	-0.141533, 0.208948, -3.074978, -2.390450, 0.920710, -0.011330, 2.084025, -0.085735, -0.029361, 0.900157, -3.089535, -0.012024, 3.112180, 0.988594, -0.036921, 0.657252, 
	-0.021622, -0.018223, 0.854627, -4.373107, 2.583340, -0.004456, 2.397749, -0.063153, -0.012789, 0.547814, 4.187483, -0.005032, -4.101402, 0.204598, -1.912329, -0.263498, 
	-0.060227, -0.004613, 0.213786, 2.095113, -1.850032, -0.000958, 0.740934, -0.004173, -0.002458, -1.075235, -1.927259, -0.001037, -0.471473, 0.632437, 1.857652, -0.142455, 
	-0.015139, -0.001476, 0.004515, 0.853125, -1.829039, -0.000598, -0.911767, -0.001297, -0.000900, -0.154500, 0.261724, -0.000554, 1.922156, -0.099608, 0.053766, -0.080409, 
	-0.010486, -0.010842, 4.478281, -0.594933, -4.383178, -0.003460, -6.167118, -0.018945, -0.007117, 0.503380, 5.474795, -0.003630, 1.931220, -2.151078, 1.150451, -0.187341, 
	-0.063691, 0.168114, -1.257706, -0.374867, -0.384754, -0.002637, 3.625157, -0.171562, -0.005521, 2.685398, -2.417372, -0.002767, -3.313324, -0.980854, 2.581333, -0.084947, 
	-0.005717, -0.004971, 1.978168, 0.203541, -0.397006, -0.001234, -0.036254, -0.007938, -0.003129, -1.697755, -1.921930, -0.001339, 3.062478, -0.640588, -0.472192, -0.054134, 
	-0.046971, -0.016965, 2.868962, 2.255182, 1.195722, -0.002547, 3.609661, -0.016918, -0.008843, 0.245052, -2.536204, -0.002919, -4.793789, -1.416943, -1.090016, -0.242465, 
	-0.136562, -0.048343, -3.078918, -2.008331, 0.430681, -0.012388, 2.671879, -0.044025, -0.023067, -0.630226, -1.362244, -0.013039, -1.172241, 3.930372, 0.580304, 0.916149, 
	-0.013233, -0.004858, 0.946919, 1.627917, -0.657851, -0.002045, -2.482382, -0.011964, -0.004014, -1.237796, 2.447561, -0.002127, 1.441236, -0.469346, -1.541412, -0.036605, 
	-0.058812, -0.027358, -1.593799, 2.906447, -2.728729, -0.004545, -2.186339, -0.121096, -0.013165, 0.996760, 1.783361, -0.004927, 2.751002, 0.829005, -2.298136, -0.229668, 
	-0.112894, -0.073634, 1.126217, -1.106362, -3.013602, -0.015975, 2.990036, -0.068876, -0.035147, -1.409244, -0.106710, -0.016374, 0.928191, -0.883140, 1.461874, 0.335641, 
	-0.130038, -0.078786, -1.245802, -2.753545, 0.356833, -0.026778, -0.054351, -0.106034, -0.048064, -2.979623, 0.420768, -0.028609, 4.703928, -1.883007, 3.820731, 0.032378, 
	-0.134286, -0.044638, -3.966980, -4.132525, -8.703685, -0.025654, -12.759227, -0.053917, -0.031351, 0.556449, 16.375647, -0.030764, 15.183990, -4.752434, -5.625076, 8.144451, 
	-0.012343, -0.012037, -0.765058, -0.208606, 1.818889, -0.001921, -0.990873, -0.028368, -0.007052, -3.813389, 1.153412, -0.002285, 3.523269, -0.698045, 0.132431, -0.088026, 
	-0.002134, -0.000320, -0.041593, 0.066386, -0.031394, -0.000092, -0.058730, -0.000549, -0.000235, -0.085724, 0.014919, -0.000094, 0.235089, -0.106108, 0.012722, -0.002143, 
	-0.011261, -0.007994, 0.892247, 0.527483, 2.364177, -0.002109, 3.352316, -0.009890, -0.005017, 1.781275, 0.963327, -0.002229, -7.128552, -2.382455, -0.255374, -0.075943, 
	-0.011274, -0.010678, -0.435471, -1.059835, 0.677919, -0.002560, -0.223592, -0.026409, -0.007097, 1.688757, 2.742633, -0.002789, -2.501006, -0.552252, -0.098399, -0.177946, 
	-0.013354, -0.013414, -1.237056, 0.880359, -2.184003, -0.002150, -1.859391, -0.026634, -0.010102, -1.177699, 4.515211, -0.002281, -1.936087, 3.367981, -0.077369, -0.224011, 
	-0.001222, -0.000874, -1.019638, 0.864559, 0.163800, -0.000341, -0.477402, -0.001754, -0.000621, 0.015217, -0.044995, -0.000361, 0.011368, 0.652664, -0.153831, -0.006568, 
	-0.036952, -0.012557, -0.770384, -1.581766, 2.035822, -0.002598, 2.068958, -0.011328, -0.007043, 2.405723, -1.015867, -0.002973, -0.699527, -0.548862, -1.639964, -0.180682, 
	-0.061058, -0.018632, -0.399067, -2.232478, -1.690408, -0.007539, 7.255803, -0.034062, -0.013858, -1.097566, -5.539405, -0.007556, 5.440032, -1.673257, 0.516871, -0.437822, 
	-0.022937, -0.019049, 6.626892, -2.031395, 3.207379, -0.004533, 3.137952, -0.020802, -0.010845, -3.244362, -2.361378, -0.004795, -1.734620, -1.575110, -1.785612, -0.156784, 
	2.405059, -0.007841, 0.474970, -2.514629, 1.832211, -0.002842, -1.010666, -0.008196, -0.004775, -0.058265, -1.975419, -0.002931, 0.892951, 1.349321, -1.317692, -0.051256, 
	-0.015385, -0.003235, -0.947545, 5.269268, -0.224392, -0.001653, -0.672682, -0.007746, -0.003423, -2.830062, 1.621470, -0.001731, -2.410352, 0.368268, 0.043267, -0.184067, 
	-0.143963, -0.032685, -3.180291, -1.091361, 1.518033, -0.007283, -1.843302, -0.060000, -0.016186, -0.828303, 2.798326, -0.007972, -1.271588, 2.818222, 1.835873, -0.487520, 
	-0.024294, -0.009817, 1.710135, -1.756647, -1.092754, -0.004987, 3.445758, -0.010543, -0.006789, -2.498576, 1.376730, -0.005667, -1.394425, -1.257668, 1.565974, -0.036431, 
	-0.021041, -0.011775, 4.604825, 0.919191, -2.559934, -0.004917, -1.194087, -0.016658, -0.008330, -3.680795, -0.720252, -0.013876, 3.694488, 1.230984, -2.143595, -0.074225, 
	-0.002837, -0.003297, -1.394381, 0.181303, -2.228070, -0.000625, -0.542456, -0.003325, -0.002366, 0.230514, -5.011410, -0.000756, 8.159721, 1.053035, -0.246293, -0.188757, 
	-0.011325, -0.002549, -0.306009, 0.382062, 0.637597, -0.000835, 1.741009, -0.005021, -0.002359, -0.547460, -2.377062, -0.000901, 0.879877, -0.482182, 0.130621, -0.035464, 
	-0.021253, -0.011710, 0.841310, -1.038088, 2.565938, -0.002958, 2.866923, -0.024099, -0.009098, -0.054729, -2.603903, 0.020108, 1.529108, -0.696936, -3.317931, -0.042683, 
	-0.084414, -0.017823, 1.703329, -3.876956, -3.020017, -0.008152, -4.352437, -0.021476, -0.012019, 1.422435, 5.171529, -0.008558, -1.874776, 0.381476, 5.164150, -0.566291, 
	-0.099632, -0.068558, 5.423842, 2.124528, -5.495978, -0.031515, 3.634737, -0.066384, -0.046725, -7.077966, 2.120989, -0.032479, -4.097814, 2.113374, 0.422517, 1.177063, 
	-0.015284, -0.008121, 4.243863, -1.732451, -1.641461, -0.002466, 2.206061, -0.054001, 0.000101, 2.491395, 1.915455, -0.005017, -2.903333, -3.193769, -1.160017, -0.140954, 
	-0.022185, -0.004641, -1.287640, -0.204375, -0.903098, -0.001277, 1.139565, -0.003757, -0.002588, -0.564871, 1.075406, -0.001391, -0.341829, -0.363252, 1.517425, -0.031492, 
	-0.038432, -0.011633, 2.604556, 0.053085, 1.182691, -0.003840, -4.713602, -0.011592, -0.006903, -3.991124, -4.319667, 0.020590, 8.781273, 0.128778, 0.781382, -0.455564, 
	-0.007615, -0.010550, 5.495984, 0.652582, -0.085675, -0.002454, -1.277132, -0.015236, -0.005262, -3.671202, -0.373303, -0.002912, 0.590798, 0.608138, -1.730200, -0.165963, 
	-0.022560, -0.011556, 9.985820, -2.541718, 4.279782, -0.006230, -1.887220, -0.016649, -0.008686, -0.693370, -2.827515, -0.006375, -1.774499, -3.224930, -1.535375, 0.291080, 
	-0.173308, -0.043617, -1.811322, 3.717952, -1.199204, -0.010591, 1.307286, -0.070102, -0.025217, 2.624310, -0.613923, -0.011608, -0.694126, -2.108829, -0.365269, -0.522432, 
	-0.003458, -0.001601, -0.051044, -0.207350, -0.363923, -0.000333, -1.052984, -0.001074, -0.000672, 0.525134, 0.595167, -0.000349, 0.471929, -0.057535, 0.171498, -0.023405, 
	-0.011342, -0.006664, -1.012389, -2.376253, 7.050798, -0.002330, -0.493656, -0.010933, -0.004589, -0.705566, -0.671031, -0.002455, -2.133391, 0.182945, 0.325375, -0.128517, 
	-0.002785, -0.001711, -0.592237, 0.084715, -1.690025, -0.000614, -1.038191, -0.005603, -0.001536, -0.557473, -2.795557, -0.000673, 4.317543, -0.417625, 2.706339, -0.004565, 
	-0.002335, 0.269058, -0.655611, -0.452748, -0.405861, -0.001101, -0.863937, -0.259811, -0.001783, 0.626638, 5.966642, -0.001137, -5.036198, -0.142018, 0.971571, -0.011368, 
	-0.011096, -0.005356, -0.347833, -2.643017, -0.084568, -0.001537, 1.393702, -0.006294, -0.003461, 2.961889, -6.514722, -0.001578, 6.246595, -1.134308, -0.198236, 0.349820, 
	-0.041479, -0.019101, -2.862447, -1.528149, 4.576049, -0.003958, 4.290303, -0.026860, -0.009560, 1.344006, -0.855278, -0.004544, -3.010235, -0.327383, -1.271309, -0.250052, 
	-0.008806, -0.009056, -0.637314, 1.842711, -0.909576, -0.001228, -2.414074, -0.011424, -0.004606, 1.613940, -0.667174, -0.001440, 2.690065, 1.145867, -1.974472, -0.653410, 
	-0.126022, -0.083392, 2.008612, -2.443739, 1.803750, -0.021212, 3.300374, -0.117640, -0.051861, -3.265875, -3.320791, -0.030001, 3.799479, 1.457125, -2.258384, -0.650425, 
	-0.058015, -0.035282, -1.589457, -2.077314, -1.402802, -0.007438, 3.733380, -0.038921, -0.018580, 2.845945, 0.489458, -0.008077, 0.806175, -0.435738, -2.216949, 0.013615, 
	-0.031246, -0.010699, -0.210874, 0.386272, -1.791109, -0.003342, -0.011816, -0.022661, -0.007259, -1.366920, -0.431834, -0.003592, 2.220381, 1.274808, 0.071976, -0.062085, 
	-0.011066, -0.008264, -0.833651, -0.935028, -0.967795, -0.001557, -0.511771, -0.012332, -0.004296, 2.345327, 1.235342, -0.001774, -0.235463, -0.338880, 0.321204, -0.039994, 
	-0.027422, -0.013163, -1.485261, -2.736579, 0.487100, -0.003390, -0.883838, -0.037028, -0.008543, -0.605666, 3.780165, -0.003952, 2.781429, -1.815283, 0.754877, -0.183446, 
	-0.021942, -0.010287, 0.891086, -1.733213, -3.025562, -0.002499, -4.787848, -0.014260, -0.006124, -0.130277, 1.103691, -0.002660, 5.161244, 2.527422, 0.130803, -0.079577, 
	-0.056496, -0.018934, 0.846811, -1.695910, -5.934331, -0.006863, -0.753291, -0.042213, -0.012602, -1.302242, 7.004174, -0.006984, 1.672039, 0.398607, 0.156275, -0.248039, 
	-0.062540, -0.011489, 5.097951, -5.634247, -2.101066, -0.003664, 8.283698, -0.056938, -0.010124, -1.805227, -9.180234, -0.004027, 6.628365, -0.352325, -0.669045, -0.119088, 
	-0.059770, -0.016129, -1.744308, -1.939031, 1.896160, -0.003373, -0.592004, -0.024890, -0.013387, 0.317501, -0.181804, -0.003247, 2.352822, 1.186273, -1.080999, -0.093814, 
	2.323204, -0.013042, 1.210852, -1.029682, -1.335318, -0.002899, -1.695459, -0.020062, -0.008096, 1.727900, -6.732141, -0.003105, 2.820700, 2.615034, 0.265588, -0.123473, 
	-0.002673, -0.001730, -0.139345, -0.641276, -0.969152, -0.000456, 0.802917, -0.002648, -0.001219, -0.149667, 2.127499, -0.000504, -2.269716, 0.441161, 0.816353, -0.009544, 
	-0.046564, -0.028271, -4.311610, -3.570400, 10.850885, -0.011742, -3.981291, -0.033674, -0.019372, 9.043408, -1.594807, -0.012029, -3.797628, 0.468072, -2.349766, -0.605211, 
	-0.026537, -0.014603, 3.899683, -1.851863, 1.738793, -0.003285, 1.011603, -0.017197, -0.007969, -5.415890, -0.116575, -0.003600, -0.707606, 2.891462, -1.212438, -0.163978, 
	-0.033999, -0.019384, 1.789511, 1.666845, -0.521726, -0.006112, 3.267260, -0.025370, -0.013550, -1.674456, -0.731425, -0.006791, -4.039528, 2.467704, -1.822371, -0.296606, 
	-0.001708, -0.002192, 3.714266, 0.526253, 0.266398, -0.000425, -0.175133, -0.001654, -0.001014, -0.805727, -0.450531, -0.000543, -0.388065, -2.510001, -0.164311, -0.005613, 
	-0.027083, -0.005162, -0.301505, -0.397378, -0.273391, -0.003263, -0.649495, -0.011314, -0.004674, -0.233750, -2.881616, -0.003363, 2.343972, -0.096250, 2.657476, -0.113206, 
	-0.017955, 0.001329, -0.865520, -0.694408, -0.312544, -0.002640, -0.465304, -0.026985, -0.003131, -1.808366, 1.778260, -0.002764, 0.729542, 1.953716, 0.029783, -0.293013, 
	-0.002594, -0.003115, 0.792620, 0.382126, -0.334682, -0.001166, -2.607176, -0.003703, -0.002292, 2.628660, 0.639937, -0.001237, -0.585116, -1.083965, 0.211162, -0.029458, 
	-0.015242, -0.009470, 1.427760, 2.214076, -1.841407, -0.003248, -1.339594, -0.016716, -0.006502, -2.052010, -2.687652, -0.003351, 0.313419, -0.698751, 4.819772, -0.101084, 
	-0.014698, -0.008335, 1.839813, -3.069225, -0.212579, -0.002646, 1.240480, -0.008167, -0.005296, -0.544940, -2.032311, -0.002789, 1.120438, 1.071731, 0.672612, -0.044089, 
	-0.022515, -0.015694, -1.601346, 1.378901, -0.780897, -0.007653, 3.213917, -0.021532, -0.010393, -1.001541, 8.618073, -0.007758, -8.716743, -1.433888, 0.062303, 0.346764, 
	-0.018611, -0.014592, 4.148319, -0.923650, 4.993463, -0.004274, -1.759203, -0.017689, -0.009313, -4.254534, 0.112383, -0.004587, -1.935531, 0.883824, -0.968856, -0.227149, 
	-0.010825, -0.002308, 2.354486, 1.557985, -1.302642, -0.000706, 2.047045, -0.003971, -0.001896, -0.810958, 2.870301, -0.000749, -3.888605, -1.747486, -1.054310, -0.005360, 
	-0.018432, -0.005058, -1.178090, 0.413757, -1.569132, -0.002925, 0.476281, -0.005167, -0.004028, 2.495633, -0.966010, -0.002955, -0.914179, -1.464055, 2.797326, -0.052967, 
	-0.000715, -0.000457, -0.456319, -0.253842, -0.072123, -0.000144, -2.864154, -0.002312, -0.000372, 1.029665, 1.725163, -0.000136, 1.429510, -0.450955, -0.069549, -0.013260, 
	-0.065319, 1.274848, 7.231240, -1.479150, 2.424916, -0.011778, -1.739031, -1.331448, -0.021619, 2.812922, 2.008666, -0.012233, -5.845047, -1.033328, -3.747044, -0.466595, 
	-0.002445, -0.001528, -1.322888, 0.270551, -0.302631, -0.000516, -0.445393, -0.001654, -0.001020, -0.300763, 0.707987, -0.000569, -0.962229, 0.469282, 1.908355, -0.014539, 
	-0.110963, -0.030142, -0.660708, 1.424630, -1.651556, -0.008015, -1.066321, -0.046950, -0.018327, 0.210302, -1.555644, -0.008541, 2.209416, -1.589616, 3.240901, -0.338466, 
	-0.016877, -0.003586, 1.206453, -0.030522, -0.203809, -0.000843, 0.218411, -0.002817, -0.001776, -1.129473, -2.133920, -0.000872, 2.094173, -0.460969, 0.597082, -0.130655, 
	-0.001089, -0.000869, 1.078104, -0.069645, -0.539227, -0.000259, 0.166931, -0.001151, -0.000680, -0.388339, -1.375676, -0.000324, 1.230024, 0.274362, -0.363727, -0.008433, 
	-0.072200, -0.011618, 2.402064, 1.174517, 0.454720, -0.002307, -1.480192, -0.034611, -0.008604, -1.335276, 3.118450, -0.002727, -2.803992, -2.176918, 0.828823, -0.050130, 
	-0.054007, -0.021133, -1.595597, 1.821534, -1.706585, -0.004803, -1.400496, -0.032445, -0.013531, -0.382229, 2.678193, -0.005166, 0.088869, 0.239384, 0.538474, -0.150462, 
	-0.318838, -0.141465, -3.951748, -7.258110, -0.302244, -0.046989, 3.962995, -0.194320, -0.095345, -0.492685, -0.421890, -0.195968, 4.177427, -2.672567, 8.332531, -0.380785, 
	-0.056222, 0.094172, 2.833078, -1.592781, -4.397773, -0.018329, 12.030066, -0.164117, -0.028125, -0.390015, -9.783626, -0.018768, -1.673036, 2.785237, 0.871863, -0.491624, 
	-0.009724, -0.245973, -0.259676, 3.913127, 1.359722, -0.002373, -3.542598, 0.236598, -0.004015, -0.248469, -1.186703, -0.002404, -2.970576, -1.090819, 4.174947, -0.121063, 
	-0.033141, -0.016061, -0.080099, -1.651268, 0.381248, -0.005296, -3.987937, -0.017555, -0.009839, -2.646596, 2.037856, -0.005475, -0.657135, 5.463544, 0.399058, 0.828695, 
	-0.021742, 0.732567, 0.044437, 2.743859, -1.637169, -0.005071, -3.483228, -0.757493, -0.013386, -1.759221, 2.831348, -0.005848, 3.834105, -0.521401, -1.718174, -0.263584, 
	-0.057967, -0.013905, -0.074240, 2.785465, 1.049679, -0.004460, -0.736129, -0.044947, -0.011315, -2.083696, 2.693502, -0.134133, -3.663700, -0.435869, 0.847195, -0.115481, 
	-0.003040, -0.002615, -1.037925, 1.433915, 1.881408, -0.000989, 0.282828, -0.002768, -0.001755, -2.313352, -0.490954, -0.000604, -0.724687, -0.594336, 0.451866, 1.123008, 
	-0.005746, -0.003447, 0.187225, 0.831837, 0.230541, -0.000642, -1.068375, -0.002697, -0.001599, -0.178438, 0.418373, -0.001004, -0.182888, -0.167734, -0.040291, -0.015117, 
	-0.008936, -0.008435, -0.275704, -2.031589, -1.699808, -0.002269, 2.739935, -0.010002, -0.004990, 1.529054, 3.477807, -0.002443, -3.584129, -0.732962, 1.012853, -0.398382, 
	-0.069545, -0.009631, -0.851132, -0.461110, 1.582840, -0.002756, -0.739712, -0.009951, -0.005650, 0.756830, 0.030884, -0.002895, 2.107407, -0.995341, -1.144685, -0.185552, 
	-0.038587, -0.027260, 1.661022, -2.430943, 3.286938, -0.008104, -1.715249, -0.027253, -0.015787, 1.397172, -3.276118, -0.008806, 0.947980, 0.693798, 0.202587, -0.641389, 
	-0.004576, -0.004073, -1.541946, -0.035644, -2.472289, -0.000966, 1.054127, -0.004126, -0.002665, 2.497276, -0.295776, -0.000985, -1.440837, 0.368874, -0.095694, 1.979298, 
	-0.001319, -0.001160, 0.795965, 0.568994, -0.633609, -0.000290, -0.698256, -0.003052, -0.000873, -1.346669, 0.288042, -0.000268, 0.544223, 0.531253, -0.038667, -0.004316, 
	-0.136623, -0.034035, 7.345615, 3.872126, 1.125329, -0.013540, -0.625224, -0.042002, -0.023700, -4.656994, -1.981762, -0.018359, -1.815277, -3.206511, 0.513987, -0.303032, 
	-0.007901, -0.005763, -2.379292, 2.803384, 0.451214, -0.001735, -0.468569, -0.005895, -0.003304, 0.075521, 0.797593, -0.001835, -1.074912, 0.780738, -0.908927, -0.050315, 
	-0.001929, -0.001828, 0.714885, -0.231359, -0.727718, -0.000451, -0.419993, -0.007320, -0.001530, -0.901705, 2.586180, -0.000521, -0.414945, -0.316062, -0.045708, -0.229997, 
	-0.276278, -0.136988, -1.092538, -1.499184, 2.867764, -0.032773, -0.126651, -0.146912, -0.073992, -2.599954, 1.107480, -0.043634, 2.666452, 0.472619, -0.035983, -1.049428, 
	-0.022312, -0.009051, -0.104505, 0.059274, 2.356295, -0.002277, 0.409362, -0.005406, -0.004040, -0.950822, -2.640647, -0.002358, 2.074708, -0.272187, -0.680253, -0.205780, 
	-0.029216, -0.005197, -1.583425, 0.358954, 3.991291, -0.001794, -0.202237, -0.006394, -0.004175, -1.505821, 3.048230, -0.002585, -2.006186, -1.292360, -0.697596, -0.061488, 
	2.006292, 0.076632, 0.455835, -2.214231, 1.831734, -0.037677, 4.326571, -0.259901, -0.074884, -1.596301, -10.510108, -0.039681, 7.271703, 1.326506, -0.773849, -1.788641, 
	-0.018138, -0.005132, 7.612263, -1.041250, 0.919705, -0.001538, -2.222973, -0.048299, -0.006832, -2.571551, -3.661600, -0.004037, 2.904716, -2.261683, 0.543864, -0.137515, 
	-0.032035, -0.010292, -0.188405, -3.660569, 1.041080, -0.001723, -0.923557, -0.005806, -0.004132, 2.788960, -1.499460, -0.001773, -0.271087, -1.472274, 4.336480, -0.095408, 
	-0.067325, -0.029224, -0.885719, 0.910171, -2.087837, -0.010519, -1.569118, -0.053525, -0.019396, -2.996741, 1.777677, -0.010919, 0.658946, 0.960747, 3.347260, 0.075522, 
	-0.012567, -0.010943, -0.993631, -0.053790, 0.184481, -0.002679, 0.744020, -0.012892, -0.006448, 2.694511, 2.386277, -0.002861, -5.011362, -0.404739, 0.837666, -0.335041, 
	-0.039848, -0.023349, -1.594793, 2.160176, 1.018262, -0.008549, -1.287342, -0.050479, 0.112226, -1.566531, 0.401355, -0.008712, -2.636745, 3.102885, 0.608111, -0.186666, 
	-0.010959, -0.006699, -2.809678, -0.884292, -1.468981, -0.002034, 0.230881, -0.011315, -0.005013, 2.390095, -0.905474, -0.002171, 1.291221, 0.151213, 2.119248, -0.076044, 
	-0.010562, -0.008123, -0.952597, -0.376422, 2.617903, -0.001570, -0.756442, -0.011398, -0.004718, -0.946522, 1.221491, -0.001825, 1.285821, -2.001734, 0.116911, -0.170213, 
	-0.222669, -0.094349, 0.154865, -1.607095, 6.650293, -0.022094, -2.045956, -0.110192, -0.049726, -0.774685, 0.666140, -0.023833, 0.663009, -1.029764, -0.450096, -1.703847, 
	-0.012216, -0.008472, -0.993046, 0.699936, -2.305482, -0.003619, 2.480075, -0.012329, -0.006197, 1.970673, 1.034059, -0.003744, -0.951660, -0.787243, -1.020537, -0.080197, 
	-0.001988, -0.000938, 0.992784, -0.814364, -0.165559, -0.000496, -0.097767, -0.001338, -0.000768, -0.416351, 0.196527, -0.000492, -0.217952, 1.006393, -0.472157, -0.005534, 
	-0.001426, -0.001033, -0.166770, 0.793358, 1.620501, -0.000367, -1.033327, -0.001309, -0.000697, -0.387307, -1.106259, -0.000382, 0.714150, -0.077371, -0.320883, -0.030878, 
	0.292247, -0.385224, 3.132746, -2.049052, -1.748765, -0.145426, 0.550358, -0.723583, -0.302225, 1.834195, -1.724141, -0.304659, 2.807247, -0.119608, 1.802005, -2.916115, 
	-0.084519, -0.042332, -0.835993, 2.305985, -2.260388, -0.007085, 1.111707, -0.236208, -0.019279, -3.536767, 0.491890, -0.007690, 3.871032, -0.487441, 0.343348, -0.606260, 
	-0.002981, -0.002489, -0.238691, 0.359297, -0.796582, -0.000938, -2.609753, -0.002207, -0.001721, -0.290302, -1.124101, -0.000963, -0.519585, -0.282251, 5.678689, -0.165422, 
	-0.058872, -0.035152, -1.106694, 1.795398, -2.316834, -0.011482, 5.136581, -0.056117, -0.024088, 0.807967, 0.091058, -0.011622, -2.649435, -2.129907, 0.865225, -0.296027, 
	-0.011980, -0.002823, -1.029131, 7.619778, -0.715994, -0.001017, -0.806722, -0.002632, -0.001839, -5.265650, 1.230868, -0.001047, -0.637146, -0.508027, 0.272208, -0.138847, 
	-0.134617, -0.030256, 2.797461, -4.779011, 0.065111, -0.008269, 2.162714, -0.041433, -0.018488, 1.006553, -2.348320, -0.008807, -1.029851, -1.654767, 4.423007, -0.401027, 
	-0.070175, 0.135729, 0.570932, -0.104230, -4.648051, 0.365851, -2.833217, -0.093691, -0.038851, -2.099557, 5.961025, -0.032249, 2.250573, -0.767029, 0.692190, 0.710749, 
	-0.025743, 0.374623, -0.870772, -2.043196, -3.623378, -0.002088, 2.912960, -0.023888, -0.005977, 0.818830, 2.375773, -0.002340, -0.426644, 1.106513, -0.483923, -0.080750, 
	-0.003442, -0.002655, -1.323858, 2.297202, 0.562930, -0.001188, -3.375510, -0.003584, -0.002097, 1.303273, 2.799930, -0.001246, -1.279500, -1.132396, 0.320368, -0.158227, 
	-0.038754, -0.016525, -1.421728, -0.444953, 1.021053, -0.003972, -0.350339, -0.025312, 0.052949, 2.634093, 2.671519, -0.004416, -3.892857, 1.157716, -1.201583, -0.136892, 
	-0.010791, -0.009496, -0.648628, 0.425738, 0.695938, -0.001101, -0.033321, -0.006849, -0.004335, 0.660251, 1.060371, -0.001176, -1.904591, 1.031092, -1.139269, -0.113835, 
	-0.101668, -0.007372, -2.709153, -3.365635, -3.086934, -0.008645, 0.574045, -0.034436, -0.014644, 0.170334, 13.609579, -0.008962, -5.284138, -1.182940, -0.100116, 1.550685, 
	-0.012448, -0.011675, 0.777720, -0.297398, -1.218907, -0.002070, -3.748074, -0.011604, -0.005600, 1.051183, 3.087921, -0.002092, 0.489993, 0.988128, -0.964652, -0.120423, 
	-0.102860, -0.037218, -2.884791, 0.473023, -0.250151, -0.009542, -2.372095, -0.082266, -0.025343, -1.182586, 4.824728, -0.012581, 1.648093, 0.444303, -0.099956, -0.330759, 
	-0.056448, -0.013253, 3.630066, -0.366286, -2.645856, -0.003008, -1.446704, -0.015743, -0.007893, -1.274204, -0.649589, -0.003321, 5.044369, 0.934620, -2.967247, -0.159504, 
	-0.024175, -0.006052, -0.798197, 0.604680, -0.736730, -0.001548, 3.735883, -0.011286, -0.003969, -0.320834, -0.180799, -0.001744, -0.925177, -0.640906, -0.663545, -0.025601, 
	-0.000991, -0.001130, -0.727998, 0.028833, -0.487217, -0.000276, -0.126714, -0.000724, -0.000611, 0.767585, 0.154911, -0.000284, 0.294940, -0.060158, 0.165333, -0.005499, 
	-0.003934, -0.001273, 1.357920, 0.048276, -1.537465, -0.000334, 1.545712, -0.004986, -0.000840, -0.831215, 2.348091, -0.000364, -1.588855, -1.229768, -0.077157, -0.023809, 
	-0.013624, -0.007912, -0.656672, -1.921277, -1.834620, -0.002705, -0.086310, -0.015515, -0.006843, 4.330102, -1.444496, -0.002771, -1.411969, 1.321074, 1.828669, -0.075131, 
	-0.009838, -0.006767, 1.221849, -0.966674, -0.772269, -0.001477, -0.003671, -0.008443, -0.004059, 2.749416, -1.212251, -0.001603, 1.130532, -1.925766, -0.156470, -0.032509, 
	-0.063947, -0.026920, -4.032104, -6.558343, 5.708757, -0.009585, -3.736366, -0.047863, -0.018612, 4.953080, -0.480883, -0.010010, 6.181592, 3.106243, -4.314075, -0.650964, 
	-0.014159, -0.009519, -0.643637, 1.367055, 2.198612, -0.003174, -3.992907, -0.023860, -0.006992, -1.145900, 1.246497, -0.003367, -0.747962, -0.408151, 1.162597, 1.024867, 
	-0.072887, -0.061886, -0.633510, 4.918000, -0.434814, -0.016235, -0.499404, -0.067727, -0.038426, -0.452003, -0.684565, -0.017139, -1.019176, 0.414226, -0.396481, -0.937976, 
	-0.008869, -0.005565, 0.121930, 0.220599, 0.928881, -0.001393, 0.586254, -0.019758, -0.003970, 0.472010, -0.000356, -0.001492, -1.199276, -0.250937, -0.818742, -0.019315, 
	-0.128105, -0.062380, 2.614073, -2.350127, 1.675923, -0.023590, 5.141100, -0.124463, -0.046670, 0.038542, 3.011683, 0.024052, -3.364376, -3.009219, -2.698523, -0.697920, 
	-0.009107, -0.005642, 2.058086, -0.945989, 4.357527, -0.002961, -2.014393, -0.006804, -0.004245, -1.602990, -3.205490, -0.003017, 1.546586, -0.074189, -0.007729, -0.079643, 
	-0.028241, 0.002726, -2.104941, 3.462078, -3.666992, -0.001988, -1.938891, -0.020536, -0.005044, 0.732888, 0.610743, -0.002087, 3.953884, -0.189657, -0.904292, 0.100350, 
	-0.021969, 0.768898, 1.027713, 3.182018, -0.054224, -0.003427, -3.741858, -0.042960, -0.008167, 3.218264, 0.039106, -0.003320, -1.737351, -2.653529, 0.399897, -0.369090, 
	-0.004808, -0.002361, -0.691365, 0.367772, -0.266321, -0.000471, 0.455148, -0.005986, -0.001234, 0.235315, -4.082077, -0.000524, 4.584774, -0.250393, -0.282920, -0.054548, 
	-0.055084, -0.018011, -1.042453, -0.470763, 2.347340, -0.010794, 0.526188, -0.068763, -0.022333, 2.704633, 3.870956, -0.015535, -5.474172, -2.158150, 0.187156, -0.300215, 
	-0.032452, 0.553322, -1.446446, 1.624522, 0.268860, -0.001894, 0.268072, -0.078927, -0.002938, 0.062644, 0.031374, -0.001942, -0.124045, -0.669234, -0.403649, -0.047267, 
	-0.009746, -0.001875, 0.332732, -0.517172, 0.202924, -0.000536, -3.110437, -0.002952, -0.001121, -0.206041, -0.636922, -0.000568, 4.141727, -0.269020, 0.084498, -0.005493, 
	-0.158435, -0.024877, -0.547423, -1.041356, -2.985927, -0.014140, 5.042599, -0.598374, -0.032840, 0.929546, -1.863442, -0.014608, -1.046644, -0.351524, 0.078514, 2.628932, 
	-0.163180, -0.070332, 4.526165, 0.798605, -3.008428, -0.036070, 2.382842, -0.113621, -0.061658, 2.869448, -0.499405, -0.038262, -2.937251, -5.500774, 2.563605, -0.711684, 
	-0.024041, -0.007225, -1.998250, 1.465331, -0.642406, -0.001526, 0.414879, -0.007188, -0.003852, 1.546403, 2.152557, -0.001594, -1.583774, -0.701859, -0.493826, -0.113630, 
	-0.018994, -0.023017, -0.599407, -1.977040, 0.243843, -0.005359, -3.455707, -0.026601, -0.013073, 0.994669, -1.875012, -0.005588, 5.557400, 1.771663, -0.454084, -0.113692, 
	-0.013223, -0.010542, -0.708095, -1.317066, 2.532186, -0.002443, -2.349982, -0.012380, -0.005726, -0.710007, -4.103330, -0.002602, 5.463952, 2.526409, -1.236429, -0.050721, 
	-0.331117, -0.156545, 2.411111, 0.907659, -2.576635, -0.039670, -0.767945, -0.262686, -0.094826, -3.428364, 0.837170, -0.045985, 4.550188, -1.556094, 2.777604, -2.223865, 
	-0.002660, -0.002068, 0.178729, -0.082931, -0.632411, -0.000951, 2.442366, -0.002077, -0.001584, -0.646474, -1.880230, -0.000881, 0.604646, -0.133652, 0.199478, -0.039299, 
	-0.022290, -0.012643, -1.179790, 4.810953, 2.425064, -0.003925, 0.541219, -0.024984, -0.008572, -1.590008, 2.121170, -0.004096, -2.246277, -2.307632, -1.273564, -1.224624, 
	-0.090566, -0.022513, -0.352572, -3.488171, -1.944335, -0.005719, 1.786316, -0.058361, -0.013497, -0.777592, 3.566724, -0.006067, 2.181160, 1.215269, -1.788251, -0.201825, 
	8.613448, 0.500642, 0.473937, -7.042099, 3.080584, 9.434816, -7.459047, -1.209532, -0.504526, -4.318878, -10.014385, 9.059931, -6.698660, -5.223348, 1.697647, 9.609472, 
	-0.002463, -0.004345, 0.019933, -1.651744, -0.813307, -0.000600, 0.555473, -0.001766, -0.001552, -0.491624, 1.427604, -0.000640, -1.658563, 3.939955, -1.302074, -0.014287, 
	-0.284694, 0.035551, -1.988568, -0.526056, -2.926046, -0.004131, 0.263342, -0.069686, -0.009688, 1.221945, 4.149618, -0.004398, 1.244706, -0.148604, -0.812182, -0.141109, 
	-0.010713, -0.012878, -3.618758, 0.796105, -1.180138, -0.003885, 2.422487, -0.013659, -0.008147, 3.199249, 3.519431, -0.008316, -4.021611, -0.594039, -0.333502, -0.131628, 
	-0.012034, -0.009938, -1.258214, -0.322486, 0.588180, -0.001660, 2.051108, -0.013072, -0.006349, 0.983559, 2.541696, -0.002377, -0.411635, -0.897385, -2.961117, -0.268278, 
	-0.044206, -0.008956, -1.763761, -1.970989, 8.934914, -0.004043, 12.626041, -0.012220, -0.007069, -2.468107, -4.251011, -0.004890, -8.095555, -1.545154, -1.184152, -0.200840, 
	-0.012032, -0.004056, 0.244892, 3.533191, 0.216413, -0.001909, 0.147987, -0.006406, -0.002992, -1.384257, 0.454150, -0.001982, -1.736793, -0.188161, -1.186966, -0.071078, 
	-0.036858, -0.016565, 0.452578, -2.860879, -1.812824, -0.004569, 2.159930, -0.024946, -0.010965, 2.288068, 0.909399, -0.004768, -0.033472, -1.425805, 0.573799, -0.152122, 
	-0.013962, -0.008897, -1.290627, 1.937867, -1.862495, -0.002097, 1.103038, -0.009622, -0.005417, 0.463586, 0.293372, -0.002315, -2.033401, 0.997178, 0.479942, -0.046150, 
	-0.024610, -0.010384, 0.171354, 3.308329, -2.874941, -0.004665, 0.941861, -0.025027, -0.008003, 2.220721, 0.696699, -0.004723, -1.943980, -2.212772, -0.124719, -0.105140, 
	-0.172989, -0.063885, 0.399491, 2.164683, 2.482450, -0.019235, -0.438238, -0.198237, -0.044304, -1.203898, -1.095486, -0.023433, 2.100914, -2.030835, -0.684474, -1.172524, 
	-0.037658, -0.010021, 0.514328, 0.394498, -0.401123, -0.002588, -1.213524, -0.018814, -0.006213, -2.223866, -0.844919, -0.002722, 5.196362, -1.771746, 0.535827, -0.107821, 
	-0.008686, -0.007896, -0.584210, -1.865160, -3.456143, -0.001688, 5.028422, -0.018732, -0.004675, 3.707901, 0.432307, -0.001838, -3.104885, 0.663190, -0.740094, -0.037814, 
	-0.026447, -1.344173, 0.603072, -1.928692, -1.462451, -0.007233, -2.988560, 1.626203, -0.011919, -1.564477, 1.668232, -0.007424, -0.197215, 4.238726, 1.528451, -0.126093, 
	-0.035443, -0.011109, -0.821750, 0.891500, 1.626877, -0.003837, 3.059498, -0.022910, -0.008926, -0.702548, -0.670529, -0.008450, -0.385052, -1.247250, -1.576055, -0.084016, 
	-0.007135, -0.012172, 3.002977, -1.243384, -0.934356, -0.001578, 4.247435, -0.007130, -0.003567, -2.634640, -2.206374, -0.001698, -2.625746, 2.998797, -0.205871, -0.365559, 
	-0.100342, -0.049644, 2.701059, -0.881540, 0.973708, -0.016227, 1.687094, -0.067185, -0.035126, 0.295546, -1.546952, -0.026287, 2.044158, -2.412319, -0.817459, -1.748482, 
	-0.000447, -0.001326, -0.581023, -0.542190, 0.177331, -0.000211, -0.274519, -0.001386, -0.000581, 1.091444, -0.171789, -0.000238, 0.041206, -0.455216, 0.728423, -0.009477, 
	-0.009822, -0.016002, -2.172661, -1.724741, -1.356118, -0.001336, -0.429337, -0.008362, -0.005971, -0.956614, -3.429624, -0.001634, 6.077723, 2.923893, 1.145692, -0.035086, 
	-0.002948, -0.000918, -0.218009, -0.981407, 3.710434, -0.000341, -1.143651, -0.001009, -0.000703, -0.141712, 0.313858, -0.000305, -1.369763, -0.046412, -0.016074, -0.101042, 
	-0.002849, -0.002713, 2.367813, -0.512410, -0.231983, -0.001435, 0.008969, -0.003136, -0.002502, 0.111349, -1.041661, -0.001474, -0.580819, 0.209458, -0.258126, -0.058480, 
	-0.006928, -0.007126, -1.286138, -4.583022, 4.911849, -0.002021, 0.712115, -0.013231, -0.004292, 2.875838, -0.596743, -0.002101, -1.016374, -1.230262, 0.291097, -0.042662, 
	-0.000918, -0.001592, -0.119608, -0.560168, 0.787626, -0.000246, -0.674171, -0.002064, -0.000870, -0.214221, -0.590645, -0.000269, 0.290389, 0.499634, 0.165009, 0.422115, 
	-0.004107, -0.003682, 2.522486, 0.459917, -1.246971, -0.001456, 1.422439, -0.006958, -0.002919, -1.176634, -2.038361, -0.001552, 0.546771, -0.161253, -0.197052, -0.110668, 
	-0.002933, -0.005814, -1.259392, 2.001929, -0.332726, -0.000805, -1.410110, -0.003071, -0.001767, -0.450873, -2.448358, -0.000841, 4.995450, -0.343810, -0.257332, -0.479545, 
	-0.002037, -0.003479, -1.464580, 0.454289, -0.328001, -0.000655, -2.146828, -0.002754, -0.002933, 0.404274, 5.627151, -0.000591, -3.570446, 1.658729, -0.595476, -0.026664, 
	-0.044784, -0.011387, -2.785620, -2.716948, -1.375192, -0.002795, 3.571322, -0.012252, -0.006875, 1.015194, 0.683340, -0.003021, 0.185299, -0.680936, 3.331925, -1.147270, 
	-0.080190, -0.014706, 3.566931, -1.036152, -4.862552, -0.004733, 7.120258, -0.018860, -0.009106, -1.909389, 7.306102, -0.004963, -7.098079, -1.440161, -1.358956, -0.155442, 
	-0.049328, -0.016847, -0.707009, 0.334303, 0.188852, -0.008737, -1.767388, -0.152934, -0.018744, -1.935668, -0.719845, -0.009103, -2.572084, 7.434998, -0.305412, 0.304946, 
	-0.011961, -0.005263, -1.297711, -0.233551, 0.856359, -0.001541, 1.382761, -0.006373, -0.003598, 0.963127, -0.084561, -0.001809, -1.413502, -0.723295, 0.745650, -0.164733, 
	-0.002190, -0.001502, 0.367820, -0.220572, 0.012265, -0.000869, -0.110778, -0.001369, -0.001110, -0.541103, 0.208783, -0.000867, -0.799790, -0.396457, 1.506226, -0.018487, 
	-0.056397, -0.003288, 0.274459, -0.931600, 1.423957, -0.001494, -0.902295, -0.011963, -0.002674, -0.758033, 0.693780, -0.005829, -0.188741, -0.284239, 1.016805, -0.262447, 
	-0.075592, 0.234811, -1.820575, 0.867777, 1.443027, -0.006256, -1.352377, -0.158561, -0.017782, 2.361982, 2.020634, -0.006383, -2.318588, 1.313366, -2.136382, -0.349101, 
	-0.005541, -0.006119, 0.479789, -0.916585, -0.990270, -0.000988, 1.129776, -0.014569, -0.003944, 1.777492, -3.428579, -0.001243, 1.353949, 1.961441, -1.256908, -0.077700, 
	-0.003817, -0.001844, 0.046847, -1.602067, -0.303312, -0.000576, 0.592046, -0.001414, -0.001013, 0.981957, -1.516347, -0.000590, 1.353474, -0.264415, 0.725935, -0.004866, 
	-0.070647, -0.026547, 3.203799, 2.661232, -0.358254, -0.011925, -3.799026, -0.077846, -0.026890, 1.345572, 3.650272, -0.141912, -1.976341, -1.123852, -2.449664, -0.797971, 
	-0.003367, -0.009094, 0.447057, -0.806479, 0.274001, -0.000684, -1.339566, -0.017420, -0.004086, -1.119872, 2.236154, -0.001225, 0.202727, -0.330179, 0.479282, -0.007250, 
	-0.000923, -0.000558, 0.598139, 0.505954, 1.168075, -0.000202, -1.756765, -0.001740, -0.000357, -0.377472, 0.182148, -0.000210, -0.202134, -0.057298, -0.055523, -0.001134, 
	-0.006953, -0.003026, -0.765472, -0.190272, -0.615595, -0.000941, -0.057963, -0.002453, -0.001866, 2.003406, -0.973529, -0.000967, 0.955002, -0.163534, -0.119677, -0.056161, 
	-0.003582, -0.002496, 0.970930, 2.841867, 0.779901, -0.000979, 1.717342, -0.004555, -0.001857, -2.440526, 0.269839, -0.001026, -2.986353, -0.861080, -0.195314, -0.082112, 
	-0.003748, -0.002907, -0.998750, -1.706552, -1.119165, -0.000795, 0.745821, -0.002549, -0.001741, -0.716642, 0.720979, -0.000719, 3.195212, -0.245615, 0.159763, -0.022592, 
	-0.037410, -0.009812, -0.164846, -0.595780, 0.479969, -0.003904, 3.037666, -0.028065, -0.011033, 1.890046, -2.305207, -0.004298, 0.059894, -2.178189, -1.923662, 1.794630, 
	-0.007243, -0.006995, -1.789912, -1.430499, 3.129258, -0.002241, -1.065972, -0.011470, -0.004786, 0.100249, -0.376090, -0.002382, -1.148603, 0.002844, 2.620760, -0.006919, 
	-0.001950, -0.001080, 0.008170, 1.257238, -0.234530, -0.000485, -0.657247, -0.001031, -0.000782, -0.917207, -0.373891, -0.000493, 0.579241, -0.149476, 0.506952, -0.013428, 
	-0.311048, 0.238550, -2.135928, 5.787981, 5.557600, -0.029165, -10.641646, -0.218855, -0.079974, -0.300774, 3.106319, -0.161850, 7.072943, -3.257989, -4.810517, 0.184354, 
	-0.027280, -0.005453, -1.402723, -0.660911, 1.263976, -0.001448, -2.046234, -0.009611, -0.003805, 4.610261, 0.485891, -0.001540, -0.991022, -1.703673, 0.541806, -0.048233, 
	-0.007860, -0.002555, -1.623024, -0.587840, 1.913006, -0.000389, 0.942294, -0.002558, -0.001327, 0.494595, -3.259171, -0.000475, 3.303761, -0.927966, -0.658953, 0.418462, 
	-0.010117, -0.004287, 3.011710, -0.339370, -1.515712, -0.000919, -0.630061, -0.008723, -0.002804, -0.168487, -0.851522, -0.001016, -0.069425, -0.250280, -0.912093, 1.753106, 
	-0.003936, -0.002452, -0.483926, -2.277682, -0.669430, -0.001057, -0.182660, -0.002269, -0.001663, 3.672819, -0.523635, -0.001082, 0.055035, 0.758455, -0.297530, -0.038986, 
	-0.078722, -0.014354, -1.378963, 5.702091, 0.498741, -0.008399, 0.572254, -0.016559, -0.012049, -0.530249, 1.744876, -0.008581, -4.994662, -1.374654, 0.037484, -0.138256, 
	-0.021565, -0.007631, -0.700998, 0.242062, -2.082263, -0.002191, -0.963123, -0.031990, -0.005085, 1.724350, 1.104059, -0.002379, 1.833529, 0.116600, -1.035622, -0.167753, 
	-0.015736, -0.014927, -2.673191, -1.744091, 4.213351, -0.006590, 0.958057, -0.014844, -0.010498, 1.238356, -0.816005, -0.006530, -1.024371, -1.495653, 1.232591, 0.180080, 
	-0.038116, -0.009161, -1.053517, -1.247402, 1.199879, -0.004903, 9.699434, -0.010606, -0.006401, -1.094232, -3.804934, -0.005194, -3.936085, -0.898571, -0.036858, 1.246667, 
	-0.002195, -0.001575, 1.671054, -0.776690, 2.741266, -0.000818, -3.013437, -0.001900, -0.001164, -0.263938, -2.143523, -0.000565, 2.835494, -0.133692, -0.898649, -0.009669, 
	-0.014950, -0.009185, 0.988357, 1.640348, 6.575855, -0.005272, -0.495653, -0.016088, -0.007850, -3.536437, -2.642598, -0.005403, -1.633783, -0.043537, -0.611856, -0.181947, 
	-0.160386, -0.074909, 2.215714, -0.248142, -5.963882, -0.030412, 7.985755, -0.152813, -0.053107, -0.290504, 4.907121, -0.031100, -2.810637, -1.486882, -6.284188, 2.478370, 
	-0.131769, -0.031398, 2.544264, -0.839301, 1.121341, -0.011520, 0.892792, -0.362468, -0.028564, -0.307317, 1.654295, -0.012151, -1.849588, -3.762496, 0.139737, 0.984143, 
	-0.020580, -0.006897, 1.110806, -0.128751, -1.819017, -0.001874, 1.206860, -0.050842, -0.005632, -2.296544, -4.272328, -0.002063, 0.797494, 1.587319, 3.962653, -0.060606, 
	-0.004725, -0.003827, -0.837900, 2.683812, -1.796103, -0.001787, -2.924570, -0.004838, -0.002624, -0.873531, 5.997295, -0.001765, -1.620036, -0.654891, 0.087763, -0.042275, 
	-0.003785, -0.003575, -0.051012, 1.575057, -0.230581, -0.001016, -1.645695, -0.007866, -0.001925, -0.042811, 0.306668, -0.001035, -1.376357, -0.564656, 2.079899, -0.031309, 
	-0.105494, -0.028215, 1.381656, -1.866691, -0.454932, -0.006477, 3.269593, -0.027664, -0.015766, 0.164622, 0.799852, -0.006787, -3.002962, 1.341313, -0.185271, -1.256779, 
	-0.027458, -0.009500, -2.017456, 1.770314, -1.749469, -0.002948, -1.130000, -0.013015, -0.006723, -1.816982, 1.967050, -0.003114, 4.441482, -1.263580, -0.073577, -0.065023, 
	-0.053198, -0.050106, -0.265390, 1.272456, -0.694797, -0.010548, -3.279520, -0.059758, -0.029905, 3.778415, 4.498622, -0.012478, -2.565353, 0.271227, -2.378089, -0.421578, 
	-0.019940, -0.004321, -1.491692, 0.360332, -0.753645, -0.001023, 2.993473, -0.005561, -0.002968, 0.717545, -0.564801, -0.001084, -1.603981, -0.583722, 1.006364, -0.044975, 
	-0.004481, -0.003484, 1.249364, -1.041005, 0.293076, -0.000661, 1.542488, -0.002427, -0.001664, -0.456582, -1.109473, -0.000706, 0.092760, -0.000197, -0.535599, -0.021409, 
	-0.010622, -0.006814, -0.892653, -0.150815, -1.057536, -0.001883, -1.716207, -0.011872, -0.004102, -1.448004, 0.145233, -0.006368, 0.883845, 1.568842, 2.787414, -0.078457, 
	-0.001650, 0.559423, 0.399292, -0.043935, 0.100212, -0.001197, -0.015238, -0.523728, -0.001387, 0.050092, -0.693533, -0.001178, -0.036952, 0.393944, -0.181487, -0.002679, 
	-0.020344, -0.014458, 2.172551, -2.867769, -1.099758, -0.006789, 0.220479, -0.018825, -0.010335, -4.779064, 0.896301, -0.006995, -0.826053, 8.352423, -1.828332, -0.163032, 
	-0.009784, -0.005557, -0.111154, -0.381283, -1.002620, -0.001902, 3.288112, -0.006301, -0.003698, 1.074996, -1.696315, -0.001879, 0.045492, -0.818602, -0.345198, -0.024308, 
	-0.024673, -0.006242, -1.210833, -1.123421, -1.923599, -0.001421, 1.879307, -0.014956, -0.004524, 0.316074, 1.523275, -0.001582, -0.950533, -1.001697, 2.620830, -0.076006, 
	-0.011994, -0.011010, -0.095933, 0.998123, 2.612091, -0.001765, 0.491718, -0.015931, -0.006137, -0.747400, 1.399566, -0.002088, -3.289142, 0.301465, -1.572296, -0.049267, 
	-0.006018, -0.004018, -1.340880, -1.656534, -0.260361, -0.001419, 1.563854, -0.003839, -0.002654, 3.495615, -2.360417, -0.001492, 0.196999, 1.020801, -0.586298, -0.053339, 
	-0.008859, -0.001632, 0.276097, 0.815935, 1.265119, -0.000736, 1.195204, -0.002324, -0.001230, 0.344205, -0.551591, -0.000761, -3.297213, -0.094043, 0.080647, -0.018819, 
	-0.366538, -0.139756, 0.054519, 1.674030, -0.063300, -0.032928, -13.068785, -0.204499, -0.087897, -2.463604, 2.056110, -0.035686, 4.915240, 2.230766, 7.638642, -2.106313, 
	-0.027669, -0.007944, 5.422306, -1.376783, 7.836534, -0.002883, -5.853955, -0.012363, -0.005897, -1.569067, 0.617133, -0.003139, -3.649407, -1.894697, 0.649819, -0.121986, 
	-0.185407, -0.081636, -0.553696, -2.991021, -6.413397, -0.015560, -0.264999, -0.099043, -0.045094, 1.312278, 3.619872, -0.016777, 2.497403, 0.795581, 1.873853, 0.567642, 
	-0.008466, -0.004875, 0.217642, -0.203597, -0.174537, -0.001534, -0.644893, -0.024086, -0.003145, 0.010148, 3.646640, -0.001600, -4.396564, 0.687580, 1.015678, -0.114392, 
	-0.004335, -0.002930, -1.055191, 2.291238, 0.270489, -0.001255, -0.297461, -0.008917, -0.002554, -0.053087, -1.334854, -0.001338, 0.123035, 0.787067, -0.500713, -0.209194, 
	-0.083800, -0.002044, -0.055223, -1.298214, -0.268319, -0.000449, 0.354724, -0.002330, -0.001251, 1.024860, 0.757639, -0.000562, -1.446860, -0.662044, 1.692594, -0.008720, 
	-0.068198, -0.032892, -2.007114, 1.155146, 0.742107, -0.003567, 0.057544, -0.014962, -0.009221, -0.438829, -1.420241, -0.003833, -0.686509, 2.984063, 0.275239, -0.528733, 
	-0.001863, -0.000839, 0.291223, 1.867529, -0.626465, -0.000403, -0.486179, -0.000971, -0.000699, 0.249425, -0.504201, -0.000466, -0.821784, -0.028286, 0.068745, -0.004768, 
	-0.088887, -0.013327, 0.442918, -1.000554, -1.972639, -0.002987, 6.627085, -0.020052, -0.008644, 0.892216, 0.150399, -0.003148, -0.716036, -2.798275, -1.372021, -0.116049, 
	-0.036483, -0.023743, -4.888349, -3.166050, -3.132272, -0.010624, 0.678806, -0.035525, -0.016652, 0.202478, -0.585308, -0.010690, 6.520041, 5.604976, -0.671900, -0.428704, 
	-0.014339, -0.006822, 2.885452, 4.237009, 3.104548, -0.001913, 0.959411, -0.015550, -0.004327, -1.709231, -3.834203, -0.002196, -3.186711, -1.611867, -0.516670, -0.282591, 
	-0.004058, -0.003765, -0.394475, -3.744587, 4.956490, -0.001702, -1.434663, -0.004571, -0.002743, 0.864708, 1.898953, -0.002065, -1.248888, -0.557674, -0.277509, -0.043454, 
	-0.055755, -0.030136, 4.688467, 3.847029, -7.744267, -0.009058, 3.792380, -0.041681, -0.019922, 3.579819, -3.292731, -0.268155, -7.016819, 2.324369, -0.455382, 0.701843, 
	-0.051317, -0.050047, 5.413556, 0.312601, 1.540887, -0.006567, -1.573087, -0.049180, -0.014882, -1.949020, 5.779379, -0.007057, -6.486834, 0.577219, -3.636569, 0.200917, 
	-0.039044, -0.006942, -1.727857, -2.714109, -0.914043, -0.002267, 0.424778, -0.034560, -0.005258, 4.003346, -1.136769, -0.002435, -0.692465, 4.239369, -1.315184, -0.076561, 
	-0.004067, 0.013697, 0.499934, 0.359262, -2.150411, -0.000754, -0.092634, -0.015125, 0.001059, -0.004407, -1.185050, -0.000789, 1.095902, 0.579337, 0.918001, -0.013953, 
	-0.234864, -0.029096, 6.088879, 3.002652, -0.918962, -0.009728, -1.570331, -0.036007, -0.022797, 1.038079, 3.667749, -0.041005, -7.298785, -0.221708, -3.242437, -0.171637, 
	-0.001936, -0.002524, -0.225808, 0.353729, 0.446088, -0.000416, 2.093641, -0.002240, -0.001063, -0.243576, 2.201306, -0.000492, -4.080645, -0.226151, -0.285825, -0.024088, 
	-0.013466, -0.009721, 1.131539, 2.811727, -1.443448, -0.001494, 1.155093, -0.009761, -0.004158, 2.916359, -1.029302, -0.001498, -2.785457, -0.730143, -1.762544, -0.223727, 
	-0.015831, -0.007203, -0.608660, 2.499156, -1.803004, -0.002766, -4.668579, -0.009138, -0.005029, -1.235477, 7.811873, -0.002878, -1.871349, 0.857572, -0.763952, -0.174736, 
	-0.002492, -0.001146, -0.294015, 0.092258, 0.066380, -0.000425, -1.742944, -0.001014, -0.000766, 0.053627, 1.141589, -0.000440, 0.671515, 0.006015, 0.020939, -0.009081, 
	-0.019591, -0.004194, -0.211202, 0.393368, 0.205624, -0.001646, -3.375933, -0.006389, -0.003088, -0.700150, 4.327440, -0.001661, -1.330110, -0.066052, 0.823147, -0.029564, 
	-0.017518, -0.001676, 0.414624, 0.037152, 0.779137, -0.000876, -0.280493, -0.009219, -0.001818, -0.323249, 0.452070, -0.000916, -0.288198, -0.057900, -0.682232, -0.018889, 
	-0.010797, -0.010274, -1.807075, -1.297929, 0.341339, -0.002890, 2.451485, -0.011143, -0.007136, 4.295663, -1.934970, -0.003321, -1.491893, 1.043073, -1.667413, 0.113281, 
	-0.012521, -0.004231, 0.826501, -0.281933, 0.058901, -0.001527, -1.300160, -0.003675, -0.002620, -1.102005, 2.666954, -0.001617, -3.263404, -0.251579, 2.698749, -0.025832, 
	-0.007930, -0.004106, 2.033002, -3.553252, -1.268211, -0.001952, -3.389059, -0.004859, -0.003425, 3.348916, -0.781856, -0.001764, -0.255203, -0.949867, 2.860620, 1.978947, 
	-0.039429, -0.012816, 3.064434, 3.335190, 0.452896, -0.003683, -1.028007, -0.017494, -0.009266, 0.600453, -0.927653, -0.003742, -0.527443, -2.314983, -2.273805, -0.294652, 
	-0.022255, -0.014548, 0.044870, -0.651669, -0.734683, -0.003277, 13.979785, -0.019612, -0.008353, 0.658809, -8.114445, -0.003518, -2.788618, -1.928681, -0.309280, -0.084523, 
	-0.125941, -0.050255, 6.644616, -0.630340, -2.052265, -0.026653, 3.484265, -0.073256, -0.036798, -0.719582, -3.096637, -0.031565, -2.985140, -0.061509, -2.023939, 1.784999, 
	-0.009516, -0.004413, 3.324634, -0.242126, -2.883811, -0.001744, -0.681205, -0.010409, -0.003082, -0.459961, 5.374600, -0.001779, -3.936778, -1.609653, 1.180972, -0.035730, 
	-0.031926, -0.016655, -0.432682, -1.035300, 1.621477, -0.003513, 0.475877, -0.008907, -0.006915, -0.397349, -2.602087, -0.003695, -0.241437, 3.822715, -1.036117, -0.103487, 
	-0.111207, -0.028911, -2.093824, 0.264183, 2.002959, -0.004994, -0.781528, -0.025587, -0.011957, 1.784653, -1.995143, -0.005397, -0.425631, 2.460462, -0.727380, -0.300698, 
	-0.033812, -0.008572, 0.393731, -2.181576, -2.411911, -0.002627, -2.859436, -0.085381, -0.008148, 3.501252, 2.487420, -0.002833, 5.610730, -0.736647, -3.543804, -0.118386, 
	-0.694858, -0.252644, -1.308705, 1.846799, 9.568986, -0.041279, 1.637231, -0.518310, -0.141340, -4.768566, 1.506981, -0.046577, 1.761895, -3.482819, -3.180006, -1.886787, 
	-0.026880, -0.008207, -1.199514, 3.109084, -1.885383, -0.004368, -6.338382, -0.011375, -0.005881, -1.952635, -1.287921, -0.004512, 4.879062, -0.597085, 2.218696, 3.115301, 
	-0.034819, -0.010731, 0.752539, 2.290402, 1.334827, -0.002191, -1.321955, -0.016682, -0.006271, 0.513188, 1.011801, -0.002303, -1.408996, -0.837688, -2.147836, -0.113284, 
	-0.011997, -0.016486, 0.157942, 4.924407, 5.162538, -0.002161, -4.454837, -0.014857, -0.007684, -1.810073, -2.610437, -0.002556, 1.071968, -0.041038, -2.242447, -0.102280, 
	-0.034866, -0.019698, 1.122152, -2.238136, -6.841393, -0.008238, -2.226150, -0.040023, -0.014759, -1.146684, 7.978088, -0.008518, -1.829130, 2.961643, 2.591295, -0.245582, 
	-0.008762, -0.004798, -0.731504, -0.229738, 1.931699, -0.001545, -0.591739, -0.006726, -0.003043, -0.187945, -0.808211, -0.001531, 0.951798, -0.409719, -0.124058, 0.225824, 
	-0.035027, -0.014371, -2.305376, 2.680214, -0.075062, -0.005421, 0.781566, -0.015758, -0.008729, 1.454277, 1.478880, -0.005619, -2.617705, -0.063072, -1.479631, 0.230835, 
	-0.002533, -0.002731, 1.209760, -0.559075, 1.329154, -0.000462, -0.801509, -0.003552, -0.001364, 0.166082, -1.327544, -0.000514, 0.318454, -0.203167, -0.107573, -0.013427, 
	-0.010561, 0.466299, -1.106020, 0.537909, -0.944484, -0.002183, 2.978174, -0.329114, -0.003991, 1.210843, 1.842875, -0.002144, -3.393808, -0.572394, -0.581595, -0.089805, 
	-0.038314, 0.379007, -2.360074, -0.490680, 8.239182, -0.002624, -2.901995, -0.026913, 0.001356, 3.054723, -0.612606, -0.003196, -3.393045, -1.233580, -0.426358, -0.184885, 
	-0.006357, -0.007392, -0.844424, 0.572902, 4.836850, -0.001832, 1.429128, -0.010727, -0.005678, 0.302496, -1.784749, -0.002460, -2.065706, -0.816052, -1.455825, -0.140174, 
	-0.007221, -0.006334, 0.817322, -1.494562, 0.931953, -0.001543, -0.016065, -0.048209, -0.005427, -0.274838, -4.413971, -0.002177, 5.213110, -1.041557, 0.364544, -0.015022, 
	-0.088448, -0.013212, -0.083839, 0.920552, -0.228754, -0.004164, -0.019714, -0.023575, -0.009504, -0.485041, -1.067741, -0.004483, 2.574591, -1.271045, -0.046474, -0.149149, 
	-0.025953, -0.022622, -0.920909, -1.772281, -3.395713, -0.006287, -3.874993, -0.098323, -0.016568, 10.324858, 1.083929, -0.007163, 1.594781, 0.642924, -3.137500, -0.368178, 
	-0.014646, -0.002977, 0.354726, 1.620209, -0.228977, -0.000686, -0.559792, -0.002247, -0.001693, -0.861493, -0.021973, -0.000736, -0.381386, -0.450655, 0.623367, -0.071041, 
	-0.022704, -0.007444, 2.086079, 0.737491, -1.439525, -0.002255, 0.586726, -0.052268, -0.008206, -1.691695, -2.715605, -0.004897, 0.977041, -0.672472, 2.272725, -0.042993, 
	-0.000370, -0.000464, -0.012051, 0.235079, -0.074743, -0.000111, -0.848936, -0.000789, -0.000306, -0.075490, 1.438461, -0.000120, -1.000520, 0.370146, -0.022643, -0.007144, 
	-0.029336, -0.002057, 0.954737, -2.227036, 0.624134, -0.008380, -2.778208, -0.037382, -0.012847, 0.699035, 3.910514, -0.008579, -6.283389, 1.759925, 3.571982, -0.133112, 
	-0.003941, -0.002393, -2.819911, -1.525862, 0.243187, -0.001246, -1.730090, -0.004929, -0.001869, 1.668515, 0.880116, -0.001320, 1.128724, 3.231511, -1.032034, -0.028458, 
	-0.054617, -0.028509, -0.106873, -3.476053, -0.592122, -0.003852, -1.647555, -0.031354, -0.013392, 0.800596, -1.183080, -0.004334, 1.390658, -0.978585, 4.272674, 1.656399, 
	-0.010449, -0.003917, -1.364062, 0.802707, -0.332799, -0.001322, 0.656858, -0.035028, -0.003192, 0.909515, -2.684495, -0.001439, 0.392054, 0.884661, 0.839961, -0.049053, 
	-0.070958, -0.028240, -2.107985, -3.543216, 8.441127, -0.035576, 15.879216, -0.045644, -0.037275, -4.106260, -1.789772, -0.035028, -14.845981, -3.701372, -3.030777, 9.057741, 
	-0.015327, -0.008056, 0.983810, 2.005643, -1.495104, -0.001801, -1.294746, -0.012621, -0.005215, 0.134931, 6.046473, -0.001915, -5.309511, -0.529038, -0.368864, -0.128660, 
	-0.011356, -0.007242, -0.866294, 3.358855, 1.674509, -0.002355, -2.185996, -0.018246, -0.004970, -1.857258, 3.756721, -0.002519, -6.250036, 2.889886, -0.448697, -0.025002, 
	-0.050698, -0.003596, 0.498830, 3.021207, -1.877223, -0.001177, 3.302572, -0.004465, -0.002472, -0.524997, 0.549061, -0.001313, -2.086814, -1.322403, -1.474635, -0.021876, 
	-0.072096, -0.041943, -2.967114, -2.278210, 3.071239, -0.011183, 2.030668, -0.085732, -0.030586, 2.919412, -1.694331, -0.012164, -0.936441, -2.736375, 1.822593, 1.022263, 
	-0.004960, -0.002430, 0.764926, -0.403202, -2.247926, -0.000917, 3.839192, -0.008899, -0.001874, -0.519973, -0.998133, -0.000949, 0.514388, -0.353278, -0.531504, -0.044459, 
	-0.021736, -0.016085, 2.981862, -1.431626, 1.244656, -0.000700, -1.064396, -0.013504, -0.003575, -1.318427, -0.671532, -0.000833, -0.070061, -0.983530, 1.615173, -0.245684, 
	-0.082387, -0.032758, 0.630925, -1.310324, -1.477109, -0.010836, 2.257735, -0.023810, -0.017449, -2.250098, 1.297063, -0.011501, 0.652370, 2.395820, -1.775532, -0.242109, 
	-0.022958, -0.003429, -0.555561, 0.175756, -0.189173, -0.000851, -0.468789, -0.101684, -0.006353, 0.038052, -1.570709, -0.004300, 2.018263, 0.057397, 0.653054, -0.018715, 
	-0.079919, -0.003855, 1.137200, 1.214055, 2.980918, -0.003926, -4.505280, -0.027369, -0.010475, 0.346791, 2.909200, -0.004431, -1.434182, -1.633250, 0.485049, -1.370524, 
	-0.011498, -0.001092, 0.316633, 0.640580, 0.476629, -0.000450, -0.489712, -0.013801, -0.001357, 0.341462, -0.445199, -0.000532, -0.216834, -0.403576, -0.188257, -0.002994, 
	-0.028623, -0.012232, -1.623495, 0.462889, 2.297290, -0.003307, 0.473544, -0.010664, -0.006837, 0.219401, 0.674086, -0.003470, -1.961524, -0.062976, -0.349043, -0.065040, 
	-0.032826, -0.026890, 2.995202, -1.464101, -3.060609, -0.002531, -2.881385, -0.051790, -0.015725, 7.017372, 7.174205, -0.003201, -5.353313, -2.995265, -1.096947, -0.202195, 
	-0.128070, -0.071134, 1.542115, 4.086531, 0.198990, -0.017481, -3.176811, -0.077602, -0.040043, 0.953793, -1.499928, -0.019240, -3.152673, 1.769891, -1.358118, 0.989780, 
	-0.010224, -0.006091, -0.584332, -1.853467, -1.606037, -0.002653, 6.308811, -0.007728, -0.004700, -0.130719, -5.893296, -0.003081, -1.267815, 5.020770, 0.091263, -0.050701, 
	-0.004899, -0.002445, -1.350799, 2.594325, -0.289212, -0.000836, -0.709913, -0.002226, -0.001631, 0.363735, 1.110589, -0.000873, -0.194242, -0.965850, -0.512015, -0.033709, 
	-0.004753, -0.004960, 1.341552, 1.320765, -1.421991, -0.001575, 2.574067, -0.003952, -0.004193, -0.498121, -1.951089, -0.001622, -0.950238, -0.131370, -0.163601, -0.098921, 
	-0.010067, -0.007896, -1.883375, 5.378393, 1.447652, -0.002798, -1.336556, -0.016950, -0.005267, 2.437639, -2.430045, -0.002829, -2.317177, 0.191679, -1.315007, -0.127394, 
	-0.045720, -0.017426, -0.289010, 0.284693, -0.688911, -0.000605, 0.643872, -0.004297, -0.001832, 0.808671, -2.377668, -0.000636, 2.447199, -0.384202, -0.300604, -0.073525, 
	-0.004766, -0.002901, 3.169473, 0.399982, 1.058387, -0.000602, 0.003522, -0.002898, -0.001575, -1.623886, -2.814897, -0.000642, 0.481271, -0.103535, -0.545954, -0.010977, 
	-0.014726, -0.009067, -0.088719, -1.215537, -0.835445, -0.003280, 0.482283, -0.018948, 0.021789, -1.487024, -2.771867, -0.003556, 2.846230, 3.089930, 0.111929, -0.103995, 
	-0.334267, -0.127557, -0.324792, 1.297708, -1.468310, -0.030683, 2.269745, -0.194046, -0.071183, 0.432010, 6.345186, -0.162629, -2.359537, -3.813932, -2.641198, 1.183487, 
	-0.002229, -0.000628, -0.109200, -0.455452, -0.168923, -0.000273, 2.305150, -0.000770, -0.000469, -0.253027, 1.192803, -0.000284, -2.716728, 0.218254, -0.004477, -0.003749, 
	-0.113402, -0.042668, 0.516097, -1.977220, -1.423786, -0.015258, -7.790297, -0.037382, -0.024944, 1.150693, 5.213396, -0.020694, 8.315170, -0.445224, -2.364780, -0.939701, 
	-0.004174, -0.009770, -0.180042, -0.252292, 0.549343, -0.000944, 0.306533, -0.009197, -0.003726, -3.628601, -1.703438, -0.001099, 1.933734, 3.416951, -0.389508, -0.023771, 
	-0.069003, -0.023887, -0.195886, -2.226034, 8.434964, -0.009329, 7.161836, -0.033940, -0.017325, 1.169917, -7.801611, -0.010762, -1.226423, -3.476164, -1.245428, -0.430927, 
	-0.010401, -0.003134, 1.454498, 1.284607, -1.225258, -0.000825, -0.993159, -0.001818, -0.001508, -0.838086, -2.788805, -0.000861, 3.768070, -0.809583, 0.283114, -0.116852, 
	-0.049012, -0.029860, -1.903337, 2.589622, -3.760040, -0.007281, -3.492052, -0.072320, -0.017668, 1.335033, 8.147127, -0.007771, -1.568627, -2.701820, 1.802206, -0.264199, 
	-0.006154, -0.005548, -2.715568, -0.606333, 1.010379, -0.002084, 0.890473, -0.007007, -0.003775, 0.459567, -1.666125, -0.002084, 0.123953, 0.694428, 2.012689, -0.176812, 
	-0.085596, -0.044233, 0.556422, -2.951664, -0.084180, -0.011118, -1.040659, -0.062154, -0.024889, -0.666544, 1.817616, -0.148304, -0.978709, 0.151939, 3.848049, -0.275975, 
	-0.016549, -0.004831, -0.153522, -0.024380, -1.833691, -0.001733, 0.693707, -0.003826, -0.002614, 0.181400, -0.161734, -0.001868, -1.798369, -1.299452, 4.513460, -0.085999, 
	-0.007496, -0.003980, -1.622560, -1.489353, 1.472504, -0.000775, 3.012556, -0.002275, -0.001791, 2.113498, -0.623915, -0.000797, -1.840983, -0.246386, -0.739389, -0.018857, 
	-0.013202, -0.009409, -0.673595, 2.311095, -0.217860, -0.001963, -0.763866, -0.009946, -0.005435, 2.852023, -1.248788, -0.001994, -0.404202, -0.984393, -0.725814, -0.102650, 
	-0.001091, -0.002371, -0.054040, -0.213172, 2.144040, -0.000447, -0.298878, -0.001095, -0.000922, -0.392511, -0.962297, -0.000547, 0.259018, -0.060260, -0.410414, -0.005013, 
	-0.008331, -0.004713, 0.857772, 0.463884, 0.086173, -0.000714, -1.267194, -0.008542, -0.002594, -0.731650, -0.602189, 0.000078, 0.156553, 1.424611, -0.289044, -0.074099, 
	-0.060515, -0.008953, 1.993831, 0.333887, -1.880293, -0.002116, -2.338793, -0.011104, -0.006110, -1.810038, -1.783459, -0.002313, 2.189869, 2.452732, 1.027225, -0.093850, 
	-0.010150, -0.004379, -1.199636, -0.542519, 0.357673, -0.001715, 0.616489, -0.005547, -0.003109, 3.212380, 0.242856, -0.001765, -0.823725, -1.029933, -0.738035, -0.068887, 
	-0.012132, -0.012040, 0.955916, -1.420403, -3.177245, -0.002533, 0.148298, -0.016254, -0.006878, -1.631754, 5.961976, -0.002792, -1.223137, 1.366305, -0.715379, -0.211948, 
	-0.032042, -0.011409, 0.713363, -1.089660, -0.545625, -0.002101, 1.916433, -0.014907, -0.005639, -0.665315, -3.070892, -0.002212, 1.634565, 1.128807, 0.256810, -0.210175, 
	-0.023403, -0.007076, -0.784274, -1.628006, 1.006765, -0.001051, -1.564983, -0.003368, -0.004268, -0.053827, -0.888484, -0.001102, 2.712456, 1.445742, -0.137116, -0.068004, 
	-0.069861, -0.005078, -0.355165, 1.638065, 0.502512, -0.001622, -0.708355, -0.009378, -0.003347, -2.510927, 3.387424, -0.001742, -2.237579, -0.117843, 0.506446, -0.013550, 
	-0.068514, -0.007598, -0.398600, 1.706100, -1.361377, -0.003682, 5.308872, -0.011158, -0.005668, -0.526626, -0.178390, -0.003788, -2.958792, -0.524963, -0.856346, -0.109469, 
	-0.001577, 1.715426, -0.279704, 0.261312, 0.005473, -0.001201, 0.013043, -1.659994, -0.001506, 0.085165, -0.026085, -0.001195, -0.065741, -0.023364, -0.015131, -0.004922, 
	-0.060654, -0.030928, -3.275544, -1.952034, 6.205724, -0.010315, -5.386852, -0.036699, -0.017145, 7.241875, -1.073372, -0.010574, 1.112765, -1.446410, -0.810284, -0.449552, 
	-0.018967, -0.012981, -3.012213, 2.421449, -1.297630, -0.003905, 0.096116, -0.023696, -0.009318, -1.446886, -0.072837, -0.004123, 2.683670, 0.252007, 0.650483, -0.201166, 
	-0.008658, -0.006219, -0.084604, 0.899687, -0.560163, -0.001935, -1.042091, -0.008674, -0.004324, 0.198536, -2.697721, -0.002070, 1.324741, -0.280921, 2.340428, -0.066013, 
	-0.002855, -0.001979, -0.302906, 0.047074, -0.208401, -0.001252, -2.959604, -0.002002, -0.001641, 0.357097, 13.109138, -0.001266, -9.297255, -0.305122, -0.403726, -0.025304, 
	-0.027755, -0.019205, 0.641410, -1.610320, 2.172050, -0.004325, 1.105761, -0.010467, -0.006863, 1.367259, -0.783144, -0.004397, -1.646159, -0.565578, -0.297418, -0.310850, 
	-0.019268, -0.010413, 0.538521, 0.200726, -2.399488, -0.004234, -1.814548, -0.019232, -0.007739, -0.273562, 2.420676, -0.004404, -0.412560, -1.477093, 3.344018, -0.061399, 
	-0.008308, -0.004982, 0.133825, -0.054555, -0.930560, -0.001297, 2.892500, -0.018862, -0.003631, -1.360462, 2.181911, -0.001422, -2.297238, -0.347700, -0.097588, -0.081633, 
	-0.009116, -0.005182, 0.326930, 0.102406, -0.770080, -0.000562, -0.488051, -0.003570, -0.001917, -0.388014, 0.192615, -0.000661, -0.053297, 0.164454, 1.014990, -0.080945, 
	-0.007978, -0.010845, -1.620791, 1.296369, 2.049657, -0.001296, -1.750133, -0.004734, -0.003497, 0.058990, 0.002567, -0.001368, -0.335706, 0.832408, -0.430082, -0.073561, 
	-0.020653, -0.006194, -0.431144, 2.569837, -1.331262, -0.001480, 1.071759, -0.023412, -0.004743, -0.083070, -1.543029, -0.001602, 1.733918, -0.940932, -1.082473, 0.094481, 
	-0.064353, -0.013264, -1.108565, -0.177920, -1.697597, -0.001193, -2.150060, -0.008199, -0.004377, 3.670276, 2.167671, -0.001477, -1.033177, 1.249200, -0.790023, -0.036944, 
	-0.224098, 0.154885, -2.461301, 1.053409, -4.836682, -0.011174, 3.039446, -0.089948, -0.018805, -0.310347, 3.746419, -0.011752, 1.093342, 0.062032, -1.126612, -0.058814, 
	-0.016432, -0.010147, -1.565648, 2.110100, -1.607737, -0.004030, -3.152157, -0.043667, 0.364197, 0.358850, 0.009398, -0.004170, 4.233371, -0.715953, 0.086993, -0.042968, 
	-0.034749, -0.008479, 0.226499, -1.450818, 0.093775, -0.002443, -5.876783, -0.011727, -0.004948, -0.816188, 15.593888, -0.006975, -5.573751, -0.386920, -1.710304, -0.030079, 
	-0.227770, -0.064103, -5.170871, -3.017655, 0.922825, -0.016595, 4.758257, -0.090354, -0.038535, 0.616668, -1.195860, -0.022359, 7.919703, -2.704677, -0.593991, -1.074682, 
	-0.003342, -0.001362, 0.134661, 2.365684, -1.251781, -0.000582, -0.623261, -0.002073, -0.000886, 0.121635, -0.155936, -0.000592, -0.230663, -0.412036, 0.078880, -0.018345, 
	-0.001539, -0.000682, 0.638202, -0.354684, -0.013572, -0.000201, -0.910254, -0.001151, -0.000479, -0.112278, 2.653924, -0.000200, -1.608517, -0.111930, -0.119611, -0.057029, 
	-0.017950, -0.008921, -0.565019, 0.738557, -0.874054, -0.001441, 0.395078, -0.012631, -0.003485, -1.339835, 1.117225, -0.001518, 0.628900, 0.596740, -0.601236, -0.050410, 
	-0.009534, -0.008786, -2.028583, 0.446146, 4.783026, -0.003107, -1.307333, -0.010879, -0.005736, 0.051474, -1.272618, -0.003195, -0.958633, 1.179364, -0.813126, -0.038480, 
	-0.028071, -0.012992, -2.955536, -2.507342, -2.060683, -0.003806, 14.442149, -0.014876, -0.008651, 2.125959, -7.278403, -0.004228, 1.473925, -1.103207, -1.724728, -0.339509, 
	-0.019291, -0.006055, -0.101676, -1.289016, 3.977749, -0.001077, 0.166552, -0.009254, -0.002789, -0.479180, -2.018047, -0.001205, -1.509566, 1.217031, 0.147266, -0.071442, 
	-0.035306, -0.014442, 0.631555, 0.191482, -1.917677, -0.002087, 0.123728, -0.018263, -0.005938, 0.252612, -2.745127, -0.002293, 6.419463, -1.764040, -0.889240, -0.224425, 
	-0.004439, -0.003781, 0.030075, -0.394038, -0.472232, -0.001097, -0.758478, -0.017009, -0.003013, -0.785496, 4.904595, -0.001160, -2.267300, 0.679719, -0.853583, -0.052763, 
	-0.020639, -0.018818, -4.454868, -5.465881, -4.277908, -0.008820, -1.845048, -0.021441, -0.013061, 7.072299, 7.625824, -0.009044, -2.886979, 5.396927, -0.868699, -0.203844, 
	-0.040092, -0.037219, -4.981395, -7.740645, -3.367591, -0.018046, 0.135646, -0.050440, -0.027560, 20.751371, -5.740636, -0.018187, 4.438635, -4.101817, 1.635990, -0.838016, 
	-0.019873, -0.006984, -2.520665, 1.624018, 1.641986, -0.001530, -2.702423, -0.009139, -0.004234, 0.810205, -2.102553, -0.001566, 3.212372, -0.636015, -0.424513, 1.140914, 
	-0.013615, -0.005547, 0.424237, -0.045324, -1.730592, -0.002129, 2.054962, -0.029691, -0.004133, -0.745628, 2.616132, -0.002244, -1.355068, -0.735354, -0.093670, -0.332337, 
	-0.004778, -0.001591, 0.216443, 0.063869, -1.294480, -0.000403, 0.336564, -0.002175, -0.001175, 0.471565, 2.984218, -0.000425, -1.695752, -0.827580, -0.225967, -0.018330, 
	-0.003819, -0.001080, -0.070049, -0.174883, -0.370921, -0.000530, -0.220093, -0.003692, -0.000947, -0.027493, -0.549798, -0.000554, 0.971752, -0.108583, 0.567302, -0.006610, 
	-0.018891, 0.107898, -0.167922, -1.913540, -2.034141, -0.003583, -4.074527, -0.124574, -0.007580, -1.077803, 10.585555, -0.004133, 1.008099, -1.951786, -0.206080, -0.116992, 
	-0.152379, 0.053491, 3.113394, 2.276739, -0.196745, -0.047028, 0.833174, -0.201566, -0.083808, -1.501639, 1.238067, -0.049764, 3.673586, -3.891202, -3.594529, -1.469791, 
	-0.015078, -0.008479, -0.240897, -2.680942, -0.647548, -0.003058, 1.820337, -0.011197, -0.006023, 0.716624, -0.882773, -0.002983, 0.745929, -0.731568, 2.033441, -0.085784, 
	-0.107956, 0.361851, -1.761006, 3.551474, -0.472845, -0.007577, 4.067613, -0.042728, -0.017603, -0.055954, -1.213227, -0.007940, -4.906417, 1.976936, -0.078112, -1.286508, 
	-0.001958, -0.001306, -0.077859, -0.574812, 1.908033, -0.000333, 0.506276, -0.001084, -0.000756, -0.203792, -0.798177, -0.000354, -0.983973, 0.345913, -0.109515, -0.006302, 
	-0.016290, -0.005241, -2.280642, -3.415819, -1.086729, -0.001248, 4.005132, -0.010337, -0.003427, 5.139755, -6.962212, -0.001329, 2.242778, 1.801556, 0.688407, -0.094355, 
	-0.038818, -0.009312, -1.679390, 6.341938, 2.090282, -0.004111, -2.744581, -0.013262, -0.007906, 1.994880, -1.981251, -0.004158, -1.133011, -0.903229, -1.776316, -0.131755, 
	-0.054269, -0.007289, 0.585586, 1.792440, -0.143565, -0.002045, -1.617533, -0.015679, -0.005190, -1.281527, -3.579512, -0.002205, 2.125775, 2.330143, -0.085870, -0.039260, 
	-0.022343, -0.011767, -1.539218, -5.272655, 1.088662, -0.003248, 0.990888, -0.017076, -0.007420, 2.076375, 1.395179, -0.003283, 0.895548, 0.009422, 0.509690, -0.088754, 
	-0.000723, -0.000664, 1.524899, -0.641483, -0.462301, -0.000296, -0.561695, -0.001347, -0.000505, -0.321534, -0.169742, -0.000304, 0.748230, -0.319619, 0.213138, -0.006054, 
	-0.008260, -0.004991, -0.449096, -0.290177, 0.064579, -0.001100, 1.696849, -0.003256, -0.002688, -0.596575, 2.145438, -0.001124, -2.038669, -0.211315, -0.253131, -0.046487, 
	-0.007897, -0.004916, -0.495879, -1.025281, -2.254263, -0.001746, 1.225752, -0.009658, -0.003588, 1.066836, 0.452074, -0.001836, 0.808324, -1.154407, 1.460278, -0.053792, 
	-0.045864, -0.015614, -0.859990, -2.289186, -3.116529, -0.003559, 1.197125, -0.026191, -0.009232, 5.631731, 2.305859, -0.003945, -0.606346, -0.586339, -1.466181, -0.105738, 
	-0.004405, -0.003644, 1.254786, -2.677319, -0.053675, -0.001377, 1.860870, -0.005153, -0.002619, -2.378504, -0.274842, -0.001436, -1.844606, -0.532441, 4.679421, -0.015057, 
	-0.002133, -0.000391, 0.535914, 0.002584, -0.100550, -0.000136, -1.192772, -0.001155, -0.000348, -0.024530, 1.482874, -0.000164, -0.944761, 0.217382, 0.029210, -0.001026, 
	-0.042247, -0.011656, -1.737460, 1.165789, 2.186059, -0.003968, -0.746602, -0.018875, -0.007889, 0.490151, -4.239534, -0.004139, 5.034243, 0.772608, -2.594396, -0.242085, 
	-0.036888, -0.009036, -1.253105, 0.495803, -0.010730, -0.004430, 0.454700, -0.074810, -0.007582, 1.588582, -2.276501, -0.004535, -0.509308, -0.893492, 2.618658, -0.077324, 
	-0.727056, -0.152575, -0.657174, -0.888603, 3.517264, -0.047633, 0.379322, -0.370220, -0.115499, -3.036093, 2.325873, -0.188767, 3.838819, 0.937292, -4.184005, -0.630945, 
	-0.030283, -0.030311, -0.909237, 4.311471, 1.195767, -0.003463, -4.102025, -0.025253, -0.012776, 0.832701, -0.203763, -0.004015, -2.446264, 1.683594, 0.268841, -0.524986, 
	-0.044909, -0.008879, 5.019500, -2.715580, -1.403469, -0.003565, -2.310345, -0.008327, -0.005838, -1.640777, 7.623366, -0.002021, -3.965268, 0.188784, -0.672687, -0.049986, 
	-0.051207, 0.017216, 4.264346, -0.778513, -3.648875, -0.003817, 3.909356, -0.312554, -0.017998, -2.369261, -4.480866, -0.004287, 5.279209, 2.099132, -3.871715, -0.030165, 
	2.109225, -0.086999, -4.800921, 3.510715, -4.982767, -0.028047, 3.252648, -0.158080, -0.064557, -1.647908, 2.673764, -0.029876, 5.196833, -3.306517, 0.019683, -1.657196, 
	-0.004600, -0.003128, 0.176359, 2.580826, 0.680388, -0.001000, -3.259016, -0.003335, -0.002079, -0.878568, 1.984202, -0.001022, -1.530721, -0.422570, 0.708932, -0.024668, 
	-0.030382, -0.015686, -0.090082, -1.447335, 2.262533, -0.004245, -1.274973, -0.048988, -0.009753, 2.289941, 0.697494, -0.004827, -0.902803, -2.274779, 0.346240, 0.507646, 
	-0.028080, -0.006681, -0.497490, -1.349382, -1.554122, -0.002089, -0.496433, -0.015825, -0.005277, 0.886463, 5.171594, -0.002001, 0.328922, -1.045941, -1.299253, -0.084406, 
	-0.027200, -0.013295, -1.143470, 4.662122, 2.715124, -0.004525, 0.776319, -0.019037, -0.008705, -1.193551, -1.735952, -0.004752, -5.928349, 1.655927, 0.405824, -0.136481, 
	-0.009359, -0.004043, 0.502684, 0.336396, 0.901501, -0.002180, -1.082903, -0.026313, 0.082977, 0.165891, -3.095690, -0.002390, 4.400761, -1.245443, -0.908517, -0.013372, 
	-0.002015, -0.002113, -1.316599, -1.289518, -0.055479, -0.001358, -0.522050, -0.002493, -0.001842, 2.815743, 2.580440, -0.001398, -1.889276, -0.138929, -0.153930, -0.019182, 
	-0.062953, -0.014559, -1.515698, -3.878745, 2.104692, -0.002718, -0.270011, -0.017112, -0.007626, 2.425689, -1.282820, -0.002898, 4.308599, 0.531150, -2.173000, -0.141992, 
	-0.005624, -0.006692, -0.211162, -2.429303, 3.516266, -0.001670, -0.243862, -0.007988, -0.004051, 1.369670, -0.189241, -0.001784, -0.269305, -0.540264, -0.897893, -0.077097, 
	-0.003609, -0.002007, 0.694986, -1.602581, -1.760551, -0.000876, 1.669748, -0.016326, -0.001652, 1.110181, 0.021214, -0.000835, 0.388069, -0.667392, 0.206665, -0.035034, 
	-0.004855, -0.003647, -1.057498, 2.906228, -0.703887, -0.000546, 2.509496, -0.002759, -0.001635, -0.440065, -0.441539, -0.000593, -1.194368, -1.497738, 0.140864, -0.207458, 
	-0.018948, -0.008831, 0.045990, -0.596766, 3.124800, -0.001582, 3.565231, -0.017270, -0.004751, 2.108838, -1.020175, -0.001779, -6.466030, -0.446917, -0.181050, -0.080761, 
	0.943035, -0.568701, -0.237179, 0.903909, 0.070198, -0.255690, -3.368371, -0.689462, -0.387617, 0.106758, 3.319311, -0.216655, -5.064395, 0.892042, -0.931338, 5.484157, 
	-0.011807, -0.006976, 1.380984, 0.232343, -0.047188, -0.003296, 2.796857, -0.008164, -0.005101, -1.947142, -1.379690, -0.003429, -4.043661, -1.118246, 4.394203, -0.229687, 
	-0.037290, 0.106252, 1.041736, 5.525123, -6.135845, -0.004093, 0.180390, -0.207593, -0.011479, -3.841937, 5.011582, -0.005234, 2.876588, -3.008610, -1.183257, -0.306333, 
	-0.004124, -0.004683, -0.395202, -1.464598, -0.308701, -0.000554, 4.822734, -0.015042, -0.002761, 0.081904, -2.952475, -0.000679, 0.606028, -0.195519, -0.105505, -0.060824, 
	-0.000649, -0.000425, 0.208085, -0.020255, -0.060406, -0.000142, 0.544069, -0.000675, -0.000314, -0.319764, -0.475567, -0.000144, -0.178129, -0.104890, 0.410438, -0.001234, 
	-0.025441, -0.009582, 0.664992, 2.055235, -3.188435, -0.004262, 0.342435, -0.010831, -0.004654, -0.373782, 3.159786, -0.004378, -5.395423, -0.217582, 2.750303, 0.261620, 
	-0.056361, -0.025319, 1.861342, 6.691577, 4.162475, -0.004560, -2.229984, -0.020803, -0.011865, -2.444618, -5.363566, -0.005010, 1.821367, -2.165027, -2.042075, -0.167571, 
	-0.015641, -0.006562, -1.036073, 0.603926, -2.262756, -0.002047, 1.068782, -0.033348, -0.005086, -1.227621, 4.854869, -0.006650, -0.913141, 0.159034, -1.071561, -0.106125, 
	-0.132908, -0.022415, 1.282461, -0.913188, -0.779046, -0.003923, -0.587120, -0.053524, -0.011823, -0.555648, 2.352799, -0.004108, 2.224361, -2.656492, 0.746008, -0.885434, 
	-0.101044, -0.041926, -4.076560, -0.280771, -0.602647, -0.011012, 1.036265, -0.069287, -0.025408, 2.356119, -2.671939, -0.012084, 3.083911, 0.324873, 1.752608, -0.661098, 
	-0.011794, 0.006923, -0.677025, -0.991531, -1.218600, -0.001464, 1.475171, -0.025414, -0.004103, -0.379829, 0.593812, -0.001670, -0.670865, 2.263370, -0.325558, -0.031423, 
	-0.082245, 2.756284, 0.080009, 0.570337, -1.153355, -0.006067, -2.794338, -1.985517, -0.043105, -1.073851, 1.592898, -0.006218, 1.777953, 0.693961, -0.283966, -0.042779, 
	-0.004727, -0.004529, 0.084735, -1.045521, 1.476598, -0.001600, -0.473727, -0.003854, -0.002556, 0.422038, 6.135758, -0.001650, -5.964645, -0.199973, -0.350790, -0.065558, 
	-0.005504, -0.001423, -0.082323, 0.967141, -1.961763, -0.000782, -1.190246, -0.001350, -0.001077, -0.153081, 5.276513, -0.000805, -3.155138, -0.193287, 0.510572, -0.007447, 
	-0.076215, -0.035008, 5.220506, 1.050730, -3.812203, -0.009850, 1.134077, -0.038720, -0.021529, 5.114256, -4.863499, -0.010207, -1.065551, -1.414801, -0.868411, -0.303575, 
	-0.022836, -0.008519, -1.298615, 0.265725, 0.036195, -0.002866, 2.006770, -0.008850, -0.014946, 0.644763, -2.437381, -0.003001, -0.551261, -0.719355, 1.369786, 0.744390, 
	-0.006905, -0.005508, 0.859850, -1.303380, 1.936998, -0.001549, 0.081728, -0.005263, -0.003004, -0.765634, -1.440265, -0.001615, 0.024054, 0.838095, -0.104050, -0.103554, 
	-0.003694, -0.000728, -0.150758, 2.771092, 0.888203, -0.000332, -1.065075, -0.000638, -0.000551, -1.977600, -0.730005, -0.000342, 0.264631, 0.016497, -0.007118, -0.003580, 
	-0.027356, -0.007290, -0.600209, -0.416271, -1.016560, -0.004170, -1.075592, -0.012973, -0.005718, 0.741334, 6.123955, -0.008689, -5.299101, 2.240316, -0.982176, 0.350500, 
	-0.023056, -0.005797, -0.064760, 0.697364, -0.560744, -0.001356, -3.364149, -0.009019, -0.003826, -0.269825, -3.074741, -0.001346, 6.574625, 0.898949, -0.760432, -0.031891, 
	-0.107041, -0.027955, -0.151248, -5.855949, 0.899854, -0.009756, -0.574566, -0.041735, -0.022566, 4.494942, 2.472978, -0.010045, -4.238498, 4.216373, -0.671812, -0.372976, 
	-0.013749, -0.004846, -0.076320, 3.005522, 1.944216, -0.002338, 2.202385, -0.012536, -0.006004, -0.625408, -4.390849, -0.002564, 2.566173, -3.381848, -0.668584, -0.533250, 
	-0.006133, -0.001324, -0.584283, 0.813702, -0.094332, -0.000717, 0.774866, -0.002493, -0.001377, -0.014068, 0.224907, -0.000748, -0.609262, -0.023263, -0.457015, -0.018460, 
	-0.012868, -0.003407, -0.364050, -0.782066, 1.268360, -0.001524, 0.179245, -0.006963, -0.002675, -0.277736, 0.392841, -0.001589, -0.146608, 0.227905, -0.418881, -0.049982, 
	2.407909, 0.034189, -3.292587, -5.326084, 3.727573, -0.042393, -2.396917, -0.281519, -0.101535, -5.460901, 7.535554, -0.053942, 5.081201, -3.420289, 2.871898, -1.282156, 
	-0.008849, -0.008036, 2.351100, 2.612233, 1.455411, -0.001521, 0.627212, -0.012953, -0.004821, 0.160264, 2.490730, -0.001725, -3.591561, -2.357546, -3.683499, -0.026438, 
	-0.006542, -0.004019, 0.002389, -0.844263, -0.147685, -0.001280, 1.316164, -0.003212, -0.002529, -0.182007, -1.311425, -0.001321, 1.712709, -0.145857, -0.373187, -0.007934, 
	-0.051810, 1.544383, -1.926854, 1.090138, 0.180086, -0.002798, -0.185031, -1.565359, -0.006760, -1.133162, -0.540296, -0.003046, 2.857284, -0.417501, 0.191759, -0.031033, 
	-0.528384, 0.172913, -0.015095, -0.725376, -0.080677, -0.060576, 0.066624, -0.443408, -0.132913, 0.881824, -1.416660, -0.193661, 0.059424, 0.043804, 4.214901, -1.842739, 
	-0.008692, -0.006123, 0.367161, 3.740536, -0.621763, -0.001446, -1.345690, -0.009259, -0.003547, 0.115883, 0.613114, -0.001531, -2.467333, -0.915348, 0.622118, -0.078079, 
	-0.002553, -0.004813, -0.105218, -0.865815, 0.778579, -0.000685, -1.510737, -0.002402, -0.003257, -0.470516, -0.021461, -0.000779, 0.979137, 1.650396, -0.395380, -0.024494, 
	-0.003729, -0.002418, -0.089659, -0.333700, 0.673700, -0.000952, 1.786811, -0.002432, -0.001638, 2.246193, -1.626705, -0.000893, -1.544309, -0.588586, -0.408356, -0.103326, 
	-0.079390, -0.015032, 0.280740, 0.586096, 2.604918, -0.002976, -1.408304, -0.011631, -0.007617, -1.399499, 4.699356, -0.003307, -3.388309, 0.841884, -2.568117, -0.128811, 
	-0.005278, -0.006309, 0.429927, 0.037694, -0.300327, -0.003743, 1.445378, -0.039410, 0.239556, -0.184295, 1.231888, -0.003785, -2.426769, -0.275424, -0.130664, -0.008440, 
	-0.003208, -0.002030, -0.772160, -1.558114, -0.783277, -0.000973, 3.858942, -0.002235, -0.001577, 1.307507, -2.925222, -0.000978, 0.333400, -0.077672, 0.662735, -0.035137, 
	-0.007192, -0.004364, -0.422685, 0.245977, -0.513402, -0.001643, 0.945899, -0.003514, -0.002745, -0.352735, 2.968076, -0.001712, -2.475018, -0.237200, -0.110851, -0.026890, 
	-0.049862, -0.006780, 1.169730, 3.056233, 3.399284, -0.002886, -1.407635, -0.042646, 0.003169, -1.847823, 3.045768, -0.002993, -7.998232, 0.185624, 0.585149, -0.086099, 
	-0.058907, -0.006951, -1.643192, -2.312458, 2.256436, -0.002358, 1.731086, -0.005836, -0.004368, -0.179314, 0.619077, -0.002421, -3.378996, 4.169631, -1.098355, -0.083074, 
	-0.006800, -0.005198, -0.061290, -1.626686, 5.825376, -0.001850, -0.150338, -0.006350, -0.003944, -0.059952, -5.151110, -0.001957, 2.305044, -0.485597, -0.481935, -0.087414, 
	-0.024857, -0.005172, -1.060185, -1.939342, -0.537888, -0.001478, -1.150946, -0.006410, -0.003199, 0.482332, 4.214339, -0.001550, 0.118016, 0.310070, -0.377720, -0.016011, 
	-0.009197, -0.008734, -2.387294, 1.156140, -2.788672, -0.002588, -0.047278, -0.021726, -0.006107, 5.400550, -2.523662, -0.002808, 0.208585, 0.483316, 0.606036, -0.056562, 
	-0.008925, -0.009164, -1.133622, -0.848252, -0.127028, -0.002738, 3.835715, -0.009856, -0.005577, 0.726217, -0.499688, -0.002868, -0.726250, 0.937249, -2.019729, -0.105486, 
	-0.008074, -0.003313, -0.169739, -1.112825, -1.055600, -0.000679, -0.287287, -0.006348, -0.001620, -0.139091, -1.539697, -0.000717, 2.164051, -0.586696, 2.762523, -0.014888, 
	-0.011263, -0.013620, 0.863119, 1.598804, 0.829703, -0.001664, 0.000628, -0.014786, -0.005762, -0.941819, -1.106248, -0.002138, -0.958653, -0.057189, -0.050528, -0.128583, 
	-0.004521, -0.003285, -0.063057, 2.133568, -0.799269, -0.000361, -0.534256, -0.001429, -0.001186, -0.756332, 2.067771, -0.000379, -1.019327, -0.416550, -0.533763, -0.067625, 
	-0.016603, -0.011346, -1.162727, 0.409908, -0.361998, -0.003733, -3.723454, -0.012828, -0.007399, -0.031669, 8.145475, -0.003916, -1.845726, -0.461021, -0.948588, 0.035625, 
	-0.109328, -0.018566, -0.631028, 0.030904, -0.311145, -0.002650, 1.563805, -0.011995, -0.009255, -1.463187, -0.718623, -0.003605, 4.703015, -0.425242, -2.527383, -0.065717, 
	-0.005325, -0.003133, -0.147557, 4.229654, 0.427087, -0.001000, -0.576041, -0.003994, -0.002034, -1.946763, -0.321026, -0.001042, 0.051450, -2.490261, 0.809107, -0.019122, 
	-0.006959, -0.004477, -0.506494, 0.703269, -0.441156, -0.000634, 0.372611, -0.011319, -0.003203, -0.935640, 0.584674, -0.000809, 0.218989, 1.908429, -1.843032, -0.034250, 
	-0.014155, -0.012058, -1.357437, 0.953091, -1.487084, -0.005613, 0.116696, -0.019177, -0.008904, 2.912276, -4.440117, -0.005756, 3.823713, 3.545710, -3.662720, -0.338465, 
	-0.027392, -0.029472, 1.283445, -5.255665, -2.686365, -0.006089, 2.395144, -0.026547, -0.017276, -0.012143, 6.405179, 0.016676, 1.520159, -2.053912, -1.377209, -0.128531, 
	-0.006505, -0.003012, -1.271924, 1.419464, 0.371013, -0.000662, -2.084746, -0.007008, -0.002009, 0.660162, 1.729021, -0.000800, 1.374530, 0.228172, -2.390204, -0.015491, 
	-0.044281, -0.020850, 0.384773, 2.753145, 0.275583, -0.005258, -5.288057, -0.021749, -0.011714, 3.052447, 2.439397, -0.005458, -3.043485, 0.730533, -1.071812, -0.123213, 
	-0.007804, -0.006574, 1.677307, 1.410825, 1.251835, -0.003884, -0.783038, -0.009255, -0.005525, -1.787737, -0.476666, -0.003949, -1.157151, -0.253232, 0.229627, -0.074780, 
	-0.016472, -0.002218, 0.091285, 0.051049, -2.035279, -0.000924, -1.742943, -0.007691, -0.001717, -0.771154, 3.057811, -0.005343, -0.260802, -0.220638, 1.893730, -0.028693, 
	-0.006201, -0.007010, -0.065645, 0.625432, -1.220120, -0.000477, -1.182026, -0.003566, -0.001801, -0.480786, 2.876061, -0.000534, -0.961700, 0.260150, 0.186428, -0.018207, 
	-0.020284, 3.183870, -1.751289, 1.307702, -1.329181, -0.005399, -1.311807, -2.888237, -0.010272, 0.761345, 3.591343, -0.005967, 1.379689, -0.400780, -2.390181, -0.110553, 
	-0.014262, -0.010225, 0.139099, -3.347533, 7.525712, -0.004672, 0.831694, -0.016491, -0.007868, -2.601802, -2.656406, -0.004866, 0.060936, 2.520047, -2.181237, -0.232128, 
	-0.002817, -0.002283, 0.607441, -0.686628, -0.554893, -0.000978, 1.000943, -0.002622, -0.001527, -0.297551, 1.912679, -0.001001, -2.645730, -0.558119, 1.261722, -0.028638, 
	-0.007222, -0.002402, -0.703957, 1.356350, 0.188577, -0.001244, -0.541425, -0.003510, -0.002122, -0.783582, -1.506216, -0.001214, 2.262224, -0.263926, 0.047779, -0.038109, 
	-0.011230, -0.006119, 1.086543, 0.376331, 0.019150, -0.001747, 1.172041, -0.008835, -0.003900, 2.000550, -4.920818, -0.001860, 4.941803, -3.825286, -0.701741, -0.114881, 
	-0.023664, -0.021890, 1.193452, 1.133490, 2.575885, -0.005345, 0.279292, -0.025378, -0.012166, -0.336252, -4.128037, -0.005656, -2.275884, 1.827455, 0.038226, -0.213528, 
	-0.005786, -0.001607, -1.052681, -1.766052, -0.906285, -0.000742, 0.343972, -0.005387, -0.001787, 2.884769, -0.762957, -0.000791, 0.276861, -0.154561, -0.623809, 1.776843, 
	-0.013218, -0.002535, -0.150450, 0.873951, 0.076922, -0.001226, 0.374590, -0.003471, -0.001933, -0.481529, -3.665224, -0.001263, 3.122149, -0.271362, 0.188814, -0.044213, 
	-0.000271, -0.000457, 0.157897, -0.277800, 0.438361, -0.000104, -0.107128, -0.000517, -0.000269, -0.325516, -0.611699, -0.000110, 0.758286, -0.056305, 0.027707, -0.002074, 
	-0.010939, -0.007487, 0.210924, 1.282113, 0.705096, -0.001386, -0.238400, -0.018267, -0.004591, -1.246282, -4.097814, -0.001613, -1.064449, 3.185583, 1.462777, -0.155265, 
	-0.046627, -0.039183, -0.096812, -1.141225, -1.426050, -0.020592, -2.343061, -0.207553, 2.535862, -0.999952, 1.512953, -0.023648, 2.485987, 2.911130, -2.772921, -0.328308, 
	-0.082269, -0.013046, 0.416552, -2.108918, 2.469412, -0.003170, -1.263408, -0.022469, -0.007890, -1.510915, 1.062506, -0.003416, 3.166547, -0.719358, -1.246068, -0.134089, 
	-0.016811, -0.017162, -0.666671, 1.504881, -1.930834, -0.002715, 1.553926, -0.040352, -0.007367, -0.663682, 0.063832, -0.002905, -1.270746, 1.225872, 0.325909, -0.055176, 
	-0.004755, -0.001692, -1.263939, -0.325499, -0.252203, -0.000453, -0.722955, -0.001885, -0.001149, 0.410714, 1.971330, -0.000482, -0.710449, 0.346893, 0.563124, -0.006602, 
	-0.278779, 0.089788, 3.904400, 1.664643, -1.292601, -0.034774, 2.072104, -0.194842, -0.063889, 2.014181, 1.477348, -0.044881, -2.293792, -3.971655, -1.998182, -1.049070, 
	-0.021356, -0.003455, -0.643003, -0.073511, -1.235224, -0.001128, -0.250514, -0.015590, -0.002447, -0.478429, -4.908514, -0.001184, 7.903577, -0.175913, -0.061668, -0.031640, 
	-0.017214, -0.010678, 0.414196, -0.305941, 0.460748, -0.002907, 1.508342, -0.041520, -0.011169, 2.714204, 0.373613, -0.003092, -1.274443, -5.114605, 0.884822, 0.425644, 
	-0.181227, -0.021641, -0.180070, 4.545842, -4.157992, -0.007183, -0.549529, -0.089434, -0.017135, -1.233257, 0.113260, -0.007648, -0.558639, -2.098021, 3.076865, 1.365811, 
	-0.009546, -0.005492, 0.163852, 0.235163, 0.140981, -0.001604, -0.198944, -0.010598, -0.004061, 0.137427, -0.421300, -0.001738, 0.737340, 0.874290, -1.588940, -0.046832, 
	-0.070357, -0.027456, -0.621104, -0.640910, 0.399949, -0.040072, -0.064606, -0.023850, -0.021585, -1.313076, 1.966227, -0.040773, -2.935104, -2.199147, -2.005203, 7.637069, 
	-0.000973, -0.000938, -0.757227, 0.936248, 0.126989, -0.000369, -0.382447, -0.000847, -0.000685, -0.037215, -0.449311, -0.000377, 0.358073, -0.129719, 0.343359, -0.004560, 
	-0.040804, 0.548994, 2.188755, -0.040520, -0.962174, -0.003344, -5.038900, -0.082178, -0.005374, 1.324751, -4.223348, -0.003435, 8.039074, -2.058965, 0.421034, -0.063568, 
	-0.176435, -0.052955, -2.983104, -1.319209, 2.914532, -0.016332, 0.167267, -0.080419, -0.034810, -2.969513, 3.310704, -0.017188, 2.175322, 1.684461, -2.848354, 0.246034, 
	-0.013596, -0.003875, -1.636597, 1.091598, -0.498596, -0.000915, -0.067701, -0.004994, -0.002275, 2.231004, -0.223375, -0.001029, -0.005084, -0.602635, -0.238473, -0.023459, 
	-0.030047, -0.010880, -0.116902, 1.414434, -0.953073, -0.003458, -4.304301, -0.020622, -0.008049, -2.175389, 4.742340, -0.003949, -4.414359, 6.483769, -0.401494, -0.198020, 
	-0.063878, -0.032110, -2.389040, 2.040790, 1.201312, -0.003790, 3.600683, -0.031871, -0.011320, 1.001255, -4.396209, -0.004088, -0.198509, 1.396301, -1.504798, -0.604727, 
	-0.065487, -0.030198, 1.243610, -1.255901, -1.154299, -0.004643, 1.759811, -0.015716, -0.008694, -1.322779, -2.972512, -0.004982, 1.254815, 1.543234, 1.253689, -0.219949, 
	-0.014603, -0.002818, 1.034554, 1.225688, -1.093084, -0.000643, -1.377945, -0.001901, -0.001285, -0.920594, 5.506907, -0.000653, -3.828505, 0.021946, -0.536121, -0.010943, 
	-0.004114, -0.004101, 0.249164, -0.584325, 0.152934, -0.000950, -0.588056, -0.004177, -0.002134, 0.697068, -0.743252, -0.000994, 0.182455, -0.392816, 1.161453, -0.118154, 
	-0.007276, -0.006556, 2.751937, 0.847107, 3.220452, -0.001243, 0.269612, -0.007884, -0.003380, -1.164319, 0.376637, -0.001277, -4.827026, -0.507980, -0.876981, -0.061824, 
	-0.004942, -0.140040, 2.203101, -1.221938, -0.219675, -0.001305, -1.767884, 0.138860, -0.002943, 1.554715, -3.966200, -0.001256, 4.104562, -0.861197, 0.263825, -0.077684, 
	-0.017209, -0.016516, 0.137931, 0.135738, -0.913113, -0.001906, 1.167045, -0.065377, -0.010899, -1.406379, 1.466008, -0.002634, 1.262339, -0.718865, -0.960174, -0.055988, 
	-0.038216, -0.007630, -0.145204, 6.246405, -0.481370, -0.010214, 0.631019, -0.029318, -0.013959, -0.905114, -2.575269, -0.139793, -0.234093, -3.201992, 0.588307, 0.316440, 
	-0.061053, -0.014928, 1.163315, 5.929082, -2.129281, -0.004983, 2.164376, -0.029349, -0.000570, -1.578959, -3.528786, -0.005191, 2.172207, -2.505695, -1.477209, -0.092977, 
	-0.013816, 1.266309, 1.446636, 0.155175, 4.803019, -0.004057, -1.338297, -1.071432, -0.007416, 1.171129, -3.328365, -0.004129, -1.724740, 0.105156, -1.402387, -0.052785, 
	-0.001263, -0.001457, -1.149079, 2.707919, -0.182190, -0.000605, 0.641051, -0.001100, -0.000981, -0.967434, 0.035447, -0.000621, -0.883871, -0.042858, -0.112196, -0.040761, 
	-0.147522, -0.048443, -4.849313, -0.961063, -1.947749, -0.021840, 2.006971, -0.073753, -0.034892, 5.835333, -0.745846, -0.022658, -3.039210, 3.693694, 0.477306, -0.121014, 
	-0.016921, -0.006548, 1.216958, -0.299945, -0.787692, -0.001049, -2.790287, -0.005636, -0.002970, -0.457710, 1.552962, -0.001182, 2.061872, -1.048468, 0.598011, -0.011395, 
	-0.003052, -0.002600, 0.760887, -2.132283, 0.248267, -0.000428, 1.999292, -0.003761, -0.001509, 1.159773, 1.233691, -0.000494, -2.661936, -0.300504, -0.287060, -0.008284, 
	-0.008542, 0.587736, 1.824587, 0.279518, 0.480691, -0.001248, -0.647609, -0.436317, -0.002276, -0.441817, -1.669197, -0.130724, 1.551319, -0.762151, -1.121533, 0.497563, 
	-0.025199, -0.010341, -0.160486, -0.422180, -2.301290, -0.002800, -0.386939, -0.012730, -0.007118, 1.481921, -7.493798, -0.002819, 4.589479, 2.768515, 2.111549, -0.125765, 
	-0.036080, 0.001869, -0.026723, -3.901267, 2.741854, -0.001890, 0.200543, -0.067926, -0.007580, 0.623882, 4.404658, -0.001910, -3.366033, -3.024864, 2.548139, -0.086673, 
	-0.010055, -0.009012, -0.356448, 3.050503, 0.062161, -0.002474, -0.032882, -0.008343, -0.005169, -1.803420, 0.611657, -0.002555, -2.393453, -2.758032, 3.894464, -0.236942, 
	-0.024618, -0.021759, -0.365459, -0.041773, 1.973300, -0.003417, -4.498265, -0.020591, -0.008772, -0.974115, 1.176928, -0.003639, -1.196861, 0.900764, 3.315362, -0.207086, 
	-0.003229, -0.001884, -0.349229, -0.165615, 0.426957, -0.000615, -0.643898, -0.002413, -0.001171, -0.072484, 1.296607, -0.000642, -1.181539, 0.760253, -0.050444, -0.010651, 
	-0.090797, -0.026211, -2.377496, 0.330835, -3.206355, -0.007052, 3.209610, -0.039996, -0.015943, -1.434987, 0.627082, -0.008003, 4.529443, -3.547173, 1.142015, 0.915026, 
	-0.005262, -0.003857, -0.280920, -0.187604, 1.308458, -0.001462, 4.189318, -0.006453, -0.002466, -0.391305, -1.149887, -0.001508, -3.696850, 0.656518, -0.315127, -0.111593, 
	-0.002738, -0.001929, -1.354396, 1.522243, -1.377470, -0.000688, 2.710214, -0.002638, -0.001625, 0.316810, 0.089380, -0.000781, -1.581971, -0.193646, -0.109320, -0.011444, 
	-0.003049, -0.004515, -0.684573, -0.198393, 1.618675, -0.000872, -0.081980, -0.005050, -0.002915, -0.027646, -0.988253, -0.001003, 2.091701, -1.104416, -0.597047, -0.010663, 
	-0.023414, -0.014617, 4.485271, -0.665385, -1.942493, -0.003195, 0.711294, -0.015998, -0.009096, 4.169470, -0.992923, -0.003404, -3.243669, -1.645405, -0.391070, -0.415365, 
	-0.016861, -0.012718, 2.729733, -2.151223, -1.578920, -0.005224, -3.179460, -0.033836, -0.009614, -2.067459, 2.174539, -0.005483, -4.548931, 2.851187, 5.668240, 0.186032, 
	-0.009844, -0.005876, 0.587377, 2.002393, 1.033372, -0.003060, -1.492423, -0.011830, -0.004805, -1.156849, -1.820017, -0.003133, 1.079474, -1.046498, 0.906091, -0.054373, 
	-0.013471, -0.004477, -1.015552, 0.778937, -2.261914, -0.000734, -3.485746, -0.003825, -0.002167, -1.753397, 1.624268, -0.000807, 5.846303, -0.438604, 0.769030, -0.037844, 
	0.114904, -0.564797, -0.469904, -9.127423, 4.248961, -0.412810, -5.910548, -1.131004, -0.638523, -3.089870, 3.653378, -0.336670, 1.361015, 2.730068, -0.567164, 10.140384, 
	-0.010734, -0.007642, -1.027216, -2.833060, 0.526856, -0.001485, -0.363715, -0.005394, -0.005088, 0.297443, 3.226721, -0.001526, -1.284107, 1.491928, 0.186295, -0.189276, 
	-0.000082, -0.000110, -0.001687, -0.032717, -0.031852, -0.000057, 0.007251, -0.000120, -0.000106, -0.004678, -0.063444, -0.000053, 0.173122, -0.007033, -0.033656, -0.004780, 
	-0.037049, -0.007736, -0.044494, 2.721142, -1.843695, -0.002686, -4.795672, -0.097122, -0.007027, 1.470258, 0.772689, -0.002858, 3.658128, -0.444762, -1.177927, -0.161189, 
	-0.051121, -0.020669, 0.837378, -0.200301, -7.135839, -0.009032, -3.849175, -0.019106, -0.011502, -1.189274, 2.520473, -0.009359, 11.341773, -1.392161, -0.591517, -0.220570, 
	-0.002709, -0.004099, -1.981646, 1.768751, -0.389840, -0.001380, 1.040589, -0.002977, -0.002249, 2.426792, -1.039361, -0.001392, -0.587733, -0.759620, -0.434640, -0.028486, 
	-0.029677, 0.181885, -2.052274, -0.318376, -0.316258, -0.003055, -1.160100, -0.094058, 0.046114, 0.353581, -2.781403, -0.003125, 5.908690, 2.191798, -1.816957, -0.106785, 
	-0.016089, -0.005235, -0.396880, 2.318041, 1.406853, -0.001081, -1.613447, -0.004879, -0.002684, -0.546076, -1.638816, -0.001143, 1.387613, -1.757179, -0.340293, 1.211294, 
	-0.064244, -0.013216, 1.271102, 0.150651, 4.154556, -0.001942, -0.649384, -0.018085, -0.007191, -2.559148, 4.446484, -0.002146, -3.921982, -1.297208, -1.417246, -0.071002, 
	-0.016693, -0.006636, -0.276869, 0.294362, 4.211835, -0.002134, -2.959467, -0.024898, -0.005092, -1.202091, 1.019181, -0.002305, -1.103299, 0.160450, -0.066584, -0.019759, 
	-0.015262, -0.008200, 4.402223, 0.048586, -1.193251, -0.002395, 1.726234, -0.008313, -0.005526, -1.267802, -3.316240, -0.002518, 1.329233, -0.556870, -0.991793, -0.138107, 
	-0.005874, -0.003293, 0.915993, 0.409145, -0.290489, -0.001519, -0.341435, -0.004116, -0.002505, -0.449672, 2.934857, -0.001561, -2.363146, -0.797971, 0.030800, -0.029214, 
	-0.017653, -0.003973, -0.159775, 2.227253, 0.852928, -0.001186, -0.756638, -0.003831, -0.002457, -1.650886, 3.697221, -0.001252, -4.602508, 0.284378, 0.159561, -0.021183, 
	-0.061609, -0.016766, 0.262923, -0.592197, -4.948262, -0.005436, 1.819390, -0.032889, -0.011449, -1.481404, 1.775232, -0.005360, -1.237922, 4.390887, 0.509848, -0.364987, 
	-0.134347, -0.070308, -3.219568, 2.090714, -1.999842, -0.035998, -4.942432, -0.092570, -0.054241, 3.634439, -4.798902, -0.036726, 5.664787, 2.449703, 2.268613, -0.723323, 
	-0.090768, -0.020831, -2.645073, -1.280339, -0.821934, -0.008904, 6.536043, -0.059244, -0.015253, -2.991644, 6.411761, -0.008207, -2.037920, -1.216984, -1.746326, -0.004377, 
	-0.050630, -0.041229, 0.092036, -2.004926, -2.607347, -0.015481, -3.221542, -0.102591, -0.028346, 1.020204, 4.000859, -0.016856, -2.307833, 2.545300, 3.277611, -0.539229, 
	-0.009319, -0.002035, -0.694353, 0.229760, -0.303563, -0.000790, 0.181153, -0.002220, -0.001390, 0.152526, 2.220205, -0.000791, -1.350777, -0.420115, 0.022204, -0.020496, 
	-0.002967, -0.001949, -0.292601, 0.250310, -0.996392, -0.000546, 4.008224, -0.002374, -0.001331, 0.725499, 1.089827, -0.000577, -3.465446, -0.945885, -0.329401, -0.034391, 
	-0.008712, -0.004314, -1.013762, 1.299736, -0.725486, -0.001191, -2.497156, -0.005014, -0.002654, -0.280831, -1.456187, -0.001230, 5.410988, -0.167156, -0.502593, -0.044437, 
	-0.000958, -0.000745, 0.181397, -0.444931, -0.237489, -0.000337, -0.707736, -0.006923, -0.000739, 0.653983, -1.555807, -0.000924, 2.117752, -0.066053, 0.075019, -0.005510, 
	-0.091662, 0.048315, -5.865849, 4.862061, 3.939656, -0.023216, -3.428880, -0.220361, -0.040237, 6.037500, -2.742409, -0.024079, 3.963248, -1.212636, -4.635974, -0.565476, 
	-0.039100, -0.016184, -2.130370, -1.632856, 0.551757, -0.004647, -0.948612, -0.027559, -0.010734, 6.255569, 4.996231, -0.005053, -5.038858, -1.748467, 0.026727, -0.227845, 
	-0.007003, 0.124949, 0.020878, -3.037396, -0.635809, -0.001871, -0.820086, -0.123016, -0.003127, 3.599754, -2.469630, -0.001936, 0.923668, 1.513803, 0.947384, -0.030561, 
	-0.064324, -0.029377, -0.510214, 5.887890, -1.456704, -0.005340, 3.211145, -0.031663, -0.012183, 0.837973, -2.407870, -0.005665, -1.031467, -2.683023, -1.435798, -0.263381, 
	-0.024255, -0.010844, -0.862246, -1.021677, -1.774352, -0.003071, -1.262369, -0.016298, 0.001926, -0.502985, 4.679605, -0.003371, -3.580708, 5.295957, -0.742112, -0.173200, 
	-0.005262, -0.003977, -0.916072, 3.681355, -1.307067, -0.001079, -1.238065, -0.023531, -0.003016, -0.266168, 0.570800, -0.001103, -2.727341, 2.015221, 0.297000, -0.071695, 
	-0.010480, -0.008942, -4.653256, -1.275485, -0.265361, -0.004358, 1.506865, -0.009477, -0.006904, 5.037978, -5.386518, -0.004527, 1.186983, 4.739415, -0.659200, -0.186730, 
	-0.024667, -0.010742, 4.007730, -0.294205, -1.668597, -0.002143, 0.931728, -0.065856, -0.006912, -1.355842, 0.338885, -0.002441, 0.077292, -0.603266, -1.210897, -0.110068, 
	-0.003878, -0.009374, -1.023082, 0.183106, 0.487520, -0.001346, 0.171159, -0.004952, -0.004119, 0.575504, 2.974648, -0.001732, -0.578184, -1.261998, -1.446807, -0.056467, 
	-0.059019, -0.033117, -2.036544, -2.283915, -0.288976, -0.008877, -1.956919, -0.040649, -0.019573, 7.264671, 1.751938, -0.009370, 1.248175, -3.572087, 0.336980, -0.292716, 
	-0.062707, -0.031537, -1.470691, 2.139042, -1.388103, -0.008983, 2.650573, -0.222205, -0.027504, 2.294749, -0.179556, -0.013733, -6.165018, -1.487534, 4.792017, -0.818809, 
	-0.008555, -0.007650, 1.907902, -2.443446, -0.755389, -0.002283, -1.428614, -0.022567, -0.005578, 1.085942, 2.365058, -0.002513, -1.792808, 0.016664, 0.685718, 0.408120, 
	-0.263610, -0.118978, -0.935072, 0.124710, -3.227479, -0.048546, -0.707538, -0.190731, -0.090857, -1.539080, 6.632135, -0.309681, 1.204053, -2.386706, 2.651603, -0.794223, 
	-0.022994, -0.015819, 0.375259, 2.881317, -5.674899, -0.004355, 7.606620, -0.037337, 0.089844, 0.028813, -0.830565, -0.134054, -3.571996, -1.082982, 0.511095, -0.117946, 
	-0.074726, -0.022396, -2.241688, -0.381663, 1.652539, -0.008606, 2.360201, -0.032779, -0.015568, -1.902034, 2.736641, -0.022156, -0.552850, -1.323315, 0.071244, -0.242844, 
	-0.010918, -0.011017, -0.034328, 1.061570, -1.040814, -0.002867, -1.929920, -0.012576, -0.005955, 0.277327, 2.895083, -0.003034, 1.710474, -1.970895, -0.721862, -0.200267, 
	-0.050277, -0.008386, -0.957486, -0.657394, 5.751118, -0.003491, -2.144959, -0.010626, -0.005967, -1.852649, -3.493125, -0.003661, -1.042839, 1.471761, 3.307203, -0.299222, 
	-0.048964, -0.020518, 2.505000, 0.544439, 1.406680, -0.005520, -2.886388, -0.033510, -0.013572, -3.293500, -0.635155, -0.006049, 2.052055, 0.397005, 0.262827, -0.224829, 
	-0.008470, -0.003819, -0.851418, 3.303791, -1.154521, -0.000928, -1.846505, -0.003209, -0.001860, -1.032560, -0.904062, -0.000994, 2.526982, -0.125108, 0.141983, -0.039301, 
	-0.053638, -0.010889, 0.500135, -2.945549, 1.938318, -0.005575, 3.599730, -0.021709, -0.007957, 1.613918, -4.377668, -0.006018, -0.284699, -1.507173, 1.656177, -0.087404, 
	-0.009772, -0.011597, -0.742439, 4.359905, 1.425203, -0.001271, 3.319317, -0.007529, -0.003176, -2.939869, -0.926697, -0.001342, -2.582599, -0.567298, -1.077186, -0.233649, 
	-0.025959, -0.010698, 0.412379, 2.197552, 0.729906, -0.002567, 3.146757, -0.014277, -0.006266, -1.007851, 0.401283, -0.002722, -4.724848, -1.159242, 0.168488, -0.101934, 
	-0.019903, -0.013010, -0.670067, -0.679594, -0.711938, -0.002753, -1.009746, -0.029091, -0.008013, 1.513167, 2.974819, -0.003030, -1.725412, 0.462232, 0.163357, -0.241017, 
	-0.004630, -0.000321, -0.667485, 0.119997, -0.078086, -0.000200, -0.202105, -0.000348, -0.000281, 0.693046, -0.240953, -0.000187, -0.150611, -0.032646, 0.565629, -0.000817, 
	-0.015071, -0.006964, 0.231412, -1.522756, 2.479283, -0.001173, 0.074917, -0.011703, -0.004183, 2.205431, 0.025900, -0.001384, -1.952493, -1.066170, -0.297678, -0.137367, 
	-0.010230, -0.004919, 1.388042, 0.727870, -1.479846, -0.001674, 0.782926, -0.004979, -0.003368, 1.007388, 2.199142, -0.001750, -3.409688, -1.222959, 0.104633, -0.070588, 
	-0.258082, -0.147198, -2.177616, -2.154575, -3.367499, -0.034284, 0.622144, -0.208434, -0.081469, 0.703501, -0.280787, -0.041237, 4.444490, 2.635452, 0.504559, -0.158965, 
	-0.130231, -0.015298, -1.527775, 5.414266, -2.101705, -0.003736, -3.825379, -0.043405, -0.010430, -2.851332, 1.860726, -0.003689, 0.835796, 4.457340, -1.908254, -0.146894, 
	-0.132114, -0.049991, 2.903148, -1.023267, 3.354105, -0.021174, -6.244982, -0.082019, -0.036278, -3.779208, 4.831984, -0.022043, 5.970290, -2.544648, -3.937237, 0.813434, 
	-0.084996, -0.032903, -1.241559, -2.541156, -5.765485, -0.008523, 7.435180, -0.039862, -0.018357, -1.159331, 4.750607, -0.017543, 0.561303, -2.152103, 0.528224, -0.213496, 
	-0.139716, -0.096670, -1.712310, 2.441668, 2.026270, -0.027902, -1.263373, -0.122520, -0.061993, 1.621745, -0.583909, -0.029890, 0.604185, -0.743940, -1.374537, -0.537107, 
	-0.029615, -0.006433, -0.722594, -0.107220, 2.586846, -0.002791, -0.235323, -0.015156, -0.004705, 0.150265, -2.170200, -0.002871, -1.851607, 2.864733, -0.424863, -0.028465, 
	-0.034034, -0.020053, 1.825243, -3.117288, -2.618428, -0.007406, 0.915990, -0.025232, -0.013714, -0.274283, -0.113217, 0.040974, -1.330577, -1.192913, 5.194521, 0.770418, 
	-0.069195, -0.032710, -3.646182, 2.024983, 2.140909, -0.010389, 2.764118, -0.039745, -0.030102, -0.334291, 3.868750, -0.011432, -4.891875, -2.487571, 0.661196, 0.093536, 
	-0.006327, -0.003390, 0.168654, 0.151630, 1.638816, -0.001489, -1.844252, -0.002718, -0.002212, 0.344836, 0.541542, -0.001529, -1.895424, -0.240589, 1.163766, -0.011315, 
	-0.148493, -0.149864, -4.096082, 2.341700, -3.197022, -0.037667, -0.443832, -0.222325, -0.100082, 2.354559, -0.067314, -0.041930, 0.515598, 3.123304, 0.689214, -0.519766, 
	-0.035532, -0.004973, 0.711244, 0.952057, 2.666322, -0.001852, -2.219837, 0.054739, -0.065207, -2.124704, -3.153918, -0.001938, 1.949612, -1.029516, 2.399029, -0.095527, 
	-0.037990, -0.014026, -0.056473, -1.984034, 0.988368, -0.003906, 2.675771, -0.026781, -0.009186, 0.706274, 4.185922, -0.004129, -5.145708, -0.761108, -0.863509, 0.350515, 
	-0.001084, 0.255366, 0.237891, 0.534877, -1.107286, -0.000332, 0.261097, -0.080124, -0.000727, 0.299685, 1.083842, -0.000341, -1.345663, -0.070017, -0.006983, -0.060202, 
	-0.037375, -0.021547, -0.062372, -2.599704, -3.630644, -0.004294, 1.601357, -0.029662, -0.009374, -4.231563, 0.083916, -0.004667, 1.465098, 8.775355, -1.157565, -0.136961, 
	-0.003940, -0.002650, 1.518073, 0.409305, 2.895859, -0.001209, 0.687749, -0.002938, -0.002008, -1.859617, -1.762432, -0.001234, -1.817818, -0.588595, 0.549071, -0.017616, 
	-0.031095, -0.015908, 0.943154, -2.187952, 2.132290, -0.004172, -4.133357, -0.014992, -0.008864, 0.385758, -3.459551, -0.004268, 3.951144, 3.894597, -1.153179, -0.293605, 
	-0.002676, -0.003435, -0.083359, -1.350324, -2.358263, -0.000797, -3.493665, -0.002600, -0.001989, 0.256530, 6.439072, -0.000840, 1.671182, -0.370361, -0.640812, -0.057663, 
	-0.008561, -0.006479, 0.324112, -2.949617, -1.349247, -0.002010, 1.703123, -0.004968, -0.003975, 3.346529, -0.897340, -0.002167, -0.795033, -0.749928, 1.448388, -0.052824, 
	3.543891, -0.197980, -0.911298, -3.053011, 0.248308, -0.037544, 3.855169, -0.111354, -0.068814, -3.862908, -0.710403, -0.038815, -1.281977, 4.637491, -0.442628, -1.568127, 
	-0.294423, -0.114243, -2.444027, -4.707885, -2.656616, -0.028287, 2.981178, -0.266348, -0.070965, -3.170029, 3.991384, -0.034393, 4.521338, 3.892815, -0.959497, -0.640002, 
	-0.010987, -0.005822, -1.952826, -1.844798, -0.172055, -0.001840, 2.163265, -0.006646, -0.004075, 3.437694, -0.208266, -0.002052, 0.147205, -0.337622, -1.132113, -0.069062, 
	-0.038143, -0.021979, -0.382279, -1.523395, -0.896851, -0.003937, -4.748016, -0.040693, -0.011676, 3.330434, 0.715810, -0.004119, 4.518695, -1.008360, 0.297715, -0.183205, 
	-0.015593, -0.007388, -0.877069, -3.159409, -1.279400, -0.002467, 0.712163, -0.013020, -0.005714, 4.336153, 6.267000, -0.002462, -2.749417, -1.515316, -1.573501, -0.114560, 
	-0.011313, -0.009357, 0.040141, -2.203226, 0.022407, -0.001889, 4.370312, -0.006872, -0.004769, 1.820071, -2.267699, -0.002005, -1.015429, -0.667915, -0.024529, -0.037926, 
	-0.011472, -0.007497, -0.131978, 0.473072, 0.675744, -0.001674, -1.448129, -0.006655, -0.003639, -0.527583, -0.530051, -0.001819, 2.946292, -0.502425, -0.830174, -0.092010, 
	-0.052517, -0.007146, 0.199103, -2.686633, -1.373936, -0.002201, -1.163048, -0.016889, -0.004913, -0.282284, 3.672602, -0.002251, 0.880576, 2.287471, -1.379360, -0.068574, 
	-0.006764, -0.003669, 0.226445, 1.575508, 1.384092, -0.001163, -0.729170, -0.003392, -0.002193, -1.776599, -0.067873, -0.001258, -0.049319, -0.137999, -0.390856, -0.015789, 
	1.794944, -0.102268, -0.367370, -0.815181, -1.571770, -0.037964, 2.254025, -0.344954, -0.098670, 0.460057, -0.529937, -0.045363, -0.123489, 1.191659, 0.263353, -1.927072, 
	-0.006085, -0.003360, -1.370241, -0.034169, -0.420513, -0.000677, -1.232593, -0.004880, -0.002061, -0.244819, 4.243572, -0.000736, -1.460627, -0.972714, 1.538018, -0.028114, 
	-0.061486, -0.006574, -1.054521, -2.238271, 1.729906, -0.002536, 4.703263, -0.010611, -0.004590, -0.065584, -0.727834, -0.002628, -1.925274, 0.786801, -1.046566, -0.073495, 
	-1.287214, 0.034938, -1.972030, -2.270993, -3.425007, -0.110543, 5.156010, -1.138187, -0.313791, 0.177040, 4.553634, -0.247861, 1.793562, -0.542100, 0.122997, -0.530454, 
	-0.013925, -0.006047, 2.216493, 0.677157, 0.672097, -0.002568, 0.229305, -0.029029, 0.073093, -1.247385, -0.122094, -0.007114, -2.484046, 0.907672, -0.807624, -0.055986, 
	1.996871, -0.021899, 0.176215, -2.390659, -0.690689, -0.022659, 1.252469, -0.212945, -0.073733, -3.343588, 0.709724, -0.025613, 3.785037, -3.627802, 2.129521, 0.359751, 
	-0.040435, -0.008150, -0.894957, -0.762816, -2.520084, -0.002482, 3.627332, -0.016367, -0.005712, -0.525645, -5.103571, -0.002601, 6.743405, -1.379185, 1.043448, -0.152180, 
	-0.006026, -0.004004, -1.135237, -1.704329, 0.774210, -0.000924, 1.424068, -0.004369, -0.002469, 0.403507, -2.310005, -0.001004, 2.278590, 0.011363, 0.287098, -0.010468, 
	-0.002452, 0.318779, 0.529317, 0.288257, 0.899997, -0.001263, -1.928811, -0.301098, -0.002184, -0.968313, -1.870757, -0.001310, 2.236802, 2.378621, -1.555693, -0.019891, 
	-0.058491, -0.025713, -5.094386, 7.081235, -0.498474, -0.009067, -5.319040, -0.049665, -0.018362, -1.316062, -0.305913, -0.009355, 6.513991, 3.082489, -3.880138, -0.093049, 
	-0.032959, -0.016456, 3.111524, -0.557924, -3.728457, -0.002335, 1.412577, -0.009499, -0.004659, -1.011680, -0.496312, -0.002414, 1.285034, 0.279819, -0.201411, -0.024850, 
	-0.008439, -0.004421, 0.279214, -0.336135, -0.935623, -0.001488, 0.449975, -0.018769, -0.003007, -1.215637, 2.264132, -0.001552, -2.052871, 0.636390, 1.010481, -0.062250, 
	-0.005855, -0.004189, -0.840377, 0.796224, -0.578402, -0.001522, 0.073415, -0.003747, -0.002482, 0.272966, 0.147014, -0.001554, -1.658314, 0.238088, 1.644218, -0.075482, 
	-0.010797, -0.004800, -0.702142, 0.164870, -0.245622, -0.002497, -0.382755, -0.004976, -0.003561, 0.483523, 1.629489, -0.002429, -1.401165, -0.425726, 0.953357, -0.044769, 
	-0.014639, -0.006396, -0.015985, -0.007771, 0.200538, -0.002355, -0.074822, -0.006184, -0.004170, -1.019935, -0.850310, -0.002286, 1.297865, -1.103243, 1.700710, -0.091017, 
	-0.061398, -0.018113, -0.472141, 2.211202, 7.991893, -0.007359, -2.422278, -0.017535, -0.013448, -2.761789, -1.774721, -0.137001, -1.559287, -0.606494, -0.228700, -0.122830, 
	-0.008951, -0.007664, -0.106827, -1.919288, 1.069523, -0.002129, 3.514348, -0.013297, -0.004569, 2.227586, -1.143426, -0.002227, -3.747007, 0.122021, 0.117401, -0.095493, 
	-0.000621, -0.000388, -0.135156, -0.119519, 1.027907, -0.000193, -0.342138, -0.000732, -0.000346, -0.017304, -0.029508, -0.000193, -0.354931, -0.087196, 0.065206, -0.004887, 
	-0.009902, -0.003531, 0.079710, -3.279605, -0.740681, -0.000884, -1.506618, -0.004177, -0.002143, 2.322504, -4.374375, -0.000884, 7.080870, 1.072345, -0.577671, -0.054957, 
	-0.040365, -0.001176, -0.816367, -0.091853, 0.567912, -0.000349, 0.694609, -0.017846, -0.001296, 1.298628, -0.619596, -0.000392, -0.821450, -0.209231, 0.066231, -0.007460, 
	-0.036702, -0.006970, -1.544199, -0.838713, -1.080086, -0.001941, 5.050703, -0.028452, -0.005615, 2.445741, -1.516013, -0.002121, -0.365792, -1.234936, -0.718044, -0.116860, 
	-0.035606, -0.037499, 9.373966, 1.305835, -2.725795, -0.004181, -3.147885, -0.118157, -0.020851, 7.323929, -3.643750, -0.005316, -6.637263, 2.375555, -3.613705, -0.389276, 
	-0.018097, -0.011320, -2.688658, -1.208821, -2.096495, -0.003617, 0.495127, -0.007024, -0.005409, 1.037493, -0.922115, -0.003697, 5.076090, 0.402792, 0.088205, -0.134455, 
	-0.004973, -0.005085, -0.967694, 1.665184, 2.724552, -0.000735, -0.684241, -0.006489, -0.002508, -1.114918, -2.341538, -0.000839, 0.853691, -0.383205, 0.309398, -0.040600, 
	-0.082435, -0.016728, -0.307002, -0.382560, 5.674894, -0.003969, -0.141220, -0.026104, -0.009594, -1.785164, -2.660612, -0.004196, 1.647410, -0.414736, -1.248493, -0.239490, 
	-0.223787, -0.048899, -2.136288, -5.950387, -2.692529, -0.005838, -2.997821, -0.110597, -0.022729, 7.867463, 2.562199, -0.006685, -2.772322, 6.580836, 0.570334, -0.612949, 
	-0.003195, -0.004029, 0.000059, 0.489599, -0.737187, -0.001302, -1.513273, -0.004775, -0.002762, -1.079530, 1.592806, -0.001813, 1.219795, -0.093439, 0.152636, -0.013591, 
	-0.015514, -0.004219, -2.307602, 1.667873, 0.170732, -0.001321, 1.947645, -0.007470, -0.002499, 0.180749, -0.321874, -0.001384, -1.532469, -0.932046, 1.239954, -0.080552, 
	-0.011599, -0.006529, 0.828781, -3.415483, 0.202299, -0.004830, 0.217530, -0.005541, -0.004401, 1.817157, -2.119385, -0.004890, 1.597167, 0.590012, -0.929507, 1.249219, 
	-0.010906, -0.004080, -1.805594, -0.548860, 0.069089, -0.001587, -1.732425, -0.005484, -0.002782, 1.747314, -0.073639, -0.001649, 1.527680, 1.461094, -0.586080, -0.032091, 
	-0.001574, -0.002345, -0.829693, 0.744047, -0.993578, -0.000563, -0.178503, -0.001472, -0.001406, 0.677671, -0.997858, -0.000603, 1.207319, 0.510334, -0.120689, -0.011085, 
	-0.010207, -0.008430, -1.069720, -2.030288, -2.683677, -0.002341, 0.679568, -0.014406, -0.006444, 4.900203, -1.708085, -0.002586, -0.123496, 0.868270, 1.297396, -0.085755, 
	-0.069210, -0.031410, -0.615830, 0.804974, 0.165714, -0.006667, 4.977383, -0.077411, -0.026524, -3.090720, -1.357601, -0.007810, -3.121775, 0.384422, -1.363253, 3.435720, 
	-0.034707, -0.016532, -1.580682, -2.613184, 0.238051, -0.003070, -5.027173, -0.034349, -0.009260, 2.437193, 0.272473, -0.003474, 5.458038, 2.088368, -1.010699, -0.160993, 
	-0.033584, -0.003649, 0.633417, -0.118306, -0.424239, -0.001230, -1.501718, -0.004630, -0.002717, 1.641887, 0.618722, -0.001281, 0.105391, -0.408203, -0.404285, -0.095574, 
	-0.149979, 0.562029, -0.199397, 1.628782, -2.534582, -0.008765, 0.183337, -0.675049, -0.027133, 2.016777, -8.322360, -0.009662, 7.178042, -0.860407, 0.363357, 0.855010, 
	-0.050797, -0.036407, 9.640634, -2.178183, 0.860794, -0.007910, -1.869372, -0.022829, -0.016433, -5.159308, 1.162217, -0.008583, -2.354809, 0.576173, -0.187491, -0.347696, 
	-0.009835, -0.000387, 0.925623, -0.317621, 0.159126, -0.000176, 0.047401, -0.000631, -0.000325, 0.032099, -0.423666, -0.000196, 0.218420, -0.036951, -0.590078, -0.002805, 
	-0.009094, -0.002583, -0.022028, 0.421510, 2.507998, -0.000783, -0.565853, -0.004736, -0.001683, -0.875166, 1.490738, -0.000811, -2.497560, -0.164843, -0.161751, -0.113355, 
	-0.007243, -0.005090, 0.456210, -1.166445, -1.411523, -0.002649, -0.515749, -0.004863, -0.003643, -0.296245, 0.206189, -0.002654, 0.076928, 0.113839, 2.593222, -0.030285, 
	-0.010016, 0.298740, -0.165577, 0.236864, -0.320313, -0.001595, 1.159306, -0.302516, -0.004559, -0.901418, 1.304940, 0.001427, -2.509619, -1.094311, 2.351647, -0.043001, 
	-0.047978, -0.022501, -1.255593, 3.926370, 0.403392, -0.005747, -2.512279, -0.121377, -0.016786, 0.799518, 2.637740, -0.009480, -0.034548, -1.743956, -1.885006, -0.111769, 
	-0.016028, -0.009557, -0.841238, -2.091309, 1.526146, -0.001670, -0.317001, -0.007952, -0.003866, 1.178872, 3.737626, -0.001784, -3.331544, 0.195723, 0.227640, -0.244057, 
	-0.015462, -0.007819, -0.278393, 2.974319, -3.656202, -0.001651, 0.151450, -0.007391, -0.003606, -2.688377, 4.307303, -0.001781, -1.102449, 0.151077, 0.212688, -0.033708, 
	-0.101450, -0.053847, 0.790745, -1.900082, 2.256408, -0.013442, 1.521748, -0.120413, -0.033581, -4.199137, 0.291446, -0.014822, -0.411611, 2.250728, 0.229699, -0.492389, 
	-0.003404, -0.001327, 0.022361, 0.245196, -0.509441, -0.000882, -2.293654, -0.003222, -0.001285, 0.134940, -0.031950, -0.000904, 2.382301, -0.055261, 0.116842, -0.000311, 
	-0.023101, -0.010872, 2.337028, 0.125397, -0.253628, -0.001707, 0.728468, -0.013455, -0.005845, -1.618435, 2.793789, -0.001945, -1.020213, -3.806683, -0.653311, 1.424513, 
	-0.012899, -0.006580, 0.091831, -2.455350, -2.344081, -0.001725, 4.429656, -0.004590, -0.003410, 4.661291, 0.320106, -0.001769, -2.706434, -1.721713, -0.133106, -0.111227, 
	-0.029757, -0.010794, -0.269066, -0.398138, 0.188512, -0.001334, 0.050539, -0.012270, -0.004479, -0.345191, -3.588253, -0.001435, 5.606225, -0.123236, -0.976977, -0.084346, 
	-0.025383, -0.012281, -1.324679, -1.071434, 0.382043, -0.002890, -1.726563, -0.022134, -0.007963, 2.356354, 2.774674, -0.003397, 1.019618, -0.294746, -1.904824, -0.136395, 
	-0.003639, -0.003436, 0.064493, -1.682065, -0.573000, -0.000841, -1.108322, -0.002059, -0.001675, -0.362683, 2.951334, -0.000878, -0.037784, 0.001080, 0.784243, -0.024767, 
	-0.002283, -0.001695, -2.082346, 1.011770, -0.235012, -0.000653, 0.685693, -0.001550, -0.001091, 1.359497, 1.211479, -0.000663, -1.149004, -0.086615, -0.698434, -0.009092, 
	-0.041965, -0.008982, -2.696157, 2.754780, -0.063730, -0.001934, 0.550916, -0.016098, -0.005316, 1.963257, -1.291460, -0.002080, -1.663646, -0.141986, 0.720616, -0.056216, 
	-0.043778, -0.012117, 2.226594, 0.135451, 1.495780, -0.003914, -2.130555, -0.014887, -0.008800, -0.978109, -0.354719, -0.004324, -1.204480, -1.636681, 2.621030, -0.086492, 
	-0.006310, -0.006709, -1.344211, 0.928899, -0.489952, -0.001975, 2.888990, -0.010523, -0.004040, -0.450696, 1.325554, -0.002091, -0.886126, -0.409491, -1.502611, -0.028708, 
	-0.032715, -0.006906, 1.549284, 0.289594, 3.316156, -0.001722, -1.866930, -0.010428, -0.003532, -1.959271, -2.111418, -0.001828, 0.288960, -0.305472, 0.882785, -0.026558, 
	-0.113900, -0.051138, 1.972215, -0.699633, -3.503831, -0.013980, -0.372446, -0.063633, -0.029300, 2.829046, -0.006641, -0.019399, -0.127083, -3.037352, 3.583412, -0.346338, 
	-1.199462, 0.637891, 6.392927, -1.008601, -3.769571, -0.127054, 3.013598, -0.783395, -0.300636, 3.049086, -3.990668, -0.280781, -0.221278, -0.998395, 2.119953, -2.533615, 
	-0.026496, -0.017951, 3.858099, 0.051319, 1.286311, -0.004746, 5.736069, -0.016673, -0.009785, 0.578934, -5.095945, -0.004985, -3.113514, -2.181871, -0.909653, -0.129115, 
	-0.002682, -0.001935, -0.025100, -0.717907, 1.449627, -0.001022, -1.639593, -0.002462, -0.001600, -0.634373, 3.711698, -0.001053, -2.248543, 0.378050, -0.238483, -0.024622, 
	-0.075127, -0.014962, -1.730091, 1.084837, 0.604211, -0.004129, 2.045670, -0.028920, -0.010607, -2.390503, -3.109136, -0.004433, 3.544792, 0.833810, -0.182664, -0.562746, 
	-0.010457, -0.004256, -0.254214, 1.470831, -1.298516, -0.000875, 1.288875, -0.024555, -0.002568, -1.254080, 0.234680, -0.000961, 1.460908, -1.342929, -0.197000, -0.064883, 
	-0.001952, -0.001035, 0.173880, -0.098063, 0.250794, -0.000371, -0.802533, -0.001184, -0.000683, -0.057143, 2.858097, -0.000395, -2.775720, -0.111347, 0.571034, -0.003377, 
	-0.001561, -0.001198, 0.381515, 0.392661, 0.483770, -0.000423, 0.188958, -0.002329, -0.000921, -0.500646, 0.714523, -0.000468, -1.349888, -0.212448, -0.076171, -0.015375, 
	-0.071130, -0.062120, 8.506033, 7.093702, -9.326514, -0.033184, -1.681017, -0.078410, -0.047468, 7.685355, 3.274636, -0.032619, -8.996649, -6.872159, 0.970747, -0.329203, 
	-0.021105, 0.506980, -0.720189, 1.435653, 2.598023, -0.004915, -7.344862, -0.520743, -0.020836, 0.877134, 2.963935, -0.005292, -0.023684, 1.706259, -1.236618, -0.189741, 
	-0.008180, -0.004494, 4.283599, -1.637752, -2.691423, -0.001774, -0.856886, -0.003656, -0.002825, -2.611681, -0.627970, -0.001816, 3.036029, 0.420276, 0.780630, -0.072077, 
	-0.022846, -0.014356, -2.119277, 0.088859, 5.884665, -0.005914, 1.258249, -0.020845, -0.010224, -0.082871, -4.397589, -0.006222, -2.081631, 1.151206, 0.537488, -0.158693, 
	-0.005866, -0.003842, -0.321100, 1.182796, -1.448906, -0.000883, -0.269524, -0.007423, -0.002747, 0.870888, -0.713530, -0.001029, 2.493278, -0.411570, -1.315040, -0.045502, 
	-0.013224, -0.015281, -1.505398, -2.005133, 0.853758, -0.002085, 0.363445, -0.005922, -0.005862, 0.391547, -4.668581, -0.002356, 5.667678, 1.559703, -0.138644, -0.473645, 
	-0.028028, -0.009172, -0.764892, 0.063634, 0.386788, -0.003413, -4.899077, -0.013700, -0.006483, -1.990876, 1.033589, -0.003551, 1.987457, 1.079084, 3.272957, -0.104315, 
	-0.006904, -0.008021, -0.445071, 1.004594, -2.414365, -0.002756, 1.865742, -0.011532, -0.005826, 1.018746, 1.437988, -0.002915, -3.029651, -1.152310, 1.850887, -0.098607, 
	-0.029471, -0.009808, -0.690179, -1.878132, -0.859639, -0.003301, 0.203897, -0.013556, -0.007095, -0.618364, -4.568030, -0.003514, 2.164137, -1.879601, 8.394637, -0.201981, 
	-0.007825, -0.005055, 2.027367, -1.891170, -1.886218, -0.002581, 1.366945, -0.006932, -0.003865, 2.213710, -4.203777, -0.002645, 2.589796, 0.059489, -0.209215, -0.038024, 
	-0.402358, 1.325064, 0.803340, 2.383852, 1.600802, -0.026492, -2.341160, -0.161819, -0.060623, -4.363050, 0.232132, -0.028104, 0.089217, 0.722523, 0.301858, -0.075180, 
	-0.049098, -0.011906, -0.776318, 0.497900, -3.118966, -0.004795, 5.304264, -0.028665, -0.000887, 0.271351, 1.837781, -0.005357, -2.671199, -0.297934, -0.653630, -0.292544, 
	-0.007058, -0.008864, -0.406637, 1.130955, 0.792489, -0.000837, -3.270169, -0.003832, -0.003137, -0.567479, 3.449182, -0.001006, 2.752143, -1.295928, -2.359888, -0.199935, 
	-0.032563, -0.009241, 1.337045, 1.375278, 2.028973, -0.003856, 0.732541, -0.055904, -0.009595, -1.324685, -4.059138, -0.004230, 1.038593, -0.547796, -0.301675, -0.163747, 
	-0.028463, -6.358132, 1.888639, -2.822642, 1.418133, -0.007747, 1.727961, 6.615649, -0.011237, -1.357697, 0.563190, -0.007946, -1.711988, -0.802863, 1.066798, -0.171653, 
	-0.004922, -0.001123, -1.560493, 1.292983, -0.238120, -0.000521, -0.242719, -0.001319, -0.000896, 1.731619, -0.036217, -0.000499, -0.013087, -0.438559, -0.472765, -0.013362, 
	-0.003768, -0.000448, -0.036178, 0.147358, 0.339258, -0.000245, -0.034793, -0.006494, -0.000570, 0.284290, -0.198095, -0.000248, -0.106905, -0.138636, -0.228339, -0.016187, 
	-0.004967, 0.186371, 1.726058, -1.317001, -1.322721, -0.001079, -0.180910, -0.067117, -0.002376, 0.250455, -4.582818, -0.001138, 6.725935, -1.072389, -0.310917, -0.025387, 
	-0.003726, -0.006108, -0.374115, -0.240261, -0.040598, -0.001456, 4.083903, -0.002578, -0.002260, 0.825751, -1.998814, -0.001537, -0.882669, -0.439884, -0.904483, -0.011166, 
	-0.003168, -0.002635, -1.022687, 0.366033, -0.959305, -0.000586, 1.856579, -0.002375, -0.001362, 0.117785, -4.906247, -0.000629, 3.177247, 0.572475, 0.933340, -0.124463, 
	-0.015194, -0.009765, -2.040593, -3.261390, 1.469647, -0.002655, -4.397056, -0.010468, -0.006199, 3.398328, 1.712212, -0.002825, 0.157038, 4.285198, -1.225352, -0.050925, 
	-0.009327, -0.004481, -0.408280, 2.735075, -0.063733, -0.001576, 0.593466, -0.004444, -0.002911, -2.220905, -1.182591, -0.001638, 0.340292, -0.324359, 0.601658, -0.046246, 
	-0.004571, -0.002241, -0.143556, 0.893501, 2.437782, -0.000706, -0.450830, -0.001671, -0.001200, 0.324492, -0.175294, -0.000725, -2.714415, -0.067533, -0.080536, -0.012498, 
	-0.047792, 0.058685, 1.109039, -3.129399, -5.058412, -0.006970, 9.233962, -0.029799, -0.014405, 4.353290, 1.253318, -0.011579, -6.005741, -0.839913, -0.712668, -0.151617, 
	-0.065651, -0.018935, -1.176856, -2.159294, -1.160067, -0.005279, 0.820160, -0.020419, -0.011000, 4.997625, -6.764844, -0.005519, 6.374832, -1.410298, 0.773818, -0.168273, 
	-0.029522, -0.023364, -2.322267, 1.017098, 0.160267, -0.007265, -2.293152, -0.043918, -0.015836, -0.172846, -1.528644, -0.007603, -2.735079, 8.860487, -0.405485, -0.452870, 
	-0.052320, -0.015475, -3.160502, 1.022308, -3.184775, -0.002991, -0.123876, -0.017746, -0.007234, 3.798563, 0.035607, -0.003154, 3.102434, -2.291378, 1.075769, -0.175230, 
	1.561570, 0.555664, 0.530259, 2.486240, 1.838108, -0.453957, -3.454490, -1.885013, -0.886733, -0.763497, -2.161980, -1.040669, -0.608216, -0.430183, -1.215126, 5.928022, 
	-0.021711, -0.006334, 1.145748, -1.530888, -0.512100, -0.002347, 1.062759, -0.015936, -0.004786, -1.963929, -2.587034, -0.002466, 2.744409, -0.367316, 0.781348, 1.280584, 
	-0.007347, -0.004578, -0.589207, 0.768130, 1.498314, -0.002263, 1.295991, -0.005815, -0.003609, -0.020299, -1.854492, -0.002358, 0.807598, -0.239755, -1.597994, -0.042316, 
	-0.011805, -0.016583, -1.851453, -1.745314, 2.432391, -0.002092, -0.313547, -0.015271, -0.006609, -1.039558, 1.915270, -0.002372, -0.629905, -0.352036, 1.708313, -0.069431, 
	-0.001956, 0.391062, -0.783897, -0.802338, 0.663457, -0.000597, -0.438033, -0.014003, -0.001134, 0.427518, -0.086086, -0.000617, -0.424625, 0.865688, 0.214811, -0.009250, 
	-0.013422, -0.010065, 0.240856, 1.346979, -1.008036, -0.003105, -3.909192, -0.013539, -0.006320, 2.332697, 4.448851, -0.132643, -1.173978, -1.599313, -0.451252, -0.048519, 
	-0.031387, 0.060936, 0.477959, -4.441025, -0.247534, -0.006520, 8.127816, -0.045321, -0.013236, -1.843898, -4.225527, -0.006714, 0.914446, 2.181950, -0.313026, -0.588919, 
	-0.003102, -0.003351, 1.348090, -1.574672, -0.173744, -0.002016, -0.174611, -0.003875, -0.002736, 2.050130, 0.591168, -0.002230, -1.096538, -0.454582, -0.445108, -0.052824, 
	-0.046645, 0.000293, 0.055970, 3.908192, -0.447160, -0.007929, 0.347441, -0.053534, -0.017508, -1.531434, 2.425252, -0.012741, 1.162660, -4.213095, -1.066809, -0.502953, 
	-0.016568, -0.020091, -1.114419, 3.084433, 4.501238, -0.005949, -3.785402, -0.070204, 0.269339, -2.444510, -0.201411, -0.006219, 0.837864, 1.822432, -2.477945, -0.372589, 
	2.218462, -0.033667, -3.978301, -2.507084, -3.683512, -0.015823, -4.240693, -0.065808, 0.261813, 7.373642, 1.288460, -0.016302, 3.642941, -3.335002, 0.383160, 2.707715, 
	-0.105988, -0.024324, 0.861236, -0.057702, -1.398841, -0.006490, -0.968470, -0.065275, -0.014872, 3.357151, 2.970388, -0.006926, -3.847679, 0.246927, -0.614256, -0.324879, 
	-0.019989, -0.005459, 0.609641, 0.555300, 0.599012, -0.001856, -2.749215, -0.009054, -0.003282, -0.282678, 0.426076, -0.001975, 1.748946, -0.632428, -0.242863, 0.009824, 
	-0.046156, -0.002998, -0.108005, -0.098157, 2.992481, -0.000666, -0.914415, -0.003391, -0.001634, -0.086434, -1.925005, -0.000710, 0.425109, -0.276398, 0.080528, -0.034148, 
	-0.013683, -0.008242, 2.317329, 2.195130, 1.574700, -0.002295, -6.396953, -0.030395, -0.006648, -2.066727, 5.563097, -0.002554, -4.099679, -0.073683, 1.282101, -0.231498, 
	-0.004607, 0.615032, 1.349339, 0.242559, -0.025125, -0.002491, -0.519222, -0.426139, -0.004685, -1.086815, -0.475762, -0.002525, 0.164649, -0.360039, 0.644270, -0.108438, 
	-0.056794, -0.033195, -4.061988, -3.386705, 10.998865, -0.008597, -3.373535, -0.058114, -0.020393, 0.758582, -1.430731, -0.009106, 3.652075, -3.272405, 0.834379, -0.532339, 
	-0.005624, -0.003627, 0.271927, 0.474481, -0.155936, -0.001712, -1.194878, -0.004001, -0.002761, -0.456749, -0.224869, -0.001695, 0.733760, 0.001480, 0.586235, -0.016030, 
	-0.023108, -0.005647, -0.123388, 0.725336, 0.948255, -0.002365, 0.295937, -0.013035, -0.004558, 1.056466, -1.218954, -0.002495, 1.201143, -1.266902, -1.287126, -0.279558, 
	-0.003118, -0.002204, 1.245326, -0.671551, -1.107035, -0.000853, 2.758633, -0.004517, -0.001698, -0.716533, 0.002529, -0.000891, -1.832959, 0.391876, -0.017962, -0.039042, 
	-0.004705, -0.004054, -0.132526, -1.587461, 0.330497, -0.000670, -5.386337, -0.005271, -0.002197, -1.198982, 7.785240, -0.000734, 1.525161, -0.431050, -0.846941, -0.039970, 
	-0.007536, -0.004332, -0.219375, -1.616143, -2.269094, -0.001294, 1.783163, -0.010974, -0.003472, 0.365425, -0.483464, -0.001356, 2.486121, -0.709004, 1.166895, -0.475560, 
	-0.000758, -0.000632, -1.264173, -0.088484, -0.010599, -0.000431, -0.102769, -0.000765, -0.000583, 1.336408, -0.033183, -0.000431, 0.051640, 0.026501, 0.093538, -0.005277, 
	-0.126130, -0.027230, 1.499920, 2.206635, -8.821818, -0.003928, -1.535195, -0.020190, -0.011946, 0.317493, 1.757944, -0.004547, 5.125767, 0.478820, -0.748180, -0.087414, 
	-0.077500, -0.043368, 0.546852, 1.111364, -0.765099, -0.006654, -1.418062, -0.046308, -0.020868, -1.957750, 0.830871, -0.006937, 0.420592, 2.409385, -0.383030, -0.593488, 
	-0.012535, -0.006308, -0.261061, 4.713111, 5.455806, -0.002422, -2.481237, -0.010668, -0.004542, -3.589159, 0.461850, -0.002613, -3.633137, -0.884300, 0.340220, -0.083005, 
	-0.056987, -0.018457, -2.927084, -0.198392, 1.748115, -0.004763, -0.463174, -0.030172, -0.013217, 0.489479, 1.254519, -0.005076, -0.120368, 1.765894, -1.264759, -0.155559, 
	-0.004614, -0.003857, -0.396503, 0.107011, -0.689662, -0.000826, -1.896379, -0.007892, -0.001905, 1.170861, 0.170700, -0.000891, 1.592543, -0.234260, 0.212855, -0.017180, 
	-0.005968, -0.003229, -0.360002, -0.154374, 0.349937, -0.000916, -0.669651, -0.003895, -0.002034, 0.342756, -0.439741, -0.000964, 0.645371, -0.810262, 1.142159, -0.029188, 
	-0.002962, -0.002213, -0.799160, 4.239367, -0.137019, -0.001064, 0.333684, -0.002697, -0.001585, -0.519060, -0.593763, -0.001078, -1.722166, -0.662051, -0.080259, -0.047973, 
	-0.019360, -0.010957, -0.658937, -0.208058, -1.661433, -0.002771, 3.409975, -0.012570, -0.006382, -0.596014, -2.730549, -0.003069, 1.959442, 1.057557, -0.441609, -0.075268, 
	2.413208, -0.009520, 1.946411, -0.032458, -0.622038, -0.004093, -3.043852, -0.025470, -0.011745, -2.029471, 4.619662, -0.004627, -0.568654, 0.943248, -3.264088, -0.306514, 
	-0.006580, -0.004256, -1.441128, -0.744099, -0.915751, -0.001168, -1.967637, -0.005002, -0.002475, 1.179920, 0.411754, -0.001229, 3.905097, -0.173660, -0.060092, -0.173693, 
	-0.004485, -0.002265, -0.163032, -0.635663, -0.347349, -0.000325, -0.365782, -0.001533, -0.001009, -0.148663, -0.216746, -0.000380, 1.419656, 0.776329, -0.204332, -0.104420, 
	-0.010753, -0.006265, -0.018741, 0.096518, 3.503489, -0.001075, -0.390662, -0.016401, -0.004106, -1.117690, -0.657648, -0.001291, -0.551574, -1.361227, 0.664408, -0.126982, 
	-0.102441, -0.017006, 1.383481, -2.238011, 3.695745, -0.004702, -0.416078, -0.037140, -0.010160, 2.935871, -4.400176, -0.004975, 1.684593, -1.819495, -0.350786, -0.298721, 
	-0.007152, -0.003909, 0.432033, 0.945166, -0.470094, -0.000660, -2.343536, -0.005767, -0.002131, 0.192756, 1.135611, -0.000736, -1.921049, 2.312712, -0.238053, -0.025191, 
	-0.002264, -0.002636, 2.856885, -0.430795, -0.337656, -0.000602, -0.255748, -0.004523, -0.001673, 0.120965, -0.176607, -0.000667, -0.171356, -0.619561, -0.957971, -0.015790, 
	-0.011131, -0.011434, 0.925338, -2.328969, -0.135073, -0.001676, -1.504025, -0.006509, -0.003860, -0.187995, 2.777817, -0.001942, -1.754615, 2.863732, -0.430680, -0.188978, 
	-0.013288, -0.006097, -1.474347, 5.013376, -1.342659, -0.002114, 3.289769, -0.007150, -0.003930, -1.680332, -1.086241, -0.002185, -3.528778, 1.240402, -0.288444, -0.107984, 
	-0.011087, -0.017153, 2.521009, -2.808696, 4.346606, -0.001653, -0.529417, -0.013595, -0.006425, 3.920039, -1.410355, -0.002034, 1.025278, -4.027253, -2.191217, -0.794045, 
	-0.088992, -0.031885, -0.582090, -1.353412, 0.564234, -0.031170, -4.341477, -0.057809, -0.026431, 9.773581, -0.289901, -0.031424, 0.749809, -4.343493, -3.150346, 3.240807, 
	-0.035584, -0.010499, 4.243036, -2.236677, -0.940817, -0.003274, -0.698452, -0.113789, -0.011030, 0.067480, 1.426894, -0.006829, -0.672729, -0.581432, -0.333521, -0.092778, 
	-0.020547, -0.005401, -0.499466, 0.017698, 1.241927, -0.002372, -0.137902, -0.009750, -0.003967, 1.993641, -1.965119, -0.002422, -0.221405, -0.060221, -0.254676, -0.070018, 
	-0.074104, -0.021986, -1.853110, 1.347106, 1.618160, -0.006212, 2.074714, -0.039065, -0.015531, -0.562811, 3.726595, -0.011215, -3.491419, -1.569572, -0.656905, -0.464647, 
	-0.046269, -0.038976, -3.079919, 2.195452, 14.158172, -0.003021, -4.065167, -0.059366, -0.020772, -1.885274, -2.247016, -0.007901, -1.799520, -0.980743, -1.817861, -0.301818, 
	-0.129680, 0.172550, 2.417623, -1.326397, -3.986738, -0.018956, -2.224154, -0.163843, -0.040292, 4.730799, -0.653005, -0.019560, 0.731697, 0.409258, -0.218295, 0.318992, 
	-1.028302, 1.291741, 3.691647, -2.760314, 4.993933, -0.091529, -1.731969, -0.792987, -0.253854, -0.156828, 2.579411, -0.110095, 0.070458, 0.536681, -4.132596, -2.105397, 
	-0.212782, 0.350764, 1.684379, -1.395004, 0.960247, -0.005647, 2.787111, -0.224974, -0.013676, -3.006036, -1.807080, -0.005892, 0.118950, 2.250970, -1.145188, -0.336142, 
	-0.007298, -0.011824, -1.475552, -0.256816, -0.118809, -0.001620, -1.261585, -0.033753, -0.006250, 0.766025, 2.075248, -0.001985, 1.937766, -1.061738, -0.552285, 0.010475, 
	-0.056029, -0.017929, -0.437770, -4.790133, 1.146640, -0.006249, 0.410311, -0.074116, -0.013540, 1.418283, -5.439179, -0.006529, 2.175335, 1.801099, 0.638915, 3.250892, 
	-0.082190, 0.810771, 0.216974, 1.323897, -1.003929, -0.012298, 4.022846, -0.083497, -0.027473, 1.863536, -2.479815, -0.013166, -4.743776, -0.822752, 1.368443, -0.337571, 
	-0.007588, -0.001332, -0.275441, -0.471504, -0.652484, -0.000338, 1.034945, -0.002278, -0.000876, -0.234583, -3.047845, -0.000368, 2.470366, 0.002460, 1.195938, -0.009072, 
	-0.067603, -0.018693, -3.604931, -2.607921, 0.367096, -0.010592, 2.705445, -0.072768, -0.020487, 0.512293, 1.150551, -0.011198, 2.423883, 1.949017, -3.372757, 0.678663, 
	-0.013791, -3.678925, -2.610105, 0.525908, 0.130489, -0.003865, 2.392003, 3.788429, -0.006400, -1.210397, -1.819048, -0.003897, 0.446973, -0.535474, 2.800107, -0.202008, 
	-0.009850, -0.007093, -0.874995, -0.002857, -3.108428, -0.002275, 4.832059, -0.012953, -0.005158, 0.549369, -1.395867, -0.002281, -1.573455, 3.249335, -1.599389, -0.036161, 
	-0.012094, -0.006971, 1.553751, 0.366948, -1.527748, -0.002243, -0.930162, -0.033324, -0.006872, -0.120140, 3.040780, 0.021945, -1.889339, -0.160087, -0.428600, 0.134157, 
	-0.009191, -0.002260, -1.374207, -1.002872, 0.475627, -0.000847, 3.919303, -0.004149, -0.001828, 0.998714, 0.229454, -0.000907, -3.149727, -0.563103, 0.499670, -0.013678, 
	-0.010974, -0.000970, -0.012240, -0.026028, -0.670811, -0.000343, 0.594248, -0.001250, -0.000764, -0.146810, -0.159855, -0.000363, 0.300875, -0.755158, 0.894459, -0.004015, 
	-0.076808, -0.017854, -2.292209, 1.454702, 0.510010, -0.005007, -2.647785, -0.038714, -0.012073, 2.461087, -2.624992, -0.005322, -0.198608, 1.048291, 0.984103, 1.461180, 
	-0.005940, -0.005447, -1.692557, 2.908102, 0.701220, -0.001845, -1.322693, -0.006272, -0.003441, -1.251662, -0.919927, -0.001798, 1.366024, 0.913582, -0.631506, -0.045839, 
	-0.007260, -0.004210, -0.864086, -1.768051, 1.102579, -0.001722, 0.513817, -0.004133, -0.002745, 2.538774, -1.250758, -0.001772, -0.990796, 0.269058, 0.470346, 0.000957, 
	-0.016427, -0.006108, -0.434595, 1.645622, -0.223824, -0.001681, 2.412754, -0.008851, -0.004063, 0.541071, -3.259482, -0.001678, -1.177141, -0.467717, 1.073272, -0.071150, 
	-0.006727, -0.005701, -0.349468, 0.204029, 2.119478, -0.000977, -0.744948, -0.003600, -0.003174, 0.827468, 1.856779, -0.001226, -0.692574, -2.290216, -0.870697, -0.038447, 
	-0.004083, -0.003829, -2.010978, 0.229327, 2.428751, -0.000662, 0.423186, -0.010479, -0.002255, 0.384299, 0.689374, -0.000750, -2.879552, -0.193068, 0.993274, -0.042555, 
	-0.012599, -0.006031, 2.216465, -0.717296, 1.571597, -0.001374, 2.886033, -0.011925, -0.003601, -2.293333, -3.102638, -0.001659, -0.688674, 0.452691, -0.267195, -0.020461, 
	-0.231860, -0.101370, 2.562825, 1.731173, 4.233981, -0.032432, -1.609888, -0.174227, -0.068512, -1.443224, -4.691312, -0.034379, -2.419760, -1.650245, 0.736056, 3.193175, 
	-0.042237, -0.007660, -1.926599, 0.887011, -0.380428, -0.002151, -0.795832, -0.008719, -0.004775, 0.137155, -3.691005, -0.002273, 4.043503, 3.162103, -1.220719, -0.147373, 
	-0.029186, -0.015558, 1.523578, 3.677736, -2.514502, -0.002594, 1.691265, -0.022371, -0.008971, -0.092640, 2.265508, -0.002905, -0.312635, -2.673297, -2.515607, -0.967823, 
	-0.004784, -0.003206, -0.003606, 0.030610, 3.870222, -0.001193, -2.810583, -0.003453, -0.002095, -0.674752, -1.947832, -0.130647, 1.121495, -0.201961, 0.827604, -0.065819, 
	-0.010822, -0.004194, 1.182723, 1.375282, 0.466220, -0.001521, -2.384068, -0.017043, -0.003639, -0.507279, 0.108777, -0.001688, 2.289301, -1.006133, -1.433598, -0.052318, 
	-0.030913, -0.007605, -0.814111, 0.003749, 1.903126, -0.002507, 1.861722, -0.011551, -0.006015, -0.455218, -0.560600, -0.132078, -2.071312, -0.707236, 1.159683, -0.129135, 
	-0.371766, -0.116174, -1.274459, -7.805659, 5.197921, -0.051484, -4.083297, -0.185066, -0.076247, -0.030455, 7.063070, -0.074827, -3.987313, -1.991517, 5.389142, 2.398132, 
	-0.244188, -0.079281, 3.130617, 0.635265, -1.116926, -0.033534, -1.292898, -0.085707, -0.059805, -5.281857, 2.122015, -0.043414, 7.038991, 1.301472, -5.357651, -0.633102, 
	-0.009761, -0.012760, -0.267155, 1.044355, -1.168294, -0.003365, 2.048096, -0.025655, -0.007990, -0.513334, -0.598957, -0.003601, -1.229612, 2.206611, -1.366585, -0.091992, 
	-0.001003, -0.000429, -0.169008, 0.312779, -0.149020, -0.000164, 0.234680, -0.000580, -0.000279, -0.029518, 3.817401, -0.000170, -3.937798, -0.015689, -0.059014, -0.002187, 
	-0.005205, -0.005598, 1.912615, -0.794922, 0.431588, -0.001192, -1.052336, -0.008217, -0.003351, 0.743924, 0.373984, -0.001313, -0.433948, -0.577510, -0.565911, -0.012608, 
	-0.033889, 0.158770, -1.871801, 0.698593, -0.712952, -0.010160, 0.271708, -0.090860, -0.017498, 0.749261, 0.786200, -0.010685, 2.992312, -2.258939, -0.588278, -0.061782, 
	-0.011307, -0.007068, 0.824585, -0.101026, 0.652119, -0.001573, -0.868849, -0.010683, -0.004350, 0.614861, -0.882108, -0.001719, -1.202305, 0.981879, 0.118665, -0.101124, 
	-0.003403, -0.001371, 0.423695, -1.095744, 1.614534, -0.000376, -1.552000, -0.001065, -0.000761, 0.598496, -0.644710, -0.000385, 0.900290, -0.072678, -0.124411, -0.040110, 
	-0.024791, -0.008519, -0.199004, -1.633162, 3.346867, -0.001408, 2.285850, -0.008151, -0.003834, -0.453274, 0.568797, -0.001485, -0.687602, -1.266142, -1.842510, -0.071631, 
	-0.010223, -0.006386, -0.280326, 2.585678, -1.142405, -0.002887, -2.579300, -0.010741, -0.005557, -0.204969, -2.416386, -0.002991, 3.179946, -0.268254, 1.195774, -0.030973, 
	-0.005658, -0.003574, -1.107660, 4.223661, -0.917035, -0.001261, -1.614156, -0.020214, -0.003477, 0.061145, -1.842821, -0.130733, 0.291094, -0.015017, 1.165460, -0.079756, 
	-0.063267, -0.024807, -1.718806, 3.553031, -5.152461, -0.010341, -2.121086, -0.060518, -0.019687, -0.503529, 3.568300, -0.010933, 6.510196, -3.541296, -0.169317, -0.235481, 
	-0.002303, -0.001891, -0.566251, 4.890072, -0.295055, -0.000897, 0.143049, -0.002603, -0.001366, -2.466424, 1.478791, -0.000903, -2.619922, -0.131535, -0.408416, -0.014347, 
	-0.005156, -0.004199, -0.113931, 0.892503, -0.523104, -0.002996, -2.062107, -0.003717, -0.003406, -0.671925, -6.116185, -0.003034, 6.864390, -0.135128, 1.990442, -0.102447, 
	-0.013951, -0.015977, 1.972466, -2.708152, -0.107628, -0.002965, 1.483098, -0.027736, -0.008748, -0.172884, 0.216076, -0.003099, 1.225891, -1.375810, -0.560849, 0.100267, 
	-0.009338, 0.359365, 1.208191, -0.030187, -1.919374, -0.001285, 2.406454, -0.359421, -0.002745, -0.870466, -2.424846, -0.001358, 1.772193, 0.032416, -0.134175, -0.025425, 
	-0.038844, -0.015179, -0.119710, 3.315120, 2.596308, -0.004144, 1.017128, -0.019075, -0.009415, 1.020829, -0.800427, -0.002542, -4.146920, -2.452060, -0.475515, 0.134445, 
	-0.067533, 1.273215, 0.862494, -0.286163, -2.707413, -0.003794, -2.431229, -1.037554, -0.005645, -1.408668, 3.575201, -0.003889, 1.709512, -0.038293, 0.612384, -0.042624, 
	-0.002079, 0.016829, -0.244798, 1.409796, -0.358539, -0.000583, 0.120035, -0.017712, -0.001124, -0.985135, -0.285282, -0.000595, 0.095356, 1.078700, -0.811671, -0.013198, 
	-0.009452, -0.014369, -0.382658, -1.607086, -0.417459, -0.001274, -1.519540, -0.013959, -0.004891, -0.463042, 0.945164, -0.001515, 6.506866, -0.604488, -2.294457, -0.117841, 
	-0.023463, 1.118245, 0.789904, -1.352417, -0.889529, -0.003177, 1.801536, -1.036733, -0.004647, 3.206897, -3.433479, -0.003229, 1.817235, -1.962229, 0.088982, -0.113897, 
	-0.013512, -0.002436, -0.422553, 0.117100, -0.440322, -0.000747, 0.991193, -0.003152, -0.001717, 0.518140, -4.769513, -0.000803, 2.694793, 0.029498, 1.447547, -0.143514, 
	-0.076248, -0.040466, 3.164628, 1.616041, -5.436718, -0.018016, -2.327432, -0.058321, -0.027903, 5.815374, -5.437677, -0.019274, -3.335407, 6.863898, -0.977967, 0.295487, 
	-0.121371, -0.020466, 0.368922, -0.338057, -0.575647, -0.002692, 3.489388, -0.045358, -0.011314, -2.250924, 1.315729, -0.003254, -0.346490, -1.257546, -0.125106, -0.075814, 
	-0.085299, -0.022008, -2.980250, 1.568800, -1.164437, -0.006610, 2.063310, -0.036606, -0.012589, -2.377130, -0.191006, -0.007050, -4.296140, -0.527434, 8.152696, -0.078247, 
	-0.005349, -0.002237, 0.190467, -0.136832, 1.072616, -0.000558, -2.389405, -0.002246, -0.001298, -0.267153, 0.672199, -0.000654, 0.455681, -0.112991, 0.389370, 0.138390, 
	-0.002828, -0.002716, 0.269569, -0.124834, -0.127770, -0.000604, -0.891149, -0.004741, -0.001654, 1.895694, -0.383383, -0.000664, 0.280147, -1.608708, 0.718982, -0.015342, 
	-0.035224, -0.050749, 1.281388, 2.077210, -5.791506, -0.005090, -0.925108, -0.071325, -0.021312, 2.602844, 1.981578, -0.006271, -3.599582, 2.865287, -1.372173, 1.070033, 
	-0.011099, -0.004706, -0.459957, 0.869243, 0.945362, -0.001680, -4.924870, -0.004112, -0.003075, -0.591332, 6.050485, -0.001957, -0.928412, -0.194803, -0.712120, -0.026967, 
	-0.005651, -0.003865, 0.311937, -0.632879, 0.512788, -0.003328, 0.484864, -0.007025, -0.003136, 1.251876, -2.941864, -0.003394, 1.121589, -1.080639, -0.201708, 1.200436, 
	-0.009536, -0.004017, -0.054921, -0.537443, -0.815888, -0.001728, 0.315842, -0.003778, -0.002905, 0.381300, 3.044525, -0.001667, -3.453440, -0.091709, 1.268310, -0.032945, 
	-0.005419, -0.003406, -0.628977, -0.234812, -1.040834, -0.001042, -1.205445, -0.009090, -0.002843, -0.386954, 1.624885, -0.001115, 2.520334, -1.159960, 0.560163, -0.025487, 
	-0.023279, -0.016554, -1.703171, 5.543972, -1.173205, -0.004419, -1.700835, -0.019958, -0.009654, -2.853920, 2.827194, -0.134189, 0.868226, -1.712258, 0.303576, -0.191525, 
	-0.018492, -0.003474, -1.463763, 0.582021, -0.281636, -0.000870, 0.982383, -0.003762, -0.002269, -0.757369, 0.099214, -0.000970, 0.038380, 1.235440, -0.392551, -0.012282, 
	-0.436935, -0.068289, -3.180307, 4.287580, 2.686004, -0.021611, 1.577354, -0.096586, -0.044973, -2.983187, 4.158647, -0.161087, 1.313650, -3.209797, -3.245661, -0.574799, 
	-0.012631, -0.003843, -0.187187, 0.196430, -1.388990, -0.001095, -3.793532, -0.022983, -0.002978, 1.093516, 2.970634, -0.001177, 1.068377, 0.309789, -0.201400, -0.022930, 
	-0.002315, -0.007499, 2.219326, -1.298931, -0.717650, -0.000647, -0.164383, -0.002834, -0.001673, 0.221025, 5.590565, -0.000696, -5.355728, 0.347595, -0.795309, -0.030846, 
	-0.003468, -0.004834, -0.250556, -0.777460, -0.383365, -0.000538, 0.306170, -0.002979, -0.001505, 0.180967, 0.826207, -0.000609, 0.075863, -0.318714, 0.356712, -0.001894, 
	-0.390026, -0.136538, 6.101453, -6.910125, -3.207686, -0.028222, 1.338260, -0.131734, -0.067652, -0.764048, 3.301018, -0.029875, 3.599965, 2.930642, -3.819370, -1.786061, 
	-0.082343, -0.011140, 0.663997, -0.894973, -2.391320, -0.001686, -0.676384, -0.010105, -0.004944, 2.573590, -1.975885, -0.001952, 2.749221, 0.215524, -0.057650, -0.093951, 
	-0.082889, -0.031126, -1.522856, -0.566668, 2.627306, -0.004624, -4.073881, -0.030682, -0.013654, 0.708420, -1.558108, -0.005066, 5.054173, 0.238212, -0.251038, -0.487518, 
	-0.015670, -0.011588, 0.300793, 0.650258, 4.342376, -0.002917, -4.895406, -0.014763, -0.007659, -2.902079, 5.802073, -0.003065, -3.756782, -1.426167, 2.061617, -0.121019, 
	-0.001249, -0.000762, -0.088403, -0.022068, -0.708742, -0.000272, -0.136340, -0.001055, -0.000530, -0.073529, 0.340895, -0.000287, 0.678989, 0.062500, -0.024579, -0.024569, 
	-0.028090, -0.010449, -1.292938, -1.004644, 2.376535, -0.002724, 1.556594, -0.015677, -0.006260, -1.115211, 3.107665, -0.002823, -1.996210, -0.046296, -1.401408, -0.118063, 
	-0.023896, -0.011826, -0.951485, 7.085692, -3.987803, -0.004954, -4.778561, -0.015625, -0.009240, -4.684347, 4.597850, -0.005069, 5.746812, -0.919048, -1.770468, -0.268032, 
	-0.019297, 0.629265, -1.201766, -1.977768, -2.846466, -0.002888, 3.412284, -0.605705, -0.005609, 3.904485, 0.727489, -0.002979, 0.322325, -1.265464, -0.881996, -0.185910, 
	-0.097618, -0.051669, -1.988649, -2.450414, 12.688957, -0.012864, -4.032828, -0.111128, -0.033227, -4.570569, 4.954373, -0.016489, -4.020101, 0.854174, -0.395630, -0.716318, 
	-0.089959, -0.039430, 0.719397, 1.804321, 0.436532, -0.016846, -1.679133, -0.049646, -0.028314, -1.313753, -2.989050, -0.017452, 5.347704, -0.586724, -0.835010, -0.662636, 
	-0.042569, -0.010805, -0.087479, -1.854101, -1.604660, -0.002412, -0.601337, -0.009715, -0.005880, -1.240202, 4.212679, -0.002543, -1.170564, 1.784247, 0.730971, -0.095629, 
	-0.006253, -0.001825, 0.281784, -0.376287, -0.567351, -0.000631, 5.124764, -0.005352, -0.001431, 0.326804, -0.640580, -0.000660, -3.124957, -0.781289, -0.172873, -0.053864, 
	-0.007842, -0.002233, -0.532129, 0.417909, -0.735761, -0.000721, 1.918023, -0.002455, -0.001530, -0.497400, 0.090309, -0.000739, -0.322554, -0.257873, -0.005636, -0.059370, 
	-0.023855, -0.011113, -1.717101, -2.459321, 0.913473, -0.002685, 4.589130, -0.030675, -0.007453, 0.788946, -0.060191, -0.002888, -1.517379, 0.187698, -0.538896, -0.107690, 
	-0.184811, -0.026622, -2.928326, 2.415440, -3.516787, -0.010873, 2.165067, -0.071261, -0.022122, 5.894410, 3.022986, -0.013656, -1.514691, -3.640611, -1.321778, -0.246365, 
	-0.012910, -0.008487, 1.633307, -0.509315, 2.184088, -0.001130, -1.585722, -0.006661, -0.003628, -3.196204, -0.656691, -0.001375, 1.701374, 0.224756, 0.324090, -0.085491, 
	-0.004835, -0.001647, -0.178725, 1.910949, 0.872286, -0.000547, -0.719617, -0.001786, -0.001083, -2.282793, -0.480393, -0.000546, -1.151596, 1.112067, 0.957645, -0.029381, 
	-0.025626, -0.017312, -0.137040, 1.924893, 3.983378, -0.005765, 8.844090, -0.017576, -0.010713, 0.566871, -10.610746, -0.006046, -3.453819, 0.689646, -1.540975, -0.183257, 
	-0.003965, -0.000695, -0.202503, 0.283188, -0.933371, -0.000270, 1.032821, -0.000791, -0.000506, -0.683746, -0.147215, -0.000277, 0.684699, -0.714853, 0.701100, -0.013616, 
	-0.012067, -0.004295, -1.038132, -3.341014, 1.278263, -0.001450, -0.244926, -0.017491, -0.003958, 0.399948, 4.610643, -0.001431, -1.402790, -0.877426, 0.694628, -0.038502, 
	-0.013857, -0.007146, -1.107931, -1.263087, 0.336688, -0.001095, 1.683050, -0.004823, -0.003188, -0.367597, -0.310469, -0.001122, -2.682062, 2.584776, 1.247953, -0.090089, 
	-0.036295, -0.013000, 1.155019, 0.295758, 4.121116, -0.002265, -2.692222, -0.007692, -0.005374, -2.174376, -0.981472, -0.002372, -0.869800, 0.832708, 0.505471, -0.125205, 
	-0.005512, -0.004526, 2.603748, -0.108442, 1.247244, -0.000869, 2.906359, -0.004901, -0.002320, -1.410370, -1.399844, -0.000945, -2.915057, -0.438339, -0.404665, -0.061560, 
	-0.014368, -0.020084, -0.696950, -0.127588, -0.418574, -0.000726, 0.510613, -0.005745, -0.003566, 3.993230, -0.857649, -0.000999, -0.541907, -1.319801, -0.468009, -0.027877, 
	-0.024902, -0.022059, 2.095050, -3.699312, 4.938421, -0.008545, -1.316368, -0.029603, -0.016271, 0.494199, 0.543140, -0.009434, -1.504070, -0.530364, -0.591520, -0.318363, 
	-0.028452, -0.009800, 0.094153, 1.031166, -1.317083, -0.001519, -1.954706, -0.007223, -0.003752, -0.231200, 1.742353, -0.001638, -1.332449, 2.857885, -0.721399, -0.116336, 
	-0.005454, -0.004529, 2.041416, -1.004958, -0.714478, -0.000678, 1.444033, -0.002330, -0.001674, -0.759899, -0.731709, -0.000738, -1.122660, 0.054787, 0.846546, -0.037673, 
	-0.089803, -0.027993, -0.980744, -2.715948, 1.604002, -0.009757, -0.254670, -0.057922, 0.051333, 0.678449, 6.238484, -0.014497, 0.465565, -3.939724, -0.739874, -0.206899, 
	-0.071051, 0.341382, -3.165802, 5.470580, -5.363541, -0.011310, -0.199319, -0.175543, -0.028891, 13.898664, -2.365824, -0.015486, -3.564990, -6.220638, 2.921274, -1.449505, 
	-0.071204, -0.008744, 4.757829, -1.169075, -2.201194, -0.003214, 8.002006, -0.010680, -0.005957, -0.964325, -8.393195, -0.003352, 1.343451, -2.131358, 0.932694, -0.073681, 
	-0.321850, -0.079046, 0.641272, 3.328571, -3.404599, -0.024081, 6.389848, -0.114809, -0.052648, 5.061983, 8.897548, -0.026072, -7.832911, -5.824110, -7.680513, 1.041416, 
	-0.008247, -0.005124, -0.356023, 3.869457, -1.920703, -0.001754, -3.546545, -0.006071, -0.003125, 2.152933, -1.274034, -0.006197, -0.131538, -0.987603, 2.283244, -0.058670, 
	-0.038271, -0.032413, 1.910024, 1.604947, 2.737599, -0.008969, 4.402970, -0.058280, -0.019485, -2.582848, -2.919132, -0.010093, -5.650251, -0.924477, 1.976830, -0.388150, 
	-0.006331, -0.001948, -0.400218, 0.190959, -0.317417, -0.000534, 1.154508, -0.004639, -0.001318, -0.351259, -1.770137, -0.000567, 0.969410, 0.889899, -0.335165, -0.015244, 
	-0.008135, -0.003410, -0.351193, 0.437315, 0.185652, -0.000509, -1.439069, -0.001085, -0.001420, -0.008766, -5.233484, -0.000535, 7.440840, -0.146104, -0.849842, -0.020254, 
	-0.017755, -0.011861, -5.163896, -1.082270, -3.453906, -0.002151, -3.903530, -0.030244, -0.007150, 0.212465, 7.376481, -0.002441, 4.680487, 2.285781, -0.769038, -0.110971, 
	-0.029201, -0.003779, 2.103883, -1.301242, 3.486995, -0.002083, -0.158676, -0.009662, -0.003188, -1.318602, -2.242782, -0.002140, -0.882769, -0.576379, 0.969043, -0.029417, 
	-0.021371, -0.014176, -1.011087, -0.748169, -1.725637, -0.004657, 1.790002, -0.011482, -0.007930, 1.492995, -2.048985, -0.005091, 5.220519, -2.215169, -0.486643, -0.203117, 
	-0.043450, -0.044029, -0.495452, 0.376173, -2.466957, -0.008314, -3.104616, -0.061353, -0.020311, 2.181142, -3.736609, -0.008813, 9.418756, -4.637547, 3.436689, -0.785310, 
	-0.002241, -0.006657, 2.230660, -2.540075, -0.103240, -0.000757, 0.005852, -0.010456, -0.003618, 0.968593, -0.111452, -0.000958, -3.068782, 2.694032, -0.027424, -0.023480, 
	-0.029378, -0.015107, 1.300660, -2.090819, -3.538240, -0.003419, 5.125470, -0.073428, -0.011387, -0.291248, 1.147070, -0.004051, -0.298374, -0.200340, -0.785274, -0.232133, 
	-0.020347, -0.016698, 0.561225, -0.865479, -1.551087, -0.007540, 5.717762, -0.021589, -0.012295, 5.878099, -4.992158, -0.007740, -0.939608, -1.929347, -1.626112, -0.167085, 
	-0.002133, -0.002065, -0.101536, -0.684814, -0.605792, -0.000581, -0.398400, -0.001327, -0.000965, -1.341716, -1.044273, -0.000567, 1.507211, -0.138377, 2.837670, -0.022336, 
	-0.008061, -0.006261, -2.859695, -0.877840, -0.663681, -0.003334, 0.598779, -0.007728, -0.004906, 4.918911, 0.933757, -0.003365, -1.113015, -1.234735, 0.446214, -0.115041, 
	-0.002319, -0.004304, -0.096429, 1.435622, -0.236820, -0.000662, -0.843198, -0.002944, -0.001845, -0.235772, 0.531215, -0.000694, -0.958364, -0.960382, 1.396736, -0.019839, 
	-0.027567, -0.010195, -2.354084, -1.350588, 3.692894, -0.002908, -2.833869, -0.008187, -0.005576, 4.949297, 0.658992, -0.003003, 0.531585, -1.191204, -1.935842, -0.109745, 
	-0.016522, -0.007357, -3.567425, 2.067717, -0.483957, -0.002411, 0.091726, -0.021312, -0.004060, -0.610274, 1.922287, -0.002491, -1.908915, 3.141564, -0.612927, 0.014359, 
	-0.022579, -0.004675, 0.781306, 0.480358, -2.231498, -0.001528, 0.890772, -0.006199, -0.003392, -0.984806, 0.733347, -0.001618, -0.252155, -0.399069, -0.538994, 1.560729, 
	-0.148852, -14.788555, -0.766755, 0.895151, 0.175192, -0.145883, -2.628608, 17.236414, -0.441133, -0.555606, 0.743104, -0.145931, 1.720538, -0.520438, -0.439542, -0.189095, 
	-0.012603, -0.007826, 1.830467, -0.699734, -0.784049, -0.002165, 2.999118, -0.015711, -0.005195, -2.491525, -1.330692, -0.002384, 2.110106, -0.858337, -0.333937, -0.395533, 
	-0.007562, -0.008753, -2.257867, 0.328795, 1.810549, -0.002363, -0.144126, -0.019462, -0.005849, 1.892871, 0.860488, -0.002588, -3.435530, -0.169028, 1.219414, -0.058988, 
	-0.007854, -0.004221, -0.525148, 0.272624, 0.391648, -0.001206, -1.370663, -0.006355, -0.002871, 0.821856, -2.607994, -0.001293, 1.153277, 2.526295, -0.618846, -0.019249, 
	-0.013156, -0.007670, 0.461357, -0.518716, 0.561602, -0.001815, 0.448003, -0.022257, -0.005202, 0.932078, -1.907672, -0.002018, 0.485268, -0.516644, -0.271965, 0.378807, 
	-0.018613, -0.009205, 6.763727, 2.250009, -1.668283, -0.004275, 2.045096, -0.016687, -0.008095, -6.372530, -2.191784, -0.004416, -3.012515, 4.638133, -2.222163, -0.168397, 
	-0.016581, -0.005075, 0.917906, -1.150385, 0.966626, -0.001452, -4.444049, -0.009653, -0.002797, 0.095266, 2.202329, -0.001501, 2.733227, -0.483849, -0.665433, -0.134577, 
	-0.056548, -0.029914, 2.004086, 2.407198, 0.820888, -0.004691, -5.263948, -0.021568, -0.012561, 1.623409, -1.852665, -0.005008, 1.246893, 0.893779, -1.460310, -0.289037, 
	-0.040813, -0.005258, -0.629532, -0.775826, -0.862168, -0.002352, -1.449153, -0.004987, -0.003428, 0.015448, 2.610512, -0.002409, -2.825698, 0.673600, 3.315740, -0.013676, 
	-0.045568, -0.002307, -1.065897, 0.495386, 0.771929, -0.001167, -0.544182, -0.002620, -0.001881, -0.745109, 0.455959, -0.001200, -0.906983, -0.327318, 2.026690, -0.105730, 
	-0.020392, 0.005549, -0.451729, 0.658699, -1.227531, -0.002804, -1.965012, -0.019943, -0.004837, -0.317069, 0.118176, -0.002891, 2.799904, -0.042994, 0.659656, -0.186782, 
	-0.042620, -0.028133, -3.801854, 12.196858, -3.391032, -0.013471, -0.935132, -0.062346, -0.022052, -3.751294, -4.229030, -0.272455, -2.740089, 13.734338, -6.233754, -0.407933, 
	-0.016888, -0.013860, 2.505438, 0.309884, 1.116607, -0.002246, -1.566856, -0.012844, -0.006531, 1.397103, 0.208785, -0.002433, -1.674652, -2.227979, 0.084769, -0.098298, 
	-0.003252, -0.002619, -1.850093, -0.888078, -0.568904, -0.001031, -1.342440, -0.003539, -0.001809, 4.966959, -3.701034, -0.001056, 3.392207, -0.244451, 0.260316, -0.011177, 
	-0.108516, 0.487407, 3.357880, -4.010841, 2.299636, -0.020753, 7.366953, -0.141787, -0.040120, -3.211447, -7.081005, -0.022666, -11.155073, 10.208858, 2.646915, -0.575441, 
	-0.052428, -0.004427, 2.562913, -1.123166, 0.312758, -0.001358, -0.418695, -0.007909, -0.003174, -0.271088, 1.596402, -0.005778, -1.350621, -0.554132, -0.647259, -0.032038, 
	-0.030711, -0.009299, 4.212853, -0.248308, -0.972596, -0.002494, -1.942900, -0.015082, 0.038472, 0.496806, -1.481142, -0.002612, 2.232029, -2.528975, 0.313219, -0.059260, 
	-0.037066, -0.012564, -0.555071, 1.822188, -2.157256, -0.002274, -0.864141, -0.008099, -0.004705, 1.172280, -0.297164, -0.002476, 0.030494, 1.600591, -0.624771, -0.059965, 
	-0.004664, -0.001871, 0.147443, -1.048358, -0.532048, -0.000370, -0.394696, -0.002330, -0.001067, 0.270483, 1.200101, -0.000417, 0.415683, -0.361823, 0.351831, -0.037899, 
	-0.004805, -0.003949, 0.673708, 1.781936, 0.017572, -0.001166, 2.735833, -0.005330, -0.002670, -3.170664, -1.587638, -0.001268, 0.749442, -0.528663, -0.642839, -0.009496, 
	-0.014111, -0.009806, -0.029443, 0.522866, -1.699923, -0.001473, 0.374128, -0.012855, -0.005441, 1.679811, -2.716601, -0.001657, 0.355130, 2.073569, -0.433317, -0.080877, 
	-0.024726, -0.024928, 2.043267, 0.999609, 2.365472, -0.003077, -1.571381, -0.019170, -0.010420, -1.838757, -1.167832, -0.003333, -1.838311, 1.929738, -0.619131, -0.217019, 
	-0.217950, -0.134974, 4.821057, -1.857304, 0.583825, -0.040325, -3.922548, -0.151754, -0.082790, 2.503644, -2.127278, -0.171656, -3.456746, 2.739553, 1.466569, 0.048677, 
	-0.005806, -0.003956, -1.022157, -3.355395, 0.321972, -0.002066, -0.320980, -0.005167, -0.003054, 4.441113, -1.857443, -0.002093, 2.155680, -0.501696, 0.221876, -0.060827, 
	-0.014809, -0.006869, -0.549274, 2.130680, -1.292622, -0.003142, -1.508223, -0.005393, -0.003760, 1.419504, 2.168229, -0.003230, -1.725100, -1.618998, 0.482915, 0.530092, 
	-0.002755, -0.002405, -0.222377, -0.034250, 1.589336, -0.000589, 0.282388, -0.003433, -0.001551, 0.461476, -1.973676, -0.000656, 0.490651, -0.296978, -0.274549, -0.010634, 
	-0.051686, -0.013116, -1.375166, -1.757223, 1.970891, -0.006014, -4.543864, -0.022208, -0.010635, -0.909919, 1.429406, -0.006281, 2.361362, -2.035476, 5.174233, -0.204304, 
	-0.022741, -0.007891, 0.321965, -0.416651, -3.469142, -0.002040, -0.221199, -0.008975, -0.004131, 4.384896, 2.673095, -0.002180, -1.101210, -1.599528, -0.392611, -0.131659, 
	-0.009108, -0.002388, -2.349374, 1.691926, 0.064921, -0.000949, -0.388588, -0.002993, -0.001750, 1.470794, 0.147285, -0.000977, -0.324570, 0.711555, -0.965963, -0.039821, 
	2.224753, -0.025954, -3.657227, -2.672216, -0.004990, -0.009897, 0.911209, -0.043496, -0.018872, -4.286343, 1.207108, -0.010523, -1.760536, 3.313969, 5.534358, -0.701342, 
	-0.075331, -0.026063, 5.060796, 0.812979, -0.038004, -0.009653, -2.518656, -0.036604, -0.027913, -3.919316, 4.284454, -0.010193, -0.413017, 0.122659, -3.040843, -0.165296, 
	-0.007347, -0.005677, 0.018610, 4.992576, -4.482802, -0.002507, -1.865840, -0.005672, -0.003905, 2.054146, 2.688904, -0.002488, -3.111878, 0.095363, -0.178661, -0.182820, 
	-0.014400, -0.007752, -0.045583, 0.444210, 2.565405, -0.002143, 2.810112, -0.012749, -0.004887, 1.047021, 0.709006, -0.002280, -7.414129, 0.367551, -1.501174, 1.061793, 
	-0.025837, -0.022517, -2.383669, 13.369310, 3.827992, -0.007195, -6.165353, -0.018300, -0.012794, -0.629963, -6.116090, -0.007411, -0.210223, -1.086983, 0.010878, -0.521845, 
	-0.034195, -0.011482, 0.739104, -1.769297, -4.840586, -0.005420, 2.455626, -0.019267, -0.011475, 0.587613, -1.188059, 0.013309, 3.915603, -1.459355, 1.497219, 0.130663, 
	-0.045981, -0.005172, -1.033648, 0.258248, 4.887186, -0.001192, -4.401400, -0.007634, -0.003104, 2.062990, -1.654413, -0.001325, 1.174227, -0.629974, -0.583647, -0.015160, 
	-0.029608, -0.011426, -0.582313, -0.224082, -0.779581, -0.002425, 0.378565, -0.025144, -0.004468, -0.819165, 2.277361, -0.011309, 0.542799, -0.510665, 0.124745, -0.323282, 
	-0.004990, -0.002281, -0.377107, -0.268400, 0.677583, -0.000433, 0.416357, -0.002321, -0.001161, 0.459480, -1.622111, -0.000484, -0.210746, -0.191967, 1.132217, -0.003637, 
	-0.008559, -0.004838, 1.392992, 1.248760, 2.025189, -0.001643, -1.885534, -0.005120, -0.003253, -1.472841, 3.444604, -0.001732, -4.193285, -0.179617, -0.286505, -0.068617, 
	-0.030518, -0.008338, 1.653440, -0.814564, -2.697169, -0.002631, -5.982450, -0.019872, -0.005809, -1.383355, 4.261574, -0.002785, 4.716619, 1.046725, -0.655063, -0.075806, 
	-0.014848, 0.069488, 1.363319, -0.602291, 0.776497, -0.002519, -3.255241, -0.022679, -0.006887, -0.180050, -0.143782, -0.002639, 0.229445, 1.955402, 0.054480, -0.217694, 
	-0.006100, -0.006580, 1.181686, -0.975374, 0.282376, -0.001463, 5.264737, -0.005587, -0.002996, 1.603316, -1.819004, -0.001836, -3.851506, -0.961723, -0.639354, -0.060592, 
	-0.055694, -0.006263, 0.587454, 0.020497, -0.989830, -0.002166, -0.691986, -0.009794, -0.004502, -0.487137, 1.442023, -0.002298, 0.768977, -0.855463, 0.346241, -0.060060, 
	-0.009885, -0.005301, -0.647670, -0.142742, -2.378595, -0.002101, 0.049621, -0.004956, -0.003488, 6.830009, 0.054242, -0.002216, -0.292195, -3.032064, -0.346102, -0.066558, 
	-0.003859, -0.001324, 0.837993, -0.090529, -0.136054, -0.000393, -0.945301, -0.000944, -0.000771, -0.165318, 2.907437, -0.004811, -1.536644, -0.193281, -0.659116, -0.007083, 
	-0.030202, -0.015840, 1.656575, 2.175517, 9.973317, -0.007182, -1.130718, -0.034514, -0.012511, -5.145360, 0.046710, -0.007501, -3.769328, -2.794039, -0.573360, -0.331563, 
	-0.018472, -0.005740, -1.507753, -0.285848, -1.112607, -0.001072, -1.692448, -0.005596, -0.002584, 0.871508, 3.097070, -0.001152, 2.284993, -0.843123, -0.706503, -0.070672, 
	-0.023852, -0.012104, -1.166323, -1.356606, -1.054967, -0.001890, -2.652671, -0.012432, -0.006271, 1.522447, 3.801959, -0.002101, -1.185721, -2.812914, 5.082975, -0.119530, 
	-0.003440, -0.002991, 0.475133, 1.996221, -1.018386, -0.000623, 0.576994, -0.002709, -0.001465, -1.778406, 0.525681, -0.000662, -1.878659, -0.148626, 1.267660, -0.005722, 
	-0.003173, -0.003403, 1.328705, -1.121218, 1.631741, -0.000967, 0.688368, -0.003018, -0.002333, -1.725034, -2.094431, -0.001078, 0.288649, 0.878101, 0.246723, -0.107631, 
	-0.013583, -0.006069, 1.495906, 3.033538, 2.231723, -0.002386, 3.072815, -0.019870, -0.004748, -5.668088, 1.247440, -0.002496, -2.905533, -1.292665, -1.110142, -0.055842, 
	-0.031070, -0.007059, 0.772463, -0.319627, 2.318607, -0.001438, -2.867367, -0.019747, -0.003929, 2.976544, -1.797772, -0.001513, 1.295166, -0.279701, -1.881151, -0.152407, 
	-0.036596, -0.015107, 1.847023, 2.104640, 0.898430, -0.015522, -4.719540, -0.163308, 0.755726, -2.092639, 2.342598, 0.008175, -2.271378, 2.174969, -0.696763, -0.120709, 
	-0.009569, 2.516748, -0.350763, 1.222086, -1.834229, -0.006524, -0.437534, -1.395553, -0.666382, -1.231000, 2.964607, -0.006604, -0.914539, -0.385669, 0.586451, -0.051526, 
	-0.012194, -0.008818, -1.816812, 0.796446, -1.287055, -0.002170, 2.552010, -0.012782, -0.005475, 0.697542, -2.298993, -0.002359, 0.848643, 1.419904, -1.921193, 1.053305, 
	-0.014718, -0.005499, -2.576796, -1.905599, -0.627082, -0.002732, -0.328596, -0.007116, -0.004194, 1.645064, 1.435907, -0.002796, -1.671006, 2.071880, 2.027030, -0.033748, 
	-0.261687, 0.285535, 11.282976, -5.253280, 3.508222, 0.147805, -0.971173, -0.422583, -0.087192, 11.540899, -5.166085, -0.048524, 4.637464, -10.323629, -7.405641, -1.463107, 
	-0.018999, -0.010986, -1.889414, -2.252334, -1.737666, -0.005701, 6.296413, -0.015247, -0.007812, -0.009917, -3.970987, -0.006240, 3.964483, -0.676181, 0.519032, -0.178446, 
	-0.033115, -0.013531, -0.112518, 1.292209, -2.127420, -0.004250, 1.133496, -0.018443, -0.008911, 1.260869, 0.034281, -0.004479, 0.781295, -1.333663, -0.673202, -0.172619, 
	-0.014025, -0.003745, -0.588148, 0.420791, 0.359438, -0.000943, -1.400305, -0.003924, -0.002374, -1.398322, 0.556018, -0.000945, 2.633158, -0.078599, -0.438880, -0.039196, 
	-0.030361, 0.160023, 0.127301, -2.855917, 1.053377, -0.007152, -0.221141, -0.092179, -0.016281, 4.253708, 2.408182, -0.007713, -4.592306, 0.650326, -0.613113, -0.216753, 
	-0.057965, -0.005490, -0.454737, -2.421691, 5.182597, -0.002827, -4.363296, -0.018187, -0.005104, -1.192417, 0.644967, -0.002900, 2.614834, -0.321299, 0.478395, -0.074881, 
	-0.009643, -0.006774, 3.926881, 1.360458, -0.525832, -0.002431, -2.469931, -0.016018, 0.001424, -1.261512, -1.682574, -0.006761, 0.037694, -1.424087, 2.137776, -0.058672, 
	-0.009728, -0.006542, -1.878543, -0.277699, 0.736534, -0.001638, -0.021756, -0.024081, -0.004714, 0.249122, -2.210761, -0.001677, 5.755398, -0.126926, -2.001469, -0.175520, 
	-0.106823, -0.025040, 5.425579, 0.367821, -0.946151, -0.004351, -3.708633, -0.040627, -0.013810, 1.688547, -0.591489, -0.005022, -1.518334, 0.992690, -1.396426, -0.117929, 
	-0.002701, -0.001528, 1.919547, -0.218368, -0.169252, -0.000755, 3.161053, -0.002634, -0.001165, -1.147721, -1.794123, -0.000780, -1.457196, -0.252229, 0.012030, -0.044178, 
	-0.023198, -0.004322, -0.384982, 1.366482, -0.533902, -0.001517, -0.807913, -0.004451, -0.002985, -0.286770, -1.708104, -0.001568, 1.921015, 2.149770, -1.656735, -0.020819, 
	-0.196944, -0.072435, -3.292852, 1.600793, 2.411478, -0.046481, -1.134037, -0.138147, -0.057745, -0.833590, 3.853439, -0.048108, -5.947165, -0.177502, -1.662180, 5.741475, 
	-0.025937, -0.006754, 0.448369, -0.727051, 4.068696, -0.002696, -0.354728, -0.009013, -0.004977, -1.352327, 1.473926, -0.002823, -2.817159, 0.009439, -0.623809, -0.073157, 
	-0.010327, -0.002519, -1.403310, -1.156184, -0.864835, -0.001945, -0.363955, -0.006393, -0.003454, -0.341490, -0.758998, -0.002073, 2.048600, 3.463422, -0.571448, -0.025092, 
	-0.044712, -0.017076, -0.865390, 6.152679, -1.569887, -0.003600, -0.578950, -0.049483, -0.011420, -2.034571, -0.863926, -0.004202, 2.622569, -0.255048, -1.961836, -0.515148, 
	-0.033542, -0.022347, -0.481809, -0.393032, -2.896132, -0.012943, -1.432285, -0.032642, -0.016972, 1.843698, -2.438100, -0.021981, 5.423403, -1.643616, 2.464246, -0.305945, 
	-0.127153, -0.034476, 1.392847, -0.248495, -3.842022, -0.005103, 1.113077, -0.055812, -0.012912, 1.459147, -3.207972, -0.135129, 2.861878, 1.097142, -0.529133, 0.274116, 
	-0.003544, -0.002462, 0.636650, 1.419725, 0.441088, -0.000872, -1.269691, -0.002268, -0.001609, -0.995713, -0.056256, -0.000885, 0.611008, -0.836595, 0.077572, -0.016147, 
	-0.025217, -0.013220, 1.150718, -2.502661, -0.128868, -0.004451, 2.328407, -0.043358, -0.010637, -0.895279, 6.626611, -0.004885, -4.255117, -1.100919, -0.928130, -0.192994, 
	-0.024856, -0.017429, -0.861319, 0.599454, 0.354729, -0.002670, -0.266522, -0.020370, -0.008861, -2.464357, -0.430873, -0.002968, 0.856724, 2.007879, 0.699856, -0.418417, 
	-0.105671, 0.150663, 0.868905, 0.984795, -1.961474, -0.006757, -3.588739, -0.100000, -0.029058, -1.265499, -3.140378, -0.007212, 3.645932, 3.256087, 1.935398, -0.636992, 
	-0.013409, -0.008433, 2.632308, -0.883994, -0.400095, -0.002071, 0.022201, -0.009024, -0.004341, 0.422535, -0.707448, -0.002173, 0.431703, -0.626893, -0.714582, -0.136284, 
	-0.018669, 1.199419, 1.240772, 0.453658, -1.598582, -0.011902, -1.406343, 4.730681, -3.175065, -1.343886, 1.688990, -0.011324, 0.037171, -0.612933, -1.121365, -0.050624, 
	-0.029056, -0.006179, 1.189071, 1.853248, -3.134836, -0.001726, -1.049215, -0.012037, -0.004143, -2.335539, 0.452567, -0.002005, 2.977155, -0.843947, 1.004556, -0.057914, 
	-0.002978, -0.001100, -0.224205, 0.406676, 0.495936, -0.000386, -0.353595, -0.000909, -0.000678, -0.269309, -0.333172, -0.000413, 0.240075, -0.640345, 0.694234, -0.009829, 
	-0.073972, -0.033851, 1.734654, 7.380102, -3.904408, -0.008352, 0.235671, -0.046126, -0.018256, 3.750616, -0.035011, -0.009136, -1.922333, -1.650857, -2.167200, -3.231542, 
	-0.001614, 0.036665, 1.924786, -0.042308, -0.283754, -0.000788, -0.364445, -0.016123, -0.000977, -0.688091, -0.038661, -0.000801, -0.071390, -0.105444, -0.340713, -0.006343, 
	-0.187573, -0.036535, -0.033754, 7.317600, -5.159901, -0.008508, 2.729067, -0.057448, -0.023312, -4.112426, 1.501432, -0.138437, -2.896041, -0.443971, 2.214075, -0.664266, 
	-0.052450, -0.012673, -0.810628, -1.946461, -2.807031, -0.003147, 2.322482, -0.130864, -0.012564, -0.131105, -1.998212, -0.006778, 4.482389, 0.530937, 0.659303, -0.083200, 
	-0.001408, -0.000728, 0.089243, -0.129568, 0.080566, -0.000399, 1.740360, -0.000701, -0.000555, -0.149537, -1.006428, -0.000405, -0.614308, 0.021794, -0.022463, -0.005461, 
	-0.164296, -5.638237, -0.378439, -1.169719, -0.250095, -0.159086, -1.425176, 11.676730, -0.580883, -0.181475, 0.940459, -0.159584, -1.174700, -0.509216, -0.648939, -0.177344, 
	-0.083295, -0.009223, 3.069795, 2.140572, 2.169935, -0.002495, -4.393143, -0.007851, -0.005027, -0.149743, 3.134674, -0.002613, -3.974639, -1.607047, -0.205694, -0.074206, 
	-0.018611, -0.010635, 0.217865, 3.908696, -2.708396, -0.002301, -2.544301, -0.016922, -0.005797, -1.278835, 0.708628, -0.002334, -0.111213, -0.457006, 2.365809, -0.044647, 
	-0.024697, -0.003196, -0.368205, 2.620318, 1.431685, -0.001309, -2.072380, -0.004420, -0.002346, -1.001975, -0.388445, -0.001330, -1.014289, -0.401009, 1.257378, -0.025781, 
	-0.002834, -0.002621, 0.733689, 1.863336, -0.321037, -0.000822, -2.478691, -0.011735, -0.001992, -1.163808, 2.215147, -0.000868, -1.537700, -0.260560, -0.307865, 1.278360, 
	-0.072842, -0.010005, 2.914386, -4.762620, 0.716089, -0.002708, -0.941456, -0.017669, -0.006252, 2.049018, 1.248123, -0.003228, -4.355485, 3.195476, 0.266307, -0.217133, 
	-0.007619, -0.005887, 0.193954, -0.361269, -0.650375, -0.001022, -0.262292, -0.013729, -0.003266, 0.181594, -0.976831, -0.001149, 0.287151, 2.419910, -0.728165, -0.071005, 
	-0.019088, -0.003886, -0.004446, 1.376925, -0.762206, -0.001070, -0.783910, -0.003861, -0.001950, -0.837728, -0.216767, -0.001118, -0.761998, 1.403022, 0.634400, -0.016322, 
	-0.007136, -0.005538, -1.137925, -2.426708, -0.603026, -0.001383, -1.582261, -0.005418, -0.002991, 0.229691, -3.289407, -0.001471, 7.578896, 0.318948, 0.953278, -0.017550, 
	-0.024230, -0.023142, 0.028181, -0.330999, 1.227457, -0.005898, -0.172843, -0.016896, -0.011519, 2.211134, 0.862556, -0.006319, -1.833738, 1.707171, -2.958237, -0.652678, 
	-0.045205, -0.022918, 0.989159, -3.317029, -0.659974, -0.007909, 5.193529, -0.046905, -0.016806, 0.815196, -4.761418, -0.008674, -0.006065, 2.190064, 0.107517, -0.402562, 
	-0.017404, -0.010444, 1.815821, 0.553437, -2.887188, -0.001881, 3.027020, -0.009865, -0.004888, -2.892293, 0.799733, -0.006421, -1.210935, -0.668322, 1.590402, -0.076773, 
	-0.017113, -0.001011, 0.171402, -2.869791, 0.732833, -0.001796, -3.106675, -0.014286, -0.004440, -0.002082, -2.886564, -0.001892, 5.253991, 1.170241, 1.623378, -0.046195, 
	2.904907, -0.101387, -3.031936, 1.323168, 4.522159, -0.029052, -4.882790, -0.108118, -0.066406, -0.737218, 2.237787, -0.030991, 1.546881, 2.995114, -5.641583, -0.900535, 
	-0.044341, -0.018805, -0.775644, 1.486366, 5.569921, -0.008125, 2.079905, -0.028418, -0.014662, -3.329304, -4.300662, -0.008645, 1.312942, -2.038173, 0.244132, -0.126486, 
	-0.007995, -0.001883, -0.525040, -0.097753, -2.123582, -0.000739, 6.530430, -0.002326, -0.001464, -0.458419, 3.697133, -0.000806, -7.205403, 0.342147, -0.117272, -0.027029, 
	-0.130994, -0.043546, -0.114267, 0.795166, -0.980704, -0.011123, 5.777779, -0.049034, -0.024340, -0.297433, 0.122214, -0.012291, -4.720729, 0.342071, -0.320193, -0.332576, 
	-0.013543, -0.006529, -0.747258, -2.216110, -0.228239, -0.002203, -5.405813, -0.005574, -0.003682, -0.673010, 1.067060, -0.002301, 3.480009, 0.074049, 1.561968, 3.121174, 
	-0.002901, -0.001855, 1.056620, 2.106338, 1.333911, -0.000427, -0.464006, -0.007277, -0.001141, -1.139869, 1.597816, -0.000461, -3.089415, -0.817706, -0.542014, -0.027612, 
	-0.055709, -0.022132, -0.787788, -0.165694, -0.458017, -0.003282, 0.575758, -0.014865, -0.009332, 0.548535, 2.069230, -0.003700, -0.639415, 1.076837, -1.974916, -0.135511, 
	-0.152097, 0.076120, -0.747752, -1.606949, 1.799029, -0.031823, -0.568902, -0.325685, -0.064950, 2.418012, 0.726707, 0.073751, 0.796158, -0.104492, -2.337592, 0.050465, 
	-0.119890, -0.028727, -0.783679, 4.556833, 4.040156, -0.005799, 3.674632, -0.044401, -0.016821, -4.854417, -0.084833, -0.006239, -4.118084, -4.104632, 2.370071, -0.474170, 
	-0.051433, 0.373291, 5.681198, -1.217226, -0.606020, 0.190421, -0.349112, -0.221347, -0.007340, -5.052209, 1.258146, -0.004582, 0.035341, 0.986019, -0.474385, -0.540762, 
	-0.005691, -0.001666, -0.028039, -0.165856, -0.169774, -0.000306, 1.488692, -0.001188, -0.000678, -0.051883, -0.176057, -0.000328, 0.219112, 0.151259, -1.134134, -0.123464, 
	-0.012532, -3.426645, 0.839786, 1.782112, -1.527678, -0.002129, 1.619171, 3.512649, -0.004718, -0.902307, -3.288409, -0.002175, 0.803776, -1.202430, 0.744255, 1.067275, 
	-0.043786, -0.012646, -2.766770, -1.386860, 0.793952, -0.004455, 4.539971, -0.014311, -0.008868, 0.193834, -4.777043, -0.009199, 4.913006, -2.240471, 1.080379, -0.256732, 
	-0.011632, -0.002943, -0.253879, 1.249150, -1.195834, -0.001541, -1.856208, -0.006985, -0.002412, 0.153614, -0.811042, -0.131002, 3.355658, -0.513947, 0.175589, -0.146587, 
	-0.096044, -0.029733, -1.521891, 2.567994, 1.579143, -0.008607, -3.150283, -0.054585, -0.021820, 1.270833, -3.549798, -0.013468, 2.412368, 3.612739, -2.613089, -0.383759, 
	-0.023639, -0.016573, -3.620154, 1.260373, -2.965974, -0.005580, 1.158097, -0.018563, -0.010748, 2.862306, -0.538737, -0.005804, 0.281842, 3.132648, -0.933087, -0.556407, 
	-0.019199, -0.008272, -3.008154, 2.769401, -2.015008, -0.002055, 2.055308, -0.008342, -0.005319, 2.213121, -2.702704, -0.002166, -3.387506, 4.116107, 0.096945, -0.092157, 
	-0.036223, -0.007388, -0.878105, -0.072138, -0.262424, -0.001873, -4.293730, -0.007822, -0.004636, 0.227095, -1.255327, 0.046822, 6.809055, 0.495185, -0.716262, -0.042229, 
	-0.009899, -0.006358, -1.284907, 1.000782, 2.300887, -0.001318, -1.497098, -0.005589, -0.003300, 2.522980, -1.165425, -0.001404, -1.417264, -0.535733, 0.178898, -0.075251, 
	-0.049157, -0.025801, -2.091692, 0.419491, 4.156218, -0.007011, 6.828141, -0.158548, -0.022325, -2.384423, -8.196600, -0.010823, -7.219758, 8.557982, 0.367388, -0.163083, 
	-0.017680, -0.011023, -0.023666, 0.669244, -2.417475, -0.002650, 2.939537, -0.010934, -0.005886, -0.664331, 0.522004, -0.002759, 0.624494, 0.021303, -1.501154, -0.119023, 
	-0.005571, -0.005620, -1.092028, 1.811076, -1.349750, -0.001175, 0.600505, -0.005647, -0.003239, -1.232853, -0.693157, -0.001279, 0.312005, 0.576774, 1.128295, -0.038336, 
	-0.007346, -0.006963, -0.105376, -0.445850, -1.806226, -0.002439, -1.256270, -0.009400, -0.004574, 0.824955, 2.695359, -0.002502, -1.548131, -0.266686, 2.012836, -0.071388, 
	-0.096487, -0.051615, 5.869987, 1.618356, -2.003637, -0.032846, -3.073657, -0.059778, -0.037874, -4.675350, 0.214373, -0.033522, -2.812224, 0.128655, 2.286930, 2.758690, 
	-0.014321, -6.859108, 4.297159, 0.008969, 0.086633, -0.005108, 4.177981, 7.735343, -0.008132, -1.463464, -4.150149, -0.005289, -2.214666, -1.319950, -0.212577, -0.053322, 
	-0.026465, -0.007433, 1.094313, 1.687450, -1.222269, -0.002152, 5.967299, -0.011057, -0.014068, -1.731240, 0.026456, -0.002284, -5.288807, -0.396647, -0.000040, -0.073056, 
	-0.024956, -0.017630, 1.991876, -1.482764, 1.267400, -0.005049, -2.760784, -0.027769, -0.012807, 4.653014, -0.606773, -0.005401, -0.011974, -2.747564, -0.046964, -0.161855, 
	-0.004750, -0.006336, -0.096409, 1.486113, 0.178820, -0.001753, 2.020129, -0.008694, -0.003873, -0.968202, -2.433720, -0.001878, -4.128759, 1.917777, 2.118526, -0.066990, 
	-0.012689, 1.758138, 0.911223, 2.150531, -1.013567, -0.004225, 0.496118, -1.138649, -0.007670, -1.858712, -0.213080, -0.004557, -0.430313, -0.279713, -0.318167, -0.034669, 
	-0.002555, -0.001001, 0.877881, -0.067162, -0.299249, -0.000424, -0.782663, -0.017664, -0.000931, -0.096062, 1.695969, -0.000440, -0.806566, -0.202560, -0.289278, -0.007297, 
	-0.003866, -0.003058, 0.912559, 0.051255, -3.554654, -0.001395, 7.539695, -0.002799, -0.002121, -0.149683, -1.040085, -0.001419, -2.713490, -0.222232, -0.794727, -0.013979, 
	-0.143169, -0.048557, -0.280905, -0.109000, 2.764050, -0.013044, -0.888554, -0.090528, -0.031478, -0.700140, -4.488208, -0.014256, 2.922362, 0.457163, 1.706573, -1.042307, 
	-0.008470, -0.009692, -2.189917, -1.237641, -0.083797, -0.002093, -0.793674, -0.024072, -0.006159, 1.984982, 1.966041, -0.002319, 1.575929, -0.980233, -0.092717, -0.096168, 
	-0.067330, -0.033572, 0.478546, 0.749853, -0.641618, -0.005834, -1.157331, -0.071174, -0.021271, -1.960745, 0.801788, -0.006545, 2.661728, 0.999322, -1.558681, -0.167137, 
	-0.004006, -0.002464, 2.120974, 0.065502, -0.622436, -0.000891, -1.297698, -0.006686, -0.001867, 0.425128, 0.828169, -0.000918, 0.301428, -0.732861, -1.027160, -0.044213, 
	-0.004122, -0.003166, -0.465310, -1.329466, 1.597996, -0.000594, -1.514814, -0.002617, -0.001612, 0.586334, 2.000672, -0.000733, -1.157958, -0.138679, 0.546189, -0.112121, 
	-0.077706, -0.008584, 0.331493, -0.248072, 0.506899, -0.002807, 2.659684, -0.011636, -0.006083, 0.021296, 1.911995, -0.007378, -3.985548, -0.078716, -0.813802, -0.191036, 
	-0.006291, -0.003813, -0.609048, 1.822322, 0.992616, -0.000911, 1.313819, -0.007176, -0.002181, -1.349468, -3.685107, -0.000594, 1.421162, -0.758622, 0.918752, -0.045460, 
	-0.019935, -0.007826, -3.020392, 0.239278, 0.317101, -0.002314, -0.432299, -0.010480, -0.004691, 0.703565, 0.776720, -0.131831, -0.756345, 3.083919, -1.127508, 0.393039, 
	-0.053142, -0.036190, 2.439459, -1.335783, -0.209521, -0.010063, -3.013065, -0.070027, -0.025372, 1.767204, 1.752304, -0.011766, 2.724385, -3.469532, -1.698934, 1.250044, 
	-0.333592, -0.181695, 6.410079, -2.138210, -3.186442, -0.051722, 2.982974, -0.295179, -0.124169, 1.818328, 0.185780, -0.065513, -0.078772, -3.720769, -0.189899, -1.031200, 
	-0.006547, -0.006496, 0.497939, -0.355085, 1.305521, -0.003781, 0.041687, -0.035161, 0.214198, 1.127245, 0.919287, -0.003828, -2.304233, -1.196236, -0.104571, -0.089938, 
	-0.004404, -0.005772, -0.384373, -1.687883, -0.423766, -0.001014, -2.341141, -0.004618, -0.002766, 3.562814, -1.994987, -0.001122, 3.696283, -0.002219, -0.395841, -0.009193, 
	-0.009192, -0.003541, -0.900715, -0.027078, 1.434410, -0.001429, -2.805296, -0.005373, -0.002795, 2.228856, -0.501785, -0.001492, 1.722034, -1.708480, 0.627257, -0.045383, 
	-0.002170, -0.000815, -0.830772, -0.280133, -0.475594, -0.000388, 0.370100, -0.004712, -0.000698, 0.710382, 3.382344, -0.000405, -4.402779, 2.169425, -0.630594, -0.003191, 
	-0.069084, -4.274065, -0.139158, 8.973329, -1.790743, -0.005312, -3.334837, 4.392118, -0.001451, -2.226144, -0.744503, -0.005458, -4.045656, 2.953906, 0.337803, -0.020745, 
	-0.003644, -0.002159, -0.497970, -2.303803, 0.702559, -0.000484, -4.565918, -0.002259, -0.001453, 1.243982, 4.314292, -0.000501, 1.094073, -0.260817, 0.301295, -0.017193, 
	-0.060563, -0.014229, -1.931890, -1.978752, 3.513406, -0.004023, 3.387959, -0.032397, -0.009243, -0.227335, 1.808252, -0.004237, -2.471393, -2.356939, 0.166372, 0.215011, 
	-0.096201, -0.036612, -0.089182, -1.606391, 5.387982, -0.007654, -3.572339, -0.060592, -0.020831, 4.637679, 0.625945, -0.142173, -1.775537, -1.142233, -1.644584, -0.457278, 
	-0.037910, 0.018392, -2.317241, 0.119005, 0.771396, -0.008403, -1.131395, -0.043934, -0.013969, 0.760272, -4.439978, -0.138151, -0.817936, 0.227387, 7.469548, -0.417083, 
	-0.060120, -0.017870, -1.858923, -0.339665, -1.669466, -0.002712, -0.845886, -0.020305, -0.007238, 4.021889, 2.759089, -0.003073, -0.230317, -0.177615, -1.422084, -0.125704, 
	-0.196964, -0.130579, 0.823683, 6.393414, -6.744583, -0.050491, 2.100708, -0.143348, -0.095476, -1.317894, 0.773636, -0.319521, 2.334788, 0.248992, -3.230528, -0.445838, 
	-0.157398, -0.050998, -0.462322, -0.873579, 0.966386, -0.017140, 4.759088, -0.059176, -0.042961, -0.238956, -0.673100, -0.017061, 0.273217, -1.580713, -1.221012, -0.604276, 
	-0.020022, -0.009485, 1.008423, 2.923478, -2.001056, -0.003431, -4.206244, -0.046586, 0.340543, -0.549789, 8.136859, -0.003694, -5.197206, 0.169866, -0.713842, 0.172186, 
	-0.015652, -0.014862, 0.131531, 1.602500, -2.980641, -0.006171, -2.487382, -0.023983, -0.010848, -0.082262, 4.914810, -0.006408, -5.466174, 2.334151, 2.247569, -0.136178, 
	-0.006030, -0.002466, 1.195810, -0.966397, -0.794948, -0.001225, 1.453638, -0.005612, -0.002377, -0.931472, -2.717843, -0.001287, 2.677881, 0.873094, -0.751272, -0.019495, 
	-0.026248, -0.044243, -1.177252, 1.773195, -3.020776, -0.003055, -1.885807, -0.019250, -0.009342, -1.916620, 4.295950, -0.003397, -1.691300, 4.145687, -0.171403, -0.246140, 
	-0.006689, -0.004846, -0.609409, 4.308974, -1.694838, -0.000878, -1.506979, -0.004429, -0.002196, -0.398138, -0.109078, -0.130377, 0.134582, -0.021339, 0.077530, -0.031890, 
	-0.007669, -0.007019, 2.623002, 1.171389, -0.089589, -0.002585, -0.969647, -0.004758, -0.005557, -0.564556, -1.181860, -0.002647, -1.726285, -1.686187, 2.614816, -0.160849, 
	-0.001287, -0.001492, -0.469082, -0.224648, 1.132238, -0.000301, 0.605615, -0.002865, -0.004699, 0.417588, -1.598896, -0.000323, 0.443749, -0.860443, 0.591824, -0.026974, 
	-0.010276, -0.007607, -0.489879, -0.498438, -0.812825, -0.002241, 1.473140, -0.027788, -0.005261, 1.049774, 1.268610, -0.002321, -1.972000, -0.576078, 0.834796, -0.221606, 
	-0.029217, -0.015702, 0.629619, 0.948478, 0.382571, -0.004329, 5.106791, -0.044693, -0.010648, -3.074233, -0.802305, -0.004644, -3.990596, 0.757351, 0.304427, -0.152873, 
	-0.025902, -0.013132, -0.877383, -3.257946, -0.159905, -0.003641, 3.494587, -0.012354, -0.008236, 1.618857, 4.624065, -0.003856, -2.024319, -2.463444, -0.784455, -0.102936, 
	-0.008551, -0.004530, -1.512721, 0.742183, 6.063091, -0.002534, 2.097854, -0.020968, -0.004703, 1.208658, -4.023119, -0.002481, -4.327743, -0.964865, -0.884216, 1.644645, 
	-0.013939, -0.009594, -3.208634, 0.840898, 2.538549, -0.002760, 3.507881, -0.008529, -0.005519, 0.421573, -4.903517, -0.002966, 2.288009, 0.067497, -1.350564, -0.158384, 
	-0.003668, -0.002608, 0.907522, -2.585799, 0.509098, -0.000891, 1.513924, -0.003818, -0.001916, 1.303697, -1.175759, -0.000831, 0.097288, -0.357552, -0.176534, -0.022152, 
	2.434104, -0.007109, 0.342828, 5.568910, -0.827552, -0.002033, 2.459909, -0.010561, -0.004648, -2.022396, -3.032990, -0.002144, -1.525726, -1.887631, -1.259061, -0.223899, 
	-0.000839, -0.000366, -0.076994, 0.317422, 0.666521, -0.000283, 1.922680, -0.000365, -0.000296, -0.034720, -1.716524, -0.000287, -0.625668, -0.407748, -0.255353, 0.212820, 
	-0.007444, -0.003212, -0.674367, -0.328490, 0.747473, -0.001084, 0.543479, -0.009179, -0.002785, -0.464326, 1.351361, -0.001194, -3.352685, 0.748003, 1.538518, -0.084068, 
	-0.011925, -0.007061, -0.129188, -0.396045, 5.231523, -0.001284, -2.368201, -0.007148, -0.003327, -0.965129, -3.709735, -0.001401, 2.366887, -0.007425, 0.076116, -0.066656, 
	-0.007341, -0.004134, 3.124903, -2.151373, 1.196935, -0.001638, -4.740607, -0.012450, -0.002998, -2.513480, 6.725995, -0.001718, -0.845930, -0.413364, -0.337807, -0.014993, 
	-0.011188, -0.006314, -0.968352, 0.654052, 0.790949, -0.000970, -1.714010, -0.006604, -0.003450, 1.224799, -0.517101, -0.001088, 1.004250, 0.556215, -0.973488, -0.027702, 
	-0.003590, -0.002446, -0.473479, 1.539604, 1.433180, -0.001845, 1.175446, -0.005306, -0.001656, -0.812457, -0.982077, -0.131384, -2.256055, -0.422758, 0.640584, 0.304238, 
	-0.032072, -0.005737, -0.647483, 0.078406, -0.585599, -0.001849, -2.555279, -0.007514, -0.003757, 1.792920, 7.652509, -0.001937, -5.781717, -0.497728, 0.221921, 0.374917, 
	-0.030295, -0.020306, 3.107031, -0.351291, -2.303373, -0.006690, -0.165277, -0.020065, -0.014117, -2.603878, -1.829298, -0.007132, 5.520046, -0.896134, -0.259772, -0.119448, 
	-0.106987, -0.029980, -0.828164, -5.819690, 0.180975, -0.008808, 5.099677, -0.042116, -0.018444, 2.628226, 6.767139, -0.009143, -3.039549, -3.005888, -1.962544, 0.195296, 
	-1.179819, 0.197561, 2.056056, -3.649763, 0.413079, -0.173139, 1.842329, -0.550536, -0.264264, 6.866228, -18.747137, -0.180583, 4.443158, 3.731668, 1.409618, 3.785544, 
	-0.017983, 0.017314, -1.576565, -0.560362, 3.913161, -0.001778, -0.917263, -0.033748, -0.006463, -0.943122, 4.054145, -0.001893, -0.654157, -2.384986, -1.021565, 0.135265, 
	-0.019871, -0.014844, 1.244501, -1.233415, -0.371656, -0.005486, -1.750040, -0.023316, -0.010698, -0.542086, -3.361905, -0.005532, -0.179948, 0.353849, 5.967006, -0.046559, 
	-0.014876, -0.006335, 1.560993, 0.190414, -1.385751, -0.002698, 2.447830, -0.011639, -0.004677, 2.355635, -2.814963, -0.002832, 1.837946, -1.358125, -2.363184, -0.427738, 
	-0.110548, -0.019616, 2.173551, 2.782323, -1.061473, -0.010753, 4.114916, -0.024067, -0.015691, 4.963239, -1.801951, -0.011112, -7.078416, -3.199615, -0.580124, -0.120662, 
	-0.005729, 1.216182, -2.174443, -0.395259, -0.410698, -0.002898, 0.342652, -1.159858, -0.003930, 1.015592, 2.203757, -0.002924, -1.076061, -0.036406, 0.504416, -0.014395, 
	-0.001027, -0.000540, -1.239648, -0.185515, -0.100946, -0.000205, -1.560158, -0.000735, -0.000401, 1.888812, 1.099741, -0.000207, 0.298915, -0.648600, 0.455887, -0.005374, 
	-0.006832, -0.005222, -2.512269, -3.485588, 0.575729, -0.001962, -0.016207, -0.006694, -0.003315, 3.339105, 3.343580, -0.002029, 0.074142, -0.251437, -0.966356, -0.074646, 
	-0.064115, -0.008237, 1.056439, 2.500336, -3.134399, -0.002039, -0.227761, -0.022139, -0.005093, 2.234173, 1.262489, -0.002096, -2.457272, 0.252039, -1.083145, -0.299181, 
	-0.745520, -0.402421, -5.492299, -0.255482, 2.891490, -0.061894, 5.552411, -0.535610, -0.187421, 2.175536, -8.105131, -0.066417, 5.800394, 2.796539, -1.756604, -1.607571, 
	-0.004373, -0.002339, 0.787849, 0.543595, 0.887686, -0.000784, -0.002303, -0.002960, -0.001515, -0.999961, 3.018212, -0.000824, -3.789740, -0.494085, 0.086112, -0.024570, 
	-0.046850, -0.018503, -0.508892, 3.329049, -1.943070, -0.002156, 2.028141, -0.015375, -0.007922, -1.444117, 3.124700, -0.002462, -1.270663, -0.627286, -2.547841, -0.046754, 
	-0.003808, -0.004562, -0.276172, 0.651177, -0.917198, -0.000727, -0.685576, -0.002519, -0.001544, -2.157279, 1.873216, -0.000761, 0.696864, -0.167764, 1.010415, -0.013761, 
	-0.047818, -0.004170, -0.113448, -0.871651, 1.309675, -0.001278, 0.821231, -0.003266, -0.002272, -0.212965, 0.204056, -0.001332, -1.737855, -0.546087, 1.220691, -0.013512, 
	-0.107135, -0.029999, -2.655311, -2.435701, 4.107237, -0.007154, 0.610277, -0.044744, -0.019527, -3.421155, 5.238321, -0.007792, -4.418405, 3.596161, -0.181928, -0.223146, 
	-0.123059, -0.051409, -0.844407, -2.082194, -5.890691, -0.022261, -1.485652, -0.204084, -0.041143, -0.110023, 4.434651, -0.030778, 1.690170, 7.375451, -1.439937, -1.174632, 
	-0.002949, -0.002443, -0.925880, -0.015195, -2.977202, -0.001327, 4.237882, -0.002864, -0.002051, 0.716634, 0.327633, -0.001353, -0.506436, 0.192370, -1.027673, -0.009147, 
	-0.062300, -0.056265, 0.433836, 3.646802, 3.493024, -0.013461, -1.871338, -0.091721, -0.030598, 1.298768, -3.001437, -0.014452, -2.576136, 1.812588, -2.798786, -0.168523, 
	-0.099525, -0.019571, 2.014140, 3.052960, 4.727767, -0.011221, 4.608298, -0.068041, -0.022882, -2.502328, -8.621716, -0.011951, -0.962606, -2.693313, 0.828331, -0.218343, 
	-0.284873, -0.033601, -2.206071, 1.886529, -0.180213, -0.012696, 1.660890, -0.616438, -0.039191, -1.004974, -0.054507, -0.272307, -2.775894, 3.566068, 0.753222, -0.385942, 
	-0.010291, -0.007575, -0.135385, -0.179255, 0.610907, -0.000945, 2.185050, -0.011771, -0.003199, -0.350436, -1.660894, -0.001064, 1.768372, -0.861974, -1.498252, 0.156712, 
	-0.027721, -0.017365, 2.677934, 3.681550, 1.753350, -0.003657, 0.954768, -0.012173, -0.007689, -1.218256, -4.759976, -0.003750, 0.206359, -3.372597, 0.487306, -0.338084, 
	-0.086362, -0.014337, -5.626587, -0.456568, 3.512476, -0.009356, 2.388286, -0.135733, -0.022697, -3.988938, -2.632295, -0.138713, 1.561642, -0.890855, 6.814574, -0.274536, 
	-0.013888, -0.007525, 0.563536, -1.381430, -0.642852, -0.001709, 0.466652, -0.008284, -0.004200, 2.486526, -6.275990, -0.001838, 5.801307, -0.314888, -0.479830, -0.185588, 
	-0.005694, -0.003022, 0.008283, -1.140582, -2.727805, -0.000887, 0.788586, -0.006611, -0.002410, -0.286169, 0.224402, -0.000892, 2.865384, -0.440372, 0.768317, -0.040530, 
	-0.038945, -0.006247, -0.419611, -0.783911, 0.501736, -0.002345, 4.170271, -0.008112, -0.004394, 1.283508, 0.493000, -0.006737, -4.583693, 0.444011, -0.987438, -0.051093, 
	-0.097994, 0.144608, 6.363720, -1.419284, 2.221474, -0.014534, 1.274822, -0.169160, -0.035664, -0.899686, -2.607996, -0.014596, -3.734292, 3.801986, -4.223675, -0.589730, 
	-0.109930, 3.815504, 1.187061, -3.181448, -0.377005, -0.022814, -3.815001, -3.358120, -0.043305, 1.336800, -2.366463, -0.023900, 5.214610, -2.784639, 5.560014, -1.031364, 
	-0.006020, -0.007585, -0.722931, -0.773522, -2.121546, -0.000726, 1.446312, -0.006493, -0.002586, -0.887049, 7.487014, -0.000850, -4.259271, -0.665162, 0.554658, -0.034244, 
	-0.028294, -0.010351, -0.914823, -0.169680, 2.249880, -0.001814, -2.920603, -0.016556, -0.005392, -0.702172, -1.962950, -0.002038, 3.477336, 2.031871, -0.838569, -0.185845, 
	-0.016065, 0.034174, 0.184748, 2.172769, -0.384909, -0.001411, 1.263484, -0.042937, -0.006716, -2.079793, -0.312620, -0.001904, -1.600555, -1.240932, 2.062054, -0.029386, 
	-0.024152, 0.027730, 4.035305, -0.711491, -2.908999, -0.004557, -1.443813, -0.025908, -0.007063, 1.253225, -1.947028, -0.004651, 1.290927, 1.415529, -0.802834, -0.142221, 
	-0.022913, -0.014363, 1.750418, -1.136855, 1.068098, -0.004036, -3.434317, -0.017343, -0.008472, 1.826054, 0.214975, -0.004199, 3.277734, -2.055455, -1.235783, -0.203541, 
	-0.078111, -0.037490, -0.646287, 0.248439, -0.733190, -0.007732, -2.263561, -0.066383, -0.018347, -0.163895, -1.344110, -0.006733, 2.829833, 3.313290, -2.008968, 0.983246, 
	-0.151885, 2.852297, -0.595641, -0.056502, 5.765157, -0.015864, -0.732698, -2.779964, -0.028059, 0.560802, -1.818584, -0.145776, -2.068259, -1.845316, 2.345311, -1.285022, 
	-0.011246, 0.007200, 4.030705, -2.585750, 1.099726, -0.001819, -0.883884, -0.016746, -0.004031, 0.606478, -3.729075, -0.001950, 0.100287, -0.751263, 2.342866, -0.201500, 
	-0.057265, -0.014790, 2.292617, -1.974048, -2.031698, -0.002636, 0.218172, -0.015764, -0.007496, 1.496089, 2.167166, -0.002968, -1.056586, 0.432597, -1.257560, -0.185831, 
	-0.003325, -0.001265, 0.058218, 0.749150, -0.242829, -0.000410, -0.088592, -0.000784, -0.000672, -0.203352, 0.065344, -0.000426, -0.162902, -0.221469, 0.061801, -0.008489, 
	-0.002547, -0.002509, -0.083022, 1.655814, 0.492894, -0.000611, -2.502001, -0.002923, -0.001354, 0.073216, -1.604735, -0.000650, 2.102406, -0.431142, 0.346986, -0.039824, 
	-0.006190, -0.003642, -0.199786, -0.054388, 0.015669, -0.001322, 0.171046, -0.004889, -0.002720, 0.445119, 1.051273, -0.001466, -0.764643, 1.230772, -1.851982, -0.022852, 
	-0.073634, -0.047514, 1.397356, -0.574965, -0.068536, -0.011456, 0.864666, -0.055838, -0.026656, 1.819918, -3.234991, -0.019364, 4.054848, -3.467967, 0.105278, -0.661147, 
	-0.004942, -0.004310, -0.041212, 0.493870, -0.830080, -0.001057, 0.699305, -0.007957, -0.003090, 0.691795, 1.548700, -0.001159, -2.454618, -0.327015, 0.278953, -0.037184, 
	-0.014707, 0.000017, 0.064640, -0.136946, -2.743902, -0.001069, 7.802109, -0.007877, -0.002714, -0.485767, -4.599421, -0.001107, -0.606319, -0.732915, 1.674257, -0.208280, 
	-0.103400, 0.241324, 0.148366, 1.928123, -0.707246, -0.004574, 8.914549, -0.094650, -0.009584, -0.099138, -1.021783, -0.004743, -4.465110, -2.353852, -2.177472, -0.190810, 
	-0.053201, -0.024897, -3.276919, 1.507580, -1.869724, -0.005972, -0.363960, -0.025022, -0.014100, 5.365042, -2.490815, -0.007006, -0.264207, 1.404582, 0.465335, -0.346719, 
	-0.108267, -0.033556, -2.565979, 0.595705, 5.532404, -0.017657, -0.690502, -0.062714, -0.030810, 2.243980, 3.857384, -0.147602, -5.530152, -1.661632, -0.246190, -1.134411, 
	-0.004089, -0.000980, 0.119050, -0.068739, 1.079083, -0.000264, 1.542908, -0.001168, -0.000605, -0.077851, -4.857101, -0.000283, 2.444988, -0.098428, -0.058229, -0.018293, 
	-0.026270, -0.014699, -0.201863, 0.041265, 0.671597, -0.004526, -0.325965, -0.022703, -0.009661, 0.247431, 1.399015, -0.004878, -0.174033, -1.418294, -0.468485, 0.312067, 
	-0.013456, -0.011756, -1.508073, 1.367314, -2.532413, -0.001724, 3.672834, -0.011466, -0.004208, -2.153582, 0.487506, -0.001878, -2.550201, 5.107599, -1.730734, -0.115763, 
	-0.030203, -0.007313, -0.362067, -0.728998, 1.939634, -0.001847, -0.547882, -0.077379, -0.006848, -0.820801, 4.122730, -0.002088, 1.204292, -2.144703, -2.471361, -0.065165, 
	-0.007993, -0.005966, 0.016132, 1.091103, 0.861294, -0.000829, -1.462501, -0.003988, -0.002409, 0.908455, 0.274605, -0.000884, 1.221312, -1.740523, -1.128178, -0.019630, 
	-0.030516, 0.638835, 0.083299, 4.014958, -1.455932, -0.004582, 2.099458, -0.679639, -0.009361, -1.848604, -0.737173, -0.004943, 1.263336, -3.425490, 0.266627, -0.170275, 
	-0.052893, -0.002118, -0.782805, -0.018998, 0.116471, -0.004242, 2.670633, -0.043325, -0.011480, -1.470517, 0.345664, -0.004841, 3.035604, -1.323828, -2.156981, -0.296343, 
	-0.007389, -0.001065, 0.306273, -0.042702, -0.493657, -0.000257, 3.452907, -0.001023, -0.000631, -0.504216, -0.623240, -0.000245, -2.403711, -0.049460, 0.389021, -0.020606, 
	-0.008652, -0.005887, 2.279282, -0.070482, 1.603669, -0.002567, -1.053747, -0.014427, -0.004877, 0.847994, -2.854699, -0.002675, -1.124714, 0.467873, 0.005559, -0.061652, 
	-0.077142, -0.020862, 3.064453, -1.560518, -0.174869, -0.002744, -0.119905, -0.060053, -0.012603, 1.819562, -0.720499, -0.003398, 1.365239, -1.489138, -2.408319, 0.400799, 
	-0.017324, -0.005118, 0.764105, -0.896797, 1.314406, -0.001097, 1.823140, -0.016915, -0.002366, -1.270683, -0.624053, -0.001093, -1.995328, -0.328931, 0.427611, 0.830445, 
	-0.200613, -0.053009, -0.285318, -2.878684, 5.264478, -0.017667, 5.226983, -0.071686, -0.032721, -5.324773, 1.931099, -0.018229, -2.385948, -1.934256, 1.225277, -0.444934, 
	-0.045373, 0.547972, 2.260331, -0.180067, 4.220788, -0.002838, -3.626179, -0.086776, -0.006040, 0.198295, 0.150344, -0.003048, -3.296295, -0.005255, -0.037283, -0.088575, 
	-0.022073, -0.018020, 0.156408, 0.179588, -1.909672, -0.004641, -2.966315, -0.014038, -0.009775, -1.088717, 0.678653, -0.005192, 2.249846, 0.829076, 2.137325, -0.192452, 
	-0.014975, -0.010502, -0.534083, -0.013760, -2.239347, -0.000804, 2.465373, -0.006559, -0.003157, -0.644425, 2.217071, -0.000890, -2.480370, 1.618181, -0.127013, -0.224738, 
	-0.003320, -0.002779, -0.059646, 0.787894, -0.524315, -0.000433, 2.305218, -0.002538, -0.000798, -0.365601, 0.219682, -0.000444, -1.948841, -0.208389, -0.171428, -0.024262, 
	-0.035581, -4.172244, 3.704910, 1.424138, 0.139607, -0.009769, 3.400111, 4.359124, -0.018446, -3.406381, -2.170908, -0.010304, -2.539222, 0.892548, -1.423096, -0.134488, 
	2.291177, -0.029656, 1.289690, -0.432691, -0.221659, -0.007870, 2.246287, -0.046284, -0.018252, 1.289475, -5.478770, 0.015791, -1.623156, -1.515077, 2.546124, -0.305129, 
	-0.004501, 0.000853, -1.729303, 1.298096, 1.803456, -0.001096, -1.020309, -0.025837, -0.004561, 0.162334, -1.019265, -0.001426, -1.328270, 1.368791, 0.628344, -0.127306, 
	-0.084711, -0.023709, -2.487969, 1.818289, -1.020806, -0.006620, 2.416060, -0.065744, -0.014937, 0.541719, -0.629904, -0.007113, -1.920263, 2.344700, -0.599115, -0.259879, 
	-0.040550, 0.363777, -0.994480, 3.424341, -2.425539, -0.005933, 1.688717, -0.060312, -0.015041, -2.017080, 3.795012, -0.006327, -5.043008, 1.319314, 0.343413, -0.326305, 
	-0.072875, -0.050924, -3.208193, -1.180058, -2.458495, -0.014551, 1.663290, -0.058771, -0.030910, -1.752040, 1.246574, -0.015266, -0.634010, 2.172387, 4.969851, -0.576007, 
	-0.270587, -0.081795, -0.891106, 2.450750, 3.106156, -0.021795, 0.522876, -0.154526, -0.055193, -3.869304, -1.351727, -0.024228, 2.758796, -2.933948, 0.910824, -0.095193, 
	-0.008589, -0.007275, -0.255704, -1.393568, 3.123437, -0.000795, 0.891015, -0.003002, -0.002204, -0.163052, -2.490426, -0.000837, -1.281663, 0.326795, 1.316323, -0.050455, 
	-0.043143, 0.051752, -2.327678, 0.225040, -3.817137, -0.009042, -2.803036, -0.035139, -0.017725, 16.227983, 3.414714, -0.009315, -8.076559, -2.772135, 0.239596, -0.248177, 
	-0.033763, -0.024021, -0.996688, 2.861710, -2.199575, -0.004347, -1.035070, -0.029349, -0.011001, 2.250022, -2.991124, -0.004831, 2.351715, -1.948626, 0.317273, 1.497676, 
	-0.020828, -0.009205, -1.153528, 0.429474, -2.092627, -0.002780, 0.194391, -0.014559, -0.006416, 2.012924, -2.310153, -0.002887, 4.036356, -0.057487, -0.941142, -0.061533, 
	-0.033538, -0.009880, 7.949339, -0.237461, 0.547132, -0.003656, -0.586750, -0.012040, -0.007450, -3.104664, -1.389592, -0.003818, -0.857317, -1.190909, -0.954132, -0.105264, 
	-0.006312, -0.000805, 0.620725, 0.921653, -0.073600, -0.000709, -1.492747, -0.008970, -0.006952, -0.565084, 0.034131, -0.000713, 0.227388, -0.294538, -1.064860, 1.711392, 
	-0.024021, -0.023764, 0.559679, 0.645548, -0.413762, -0.002262, 2.045722, -0.010351, -0.005266, -0.585868, -1.083688, -0.002781, -0.988421, 0.392740, -0.425968, -0.077540, 
	-0.470281, -0.022773, 2.393681, -3.120346, -0.896648, -0.095689, -14.947359, -0.400622, -0.153798, -5.247145, 7.368313, -0.111817, 0.676939, 19.603863, -2.866865, -1.709451, 
	-0.340322, 0.110375, -2.505180, -3.653096, -4.505970, -0.041487, 1.718273, -0.268567, -0.098469, -1.868575, 5.578194, -0.047871, 4.614657, 0.220113, 1.746455, -0.658532, 
	-0.028039, -0.018477, -0.525016, 0.413137, -0.432586, -0.003678, 1.453013, -0.026429, -0.009960, -1.243218, -0.889791, -0.003560, 1.601559, -2.807254, 2.888916, -0.368618, 
	-0.020658, -0.011473, 0.879251, 2.660043, -1.592402, -0.003890, 0.073676, -0.032611, -0.009280, -3.755506, -0.785169, -0.004563, 3.821446, -0.840858, -0.225034, -0.152973, 
	-0.017042, -0.010633, 11.869532, -8.537408, -0.127946, -0.007123, 0.765244, -0.016655, -0.009222, -6.653948, 5.370934, -0.007151, -4.968021, -0.826305, 2.697044, 0.478702, 
	-0.005057, -0.004216, -2.892316, 0.787439, -0.789653, -0.001542, 0.274773, -0.010672, -0.003234, 2.283575, -1.762145, -0.001612, 2.214985, -0.434151, 0.410811, -0.066986, 
	-0.005076, -0.004639, 1.771737, -0.930634, -0.317871, -0.001860, -0.831679, -0.005456, -0.003354, -2.525355, 4.046739, -0.001960, -1.866405, -0.738634, 1.444753, -0.030303, 
	-0.006448, -0.008657, -0.006794, 0.506559, 0.867490, -0.002138, 0.179804, -0.011587, -0.006312, -0.915504, -0.672185, -0.002772, -1.353283, -1.239067, 2.731121, -0.060228, 
	-0.002705, -0.005018, -0.232393, 0.187855, -0.199697, -0.001015, 1.668672, -0.003749, -0.002378, -0.793195, 0.113238, -0.001094, -1.649636, -0.442302, 1.402911, -0.039494, 
	-0.029576, 0.811892, -1.281632, 0.377878, 3.718477, -0.003925, -0.842357, -0.824404, -0.009715, 3.994001, -3.014420, -0.004126, -3.459618, 1.628180, -0.855775, -0.204878, 
	-0.012572, -0.006226, -2.375516, 2.058851, -0.861888, -0.002181, -1.824042, -0.008214, -0.004574, 0.503748, -2.945175, -0.002315, 5.236406, 0.362152, 0.221031, -0.339486, 
	-0.006753, -0.004334, 0.845472, 1.120622, -2.370626, -0.001666, 0.113712, -0.008751, -0.003212, -0.444151, 1.942574, -0.001640, -0.437573, -0.518008, -0.425769, 0.200104, 
	-0.011865, -0.006039, -1.010348, -1.877258, 0.583173, -0.001614, -1.164896, -0.006703, -0.003384, 0.472010, 3.548331, -0.001676, -4.343996, 0.956822, 2.954508, -0.087065, 
	-0.029137, -0.016020, -3.854331, 3.316305, -1.437553, -0.005479, -0.479391, -0.025110, -0.011166, -2.522285, -0.083304, -0.005516, 1.130330, 1.268693, 2.867485, -0.113522, 
	-0.010334, -0.008690, -1.814607, 3.436021, -1.608443, -0.003307, -1.112817, -0.012319, -0.006370, 1.450673, -1.433484, -0.003465, -0.674533, -0.148313, 2.007210, -0.057221, 
	-0.112209, 0.742317, 4.669653, -1.571547, -5.396231, -0.014908, 1.435636, -0.785579, -0.029474, -0.305415, -1.349321, -0.020173, 3.496388, 0.231256, -1.403032, 0.412639, 
	-0.013451, -0.002024, 0.160401, -0.121842, 1.272384, -0.001210, 0.667106, -0.023256, -0.001892, -0.462075, -0.742119, -0.001195, -1.002665, -0.294624, 0.583365, -0.016903, 
	-0.023847, -0.007056, 1.359835, -0.663418, -3.050247, -0.002325, -1.956089, -0.005979, -0.004753, -0.618561, -0.286037, -0.002384, 3.568995, 1.911733, -0.141759, -0.078108, 
	-0.075269, -4.956497, -2.140891, -1.478144, 0.754088, -0.013398, -0.813895, 4.794078, -0.036095, 1.753603, -0.430363, -0.014998, 2.046160, -1.370922, 2.935523, -0.952982, 
	-0.103884, -0.025053, -0.200563, -0.858829, 2.853776, -0.007594, 4.972250, -0.079327, -0.022062, -1.427593, 1.033364, -0.013069, -0.904027, -2.747138, -4.187328, 1.717079, 
	-0.080643, -0.009681, -1.031893, -1.532572, 8.570721, -0.002193, -2.951059, -0.023498, -0.006497, 0.831321, -0.888796, -0.002447, 0.024558, -2.030339, -0.793011, -0.073971, 
	-0.004115, -0.003131, -0.685122, -0.283665, -0.136921, -0.001001, -1.629780, -0.003976, -0.002204, 2.251078, 2.118059, -0.001101, -1.175634, 0.736710, -1.392942, 0.213743, 
	-0.001261, 0.061675, 0.010234, -0.021434, -1.044788, -0.000528, -0.037051, -0.054281, -0.000658, 0.987918, 0.217122, -0.000534, -0.242920, -0.036667, 0.174067, -0.010894, 
	-0.006455, -0.002331, -1.137628, -0.416746, -0.576658, -0.000649, -0.282904, -0.002372, -0.001283, 1.990993, 1.127740, -0.000720, -0.986501, 0.331666, 0.047156, -0.083307, 
	-0.004765, -0.003676, -0.899828, 0.004340, -0.289490, -0.001107, -0.096128, -0.003879, -0.002189, 2.797104, -3.349714, -0.000980, 1.597011, 0.455849, -0.115151, -0.087398, 
	-0.008349, -0.003662, -0.931561, 0.797318, 0.177153, -0.001021, -1.660419, -0.004741, -0.002539, 1.538820, -4.633706, -0.001406, 4.220697, 0.114660, 0.467787, -0.069030, 
	-0.029684, -0.006955, 0.419683, 1.243881, -1.261262, -0.001708, 1.978624, -0.008979, -0.005112, -0.668844, -7.118613, -0.001913, 4.364408, 1.273966, 0.169196, -0.346688, 
	2.084565, -0.051253, -0.680673, -1.257659, 0.418856, -0.027786, -3.244323, -0.105861, -0.046493, -4.866422, 4.065808, -0.033487, 9.644301, -2.125962, -2.154356, -1.619257, 
	-0.059047, -0.021680, -2.025815, -3.573963, 2.620624, -0.004001, -3.706440, -0.046808, -0.011486, -1.849553, 12.970986, -0.004360, -1.361710, -1.122450, -1.591134, -0.213164, 
	-0.023022, -0.003219, -1.160744, 0.756724, 1.009408, -0.001789, -2.584583, -0.007702, -0.003260, 1.204226, 1.875346, -0.001783, -1.409908, 0.601761, -0.229453, -0.022004, 
	-0.075250, -0.008876, 0.625318, -0.639475, -2.881104, -0.001477, -0.781224, -0.011755, -0.004628, 0.360869, 3.363037, -0.001849, 1.811280, -1.311712, -0.392072, -0.051081, 
	-0.009847, -0.006039, -0.778917, 2.960854, -1.348672, -0.001744, 8.066856, -0.007074, -0.003976, -1.022534, -2.481657, -0.001371, -5.630315, 1.034146, -0.701701, -0.068012, 
	-0.304224, -0.102637, -3.154843, 1.576579, 4.064747, -0.034400, 0.997832, -0.271942, -0.059699, -0.497578, -0.900802, -0.045041, -4.127013, 1.770700, 2.858806, -1.770485, 
	-0.008626, -0.006906, 3.787911, -0.625686, -3.654051, -0.001802, 1.003689, -0.008714, -0.004688, -0.743514, 9.961424, -0.001940, -8.714880, 0.471189, -1.371948, -0.081458, 
	-0.002324, -0.001977, 0.851342, 0.157886, -0.995364, -0.000521, 0.270666, -0.002712, -0.001099, -0.539869, -1.142253, -0.000560, 1.072503, 0.471570, -0.122951, -0.014337, 
	-0.003220, -0.002216, 0.077487, 1.530174, -1.462124, -0.000457, 1.906247, -0.001592, -0.001099, -0.604183, -2.639570, -0.000494, 1.845079, -0.271510, -0.367673, -0.004849, 
	-0.002627, 0.006035, 0.302507, -0.168088, -0.473856, -0.000947, 0.344799, -0.010692, -0.001906, 0.802443, -0.643102, -0.001071, -0.784410, 0.205594, 0.437073, -0.011751, 
	-0.005361, -0.004477, -0.830022, -2.112492, 0.291200, -0.003009, 0.007908, -0.004850, -0.003752, -0.056312, -0.017379, -0.003050, -0.068135, 1.597259, 1.248905, -0.036434, 
	-0.066016, -0.056084, -0.025673, 1.423223, 3.225004, -0.007759, -2.781571, -0.038583, -0.019018, 1.542112, 2.401247, -0.008231, -4.757286, 0.533088, -0.743154, -0.621301, 
	-0.002161, -0.003780, -1.225430, 0.357761, 1.464345, -0.000489, -0.103726, -0.001397, -0.001064, 0.900790, 1.520028, -0.000479, -2.572306, 0.014917, -0.337272, -0.009738, 
	-0.013879, -0.015772, 5.071206, -2.872662, 1.766711, -0.002818, -2.972931, -0.014821, -0.006801, 3.181707, -1.286254, -0.003030, 1.145549, -2.570003, -0.574710, -0.831492, 
	-0.004661, -0.005693, -0.476331, 0.511559, -1.439801, -0.001938, -0.372527, -0.004437, -0.003426, 0.650395, 3.675910, -0.002030, -3.511846, 1.468762, -0.455965, -0.027973, 
	-0.012143, -0.005480, -0.572900, -1.216585, -4.094261, -0.001606, 1.807153, -0.007560, -0.003483, 1.530053, -4.319399, -0.001721, 5.638206, -0.804444, 2.130340, -0.066171, 
	-0.131413, -0.058836, 2.730524, -2.881149, -3.470401, -0.008268, 3.987779, -0.098592, -0.028131, -1.826226, 0.526927, -0.009374, 3.207929, -0.167294, -1.179097, -0.594381, 
	-0.002822, -0.000703, -0.252492, -0.570165, 0.353974, -0.000827, 0.146514, -0.004322, -0.001673, -0.471429, -0.158339, -0.000898, 0.624014, -0.531967, 0.878962, -0.007827, 
	-0.021863, -0.013131, 0.383911, -2.220525, 0.831885, -0.005333, -1.427266, -0.015363, -0.008937, 4.320020, 0.735862, -0.005469, -3.900967, -1.096433, 2.558950, -0.115342, 
	-0.104094, -0.018642, -2.270498, 1.690247, -2.867711, -0.004324, 2.566052, -0.020404, -0.010878, 1.254995, -2.004416, 0.044120, 1.555752, 0.076963, 0.293889, -0.181050, 
	-0.001728, -0.001288, -0.230212, 2.255865, -0.373216, -0.000604, 0.200326, -0.001847, -0.000952, -1.308992, -0.283156, -0.000617, -0.489338, -0.063544, 0.293698, 0.005606, 
	-0.002802, -0.002708, 0.306608, -0.286372, 1.549763, -0.000830, -1.434392, -0.002154, -0.001664, -0.640139, -1.783517, -0.005212, 2.885919, -0.535253, -0.021803, -0.025444, 
	-0.003961, -0.002320, 0.294507, 0.090910, -2.770148, -0.000796, 1.515999, -0.002850, -0.001464, -0.674011, 1.092903, -0.000847, -0.639254, -0.451958, 1.633615, -0.080326, 
	-0.091614, -0.010172, -1.030129, -0.781743, 0.531971, -0.001478, 3.690151, -0.007042, -0.004501, -0.718459, 2.495279, -0.001608, -2.555354, -0.724824, -0.764384, -0.026094, 
	-0.015559, -0.014863, -1.801744, -0.542340, -1.299509, -0.002435, -1.490122, -0.009498, -0.006015, 2.697141, 0.837655, -0.002617, 3.517015, -0.041514, -1.736406, -0.089190, 
	-0.004233, -0.002555, -0.664079, -0.726622, -0.255443, -0.000662, -0.757863, -0.002717, -0.001719, 0.686431, 0.721452, -0.000689, 2.318478, -0.601038, -0.680668, -0.028073, 
	-0.108289, 0.107328, 1.628696, -2.664752, -0.886530, -0.029466, 1.654415, -0.199730, -0.062368, 1.414505, -2.427256, -0.033129, -2.096544, 1.984550, 2.580044, -0.861475, 
	-0.007440, -0.004792, -1.620895, -3.362820, 0.898128, -0.001710, 3.168648, -0.005761, -0.003160, 1.180428, 0.255131, -0.001792, 0.068482, -0.552571, 0.029037, -0.038912, 
	-0.019412, -0.002895, -0.882301, 1.807905, -0.206732, -0.000966, 0.599431, -0.003355, -0.001841, -1.164949, -1.347785, -0.000998, 0.974236, -0.377500, 0.636998, -0.009836, 
	-0.019690, -0.012731, -1.437583, 0.884042, -0.701799, -0.004975, 0.901476, -0.056617, -0.011942, -3.182198, -2.323442, -0.011762, -0.329997, 4.245295, 2.524067, -0.462143, 
	-0.191471, -0.094698, 1.546916, 4.827160, 0.885264, -0.048202, -1.531267, -0.154620, -0.076356, 0.374407, 0.220492, -0.183157, -2.642547, -0.097975, -2.156672, -0.677273, 
	-0.060550, -0.015377, -1.476774, -1.966901, -1.948199, -0.007401, 5.944946, -0.034708, -0.016084, 2.387289, 2.618627, -0.007749, 1.835906, -2.953725, -3.818124, -0.481177, 
	-0.001653, -0.000508, 2.051702, -0.718343, -0.158598, -0.000251, -0.438845, -0.006329, -0.000478, -1.303657, 0.537434, -0.000256, -0.410419, -0.077128, 0.530148, -0.002820, 
	-0.203666, -0.059916, -3.240006, -1.571493, -2.038531, -0.017800, 1.587823, -0.077386, -0.040231, -0.771876, 5.781092, -0.027565, 5.340934, -3.198913, -0.633823, -0.828643, 
	-0.082990, -0.018957, 3.238297, 1.850738, -3.094523, -0.011389, -2.182580, -0.017905, -0.015214, 4.601698, -0.172537, -0.011824, -0.195882, -2.436047, -1.401850, -0.049034, 
	-0.001002, -0.001159, 0.143649, 0.673718, -0.282687, -0.000248, 4.362826, -0.001246, -0.000592, -0.335809, -2.058638, -0.000261, -2.383895, -0.064543, -0.046092, -0.004020, 
	-0.252182, -0.032387, 6.104506, 3.928439, 1.358795, -0.009669, -4.871106, -0.066734, -0.021265, 0.230447, -0.559428, -0.010314, -0.472663, -1.945957, -3.205349, -0.175132, 
	-0.074384, -0.020683, -1.885286, 2.466487, -2.240484, -0.004631, -1.242908, -0.042125, -0.012578, 0.588538, 2.864478, -0.005049, -1.075551, -0.682922, 1.699697, -0.332597, 
	-0.064152, -0.013758, 3.257989, 0.975720, -0.120326, -0.001886, -0.269171, -0.034237, -0.008753, 3.034283, -0.617389, -0.002393, -1.179155, -1.925989, -2.463378, -0.567405, 
	-0.058745, -0.022813, -0.358826, 4.271652, -3.977493, -0.005839, -3.354714, -0.041003, -0.014542, 0.695699, 4.206206, -0.135810, -1.266721, 3.096161, -2.752541, -0.280671, 
	-0.008570, -0.005794, -1.116164, 3.079110, 4.582697, -0.001439, -1.012770, -0.008344, -0.004029, 0.070583, 0.627348, -0.001637, -2.914064, -1.562167, -1.648038, -0.076721, 
	-0.014229, -0.006485, 0.636165, 0.516780, -0.944339, -0.001623, 1.630578, -0.010663, -0.004699, 2.302351, -2.556946, -0.001781, 0.080604, -2.944629, 1.375127, -0.056213, 
	-0.003421, -0.001841, 1.301227, -0.029981, -1.007587, -0.000925, 1.782824, -0.004130, -0.001510, -0.493028, -1.419845, -0.000923, 0.430913, -0.430414, -0.100891, -0.020467, 
	-0.004852, -0.006135, 1.967908, -0.118732, -0.722741, -0.001207, -0.918592, -0.007393, -0.003744, -1.156224, -0.767552, -0.001381, -0.655399, 1.668595, 0.755142, -0.027693, 
	-0.190135, -0.022061, -3.145651, -2.504985, 12.252068, -0.008460, 2.073496, -0.026406, -0.014442, 0.200814, -6.266371, -0.008794, 0.229485, -2.708227, -1.322972, 1.462641, 
	-0.009150, -0.005911, 0.875836, -0.120242, -0.265652, -0.001939, -0.026010, -0.006753, -0.004197, -0.657680, 5.021437, 0.047153, -3.474353, -1.126215, -0.203464, -0.042860, 
	-0.064161, -0.012007, -0.450547, 2.880148, 0.046277, -0.003550, -1.251331, -0.050069, -0.008775, -2.982016, -1.063920, -0.003818, 2.080908, 0.577318, 0.446685, -0.141142, 
	-0.006834, -0.002335, -0.006166, -0.279361, 0.570137, -0.000968, -2.099419, -0.001912, -0.001610, -0.119460, 2.538903, -0.001028, -0.214494, -0.591724, 0.235680, -0.019410, 
	-0.015991, -1.389821, -1.704432, 1.102037, -0.427738, -0.002041, -1.618905, 1.370762, -0.007347, -0.796257, 6.803109, -0.002443, -2.257552, -0.147760, -0.881250, -0.024371, 
	-0.063233, -0.019898, 0.155202, 0.204751, 1.492068, -0.006085, -2.329895, -0.029503, -0.013966, 1.815972, -1.592173, -0.006468, -2.067988, -1.874899, 4.355750, -0.019633, 
	-0.024527, -0.018059, 3.058800, -0.393189, 0.658786, -0.005403, 2.770220, -0.025893, -0.010939, 1.134260, -1.140100, -0.005475, -3.092896, -0.729863, -1.978726, -0.196997, 
	-0.158247, -0.022431, 0.882240, -1.703907, 1.023084, -0.002130, -2.702914, -0.013556, -0.006654, 0.597293, 17.161552, -0.002396, -10.331988, -1.887817, -2.541484, -0.290646, 
	-2.699124, -0.150900, -1.292783, -1.947530, -1.928521, 15.849707, -0.349136, -0.163746, -0.126906, 0.627150, 2.922658, -2.532511, -3.698761, -0.781660, -0.759971, -2.967964, 
	-0.063947, -0.040935, -2.116104, -0.191421, 1.360319, -0.006934, -0.592778, -0.059108, -0.026488, -1.259737, 2.555641, -0.007690, -2.212520, 1.456784, 1.942040, -0.737123, 
	-0.004938, -0.001180, 1.091011, 0.457442, -0.143023, -0.000269, -0.852965, -0.001291, -0.000674, -0.282232, 1.292053, -0.000287, -1.405017, -0.200283, 0.055183, -0.003530, 
	-0.024806, -0.011197, -0.886650, -3.806464, -0.069280, -0.003150, 0.723421, -0.015363, -0.007514, -0.871027, 4.048530, -0.003334, 0.346794, 1.141343, -0.459591, -0.101712, 
	-0.010245, 0.003744, 0.139197, 0.289799, 1.725253, -0.001331, -2.513016, -0.015448, 0.011727, 0.326772, -0.898256, -0.001334, 1.201877, 0.143313, -0.307133, -0.094916, 
	-0.024709, -0.016619, -0.464020, 1.003065, -0.760179, -0.007066, -4.528221, -0.064759, 0.361292, -1.174187, 1.733960, -0.007940, 0.787581, 0.524689, 1.433650, 1.203463, 
	-0.001750, -0.000537, 0.136304, -0.067440, 0.142347, -0.000246, 0.109194, -0.000706, -0.000391, -0.202142, -0.073311, -0.000251, -0.331631, 0.240445, 0.055485, -0.005370, 
	-0.007383, 0.178913, 1.149474, -3.956292, -0.675682, -0.001121, -0.703573, -0.183078, -0.002346, 1.924748, -1.264916, -0.001184, 4.078629, -0.138756, -0.363930, -0.033502, 
	-0.047720, -0.014786, 2.363503, -0.781314, -3.791392, -0.003161, -2.195188, -0.017684, -0.008491, 0.418914, 9.466105, -0.003680, -0.475055, -3.131495, -1.467816, -0.310740, 
	-0.031557, -0.005179, 0.885947, 0.416852, -1.210126, -0.001311, 2.234011, -0.008616, -0.003627, -1.249838, 0.943110, -0.001370, -0.965890, -0.643048, -0.320815, -0.038543, 
	-0.004497, -0.007570, -1.058764, -0.373269, -1.340803, -0.001133, -1.872676, -0.010321, -0.003798, -0.967787, 2.486582, -0.001283, 1.665347, -0.386011, 1.928599, -0.052616, 
	-0.001510, -0.001223, -1.359331, -2.515741, 0.350386, -0.000289, 1.340681, -0.000811, -0.000704, -0.340248, 4.398047, -0.000311, -1.520921, -0.067635, -0.262851, -0.017539, 
	-0.010430, -0.007684, -3.232483, 2.630029, 0.345264, -0.005399, -2.526278, -0.022976, -0.006596, -0.406513, -4.116855, -0.005513, 2.482994, -2.169044, 7.198870, -0.147386, 
	-0.005879, -0.006575, -0.914941, -1.162115, 1.366755, -0.001428, -4.454463, -0.011186, -0.004005, 0.644565, -1.827039, -0.001581, 6.770321, -0.245781, -0.093455, -0.053196, 
	-0.005370, -0.002369, -0.151526, 1.708363, -0.010496, -0.001300, 1.068603, -0.003788, -0.001883, -1.563931, 0.363220, -0.001287, -3.527683, -1.317577, 3.425566, 0.021459, 
	-0.025549, -0.006873, 4.158285, 2.234694, -0.671118, -0.001927, 0.075476, -0.010675, -0.004537, -1.235038, -1.781595, -0.002076, -1.182874, -1.408949, -0.111850, -0.025394, 
	-0.036201, -0.014978, 0.455538, 2.385339, -2.304397, -0.005392, -1.383673, -0.020280, -0.010411, 4.393351, 1.993381, -0.005609, -0.221043, -3.055641, -2.033624, -0.136361, 
	-0.011758, -0.007014, 0.561624, -1.011461, 2.976930, -0.002815, -1.810776, -0.006357, -0.004834, 1.522157, -1.385773, -0.003047, -0.658888, -1.588300, 1.875866, -0.445553, 
	-0.078593, -0.007807, -1.346374, -1.669536, 5.100461, -0.002373, -3.370730, -0.022196, -0.004786, 0.544581, 6.519572, -0.002457, -6.083425, -1.246371, 1.729077, -0.059044, 
	-0.024194, -0.008791, 2.179788, -1.144177, 2.674555, -0.004946, 0.498291, -0.042912, -0.006811, -0.265453, -2.009578, -0.005073, -0.961401, -0.677842, -0.105380, -0.096075, 
	-0.033625, -0.015240, 2.978461, 0.245463, -1.478135, -0.002360, -0.612835, -0.030159, -0.008966, 2.986730, -1.437528, -0.002841, -2.367090, 0.303982, -0.336315, -0.189543, 
	-0.018046, -0.007772, 0.570795, -1.275667, -0.896934, 0.191088, 1.857751, -0.015522, 0.008368, -2.161363, -1.479510, -0.003720, 2.672887, -0.391977, 1.152418, -0.202797, 
	-0.260012, -0.063093, -0.566778, -2.655649, 0.959186, -0.021097, 4.620900, -0.128493, -0.044165, -0.938072, -0.138994, -0.024546, 7.628654, -3.559812, -2.954159, -1.853870, 
	-0.006489, 0.049759, 1.579688, -1.208275, -0.380546, -0.001469, -0.605117, -0.053060, -0.002578, -0.370525, -1.238011, -0.001466, 1.575100, -0.661152, 1.370038, -0.045896, 
	-0.016782, -0.012465, -1.490863, -2.378915, -0.108323, -0.001520, -1.681611, -0.020314, -0.003355, 9.127335, -5.934510, -0.001615, 1.024155, 0.969800, 0.258112, 0.270870, 
	-0.020887, -0.012647, -0.383274, 1.633813, -3.929363, -0.004169, 0.638142, -0.017052, -0.007844, -1.084525, 6.104086, -0.004348, -3.989376, -0.852923, 2.091587, -0.161218, 
	-0.006244, -0.004027, 1.064281, -1.515083, -0.189722, -0.001049, -0.911287, -0.003544, -0.002222, 0.220399, -4.354463, -0.001102, 5.984547, 0.303197, -0.419444, -0.164237, 
	-0.021582, -0.016586, -2.304915, -0.536000, 4.883985, -0.006398, 0.145153, -0.023597, -0.011661, 3.177660, -2.223009, -0.006840, -2.444106, -0.376431, -0.093514, -0.142158, 
	-0.036828, -0.021883, -2.586607, -0.491637, -0.176376, -0.003671, 0.492094, -0.016768, -0.009856, 2.368669, -2.787338, -0.003871, 2.048001, 1.977112, -0.591997, -0.159043, 
	-0.006920, -0.003126, -1.276652, 1.626277, -1.274974, -0.001194, 3.894748, -0.003951, -0.002259, 0.237751, -0.571424, -0.001238, -2.216960, 0.127398, -0.506606, -0.020871, 
	-0.004610, 0.253787, 0.476215, 1.328670, 0.883435, -0.001232, -0.222213, -0.083171, -0.002299, -0.396317, 0.531892, -0.001259, -2.466594, -0.529215, 0.357801, -0.124890, 
	-0.021868, -0.006961, 4.655131, 5.586268, 0.871781, -0.002431, -0.632955, -0.006744, -0.004177, -4.390007, -0.954203, -0.002528, -3.033120, -3.476604, 1.482517, -0.064097, 
	-0.021833, -0.014506, -1.163905, 5.802884, -0.928708, -0.005903, -0.434415, -0.020553, -0.010483, 3.272921, 0.094841, -0.006044, -2.262728, -3.033878, -1.148072, -0.119618, 
	-0.003009, -0.002085, 0.005415, -1.248195, 0.137768, -0.000640, 0.202476, -0.002893, -0.001445, 0.818908, -2.940707, -0.000742, 2.490692, 0.032223, 0.589197, -0.076962, 
	-0.008400, 0.006775, -1.022743, 0.258110, -1.070422, -0.000694, 2.815500, -0.009051, -0.001501, 0.546241, -0.571450, -0.000746, -1.078987, -0.111018, 0.282884, -0.034499, 
	-0.005821, -0.005984, -1.496385, -0.128750, -0.591639, -0.002878, 0.168011, -0.008918, -0.004677, 1.934552, -1.084388, -0.003016, -1.570644, 2.544492, 0.286705, -0.030659, 
	-0.007867, -0.009440, -0.323028, 1.949284, -1.805731, -0.002179, 4.736414, -0.007196, -0.004626, -1.399782, 3.239389, -0.131985, -7.492778, 0.682588, 0.673724, -0.096786, 
	-0.007074, -0.004263, -1.043772, -3.418668, -0.279385, -0.001531, -2.803878, -0.004921, -0.003013, 3.026670, -2.285720, -0.001621, 5.138131, 0.755428, 0.976571, -0.042955, 
	-0.130541, -0.064842, 0.388042, 3.685912, -1.377904, -0.012184, -2.348442, -0.100294, -0.032116, 2.785940, 4.767914, -0.013773, -3.613691, -1.869902, -1.145866, -0.918255, 
	-0.071849, -0.036922, -1.072948, -2.825707, -2.943184, -0.008807, -1.223142, -0.142734, -0.026053, 0.596291, -0.141817, -0.009440, 7.450487, -2.613034, 3.356124, -0.287263, 
	-0.014389, -0.004335, -0.116010, -2.899697, 2.570334, -0.001568, 0.927056, -0.004583, -0.003017, -0.588214, 1.054940, -0.001611, -0.879805, -0.284336, 0.310078, -0.064843, 
	-0.030480, -0.013580, 1.194214, -2.506468, -3.090335, -0.004342, -0.814357, -0.032681, -0.010139, 0.407615, 4.850376, -0.004461, 2.900712, 0.100980, -2.824586, -0.122468, 
	-0.004711, -0.001374, 0.807802, 0.446437, 1.193666, -0.000591, -1.854223, -0.001402, -0.000979, -0.626292, -0.155670, -0.000632, 0.892878, -0.579362, -0.074334, -0.041212, 
	-0.007009, -0.002182, -0.071373, 0.416953, 0.852041, -0.001012, 1.551853, -0.002053, -0.001409, -0.678123, -0.515903, -0.001105, -1.605415, -0.243779, 0.325103, -0.016587, 
	-0.013427, -0.009050, -0.262142, 0.409223, 2.276835, -0.004723, -1.769195, -0.010921, -0.006806, -0.576014, 3.449362, -0.005251, -2.511780, -0.608177, -0.168578, -0.189355, 
	-0.001234, -0.003633, -0.205836, -0.244410, -1.408083, -0.000369, 0.874795, -0.001449, -0.002729, -0.089781, -1.063443, -0.000391, 0.895250, 1.673418, -0.403122, -0.018984, 
	-0.001124, -0.002011, 3.019481, 0.229682, -0.786735, -0.000320, -0.053654, -0.005379, -0.001255, -2.964772, 1.363123, -0.000375, -0.406743, -0.425564, 0.041686, -0.006041, 
	-0.036957, -0.010500, -1.888733, 0.238738, -1.480468, -0.003248, 1.540621, -0.016471, -0.007584, -1.547528, -0.955323, -0.003598, 2.895430, 1.081274, 0.445743, -0.251397, 
	-0.305061, -0.113539, 1.532817, 1.739733, 2.296400, -0.035564, 3.568102, -0.181186, -0.078253, 1.623566, -7.854178, -0.296045, 2.690471, -4.525519, -0.954926, 0.893183, 
	-0.013857, -0.007663, 0.031771, -0.006612, 2.394472, -0.001399, -0.660555, -0.046562, -0.005007, 0.088519, -2.090310, -0.001430, 0.173127, 0.092729, 0.198472, -0.145694, 
	-0.017792, -0.017784, -1.950842, 1.357369, -3.513254, -0.004171, -3.253496, -0.025669, -0.009097, -0.421628, 0.930180, -0.004379, 0.829500, 0.646048, 5.754666, -0.299650, 
	-0.072997, 0.215855, 0.979056, -2.914644, -1.356181, -0.007349, 0.751245, -0.102465, -0.025618, -3.899433, 6.420872, -0.007179, 0.193601, -0.557678, -0.455935, 0.838850, 
	-0.030035, -0.009902, -2.875478, 0.461025, -0.869211, -0.003553, 2.310061, -0.019052, -0.007291, 0.306088, 1.043271, -0.003737, 0.292670, 0.467369, -0.797909, -0.264315, 
	-0.004495, -0.001791, -0.245538, -0.243221, 0.067931, -0.000588, -0.090187, -0.002110, -0.001183, 0.040330, -4.779250, -0.000613, 4.850647, 0.550418, -0.082138, -0.058211, 
	-0.026033, -0.005332, 0.435049, -1.609700, 3.705371, -0.001241, -0.214023, -0.003292, -0.002435, 0.283068, -3.251158, -0.001305, 2.069607, -0.963029, -0.333796, -0.081752, 
	-0.003906, -0.001050, -0.609105, -0.067431, -0.263586, -0.000377, -2.019635, -0.002335, -0.000759, -0.075230, -2.623811, -0.000379, 1.806732, 3.000838, 0.863283, -0.003249, 
	-0.011549, -0.009628, 5.741114, -2.356609, -0.131210, -0.001670, 3.129725, -0.011884, -0.005873, -1.246166, -3.826655, -0.001832, 1.782655, -1.675437, -1.319887, -0.055095, 
	-0.019097, -0.015336, -1.192062, -1.579840, -3.519479, -0.003526, -0.776297, -0.022482, -0.007369, -1.276373, 0.699470, -0.003731, 4.506950, 5.290359, -1.869166, -0.212020, 
	-0.004274, -0.005605, 0.898113, -0.033472, 1.884703, -0.000873, -0.093881, -0.007470, -0.012810, -1.161784, 0.050982, -0.000917, -1.122335, -0.291154, -0.065821, -0.033402, 
	-0.854415, -0.091425, 0.941317, 5.557363, 4.111398, -0.120494, -6.533475, -0.606739, -0.224252, 2.214183, 2.966077, -0.130391, 0.478005, -2.413013, -3.380765, -1.913373, 
	-0.117907, 0.010738, 2.428792, -3.162080, 5.228374, -0.006394, -2.487871, -0.050557, -0.016885, 3.943870, 1.882223, -0.006488, -4.996636, 0.153600, -2.319788, -0.482991, 
	-0.019367, -0.009876, -1.340173, -1.730977, -1.566704, -0.002353, 5.409682, -0.015830, -0.006189, 0.085338, -1.241175, -0.002602, 0.566301, -0.247647, 0.222418, -0.100846, 
	-0.047337, -0.028888, -1.659632, 9.842206, -4.441775, -0.007391, 0.177974, -0.028852, -0.015869, -2.671486, 0.877570, -0.007726, -6.383192, 4.272007, 0.626797, -0.504406, 
	-0.036847, -0.011648, 1.911804, -0.825754, -2.855190, -0.003777, -3.963567, -0.022128, -0.008103, -0.842176, 4.559873, -0.003994, -2.698519, 3.683405, 1.381540, -0.264918, 
	-0.133354, -0.037186, 1.692943, -3.647266, 1.426821, -0.012434, 2.105660, -0.046707, -0.023176, 0.185046, 5.625518, -0.021966, -6.006951, -3.275868, 1.719900, 0.449021, 
	-0.007368, -0.009752, -0.845289, 4.042245, -0.745150, -0.001984, -0.096329, -0.004496, -0.007531, 0.225304, -1.491287, -0.002037, -0.512731, -1.427264, 0.967511, -0.083844, 
	-0.133617, -0.033978, -1.171903, -0.974808, -0.065772, -0.009506, 1.390838, -0.035454, -0.019775, 1.235799, 2.627410, -0.010026, -3.406455, 1.852242, -0.840771, -0.404225, 
	-0.011421, -0.005638, -0.382476, -1.465616, 1.197996, -0.000751, 0.061420, -0.008508, -0.002906, 0.935511, 0.229667, -0.000830, -0.818200, 0.596240, -0.271725, -0.052763, 
	-0.215987, -0.027805, 0.490394, 0.375877, -1.817923, -0.008180, -2.309505, -0.033993, -0.017119, 1.199700, -0.303271, -0.008603, -3.166218, 4.094885, 1.923593, -0.175844, 
	-0.013655, -0.009445, 0.428374, 0.990698, -2.169872, -0.002496, -0.845850, -0.008563, -0.005481, -3.232963, -0.831497, -0.002630, 1.873386, 3.711327, 0.179460, -0.060793, 
	-0.038010, -0.017103, -1.459336, -0.523004, 1.855906, -0.005243, 4.181338, -0.016853, -0.010948, -2.782340, 0.877737, -0.005486, -2.066456, -0.659050, 1.227567, -0.558721, 
	-0.071763, -0.023034, 0.274613, 4.473751, -4.529226, -0.003805, 0.039988, -0.032608, -0.011048, -0.072143, -0.103583, -0.004283, 1.540460, -0.125755, -0.723453, -0.628110, 
	-0.004469, -0.000895, 0.392408, -1.358531, -1.484120, -0.000482, 0.641464, -0.006006, -0.000934, -0.346241, 1.297879, -0.000500, 1.068034, -0.072437, -0.108516, -0.016653, 
	-0.009895, -0.007516, 3.775349, -2.704018, 1.113064, -0.003401, 1.933725, -0.007900, -0.004941, -3.266499, -3.329131, -0.003476, -1.449192, -0.090702, 4.102314, -0.047781, 
	-0.005558, -0.002488, 0.631467, -0.389943, -0.814716, -0.000825, 0.163283, -0.002475, -0.001620, 0.348097, 1.086256, -0.000853, -1.344547, -1.012657, 1.364077, -0.017498, 
	-0.017205, -0.018884, -0.161280, 1.388460, 0.029981, -0.002563, -1.755343, -0.017455, -0.007205, -1.015780, 1.240593, -0.002942, 0.049738, -0.487889, 1.018058, -0.240283, 
	-0.139826, -0.010698, 0.235285, 1.912861, -2.259259, -0.001386, -0.825661, -0.010075, -0.004452, -1.752564, 1.204718, -0.001599, 2.713470, -0.620585, -0.346258, -0.093970, 
	-0.013261, -0.004043, -1.003705, -0.697025, -0.278009, -0.001329, 1.491276, -0.004548, -0.002617, -1.026153, -1.996606, -0.001401, 1.225731, -0.598682, 2.965111, -0.054737, 
	-0.006094, -0.004903, -2.577123, -0.356795, -1.245306, -0.001374, 3.629251, -0.012402, -0.003025, 2.153037, -0.858657, -0.001461, -1.330633, 0.661336, -0.023863, -0.021989, 
	-0.007725, -0.006210, -0.298840, 2.726496, -2.210187, -0.002100, 0.198429, -0.004766, -0.003850, -1.308515, -1.062527, -0.002041, -0.477881, -1.715703, 4.215740, -0.040319, 
	-0.458390, -0.069820, -4.038727, -0.558024, 6.913434, -0.024262, -8.560555, -0.106318, -0.045678, 3.451619, 4.423072, -0.025397, 2.514325, -0.981988, -1.929478, -0.503812, 
	-0.003951, -0.004756, -0.712534, -0.071537, -0.332622, -0.000821, -1.103611, -0.008635, -0.004409, 1.950053, -0.613026, -0.000947, 1.713854, -0.240803, -0.532341, -0.033916, 
	-0.010646, -0.006694, 3.303681, -1.235461, 4.068964, -0.001582, 0.760907, -0.006469, -0.003277, -1.655990, -1.876466, -0.001650, 0.539386, -3.682858, 0.100545, -0.292390, 
	-0.076477, -0.028374, -1.668746, -1.188355, 2.559869, -0.006840, -1.070442, -0.064539, -0.017019, -0.027020, -2.371913, -0.007355, 2.717183, 1.573187, -0.060136, -0.263023, 
	-0.009469, -0.007650, -0.657375, 0.991404, 0.970369, -0.001758, -0.057389, -0.007937, -0.004185, -0.886666, -0.528233, -0.001892, 1.526828, -0.463416, -0.824780, -0.037850, 
	-0.058952, -0.019388, -1.010031, -0.785796, -0.500480, -0.003854, 1.187807, -0.022342, -0.010239, 1.168680, 0.428830, -0.004209, 0.433839, -1.080675, 0.446848, -0.170037, 
	-0.009095, -0.009135, -0.342288, -0.722481, -1.763684, -0.001401, 0.323230, -0.008011, -0.003853, -0.746829, 5.751977, -0.001490, 0.314299, -1.292770, -1.441314, -0.047154, 
	-0.033756, -5.881067, 1.236938, -3.430977, -1.054881, -0.005495, -3.146569, 5.824597, -0.012823, 0.511666, 3.095111, -0.005849, 3.215743, -0.650502, 0.943074, -0.605210, 
	-0.014019, -0.009821, 0.147616, -1.299989, 2.523718, -0.002572, -0.556366, -0.014862, -0.006731, 0.321300, 2.576370, -0.002702, -1.843098, -0.304155, -1.444748, -0.069942, 
	-0.003016, -0.004028, -0.699682, -1.810063, -0.908524, -0.001451, 1.331968, -0.003923, -0.004408, 0.832463, -0.383614, -0.001622, -1.587009, 3.315829, -0.055045, -0.017875, 
	-0.011824, -0.018193, -0.431900, 0.165910, 1.928426, -0.002125, 2.385862, -0.004309, -0.002592, -0.992593, -1.032004, -0.002169, -2.281111, 0.179519, 0.227877, -0.108776, 
	-0.025299, -0.006781, 1.296733, 0.417518, 0.757601, -0.002836, 0.529751, -0.018787, 0.043528, -0.142964, 2.771253, -0.002961, -5.347289, -0.403616, 0.169687, -0.035538, 
	-0.020144, -0.007446, 2.374375, 1.297407, -0.493413, -0.002052, -2.175850, -0.009676, -0.004437, -1.862892, 0.243730, -0.002252, 4.245805, -1.498168, -1.996257, -0.088729, 
	-0.157667, -0.018479, -0.127674, -3.650462, -1.052459, -0.014211, -1.037045, -0.217786, -0.031149, 6.506311, 4.579375, -0.015030, -5.573874, 1.582487, -0.000885, -0.771453, 
	-0.008668, -0.007100, 0.031669, 1.680171, 4.637006, -0.001876, 0.337408, -0.008393, -0.003779, 0.107994, -1.119070, -0.001971, -4.956417, -0.334653, -0.295256, -0.057065, 
	-0.025203, -0.009105, -0.086392, 1.182523, 3.780696, -0.001783, -1.452852, -0.012582, -0.005978, -2.625423, 1.005468, -0.001871, -0.921007, -1.784326, 1.088626, -0.130792, 
	-0.021363, -0.006088, -1.028237, -1.098510, 0.105968, -0.001663, 0.129184, -0.007341, -0.003863, 0.098443, -2.588164, -0.001777, 4.595290, 0.403800, -0.438438, -0.137240, 
	-0.010078, -0.005473, 0.855172, 0.556828, -2.943538, -0.001741, 0.964935, -0.012044, -0.004468, 0.895229, -1.500453, -0.001714, -0.624286, 1.821002, 0.105063, -0.094433, 
	-0.036960, -0.020770, 0.154095, -1.148644, -0.672483, -0.003981, -0.172431, -0.019330, -0.008879, -0.466772, 1.211570, -0.004289, -0.535650, -2.356875, 4.215004, -0.133605, 
	-0.005848, -0.004800, 0.013199, -0.756420, -1.151800, -0.001012, 0.627562, -0.020362, -0.003421, 0.327800, 2.050974, -0.001139, -1.072747, 0.176370, -0.161484, -0.016875, 
	-0.006339, -0.005388, 0.782568, 1.457743, 0.893494, -0.001488, -0.264505, -0.006293, -0.003134, -0.437970, -1.316871, -0.001493, -0.491241, -0.831537, 0.374948, -0.142494, 
	-0.012821, 0.000873, -0.302749, -0.377285, -0.810694, -0.001961, -4.269810, -0.010764, -0.003316, 0.262220, 1.843698, -0.002003, 3.276755, 0.036983, 0.395589, -0.024716, 
	-0.060686, -0.022003, 1.235380, 6.300854, -4.860450, -0.015854, 7.740496, -0.067400, -0.025173, -5.282674, -1.263232, -0.145619, -1.548014, -0.440450, -1.276568, -0.268606, 
	-0.002440, -0.000857, 0.801261, 0.100796, -0.052522, -0.000314, 0.167069, -0.001090, -0.000623, -0.880231, -1.751939, -0.000328, 1.661963, 0.078820, -0.117400, -0.002163, 
	-0.043689, -0.009380, 0.696347, 0.268995, 3.166192, -0.002026, -1.126373, -0.023141, -0.006327, -0.006312, 1.520087, -0.002384, -2.551675, -1.210183, -0.548167, -0.121965, 
	-0.008307, -0.000647, 0.428479, -0.140921, -0.961038, -0.000227, 0.361784, -0.001052, -0.000399, -0.342868, 0.291301, -0.000236, -0.317700, 0.829268, -0.093113, -0.044325, 
	-0.001828, -0.001052, -0.718887, 0.077848, -0.756221, -0.000580, 1.801419, -0.001734, -0.000821, -0.238543, 0.742093, -0.000574, -0.768236, -0.049200, -0.076777, -0.006906, 
	-0.010619, -0.006444, -1.252057, 1.629043, -0.970172, -0.001744, 1.413146, -0.006990, -0.003370, -0.206204, -5.100138, -0.001833, 4.045496, 1.142088, -0.589797, -0.080407, 
	-0.019404, -0.008369, 1.976739, -1.509407, 3.159997, -0.003190, -1.715618, -0.011069, -0.005649, -2.366962, -2.405257, -0.003066, -2.335428, 2.167995, 3.151103, -0.072416, 
	-0.024682, -0.023404, -2.653786, -0.723534, -2.236563, -0.004208, 0.259680, -0.028762, -0.012039, 0.337843, 0.703883, -0.013577, 3.046130, -3.094565, 2.795934, 1.671651, 
	-0.021660, -0.009637, 1.851113, -2.238336, 2.163554, -0.003032, -0.848062, -0.014449, -0.005913, -2.436540, -1.836535, -0.003140, 1.698275, 0.981535, 0.831508, -0.108682, 
	-0.001966, -0.001258, -0.475320, 0.477452, -0.372815, -0.000400, 2.437206, -0.001270, -0.000774, 0.073789, -2.220671, -0.000477, -0.090276, 0.312802, -0.121370, -0.014651, 
	-0.020808, -0.009118, 0.111124, -0.487204, -6.130331, -0.002489, 3.805136, -0.060552, -0.006445, -0.671810, 11.620182, -0.002694, -6.067136, -0.491276, -1.328139, -0.258438, 
	-0.010886, -0.004283, 1.669199, 0.702048, -2.837688, -0.001394, 1.121853, -0.009595, -0.003213, 1.256084, -0.753081, -0.001452, -0.365101, -0.582194, -0.148906, -0.031393, 
	-0.053326, -0.022318, 1.909428, -2.240660, 2.061975, -0.009755, -1.779496, -0.114770, -0.019822, -3.334602, -0.433630, -0.014813, 3.825230, 1.715577, -1.833779, 0.344761, 
	-0.001741, -0.000987, 0.463916, -0.187810, 0.693392, -0.000570, 0.391484, -0.009857, -0.000975, -0.526396, -1.602980, -0.000585, 0.818810, -0.232984, 0.210031, -0.012747, 
	-0.014853, 0.450773, -1.893780, 0.326654, 0.517692, -0.004056, -2.345287, -0.435040, -0.006220, 1.377972, 2.087693, -0.004155, -0.791862, 0.381404, 0.401306, -0.048243, 
	-0.085704, -0.030554, 0.293621, 3.585195, -0.515720, -0.007984, -2.560527, -0.049022, -0.019587, -0.394895, -0.167646, -0.009136, 4.123909, -2.066669, -1.666891, -0.428389, 
	-0.111798, 0.233284, -2.152424, 1.384788, -1.682229, -0.007395, -0.427001, -0.105828, -0.015492, 3.011756, -5.607450, -0.007819, 8.198145, -2.756517, 0.579513, -0.533532, 
	-0.015083, -0.016968, -0.322172, 2.793749, 1.143626, -0.002480, -0.051608, -0.010302, -0.005339, -0.118105, 2.703698, -0.006995, -5.693897, -0.744986, 0.599204, -0.252342, 
	-0.002029, -0.000867, -0.715309, 1.774518, -0.323351, -0.000403, -0.548061, -0.001056, -0.000658, -0.419929, 0.121175, -0.000408, 0.484986, -0.299368, -0.051283, -0.017957, 
	-0.068345, -0.049334, -0.153277, -0.422956, -4.481869, -0.022186, -1.663212, -0.071131, -0.034486, 10.347748, -4.401627, -0.022583, -3.648399, 0.661027, 4.952612, -0.921983, 
	-0.059942, -0.008647, -0.358779, -1.632465, 6.260018, -0.002435, 0.451203, -0.116664, -0.010308, -1.433745, -1.789825, -0.006047, -0.418803, -0.416213, -0.416919, -0.040431, 
	-0.005576, -0.004435, -0.304152, 1.485797, 0.076120, -0.001499, -2.770753, -0.003596, -0.002582, -0.531191, -0.611836, -0.001579, 1.495512, 0.738260, 0.474221, -0.032712, 
	-0.323702, -0.202602, 4.734133, 1.026908, -3.535097, -0.121892, -4.438516, -0.354554, -0.177472, 4.446248, -5.093554, -0.052695, -8.189232, 3.013510, 4.154122, 5.114395, 
	-0.060284, -0.027947, -2.078626, -1.316208, 1.324202, -0.007713, 2.377621, -0.073389, -0.019339, 4.713542, -1.089240, -0.008214, -1.456657, -0.856341, -2.523301, 1.101893, 
	-0.133677, -0.047308, 0.433269, 2.380591, 0.432650, -0.010226, 0.676724, -0.075585, -0.028848, -2.137618, 2.775296, -0.011324, -3.268569, -0.852084, 0.223698, -0.356990, 
	-0.026823, -0.007615, 0.269891, 0.260294, 2.456070, -0.003057, -2.272673, -0.008802, -0.004410, 0.121969, 1.000909, -0.003571, -2.607750, -0.308030, 1.339241, -0.205643, 
	-0.016636, -0.006055, -0.588316, 0.446674, 1.422041, -0.001340, -0.182653, -0.008524, -0.003545, 0.214957, 4.431437, -0.001456, -4.206898, 0.257241, -1.716629, -0.040298, 
	-0.039402, -0.012716, 1.405792, 0.826491, -3.558827, -0.004828, -4.373050, -0.027050, -0.010182, -2.401266, 3.428244, -0.005191, 3.352404, -0.672781, 2.248445, -0.156082, 
	-0.030828, -0.017526, -1.054613, -0.306792, 0.522561, -0.024884, -0.823432, -0.015054, -0.014057, -0.236627, 2.479549, -0.025166, -2.542770, -0.593330, 0.248931, 2.434039, 
	-0.001502, -0.000927, 0.841388, 0.096554, -0.103703, -0.000255, -0.124207, -0.003342, -0.000893, -0.491668, 0.065453, -0.000270, 0.482598, -1.018148, 0.272480, -0.013556, 
	-0.004355, -0.005038, -0.161762, 0.066659, 0.363397, -0.000933, 2.044676, -0.006164, -0.002740, 3.808650, -2.606716, -0.000986, -2.635317, 0.237128, -1.082929, -0.013570, 
	-0.531588, 1.111720, 6.964628, -1.038394, 11.427021, -0.020385, -7.878646, -0.571247, -0.014982, -0.053216, 0.046565, -0.018948, -6.993478, 0.746529, -0.908488, -2.267090, 
	-1.146733, -0.822512, 0.011908, 3.982560, 2.985411, -0.300669, -0.444736, -1.059005, -0.577012, -0.300879, 0.818847, -0.270128, 1.871061, -1.663539, -0.017729, -3.066844, 
	-0.209455, -0.100642, 1.229235, -0.036524, 1.812446, -0.026648, 2.077738, -0.176738, -0.063161, -1.380501, -1.481459, -0.028846, 4.477345, -2.723785, -2.292005, -1.076999, 
	-0.007014, -0.002917, -2.145657, 2.138141, 2.299875, -0.001408, -0.563699, -0.003754, -0.002191, 1.220048, -3.269030, -0.001506, 1.573188, -1.160838, -0.045079, -0.028159, 
	-0.035933, -0.023763, -1.501157, 0.890128, 0.892901, -0.005272, -1.111057, -0.021678, -0.013658, -1.104823, 5.432762, 0.043740, -1.551873, 0.017925, -1.487738, -0.420503, 
	-0.023803, -0.014581, 2.061425, 0.311775, -3.067197, -0.003405, 5.200888, -0.019006, -0.009691, -0.561784, -2.089761, -0.003629, -1.933659, 2.724350, -2.465533, -0.106388, 
	-0.009763, -0.004877, -0.491818, -0.650641, 0.596280, -0.001482, 3.886883, -0.007494, -0.003190, -1.366747, 1.035723, -0.001576, -4.097130, 1.124492, 0.075039, -0.083698, 
	-0.047558, -0.008909, 0.938605, 0.701734, 1.495099, -0.002418, 0.228681, -0.021483, -0.006754, -2.244976, -0.717344, -0.002755, -3.350548, 2.736472, 0.348674, -0.046520, 
	-0.222716, -0.047921, 1.623929, 3.062985, 3.390779, -0.019436, 3.907545, -0.072803, -0.034831, -4.690085, -2.202361, -0.149453, -4.877859, 1.527804, -0.767025, -0.428551, 
	-0.011260, -0.006741, -0.128057, -0.212948, 3.498857, -0.003124, -1.219352, -0.009227, -0.004251, -0.554636, 2.737372, -0.003567, -3.806952, -0.282612, -0.171181, 0.177678, 
	-0.018766, -0.009330, 0.540736, 1.234255, -3.582363, -0.002379, 2.001239, -0.013001, -0.005940, -0.133046, 0.253368, -0.002404, 0.085584, -0.581534, 0.384694, -0.151112, 
	-0.002979, -0.008835, -1.786418, -1.045333, -1.380394, -0.001193, 0.153063, -0.003645, -0.002614, 3.875048, -1.283897, -0.001259, 0.562856, 1.425905, -0.483454, -0.016850, 
	-0.100441, -0.030624, 5.732839, -1.070547, 6.935282, -0.012265, -1.816381, -0.059767, -0.022121, -1.597561, -4.918634, -0.012781, -4.672855, 4.186376, -3.281252, 0.740732, 
	-0.028522, 0.005019, -0.113008, 1.875189, 2.793153, -0.002497, -0.927073, -0.020232, -0.006448, -2.173315, -1.083513, -0.002771, -1.315029, -0.199554, 1.288912, -0.090311, 
	-0.025379, -0.013264, 1.106091, -1.451539, 1.695238, -0.003199, -2.754531, -0.017073, -0.008117, -2.855155, 2.671027, -0.003592, 1.754557, -1.519666, 1.634585, -0.209982, 
	-0.002026, -0.000803, 0.023613, 1.083293, -1.226627, -0.000237, 0.594072, -0.003532, -0.000636, 0.410335, -1.254892, -0.000259, -0.195697, 0.713690, -0.134020, -0.006275, 
	-0.012882, -0.004445, 0.504748, -0.189839, -0.568146, -0.001582, -0.637011, -0.004889, -0.003082, -1.104991, 3.163002, -0.001617, -0.741687, -0.765756, 0.500598, -0.132421, 
	-0.023117, -0.001379, 0.737848, -0.183415, -0.630695, -0.000471, -0.713341, -0.001822, -0.000797, -0.322597, -1.423741, -0.000240, 1.345373, -0.073881, 1.295130, -0.002855, 
	-0.046926, -0.009262, 0.710593, -0.519376, 0.564487, -0.002426, 3.799922, -0.021942, -0.006396, -0.351585, -2.469112, -0.002638, 0.774893, -2.012470, -0.305215, -0.102548, 
	-0.004560, -0.004782, 1.408411, -0.898661, -1.952122, -0.000819, -0.196877, -0.023029, -0.003155, -0.584151, 0.053108, -0.000958, -0.692347, 2.202695, 0.707625, -0.010379, 
	-0.005439, -0.006533, -0.480040, 0.273621, -0.679669, -0.001090, 3.479775, -0.014064, -0.003605, -0.642539, -0.781821, -0.001252, -1.204190, 0.084775, -0.003226, -0.014704, 
	-0.001423, -0.000996, -1.279069, -0.393206, 3.077244, -0.000399, -0.402220, -0.001351, -0.000808, 0.330707, -2.635570, -0.000492, 1.875002, -0.255085, -0.305404, -0.006931, 
	2.379211, -0.013725, 6.016502, -2.543437, -7.821970, -0.004219, 6.819705, -0.015312, -0.008585, -2.680261, 0.460077, -0.004501, -2.658399, -0.658432, 0.926022, -0.192677, 
	-0.032981, -0.018330, -2.360017, -0.780717, -1.959269, -0.004698, 5.039914, -0.015913, -0.009386, -1.464270, 1.304429, -0.004998, -0.197007, 0.406271, 0.342116, -0.245144, 
	-0.010408, -0.011400, 0.121925, -0.745147, -0.139979, -0.002663, -0.235164, -0.008108, -0.007672, -0.236708, -0.717477, -0.002657, -1.837609, 3.484731, 0.449556, -0.101219, 
	-0.035075, -0.004984, 0.090015, -0.233704, -0.329123, -0.001696, -1.063596, -0.006126, -0.003343, -0.664792, 0.671043, -0.001754, 1.215595, -1.173445, 1.633754, -0.092769, 
	-0.006724, -0.003078, 0.072366, -0.826256, -0.987945, -0.000919, -0.408434, -0.008563, -0.002334, -0.232312, 2.098637, -0.000954, 0.654089, -1.145361, 0.812065, -0.014277, 
	-0.049558, -0.013890, -0.340990, -0.168364, -2.425977, -0.005417, 2.501655, -0.014223, -0.010476, 0.257269, -2.127091, -0.005543, 1.049518, 0.897347, 0.627303, -0.171563, 
	-0.015339, -0.002891, -0.410643, -0.360296, -0.583313, -0.000796, -1.395447, -0.002747, -0.001672, -0.112536, -4.065532, -0.000774, 5.884198, 0.268459, 0.809748, -0.010419, 
	-0.113860, -0.032467, 0.136570, 0.378777, -6.046580, -0.006639, 7.306380, -0.059012, -0.019208, -2.132457, -0.200574, -0.007088, -1.635661, -1.082738, 4.288490, -0.773931, 
	-0.043193, -0.006648, -1.454546, 1.561671, 4.888403, -0.002541, -0.813607, -0.132348, -0.009587, 0.433140, 0.631743, -0.005963, -4.939937, -1.857492, 1.819382, -0.068480, 
	-0.006140, -0.003153, 0.148794, 0.235402, -1.199079, -0.001047, -0.726937, -0.006998, -0.002792, 1.427300, -0.633226, -0.001113, -1.358834, -1.322151, 0.396224, 3.053750, 
	-0.003731, -0.001932, 0.902519, -0.661947, 0.509900, -0.001022, -0.657933, -0.005967, -0.001590, -0.336172, 1.486393, -0.001071, -0.565939, -0.305279, -0.349069, -0.007160, 
	-0.283928, -0.161718, -1.561072, 1.039487, -1.897691, -0.022236, -5.844744, -0.168540, -0.063369, -4.178471, 10.718698, -0.025780, -5.922957, 1.314626, 4.784638, 2.273058, 
	-0.006887, -0.005497, -1.496070, 0.000476, -2.725825, -0.002145, 6.933335, -0.020050, 0.114278, -0.157585, -0.767390, -0.002224, -2.545818, 1.045935, -0.325680, -0.038853, 
	-0.003152, -0.001806, 0.810586, -0.414171, -0.906810, -0.000506, 0.918444, -0.005168, -0.001317, -0.719409, 3.376423, -0.000557, -3.896333, 0.330861, 0.543557, -0.030643, 
	-0.007932, -0.002403, -0.511592, 1.562160, -1.004819, -0.000850, -0.576951, -0.003983, -0.002708, 0.348614, -0.835134, -0.000898, 1.719573, -0.306692, -0.297119, -0.079267, 
	-0.021953, -0.016541, 2.034566, -1.373844, 0.007133, -0.003233, 7.086599, -0.020762, -0.008297, -2.438549, -2.739644, -0.003749, -1.653369, -2.650898, 1.221119, 0.581422, 
	-0.001283, -0.000587, -0.019924, 0.042279, 1.303913, -0.000304, 0.469029, -0.000657, -0.000465, -0.230460, -0.726499, -0.000309, -0.791371, 0.008743, -0.046626, -0.005480, 
	-0.007611, -0.004710, 1.284280, -1.692455, 0.135897, -0.001577, -1.033969, -0.002869, -0.002002, -0.285565, 6.695035, -0.001602, -5.084989, -0.612183, -0.668149, 1.282470, 
	-0.005727, -0.002678, -0.997649, 0.641249, 0.405327, -0.000905, -3.745412, -0.009542, -0.002078, 0.243586, 0.048102, -0.000935, 2.449885, 0.319508, 0.673480, -0.016212, 
	-0.004964, -0.252570, 0.004066, 0.029276, -0.381581, -0.001120, -0.061529, 0.252900, -0.000747, 0.787868, -2.853868, -0.001120, 1.663999, -0.337586, -0.134690, 1.291667, 
	-0.009204, -0.004008, 0.578082, -0.515275, 0.607552, -0.000985, -1.116616, -0.002750, -0.002111, 2.216543, -3.525440, -0.005734, 2.692920, -0.509879, -0.377925, -0.025170, 
	-0.103822, -0.005588, 0.065694, 0.740751, 1.191267, -0.001002, -1.611989, -0.004241, -0.002630, -0.566011, 0.433780, -0.001106, 0.260912, -0.006971, -0.361334, -0.027711, 
	-0.160399, -0.108994, -0.606819, 3.336190, 2.353867, -0.055003, -3.473462, -0.139940, -0.081453, -1.905849, -5.868679, 0.007957, 2.939050, -1.978044, 4.990838, 0.750740, 
	-0.054509, 0.005787, 3.395210, 1.525590, 1.961707, -0.008477, 1.231278, -0.086305, -0.021267, 0.391426, -4.190197, -0.008784, 0.765025, -1.791052, -2.550886, -0.564548, 
	-0.017441, -0.007489, -0.912636, 1.793003, 0.609698, -0.002262, -2.634164, -0.037689, -0.005744, 1.619433, 0.281071, -0.002483, -0.019606, -1.798931, 0.072478, 1.062762, 
	-0.403044, -0.114691, -0.522109, 1.321430, -1.764148, -0.046839, -0.975271, -0.134239, -0.084281, 0.456158, 3.130708, -0.058217, 5.084693, -2.583691, -0.792260, -2.514199, 
	-0.123886, 0.005586, 0.424642, 0.968818, -1.068934, -0.007888, -5.437535, -0.130905, -0.026316, 3.774882, 4.035511, -0.008802, -0.830786, -0.860368, -0.336050, -0.377966, 
	-0.000913, 0.032441, 0.105187, -0.420378, -0.481768, -0.000422, -0.785891, -0.033549, -0.000902, -0.412730, -1.178846, -0.000447, 3.401063, -0.060121, -0.157418, -0.005307, 
	-0.186603, -0.071492, -0.345449, 0.529527, 3.069801, -0.026433, 4.252958, -0.085972, -0.045270, -1.554130, 6.040687, -0.031856, -6.036193, -2.547452, -1.213510, -1.748613, 
	-0.004605, 0.012063, -0.963441, 1.135070, 0.052868, -0.001184, 5.128567, -0.025228, -0.002426, -0.740140, -1.197636, -0.001239, -3.458194, 0.098310, 0.031703, -0.064488, 
	-0.004870, -0.002671, -1.372008, 3.723448, -1.419555, -0.001049, -0.582101, -0.003254, -0.002031, 1.226478, 2.333360, -0.001042, -3.933754, -0.526255, 0.660695, -0.095390, 
	-0.061727, -0.004891, -0.426843, -1.403097, 1.445350, -0.002073, -0.007156, -0.008180, -0.003528, -0.258089, -1.054791, -0.002148, -1.433725, 4.215999, -0.853559, -0.141539, 
	-0.013249, -0.008792, -0.295480, 0.513400, -1.474917, -0.001511, -1.390169, -0.006987, -0.004246, -2.649961, 2.274556, -0.001666, 1.682636, 1.778797, -0.340941, -0.061469, 
	-0.012586, -0.010778, 0.002340, 0.229996, 4.348089, -0.003354, 3.520076, -0.029774, -0.007661, 0.053427, -2.308953, -0.003562, -6.819555, 1.501442, -0.388499, -0.070646, 
	-0.006478, -0.005800, 0.792785, -1.047764, -0.260137, -0.001165, -0.045216, -0.003123, -0.002321, 3.692609, -1.236549, -0.001210, -1.182126, -0.698740, 0.067834, -0.062599, 
	-0.009538, -0.010928, -0.573882, 0.175061, 1.584208, -0.001065, -1.907731, -0.010655, -0.003923, -0.495890, -0.912041, -0.001215, 1.192787, 1.360939, -0.365590, -0.020537, 
	-0.006076, -0.009076, 1.243910, -1.046462, 3.832311, -0.002025, 0.035194, -0.014962, -0.005086, -0.180894, 1.884166, -0.002365, -3.962761, -0.663454, -0.998250, -0.104171, 
	-0.743322, -0.278213, -1.612021, 0.667092, 3.300005, -0.078265, 2.761666, -0.502548, -0.181335, -0.832605, 4.344974, -0.349118, 0.784828, -2.378418, -1.877349, -3.025370, 
	-0.010711, -0.005631, -0.572988, 0.425390, -0.453117, -0.001334, 0.057619, -0.006814, -0.003228, 1.482998, 4.336947, -0.001415, -3.712340, -3.049757, 1.916233, -0.401854, 
	-0.002739, -0.002700, -0.523881, -0.165287, 0.776248, -0.000989, -0.556323, -0.003797, -0.002140, -0.791888, -2.091263, -0.130360, 3.164102, -0.143867, 0.500580, -0.025695, 
	-0.076129, -0.021711, -2.081761, -0.154603, -3.384477, -0.006906, 2.953091, -0.053761, -0.015799, -3.431043, 0.391196, -0.007260, -0.397241, 1.538394, 3.514829, 1.233182, 
	-0.005013, -0.003300, -1.531808, -2.022958, -1.747167, -0.001506, -1.498782, -0.006211, -0.002573, 5.048421, 1.138357, -0.001258, 0.889463, 0.235783, -0.443448, -0.047998, 
	-0.076813, -0.046983, 1.138273, 6.707378, 4.510744, -0.043783, -3.358263, -0.049135, -0.033837, 0.996318, 0.247761, -0.307795, -8.712337, -2.183248, -3.948004, 5.159722, 
	-0.080813, -0.005059, 0.071965, -0.301144, -0.025837, -0.002078, 3.211052, -0.008518, -0.005933, -0.366437, 0.977380, -0.002226, -3.812940, 0.042068, 0.360852, -0.052330, 
	-0.005527, -0.006018, -0.340826, 2.790293, -0.792777, -0.001321, -1.334747, -0.005851, -0.003669, -0.874536, -4.171721, -0.001480, 4.990171, -1.131885, 0.924928, -0.035036, 
	1.921580, -0.116726, -4.845969, -2.403075, -2.791455, -0.033649, -7.454275, -0.183735, -0.078110, -0.333672, 3.791557, -0.045050, 3.756624, 6.736149, 2.629941, -0.550136, 
	-0.005274, 0.253776, -0.561522, 2.484750, -0.782130, -0.000887, 0.620461, -0.082707, -0.001963, -1.371224, 0.778769, -0.000937, -2.757528, 1.616850, -0.156084, -0.034349, 
	-0.001727, -0.001325, 0.250991, 1.531863, 0.526651, -0.000748, 0.923721, -0.001362, -0.001011, -0.676744, -1.190377, -0.000784, -1.685064, -0.012738, 0.343671, -0.005014, 
	-0.034429, -0.019350, 3.696883, 0.355764, -1.422455, -0.004136, 5.381317, -0.025588, -0.014894, 1.745185, 2.112319, -0.004480, -5.867025, -1.915234, -3.752172, -0.231707, 
	-0.332126, 18.594814, -1.332630, -4.479645, -2.169491, -0.291887, 1.054657, 6.118827, -2.917489, -1.274026, -4.380227, -0.294787, -3.563659, -0.957430, -3.412616, -0.362287, 
	-0.004571, -0.001892, 0.294765, -0.763793, 2.720960, -0.000715, 1.246267, -0.004984, -0.001686, -1.184700, -0.539058, -0.000704, -1.531795, 0.135359, -0.330205, -0.033249, 
	-0.178305, -0.021498, 10.417083, -5.822600, 10.832994, -0.007018, -5.750609, -0.023182, -0.013529, -2.057647, -15.753928, -0.007362, 11.151986, -1.063392, -1.450505, -0.252487, 
	-0.013055, -0.002246, -0.185563, -0.867368, 1.303395, -0.000621, -0.540157, -0.002310, -0.001470, -0.063656, -1.271485, -0.000641, 1.781157, -0.122527, -0.001711, -0.011741, 
	-0.022943, 0.007062, 7.817142, -0.151370, 3.227962, -0.003702, -1.766918, -0.035761, -0.008444, -2.659607, -1.030386, -0.003870, -3.040383, -1.439469, -0.736646, -0.152665, 
	-0.007608, -0.006928, 1.514174, -0.468082, 3.510092, -0.003315, 0.618505, -0.005302, -0.005486, -1.029332, -1.045074, -0.003682, -2.741055, -0.280743, -0.269413, 0.223250, 
	-0.016543, -0.004930, -0.587957, 2.724124, -1.802783, -0.001446, -3.773237, -0.007006, -0.003168, -0.339367, 1.687540, -0.001511, 1.936154, -0.701218, 0.931821, -0.040473, 
	-0.076059, -0.023767, -0.604191, -2.667937, 4.994646, -0.004991, 0.401399, -0.047772, -0.014669, 0.493824, -0.531619, -0.005297, -3.694541, 3.254806, -1.348302, -0.125529, 
	-0.005878, -0.001387, 0.273760, -1.480692, -0.429226, -0.000644, -0.423923, -0.001185, -0.001024, -1.126841, 0.715801, -0.000674, 1.287834, -0.051964, 1.253473, -0.007431, 
	-0.013672, -0.008819, 0.330805, -1.627612, -0.352421, -0.003769, 1.907975, -0.010051, -0.006292, 5.410352, -1.105973, -0.003838, -2.132066, -0.740633, -1.551087, -0.092898, 
	-0.006043, -0.003674, -1.526878, 1.903316, 0.147874, -0.001129, 1.015461, -0.006913, -0.002343, -0.512250, -0.387910, -0.001194, 0.009739, -0.687617, 0.165277, -0.105717, 
	-0.004014, -0.005678, -0.138679, -0.000966, 0.077660, -0.003191, 1.683459, -0.024826, 0.145909, -0.009502, 0.540890, -0.003188, -1.537613, -0.550338, -0.159184, -0.010740, 
	-0.035795, -0.019029, -1.132215, 1.383727, 1.139142, -0.006183, -9.673693, -0.021200, -0.009715, 0.650638, 1.219594, -0.006459, 6.871756, 1.473713, -0.701275, -1.133006, 
	-0.007475, -0.008407, 1.456233, -0.704606, -1.313213, -0.001868, 3.105673, -0.008636, -0.003677, 1.618354, -3.766019, -0.001951, -0.997433, -0.023253, 0.690591, -0.034312, 
	-0.011611, -0.008321, 0.438448, 1.011814, 2.953944, -0.003393, -1.781785, -0.012446, -0.005615, 0.653055, 4.272075, -0.003566, -7.248151, -0.529245, -0.775605, 1.050404, 
	-0.022524, -0.014002, -3.195709, -1.045838, -3.623781, -0.004297, 1.165703, -0.042251, -0.010422, 0.082181, -0.924529, -0.004634, 0.133834, 3.253533, 4.347021, -0.094285, 
	-0.012481, -0.011251, -1.505295, -1.638836, 1.366942, -0.003232, -1.683188, -0.018926, -0.007053, 0.425952, 6.281658, -0.003376, -2.443043, -0.502402, -0.058925, -0.186544, 
	-0.018927, 2.815460, -0.593172, 1.329564, -1.669705, -0.005332, 1.587970, -2.681384, -0.041548, -0.511822, 0.434372, -0.005514, -0.170785, -0.367615, 0.009036, -0.110597, 
	-0.022005, -0.012836, -2.189659, -0.017070, 0.086855, -0.002664, 3.842948, -0.010067, -0.006475, 0.523301, -5.149202, -0.003070, 4.453279, -0.979284, -0.275274, -0.238776, 
	-0.001815, -0.001111, 2.896840, -0.622955, -0.574701, -0.000563, -0.232222, -0.002708, -0.000975, -1.006374, -0.266150, -0.000573, -0.165845, 0.170027, -0.188236, -0.002640, 
	-0.192525, -0.116760, 2.348095, -0.614880, 0.934152, -0.030949, 6.597004, -0.183512, -0.076012, -4.017099, -3.454692, -0.033464, 0.397959, -1.645033, 1.103080, -1.015364, 
	-0.006761, -0.001404, 0.282724, 1.361688, -2.135233, -0.000460, 0.564045, -0.002418, -0.001040, -0.197853, -0.232974, -0.000501, 0.366856, -0.266906, 0.282528, -0.012291, 
	-0.012638, -0.007295, 0.128600, 0.050421, -0.135831, -0.001345, -2.313787, -0.014025, -0.004717, 0.169298, 1.336370, -0.001639, 1.989841, -0.426187, -0.438416, -0.318649, 
	-0.031450, -0.015480, -0.160996, -4.221600, -5.919295, -0.006124, 9.641407, -0.023541, -0.011118, -1.274963, 5.251622, -0.006364, -2.227675, 0.400693, -1.070150, -0.324966, 
	-0.026919, -0.011651, -0.209073, -1.918178, -3.336100, -0.002590, 2.561922, -0.040640, -0.007614, -0.395427, -0.317284, -0.002856, 5.661962, -1.253250, -0.563769, -0.138533, 
	-0.005841, 1.582504, -0.096047, 0.009033, -0.103803, -0.002440, 0.224512, -1.500611, -0.002915, 1.919154, -0.010131, -0.002524, -0.751843, -1.038548, -0.174309, -0.046191, 
	-0.008677, -0.004987, 1.221213, -0.872865, -3.574931, -0.001760, -2.719812, -0.004982, -0.003306, -1.978530, 0.494858, -0.001856, 3.644558, 4.524228, -0.679519, -0.033630, 
	-0.025376, 0.573928, -0.717397, -1.402423, -2.474877, -0.003930, 2.214146, -0.520935, -0.008318, -0.613255, -4.890234, -0.004064, 6.155661, 0.181246, 1.628939, -0.093110, 
	-0.040704, -0.002717, 1.359934, -0.034033, 3.419570, -0.000532, 0.226616, -0.003687, -0.001581, -0.150596, -2.249730, -0.000584, -1.318015, -1.023330, -0.163331, -0.017281, 
	-0.006604, -0.006793, -1.272608, 0.537658, 0.326258, -0.001642, -0.517455, -0.011138, -0.004151, -0.323641, -0.025324, -0.001839, -3.265162, 3.363576, 1.282127, -0.073262, 
	-0.021500, -0.010580, 1.300736, 1.231469, 0.630119, -0.003100, -3.818822, -0.025282, -0.008384, 0.924021, 0.812011, -0.003459, -0.360793, 0.485970, -0.617954, -0.514451, 
	-0.040458, -0.001889, -0.091984, 0.135639, -0.351623, -0.000432, 1.104480, -0.004110, -0.001338, -0.929288, -0.606863, -0.000479, 0.284147, -0.332030, 0.850664, -0.014436, 
	-0.050575, 0.008800, 0.870946, -1.702793, -3.549513, -0.001993, -0.840649, -0.016079, -0.004306, 1.730328, 1.621263, -0.002063, -0.718522, 3.282698, -0.472257, -0.155283, 
	-0.019869, 0.002274, -1.066006, 0.201642, -1.466422, -0.002157, 0.835930, -0.012543, -0.004667, -0.483819, -0.902897, -0.002231, -0.340040, 2.779404, -1.192203, 1.673605, 
	-0.013138, -0.005744, 0.796839, -0.105103, 4.152313, -0.002763, -3.918714, -0.007641, -0.004008, 0.131892, -0.415036, -0.002872, -0.769319, -3.278315, 2.149848, 1.291762, 
	-0.544907, -0.069011, -0.785675, 0.699190, -1.637347, -0.019931, 0.341462, -0.148937, -0.043784, 0.138944, -0.183501, 0.668614, 1.818120, -0.245340, 0.228879, -0.216775, 
	-0.058975, -0.023295, 4.480708, 3.123785, -0.855263, -0.007789, 1.361626, -0.038926, -0.015032, -4.745030, -0.919288, -0.008155, 2.402486, -1.528009, -3.010639, -0.158203, 
	-0.069531, -0.006813, -0.525737, -0.586281, -0.274415, 0.192049, 0.277813, -0.005341, -0.003631, -1.492531, 0.822842, -0.002790, 3.716767, -1.083812, -0.815143, -0.143447, 
	-0.007351, -0.002740, 0.122093, -0.279740, 0.275599, -0.000679, -0.665547, -0.002614, -0.001559, 0.590755, -0.768551, -0.000714, 0.715096, -1.725073, 1.767736, -0.016712, 
	-0.022948, -0.005437, -0.184655, -1.292022, 1.396552, -0.001772, 5.538726, -0.021871, -0.004591, 0.133680, 0.431132, -0.001881, -4.153570, -1.353939, -0.410305, -0.047101, 
	-0.118508, -0.073115, -5.386155, 2.315731, -1.308675, -0.013153, 7.259646, -0.062737, -0.033886, -1.326884, -1.307807, -0.017960, 0.066767, 2.176001, -1.313450, -0.855816, 
	-0.002452, -0.002896, -0.933011, -0.378130, 2.497395, -0.000633, -2.919605, -0.009740, -0.001833, -0.592879, -1.640060, -0.000787, 1.868312, -0.262984, 2.390794, -0.011492, 
	-0.095583, 2.498992, -5.515935, -2.105525, 0.433821, -0.017324, -4.880682, -2.562590, -0.025664, -1.172885, 2.610661, -0.017782, 5.367254, -0.568057, 5.369739, 0.681562, 
	-0.070731, -0.013050, 7.366643, -0.208651, -2.444169, -0.005565, -0.045184, -0.022010, -0.010952, 3.930947, -2.317081, -0.005821, -2.305055, -1.554915, -2.228929, -0.065479, 
	-0.096628, -0.046040, 3.414874, 4.183984, 1.686205, -0.018362, 0.316001, -0.064179, -0.034548, 11.854740, -1.905602, -0.019112, -8.568017, -5.152147, -3.783497, -1.767672, 
	-0.099794, 0.231385, -5.027555, -1.013355, 0.185064, -0.015485, 3.334949, -0.210192, -0.033400, -3.529452, 3.027361, -0.146053, -2.964300, 3.702407, 3.043572, -0.485151, 
	2.463891, -0.005259, -0.661586, 1.601396, -4.125031, -0.001735, 5.010082, -0.011351, -0.003956, 2.483584, -0.980316, -0.001863, -4.081973, -0.753296, -0.481199, -0.451387, 
	-0.164520, -0.084625, 3.887346, 0.460719, -3.507509, -0.058339, -5.972800, -0.100533, -0.059619, 5.327221, -6.435500, -0.318264, -3.207481, 10.759106, -5.274780, 4.749579, 
	-0.322333, 0.098924, 2.239349, -2.718075, -3.834106, -0.047447, -2.594836, -0.314706, -0.101580, -1.472497, 2.937613, -0.055048, 8.808095, -2.082560, 0.502870, -1.043663, 
	-0.003653, -0.003992, -2.191270, 1.909357, -0.032731, -0.001242, 2.262444, -0.005687, -0.003098, -0.506146, -0.888053, -0.001290, -0.171306, 0.160230, -0.491177, -0.032386, 
	-0.005648, -0.001446, 0.250199, 0.779259, -0.055332, -0.000700, -1.153125, -0.001622, -0.001123, -0.316561, 1.695804, -0.000708, -0.528463, -0.520692, -0.129294, -0.010547, 
	-0.058705, -0.026746, 2.179121, 2.330236, 2.231675, -0.008315, 1.001238, -0.063363, -0.018614, 0.225444, 1.153196, -0.009475, -5.908943, -1.280929, -1.383057, -0.362765, 
	-0.010554, -0.008592, -0.430671, -0.299440, -2.764032, -0.002944, 5.741465, -0.010584, -0.005572, 2.139859, -2.435130, -0.002644, 0.121144, -2.202976, 0.248194, -0.077522, 
	-0.014677, 0.244101, 0.407964, -0.382066, -1.187067, -0.001609, -0.093467, -0.264426, -0.006096, 0.237803, 1.369724, -0.001726, -3.761188, 2.128540, 1.671286, -0.347096, 
	-0.035639, 1.201261, 0.408380, -0.145358, -0.298903, -0.020091, 0.416039, 0.261853, -0.026612, -2.272745, 2.333043, -0.020430, -1.415742, -0.437104, 0.172763, -0.120716, 
	-0.001285, -0.000597, -0.993772, 0.530409, -0.582219, -0.000178, 1.821694, -0.001049, -0.000524, -0.093458, -0.134233, -0.000184, -0.538164, -0.430798, 0.436954, -0.012600, 
	-0.006049, 0.168009, 1.290908, -3.235526, -0.795683, -0.001764, -0.058749, -0.167014, -0.002898, 3.314564, 1.168737, -0.001834, -0.529685, -0.785302, -0.358974, 0.001259, 
	-0.011370, -0.003164, -0.490700, 0.043060, -1.913437, -0.002049, -3.335406, -0.020465, -0.003413, 0.285309, 0.834273, -0.002118, 3.777520, -0.804394, 1.471655, 0.174701, 
	-0.007229, -0.002350, -0.991296, 0.188216, 1.255945, -0.000825, -1.918872, -0.005775, -0.001919, 1.452128, 1.384014, -0.000873, -0.779329, 0.094007, -0.619446, -0.046396, 
	-0.023070, -0.001534, 0.098940, -0.340672, 0.291227, -0.000934, 1.177177, -0.014103, -0.001948, -0.353538, 1.302119, -0.005373, -1.402978, -0.501537, -0.039152, -0.184624, 
	-0.010985, -0.007144, 2.652428, -0.030440, -1.524061, -0.001405, 4.465805, -0.028417, -0.004591, -2.535532, -5.817134, -0.001598, 4.430186, -0.491232, -1.074455, -0.021425, 
	-0.030755, -0.016818, -1.029215, 7.007993, -0.941030, -0.004312, -0.804887, -0.021015, -0.010177, 1.883101, 0.911531, -0.004499, -4.026662, -1.870080, -2.623030, 1.579855, 
	-0.003948, -0.000520, 0.774479, -0.012881, -0.067054, -0.000190, 6.576904, -0.000585, -0.000360, -0.662272, -1.737243, -0.000199, -4.702398, -0.116057, -0.045046, -0.002629, 
	-0.007249, -0.006332, 4.769475, 1.685722, -0.337379, -0.001681, -4.712522, -0.006098, -0.003580, -2.615474, -0.054079, -0.001807, 0.175838, 0.891094, 0.275446, -0.051373, 
	-0.006514, -0.005215, -1.187005, 2.325249, -0.833418, -0.002592, 0.526957, -0.006785, -0.003815, 1.253242, -0.929281, -0.002666, -0.054882, -0.827858, -0.165330, -0.080087, 
	-0.006262, -0.003757, -0.791871, -1.124504, -1.671132, -0.001252, 0.618978, -0.003542, -0.002537, 6.019588, -0.570287, -0.001308, -0.420902, -1.483419, -0.480941, -0.076854, 
	-0.064807, -0.023589, 0.307619, 1.515146, 1.233044, -0.006619, 1.003891, -0.039748, -0.014550, -1.469401, -6.630877, -0.007048, 5.520215, 0.290332, -1.447745, -0.165864, 
	-0.007266, -0.006538, 0.565063, 4.114814, 0.512374, -0.001253, 1.582517, -0.004168, -0.002492, -2.694324, -1.166655, -0.001311, -2.689446, 0.258238, -1.562603, 1.103050, 
	-0.010550, -0.005224, -0.076619, 0.668688, -3.162491, -0.000841, -0.990030, -0.022280, -0.003088, -0.763540, -1.489856, -0.000995, 6.022555, -0.113403, -0.041216, -0.011109, 
	-0.011437, -0.005167, -0.889562, -0.659244, 0.865634, -0.001634, -3.472480, -0.005571, -0.003252, 1.458440, -2.274276, -0.001674, 6.136670, -0.425619, -0.675164, -0.035665, 
	-0.010879, -0.010490, -1.040678, -1.846251, -2.809770, -0.003112, 0.782898, -0.028052, -0.007297, -0.085951, -3.958804, -0.003383, 7.964172, 1.581338, -0.380022, -0.143719, 
	-0.045776, -0.021006, 7.911440, -0.361644, 1.512853, -0.003358, -1.285178, -0.036221, -0.010365, -6.046953, -0.373649, -0.003805, 1.004339, -1.974868, -0.150982, -0.114827, 
	-0.019216, -0.004807, 0.784765, -2.267173, 0.106680, -0.002009, -1.777077, -0.008637, -0.003841, 2.438625, 1.439321, -0.002039, -0.848748, 0.311249, -0.093853, -0.053240, 
	-0.028096, -0.025050, -0.526307, 0.433069, -0.748293, -0.005398, 2.561540, -0.052918, -0.008819, -0.505380, -5.046719, -0.005713, 5.356681, -0.342452, -0.413475, -0.642669, 
	-0.008506, -0.002953, -0.355373, -0.158274, 0.425833, -0.000762, 2.789090, -0.007331, -0.002363, -0.929338, -1.740423, -0.000887, -0.042652, -0.132389, 0.201370, -0.035042, 
	-0.095394, -0.006202, -0.140340, -0.400892, 0.929829, -0.001761, 2.306736, -0.022020, -0.004727, -0.977172, 2.843483, -0.001912, -4.104959, -0.409963, 0.109601, -0.024307, 
	-0.016989, -0.008424, -3.304120, -0.203195, -2.408198, -0.003349, 11.458590, -0.007598, -0.005325, -0.445311, -4.222458, -0.003442, 1.640763, -1.317545, -1.120547, -0.032853, 
	-0.019380, -0.613023, 1.226871, -2.368039, -2.223575, -0.002406, 0.785037, 0.571169, -0.005791, 1.452927, 0.486794, -0.002012, -2.385261, 4.114362, -0.717769, -0.299904, 
	-0.023465, -0.004501, -0.576749, -0.569561, -0.308654, -0.001034, -0.890111, -0.016410, -0.002561, -0.124818, 2.816320, -0.001117, 0.785511, -0.603912, -0.435748, -0.043191, 
	-0.045692, -0.024061, 1.558506, 2.334761, 1.189371, 0.185473, -3.111876, -0.026175, -0.015609, 0.388313, 3.507725, -0.009562, -3.421454, -0.273946, -1.818519, -0.417256, 
	-0.007449, -0.004933, -0.597556, -0.398793, 0.179359, -0.002232, -1.547339, -0.004111, -0.003064, -0.803125, -2.864039, -0.002284, 2.216726, -0.417848, 1.080461, 3.176225, 
	-0.425647, -1.001896, -0.204449, -0.806338, -0.460098, 0.871081, 1.061170, -1.387085, -0.315369, 0.226491, 1.591840, -0.834168, 0.868734, -0.650051, 1.194196, 0.271587, 
	-0.063128, -0.017082, -3.046292, 1.946780, -1.630734, -0.004129, 2.359692, -0.012423, -0.007650, 2.458851, 1.222509, -0.011518, -2.096207, 0.714465, -1.752953, -0.060181, 
	-0.020483, -0.018496, 4.116988, 1.792817, -3.180876, -0.006273, 1.271099, -0.029106, -0.012110, 4.408817, -2.504258, -0.006656, -3.663549, -2.096784, 0.209139, -0.260270, 
	-0.000986, -0.001121, -0.609070, 0.522155, 0.101175, -0.000337, 0.451958, -0.001099, -0.000728, 0.123195, 2.302136, -0.000327, -2.865601, 0.154737, -0.157760, -0.018328, 
	-0.008715, -0.002159, 0.614943, -0.912441, 2.136269, -0.000856, -3.019624, -0.002699, -0.001499, -0.429516, -1.010772, -0.000897, 1.685660, -0.101490, 1.064253, -0.010457, 
	-0.005671, -0.005763, 0.046776, -1.636362, 1.691893, -0.002920, 0.124965, -0.020647, 0.116103, -0.212653, -0.170152, -0.002977, -0.861767, 0.536580, 0.447545, -0.044950, 
	-0.018035, -0.006246, -0.807733, 0.623501, 0.432144, -0.002220, -6.850111, -0.011081, -0.004399, -0.759567, 2.556152, -0.002373, 5.869585, -0.199592, -0.742686, -0.077339, 
	-0.016594, 2.657893, -0.303936, 3.359067, -3.063818, -0.008422, -2.333110, -1.728274, -0.013229, -1.741921, 1.419655, -0.008566, 1.969827, -1.276464, 1.137822, -0.049930, 
	-0.081603, -0.020189, 2.291271, 0.070160, -3.244436, -0.005139, 1.388092, -0.028038, -0.011532, -3.424859, 0.609615, -0.005449, 4.281686, -1.618549, 0.132276, -0.333307, 
	-0.037532, -0.008821, 3.200969, -0.807021, -1.472253, -0.003858, -0.519396, -0.017576, -0.006872, -0.874307, 1.550849, -0.004055, 0.735171, -0.921265, -1.128000, 0.313967, 
	-0.015156, -0.005203, -1.616251, 1.114017, -3.806486, -0.001415, 1.926298, -0.005577, -0.003132, 2.517661, 1.728641, -0.001481, -1.670814, -1.075585, 0.932385, -0.017901, 
	-0.007867, -0.008857, -1.971859, 1.435235, -1.280703, -0.002181, -1.577276, -0.019989, -0.006154, 2.578614, -0.971827, -0.002435, 0.056063, -0.728896, 2.708523, -0.200391, 
	-0.001999, -0.000719, 0.251550, 1.069991, -0.524235, -0.000262, 0.485090, -0.000736, -0.000462, -0.524082, 1.273385, -0.000264, -1.680516, -0.317940, -0.026280, -0.002520, 
	-0.003226, -0.004392, 3.522992, 0.507843, 1.977477, -0.001078, -0.612905, -0.002351, -0.001919, -2.479120, -2.911315, -0.001166, 0.493784, -0.309343, 0.091925, -0.267208, 
	-0.006150, -0.002396, -0.068663, 1.810863, -1.406474, -0.000613, 1.759621, -0.001838, -0.001413, 0.136170, -1.361391, -0.000643, 0.006168, -0.507185, -0.350813, -0.005243, 
	-0.262447, -0.134685, -0.331688, 0.743474, -1.035435, -0.049132, -4.582551, -0.197214, 0.156105, -0.483901, 3.345043, -0.181119, -2.172016, 1.272688, 4.426392, -0.513514, 
	-0.021364, -0.019321, 3.467355, -3.612927, -1.295466, -0.004019, 3.933280, -0.017114, -0.009155, -2.644180, 1.984611, -0.004152, -4.380065, 0.768763, -0.014045, 1.867797, 
	-0.014633, -0.007956, 0.421214, -1.868884, 1.335013, -0.003688, -1.108373, -0.016544, -0.006344, -1.299569, 3.175907, -0.003918, -2.388009, -1.373461, 3.242503, -0.083258, 
	-0.002381, -0.002509, -0.354969, -0.186379, 0.794537, -0.000742, -0.997995, -0.004309, -0.001775, 0.218614, -1.598042, -0.000781, -0.724236, -1.068977, 3.960231, -0.030288, 
	-0.017382, -0.015199, -0.334951, -2.344473, -1.806615, -0.003619, -2.673965, -0.036444, -0.009440, 3.572210, 5.488398, -0.113481, -2.879281, 0.693455, 0.160156, 0.320632, 
	-0.002760, -0.001171, -1.353685, -0.115768, 0.021544, -0.000607, -0.599325, -0.001683, -0.000945, 1.262858, -0.408482, -0.000610, 0.912396, 0.379417, -0.082153, -0.009027, 
	-0.005985, -0.005828, 0.642314, 2.391063, -2.017394, -0.001373, -0.068003, -0.003890, -0.002834, -1.115467, 6.672856, -0.001423, -5.358978, -0.548748, -0.485064, -0.091247, 
	-0.002149, -0.002487, -0.324231, -0.426074, 1.020824, -0.000543, 2.098298, -0.003521, -0.001663, -0.409886, -0.641242, -0.000615, -0.344969, -0.164045, -0.743159, -0.054538, 
	-1.581433, -0.705381, 0.728936, 4.058374, 1.622047, 0.271354, -2.334345, -1.167569, -0.623594, 0.013978, -3.368884, -0.261082, -0.590217, 0.548934, -0.099705, 3.488589, 
	-0.435857, 0.036665, 3.857615, 0.927539, 3.529745, -0.047633, 2.641147, -0.376366, -0.116019, -3.372291, -4.928962, -0.053780, 0.541115, -3.673760, 1.670266, -0.199424, 
	-0.043376, -0.021775, 2.784991, -4.648937, -3.783295, -0.009586, 0.647517, -0.026982, -0.015905, 8.338921, 3.641591, -0.010748, 0.985418, -4.193634, -3.372023, -0.272178, 
	-0.015638, -0.016443, 0.060623, -4.510840, 2.587706, -0.004469, 1.320221, -0.018653, -0.010396, 2.859023, -3.360477, -0.004715, -5.591662, 1.462375, 3.612943, 1.630404, 
	2.393065, -0.021560, 0.379030, -1.776813, -3.496347, -0.006510, 1.419353, -0.030529, -0.013948, -0.686891, 1.814619, -0.006844, 0.364233, 0.669092, -0.739897, -0.260054, 
	-0.006238, -0.006113, 3.276153, -0.930947, -0.775433, -0.001335, 0.514096, -0.010346, -0.003914, -1.376320, -1.422610, -0.001465, 0.130831, -0.126622, 0.785422, -0.045158, 
	-0.014183, -0.005440, 0.463595, -0.902418, -1.674816, -0.001995, 3.574032, -0.005619, -0.003315, 0.712604, -4.634672, -0.002023, 2.816055, -0.666854, 0.471798, -0.126750, 
	-0.015812, -0.009479, 1.664211, 1.615333, -1.633281, -0.002113, -5.103807, -0.014875, -0.004908, -2.399714, 1.070104, -0.002211, 3.308651, 2.026807, -0.456005, -0.042899, 
	-0.067559, -0.010704, -0.412029, 0.405938, 1.551177, -0.003184, -7.558242, -0.057567, -0.009468, -1.647260, 6.764894, -0.003398, 3.353303, -1.410471, -0.752019, -0.143413, 
	-0.045546, 0.008074, -3.774413, 2.107445, -2.114794, -0.011139, -0.214862, -0.069627, -0.020128, 5.681862, -5.045850, -0.141050, -2.903283, -0.755238, 7.290356, 0.008194, 
	-0.002444, -0.002055, 1.383229, -0.550201, -0.439152, -0.000481, -0.786900, -0.002496, -0.001271, 0.068627, -0.288381, -0.000538, 1.619815, -1.310866, 0.337701, -0.024587, 
	-0.012041, -0.005437, 0.523639, 1.916683, -0.398922, -0.001740, -0.744967, -0.007321, -0.003775, 1.163470, 3.028675, -0.001852, -3.706842, -0.988870, -0.398823, -0.361878, 
	-0.056390, -0.013744, -5.377662, -1.281494, 1.374848, -0.004198, 1.096451, -0.009395, -0.007536, 3.605799, 1.096453, -0.004276, -5.122381, 5.383379, -0.588589, -0.091265, 
	-0.041754, -0.016543, -0.524669, 0.569435, 1.428862, -0.005109, 0.167962, -0.047527, -0.012253, -0.526737, 1.402010, 0.018931, -1.509723, -2.242956, 1.496151, -0.156080, 
	-0.012498, -0.010048, -2.007297, -0.868999, -0.932791, -0.002546, 6.807160, -0.012016, -0.005713, 2.005752, -5.593839, -0.002477, 3.146946, -0.480793, -1.904500, -0.126341, 
	-0.078923, -0.051879, 3.843984, 1.521748, 1.359067, -0.019355, -1.591617, -0.058131, -0.037295, -1.385856, 0.099192, -0.024219, 0.605497, -0.392951, -3.300787, -0.488475, 
	-0.002009, -0.002166, 0.198900, -0.667522, 0.746890, -0.000706, -0.151725, -0.001317, -0.001207, -0.131163, -0.192142, -0.000712, -0.141429, 0.440412, -0.013325, -0.080778, 
	-0.010652, 0.004757, -2.446545, 1.964464, -0.568464, -0.001745, 0.599183, -0.018723, -0.004866, -1.100349, -0.821258, -0.001836, 0.324190, 2.477405, -0.369373, -0.026188, 
	-0.014790, -0.005870, -2.854061, -0.063275, -1.665437, -0.001306, 3.197265, -0.006798, -0.003488, 0.586666, 3.112742, -0.001398, -1.238156, -0.427093, -0.557196, -0.057804, 
	-0.003081, -0.002129, -0.411194, 0.967003, 0.577656, -0.000666, -0.095881, -0.001707, -0.001276, 1.523956, -0.495345, -0.000662, -0.535206, -1.299120, -0.127519, -0.094830, 
	-0.010495, -0.006513, -0.197246, 0.723651, 2.749104, -0.001437, -2.280733, -0.006151, -0.003649, -1.090042, -2.061240, -0.001886, -0.474115, 0.405190, 2.337984, -0.082423, 
	-0.008094, -0.003028, -0.547681, 0.241596, 4.988266, -0.001145, -1.655534, -0.002948, -0.001990, -0.807605, -1.272131, -0.001194, -1.555461, -0.278062, -0.648092, 1.553104, 
	-0.000535, -0.000791, -1.102932, 0.034249, -0.390237, -0.000287, 0.936204, -0.000770, -0.000536, 0.950766, -0.642896, -0.000299, -0.792353, 0.451389, 0.567720, -0.008691, 
	-0.002467, -0.002844, -0.176979, 0.992645, -0.354414, -0.000715, -0.742609, -0.003918, -0.001817, -1.876142, 4.018280, -0.000805, -2.487821, 1.109636, -0.449516, -0.020515, 
	-0.014750, -0.006307, -0.387247, -0.967933, -1.273629, -0.001424, 0.302386, -0.017245, -0.005260, 4.984664, -0.497531, -0.001644, -0.312506, -0.847883, -0.912969, -0.040722, 
	-0.030223, -0.004091, -1.815222, 2.760890, 0.080536, -0.001886, -2.427347, -0.007441, -0.003502, 0.896826, -1.171903, -0.001987, 2.948002, -0.831052, -0.334590, -0.057010, 
	-0.006878, -0.003046, -0.143174, 1.365160, -1.049079, -0.000766, -0.677505, -0.001268, -0.001284, -0.567956, -1.290452, -0.000803, 1.980132, 0.125472, 0.286645, -0.015199, 
	-0.020379, -0.006969, -0.359438, 0.322410, -1.536693, -0.002107, -1.079079, -0.021304, -0.005015, 0.260711, -3.376043, -0.002242, 5.352362, 0.060232, 0.486257, -0.072704, 
	-0.002365, -0.002833, 2.063594, -0.307202, -0.380925, -0.001011, 0.066891, -0.002376, -0.001740, -1.756521, 1.697166, -0.001051, -1.989175, 0.012235, 0.645414, -0.040100, 
	-0.593565, -0.271845, -3.002327, -6.498057, -2.321150, -0.071814, 1.941118, -0.410171, -0.165324, -3.998005, 3.882304, -0.082984, 9.949836, 0.266922, 1.791611, -0.416549, 
	2.328465, -0.062880, -0.230233, -0.642820, 0.335102, -0.008932, 0.681512, -0.075402, -0.028508, -2.141750, -1.465289, -0.010033, 2.436495, 0.665687, 0.060504, -1.841916, 
	-0.108101, 0.740467, -1.890039, -0.757608, 0.940491, -0.005191, 0.130886, -0.165959, -0.017924, -0.528146, 1.216706, -0.006205, 1.775129, -1.276788, 0.131393, -0.179110, 
	-0.011618, -0.003538, 0.230927, 1.511355, -1.548242, -0.001368, -1.445229, -0.029080, -0.004094, 0.923291, -0.682643, -0.001374, 0.864148, -0.599992, 0.845648, -0.048192, 
	-0.002601, -0.001730, -1.105057, -0.328111, 3.318883, -0.000692, -0.867442, -0.002024, -0.001179, 1.101362, -1.722599, -0.000689, -0.409792, 0.113200, -0.082922, -0.008609, 
	-0.524108, -0.213430, -6.064481, -6.798648, -3.426549, -0.034052, 4.776567, -0.370056, -0.102042, -6.010563, 6.788327, -0.037726, 11.619918, 1.083525, 0.417628, -1.104309, 
	-0.048298, -0.022288, 4.306575, -0.474902, 0.413619, -0.006446, -2.160502, -0.020761, -0.012718, -1.230054, -2.029991, 0.042147, 0.116391, 3.646937, -2.397500, -0.122210, 
	-0.003761, -0.002765, -0.235583, 3.584651, -1.242066, -0.001552, -0.399132, -0.002891, -0.002262, -1.716167, -1.726633, -0.001599, 0.457799, 1.590346, -0.271133, -0.027255, 
	-0.026431, -0.010638, 1.351073, 0.934480, -2.462495, -0.002031, 1.146832, -0.059843, -0.005431, 0.329383, 6.972232, -0.131562, -5.132731, -1.515039, -1.304257, -0.083542, 
	-0.012876, -0.012494, -1.215422, 2.238356, -2.390058, -0.002141, 2.094838, -0.015900, -0.006771, -0.331196, -1.431514, -0.002433, 0.816501, -0.624501, 1.045184, -0.149573, 
	-0.016596, 0.270754, -2.910227, 1.131332, 1.632915, -0.002771, -0.468776, -0.114848, -0.005636, 1.186582, -1.848793, -0.002922, -1.161514, 2.229172, 0.126673, -0.045344, 
	-0.012666, -0.007992, -0.522684, -2.205721, 1.841508, -0.001534, 2.784169, -0.007688, -0.003864, -0.449468, -6.674420, -0.001666, 3.783461, -0.065603, 1.814477, -0.270307, 
	-0.038164, -0.009975, 5.951552, -0.631463, -1.780822, -0.003819, -2.738806, -0.012412, -0.007172, -2.837809, 8.964812, -0.004010, -5.073787, -0.269205, -1.448027, -0.060893, 
	-0.011815, -0.010358, 2.301233, -0.351948, -1.166031, -0.002327, 0.389551, -0.017928, -0.006163, -1.693661, 0.818927, -0.002525, -1.863996, 1.939423, -0.175051, -0.147332, 
	-0.008765, -0.006449, -0.675482, -0.843478, 1.360404, -0.001584, -1.032504, -0.008572, -0.003942, -0.271705, 4.746480, 0.047488, -2.336529, -1.503482, 0.596754, -0.058634, 
	-0.015594, -0.005155, 0.060117, 1.947682, -0.526510, -0.002016, 1.781168, -0.028270, -0.004003, -1.637951, 3.587725, -0.002176, -4.276379, -0.309047, -0.524400, -0.045191, 
	-0.039325, -0.012335, 0.191098, -3.405650, -1.602488, -0.001988, 4.333894, -0.019884, -0.007405, -0.076256, -0.541366, -0.001187, 3.225448, -2.816470, 0.874626, -0.100712, 
	-0.001881, -0.002335, -0.599433, -0.374833, -0.065489, -0.000515, 0.510319, -0.001417, -0.001215, -0.088974, 1.065510, -0.000547, -1.134929, 0.659458, 0.068222, -0.031940, 
	-0.002056, -0.001179, 1.636578, 1.342917, -0.076687, -0.000290, -0.169537, -0.002152, -0.000719, -1.012734, -0.077050, -0.000323, 0.262824, 0.115714, -2.004816, -0.010492, 
	-0.017702, -0.009894, -1.314292, 0.190499, 0.392757, -0.003277, -0.744484, -0.011749, -0.006352, 0.588901, 5.158348, -0.003371, -2.385522, -2.102116, 0.356031, -0.087777, 
	-0.035829, -0.007244, -0.674231, 0.228526, -0.059795, -0.001291, 1.024607, -0.005093, -0.003190, -0.698092, -1.309809, -0.001418, 2.318112, -0.739604, 0.120824, -0.156473, 
	-0.047814, -0.007349, 0.134217, -1.947162, 4.284453, -0.001446, 3.392341, -0.012207, -0.008101, 1.111327, -0.684287, -0.001576, -3.798762, -1.289348, -0.486400, -0.637886, 
	-0.002054, -0.001989, -1.077485, 1.041142, -0.181652, -0.000531, -0.962291, -0.002052, -0.001237, -0.307247, 1.599103, -0.000553, -1.579018, 0.310294, 1.185322, -0.019751, 
	-0.007048, -0.004625, -1.013599, -0.721003, 0.370367, -0.001062, 1.752103, -0.005051, -0.002602, -0.015084, 0.428143, -0.001129, -0.127175, -0.114610, -0.465353, -0.072272, 
	-0.001297, -0.001550, -0.565141, 0.740585, -0.075457, -0.000698, 3.649654, -0.002415, -0.001220, -0.465635, -1.189995, -0.000715, -1.551797, -0.432481, -0.088426, -0.013413, 
	-0.001659, -0.001035, -0.198117, 0.112402, -0.180490, -0.000280, 1.200629, -0.001221, -0.000903, 0.175494, -0.363730, -0.000300, -0.202052, -0.110326, -0.367415, -0.060996, 
	-0.058284, -0.015040, -0.314505, -2.503828, -0.317148, -0.002835, 0.203367, -0.056984, -0.008686, -0.794684, 0.052933, -0.003115, 1.263552, 3.347233, -0.692697, -0.099279, 
	-0.005651, 0.007375, -0.371570, 1.023943, 1.724795, -0.001438, -0.597458, -0.008642, -0.002314, -0.198714, -3.957498, -0.001467, 2.447681, -0.102809, 0.070814, -0.027048, 
	-0.018419, -0.008840, -0.962517, -0.552573, -0.394883, -0.002252, -2.185414, -0.031881, -0.007011, 1.413077, 1.455875, -0.006868, 0.503453, -0.152787, 0.355906, 0.595135, 
	-0.279816, -0.144341, -3.766782, -1.333196, 0.903800, -0.043992, 9.863665, -0.193545, -0.082421, -3.659701, 0.804399, -0.050884, -5.012508, -3.211981, 5.398841, 0.808461, 
	-0.017555, -0.012328, -0.795120, -1.425942, 0.831329, -0.004307, 0.593945, -0.017009, -0.008862, -1.760489, 0.566777, 0.019876, -4.107364, 3.331325, 2.983267, -0.177544, 
	-0.007878, -0.004841, 1.142238, 0.024193, 0.676313, -0.001232, 1.081061, -0.005132, -0.002937, -0.991440, -0.023107, -0.001306, -0.084533, -1.186441, -1.155182, 0.540223, 
	-0.079731, -0.034311, 0.042646, -1.257232, -4.184595, -0.016008, -0.871756, -0.165698, 1.111808, 1.186199, 5.471590, -0.016376, 0.389961, -0.073355, -1.412078, -0.091064, 
	-0.015211, -0.008806, -0.865258, 1.493874, 4.249624, -0.002232, 1.890583, -0.011215, -0.004447, 0.377551, -3.508126, -0.002871, -2.246509, -0.529295, -1.062163, 0.244502, 
	-0.005360, -0.003007, 0.515061, 0.823944, 0.227100, -0.001122, 1.774895, -0.003414, -0.002256, -1.043598, 0.551650, -0.001133, -1.296361, -0.563466, -0.933191, -0.039741, 
	-0.012922, -0.006121, -2.178628, 3.162387, 2.403662, -0.002360, 0.784636, -0.007272, -0.004554, -0.318863, 3.087432, -0.002391, -5.946419, -0.381027, -1.622001, 1.044441, 
	-0.009821, -0.003836, 0.961243, -2.978741, -1.439433, -0.001645, 0.005730, -0.017974, -0.003289, -1.005605, 1.944003, -0.001760, -0.650022, 3.883682, -0.647945, -0.034585, 
	-0.020598, -0.004421, -1.148674, 2.134210, -1.522174, -0.001195, -2.130774, -0.011619, -0.002701, 1.585096, 2.252796, -0.001334, 0.569269, -1.395798, -0.219406, -0.082678, 
	-0.004702, -0.002073, -0.003053, 0.730843, -0.160306, -0.000847, -0.938045, -0.004043, -0.001616, 0.318505, 0.045632, -0.000827, 0.497734, -0.650275, 0.192831, -0.019759, 
	-0.021978, -0.011299, 1.766092, -3.475869, -1.017882, -0.002336, -1.527822, -0.029212, -0.006921, -2.410841, 5.795946, -0.002676, -1.028160, 0.300170, 1.823027, -0.150238, 
	-0.235147, -0.135293, 3.991024, 0.462072, 10.302041, -0.034394, 1.443732, -0.097361, -0.063329, -10.245032, -5.926819, -0.035874, 8.474913, -3.532247, -3.324068, -1.044217, 
	-0.028478, -0.000382, -0.347705, 1.473972, -0.586254, -0.000268, -0.024546, -0.006321, -0.000436, -0.209732, -1.580696, -0.000869, 1.525088, -0.149109, -0.044886, -0.019380, 
	-0.003987, -0.004281, -0.036331, -0.617991, -0.631095, -0.000911, -0.682283, -0.003827, -0.002021, -0.311847, 3.917545, -0.001044, -1.797958, 0.469763, -0.704339, 0.410606, 
	-0.036814, -0.020481, 0.528637, -3.925788, -1.264815, -0.005198, -2.394137, -0.018964, -0.010407, 2.503288, 3.740982, -0.005590, -1.261789, 1.498094, 0.834359, -0.161378, 
	-0.026767, 0.472143, 0.196892, -2.776032, -0.308540, -0.004165, -0.236644, -0.496644, -0.009491, 4.973140, -3.183758, -0.004431, 1.314292, 1.039012, -0.813160, -0.135846, 
	-0.015708, -0.006854, -1.169029, 5.707174, -1.104089, -0.003341, -2.550118, -0.010766, -0.005327, -2.794547, 11.054808, -0.003451, -9.895725, 1.099599, -0.231816, -0.070810, 
	-0.012679, -0.009396, 3.698271, -0.915530, 1.418261, -0.002742, 0.713399, -0.011634, 0.002422, -0.410523, -4.819732, -0.002951, 2.354411, -1.687864, -0.220851, -0.092863, 
	-0.027569, -0.003365, 0.987354, 0.250100, 0.225221, -0.000716, 0.992154, -0.003741, -0.002022, -1.202798, -2.007091, -0.000771, 1.677687, -0.125732, -0.652891, -0.105819, 
	-0.008542, 0.272860, -1.273082, 1.029402, -0.283356, -0.001294, 1.595433, -0.265486, -0.002388, -1.262338, -0.567981, -0.001294, 0.903148, 0.461012, -0.562364, -0.033729, 
	-0.030911, 0.180710, -0.862639, 0.140362, 2.126089, -0.002757, 3.887743, -0.074183, -0.005706, -1.007264, -4.179016, -0.002913, -4.206270, -0.171212, 4.325598, -0.117631, 
	-0.008738, -0.005512, -1.066601, 0.079180, -1.217575, -0.002032, 1.937798, -0.004519, -0.003400, -0.254904, 2.162159, -0.002106, -1.653352, -0.114844, 0.222555, -0.068107, 
	-0.047529, -0.013608, -1.430301, 4.759471, -1.455437, -0.003540, -0.741828, -0.038340, -0.009354, -1.163983, -0.720239, -0.003774, -2.811816, 0.074364, 3.711935, -0.106022, 
	-0.000953, -0.001947, 1.393238, -0.284955, -0.063691, -0.000446, -0.069732, -0.002076, -0.001232, 1.037101, -0.578054, -0.000665, -0.205365, -1.158745, -0.055711, -0.006767, 
	-0.002445, -0.001265, 1.053398, -0.225119, -0.097747, -0.000373, -0.839020, -0.001004, -0.000754, -0.614073, 0.149976, -0.000389, 1.051311, -0.159634, -0.294691, -0.018171, 
	-0.087521, -0.030716, 1.635832, 3.655130, -1.426017, -0.009136, 1.187628, -0.077065, -0.021926, -2.423944, -2.636477, -0.010134, -0.433811, -2.065348, 3.173436, -0.429931, 
	-0.010231, -0.012282, 1.451413, 3.108171, -0.686175, -0.002079, -1.057241, -0.011548, -0.005885, 0.094738, -0.476080, -0.002222, -1.362599, -1.811732, -0.283669, 1.067422, 
	-0.017853, -0.003146, -0.774896, 0.175260, -0.526081, -0.001192, 1.954664, -0.022456, -0.002976, -2.111525, 0.149427, -0.001318, -1.492298, 3.409007, -0.723131, -0.011486, 
	-0.020231, -0.013191, 1.463043, 6.853058, -0.234988, -0.005723, -2.432037, -0.013590, -0.009170, -5.096977, -4.561226, 0.018597, 4.812131, -1.917115, 1.266591, -0.109171, 
	-0.096470, -0.027445, -0.838949, -0.922069, 3.356302, -0.008773, -5.339917, -0.063576, -0.019400, -2.563864, 2.209756, -0.008473, 5.810129, -1.056489, -0.231315, -0.199447, 
	-0.038838, 0.003721, -1.159509, 3.636947, 0.206498, -0.002511, 1.655784, -0.018861, -0.006096, 1.838308, -4.175901, -0.002852, -1.844592, -1.479180, 1.624329, -0.237248, 
	-0.027873, -0.012253, -2.390199, -1.146294, 0.527369, -0.003751, 1.898313, -0.014973, -0.008022, 1.968159, 1.797033, -0.003895, 0.618550, -1.926712, -1.269964, -0.005488, 
	-0.021076, -0.012250, -0.249436, -5.008973, 2.229907, -0.002207, -1.223565, -0.025998, -0.007130, 1.216958, 3.134584, -0.002540, 1.379040, 0.903467, -2.178185, -0.132597, 
	-0.010204, -0.003452, -0.446211, 0.331350, -1.007094, -0.000997, 0.790761, -0.005007, -0.002388, 0.105846, -3.456721, -0.001059, 3.270478, 0.684232, -0.208719, -0.040814, 
	-0.005325, -0.004863, -0.590355, 1.678964, 1.019821, -0.002181, -1.278352, -0.004603, -0.003462, -0.298181, 1.068198, -0.002290, -2.148387, -1.324319, 1.933851, -0.038515, 
	-0.070805, -0.017561, 4.951921, -1.597484, 0.917413, -0.002248, 1.580860, -0.017472, -0.006821, -2.263416, -0.705481, -0.002467, -1.167728, -2.169384, 0.729964, -0.159289, 
	-0.031963, -0.015121, -0.597955, -1.466444, -3.285518, -0.004537, 3.482289, -0.015263, -0.008042, 4.571081, -0.217874, -0.004793, 0.244917, -1.273264, -1.167165, -0.210348, 
	-0.009661, -0.004130, 0.995417, -0.575103, 1.315614, -0.002216, 0.075330, -0.005544, -0.003408, 1.458472, 6.688723, -0.002251, -9.199219, 0.210101, -0.918998, -0.023128, 
	-0.101307, 0.520999, 3.623098, 1.003462, -2.166200, -0.008474, 1.420414, -0.193235, -0.022423, 0.765360, -1.320219, -0.009350, -2.199986, -0.267362, -0.144715, -0.900062, 
	-0.001944, -0.001757, -0.850271, 0.168321, 0.455125, -0.000815, 0.781950, -0.002071, -0.001406, -0.217107, -1.805387, -0.000846, 1.464849, -0.064798, 0.091370, -0.015211, 
	-0.009036, -0.004331, 1.539661, 1.543914, -0.220013, -0.001533, -1.007159, -0.010864, -0.003264, 1.015418, -0.691806, -0.001579, -0.860787, -1.068583, -0.157478, -0.062558, 
	-0.027157, -0.001237, 0.804440, -0.659462, -0.430990, -0.000440, -0.039905, -0.002581, -0.001141, -0.744852, -2.784620, -0.000475, 3.301930, -0.298630, 0.917874, -0.032754, 
	-0.021330, -0.006541, 2.289170, 2.380206, 0.858858, -0.002001, 0.473174, -0.007819, -0.004544, -0.815796, -1.912255, -0.002031, -2.045826, -1.268909, 0.231737, -0.146092, 
	-0.023830, -0.006031, -0.182462, -0.278889, 0.813853, -0.004714, 0.441611, -0.007131, -0.004526, 0.907911, -3.509062, 0.060636, 0.207732, 0.031938, 0.473391, 1.079572, 
	-0.010688, -0.012895, -1.130797, -1.775989, -5.708022, -0.003157, -0.244884, -0.015087, -0.007434, -3.191171, 3.313168, -0.003628, 1.950366, 4.934954, 1.997003, -0.091739, 
	-0.007378, -0.002675, 0.732104, -1.068025, -1.980281, -0.001416, 3.992316, -0.003019, -0.002150, 0.042362, 2.786958, -0.001447, -3.732720, -0.547397, -0.176552, -0.030682, 
	-0.094613, -1.631900, -0.189681, 2.931191, 3.086157, -0.017753, 1.389352, 3.162486, -0.914409, 0.761437, -2.847946, -0.018551, -2.368720, -2.259558, -2.019686, 1.032193, 
	-0.023316, -0.007209, -1.979144, -2.912016, -0.473460, -0.001925, 1.565343, -0.009213, -0.004597, 7.365965, -0.128636, -0.002281, -1.951700, -2.361710, 0.949818, -0.025920, 
	-0.004791, -0.003496, 1.933050, 2.413961, -0.387214, -0.001145, 0.089413, -0.014568, -0.000078, -1.182000, 0.296980, -0.001260, -1.922429, -0.539908, -0.641685, -0.034831, 
	-0.033890, -0.007790, -1.521000, 2.594618, 1.771192, -0.003134, -6.972171, -0.020165, -0.005785, -1.088781, 4.431662, -0.003150, 1.392671, -0.965680, 0.681253, -0.249849, 
	-0.003148, -0.003503, -0.406937, 0.581627, -0.561663, -0.000515, 0.629077, -0.002576, -0.001353, -0.270868, 0.345513, -0.000557, -0.922627, -0.737215, 1.367538, -0.012792, 
	-0.033317, -0.014282, -1.402081, 0.411807, -0.414868, -0.003012, 1.519584, -0.057763, -0.011642, -0.841969, -0.782997, -0.005598, 1.315050, 2.305260, -3.556594, 1.572423, 
	-0.018997, 0.010806, -4.295722, 0.344402, -0.026539, -0.003959, 3.490835, -0.029876, -0.007120, 4.952456, -1.878745, -0.004096, 1.026260, -1.215084, -2.231200, -0.113422, 
	-0.013910, -0.001205, 0.163002, -0.253272, 0.162238, -0.000544, -0.283525, -0.013577, -0.001043, -0.165722, 0.375313, -0.000574, -0.594543, -0.344229, 0.989837, -0.018246, 
	-0.062293, 0.343885, -0.868363, 3.857481, -0.660599, 0.183119, 1.924840, -0.264924, -0.023527, -2.019487, 0.818494, -0.011827, -1.191526, -1.870329, 0.099658, -0.254602, 
	-0.021690, -0.010440, -1.422416, 6.508185, -3.660149, -0.002787, 0.159754, -0.013595, -0.006509, -1.007293, -0.959971, -0.003009, 2.939757, -1.726673, -0.487646, -0.285519, 
	-0.003601, -0.003395, 10.991078, -1.251480, -0.872774, -0.001787, -0.453651, -0.003261, -0.002735, -4.417296, -0.598147, -0.001848, -0.514328, -1.862736, -0.954084, -0.049954, 
	-0.009039, -0.002313, -0.357144, 0.209231, -0.857569, -0.000905, -1.205265, -0.006638, -0.001990, 0.056650, -0.008059, -0.000941, 1.883209, -0.646905, -0.808269, 1.755947, 
	-0.000427, -0.000435, -0.037748, 0.230522, 0.086473, -0.000248, -0.528522, -0.000326, -0.000318, -0.442561, -0.116950, -0.000250, 0.514180, 0.384434, -0.080265, -0.007558, 
	-0.013331, -0.003048, 1.433558, 0.105063, 0.715568, -0.000938, 0.599393, -0.006885, -0.002302, -1.339738, 1.758720, -0.001015, -1.210053, -1.725480, -0.286508, -0.023004, 
	-0.086849, 0.317924, 0.089248, -3.530763, 1.554227, 0.177582, -3.117205, -0.261182, -0.032787, -3.650318, -1.511716, -0.026067, 4.670336, -1.849301, 5.286649, 1.970223, 
	-0.005013, 0.034219, -0.250636, 2.974159, 0.953631, -0.001498, 1.746957, -0.041113, -0.003168, -2.923031, 0.330631, -0.001549, -1.627519, -0.881802, -0.210791, -0.093477, 
	-0.096228, -0.038218, -1.019701, 2.830552, -2.604651, -0.009288, 2.112473, -0.043801, -0.021596, -1.438705, -2.815097, -0.010000, 0.277601, 1.809219, 1.282993, -0.215553, 
	-0.059571, 0.119897, 0.567813, -1.626014, -0.070213, -0.003543, 1.605702, -0.158530, -0.005228, -1.653180, 1.033205, -0.003796, -2.743956, 0.610718, 2.599231, -0.212537, 
	-0.014508, -0.009874, 3.091609, 4.232566, -2.675175, -0.004319, 2.854192, -0.013850, -0.007711, -1.983886, -0.579334, -0.004671, -1.817574, -2.060805, -0.937677, -0.068983, 
	-0.005257, -0.003877, -0.179114, -0.999920, -0.235179, -0.001202, -0.913921, -0.007552, -0.002550, -0.758317, 3.853061, -0.001270, -0.073435, 0.342512, -0.987535, -0.026443, 
	-0.009381, -0.007629, -0.006640, 0.249981, -3.405445, -0.000861, 0.879545, -0.009892, -0.002909, -2.946541, 5.250257, -0.000911, -1.840916, 0.056569, 1.921360, -0.126588, 
	-0.082746, -0.021062, -2.868989, -0.697877, -2.058224, -0.004941, -0.656107, -0.023455, -0.013327, 0.870095, 2.108254, -0.005233, -0.159473, 4.791488, -0.629182, -0.549220, 
	-0.024806, -0.023467, -2.532954, -4.397714, 2.989173, -0.008630, -0.968596, -0.030720, -0.016125, 1.553047, -3.735358, -0.008866, 0.594863, 5.935436, 1.027135, -0.352416, 
	-0.002553, -0.002522, 0.100356, 1.924982, -0.281061, -0.000692, 1.664560, -0.006379, -0.001583, -0.583752, -1.314362, -0.000708, -1.051240, -0.279944, -0.103835, -0.061266, 
	-0.004306, -0.002681, 2.347865, 0.286943, -1.469410, -0.000978, 0.232133, -0.007046, -0.002206, -1.503868, -1.463121, -0.001035, -0.111674, 0.509594, 1.243261, -0.053470, 
	-0.025637, -0.005177, 0.726793, -0.310290, 1.611886, -0.002976, 3.091791, -0.007193, -0.004274, -1.899117, -0.303702, -0.003025, -3.033149, 0.274985, -0.077587, -0.033328, 
	-0.019699, -0.002917, 0.254639, -0.144473, -1.436502, -0.000952, -0.729854, -0.005892, -0.002405, -0.694924, 1.477581, -0.001015, 0.105569, -0.341449, -0.090772, 1.633064, 
	-0.003784, -0.003615, 3.667170, -0.140533, -0.157676, -0.000777, 0.574251, -0.004873, -0.002553, 0.271448, -2.353416, 0.047778, -0.826183, -1.274609, 0.327575, -0.120203, 
	-0.809933, -0.058780, 2.669711, -0.491397, 0.712183, -0.114506, 1.051343, -0.715837, -0.267719, -0.256972, 1.514086, -0.133876, 2.325533, -5.007951, 3.498387, -3.914271, 
	-0.004745, -0.002716, 0.349036, 1.836126, 0.134704, -0.000823, 0.166224, -0.002790, -0.001529, -1.124895, -0.126264, -0.000821, -0.448453, -0.447962, -0.301050, -0.024041, 
	-0.001685, -0.001322, -0.035750, -0.155437, 1.468936, -0.000260, 0.042932, -0.000671, -0.000620, 0.227513, -0.199143, -0.000285, -1.283860, -0.026951, -0.032344, -0.001054, 
	-0.000407, -0.000310, 0.343659, 0.113466, 0.292335, -0.000127, 0.093878, -0.000303, -0.000240, -0.178401, -0.473926, -0.000131, -0.085881, -0.057393, -0.031240, -0.014978, 
	-0.013385, 0.177179, 4.407087, -1.821348, 3.818528, -0.003878, -0.834731, -0.073311, -0.008313, 0.987858, -2.982735, -0.003960, -4.543906, 0.046383, 0.968939, -0.120407, 
	-0.021230, -0.008139, 2.843788, 1.685689, 0.027418, -0.002155, -1.220302, -0.010069, -0.005188, 0.969524, -3.220589, -0.002312, 0.770073, -0.147115, -1.577697, -0.081697, 
	-0.005908, -0.000844, -0.042424, 0.489729, -0.811230, -0.000286, -0.405732, -0.003096, -0.000645, -0.251428, -2.533680, -0.000296, 3.707011, -0.684330, 0.558612, -0.015454, 
	-0.035318, -0.010862, -0.846405, -0.906094, 9.453070, -0.002865, 0.954347, -0.009571, -0.006319, -0.125686, -0.561773, -0.003034, -6.207180, -0.710252, -0.786545, -0.195514, 
	-0.063720, -0.040630, -1.150292, 0.251191, 0.617291, -0.012028, 2.045925, -0.081185, 0.266367, -4.920479, -0.754351, -0.012761, 1.088935, 3.413867, -0.260727, -0.387404, 
	-0.017985, -0.007281, -1.035939, 1.358208, 0.097938, -0.002545, 3.672743, -0.008383, -0.004840, -1.115839, -4.373627, -0.002667, 2.077522, 0.823913, -1.428512, -0.032705, 
	-0.014181, -0.010222, 1.028648, 4.585319, 4.191915, -0.003033, -6.101148, -0.010831, -0.006012, 0.994594, -0.837139, -0.003201, -1.486582, -0.981823, -1.280953, -0.065350, 
	-0.013496, 0.004447, -0.857136, -0.424841, 0.371563, -0.002807, 0.893913, -0.026151, -0.007113, 0.014828, 2.705584, -0.003004, -1.909222, 0.856648, -1.450519, -0.152694, 
	-0.284746, -0.085394, -2.419303, 2.655644, 2.704104, -0.020270, -0.373027, -0.147873, -0.052261, -1.898033, -0.486544, -0.025750, 4.607471, -0.365846, -2.818504, -0.989670, 
	-0.068523, -0.008584, -0.998664, 0.816906, 1.334905, -0.002765, 3.921588, -0.010810, -0.005558, -1.214877, -6.469687, -0.002885, 0.835091, 2.966479, -1.037887, -0.054729, 
	-0.006921, -0.004354, -0.033159, -1.077233, 1.030768, -0.001316, -1.521284, -0.005372, -0.002479, 0.181260, 2.837770, -0.001310, -2.108505, 0.368840, 0.455770, -0.112474, 
	-0.151000, -0.098829, 0.023522, -0.539556, 0.977770, -0.036768, 3.168402, -0.127313, -0.070030, -2.180851, 1.342288, -0.039217, 3.638307, -4.578279, -0.038848, -1.289599, 
	-0.033182, -0.013049, 2.057179, 0.109553, -5.556333, -0.003087, 0.760386, -0.014793, -0.006745, -0.461279, 8.136479, -0.003413, -3.623079, -1.343149, 0.177835, -0.183323, 
	-0.010544, -0.006486, -0.805330, 2.629030, 2.105448, -0.001539, 0.163943, -0.019209, -0.004839, 0.334389, -1.270366, -0.001756, -3.430414, 1.098126, -0.717995, -0.062459, 
	-0.035830, -0.025828, -3.621013, -0.569187, -2.390841, -0.003938, -0.876729, -0.064560, -0.012111, -2.359978, 7.077721, -0.004412, 1.700645, 1.363959, -0.013136, -0.164763, 
	-0.001398, -0.001694, -0.017206, 0.309591, -0.217592, -0.000175, -2.044664, -0.001274, -0.000932, -0.267644, 3.280444, -0.000206, -0.672966, -0.109237, -0.243798, -0.011248, 
	-0.040169, -0.012254, -0.217972, -0.389791, -2.468431, -0.006865, 0.172763, -0.014995, -0.009476, -1.412999, -1.030552, -0.006963, 1.588618, -0.480516, 2.430377, 1.899225, 
	-0.009152, -0.005655, -1.211286, 0.672678, 1.533854, -0.002874, -2.909756, -0.005616, -0.004247, 0.578970, -0.929345, -0.002896, 2.956023, -0.483717, -0.135043, -0.041938, 
	-0.215090, -0.094525, -1.953555, 0.388266, 3.845679, -0.037730, 1.306694, -0.095649, -0.058401, -3.913494, 1.158401, -0.050867, 5.670669, -3.570419, -3.457563, 1.077582, 
	-0.014730, 2.878441, -0.901690, 0.576275, -0.555710, -0.003686, -1.258748, -2.595556, -0.006153, -0.894118, -1.276215, -0.003776, 5.027082, -0.407670, -0.041576, -0.522171, 
	-0.030115, 0.266943, 0.133765, -2.757514, 1.024997, -0.004648, 2.613075, -0.297099, -0.011158, 1.857092, -6.428258, -0.005067, 4.057261, -1.716398, 0.211582, 1.085542, 
	-0.017852, -0.005318, -0.949993, 0.384295, -0.460609, -0.002755, 0.578375, -0.011045, -0.004158, 4.333669, 1.598852, -0.002878, -2.645191, -1.615875, -1.151883, -0.027633, 
	-0.005853, 2.348992, 0.078532, 1.694487, -0.424739, -0.004338, -0.044385, -2.119677, -0.005910, -0.387213, -1.996636, -0.004363, 2.877005, -0.977334, -1.017916, -0.010652, 
	-0.019869, -0.006144, -2.557543, -2.975068, 0.826125, -0.002175, -0.669567, -0.013264, -0.004734, 7.791735, -2.519183, -0.002291, -0.037019, 1.027284, -0.800940, -0.037347, 
	-0.010418, -0.003327, -0.475030, -0.624945, -0.672678, -0.001186, -1.758942, -0.004699, -0.002302, -0.260218, -4.510446, -0.001270, 8.069148, -0.134915, 0.370558, 0.020669, 
	-0.007596, -0.002430, 0.084018, 0.863695, -0.581899, -0.000940, -0.918367, -0.003048, -0.001625, 0.277312, 1.869459, -0.001042, -2.053106, -0.577424, 1.089072, -0.036079, 
	-0.111978, -0.032383, 0.029411, -2.503624, -0.558351, -0.005306, -0.408701, -0.026765, -0.011822, 2.751217, 0.287168, -0.005606, 1.745571, -1.251889, 0.255563, -0.152505, 
	-0.035641, -0.016569, -1.745393, -0.547928, 0.104724, -0.006199, 0.687082, -0.017442, -0.011324, 8.138819, -2.649499, -0.006626, -0.538516, -1.653796, -1.419189, -0.282503, 
	-0.032155, -0.019144, 1.205000, 2.153151, 0.348824, -0.014134, -2.245610, -0.024718, -0.013562, 0.989431, 1.869074, -0.014376, -2.374942, 0.743047, -3.542763, 0.972877, 
	-0.018349, -0.012724, -2.449426, 2.840666, 0.560322, -0.002764, -1.537209, -0.012119, -0.006961, 2.476563, -3.677172, -0.003130, 2.692948, -0.824748, 0.357429, -0.383327, 
	-0.006713, -0.007622, -0.605900, 1.076831, -1.267686, -0.001220, -4.459721, -0.006936, -0.004117, -0.792457, 7.626366, -0.001382, -3.239191, 0.503529, 1.236936, -0.050718, 
	-0.048394, 0.474219, -0.811945, 1.784428, 0.038036, 0.190158, -3.351613, -0.494592, -0.008622, -2.198076, 3.898178, -0.004970, 2.428938, -2.109449, 0.312849, -0.099145, 
	-0.356830, -0.107302, -2.861798, 0.632078, -0.987494, -0.038823, 6.521291, -0.133316, -0.074006, 3.675730, -7.683047, -0.041208, 9.652562, -1.744111, -4.447054, -2.006673, 
	-0.001689, -0.001767, -0.131909, 0.086730, 1.073414, -0.000713, -0.108239, -0.001725, -0.001132, 0.438860, -0.731302, -0.000725, -1.183061, -0.317993, 0.896551, -0.015299, 
	-0.021066, -0.010444, -0.364909, 1.511537, 0.894274, -0.004106, 4.629869, -0.014072, -0.007500, -2.872424, -3.912567, -0.004350, 1.522073, -0.751530, -0.318441, -0.276344, 
	-0.002993, -0.001463, -0.937364, 1.492879, 0.168484, -0.000916, -0.737705, -0.004319, -0.001375, -0.329084, 0.510228, -0.000957, -0.401621, 0.296135, -0.020177, -0.029752, 
	-0.014471, -0.005010, 0.553258, 0.183962, -0.028190, -0.001150, -0.858387, -0.006004, -0.002860, -1.256667, 2.614176, -0.001215, -1.997479, -1.629460, 2.526523, -0.077027, 
	-0.011082, -0.006868, -0.240009, 2.607585, -1.047403, -0.002241, 0.319055, -0.016301, -0.005293, -3.238860, 1.675064, -0.002555, -1.238107, 0.028531, 1.659053, -0.480570, 
	-0.007112, -0.005124, 0.030855, -1.639047, -0.544532, -0.001710, 2.395693, -0.004833, -0.003113, 1.869724, -0.490420, -0.001760, -1.651742, 0.161263, -0.074370, -0.033773, 
	-0.109035, -0.076011, -2.082820, 5.658316, -1.244376, -0.016240, -0.860392, -0.099079, -0.039763, 1.027868, -1.773339, -0.275935, 4.735715, 2.221034, -5.326788, -1.739155, 
	-0.002173, -0.002212, -0.127348, 1.134369, -1.172787, -0.000638, -0.617641, -0.003466, -0.001451, -1.524096, -1.130689, -0.000680, 1.637612, -0.721144, 2.545369, -0.013025, 
	-0.002738, -0.003581, 1.313462, -0.269610, 2.654208, -0.000781, 0.225511, -0.003977, -0.001475, -0.749926, -2.060666, -0.000832, -0.639447, -0.062634, 0.056080, -0.453594, 
	-0.013734, -0.014445, 3.617135, 1.915859, -1.312813, -0.004059, 3.806545, -0.017401, -0.008611, -2.452290, -4.846490, -0.004216, 2.893237, -2.189022, -1.186578, -0.183116, 
	-0.000261, -0.000278, 0.423480, 0.230753, -0.229635, -0.000140, -0.073978, -0.000308, -0.000201, -0.003816, -0.156261, -0.000142, 0.043403, -0.269522, 0.038186, -0.001281, 
	-0.015835, -0.016739, -0.722101, -0.067395, -0.463009, -0.009026, 0.155763, -0.087011, 0.628134, -0.119471, 0.167074, -0.009235, 2.375903, -0.551403, -1.220849, -0.044800, 
	-0.000303, -0.000400, -0.586884, 0.006961, -0.007947, -0.000173, -0.248336, -0.000684, -0.000313, -0.051682, -0.028650, -0.000170, -0.019650, 0.514611, 0.427004, -0.003385, 
	-0.007852, -0.003495, -1.405689, 0.194837, -1.653942, -0.001819, -0.714704, -0.003266, -0.002495, 1.247307, 0.582322, -0.001921, 1.000845, -0.368955, 1.213631, -0.074803, 
	-0.018753, -0.009646, -1.120258, 1.700463, -0.105459, -0.004601, 0.167140, -0.016089, -0.007775, -2.699457, 3.895134, -0.004634, -2.553262, 1.408948, -0.387134, -0.244615, 
	-0.001994, 0.112821, 0.040063, 1.362197, 1.290127, -0.000437, -0.936436, -0.110617, -0.001322, 0.660381, -2.581652, -0.000395, 2.447545, -1.465733, -0.757897, -0.056653, 
	-0.012808, -0.005794, 7.053280, -0.952293, -2.617625, -0.001643, 1.366973, -0.008089, -0.004581, -4.301309, 0.632982, -0.001741, -0.951726, -0.134772, -1.784573, 1.723717, 
	-0.024106, -0.007902, -2.510892, -1.555583, 0.034832, -0.003379, -1.528368, -0.019210, -0.006745, 2.051927, 0.128273, -0.003690, -0.470917, 3.801205, 0.458236, -0.343682, 
	-0.011879, -0.007478, -2.089589, 1.707537, 2.083996, -0.001129, -4.404787, -0.008928, -0.004141, 1.402997, 1.177538, -0.001313, 1.151619, -0.463973, -0.388723, -0.141748, 
	-0.077818, -0.029487, 3.182745, -1.469959, -3.251366, -0.004692, -1.080340, -0.041110, -0.013538, 3.728101, 3.439364, -0.005104, 0.531121, -6.381201, -0.178097, 1.651381, 
	-0.002709, 0.781459, 0.061798, 0.995781, 0.875386, -0.001628, -0.528686, -0.740679, -0.002411, 0.075239, -0.318296, -0.001682, -0.932236, -0.129196, -0.062446, -0.069692, 
	-0.026292, -0.021050, -1.683188, -3.760217, 1.564367, -0.010159, 5.103197, -0.040650, -0.016943, -1.709835, -4.159711, -0.010509, 0.807145, 4.466580, -0.373962, -0.128772, 
	-0.004019, -0.004094, -0.334731, 0.109511, -0.280251, -0.001001, -1.381081, -0.003470, -0.003429, 0.471713, -2.583550, -0.001031, 3.126349, 1.095711, -0.188497, -0.018128, 
	-0.032929, 0.261406, -0.761959, 1.588057, 0.188624, -0.004549, 3.498191, -0.127025, -0.009445, -1.502999, 4.932748, -0.004767, -3.624266, -4.103225, 0.016964, -0.314826, 
	-0.000619, 0.007518, -0.595997, 0.129072, 0.570060, -0.000401, -0.235754, -0.008088, -0.000609, 1.014440, 0.104389, -0.000414, -0.558109, -0.142385, -0.274720, -0.008383, 
	-0.082717, -0.064497, 10.053821, -3.652020, 4.427155, -0.017353, -1.178781, -0.089123, -0.037734, -2.886270, -3.312143, -0.018287, 1.605534, -2.939012, -1.530165, -0.278406, 
	-0.005135, -0.003931, 1.171037, 1.102845, 1.678388, -0.001400, -7.581172, -0.016179, 0.017132, -1.401148, 0.496092, -0.001486, 4.881994, -0.182644, -0.084277, -0.070117, 
	-0.004551, -0.004467, -1.341544, 0.681380, -1.179417, -0.001023, 0.992812, -0.004818, -0.002766, -0.222041, 3.572972, -0.001126, -2.447753, -0.647629, 0.654454, -0.044481, 
	-0.066073, -0.013072, -2.299899, -4.357117, 0.329357, -0.004180, 1.677598, -0.188492, -0.013656, 0.541675, 2.521518, -0.004537, -3.701270, 5.376788, 0.398422, -0.197061, 
	-0.010012, -0.008096, -1.612222, 1.614794, -2.204042, -0.001987, 2.754807, -0.013927, -0.005413, -1.752926, -2.167139, 0.046684, 0.946737, 1.003606, 1.646741, -0.237605, 
	-0.062348, -0.011367, -3.582781, 0.295029, 4.651024, -0.002948, -0.414989, -0.029187, -0.007612, 3.047706, -1.819858, -0.003199, -2.913892, -0.593386, 1.672425, -0.224617, 
	-0.012096, -0.005007, -1.865174, -0.379867, 0.121364, -0.001040, -2.033651, -0.005989, -0.002834, -1.107805, 2.343296, -0.001180, 2.520056, 0.916501, -0.261396, -0.225177, 
	-0.025193, -0.005611, -0.912091, -0.779053, -1.219002, -0.001808, -1.036362, -0.007756, -0.003461, -0.246730, 4.681808, -0.001772, -0.477099, 0.343438, -0.268519, -0.040789, 
	-0.235633, -0.050068, -2.778749, 0.791436, -3.405622, -0.012318, 3.826060, -0.082088, -0.034579, -1.519710, 2.023679, -0.013232, -2.594624, -0.054446, 4.768713, -0.628817, 
	-0.007788, -0.003150, -0.520334, -0.044580, -0.864343, -0.000808, -1.500374, -0.005214, -0.001970, 2.341848, 2.599663, -0.000879, -1.461519, -0.165681, -0.275170, -0.089701, 
	-0.026813, -0.025640, 1.597147, -2.258502, 3.812510, -0.005228, -1.451898, -0.016222, -0.012256, -0.751077, 2.208380, -0.005519, -2.308454, -1.135808, 0.725807, -0.346426, 
	-0.038454, -0.023306, -2.848171, 1.664746, -1.210110, -0.007225, -3.538855, -0.021829, -0.013134, -1.823842, -1.287632, -0.007506, 3.411478, 4.811783, -0.982233, 1.914290, 
	-0.009792, -0.003681, -1.321002, 5.418104, 1.678469, -0.002192, -1.338515, -0.008587, -0.003148, -1.327020, -2.240208, -0.002336, -1.316400, -0.893665, 1.097368, 0.272607, 
	-0.004476, -0.001977, 1.068536, 0.437083, -1.827137, -0.000539, 0.452668, -0.004049, -0.001544, 0.153663, 1.143895, -0.000587, -0.950071, -0.184104, -0.251726, -0.029635, 
	-0.006168, -0.002185, -0.991811, 0.090443, 3.488256, -0.000685, 0.853503, -0.016492, -0.001905, -0.412489, -1.472778, -0.000719, 0.417936, -1.089971, -0.836368, -0.018566, 
	-0.024378, -0.007387, 4.348767, 4.465304, -0.964469, -0.002172, -0.293050, -0.011512, 0.003949, -1.557994, -0.628594, -0.002284, -1.058670, -1.824800, -2.340830, -0.101880, 
	-0.015819, -0.005268, -0.440962, -0.554487, -0.710192, -0.001740, -0.345246, -0.006165, -0.003214, 0.908881, -0.932139, -0.001858, 1.187232, -1.027706, 1.117755, 0.830927, 
	-0.026707, -0.006143, -1.467267, 1.083714, 1.120238, -0.001411, -2.691911, -0.010147, -0.005022, 1.578635, 3.578006, -0.001847, -1.816270, -0.222355, -1.087589, -0.023924, 
	-0.138728, -0.114607, 4.485378, -1.510592, -1.259257, -0.011731, 2.517396, -0.045748, -0.038547, -3.594760, -3.768801, -0.012796, 1.992109, 1.070709, -2.093556, 2.523531, 
	-0.008445, -0.008077, -0.961003, -0.101790, -0.332697, -0.001080, 0.197415, -0.023418, -0.004659, 2.191942, 0.558575, -0.001323, -1.359418, 0.196487, -0.317161, -0.025348, 
	-0.028625, -0.019847, -2.979329, -2.610634, -1.601155, -0.005697, 1.005092, -0.039182, -0.012603, 1.768498, 3.407762, -0.006018, -0.078044, -1.892025, 3.256790, -0.164982, 
	-0.018833, -0.008988, 1.367368, 0.128326, 0.696917, -0.001403, -0.557898, -0.017620, -0.005010, -1.528051, 0.191179, -0.001598, 0.145230, -1.476231, -0.150337, 1.236949, 
	-0.019193, -0.008228, -4.398365, 4.123639, -2.520568, -0.001880, -0.446868, -0.008033, -0.004504, 0.538175, 2.748694, -0.002009, 0.651857, -0.987360, 0.647538, -0.312895, 
	-0.011129, -0.007732, 1.273537, -3.030568, -2.598716, -0.003075, -3.838122, -0.007758, -0.005178, -1.778034, 9.257968, -0.003206, -4.144291, -0.776260, 5.763614, -0.091049, 
	-0.002034, -0.002779, -0.016974, -0.252003, -0.106900, -0.000754, -1.307541, -0.002931, -0.001561, 1.607862, -1.379732, -0.000756, 1.099507, 0.557581, -0.177130, -0.013854, 
	-0.042621, -0.011344, -2.462263, 0.267171, -2.081529, -0.002953, 2.017257, -0.013768, -0.007658, 1.338086, -0.437081, -0.003097, 1.937320, -2.471432, 2.032136, -0.058225, 
	-0.020530, -0.013660, -0.818298, -2.358230, -0.269424, -0.003585, -2.105701, -0.043766, -0.010112, -0.346816, 0.360036, -0.003728, 2.746073, 1.800770, 1.456639, -0.369666, 
	-0.007883, -0.005265, 1.205959, -1.202835, 4.303900, -0.001618, 0.522567, -0.007956, -0.003510, -1.057825, -3.806010, -0.001714, -0.436073, -1.072429, 1.588562, -0.017870, 
	-0.030934, -0.015889, -3.043514, -0.579864, 0.253276, -0.007275, 0.602018, -0.022831, -0.012562, -2.208600, 9.828388, -0.007618, -1.877796, -0.847513, -1.880930, -0.148354, 
	-0.086066, -0.056456, -3.413635, 4.325443, -2.024148, -0.020431, 4.421992, -0.084005, -0.034758, 2.676430, -1.805751, -0.021450, 1.308813, -1.707439, -1.986043, -1.492495, 
	-0.012904, -0.010337, -2.504102, 0.561387, -2.092832, -0.001754, -2.558585, -0.020453, -0.004337, 2.181602, -1.334789, -0.001882, 6.403494, -0.356688, -0.105776, -0.142043, 
	-0.000950, -0.000926, 0.152233, -0.426023, 0.346019, -0.000298, 2.091762, -0.001440, -0.000722, -0.124035, 0.136789, -0.000320, -2.160301, 0.099333, -0.103784, -0.007336, 
	-0.108101, -0.015458, 1.029031, -2.083252, 1.123981, -0.005294, 0.608155, -0.017960, -0.010768, -0.788446, -0.193138, -0.005718, -4.066558, 4.856674, -0.110804, -0.212343, 
	-0.010030, -0.011477, -0.487712, -1.192713, 3.668749, -0.000989, 1.772992, -0.018400, -0.002410, 0.125247, 0.141587, -0.001103, -3.905480, -0.941510, 0.934504, -0.071253, 
	-0.028166, 0.235915, -1.696991, -1.023878, -0.391398, -0.002035, -0.926532, -0.083083, -0.004319, 0.570797, 2.268469, -0.001739, -2.831043, 0.415717, 2.561234, 0.937054, 
	-0.009500, -0.004745, -1.121934, -0.988874, -5.413971, -0.001395, 4.873416, -0.011033, -0.003117, 1.171566, 0.916621, -0.001477, -1.012917, 1.129799, 0.537842, -0.060280, 
	-0.031224, -0.016004, -2.152479, 3.031286, -3.670819, -0.007708, -1.361258, -0.018819, -0.012057, -0.558610, -0.068157, -0.007967, -1.096186, -0.764083, 6.625002, 0.109084, 
	-0.010397, -0.003916, 1.124200, -0.231230, 0.940520, -0.001385, 3.657432, -0.006436, -0.002778, -1.824827, -1.744690, -0.001487, 0.007108, -1.071128, -0.781041, -0.049945, 
	-0.064809, -0.037689, 4.262621, -4.713932, 3.409896, -0.014513, 0.713713, -0.061149, -0.028085, -2.721819, 0.434757, -0.015749, -1.794003, -2.301559, 1.978540, 0.953781, 
	-0.012877, -0.008144, 2.257331, 0.878609, -1.373435, -0.002471, -1.119348, -0.008279, 0.003605, -1.307195, -0.184507, -0.002583, -2.336897, 4.515592, -1.161203, -0.138200, 
	1.839969, -0.078057, 0.833639, 2.314348, -5.418620, -0.011983, -0.613205, -0.051156, -0.032210, -2.075222, 1.614545, -0.013006, 5.054921, -2.879186, 0.150567, -0.635346, 
	-0.012570, -0.011735, -2.374193, 0.934839, 3.870389, -0.004087, -0.049974, -0.010200, -0.006979, 0.717236, -2.496097, -0.004262, -0.364908, 0.300469, -0.402469, -0.085458, 
	-0.010047, -0.005156, -0.810826, 1.340565, -2.128859, -0.001820, 0.018394, -0.021270, -0.003552, -1.658366, -2.863616, -0.001902, 3.163564, 1.968773, 1.121772, -0.107654, 
	-0.027709, -0.006771, -0.176213, -0.503550, -1.254503, -0.001072, 5.236645, -0.005330, -0.004743, -2.068744, 0.941640, -0.001174, -1.917388, 0.049155, -0.213483, -0.046761, 
	-0.017968, -0.006433, -0.420631, -1.083663, 0.247407, -0.001874, -2.892210, -0.011338, -0.004568, 1.720589, 5.835339, -0.002021, -2.064797, -1.416944, 0.198166, -0.079053, 
	-0.009164, -0.003173, 0.316821, -2.770471, 0.805319, -0.000968, 5.027491, -0.010945, -0.002735, -0.420037, -2.732536, -0.001212, -1.899152, 1.319970, 0.403541, -0.022748, 
	-0.006377, -0.004828, 1.534859, 1.872483, -1.400947, -0.001486, -3.816258, -0.005282, -0.003661, -3.191682, 3.405811, -0.001691, 0.075208, 1.088160, 0.564324, -0.108633, 
	-0.132533, -0.047998, -0.298829, -0.106949, 0.250262, -0.007168, 0.901120, -0.077565, -0.022389, -2.328890, -0.500843, -0.007671, 2.545503, 0.760618, -0.062569, -0.864100, 
	-0.010091, -0.007376, -0.091276, -0.046410, 0.363030, -0.001400, -1.285162, -0.010331, -0.004616, -1.054404, 1.340589, -0.001650, -1.208699, 1.141442, 0.994204, -0.117849, 
	-0.032205, -0.010561, -0.050431, -0.516321, -0.986602, -0.003717, -0.599535, -0.018751, -0.007012, -2.138903, 5.167120, -0.003386, -0.982228, -1.030550, 1.304695, -0.091611, 
	-0.090637, -0.045524, -0.368551, 1.984304, -2.594957, -0.016769, 8.177131, -0.071408, -0.033266, -2.025176, -3.994626, -0.017478, 0.858468, -0.679051, -0.169380, -0.913080, 
	-0.011090, -0.006551, -0.094559, 0.446349, 2.266675, -0.000588, -4.773079, -0.012445, -0.002291, 0.087513, -1.112416, -0.000697, 2.096438, 1.313050, -0.147492, -0.048814, 
	-0.018647, -0.009709, -2.852157, 0.204909, 0.572719, -0.004003, -0.621904, -0.019385, -0.007322, 5.471951, 1.092250, -0.004230, -3.128097, -0.468730, -0.136429, -0.071215, 
	-0.047908, 0.550042, 3.158495, 1.322723, -0.632634, -0.001992, 2.234641, -0.082519, -0.004408, -0.315575, -0.424642, -0.002199, -5.018199, -0.481069, -0.161932, -0.092823, 
	-0.008700, -0.005477, -2.283088, 1.820172, 2.090613, -0.001688, 1.388183, -0.008355, -0.003819, 0.592067, 0.173396, -0.001810, -4.261023, 0.172581, 0.383892, -0.046944, 
	-0.012377, -0.008052, -1.389537, -1.119771, 0.180229, -0.003223, 0.381373, -0.007308, -0.006149, 0.971771, 2.144685, -0.003281, -3.414509, 1.140134, 0.606377, 0.539638, 
	-0.003807, -0.002863, -0.403212, -0.950611, -0.583085, -0.000731, -1.664281, -0.005054, -0.001602, -0.542149, 6.262392, -0.000630, -3.257110, 1.461081, -0.253155, -0.055180, 
	-0.019981, -0.005121, -0.758740, 2.848567, -3.445559, -0.001798, -0.238081, -0.008054, -0.003797, 1.002466, -0.994807, -0.001854, 1.787245, -0.592663, 0.572505, -0.140328, 
	1.972977, -0.057113, -1.611030, -0.371699, -0.854733, -0.007112, 1.116077, -0.043190, -0.020152, -0.700607, 1.630139, -0.008067, -0.198421, 0.304439, -0.298388, -0.853121, 
	-0.018520, -0.004541, -0.636719, -0.417762, -0.414931, -0.001960, 0.074467, -0.006309, -0.003379, -0.126538, 1.287158, -0.009301, 0.263232, 0.153240, -0.118531, -0.019607, 
	-0.014671, -0.008901, -1.214480, 1.088945, -0.268013, -0.003078, -2.376384, -0.008927, -0.005618, 0.304929, 7.029509, -0.007586, -2.911102, -0.060142, -1.408103, -0.136380, 
	-0.012358, 0.248240, -1.012140, 2.253514, -3.435239, -0.002276, 2.434206, -0.091044, -0.005594, 1.292233, -1.607395, -0.002160, -2.071960, -0.285511, 2.613771, -0.316286, 
	-0.002072, -0.000711, -0.264743, 0.284583, -0.836611, -0.000631, 2.539793, -0.002423, -0.001142, 1.185824, -4.194180, -0.000578, 1.107473, -0.096742, 0.328392, -0.046234, 
	-0.008419, -0.006868, 6.077524, -4.888620, 2.316376, -0.002132, -1.403749, -0.012540, -0.005139, 4.674549, 1.661696, -0.002246, -6.045914, -1.523853, -0.797251, -0.033415, 
	-0.030375, -0.015395, -2.036087, -0.873353, -1.115576, -0.002325, -0.331314, -0.011799, -0.007937, -2.525030, 3.541853, -0.006962, -2.687182, 3.246428, 2.906239, -0.051187, 
	-0.039365, -0.021859, 3.447526, 2.495339, -3.095623, -0.007179, -6.529819, -0.018171, -0.013775, -3.162802, 0.132810, -0.007347, 2.218675, 5.686098, -0.833958, -0.250550, 
	-0.115515, -0.021646, 1.835488, 0.298615, 1.565559, -0.005171, -2.222603, -0.030385, -0.012786, -1.798277, 1.584930, -0.014400, 0.902098, -1.153165, -0.644642, -0.168100, 
	-0.899048, -0.580493, 1.398871, 3.185882, -0.769975, -0.234832, -5.055924, -0.732879, -0.403097, 3.473049, -2.846306, -0.576275, -1.933556, 2.448172, 0.831547, 2.694863, 
	-0.013432, -0.008067, 4.214651, -0.495677, -2.413576, -0.002714, 2.310316, -0.018422, -0.005939, -0.131216, -0.914517, -0.002862, 2.317796, -2.718259, -1.675078, -0.443003, 
	-0.006787, -0.003575, 0.721311, -2.027467, -0.704773, -0.001394, 1.346170, -0.005188, -0.002568, -0.510267, -2.081429, -0.001441, 3.029658, 0.529194, -0.171824, -0.109620, 
	-0.012944, -0.002967, -0.021034, 0.648067, 2.058551, -0.000344, -1.225805, -0.003040, -0.001565, -5.645520, -0.434164, -0.000415, 0.472641, -0.042244, 4.249954, -0.039171, 
	-0.037748, -0.008673, 0.498992, 2.735278, -1.732365, -0.002207, -1.576020, -0.011405, -0.004783, -2.971927, -6.612724, -0.002306, 5.216261, -1.038749, 5.960877, -0.412500, 
	-0.023567, -0.017681, -0.129952, 7.184301, -6.495550, -0.005930, 7.297133, -0.031690, -0.014108, 1.442882, 3.716663, -0.006218, -9.277643, -1.454536, -2.064775, -0.119327, 
	-0.048380, -0.022494, -2.813441, -3.451054, -2.644362, -0.010809, -0.422141, -0.038242, -0.018487, 3.623546, -1.608315, -0.010563, -4.236248, 0.141529, 10.579435, 0.980025, 
	-0.010715, -0.006859, -0.371292, -2.694723, -2.703201, -0.001445, 4.009055, -0.008316, -0.004820, 1.226721, -0.295490, -0.001706, -3.325750, 2.094021, 2.130465, -0.035943, 
	-0.006968, -0.003582, 0.765506, 0.304184, -0.711952, -0.001266, -1.743958, -0.003539, -0.002108, -1.753835, 1.717113, -0.001236, 1.915047, -0.205871, -0.228287, -0.039247, 
	-0.021448, -0.002269, -0.004473, -2.753690, -0.777261, -0.000452, -1.511029, -0.002329, -0.001176, 0.137540, -1.358880, -0.005000, 6.731172, -0.161312, -0.249957, -0.019436, 
	-0.629464, -0.484089, 2.730340, 0.782612, -0.106657, -0.154537, -2.520116, -0.578017, -0.292431, 0.905080, -3.338365, -0.091260, -0.947857, 0.671040, 1.761929, 2.291792, 
	-0.031199, -0.012399, -1.389626, -2.440954, -0.178103, -0.003703, -0.353095, -0.019413, -0.008463, 1.721564, 2.200582, -0.003838, -2.397895, 1.281313, 1.778300, -0.143071, 
	-0.001672, -0.002464, 0.863008, -0.924620, -0.227438, -0.000422, 1.090497, -0.002330, -0.001183, -0.190394, 1.552348, -0.000265, -1.225309, -0.960779, 0.040389, -0.009367, 
	-0.207425, -0.080328, -0.916399, 1.868981, -1.547603, -0.023735, 0.233545, -0.092925, -0.049975, 0.362856, 1.809997, -0.025210, -1.536758, 2.201313, -0.580558, -1.415779, 
	-0.081123, 0.218384, 0.256191, 5.730724, 1.480868, -0.007392, 3.578048, -0.109770, -0.018409, -2.512464, -4.242223, -0.008033, -2.406861, -0.504528, -0.959115, -0.414296, 
	-0.002926, -0.002727, 0.143499, -0.030092, -0.007180, -0.000509, -1.996663, -0.002947, -0.001605, -0.570075, -0.793909, -0.000567, 3.107120, 0.644210, -0.470511, -0.015118, 
	-0.012392, -0.005747, 0.709811, -0.932957, 0.854880, -0.001898, 1.761667, -0.007370, -0.003647, -0.423547, -2.305735, -0.001981, 0.132835, -0.340957, 0.613461, -0.036423, 
	1.394261, -0.123784, -3.334824, -7.648258, -5.751721, -0.212327, -0.380730, -0.635954, -0.290830, -2.020878, -2.510741, -0.228787, 3.020296, -0.906390, 12.898939, 6.731726, 
	-0.061721, -0.021472, -1.577718, 2.039435, -1.414663, -0.008752, -0.798388, -0.056624, -0.021739, 4.113451, -3.973829, -0.013823, 1.682039, 0.449261, -0.040610, -0.294846, 
	-0.054880, -0.029813, 3.990053, 5.740172, -2.792697, -0.007373, -0.606411, -0.048489, -0.017262, -6.966121, 1.447827, -0.007897, -4.772323, 7.796666, -3.155358, -0.516093, 
	-0.113980, -0.041502, -1.730638, -1.701465, 3.699551, -0.009586, 0.175498, -0.070849, -0.024093, -0.290010, 0.630103, -0.018348, 2.329234, -1.041226, -1.243228, -0.549463, 
	-0.000967, -0.000725, 0.872905, -0.586328, -0.229697, -0.000352, -0.887719, -0.002818, -0.000685, -0.359308, 0.582545, -0.000370, -0.109166, 0.873614, -0.148602, -0.002327, 
	-0.088626, -0.041628, -2.098895, 0.378260, 2.466090, -0.010974, 0.638580, -0.049637, -0.026156, -1.221248, 4.852166, -0.011656, -0.342353, -1.706048, -1.757051, -0.980824, 
	-0.013354, 0.002203, -1.426892, 0.407694, -1.681659, -0.001524, 5.053586, -0.010133, -0.003885, 1.394185, 0.527205, -0.001696, -1.842902, -0.501218, -1.832672, -0.068937, 
	-0.017119, -0.012057, -0.701468, -2.575571, 0.235912, -0.004951, 1.102184, -0.013983, -0.008138, 5.642767, -5.568017, -0.005086, -2.232141, -2.691606, 7.143010, -0.293736, 
	-0.035244, -0.012068, -0.729044, -0.115926, 2.424385, -0.003214, 0.576782, -0.043094, -0.008650, -1.173765, -2.386718, -0.003465, 1.936312, -0.540688, 0.208810, -0.094415, 
	-0.013763, -0.006769, -0.076989, -0.908579, 1.259641, -0.001891, 2.447118, -0.005885, -0.004190, -2.705488, -2.914104, -0.001919, 1.711695, 1.327351, -0.084618, -0.021609, 
	-0.005927, -0.004590, -1.322674, 1.145389, -1.736021, -0.001553, 2.366496, -0.006533, -0.002875, -1.279801, 1.151981, -0.001584, -1.259251, -0.055095, 0.689271, 0.322767, 
	-0.016648, -0.002318, -0.218336, -1.080976, 0.848193, -0.000509, -0.691935, -0.003575, -0.001410, 0.677237, 0.806854, -0.000574, -0.611510, 0.455873, -0.119909, -0.040456, 
	-0.028302, -0.008825, -0.181981, -1.629644, -4.693592, -0.003315, 3.829657, -0.037060, -0.006397, -2.000402, 3.780798, -0.003484, -0.033245, -0.551353, 1.624990, -0.057848, 
	-0.022772, -0.010276, 2.537541, -1.742285, -0.874011, -0.002447, -3.019343, -0.013577, -0.005215, 4.953022, -0.649123, -0.002632, 1.090360, -2.209769, 0.193843, -0.223317, 
	-0.033162, -0.027786, -1.143962, 2.425133, -1.106243, -0.002946, -0.290670, -0.009742, -0.010564, -2.610399, 1.884209, -0.003135, 1.868150, -0.537721, -2.563600, 2.162439, 
	-0.006980, -0.004323, 2.906366, -0.277254, -0.105365, -0.001415, 0.806198, -0.003276, -0.002582, -1.507287, -6.292830, -0.000520, 6.839180, -1.354406, -0.898233, -0.097273, 
	-0.037522, -0.012930, 0.215228, -3.908260, -0.804578, -0.002446, 0.366711, -0.011966, -0.006392, 0.682016, 5.378998, -0.002674, -2.385027, -0.532701, 1.375226, -0.313683, 
	-0.062659, -0.017080, -3.894363, -0.705155, 1.090220, -0.003890, 4.078380, -0.023179, -0.011031, -0.662222, -0.488540, -0.004216, -3.763986, 3.209319, 1.460653, -0.202250, 
	-0.014132, -0.007117, 0.391337, -0.834636, -0.112666, -0.001392, -1.456026, -0.004528, -0.005167, 1.815020, 0.643640, -0.001482, 0.629260, -0.356837, -0.662637, -0.022638, 
	-0.033727, -0.007018, -2.386775, -2.033260, -2.410866, -0.003608, 3.556127, -0.029070, 0.002143, 4.892189, -1.414918, -0.003733, -1.125460, 0.884125, 0.303638, -0.189787, 
	-0.001494, -0.001267, 0.071311, 0.745914, -0.762384, -0.000412, -1.940376, -0.002770, -0.000892, -0.525200, 0.545026, -0.000426, 0.608421, 1.357291, -0.084529, -0.008213, 
	-0.006732, -0.003335, -1.581802, 0.278605, 1.425001, -0.001151, 0.418998, -0.005097, -0.002085, 2.269806, 1.729387, -0.001272, -2.418584, -1.397068, -0.576627, -0.128045, 
	-0.042581, -0.037334, -1.106685, 1.678902, -4.374485, -0.012288, -4.745619, -0.034896, -0.023132, 0.629484, 5.496517, -0.012892, -0.799029, 2.232287, 1.306755, -0.155005, 
	-0.037108, -0.010634, 4.729209, -1.469231, 0.589935, -0.003558, -0.260442, -0.009460, -0.006336, -1.670678, 2.130920, -0.003589, -1.313626, -1.134531, -1.380269, -0.150602, 
	-0.025399, -0.012489, -2.943832, -2.244004, 2.173955, -0.004493, 1.275327, -0.017241, -0.008576, 4.339867, 0.417028, -0.004692, -0.039411, -1.327957, -1.375913, -0.202171, 
	-0.289320, -0.028821, 0.434746, 2.674570, -3.903286, -0.006637, -2.714118, -0.022502, -0.012867, 0.738960, 6.845625, -0.006990, -2.865973, -0.466938, -0.239937, -0.136511, 
	-0.171269, -0.088324, 3.646294, -3.018455, 0.847842, -0.038835, 0.145165, -0.130536, -0.068472, -2.398455, 4.137568, -0.041037, 5.311446, -4.310121, -2.809950, -1.012860, 
	-0.012076, -0.010077, 1.984806, 2.976122, -1.221089, -0.002090, -3.741927, -0.014589, -0.005661, -2.330185, 5.992412, -0.002131, -3.123104, -0.559070, 0.125836, -0.057178, 
	-0.012554, -0.004744, 1.986553, 0.843731, 2.570597, -0.000837, -2.129865, -0.010116, -0.002473, -3.117965, 4.420242, -0.000956, -3.986363, -0.137972, -0.339909, -0.077370, 
	-0.013054, -0.008358, 0.281981, 0.949144, -0.523413, -0.002357, 3.290695, -0.006742, -0.004439, -0.789727, -4.969402, -0.002467, 1.554172, -0.732827, 1.080724, -0.103931, 
	-0.021637, -0.019314, 0.322138, -0.059144, -1.115791, -0.005833, -3.440139, -0.013503, -0.010046, 2.902770, 0.216997, -0.005969, 5.017005, -1.601165, -1.790256, -0.376114, 
	-0.039447, -0.004324, -1.179652, -1.165355, 0.620225, -0.001521, 0.869625, -0.038612, -0.004431, 0.610742, 1.305549, -0.001694, -2.717243, 1.527777, 0.336033, -0.117671, 
	-0.008543, -0.007643, -0.179556, 3.879435, 1.041857, -0.004512, -1.130299, -0.010815, -0.006162, -0.006485, -0.110584, -0.008947, -1.712036, -3.932287, 2.220802, -0.024225, 
	-0.008949, 0.233289, -1.382606, 1.317450, 0.733126, -0.001201, -2.581054, -0.083213, -0.003570, -0.384619, 2.187734, -0.000942, 0.581542, -1.079281, -0.581631, 1.053925, 
	-0.015545, -0.001887, 0.183079, 0.503326, 0.512764, -0.000425, -0.162778, -0.001830, -0.001076, -0.062682, 0.288959, -0.000468, -1.220260, -0.124715, 0.111140, -0.007602, 
	-0.019801, -0.003827, 0.085619, -0.555938, 1.212601, -0.002107, 3.587777, -0.004915, -0.003107, -1.297732, -2.544839, -0.002168, 0.538866, -0.876932, -0.082234, -0.031263, 
	-0.070251, -0.038728, -1.253807, -0.122375, 0.652899, -0.008286, -1.945226, -0.043535, -0.024024, 3.972725, 0.290923, -0.009172, 2.607218, -3.265578, -0.513580, -0.229203, 
	-0.010028, -0.003309, -0.503152, 0.913469, -0.234441, -0.000901, -2.275621, -0.004519, -0.002037, -0.630315, 0.228034, -0.000931, 2.359705, 1.136839, -0.897735, -0.075058, 
	-0.004388, -0.003366, 1.587585, 1.272344, -0.149631, -0.000632, 0.097219, -0.004483, -0.001800, -1.416220, 1.880846, -0.000694, -3.153453, -0.693696, 0.616328, -0.025959, 
	-0.003038, -0.001620, -0.335835, -1.148203, -2.668864, -0.000741, 2.784292, -0.002525, -0.001536, 1.287576, -1.743131, -0.000779, 1.653420, 0.045324, 0.153961, -0.018302, 
	-0.003408, -0.002243, -0.205160, -0.864789, 1.848253, -0.001153, -0.364594, -0.002970, -0.001748, -0.062741, -2.363498, -0.001178, 2.409208, -0.159762, -0.191721, -0.032496, 
	-0.086255, -0.019779, 1.622753, 3.017154, 1.078034, -0.005493, -1.379991, -0.033088, -0.012999, -1.616224, -0.159065, -0.005992, -3.284213, -1.091087, 2.365994, -0.389749, 
	-0.005664, -0.002208, 0.194022, -0.100473, -1.285366, -0.000762, 0.362335, -0.004741, -0.001519, 0.480906, 4.113673, -0.000803, -4.405644, 1.466926, -0.774907, -0.035776, 
	-0.002482, -0.004340, 2.081365, -1.311302, -0.533207, -0.000664, 0.002835, -0.001996, -0.001621, -0.575504, -1.860922, -0.000705, 2.797922, -0.336363, -0.348970, 0.095955, 
	-0.111441, 1.147511, 1.080753, -4.052144, 1.120738, -0.006327, -4.604775, -1.197788, -0.015183, -1.651763, 5.079093, -0.011074, 1.335361, 1.722524, 0.564304, -0.399788, 
	-0.053997, -0.011521, -0.840683, -1.329464, -1.975348, -0.003292, -0.567100, -0.014604, -0.007779, 2.175899, 4.382199, -0.003513, -1.134273, -0.420777, 0.004553, -0.200302, 
	-0.015362, -0.014138, -1.943583, 4.200124, -1.426255, -0.003107, 0.687279, -0.016464, -0.008061, -3.118516, 2.863674, -0.003349, -1.067376, 2.209157, -2.108370, -0.235653, 
	-0.011080, -0.007568, 1.828357, 1.524546, 1.191390, -0.002125, -2.296922, -0.008656, -0.004468, -0.506573, 1.196532, -0.002268, -1.547879, -0.238007, -1.041594, -0.073687, 
	-0.011902, -0.007695, -1.980169, 2.371008, 0.279467, -0.002303, -0.227193, -0.007478, -0.003763, 1.750213, 1.248201, -0.002390, -3.704966, -0.719921, 1.342248, -0.323357, 
	-0.058719, -0.035926, 4.855336, -1.745820, 3.575960, -0.007721, -1.954105, -0.102411, -0.023591, -4.798820, -6.208302, -0.009016, 4.518614, -4.600366, 6.729752, -0.134865, 
	-0.070017, -0.027662, -0.498941, -1.001800, 2.622085, -0.007106, 2.589813, -0.026393, -0.014797, -1.828732, 2.264368, -0.011807, -1.009116, -0.411395, -2.058190, -0.510309, 
	-0.005705, -0.004171, 0.039828, 1.078458, -0.514129, -0.001336, -1.975082, -0.002700, -0.002009, -1.550135, 6.096508, -0.001378, -2.212941, -0.116179, -0.803038, -0.025991, 
	-0.000675, -0.000629, -0.173770, -0.115186, -0.081756, -0.000211, 0.524269, -0.000582, -0.000407, -0.170554, -0.418287, -0.000159, -0.050496, 0.019277, 0.476265, -0.007098, 
	-0.006319, -0.004467, -0.106053, 0.369160, 0.253848, -0.001993, 0.512924, -0.003950, -0.002514, 2.825063, -1.663350, -0.002464, -1.055430, -0.819329, -0.537030, 0.241905, 
	-0.090618, 0.730696, -2.790579, 6.473949, -4.940997, -0.008118, 4.865565, -0.073065, -0.018115, -0.350839, -3.763662, -0.009025, 1.083180, 1.298461, -1.965068, -0.441764, 
	-0.009226, -0.008130, -0.969177, -0.357516, -0.430684, -0.001709, -0.882645, -0.014825, -0.005684, -1.414537, 1.743571, -0.001972, 0.250458, 2.984216, -0.846749, -0.035392, 
	-0.151950, -0.026106, 0.285854, 4.095859, 5.988926, -0.007493, -2.268384, -0.123295, -0.019403, -2.562125, -2.529223, -0.008352, 0.481297, -2.022440, -0.884890, -0.248274, 
	-0.032866, 0.173194, -1.795717, 2.029208, 1.920046, -0.001980, 0.471760, -0.076134, -0.006990, 1.031041, 1.079080, -0.006697, -3.338110, -1.002872, -0.283359, -0.159604, 
	-0.008126, -0.004778, -1.167605, 0.426499, -0.953678, -0.001472, -0.965936, -0.012166, -0.003671, -0.323565, 0.594086, -0.001644, -1.006548, 2.849542, 0.626163, -0.047102, 
	-0.088695, -0.039313, 1.977499, 0.472510, -0.108850, -0.012707, -0.186103, -0.052764, -0.025679, 1.151215, 1.374926, -0.017588, -0.872098, -0.697705, -2.650119, -0.224531, 
	-0.040053, -0.005462, 1.836890, -0.829741, -3.627733, -0.001486, 2.060668, -0.009221, -0.003287, 5.156530, -1.521038, -0.001574, -2.386767, -1.344947, 0.765998, -0.048779, 
	-0.014328, -0.005398, 0.958894, -0.372695, -0.114864, -0.001250, 1.645534, -0.003540, -0.002709, 2.356927, -2.659739, -0.001490, -1.135219, -0.318882, -0.188458, -0.142783, 
	-0.061219, -0.023021, -5.985416, -0.309077, 0.228137, -0.009185, -0.749556, -0.035910, -0.017135, -0.461900, -23.921816, -0.009814, 32.023621, 3.164247, -3.178018, -0.653934, 
	-0.021716, -0.022892, 1.836182, -2.372604, -1.026263, -0.002805, 2.902871, -0.013008, -0.008206, 3.354496, 0.065983, -0.003122, -0.903548, -3.028932, 0.090504, -0.846940, 
	-0.001373, -0.000694, -0.029313, 0.899731, 0.010970, -0.000206, 0.298353, -0.000927, -0.000551, -0.431598, -0.189790, -0.000215, -0.215036, -0.071945, -0.248263, -0.019144, 
	-0.050416, -0.011577, 0.442377, -0.175578, -0.277251, -0.014692, 0.140574, -0.010586, -0.009206, 0.886432, -1.637202, -0.014789, 1.790082, -2.453739, 0.100225, 1.295344, 
	-0.016410, -0.008381, 0.050597, -1.770656, -1.080371, -0.005103, 2.779072, -0.009688, -0.006936, -0.549027, -1.005838, -0.005236, 1.955297, -0.967047, 1.165590, -0.525864, 
	-0.045445, -0.007800, 1.838311, 0.541586, 0.076550, -0.001588, -1.828932, -0.013251, -0.004372, -1.987227, 1.280709, -0.001694, -0.018098, -0.757630, 1.058999, -0.130118, 
	-0.000788, -0.001139, 2.335881, 0.943388, -0.405751, -0.000355, -0.784994, -0.001071, -0.000584, -1.529889, -1.226708, -0.000385, 1.128148, -0.483887, 0.062537, -0.034401, 
	-0.033085, 0.006243, -2.825133, 0.481269, 3.911174, -0.003201, -2.336292, -0.084425, -0.008896, -3.461035, 1.064302, -0.003458, 4.473024, -1.664446, 0.587812, -0.103853, 
	-0.057938, -0.009119, -1.820538, -1.007778, 2.390519, -0.002215, 0.777314, -0.005692, -0.004631, -0.088124, 1.568113, -0.002348, -0.556873, -0.192377, -0.948469, -0.039843, 
	-0.003184, -0.002705, -0.503709, 0.463695, 0.316646, -0.000647, -0.494745, -0.001866, -0.001514, 0.044649, 2.649452, -0.000772, -0.682569, -1.114394, -0.648765, -0.019571, 
	-0.009865, -0.007851, 0.686957, -1.238760, -0.667485, -0.001939, 0.166916, -0.010457, -0.004030, -1.665462, -0.721557, -0.002017, 0.294746, 1.537856, 1.667053, -0.024105, 
	-0.024714, -0.011453, -0.636769, -1.330971, -4.048878, -0.002531, -1.531132, -0.018038, -0.006764, -1.084326, -0.949612, -0.002768, 5.232914, 3.074883, 1.465031, -0.124873, 
	-0.002653, -0.001305, -0.130247, 1.406585, 1.094086, -0.000689, 0.228281, -0.001212, -0.000947, -0.359427, -0.176947, -0.000698, -1.874117, -0.216622, 0.061277, -0.025365, 
	-0.018241, -0.008620, -0.925004, -0.190868, -0.634884, -0.001903, 1.326738, -0.005253, -0.003602, 1.257254, -0.393670, -0.001983, -1.006980, -0.715870, 1.345890, -0.023005, 
	-0.013204, -0.013312, 2.337012, 2.222933, -1.338770, -0.002547, 1.356583, -0.068274, -0.007454, 0.799119, -6.233521, -0.132212, 5.725228, -3.612160, -1.246966, 0.227547, 
	-0.002103, -0.004161, 0.226240, -0.383979, -1.208586, -0.000993, -0.053202, -0.002913, -0.002147, -1.008578, 1.616720, -0.001025, -0.690701, 0.604565, 0.969089, -0.058228, 
	-0.009517, -0.008134, -0.689541, -0.516122, 1.676339, -0.001528, -3.050389, -0.019311, -0.004958, 2.991017, 4.437580, -0.001715, -4.746528, -0.840828, 0.937448, -0.153813, 
	-0.009369, -0.004394, -0.417421, 0.272664, -2.414565, -0.001457, -0.775996, -0.005377, -0.003263, -0.254400, 2.174628, -0.001539, 0.724683, 1.196347, -0.462218, -0.018324, 
	-0.002646, -0.004551, -0.887608, -0.550834, 2.219095, -0.000723, -0.167629, -0.005161, -0.002722, 0.063635, 0.138417, -0.000851, -0.266319, -1.462636, 0.941916, -0.011383, 
	-0.000924, -0.000809, 0.665140, 0.249283, -0.146309, -0.000369, 0.536006, -0.001327, -0.000568, -0.676017, 0.216818, -0.000394, -0.636873, -0.043155, -0.155213, -0.005288, 
	-0.009100, -0.007855, 2.128231, 0.773964, -1.391124, -0.001666, -2.546397, -0.007110, -0.004585, 4.258358, -4.558055, -0.001914, 4.214337, -0.826093, -1.908430, -0.112560, 
	-0.020726, -0.009362, 4.552521, -3.671360, -0.337690, -0.005889, -0.401929, -0.014205, -0.008249, -2.335617, -2.146125, -0.006138, 5.464181, -1.764242, 0.788736, -0.083905, 
	-0.007127, -0.004228, 1.404339, -0.728950, -1.603638, -0.001269, 0.197565, -0.003443, -0.002652, 0.923188, 3.474027, -0.001513, -3.110380, 0.315819, -0.798711, -0.053028, 
	-0.010860, -0.006513, -0.353099, -0.437060, -0.533230, -0.002397, 0.146607, -0.009706, -0.004687, 2.125894, -1.545764, -0.002500, 1.607137, -1.060082, 0.125334, -0.039074, 
	-0.027502, 1.010274, 2.437860, -1.392230, -0.379602, 0.190141, -0.064704, -0.881909, -0.010227, -2.123056, -3.207323, -0.008167, 2.782372, 1.531030, 0.179660, -0.036617, 
	-0.009141, 0.365372, -0.219327, -0.171675, 0.086844, 0.192674, -2.160716, -0.202309, -0.003228, 0.277437, -0.269255, -0.002158, 2.623110, -0.177351, -0.282599, -0.047679, 
	-0.015682, -0.008851, -1.472707, 1.968028, -0.497713, -0.002621, -2.072496, -0.016214, -0.005227, 1.733249, 4.269769, -0.002499, -3.923428, -0.421606, 0.617170, -0.149172, 
	-0.059662, -0.029432, -0.541226, -2.137915, -5.895432, -0.007063, 4.349836, -0.035424, -0.016773, 3.924230, 4.163860, -0.007528, 0.986173, -2.580629, -2.001630, -0.111385, 
	-0.006192, -0.001701, 0.674470, -0.559233, -1.005316, -0.000814, -0.462427, -0.002897, -0.001393, 0.682577, -0.111636, -0.130267, 1.498575, -0.622066, 0.096346, -0.048026, 
	-0.080997, 0.674871, -1.113396, 0.867850, -2.525760, -0.013632, 7.437791, -0.740654, -0.028524, 0.620464, 7.248708, -0.143696, -7.031084, -3.646482, -2.623281, 1.097822, 
	-0.002115, -0.001132, -0.040218, -0.175205, -0.801301, -0.000520, -0.670570, -0.001313, -0.000795, -0.237907, 0.317477, -0.000542, 1.588033, -0.061048, 0.146199, -0.059043, 
	-0.073930, -0.011049, 0.674796, 3.121452, -2.685403, -0.003515, 2.084672, -0.014253, -0.007867, -0.800401, 1.436363, -0.003682, 2.187941, -3.025474, -3.011773, 0.132121, 
	-0.022448, -0.020126, -0.981070, 1.885612, 2.610298, -0.005549, -0.065241, -0.027692, 0.004045, -1.428557, 5.584823, -0.004793, -6.899812, -2.138026, 1.157396, 0.351140, 
	-0.009610, -0.005452, -0.596853, 0.220368, 0.683114, -0.001787, 0.474117, -0.007168, -0.004124, -0.879520, -2.741374, -0.001902, 2.614770, -0.327257, -0.502035, 1.084711, 
	-0.003304, -0.001156, 1.071728, -0.387850, -0.025379, -0.000544, -1.870140, -0.001542, -0.000898, 0.516079, 0.784418, -0.000570, 0.282454, -0.303323, -0.042128, -0.017844, 
	-0.386689, -0.154697, 0.579433, -2.373305, -3.404505, -0.040466, 3.526770, -0.210080, -0.088312, -1.189772, -0.716440, -0.043200, 0.350309, -0.435423, 4.338135, 0.248241, 
	-0.004677, -0.003248, -1.168423, 1.796129, 0.514785, -0.000830, -0.290328, -0.006573, -0.002283, -0.809844, 0.764441, -0.000931, -1.240730, -0.831241, 1.351031, -0.067279, 
	-0.017033, -0.012384, 1.035596, -0.603928, -1.286571, -0.002101, 1.965613, -0.004496, -0.003011, -0.044788, -2.119750, -0.001965, 0.737971, -0.890404, 1.368279, -0.121027, 
	-0.288818, -0.146657, 15.502252, -1.778820, -3.190486, -0.071968, -2.480412, -0.187624, -0.102336, 2.875747, -5.654513, -0.073854, 2.105104, -3.926887, -9.048737, 6.468009, 
	-0.051676, 4.470047, -0.565021, 0.301477, -0.254868, -0.011013, 2.241041, -4.165075, -0.019181, -2.666761, 0.810433, -0.015674, 2.433881, 0.645645, -2.986233, -0.167022, 
	-0.029021, -0.015816, -2.080325, 3.167485, -3.075248, -0.002994, -3.496341, -0.015702, -0.008251, 3.735145, 3.178380, -0.003223, -2.901389, -0.437457, 2.263453, -0.278694, 
	-0.006227, -0.004975, 0.330371, -1.108084, -0.096236, -0.001972, -1.268462, -0.014206, -0.003937, -0.169701, -2.052003, -0.002153, -0.711398, -0.214722, 5.368274, -0.044569, 
	-0.045318, -0.018721, -0.843656, 0.124080, -2.195307, -0.005691, -0.925548, -0.125672, -0.016684, 1.043561, -0.208966, -0.008992, 2.271174, 2.537232, -1.317075, -0.264417, 
	-0.016283, -0.001372, -0.321994, 0.096969, 0.416237, -0.000242, 0.203867, -0.001607, -0.000766, -0.150142, -0.607341, -0.000191, -0.126911, -0.045864, 0.568830, -0.013188, 
	2.225918, -0.027836, 0.665305, -2.032645, 0.652172, -0.012028, 3.290811, -0.056955, -0.027057, -2.457217, -1.644978, -0.012339, -1.484016, 2.679215, -1.032373, -0.725976, 
	-0.007370, -0.004918, 0.709651, 0.126808, -0.957298, -0.001779, 2.019805, -0.006422, -0.003716, 1.667382, -0.704768, -0.001975, -0.784975, -1.374113, -0.602002, -0.074311, 
	-0.014749, -0.007585, 0.165134, 6.103350, -1.246061, -0.002604, -3.647684, -0.010240, -0.004912, -1.253591, -0.839978, -0.002629, 2.614040, -1.135895, -0.666210, -0.050385, 
	-0.029857, -0.014265, -1.523447, 2.696387, 1.499832, -0.004203, 2.147767, -0.018791, -0.009609, -2.859711, -4.496394, -0.004501, 4.101749, -0.173466, -1.170792, -0.140700, 
	-0.162236, -0.051916, 0.010816, 0.672788, -1.420166, -0.014216, 4.845205, -0.076093, -0.032485, 0.880139, -1.580985, -0.015736, 1.193654, -3.561676, -0.575222, -0.111870, 
	-0.024129, -0.006392, 1.577103, -1.085270, -0.376989, -0.000822, -4.598036, -0.010455, -0.003580, 0.786611, -0.638954, -0.001009, 4.581100, -0.415296, 0.285845, -0.069727, 
	-0.032042, 0.139220, 0.508271, 1.103303, 1.733307, -0.002546, -2.622005, -0.125849, -0.004658, 0.991024, -1.641633, -0.002686, 2.033681, -1.867539, -0.133261, -0.076590, 
	-0.003567, -0.003673, 3.089185, -0.122358, -0.318592, -0.000912, 1.540452, -0.002815, -0.001789, -2.248553, -0.042474, -0.000929, -0.187834, -0.876264, -0.732354, -0.087522, 
	-0.029659, -0.021169, -0.091494, 3.421898, -1.970737, -0.003997, 3.248179, -0.019279, -0.010851, -3.572942, 4.356373, -0.004388, -1.490108, -2.448971, -1.228155, -0.134700, 
	-0.009527, -0.005611, 0.429636, 2.587547, 0.187794, -0.002410, 2.419821, -0.054498, -0.003641, -3.031021, -2.027099, -0.131876, -1.389906, -0.646003, 1.781303, -0.104510, 
	-0.215717, -0.137686, -1.451245, -0.008529, -1.136666, -0.048365, 1.033713, -0.385033, -0.110530, 2.457555, -0.222596, -0.050078, 2.291223, 3.411527, -4.957185, -0.470388, 
	-0.028598, -0.005499, 3.344477, -0.420547, -2.976852, -0.005732, 1.888270, -0.040236, -0.012946, -0.042049, 1.822858, -0.006095, -3.215549, -0.274850, 0.231891, -0.258543, 
	-0.002183, -0.002327, -0.245519, 0.426404, 0.044287, -0.000640, 0.430825, -0.003826, -0.001832, -0.189958, -0.364298, -0.000689, -0.061609, -0.481962, 0.471642, -0.018317, 
	-0.070132, -0.002316, 2.949317, -1.046207, -0.139515, -0.001244, -1.686504, -0.002881, -0.001825, -0.637723, -0.015431, -0.001310, 0.505312, -0.626452, 0.816285, -0.039372, 
	-0.176934, -0.025279, 0.895730, 0.765740, 0.539105, -0.008539, -4.495861, -0.041865, -0.017373, 1.838953, 2.362898, -0.017928, 0.859984, -1.982995, -0.739181, 0.243544, 
	-0.001564, -0.000725, 0.346402, 0.561580, 0.448110, -0.000223, -0.612162, -0.000891, -0.000517, -0.596970, 0.197322, -0.000202, 0.021054, -0.036292, -0.317946, -0.006978, 
	-0.103899, -0.020268, 0.071458, -0.795231, 0.870137, -0.004070, 4.559550, -0.039428, -0.010465, -2.670751, 1.983191, -0.004456, -2.333639, -1.361174, -1.117010, 0.976053, 
	-0.006986, -0.002919, 0.604561, -0.832157, 0.225149, -0.001312, -1.058620, -0.004330, -0.002326, 0.537629, 0.222543, -0.001374, 0.595136, -0.393506, 0.145738, -0.027226, 
	-0.016033, -0.012045, -0.205041, 2.570134, -0.957998, -0.004404, -2.268279, -0.013636, -0.008336, -4.472045, 0.353664, -0.004635, -2.949987, 0.386111, 7.870828, -0.268298, 
	-0.039530, -0.009207, 3.149577, -0.910255, -4.081990, -0.002570, 1.365498, -0.023135, -0.006797, 0.795375, -0.805581, -0.002796, -0.488444, 2.433867, -1.162951, -0.211062, 
	-0.067055, -0.019048, -0.287071, 1.543568, 6.322516, -0.004508, 5.754736, -0.046874, -0.010810, 0.997949, -5.237354, -0.134350, -5.895339, -1.132023, -1.122916, -0.661422, 
	-0.000444, -0.000415, 0.522883, -0.178587, 0.783280, -0.000186, -0.810903, -0.000389, -0.000278, -0.579510, 0.306357, -0.000193, -0.005379, -0.037633, 0.002614, -0.001218, 
	-0.010757, -0.004403, -0.573041, -0.479618, 2.472008, -0.000543, -3.186539, -0.001748, -0.001396, -0.042934, 1.635796, -0.000571, -0.457040, 0.926466, -0.247678, -0.028002, 
	-0.085934, 0.525429, -3.423866, 4.598041, -3.792325, -0.020374, -4.302786, -0.141208, -0.034961, 1.220839, -3.003273, -0.021219, 1.827353, 6.492106, 1.297623, -1.135443, 
	-0.025092, -0.009164, -1.823189, 1.797142, -1.913758, -0.004168, 0.940535, -0.011190, -0.007082, 1.472184, 0.456245, -0.004767, 0.304975, -0.577798, -1.020913, 0.426042, 
	-0.023825, -0.003923, -2.662289, -0.844051, -0.180660, -0.002423, -0.220055, -0.007756, -0.002801, -1.331215, 1.380025, -0.002610, -1.807823, 5.292004, 0.577226, -0.159825, 
	-0.111870, -0.017831, 2.715616, -2.307518, -1.737282, -0.005887, 2.904587, -0.024013, -0.011490, 2.881575, -0.598599, -0.006170, -3.469960, 1.159456, -0.970209, -0.400403, 
	-0.019715, -0.008198, 2.492611, 2.095248, 0.064666, -0.001425, 2.594343, -0.008218, -0.004385, -0.735997, -1.127095, -0.001589, -2.765518, -1.617912, -0.814389, -0.142427, 
	-0.033475, -0.022043, -0.660106, -0.844196, -0.546582, -0.003343, -3.161221, -0.016732, -0.010729, 2.651743, 7.047769, -0.003818, 0.969704, -3.521283, -1.715815, -0.129874, 
	-0.003583, -0.002425, -0.039633, 1.787578, 0.490493, -0.001016, 2.826700, -0.002432, -0.001711, -1.325596, -1.042370, -0.000918, -1.941195, -0.386819, -0.324393, -0.032680, 
	-0.176948, 0.015793, -0.555442, 0.361668, 4.196098, -0.015489, -0.010106, -0.117722, 0.312521, 1.440104, -2.207217, -0.016110, -2.158186, -1.871474, -0.551627, 1.354137, 
	-0.008056, -0.005028, -0.383501, -1.518904, -1.275770, -0.001745, 0.772251, -0.006074, -0.003431, -1.018807, -0.211230, -0.001816, 2.952699, 0.513586, 0.274662, -0.078836, 
	-0.024723, -0.009655, 0.010172, -0.664046, -1.572012, -0.017406, 3.753357, -0.023155, -0.009433, 0.866516, -3.381388, -0.017457, 1.601022, -0.102107, -3.326143, 2.916457, 
	-0.012701, -0.005906, -0.087288, 0.699057, 2.551563, -0.001113, 0.225645, -0.021420, -0.003069, 0.738623, -2.474654, -0.001505, -0.502071, -0.564030, -0.493597, -0.047533, 
	-0.009766, 0.358810, -1.060057, 1.915067, -1.942036, -0.002247, -3.576563, -0.211599, -0.006803, 1.978154, 5.735151, -0.002402, -3.128469, 1.627539, -1.068056, -0.606722, 
	-0.073995, -0.011275, -2.416821, 2.539930, 3.449685, -0.004819, -4.415383, -0.012854, -0.008308, 4.440013, 1.586924, -0.134455, -0.553625, -1.167659, -3.134701, -0.082657, 
	-0.051098, -0.012931, 4.924410, -0.047031, -2.654013, -0.001806, -3.418066, -0.111008, -0.007109, -0.565322, 2.235600, -0.002163, -2.413080, 2.338007, -0.132134, -0.082256, 
	-0.003394, -0.003104, 0.467073, 2.357775, 0.234120, -0.000366, 0.773046, -0.004218, -0.001460, -0.434970, -0.734885, -0.000408, -1.338784, -0.369288, -0.933201, -0.007937, 
	-0.017912, -0.004227, -0.094487, 3.466708, -2.916948, -0.001274, -1.310560, -0.009335, -0.002869, 0.254429, -1.020052, -0.001353, 1.656735, 0.072734, -0.024144, -0.047447, 
	-0.021272, -0.005914, -1.050035, 0.396847, -1.215749, -0.001485, 0.977604, -0.006357, -0.003670, 2.744346, 0.309608, -0.001791, -0.408598, -0.881453, -0.774952, -0.057128, 
	-0.020190, -0.007795, 0.715274, -0.033334, -1.097399, -0.002598, -1.277194, -0.012686, -0.005419, -0.847728, -2.589790, -0.002615, 5.078907, -0.409271, 0.563014, -0.051178, 
	-0.005516, -0.003102, -1.120222, 1.368608, -0.933659, -0.001586, -2.141319, -0.004184, -0.002588, -0.672433, 1.484708, -0.001632, 0.134305, -0.337947, 2.292339, -0.055771, 
	-0.021624, -0.008634, -0.479422, -0.260837, -1.081965, -0.002066, 0.580262, -0.008952, -0.004918, -1.072081, -0.964029, -0.002016, -0.816574, 1.446271, 2.770225, -0.073640, 
	-0.002340, -0.001311, -0.196057, 1.175137, -0.210302, -0.000510, -1.177095, -0.001704, -0.000957, -0.051353, -3.612432, -0.000526, 4.844076, -0.394436, -0.362275, -0.007913, 
	-0.002870, -0.001531, -0.460060, -0.022526, -0.804025, -0.000487, 0.722471, -0.002114, -0.001087, 0.372874, -0.512045, -0.000519, 1.416731, -0.158647, -0.525434, -0.020730, 
	-0.027254, -0.016405, 0.704507, 6.144163, -0.638172, -0.004301, -3.487909, -0.012207, -0.012257, -2.701429, -0.858855, -0.004497, 0.114999, 2.178022, -1.267681, -0.110723, 
	-0.038911, -0.010948, 0.153501, -1.665030, -1.757539, -0.003732, 1.191686, -0.016143, -0.008030, 1.788893, 0.225171, -0.003912, 0.889342, -1.658140, 1.033407, -0.119617, 
	-0.014051, -0.007617, -2.286935, 1.919673, 0.863403, -0.003500, -4.206297, -0.010360, -0.005649, 4.615316, 5.338559, -0.003592, -5.963167, 0.611715, -0.590170, -0.257329, 
	-0.090705, 0.039536, 2.033098, -1.398509, -3.023017, -0.012076, -0.295552, -0.152867, -0.030566, 1.385809, 3.635011, -0.020766, 2.621222, -3.172294, -1.034123, -0.484204, 
	2.254419, -0.028367, -3.365025, 2.848287, -0.561652, -0.006656, 0.066399, -0.040268, -0.017645, 0.952455, -1.930879, -0.007303, 2.343574, 1.424969, -2.019294, -1.913015, 
	-0.038530, 0.181593, -1.638387, 1.359286, -0.910380, -0.001823, 2.663658, -0.093277, -0.005742, -0.007674, 3.208724, 0.000213, 2.724760, -6.126349, -1.573664, 0.257592, 
	-0.139998, -0.027787, 1.180678, -2.445686, -3.563533, -0.014304, -7.337251, -0.048637, -0.020655, -2.769716, 3.256006, -0.015051, 19.574858, -4.979776, -3.171180, 0.522030, 
	-0.148351, -0.061768, 3.128577, -2.138381, -2.219815, -0.020832, -1.356011, -0.094372, -0.040760, -0.618589, -2.420343, -0.022495, -0.757452, 1.907637, 5.655506, -0.792551, 
	-0.031620, -0.005286, -0.775279, 1.968676, -0.166415, -0.002395, -2.868649, -0.018973, -0.004298, -0.999762, -4.050433, -0.002500, 3.311730, 4.141650, -0.429856, -0.066590, 
	-0.030668, -0.011512, -1.175113, 1.972485, -0.652692, -0.002036, -2.999929, -0.025199, -0.005182, -0.010918, -0.460500, -0.002160, 1.160290, 0.126563, 2.273216, -0.156646, 
	-0.031621, -0.005873, -0.673356, -0.793183, -3.268406, -0.001803, 5.665931, -0.007341, -0.003560, -1.049458, -5.583927, -0.001868, 6.663116, -1.339126, 0.516391, -0.085918, 
	-0.026878, -0.030212, -1.783207, -1.798361, -1.931476, -0.003583, 2.644607, -0.022636, -0.008978, -1.637342, 4.631337, -0.003845, -1.188835, 1.889731, -1.081638, 0.351316, 
	-0.039688, -0.019620, -2.254306, 9.075636, -5.786237, -0.008688, 3.533158, -0.017903, -0.012935, 0.973714, -1.399855, -0.009044, -1.844222, -1.304623, -1.440362, 0.554976, 
	-0.030536, -0.014879, -1.023087, 0.238795, -2.277239, -0.002419, -2.074471, -0.032202, -0.009055, -1.976690, 0.761755, -0.002812, 1.577150, 4.371901, 0.859047, -0.365259, 
	-0.057740, -0.012558, 3.971144, -1.120991, 0.263979, -0.002810, -0.929360, -0.018940, -0.008527, -0.190283, -2.446055, -0.002921, 2.050852, -0.416716, -1.029253, -0.049821, 
	-0.018890, -0.017234, 5.994439, -3.667721, -3.317942, -0.004544, 1.030694, -0.025115, -0.009936, 1.883035, 6.031096, -0.004695, -3.190386, -2.706897, -1.860731, -0.115172, 
	-0.006542, -0.002642, 0.075969, -1.015166, 1.374631, -0.000847, 1.406271, -0.004780, -0.001835, -0.373700, -0.856613, -0.000874, -1.468427, 1.025596, -0.044475, -0.106566, 
	-0.008688, -0.005227, -1.222778, -2.163208, -0.207736, -0.001571, -2.797025, -0.004299, -0.002999, 1.961028, 1.379196, -0.001620, 3.220028, -0.227624, 0.119707, -0.037183, 
	-0.030760, -0.011836, -0.784600, 1.458863, 0.592339, -0.002932, -1.215328, -0.021751, -0.006432, -0.724802, 0.116721, -0.132470, 3.863258, -1.416156, -1.548101, -0.136012, 
	-0.113500, -0.031024, -0.009815, 1.135163, 2.314834, -0.007290, -2.357735, -0.304033, -0.024969, -0.742776, 1.618770, -0.007905, -3.443493, 0.656397, 1.647708, -0.330333, 
	-0.006531, -0.012154, -0.617487, 0.905155, -1.000940, -0.001027, 0.466654, -0.006821, -0.003416, 0.946293, 1.348223, -0.001195, -0.164851, -0.579266, -1.243779, -0.028858, 
	-0.020432, -0.015017, 2.002053, -2.741284, -0.308448, -0.003118, -2.733602, -0.023929, -0.009092, -1.630744, 3.209734, -0.003381, 1.043232, -0.641390, 2.043213, -0.167795, 
	-0.015832, -0.006446, 0.977272, -0.044740, 1.599397, -0.001195, -0.002939, -0.010028, -0.003670, 0.929839, 1.053855, -0.001282, -2.830816, -1.336236, -0.035318, -0.271859, 
	-0.034343, -0.018564, -1.254256, 0.286404, -3.237092, -0.002920, -5.091701, -0.022999, -0.009504, -0.280581, 0.169855, -0.003251, 8.068367, 2.723699, -1.159478, -0.133634, 
	-0.001487, -0.001295, 0.160191, -0.000206, -0.508739, -0.000465, -0.139866, -0.007449, -0.001042, -0.608431, 2.279792, -0.000418, -2.410386, 0.016983, 1.232078, -0.009259, 
	-0.005813, -0.006744, -1.209032, 0.775846, -0.057893, -0.001669, 0.212551, -0.008903, -0.003871, 3.015620, -0.816367, -0.001802, -1.064764, -0.353098, 0.209901, -0.683963, 
	-0.006563, -0.005950, -0.130894, 0.198140, 1.916608, -0.000883, 1.190554, -0.005965, -0.002703, -1.273695, 2.371419, -0.000991, -3.166788, 0.021454, -1.008189, -0.095552, 
	-0.017166, -0.014086, 1.313923, 2.971505, -1.284029, -0.003275, -1.972104, -0.013842, -0.007280, 6.236325, -2.473935, -0.003404, -2.905866, -2.571012, 0.944523, -0.200277, 
	-0.042851, -0.042936, 0.660959, -3.215718, -0.659290, -0.008821, -6.387087, -0.043825, -0.025046, 0.866456, -0.848123, -0.009542, 9.338583, 2.175838, -1.096088, -0.662511, 
	-0.010838, -0.006528, -1.048203, -0.646715, -0.183853, -0.001969, -1.976369, -0.049142, -0.007066, -0.078959, 13.908440, -0.004230, -10.452404, -0.556658, 1.155740, -0.041246, 
	-0.016433, -0.003924, -2.659036, 6.144903, 0.523586, -0.006049, -1.879359, -0.023688, -0.008631, -3.786969, -0.784921, -0.135565, 2.015913, 0.202047, 0.694922, -0.276797, 
	-0.001522, -0.001245, -0.182476, 0.743469, -0.529630, -0.000653, -0.157812, -0.002707, -0.000987, -0.156285, -0.010237, -0.000674, -0.107885, -0.051374, 0.646252, -0.186233, 
	-0.008821, -0.001981, -0.035215, 0.081328, -0.552070, -0.000372, -1.003070, -0.002461, -0.001217, -0.680983, 1.978123, -0.000408, 1.050305, -0.933756, 0.141194, -0.030596, 
	-0.069217, -0.034149, 0.534567, -0.611529, -1.030588, -0.010470, 5.686741, -0.057635, -0.023383, 3.505996, -5.098521, -0.011148, -3.354312, 2.716136, -1.913420, -0.229067, 
	-0.009488, -0.005240, 3.707746, 0.037181, -0.841628, -0.002134, 2.698300, -0.010290, -0.003983, -2.371340, -0.868496, -0.002144, 1.946175, -1.364350, -2.858773, -0.051537, 
	-0.045730, -0.024588, -0.419438, -0.480639, -1.452680, -0.006771, -2.425837, -0.046256, -0.015554, 1.341427, 1.235877, -0.007234, 2.768423, 0.113671, -0.744551, 0.209880, 
	-0.003695, 0.759478, 1.118031, -0.119983, 0.617371, -0.001216, 1.068992, -0.748435, -0.002546, 0.823669, -2.025316, -0.001282, -0.854562, -0.607969, 0.016398, -0.038937, 
	-0.004025, -0.002093, -0.448188, 0.767922, -1.144524, -0.000993, 0.386180, -0.004258, -0.001918, -0.371410, 1.777505, -0.001053, -0.042938, -0.451550, -0.339748, -0.118909, 
	-0.010436, -0.003280, -1.176691, 5.089832, -2.097970, -0.001288, 1.346262, -0.004604, -0.002397, -0.362253, -0.073263, -0.001398, -1.447122, -0.903864, -0.299710, -0.051816, 
	-0.006844, -0.003769, 2.608069, -2.324265, -0.024997, -0.001396, -0.684468, -0.005416, -0.002489, -0.097264, 0.094118, -0.001493, -0.746852, 0.083216, 1.124231, -0.010381, 
	-0.009213, -0.005814, -1.481340, 0.307812, -0.137488, -0.001771, 2.338825, -0.006808, -0.003763, -0.458685, 0.964972, -0.001880, -1.007444, -0.435533, -0.018957, -0.042913, 
	-0.019639, -0.016077, 2.058383, -1.469087, -3.598484, -0.002820, 1.270089, -0.015722, -0.007837, -0.761152, -5.992388, -0.003009, 9.071123, 0.149792, -0.527208, -0.135966, 
	-0.008347, 0.384829, 3.380155, 0.716188, -0.438799, -0.001895, 0.912422, -0.252230, -0.004918, -2.851979, -0.458164, -0.002031, -1.649734, 0.090410, 0.224173, -0.040079, 
	-0.042369, -0.007494, -0.348940, 0.080345, 0.056053, -0.000878, 0.935764, -0.002522, -0.002125, -0.736739, 1.576630, -0.000920, -2.225363, 0.271643, 0.573502, -0.126587, 
	-0.012833, -0.013718, -1.514764, 1.304167, -1.063157, -0.003556, -0.215574, -0.027196, -0.008929, 0.355342, 6.239742, -0.003730, -3.392728, -2.693079, 1.136182, -0.086170, 
	-0.050190, -0.005844, -0.536472, -1.421442, 0.039740, -0.002125, 2.158110, -0.025089, -0.004691, -1.183443, -3.247363, -0.002293, 2.338105, 1.539189, -1.363760, 1.767568, 
	-0.006045, -0.002072, 0.479305, -1.404040, 0.867148, -0.000629, 0.968899, -0.005502, -0.001961, -0.404348, -0.423709, -0.000710, -0.715717, 0.368743, 0.288147, -0.007508, 
	-0.075232, -0.028330, 0.661070, -0.968708, 5.728448, -0.011816, -4.366942, -0.092514, -0.023030, 1.572524, -2.547805, -0.012733, -0.045380, 1.558585, -0.750011, -0.598125, 
	-0.002622, -0.002035, -0.338923, -0.180030, 0.213113, -0.000516, 0.125052, -0.002203, -0.001129, 2.470372, -0.445968, -0.000525, -1.675102, -0.024787, -0.087306, -0.047392, 
	-0.006346, -0.003361, 0.983879, 1.166893, 0.256989, -0.001158, -3.616649, -0.006102, -0.002566, 0.209222, -0.096155, -0.001236, 0.815337, 1.078357, -0.771147, -0.005956, 
	-0.009365, -0.003440, -0.083407, 0.812628, 2.337111, -0.001380, -1.608923, -0.003804, -0.002329, -0.832390, -0.231348, -0.001441, -0.257075, -0.183723, 0.107606, -0.038720, 
	-0.102762, 0.223688, 3.550885, -0.535782, -4.110450, -0.016954, -0.872985, -0.174555, -0.034709, -0.633866, 1.899205, -0.017758, 3.214111, 2.097736, -2.726737, -1.759069, 
	-0.050078, -0.018531, 2.941282, -0.832363, -0.819706, -0.004476, 2.201765, -0.060232, -0.012294, -1.949459, 3.874670, -0.004706, -4.595431, -0.970016, 0.510244, -0.210670, 
	-0.031651, -0.021293, 1.217347, -0.208068, -3.335062, -0.003976, 2.916060, -0.026655, -0.011644, 3.618357, -3.701381, -0.004301, 1.240967, 0.524314, -1.519389, -0.653626, 
	-0.001561, -0.000615, 0.625468, -0.125030, -0.267433, -0.000242, -0.175646, -0.000539, -0.000418, 0.185501, 0.139710, -0.000257, -1.041220, -0.032028, 0.719017, -0.024707, 
	-0.001286, -0.002787, 0.205117, -0.633774, 1.738613, -0.000433, -0.056049, -0.003021, -0.001384, 0.108632, 0.350666, -0.000496, -0.866120, -0.780872, -0.042844, -0.013962, 
	-0.002022, -0.000710, -0.026326, 0.259799, -0.048720, -0.000146, -0.086658, -0.000627, -0.000391, -0.028564, -0.909491, -0.004560, 0.616916, 0.581167, -0.337519, -0.012148, 
	-0.005803, -0.007015, -1.410952, 1.036644, -3.352580, -0.001581, 0.611365, -0.011941, -0.005504, -0.685857, 5.318515, -0.001702, -4.415677, 3.407079, -0.427215, -0.047777, 
	-0.003930, -0.003789, 0.094646, -0.678911, -1.765955, -0.001035, 5.620898, -0.004921, -0.002481, 0.230006, -1.086519, -0.001106, -2.297714, -0.358505, 0.302597, -0.043281, 
	-0.003000, -0.004415, -1.465252, 1.412203, -0.243790, -0.000745, -0.905196, -0.002036, -0.001664, -1.403792, 1.637946, -0.000770, -2.109624, -0.462134, 3.564348, -0.012080, 
	-0.006298, -0.003630, -0.901217, -1.646959, 3.231992, -0.001662, 3.177036, -0.004207, -0.002999, 0.601628, -0.074474, -0.001750, -3.432568, -0.344031, -0.575676, -0.015185, 
	-0.010905, -0.005912, 6.027760, -2.057489, 0.107746, -0.002097, 0.977842, -0.013178, -0.004432, -0.901795, -0.669692, -0.002321, -0.699984, -1.037491, -1.672969, -0.035082, 
	-0.003426, -0.003151, 0.976355, 1.319928, -0.621614, -0.001671, -1.788494, -0.009532, -0.002644, 1.314381, -1.412698, -0.002278, 1.652557, -1.051502, -0.348149, -0.018062, 
	-0.002998, -0.002739, -1.522071, 1.395621, 0.232717, -0.001590, -0.220928, -0.005074, -0.002431, -0.930755, -0.574486, -0.001630, -0.312042, 1.395381, 0.577609, -0.024584, 
	-0.002468, -0.002470, -0.192057, -1.355111, 0.875586, -0.001096, -1.271005, -0.002632, -0.001745, 0.627447, 0.221262, -0.001137, -1.100477, -0.757975, 2.991037, -0.027158, 
	-0.027264, -0.014629, -2.926462, 0.215103, 4.479993, -0.004016, 0.320175, -0.016411, -0.008674, 0.757359, -4.717155, -0.004532, 2.193128, 0.077380, -0.216726, -0.107270, 
	-0.191871, 0.037840, 1.704720, -1.632378, -3.637476, -0.026769, -1.341119, -0.246815, -0.041420, -6.042968, -1.450284, -0.023697, -2.945991, 12.273545, 5.516861, -1.952180, 
	-0.002511, -0.002910, 0.668436, 1.814269, -0.832917, -0.000821, -2.040524, -0.002342, -0.001649, 1.178296, 2.309468, -0.000854, -2.517128, -0.098611, -0.451874, -0.018328, 
	-0.009048, -0.005908, -2.323747, -1.322967, 0.579379, -0.001253, -0.563358, -0.041764, -0.004250, 4.487229, 0.444265, -0.001385, -1.416215, 0.314406, -0.052126, -0.083259, 
	-0.001055, -0.000667, -0.422722, -0.180060, -0.144232, -0.000359, -2.150130, -0.001025, -0.000582, 0.269518, 3.290401, -0.000370, -1.158658, -0.148424, 0.659142, -0.010777, 
	-0.035306, -0.023027, 1.190565, -0.527192, -2.718812, -0.006739, -3.391047, -0.033959, -0.013992, 4.125994, -1.716739, -0.007300, 4.368863, -0.834725, -0.272724, -0.103859, 
	-0.006774, -0.009571, -0.555673, -0.962027, -0.075760, -0.000909, 0.378472, -0.019198, -0.004430, -0.708622, 1.940431, -0.000934, 1.132275, -0.647319, -0.406977, -0.052985, 
	-0.009829, -0.002845, -0.510511, -0.353543, 0.317957, -0.001348, 0.647915, -0.003418, -0.002033, -0.343782, -1.837950, -0.001440, 1.425511, -1.570923, 2.276400, -0.030162, 
	-0.008799, -0.003337, -0.387476, -0.443298, 0.201504, -0.001373, 2.172673, -0.009216, -0.002599, -2.131409, -2.336042, -0.001487, 0.893917, -0.847658, 2.937165, -0.032568, 
	-0.019701, -0.003453, -1.236622, 4.650601, 0.041271, -0.000816, -1.806606, -0.056845, -0.002631, -0.715482, -0.089653, -0.001656, -1.817271, 0.552295, 0.530750, -0.024181, 
	-0.007196, -0.007778, -0.624468, 0.393981, 0.535457, -0.001794, 1.610486, -0.011412, -0.005370, 5.346548, -5.182701, -0.002099, 2.001779, -1.857872, -0.826344, -1.361216, 
	-0.013560, -0.008193, -1.062426, 7.656091, -1.944609, -0.002710, -0.379933, -0.010968, -0.005617, -1.640725, -2.519547, -0.002811, 3.426948, -1.506810, -1.679092, -0.306037, 
	-0.068276, -0.032926, -1.426266, -2.943273, -4.880529, -0.031792, -2.154213, -0.034993, -0.024146, 2.516053, 12.814421, -0.032269, -4.313653, -2.031917, -1.863661, 4.507441, 
	-0.038921, 0.100708, -2.638281, 0.591364, -1.483184, -0.003478, -0.271713, -0.136602, -0.009426, 0.812737, 5.260265, -0.008130, 0.359874, -0.956265, -1.467563, -0.111383, 
	-0.035977, -0.015643, 0.060930, -1.269328, 1.480641, -0.004836, 0.629787, -0.025816, -0.010831, -1.387938, 3.123208, -0.005272, -5.902345, 0.731703, 2.841204, -0.209488, 
	-0.004369, -0.001684, 0.513688, 0.346161, -0.408361, -0.000624, 2.433331, -0.043187, -0.002598, -0.719069, 1.048814, -0.000696, -2.128940, -1.074945, 0.063598, -0.021121, 
	-1.141110, -0.748882, 2.073625, 2.559338, 0.398216, -0.243162, -2.455179, -0.937099, -0.453344, 0.848456, -1.665791, -0.190414, -2.625298, 2.132716, 0.454260, 1.993667, 
	-0.012277, -0.007094, -1.020283, -2.161801, -0.366221, -0.002561, 0.426833, -0.012538, -0.005623, 4.432948, -1.281136, -0.002626, -1.027210, 1.324723, -0.205370, -0.079764, 
	-0.017708, -0.021769, -3.230203, -0.518206, -1.124352, -0.002321, 2.635887, -0.015621, -0.006653, -0.560582, -0.140248, -0.002398, 1.565301, 1.290779, 0.057335, 0.090757, 
	-0.022130, -0.005455, 0.152483, 1.725201, 1.424921, -0.002167, -0.834978, -0.006208, -0.003547, -1.811461, 0.396991, -0.002230, -1.974563, 0.282703, 0.727895, -0.047455, 
	-0.014170, -0.006827, -4.943749, 5.266127, -1.574737, -0.002606, -0.669470, -0.006063, -0.004300, 4.115617, -0.504630, -0.002652, -0.764512, -0.713149, -0.093205, -0.081675, 
	2.376071, -0.006127, 0.228288, -1.806950, -0.834061, -0.001527, -1.035132, -0.011180, 0.014864, 3.095484, -4.449159, -0.001680, 4.208819, -0.941185, -0.792739, -0.043786, 
	-0.003375, -0.003878, 1.849916, -1.267029, -0.435695, -0.001097, 4.094910, -0.003605, -0.002307, -0.268920, -3.476810, -0.001259, -0.220269, -0.006100, -0.214304, -0.040180, 
	-0.007154, -0.006559, 1.929868, 0.823480, 0.467761, -0.002030, 0.209363, -0.009880, -0.004418, -2.556271, -0.741946, -0.002054, -2.127402, 0.497649, 1.811907, -0.282314, 
	-0.017812, -0.015516, -0.014644, -3.900984, 0.497887, -0.009064, 2.251841, -0.014946, -0.010962, -1.680029, -0.411470, -0.009178, -2.973928, -1.625836, 8.198030, -0.263390, 
	-0.021146, 0.264223, -2.504176, 0.577875, 2.344142, -0.003095, -3.845489, -0.264278, -0.006386, 0.588804, -0.310812, -0.003089, 3.831894, -0.406679, -0.180075, -0.061711, 
	-0.004553, -0.003341, 1.895298, -1.547511, 2.997127, -0.001330, -0.671872, -0.004126, -0.002454, -0.991015, 0.156974, -0.001365, -0.487011, -1.910713, 0.587452, -0.011561, 
	-0.006417, -0.002101, -0.213108, 0.608308, 0.485174, -0.000776, -1.666049, -0.002916, -0.001473, -0.057999, 3.777534, -0.000801, -3.255149, -0.087431, -0.055344, 0.478545, 
	-0.028087, -0.014081, 1.871244, 1.759568, -1.671938, -0.004445, 0.879804, -0.023102, -0.009885, -0.530019, 0.056870, -0.004746, -0.094324, -2.349458, 0.307008, -0.144408, 
	-0.008823, -0.007528, -3.332250, -2.150491, 4.271139, -0.003082, -0.185578, -0.006815, -0.004903, 2.009209, -2.809785, -0.003133, -1.226083, 1.593184, 1.895256, -0.030317, 
	-0.078763, -0.017846, -2.822286, 0.876897, -3.294657, -0.005908, -1.850271, -0.028380, -0.011525, -0.407599, 2.901029, -0.006342, 1.627382, 3.394183, 0.047966, -0.323880, 
	-0.049443, -0.028422, -4.060269, -0.644705, 2.768445, -0.003794, -0.461514, -0.019405, -0.009877, 2.635442, 2.046080, -0.004078, -3.339111, 1.836035, -0.138545, -0.526839, 
	-0.001250, -0.000936, -0.151178, -0.093457, 0.075039, -0.000483, -0.447834, -0.001151, -0.000691, 0.344895, 5.164461, -0.000480, -4.942067, 0.106626, -0.038002, -0.013491, 
	-0.004749, -0.004499, -0.682879, -0.438789, 1.619508, -0.000764, -0.711364, -0.010063, -0.002464, -0.951674, 3.473947, -0.000855, -1.762904, -0.099980, -0.351677, -0.070793, 
	-0.038913, -0.006704, 2.109539, 1.057922, -1.096190, -0.000759, 1.694519, -0.011371, -0.003793, -1.397819, -0.859922, -0.000971, -1.542692, 0.206180, -0.068867, -0.040160, 
	-0.011094, -0.011796, 2.774652, 0.341253, 1.035885, -0.003114, -4.224091, -0.018866, -0.006234, -0.272191, 2.045627, -0.132697, -0.083217, -1.645381, 0.691878, -0.480615, 
	-0.005284, -0.002396, 1.297871, -0.169212, 2.845371, -0.000791, -1.580828, -0.003019, -0.001613, -1.164472, -1.116417, -0.000838, 0.210622, -0.594577, 0.306752, -0.021170, 
	-0.008343, -0.005131, 0.270825, 2.390947, -0.381021, -0.001328, -3.192847, -0.008892, -0.003681, 0.465249, 1.304189, -0.001500, -0.280933, -1.027496, 0.596893, -0.116929, 
	-0.031291, -0.006995, 7.935993, -2.834425, -0.457274, -0.003302, -2.786409, -0.010923, -0.005597, -4.143737, 0.487157, -0.003404, 1.337380, 0.504053, 0.065629, -0.046854, 
	-0.002675, -0.001647, 0.145857, -2.246722, 1.062849, -0.000560, 1.179431, -0.002926, 0.008585, -0.019704, 0.908570, -0.000602, -0.814764, -0.202141, 0.083858, -0.097410, 
	-0.038392, -0.017269, -0.129576, 1.002771, -1.520150, -0.003170, 1.473675, -0.049791, -0.007553, -0.347224, -1.076939, -0.000481, 1.861644, -0.097033, -0.675745, -0.374767, 
	-0.007799, -0.006667, -1.074046, 1.357127, -2.181006, -0.000830, 2.303739, -0.011651, -0.003584, 3.589989, -0.499992, -0.001009, -0.871588, -0.170462, -1.851961, -0.570259, 
	-0.023799, -0.004880, -0.782217, -2.215607, -4.286094, -0.000727, -4.958892, -0.009887, -0.002703, -0.864725, 5.650115, -0.000864, 6.699281, 1.126119, -0.049832, -0.275288, 
	-0.014454, -0.010591, -0.126262, 0.731299, -1.210515, -0.001908, -1.961657, -0.008211, -0.004797, 2.373010, -5.601202, -0.002031, 5.587485, -1.859595, 0.448089, 1.661340, 
	-0.059237, -0.015011, 0.866493, 0.791601, 0.082098, -0.003664, 1.811155, -0.018479, -0.007399, -1.201558, -4.163696, -0.003877, 3.037563, -1.944777, 0.945501, -0.116713, 
	-0.010417, -0.004165, -0.076056, 1.284937, -1.457191, -0.001273, 1.254928, -0.006292, -0.002421, 1.806430, -4.533935, -0.001327, 1.898437, 0.881240, -1.013956, -0.018941, 
	-0.019819, -0.012701, -2.757381, -0.935671, -0.761523, -0.005081, 4.183978, -0.012949, -0.010885, 7.773622, 1.651704, -0.005170, -5.243658, -2.085043, -1.674252, -0.085172, 
	-0.005029, -0.002719, 0.137914, -0.831543, -1.244569, -0.001127, -1.718211, -0.004576, -0.001964, 1.412423, 4.859511, -0.001178, -3.360584, -0.172416, 1.006240, -0.072174, 
	-0.025985, -0.012293, -2.336620, 0.775683, -1.959599, -0.007542, -0.934241, -0.014347, -0.009976, 0.297610, -1.959394, -0.007710, 1.843986, -3.479095, 7.447619, 0.381905, 
	-0.020822, -0.013571, -2.737911, -2.308561, -3.690734, -0.004317, 11.490306, -0.026691, -0.009563, -0.493567, -2.127542, -0.004286, -5.043602, 0.290048, 5.101148, -0.400336, 
	-0.004594, -0.002688, 0.913212, -1.063547, 0.621390, -0.000840, -0.822779, -0.001862, -0.001601, -0.285659, 1.490904, -0.000877, -0.602136, -0.084075, -0.134246, -0.020603, 
	-0.005723, -0.002887, 0.926317, -1.734953, 0.603312, -0.001330, -1.859473, -0.002768, -0.001794, -0.716797, -2.218005, -0.001398, 2.188479, -0.348849, 0.197446, 2.978422, 
	-0.035091, -0.009682, -1.695158, 1.209685, -1.746845, -0.003388, -1.429439, -0.015285, -0.007683, 0.055293, 2.837621, -0.003532, 3.541576, -1.401286, -1.221474, -0.075311, 
	-0.011406, -0.008929, 1.201032, -2.035986, 0.309520, -0.002789, -5.855918, -0.015457, -0.005651, -2.438479, 4.594400, -0.002964, 3.298066, -0.409421, 1.431295, -0.047313, 
	-0.122632, -0.033005, 0.026554, 0.908447, -9.075053, -0.011505, -0.911046, -0.045634, 0.009106, 4.964709, 11.801605, -0.020783, -5.249944, 1.435165, -3.332528, -0.343454, 
	-0.020786, -0.007188, -1.155503, -1.361613, -1.064133, -0.002766, 0.227054, -0.030636, -0.005324, -0.190583, -0.071576, -0.002875, 0.498401, 0.615581, 2.966472, -0.394524, 
	-0.028711, -0.017937, 0.644675, 0.642424, -5.170234, -0.004554, -2.241078, -0.036590, -0.012492, 0.746769, 1.353144, -0.005027, 2.130269, 1.203538, 1.324144, -0.528342, 
	-0.011760, -0.008670, -0.364897, 1.289886, -3.646052, -0.003071, -0.400806, -0.014971, -0.006036, 1.550890, 0.431835, -0.003223, 1.413049, -0.230512, 0.069017, -0.064679, 
	-0.000998, -0.000689, 0.525093, -0.075776, -0.134216, -0.000399, -0.113568, -0.001495, -0.000695, -0.420612, 0.112335, -0.000409, 0.261471, -0.083591, -0.050963, -0.015488, 
	-0.199975, -0.025526, -3.053316, -0.659315, 3.019001, -0.006256, 7.144126, -0.030066, -0.013771, -1.657139, -1.694585, -0.006633, -1.084002, -1.982403, 0.189700, 0.060162, 
	-0.016858, -0.010958, 0.394091, -0.436463, -0.196570, -0.002823, 0.518004, -0.010686, -0.005592, 2.034451, 2.106399, -0.002972, -3.184406, -0.322038, -0.814324, -0.049256, 
	-0.052469, 0.047516, -1.322538, 3.093452, -2.319613, -0.007580, 2.209486, -0.050109, -0.018539, -0.420829, 2.005760, -0.007671, 0.043241, -3.141239, 0.531949, -0.590818, 
	-0.005839, -0.006602, -0.319105, -1.583149, 5.255051, -0.001164, -1.742376, -0.003290, -0.002172, 0.712553, -1.600669, -0.001229, -1.405976, -0.254669, 0.983560, -0.024924, 
	-0.006331, -0.006178, -1.250141, 2.192398, 1.278273, -0.001865, -0.912328, -0.007037, -0.003928, 0.947889, 0.279191, -0.001875, -2.617102, -0.412923, 0.606653, -0.084696, 
	-0.021153, -0.016641, -1.961521, -0.706504, -1.818261, -0.003956, -0.593910, -0.011899, -0.008689, 1.035447, -1.583100, -0.004134, 1.018808, 4.711250, 0.090639, -0.126375, 
	-0.013463, -0.005391, 0.095517, 0.456435, -0.863931, -0.001905, -2.277100, -0.006344, -0.003776, 2.192924, 0.929500, -0.001997, -0.100075, -2.335063, 1.953648, -0.018979, 
	-0.011770, -0.006246, 1.701952, 1.596655, -2.753635, -0.002523, -0.823622, -0.006124, -0.004810, -2.041293, 4.759747, -0.002701, -1.548513, -0.202379, -0.578174, -0.076561, 
	-0.011425, -0.007957, -2.918527, 1.066429, -2.194034, -0.003161, -2.946531, -0.010751, -0.005982, 0.698807, 1.608776, -0.003259, 1.607135, -1.942454, 5.137351, -0.074416, 
	-0.012969, -0.006358, 4.209315, -0.607215, 1.720737, -0.003143, -2.299652, -0.007659, -0.004807, -1.385203, -0.154561, -0.003273, 0.897002, -0.856194, -1.446241, -0.039779, 
	-0.014899, -0.006791, -0.395726, -2.397123, 1.463136, -0.004050, 14.098227, -0.009860, -0.005763, -0.503559, -9.722082, -0.004131, -4.422276, -0.133255, 0.370207, 1.687945, 
	-0.017890, -0.007262, -0.249062, 0.200550, 0.570478, -0.001711, -1.540316, -0.017159, -0.004454, -1.877231, -3.257594, -0.001937, 1.775777, 2.953026, 1.524933, -0.050148, 
	-0.034314, -0.009912, 0.227800, -1.080557, 0.206202, -0.003311, -0.205186, -0.004764, -0.003986, 1.611584, -1.845918, -0.003342, -1.151917, 0.301915, 0.718490, 1.277218, 
	-0.010686, 2.276890, 0.990450, -0.205333, 1.996897, -0.005443, -2.458048, -2.101393, -0.006826, -0.993714, 2.713241, -0.005684, -3.352616, 0.749995, 0.532368, -0.120099, 
	-0.011171, -0.007705, 1.075234, -0.119778, 0.123475, -0.003238, 1.618572, -0.011511, -0.005894, -1.162173, -4.582816, -0.003496, 2.751255, 1.244237, -0.806708, -0.098284, 
	-0.031902, -0.025960, -1.424298, 1.455300, -2.543250, -0.001618, 8.296930, -0.033420, -0.003972, 1.139577, -4.126039, -0.001748, -3.581292, 2.243281, -1.291756, -0.069834, 
	-0.023186, -0.016272, -0.809151, 0.425074, -0.640325, -0.002962, -0.685048, -0.028195, -0.008803, 4.291116, -0.283051, -0.003077, -3.563114, 2.596246, -1.117960, -0.131291, 
	-0.020049, -0.013018, -2.323719, 2.650562, -1.404267, -0.003356, 4.849566, -0.016808, -0.007669, -1.411523, 0.515568, -0.008036, -5.358515, 1.495565, 1.166414, -0.110714, 
	-0.004474, -0.004079, -0.409551, -0.017644, -0.140313, -0.001058, 1.007113, -0.006829, -0.002769, -1.054119, 0.641122, -0.001228, -1.529961, 2.493365, -0.946818, -0.022758, 
	-0.007491, 0.092555, 0.410728, -0.553005, -0.910131, -0.001887, 1.346687, -0.104150, -0.004325, -0.421855, -2.501953, -0.002055, 3.179074, -0.614225, 0.200682, -0.108647, 
	-0.041812, -0.022219, 3.562284, -0.020298, -2.529387, -0.007542, -2.417106, -0.022306, -0.009633, 3.165650, 0.854509, -0.007732, -0.804763, -1.110875, -0.433769, -0.154999, 
	-0.018016, -0.010401, 1.194366, 2.033028, 0.909843, -0.002020, 0.128149, -0.013913, -0.005727, -3.545992, 0.743493, -0.002291, 1.519433, -1.959008, -0.866648, -0.104295, 
	-0.007936, 0.005430, -0.730851, -0.495801, 5.889009, -0.003270, -2.879853, -0.013024, -0.003700, 0.322736, -3.605078, -0.003316, 1.849703, -0.137062, -0.249325, 0.062337, 
	-0.113783, -0.039025, -1.356597, 2.943877, 3.156960, -0.006710, -1.472301, -0.083201, -0.022058, 3.332406, -3.199349, -0.007441, -2.400402, -0.821799, 0.373422, -0.283996, 
	-0.161495, -0.077041, 0.162579, -2.863355, 0.636132, -0.019455, -4.726902, -0.106954, -0.047693, 1.169278, 3.984025, -0.020670, 2.051808, 6.693888, -6.843668, 0.169523, 
	-0.008769, -0.004314, -1.959707, 1.481840, -0.921149, -0.001663, 0.272635, -0.004991, -0.003168, -0.228023, -3.493409, -0.001735, 5.916745, -0.511857, -0.428920, -0.103516, 
	2.151899, 0.159695, -0.943721, 2.691696, -3.573922, -0.025710, 1.246782, -0.214425, -0.050848, 0.981933, -9.494508, -0.026721, 5.034286, 1.208168, 1.567297, -0.711901, 
	-0.055777, 0.000830, -2.299534, -0.661956, -0.355423, -0.003941, 4.756345, -0.071625, -0.009720, -0.138644, -1.139923, -0.004369, -2.943728, 4.105678, -1.109001, -0.069211, 
	-0.022434, -0.007001, 1.820237, 2.598242, -2.149190, -0.003609, 3.557183, -0.097108, -0.008377, -1.539371, -1.933300, -0.003935, -1.146713, 0.089530, -1.060556, -0.093598, 
	-0.002125, -0.001469, -0.462038, -0.262737, 0.722490, -0.000494, 0.681314, -0.002271, -0.000974, -0.352320, 1.332452, -0.000520, -2.111705, -0.322679, 0.795441, -0.012365, 
	-0.002348, -0.001367, -0.185642, -0.081265, -0.290112, -0.000406, -3.674362, -0.001768, -0.000926, 0.128367, 5.846661, -0.000436, -1.839141, -0.429841, 0.563827, -0.031241, 
	-0.025582, -0.000850, -0.049236, -0.479324, 1.042035, -0.000343, -0.078943, -0.000869, -0.000614, -0.146916, 0.125663, -0.000355, -0.557561, -0.229110, 0.414597, -0.012592, 
	-0.409599, 0.075195, -0.935139, -1.188632, 2.722368, -0.035574, 5.616364, -0.234676, -0.036202, -0.573409, 5.818384, -0.040211, 0.777416, -5.188021, -5.430719, -0.937546, 
	-0.007220, -0.007984, 0.470602, -1.156879, -0.207908, -0.001842, 2.523817, -0.021763, -0.005495, 1.889450, -1.110117, -0.002119, -0.926449, -0.023778, -1.372084, -0.040230, 
	-0.001334, -0.000817, 0.913131, -0.189333, 0.228148, -0.000465, -0.291986, -0.000723, -0.000630, -0.588266, -2.072201, -0.000435, 1.891311, 0.276219, -0.145661, -0.016959, 
	-0.001383, -0.001008, -0.161331, 0.264481, -0.378718, -0.000486, -0.561640, -0.001166, -0.000810, 0.856426, 0.204869, -0.000490, -1.115559, 0.079472, 0.824736, -0.007392, 
	-0.123157, -0.093772, -2.324054, 7.243887, -0.674174, -0.029206, 1.877592, -0.097723, -0.060272, 2.752449, -1.210652, -0.030624, -2.409184, -4.216919, 0.254337, -0.858530, 
	-0.019945, -0.011457, -1.233449, -2.527129, -4.453020, -0.002850, 2.787406, -0.022464, -0.007580, 7.244468, -0.540944, -0.003027, 0.528014, -1.062394, -0.607900, -0.067729, 
	-0.002596, -0.002003, -0.822225, 0.686307, 0.163526, -0.000796, -0.851156, -0.002328, -0.001575, 0.343200, -2.443319, -0.000780, 3.377158, -0.003888, -0.425491, -0.014034, 
	-0.003041, -0.002530, -0.145175, -3.055256, 1.520027, -0.000935, 0.688302, -0.002880, -0.001859, 1.582891, 0.896343, -0.000972, -2.192757, -0.226185, 1.019614, -0.075586, 
	-0.022921, -0.007702, 1.536312, 0.854920, -0.555605, -0.001668, -0.539564, -0.008835, -0.004088, -1.949688, 1.859739, -0.001803, -0.179092, -0.272523, -0.655322, -0.052162, 
	-0.004026, -0.002494, -0.526533, -0.286017, -1.537095, -0.000807, 5.931040, -0.003095, -0.001964, -0.213445, -2.042572, -0.000886, -2.487957, 0.596436, 0.623559, -0.044143, 
	-0.017277, -0.008972, -5.057119, 1.741061, 3.913023, -0.002817, 0.503947, -0.011461, -0.006293, 3.601591, -1.736794, -0.003039, -0.399736, -1.936532, -0.532122, -0.047460, 
	2.298634, 0.015275, 0.276811, 0.501334, -0.404493, -0.001621, -2.592524, -0.035031, -0.004351, 0.577597, 1.491195, -0.001748, -1.498291, -0.336558, -0.254392, -0.031837, 
	-0.026327, -0.009628, -1.798461, 2.707092, 0.235214, -0.002979, -0.504865, -0.021826, 0.072348, -0.799634, 4.241510, -0.132552, -3.654186, -0.909327, 0.663924, -0.060303, 
	-0.024319, -0.014713, -0.760243, 2.166547, -1.697475, -0.005858, -2.915599, -0.034918, -0.012193, 4.362031, 6.582117, -0.010602, -3.444184, -1.061713, -2.717856, -0.411022, 
	-0.002291, -0.001528, 0.222352, 0.280570, -0.161861, -0.000128, 0.085787, -0.001767, -0.001156, -0.697807, 0.536719, -0.000813, -0.614647, 0.070070, 0.300156, -0.013657, 
	-0.010054, -0.001436, -0.670240, -0.348854, -3.420721, -0.000845, 1.914867, -0.022347, -0.003249, 2.608154, 1.043105, -0.000753, 0.499247, -1.380878, -0.033160, -0.172836, 
	-0.332498, -0.052391, -1.608717, -1.282559, -5.278187, -0.012727, -0.780043, -0.057446, -0.029185, 1.869030, 2.787819, -0.020607, 4.074619, -1.671726, 2.884249, -0.489631, 
	-0.025967, -0.014587, -0.505414, -0.399821, -0.374999, -0.003513, -0.693763, -0.020943, -0.008937, -0.145354, 2.448563, -0.003773, 3.522892, -2.723129, -0.767681, -0.283573, 
	-0.003843, -0.002485, -0.203528, -0.683078, 0.344206, -0.000849, -0.982820, -0.004223, -0.001684, 0.386166, 1.603694, -0.000874, -0.032207, -0.441770, 0.096761, -0.073466, 
	-0.281137, -0.067093, 6.802339, 0.237058, 4.774143, -0.026328, 5.573446, -0.181787, -0.055383, 1.300480, 2.308278, -0.036961, -17.215515, 4.011794, -6.138229, -1.005102, 
	-0.007262, -0.005096, -0.630058, -2.444503, 1.265417, -0.002648, -0.402264, -0.004909, -0.003910, 3.780170, -0.589243, -0.002667, -0.522270, 0.820119, -1.212779, -0.038097, 
	-0.067958, -0.023476, -1.008345, -5.615778, 11.615138, -0.009983, 2.300310, -0.032852, -0.017293, 2.731843, 1.818514, -0.010334, -9.208884, -2.481592, 0.298761, -0.288070, 
	-0.018656, -0.007077, -1.098279, 0.760569, -1.463196, -0.002370, -1.363169, -0.009499, -0.004677, 2.103060, 2.682741, -0.002430, -2.106514, -0.746403, 1.351987, -0.076085, 
	-0.000582, -0.000249, 0.030126, 0.123949, -0.000254, -0.000134, -0.022197, -0.000244, -0.000215, -0.043642, -0.009128, 0.000807, -0.189166, -0.118534, 0.230355, -0.000891, 
	-0.054090, -0.024991, -1.379238, 1.679916, 3.293583, -0.006442, -1.867634, -0.054460, -0.015037, 1.201758, -1.220520, -0.006927, -0.750308, -0.587485, -0.044618, -0.163504, 
	-0.013780, -0.005988, 0.437630, -1.902556, 0.918635, -0.001754, -1.990759, -0.007812, -0.004784, -0.165623, 3.670257, -0.001827, -0.581224, 0.245853, -0.349821, -0.246447, 
	-0.111816, -0.042613, 0.964339, -3.009692, -0.674736, -0.014310, -2.616965, -0.074319, -0.030122, -0.925913, -0.402318, -0.015481, 5.900499, 5.415125, -4.486446, 0.124769, 
	-0.011551, -0.005773, 1.942825, -1.564279, 1.660921, -0.001289, -1.952735, -0.005533, -0.004208, -0.595914, -1.991251, -0.001347, 0.575955, 0.990021, 0.992343, -0.028184, 
	-0.027057, -0.033832, 1.269239, -0.911584, -0.859368, -0.021800, -1.722622, -0.199442, 1.377507, -1.162045, 0.165413, -0.021968, 2.823086, -0.485373, -0.124531, -0.065623, 
	-0.004002, -0.006971, -0.268584, -1.398917, -0.114934, -0.000958, -2.223835, -0.015169, -0.003907, 2.453184, -0.632900, -0.001165, 2.894168, 0.120975, -0.766114, -0.030870, 
	-0.012225, -0.003955, 0.439471, -2.075005, -1.209113, -0.001096, -0.903754, -0.003834, -0.002376, 0.312602, 3.227101, -0.001168, 0.969404, 0.130839, -0.833687, -0.033204, 
	-0.346387, -0.108228, 1.450994, -5.061051, -3.223197, -0.038359, 2.351151, -0.133488, -0.074676, -1.893748, -4.501218, -0.044811, 3.071687, 2.637826, 7.232417, -1.318913, 
	-0.225046, -0.104359, 2.271889, -2.994951, -4.723476, -0.036016, 1.217756, -0.143632, -0.074101, -0.956002, 2.415146, -0.037082, -1.513861, 1.958707, 1.334546, 1.610482, 
	-0.024628, -0.009638, -2.261655, 0.005486, -1.005863, -0.002430, -0.026549, -0.013451, -0.006615, 0.760095, 7.117340, -0.002628, -4.346172, 1.211461, -1.302955, -0.091797, 
	-0.011755, -0.009709, 4.911371, -2.236187, -1.506512, -0.003125, 3.169892, -0.011865, -0.005827, -0.808444, -0.180797, -0.006079, -2.607527, -1.540794, 0.981610, -0.134253, 
	-0.004682, 1.050259, -0.389061, -0.806638, 0.199090, -0.002909, -0.330341, -0.816887, -0.014296, 2.726002, -0.529261, -0.002973, -0.331457, -0.354670, -0.364102, -0.028073, 
	-0.070658, -0.017119, -1.534585, -0.353608, -1.257829, -0.004879, -1.019375, -0.036209, -0.010894, 3.054293, -1.348763, -0.005000, 1.052084, 3.001612, -1.324078, -0.124992, 
	-0.013973, -5.825501, 1.610983, -1.531128, -1.504436, -0.006507, -0.414144, 6.168599, -0.018868, -1.314688, 1.149124, -0.006534, -0.889518, 0.535217, 2.279912, -0.218537, 
	-0.005490, -0.003665, -0.470680, 1.174770, -2.030023, -0.001332, 1.635541, -0.004696, -0.002433, 1.492416, -0.487123, -0.001356, -2.277766, 0.506228, 0.510418, -0.034810, 
	2.426321, -0.013041, -1.421222, 3.474532, -2.126033, -0.004162, 1.873569, -0.022096, -0.009626, -3.393885, -1.784226, -0.004431, 0.046961, 0.820887, 0.350781, -0.214329, 
	-0.012573, -0.002906, 1.565112, -0.521692, 0.878721, -0.000949, 1.092247, -0.026166, -0.002244, 0.296095, -0.548094, -0.001040, -2.061193, -0.066677, -0.572203, -0.016440, 
	-0.021743, 0.069172, 0.474938, 0.624608, -3.524068, -0.003281, -1.745885, -0.016388, -0.006780, -0.919399, 2.849571, -0.003358, 2.714677, -0.280408, -0.144772, -0.066883, 
	-0.003566, -0.002756, 0.667997, -0.659841, -0.063310, -0.000646, -1.067601, -0.007391, -0.002022, -0.431040, 0.545184, -0.000701, -0.248044, 2.270263, -0.930572, -0.065954, 
	-0.020318, -0.010419, -0.975247, -2.494892, -4.920457, -0.003149, -0.864041, -0.008676, -0.005832, -3.518240, 5.274006, -0.003266, 4.302258, 4.119325, -0.774931, -0.096120, 
	-0.018125, -0.001651, -0.942142, 0.664322, 1.478077, -0.000694, 0.381903, -0.002190, -0.001232, -0.331352, 2.009216, -0.000719, -2.839514, -0.123993, -0.250253, -0.021652, 
	-0.019138, -0.015860, 0.195973, 1.547559, 2.842230, -0.001797, -5.182374, -0.019071, -0.006832, -2.567417, 0.423776, -0.002315, 0.574114, 2.004246, 0.631432, -0.404526, 
	-0.008769, -0.006365, 0.531349, -1.654008, -1.398465, -0.001317, -2.024214, -0.007469, -0.003592, -0.226654, 2.166709, -0.001419, 3.576122, -0.559909, -0.336763, -0.045236, 
	-0.041506, 0.098501, 2.454726, -2.055042, 0.188388, -0.011422, -2.281344, -0.138646, -0.015769, -0.520235, -0.474523, -0.011620, 1.614106, -4.764477, 5.693391, 0.265471, 
	-0.006535, -0.006177, -1.325192, -1.886163, -0.782691, -0.001875, 3.185019, -0.006943, -0.004169, 1.658030, -1.764154, -0.002066, -0.327200, 0.837136, 0.869098, -0.436117, 
	-0.019892, -0.017064, 1.429358, -0.431196, -2.217530, -0.003700, -2.167991, -0.036145, -0.009510, 2.574533, 1.042249, -0.004059, -0.371337, -0.341134, 0.709199, -0.135781, 
	-0.002510, -0.001644, -0.619436, 0.382049, 0.133258, -0.000485, -1.480213, -0.001858, -0.001008, 0.923569, 3.428150, -0.000520, -2.909784, 0.234852, -0.075975, -0.008444, 
	-0.119970, -0.041555, -1.367609, -2.812179, 12.268924, -0.007919, 4.945920, -0.047999, -0.020787, -1.963480, -2.687396, -0.007825, -0.525066, -2.452202, -4.205642, -0.955215, 
	0.837002, -0.277175, -1.020161, -1.374223, 0.092769, -0.094956, -0.330174, -0.352954, -0.190811, -3.739117, 3.029749, -0.108713, 4.530726, -3.592911, 0.601166, 1.989783, 
	-0.005675, -0.005222, -0.135695, -2.349377, 2.228604, -0.001636, 2.156198, -0.008028, -0.003718, -0.465531, -3.527702, -0.002116, 2.734349, -0.469359, -0.117145, -0.027945, 
	-0.003824, -0.002223, -0.833277, 1.317822, 0.930393, -0.000884, 0.059034, -0.004115, -0.001681, -0.869057, -1.137617, -0.001161, 0.982203, -0.285142, -0.126289, -0.024182, 
	-0.006400, -0.004771, -1.817465, -1.527271, 0.129044, -0.001477, -0.344506, -0.006122, -0.003130, 2.783911, -0.637612, -0.001563, 1.309104, 0.127703, 0.112333, -0.111777, 
	-0.046029, -0.012498, -0.825337, 1.255997, -0.062731, -0.003308, 3.739948, -0.012605, -0.007220, -0.415073, 1.270688, -0.003758, -2.524661, -1.365855, -0.685473, -0.302086, 
	-0.025548, -0.011377, -0.765039, 0.246664, 2.718692, -0.003607, -0.439764, -0.140375, -0.009294, -2.665326, -2.181044, -0.003892, 0.384708, 3.412371, -0.322831, -0.194339, 
	-0.027537, -0.010370, 0.709479, -1.408114, -0.899656, -0.002659, -1.858117, -0.013567, -0.006720, 2.127897, -3.285141, -0.002870, 1.240286, 2.842354, 0.642639, -0.047905, 
	-0.010740, -0.003790, -0.610572, -0.511084, -0.887098, -0.001215, 3.460126, -0.005473, -0.002513, -0.840692, -1.672192, -0.001312, 1.756486, -0.049249, -0.604126, -0.016555, 
	-0.927070, 0.152562, 3.718611, -0.593253, 1.900900, -0.070181, -2.179574, -0.953339, -0.225793, -1.095432, -2.237416, -0.205302, 1.251971, -1.994761, 3.361553, 0.096524, 
	-0.035930, -0.007601, 0.967738, 2.149588, -0.048459, -0.002450, 1.878580, -0.021754, -0.005462, -1.423985, 2.196645, -0.002427, -3.628444, -2.034204, 0.095621, -0.077453, 
	-0.016135, -0.005094, -1.874613, -0.827709, -1.098534, -0.001282, 1.383265, -0.005477, -0.002987, 1.670668, 1.167064, -0.001388, -3.321166, -0.340319, 3.333708, -0.060002, 
	-0.006624, -0.002586, 2.292854, -0.049774, -0.297097, -0.000790, 0.366912, -0.002896, -0.001627, 0.505401, -1.932849, -0.000803, -0.728028, -0.028085, -0.088600, -0.025409, 
	-0.016227, -0.010611, -1.122426, 1.592485, 2.070935, -0.002724, 2.984215, -0.011931, -0.005902, -1.341735, -1.025651, -0.002803, -2.752912, 0.316800, -0.626197, -0.045315, 
	-0.002979, -0.002458, 0.269124, -1.752659, 0.946031, -0.000868, -0.268696, -0.003198, -0.001645, 0.570900, -2.736028, -0.000903, 1.512197, -0.402646, 1.900166, -0.026339, 
	-0.268642, -0.121219, 3.167044, -0.841988, 3.275400, -0.035723, -6.473006, -0.170610, -0.073741, 2.517485, -12.250710, -0.037804, 5.269008, 4.294977, 1.789487, -0.039957, 
	2.374001, -0.052370, -3.378376, -2.183726, 4.216422, -0.010917, 4.568233, -0.046825, -0.029519, -1.468590, 4.162403, 0.012133, -7.482897, 0.234352, 0.077341, -0.991665, 
	-0.040318, -0.004809, 0.478490, 0.189949, 3.649780, -0.002016, -1.529690, -0.006262, -0.003408, -2.510931, 3.432195, -0.002058, -3.475766, -1.019828, 0.963478, -0.118805, 
	-0.008148, -0.003971, -3.160806, 1.159560, 2.623342, -0.001027, -1.357386, -0.004077, -0.002601, 1.064548, 0.261955, -0.001094, -1.434841, 1.857402, -0.960799, -0.032057, 
	-0.028780, -0.010706, 0.663073, -0.139961, 6.471054, -0.003562, -0.597309, -0.016379, -0.007852, -2.548632, -2.193527, -0.003893, 1.180257, -2.576009, 0.262920, -0.450695, 
	-0.014514, -0.006635, 1.243769, 1.693466, 0.745464, -0.001276, -1.856906, -0.060943, -0.004760, -1.625424, 1.535502, -0.001445, -1.384422, 0.628045, -0.779933, -0.109990, 
	-0.765108, -0.178448, 2.530686, -3.542408, -0.693158, -0.066096, -2.733617, -0.329562, 0.826043, 2.967865, -2.605789, -0.071098, 2.282340, 1.249397, 3.254739, -2.125785, 
	-0.038067, -0.012290, 1.578539, -1.077626, 3.003815, -0.003035, 0.648211, -0.050082, -0.008712, 0.676303, -1.272652, -0.083907, 0.727577, -3.893219, -0.042904, -0.151953, 
	-0.532470, -0.056520, -7.507627, -6.564459, 8.952121, -0.016538, -4.987131, -0.063561, -0.039292, 0.755291, -3.574799, -0.017421, 6.021034, 7.786487, 0.603341, -0.758456, 
	-0.022378, -0.011084, -1.095216, -3.862711, 3.642080, -0.004271, -1.945134, -0.013614, -0.005870, 3.028328, -3.080897, -0.004480, 0.170662, 1.317724, 0.199923, 1.686937, 
	-0.265527, 0.807716, -2.023136, 1.076318, -4.522540, -0.031213, 3.089703, -0.298846, -0.071213, 3.153790, -1.544673, -0.037658, -3.012312, -0.998222, 2.539161, 2.138651, 
	-0.048784, -0.038785, 3.278072, -0.993674, -2.611375, -0.010692, 4.902879, -0.049221, -0.025337, -1.714387, 3.737592, -0.015843, -6.345500, -3.459813, 4.278099, -0.883230, 
	-0.004419, -0.003440, -0.741653, 0.450280, -0.596404, -0.000804, -1.119461, -0.012783, -0.002635, 0.407727, 2.149439, -0.001061, -1.967809, 0.527470, 0.925785, -0.010232, 
	-0.005863, -0.003149, 0.140867, 0.597667, -0.399712, -0.000633, 1.211171, -0.004578, -0.001886, 2.654130, -0.493636, -0.000707, -1.680053, -1.160201, -0.843360, -0.010057, 
	-0.021853, -0.008556, 4.483108, -1.944713, -4.401241, -0.003532, 2.374712, -0.070026, -0.007047, -3.781595, -1.995135, -0.003470, 5.781643, -0.823346, 0.478473, -0.057422, 
	-0.019407, -0.016022, 1.528510, 0.534143, -3.127073, -0.003502, -1.768506, -0.014355, -0.007924, 0.514458, 0.199161, -0.003930, 0.685263, 1.125799, 0.490098, -0.116713, 
	-0.004683, -0.004401, -0.683755, 3.980597, 1.375489, -0.001560, -3.177763, -0.006960, -0.003328, -0.089655, 1.491064, -0.001615, -1.329774, -1.480538, 0.060857, -0.123975, 
	-0.151666, -0.042748, -0.598522, -2.261967, -1.848703, -0.010079, -1.586058, -0.065976, -0.022740, 1.623752, 3.701712, -0.010645, 5.422624, -1.312556, -2.348914, -0.487515, 
	-0.081686, -0.034168, 1.966919, -3.227174, 4.803779, -0.009125, -4.777985, -0.057262, -0.024437, 0.266862, -0.523378, -0.009990, 2.446084, -1.137987, 0.889520, -0.489972, 
	-0.010231, -0.436762, 0.073546, 0.490963, -1.093468, -0.007170, 2.367055, 0.886526, -0.013316, -0.635161, -1.282511, -0.007155, -1.147826, -0.101178, 0.939207, -0.022517, 
	-0.000631, -0.000846, 0.258408, -0.769128, 0.017322, -0.000199, 1.486252, -0.002382, -0.000513, -0.426591, -0.375085, -0.000093, -0.532440, -0.050830, 0.410869, -0.014114, 
	-0.024411, -0.018571, 5.090699, -1.286118, -3.699266, -0.007872, 1.201653, -0.021197, -0.013141, -0.530374, -2.670624, -0.008115, -3.471838, 2.560358, 3.227710, -0.328893, 
	-0.000149, -0.000162, 0.027506, 0.998980, -0.044234, -0.000066, -0.011677, -0.000113, -0.000097, -0.790139, -0.015567, -0.000068, -0.020581, -0.140828, -0.002462, -0.000343, 
	-0.024497, -0.009907, 1.402895, 0.918191, 4.707643, -0.002447, -4.488490, -0.019172, -0.005765, -0.416947, 2.157058, -0.002665, -4.976470, 0.440011, 0.471976, -0.151413, 
	-0.288691, 0.811884, -0.488941, -1.356010, -3.303346, -0.252747, -2.288100, 2.182240, 16.612249, -2.730792, -5.402121, -0.256153, 0.021677, -1.647026, -1.280685, -0.333440, 
	-0.004149, -0.002947, 0.211704, 0.973639, 2.646979, -0.001005, -1.059878, -0.002742, -0.001831, -1.787686, -1.137054, -0.001033, -0.445196, -0.387922, 1.026185, -0.027065, 
	-0.003353, -0.004372, -0.496879, -0.879425, 3.551390, -0.000859, -1.439550, -0.003798, -0.002130, -0.609157, 2.781336, -0.000927, -5.161517, 1.023345, 1.276618, -0.030722, 
	-0.009354, -0.003859, 1.976172, 1.646497, -1.231835, -0.001323, -2.139497, -0.022675, -0.002808, -0.196306, 3.418058, -0.001583, -2.493693, -0.791233, -0.063829, -0.082731, 
	-0.000489, -0.000580, 0.271726, -0.370507, 0.954925, -0.000132, 0.074190, -0.000455, -0.000536, 0.572368, -0.178409, -0.000145, -0.920662, -0.353110, -0.045801, -0.002384, 
	-0.013305, -0.014878, 5.652114, -0.700794, -0.860748, -0.003443, -0.939233, -0.012849, -0.007573, -3.954917, 4.716617, -0.003642, -2.714371, 1.875263, -2.784274, -0.233967, 
	-0.006589, -0.003106, 0.878326, 0.196903, -0.380973, -0.000847, 0.153306, -0.015538, -0.001584, -0.827230, 1.232856, -0.000881, -1.217725, -0.173844, 0.210507, -0.043580, 
	-0.012969, -0.007717, -0.382838, -0.619793, 2.756569, -0.003833, 1.667188, -0.033406, 0.225259, -0.268243, -5.018897, -0.003876, 2.785814, -0.231235, -0.836261, -0.015763, 
	-0.063833, -0.016261, -2.701490, -0.097577, 1.465192, -0.004670, -2.520935, -0.052384, -0.012600, -1.289230, -0.796610, -0.005202, 2.638663, 3.784025, -0.040867, -0.286221, 
	-0.045561, -0.009403, -0.582033, 2.763215, -0.663363, -0.003451, -2.565314, -0.009906, -0.005943, 2.055208, 0.328745, -0.003805, -1.040087, 0.822745, -1.954553, 0.913506, 
	-0.007718, -0.004895, -0.210995, 0.247359, -0.705457, -0.002117, -0.730865, -0.005619, -0.004297, -0.933807, -3.476140, -0.002838, 3.134244, -0.531995, 3.299898, -0.064758, 
	-0.016828, -0.005345, -0.042725, 1.392140, -0.045615, -0.001532, -1.352756, -0.005761, -0.003743, -2.077624, 1.089976, -0.001635, -0.992470, 2.106287, -0.017544, -0.024826, 
	-0.001106, -0.001106, -0.060693, 0.549653, 0.451776, -0.000572, 0.802473, -0.001169, -0.000869, -0.091910, -0.543012, -0.000808, -0.786730, -0.117786, -0.192765, -0.005375, 
	-0.006161, -0.004514, -2.488729, 0.653733, -1.807287, 0.192322, 1.354736, -0.005102, -0.002607, -0.887244, 4.002923, -0.002499, -2.884696, 0.027043, 1.903882, -0.045804, 
	-0.000517, -0.000546, 0.024742, 0.444027, 0.115200, -0.000161, 0.660414, -0.000565, -0.000321, -0.056403, -1.010408, -0.000168, 0.324418, -0.027733, -0.468364, -0.003614, 
	-0.019975, -0.013736, -1.169540, 0.809544, -0.196771, -0.004133, -2.188278, -0.017292, -0.008477, -0.515790, 0.668311, -0.004360, 2.233454, 1.535557, -0.992587, -0.115927, 
	-0.046697, -0.020628, 7.174120, -2.788592, 5.156527, -0.004183, -1.521678, -0.026248, -0.012506, -3.337640, 0.451572, -0.004858, -0.375001, -1.719835, -2.791574, -0.132779, 
	-0.002666, 0.013673, -0.870988, -0.015948, -0.620162, -0.000468, 3.154062, -0.010878, -0.001309, -0.871982, -6.277381, -0.000576, 2.991735, 2.493325, 0.032250, -0.012687, 
	-0.025287, -0.015502, -1.812299, 1.648511, -3.487793, -0.004188, 2.219842, -0.024270, -0.009624, -2.327963, -0.767906, -0.004336, 3.376321, -0.857421, 2.294358, -0.202444, 
	-0.013444, 0.175961, 2.276285, 1.014692, -0.592647, -0.004036, -0.006339, -0.078619, -0.008629, -5.749834, 3.198491, -0.004190, -1.629869, 2.139143, -0.380396, -0.336571, 
	-0.003484, -0.002881, -0.034734, 3.099194, -0.235611, -0.000443, 1.235689, -0.004022, -0.001430, -0.612852, -3.529736, -0.000535, 0.367717, -0.401924, 0.128947, -0.003895, 
	-0.015722, -0.006783, 1.584355, -2.122139, 0.526652, -0.001461, 1.990258, -0.008324, -0.003997, 0.350625, -1.162562, -0.001640, -0.750470, 1.513216, -1.350276, -0.541733, 
	-0.003226, -0.005195, 0.635996, -1.696383, 0.882137, -0.000902, 2.176419, -0.003939, -0.002313, 0.072943, -0.213175, -0.000982, -1.243936, 0.028015, -0.588203, -0.037255, 
	-0.346495, 0.113558, -2.751529, 4.868925, -3.227290, -0.062317, 3.885215, -0.330199, -0.097329, -2.831045, 3.515119, -0.201215, 4.426967, -1.450148, -5.635375, 0.123160, 
	-0.065865, -0.028174, 2.956337, 3.168074, -3.832763, -0.013082, -0.784754, -0.037071, -0.021017, 6.060881, -0.963480, -0.143126, -1.871634, -1.223651, -2.991460, -0.209216, 
	-0.044748, -0.010172, -2.532728, -0.689055, -0.989856, -0.006089, -6.419436, -0.013217, -0.008422, -1.964163, 18.787018, -0.019376, -6.941720, 2.265286, -1.293931, -0.119391, 
	-0.014773, -0.006499, -0.669751, -1.107362, -0.652411, -0.001152, -0.022947, -0.010739, -0.003299, 1.296363, 1.194970, -0.001277, -3.115075, -1.129571, 1.913815, 2.329707, 
	-0.010121, -0.013403, -0.504030, 3.673084, -0.937504, -0.004602, 0.303366, -0.009674, -0.007011, -1.444646, -1.566553, -0.004795, -1.644485, -0.045544, 2.307830, -0.091913, 
	-0.006502, -0.006108, 0.607745, -1.209058, 1.367937, -0.001567, 0.145311, -0.007356, -0.004037, 2.753331, -2.062198, -0.002108, -0.015436, -1.257006, -0.250438, -0.052512, 
	-0.018939, -0.012855, -0.360652, -0.270294, -1.983998, -0.002542, -3.861798, -0.014988, -0.006257, 2.519657, -1.409875, -0.002712, 6.850935, 0.523827, -1.809500, -0.140009, 
	-0.020097, -0.011947, 1.462688, 1.955780, -0.379987, -0.003751, 0.386334, -0.021017, -0.008014, -0.059476, -1.099610, -0.003939, -0.727246, -2.090734, 0.754548, -0.133533, 
	-0.004465, -0.002558, 0.124759, 0.243682, 0.164708, -0.000412, -1.460075, -0.001236, -0.000802, -0.485882, -0.948864, -0.000432, 2.192409, 0.212464, -0.022035, -0.011261, 
	-0.018213, -0.005602, -0.204932, -0.432851, -0.116089, -0.001981, 0.157896, -0.004129, -0.003225, -0.186317, 0.399993, -0.002049, -0.117190, -0.231111, 0.846570, -0.080770, 
	-0.000618, -0.000306, -0.565878, 0.663473, -0.056360, -0.000162, -0.047871, -0.001157, -0.000220, -0.161002, -0.247738, -0.000167, -0.037300, 0.004898, 0.462756, -0.012349, 
	-0.076984, -0.021887, 0.141687, 0.549514, 3.596814, -0.004034, -2.992564, -0.026408, -0.010054, -2.416755, -6.381308, -0.004562, 7.547961, -1.726805, 1.972078, -0.146694, 
	-0.014266, -0.009048, 0.161588, -0.569038, -1.159282, -0.003652, -1.935408, -0.057356, -0.006890, -0.179865, -0.445188, -0.003608, -1.507635, 4.156501, 1.641483, -0.068336, 
	-0.004885, -0.009794, -1.702634, 1.266120, 0.058617, -0.000685, -1.983447, -0.004103, -0.002359, 2.822354, -2.237250, -0.000808, 2.587868, -0.944304, 0.230606, -0.075296, 
	-0.006150, -0.001683, -0.246789, 0.463598, 0.156265, -0.000778, 0.094699, -0.003754, -0.001267, -0.310875, 4.228685, -0.000801, -4.048118, -0.158261, -0.130776, -0.033997, 
	-0.025670, -0.006369, 0.124740, 1.936621, 0.805474, -0.002130, 0.406183, -0.016386, -0.004784, 0.240968, -1.839071, -0.002210, -0.780035, 0.544713, -1.247996, -0.134049, 
	-0.996918, -0.077535, 2.135315, 2.008677, -3.045568, -0.093656, 1.535159, -0.472820, -0.225139, 0.884900, 2.627422, -0.098110, -5.310096, 5.733723, -2.692961, -1.912393, 
	-0.014828, -0.006872, -2.371659, 0.239584, -0.482166, -0.002182, -3.315776, -0.008073, -0.004750, 1.280273, 2.049989, -0.002097, -1.149415, -0.736391, 4.551070, -0.026709, 
	-0.148570, -0.006030, 0.312019, 2.178962, -3.473822, -0.004682, -2.554724, -0.029502, -0.009602, -1.326653, 8.706681, -0.009194, -1.589509, -2.408860, 0.524114, -0.160628, 
	-0.003765, -0.001976, -0.044589, 0.547027, -0.864088, -0.000763, -0.917216, -0.004875, -0.001593, -0.329315, 3.461370, -0.000811, -2.035838, 0.880484, -0.626144, -0.057910, 
	-0.007600, -0.014947, 1.713875, -0.626697, -0.166393, -0.002022, -1.377391, -0.015107, -0.005666, 1.213867, 1.406336, -0.002251, 0.785803, -0.923953, -1.926163, -0.051693, 
	-0.021095, -0.010780, -2.877752, 0.593928, 3.782906, -0.002498, -2.227351, -0.015490, -0.005881, -0.352752, 2.755058, -0.002702, -0.775736, -1.426113, 0.785134, -0.198876, 
	-0.020473, -0.003698, -0.188441, -0.581014, -1.786768, -0.000955, -3.157887, -0.011437, -0.003086, 2.180442, 0.097873, -0.001045, 4.090712, -0.685483, 0.091720, -0.020460, 
	-0.009875, -0.006432, -0.168865, 0.057149, -1.820660, -0.002253, 1.745610, -0.006623, -0.004154, 0.978661, -0.860089, -0.002329, 0.297537, -0.760144, 0.612746, -0.050281, 
	-0.137053, -0.045819, 2.879566, -1.821540, -1.622317, -0.019449, -0.103734, -0.080035, -0.035597, -3.236196, -3.492094, -0.020205, 2.746279, 7.191441, -1.468888, -0.734358, 
	-0.048009, -0.005156, 1.115068, -0.249021, 0.185928, -0.000955, -1.833243, -0.003751, -0.002300, -0.884929, -0.116825, -0.001010, 2.410675, -0.651509, 0.110305, -0.025269, 
	-0.062984, 0.008097, -0.448889, 2.420660, -0.336335, -0.001250, -0.658107, -0.017860, -0.003643, -0.556267, 2.566386, -0.001385, -1.553493, -0.586896, -0.442753, -0.325280, 
	-0.034173, -0.012424, 3.895293, 0.101339, -1.517615, -0.003436, -1.506422, -0.034959, -0.009096, -0.648644, -0.359575, -0.003714, -2.291959, 4.060813, -1.500534, -0.134896, 
	-0.029445, -0.016088, 7.005207, -3.285129, -2.249038, -0.002906, -2.195771, -0.009964, -0.006710, 0.999763, 2.094914, -0.003052, -3.922113, -2.104707, 3.808892, -0.083852, 
	-0.004649, -0.007055, 1.112340, -0.595129, 0.815443, -0.001005, -1.695456, -0.009151, -0.004748, 2.077861, -0.643910, -0.001123, -1.684331, 0.301426, 0.391976, -0.052488, 
	-0.160412, -0.046007, 3.300157, 1.649759, -1.768319, -0.013228, 3.981002, -0.440628, -0.040253, -2.896612, -0.320432, -0.273057, 1.182588, -4.169187, 1.701284, -1.686654, 
	-0.007472, -0.006154, 3.015884, 1.761953, 2.914341, -0.002097, -0.959395, -0.007068, -0.004217, -1.236786, 0.519576, -0.002199, -5.102412, 0.600513, -1.354330, -0.130136, 
	-0.019405, -0.025618, -0.738394, 2.442170, -0.229736, -0.009483, -2.060863, -0.024976, -0.016110, 3.207953, -2.277263, -0.009654, 0.901615, 0.990794, -2.007370, -0.123659, 
	-0.006277, -0.001298, 1.709334, 0.694961, -1.360735, -0.000479, -0.544506, -0.001668, -0.000956, -0.980943, -1.025259, -0.000495, 2.139672, -0.200164, -0.412401, -0.008786, 
	-0.007827, -0.005712, -0.826725, 1.493270, -1.028308, -0.001805, 1.334471, -0.005572, -0.003318, 2.593559, -3.565596, -0.131293, -0.393294, -0.096634, 0.719646, -0.074861, 
	-0.005349, -0.004254, -1.446527, -1.258871, -2.034647, -0.001276, 2.055626, -0.044048, -0.003384, 1.533780, -1.619828, -0.001385, -0.274264, 2.211306, 0.935627, -0.042505, 
	-0.023425, -0.010354, -1.245762, 1.921405, 3.990301, 0.190976, -3.369219, -0.012634, -0.005814, 0.416245, 2.618904, -0.004139, -3.255914, 0.114223, -1.207570, -0.117223, 
	-0.008653, -0.004536, 1.744261, -1.511853, 3.447323, -0.001919, -0.493854, -0.008691, -0.003289, -0.900874, 0.528928, -0.006411, -1.699213, -1.630793, 0.650518, -0.100944, 
	-0.017388, -0.006030, 1.167343, 0.919640, -0.397794, -0.001030, -1.434079, -0.008404, -0.002706, -1.635668, 0.477759, -0.001132, 0.711166, -1.325315, 0.828791, 0.724849, 
	-0.010955, -0.005474, -1.371137, -1.058084, -0.721136, -0.001399, 0.977303, -0.007590, -0.003317, 3.328312, 1.879112, -0.000969, -1.406896, -0.629599, -1.110804, 0.142633, 
	-0.003749, -0.003633, 0.646930, 0.365166, -0.710845, -0.000889, 0.326198, -0.004594, -0.002686, -1.491758, -1.081781, -0.000944, 0.640196, 3.300632, -1.937370, -0.040874, 
	-0.455055, 0.477556, -1.907352, -1.759995, 2.045993, 0.152239, 2.684826, -0.601817, -0.110792, -2.388745, 1.977933, -0.044825, 1.027445, 0.809310, -0.067411, -1.839311, 
	-0.003453, -0.002845, 0.958027, -0.938446, -0.748280, -0.000800, 1.815377, -0.004422, -0.002016, -0.386543, -1.356725, -0.000753, -0.880470, 0.503363, 1.068705, -0.020721, 
	-0.005533, -0.010376, 1.514216, -0.221414, -0.119249, -0.000910, 1.904629, -0.025244, -0.002305, -0.490436, -5.384087, -0.000985, 3.584153, -0.686223, -0.004138, -0.052098, 
	-0.008716, -0.002451, -2.493718, 0.800378, -0.593679, -0.001011, -0.169821, -0.006670, -0.001981, 0.873218, 1.132063, -0.001071, -2.014621, 0.498817, 2.011281, -0.022017, 
	-0.003174, 0.035138, 0.374456, -0.567932, -1.121263, -0.001230, 1.336299, -0.019740, -0.001986, -0.620720, -0.588729, -0.130698, 0.317632, 0.754264, 0.273965, -0.036284, 
	-0.000645, -0.000452, -0.018618, -0.591198, -0.228884, -0.000280, 1.894648, -0.000647, -0.000413, -0.033469, -0.736181, -0.000289, -0.214676, -0.016064, -0.051322, -0.001509, 
	-0.007802, -0.006713, 4.099961, -1.166290, -1.314100, -0.001440, -0.189933, -0.014853, -0.003449, -1.387860, -1.991577, -0.001550, 3.264028, -2.217528, 1.063694, -0.124590, 
	-0.035719, -0.005861, -0.237920, -2.608267, -1.155822, -0.000963, 3.017587, -0.008912, -0.003572, -1.073508, -2.046676, -0.001103, 2.136894, 2.980215, -0.939459, -0.016913, 
	-0.061462, -0.034937, 0.580994, -3.315161, 4.543179, -0.010237, -4.314379, -0.056478, -0.021464, -1.811508, 6.766779, -0.010847, -1.289409, 0.228798, -0.937103, -0.256767, 
	-0.022558, -0.005424, -0.088402, -2.660804, -2.543638, -0.001211, -1.711082, -0.005362, -0.002873, 1.950372, 2.711940, -0.001299, 3.351486, -0.287154, -0.604035, -0.079957, 
	-0.005442, -0.003041, -0.414972, -0.098521, 1.188843, -0.000973, -0.952594, -0.011585, -0.002439, -0.370928, 2.847400, -0.001046, -3.784926, 2.061180, -0.432837, -0.018119, 
	-0.018946, -0.012491, -1.947197, 3.377192, -1.701356, -0.005548, 5.872510, -0.016486, -0.009634, 0.131365, 2.182301, -0.010144, -4.907852, -1.358388, -1.408994, -0.166333, 
	-0.010682, -0.008065, -0.155750, 2.014458, -0.594871, -0.003644, 6.743941, -0.010088, -0.006097, -1.300702, -3.682824, -0.004036, -6.756354, 4.275478, -0.408395, -0.092368, 
	-0.007368, 0.001263, 0.085226, -0.507646, -1.074406, -0.000838, 0.468882, -0.007052, -0.002035, 1.601807, 5.346604, -0.000914, -5.277191, 1.434887, -1.767977, -0.293243, 
	-0.007802, -0.001928, -1.070032, -0.310200, 0.882347, -0.000906, -0.734338, -0.012532, -0.001775, 1.424866, 0.565480, -0.000849, -1.198816, 1.135698, -0.632543, -0.036668, 
	-0.002509, 1.748164, 1.560759, 0.115823, -0.739352, -0.001378, -0.193991, -1.655088, -0.032677, -0.753732, -0.128902, -0.001397, -0.147918, 0.332144, -0.085356, -0.014589, 
	-0.007127, -0.003236, 0.211174, -0.149752, -2.318408, -0.001447, 2.229213, -0.004165, -0.002553, 0.043566, 3.550422, -0.001496, -1.916831, -0.557264, -0.924920, -0.147176, 
	-0.040034, -0.011697, -0.703381, -0.396865, -2.938329, -0.003484, 3.241742, -0.012852, -0.007032, -0.075835, 2.793588, 0.020752, -4.241810, 2.078718, 0.422144, -0.125625, 
	-0.011684, -0.007209, 0.229166, 0.379667, -1.982961, -0.000951, 1.027498, -0.004561, -0.002966, -1.034724, 5.696263, -0.001072, -4.186667, 0.645904, -0.422455, -0.323247, 
	2.511127, -0.181076, 3.759760, -6.153008, 2.919684, -0.058773, 0.925192, -0.192551, -0.110956, -7.740287, 4.920120, -0.062025, 2.315095, -0.413815, -1.453999, -0.984487, 
	-0.007329, 0.898336, 0.018903, 1.825653, 0.083833, -0.001328, -0.829083, -0.878100, -0.002590, -0.060069, -4.317245, -0.001380, 2.824265, 0.488703, -0.015286, -0.027284, 
	-0.015994, -0.005775, -1.054004, -1.403610, -0.878034, -0.001681, 1.550583, -0.014152, -0.003735, -0.122780, -0.766806, -0.001695, 0.357760, 3.507639, -1.112553, -0.035164, 
	-0.000300, -0.000241, 0.078092, 0.038190, 0.009244, -0.000179, -0.133128, -0.000457, -0.000218, 0.042534, 0.243325, -0.000181, -0.150405, -0.153562, 0.028744, -0.001458, 
	-0.004499, -0.005369, 0.690484, -0.316338, 2.519168, -0.001477, -0.382972, -0.003006, -0.002303, 0.216744, 1.606250, -0.001531, -3.678106, -0.026309, -0.526817, -0.083917, 
	-0.008855, -0.004165, 0.044134, -0.012515, 0.250333, -0.001519, 1.502275, -0.006053, -0.003184, -0.034134, 1.320854, -0.001553, -3.258774, -1.502254, 1.811610, -0.096198, 
	-0.020083, -0.004072, -0.058721, 0.735986, 2.311990, -0.000964, -1.832127, -0.002200, -0.001787, -0.221357, -0.028128, -0.000977, -0.603110, -0.550862, 0.290199, -0.013786, 
	-0.003697, -0.003364, 0.179179, 1.004781, -0.727849, -0.001171, -0.555123, -0.002737, -0.001627, -0.356490, -2.226689, -0.001169, 3.774984, -0.061859, -0.976153, -0.041015, 
	3.070581, 0.014678, 2.234794, 1.600989, -1.591308, -0.049107, 3.674475, -0.417151, -0.117164, -5.636539, 0.846002, -0.057626, -0.768672, -3.110673, 2.147956, -1.841236, 
	-0.004613, -0.003556, 2.389860, -1.380005, 1.909898, -0.001331, 1.738402, -0.005617, -0.002527, -0.921171, -1.272460, -0.001400, -1.366158, 0.333251, -1.380908, -0.031664, 
	-0.731694, -0.393576, 0.446192, -0.586682, 2.742996, -0.054710, 2.535259, -0.476462, -0.178359, -1.341801, -2.687500, -0.059390, 4.180037, -3.200909, 1.224289, -1.417690, 
	-0.009738, -0.003530, -0.911236, 1.382979, 0.518194, -0.001424, -0.926634, -0.003959, -0.002436, -0.743674, -2.091104, -0.001438, -0.552756, -0.808657, 4.169097, -0.013683, 
	-0.014499, -0.006303, 0.036667, 1.432176, -2.192913, -0.001565, 2.821897, -0.035956, -0.004636, -0.800014, 3.052538, -0.001781, -2.237735, -1.398409, -0.591290, -0.058178, 
	-0.008312, -0.007550, -1.640083, -2.132905, -0.662945, -0.003975, -1.162514, -0.008977, -0.005773, 6.707450, 0.815772, -0.004028, -0.931806, 0.111797, -0.986686, -0.079466, 
	-0.002290, 0.000913, -0.511475, 1.282186, -0.405513, -0.000574, 1.633867, -0.003547, -0.000925, 0.055378, -1.188604, -0.000579, -0.553069, -0.287196, 0.013952, -0.032524, 
	-0.013934, -0.014269, -3.040010, -5.343320, 0.537856, -0.003579, 1.630672, -0.021473, -0.011015, 5.367429, -0.825831, -0.003846, -2.184716, 1.283365, 2.865839, -0.223170, 
	-0.001771, -0.000513, -0.332627, -0.008396, -0.236257, -0.000264, 0.427109, -0.000644, -0.000386, 0.127941, 0.179245, -0.000266, -0.332338, 0.354942, -0.174236, -0.001537, 
	-0.002581, -0.001268, -0.018310, 0.397571, -0.970488, -0.000695, 0.589821, -0.001155, -0.000981, 1.560009, -1.042042, -0.005021, -0.900136, -0.100991, 0.349214, 0.147052, 
	-0.001868, -0.002677, -1.808197, -1.789987, 0.902344, -0.000706, 0.626316, -0.002864, -0.001985, -0.415864, 3.182119, -0.000603, 0.533131, -0.131346, -1.034670, -0.053144, 
	-0.005806, -0.001750, 0.349575, 0.527577, -1.064210, -0.000711, -0.267048, -0.002015, -0.001243, 0.385693, 2.391182, -0.000739, -1.463177, -0.460224, -0.370629, -0.016477, 
	-0.114550, 0.177845, -2.878200, 7.816444, -1.163494, -0.014540, 0.686449, -0.160515, -0.037317, -2.363269, -1.461477, -0.000624, 2.710918, -1.747913, -2.080976, 0.631220, 
	-0.004699, -0.006832, 2.790919, 0.501327, -4.309592, -0.001702, -0.965816, -0.005634, -0.003249, 2.313065, 1.441603, -0.001885, -1.151767, -1.078820, 0.649129, -0.166048, 
	-0.009530, -0.009119, -0.855137, -0.467104, -2.233376, -0.003389, 3.349332, -0.011814, -0.005719, 3.261791, -1.853802, -0.007872, -3.204473, -1.687333, 3.746829, -0.009285, 
	-0.061334, -0.001182, 0.289443, -1.868003, -2.697759, -0.011444, -2.478081, -0.074439, -0.023592, 0.496226, 2.251408, -0.011840, 1.912460, 3.484808, -0.940277, -0.266395, 
	-0.015478, -0.008952, -1.511325, 0.687824, -1.869176, -0.002159, -0.543681, -0.013883, -0.005481, 3.247926, -2.070315, -0.002439, 4.494527, -2.135773, 0.148755, -0.400370, 
	-0.168154, -0.074517, -1.140705, -2.642422, -1.146686, -0.025445, 2.709614, -0.147697, -0.054511, 0.361429, 0.216301, -0.036048, 6.487651, -2.507375, -1.466750, -0.364683, 
	-0.033706, -0.017381, 2.084872, -1.355460, -4.248509, -0.003198, 1.023076, -0.041508, 0.050650, -2.652296, 4.873213, -0.003452, 1.389711, -0.904586, -0.045020, -0.116406, 
	-0.008361, -0.016578, -0.772196, 1.472225, -1.861511, -0.001470, -1.823461, -0.009886, -0.004229, -0.504426, -0.320500, -0.001604, 4.002683, 2.036894, -2.127623, -0.059955, 
	-0.034911, -0.019333, 1.319834, 1.677652, -1.694821, -0.004894, -2.751623, -0.027544, -0.011044, -1.130495, -1.386790, -0.005390, 3.560630, -1.280066, 0.565069, 1.223728, 
	-0.011111, -0.003530, 2.170305, -0.669090, 0.563451, -0.001443, -3.036675, -0.004150, -0.002423, -0.804324, 2.837570, -0.001461, -0.075350, -0.673044, -0.254520, -0.034206, 
	-0.007093, -0.002264, -0.006316, -0.261108, -0.445645, -0.000764, 2.084171, -0.004807, -0.001661, 0.672557, -1.781840, -0.000806, 1.064371, -0.978019, -0.282121, -0.048654, 
	-0.022837, -4.234077, -0.057543, -0.482306, -2.439825, -0.003301, -0.313074, 4.293049, -0.005817, -2.641732, 1.974678, -0.003405, -0.880030, 3.614126, 1.240610, -0.038517, 
	-0.014128, -0.005099, 0.371970, 1.186680, -1.087702, -0.000953, -5.518581, -0.009215, -0.003044, -0.978087, 13.463932, -0.000987, -7.139079, -0.250089, 0.008753, -0.024372, 
	-0.004789, -0.002406, -0.013394, 0.426675, -0.087876, -0.000939, 0.547698, -0.002206, -0.001619, -0.389948, -0.367777, -0.000942, 0.242770, -0.119744, -0.192743, -0.032761, 
	-0.003272, -0.000870, -0.699724, 0.185425, -0.660471, -0.000198, 0.540792, -0.001024, -0.000540, 0.071288, -0.528072, -0.000210, -0.177151, 1.403141, -0.115559, -0.013556, 
	-0.023102, -0.029817, 1.234236, -1.116496, -1.271749, -0.004056, -0.320005, -0.012603, -0.007998, 1.362958, -2.107154, -0.004386, -0.199825, -1.843274, 4.570272, -0.227002, 
	-0.046349, -0.006846, -1.180376, -3.546603, 4.265758, -0.002983, 1.416512, -0.008211, -0.005147, 0.352886, -2.457761, -0.003118, 1.510157, 0.360457, -0.530461, -0.117916, 
	-0.007439, -0.004500, 0.069264, 2.226433, 2.098031, -0.001247, 2.338858, -0.008356, -0.002854, 0.144366, -0.590213, -0.001331, -4.537219, -1.473296, -0.042057, -0.208440, 
	-0.003699, -0.002582, -1.221377, -0.474056, -0.246694, -0.000631, 0.607899, -0.002678, -0.001644, -0.202886, 4.707170, -0.000723, -2.595480, 0.348626, -0.894929, -0.016315, 
	-0.031412, -0.007960, 0.601777, -0.211112, -3.203224, -0.002025, 3.685310, -0.007423, -0.003820, -0.640317, -12.615484, -0.002179, 11.450315, -1.402016, 2.464094, -0.074526, 
	-0.012833, -0.005788, -0.461710, 2.724315, 1.132562, -0.000811, -1.315653, -0.002833, -0.002050, -0.992591, 1.855616, -0.000813, -1.631708, 0.085167, -1.313922, -0.056948, 
	-0.039341, -0.010480, -0.876344, -1.964498, 0.411634, -0.002229, -1.095785, -0.010636, -0.005812, -2.240712, 1.214692, -0.006777, 2.985348, 1.557266, 0.505694, -0.422021, 
	-0.044653, -0.001909, 2.000744, 0.463810, -1.122436, -0.000597, -2.295279, -0.003561, -0.001470, -0.661079, -1.179403, -0.000645, 3.525014, -0.499496, -0.167367, -0.011673, 
	-0.040482, -0.017146, 0.482119, -4.388307, -6.088188, -0.003805, -7.265937, -0.042080, -0.011422, -0.201556, -12.075767, -0.008423, 31.409706, 0.092348, -1.419170, -0.421892, 
	-0.013196, -0.005860, -0.529437, 2.612112, 2.497035, -0.001768, 1.638493, -0.021130, -0.005430, 0.036771, -2.030462, -0.001915, -3.245461, 0.447628, -1.326093, -0.051288, 
	-0.019439, -0.009486, -0.842154, -0.427467, -0.752442, -0.003045, -1.363614, -0.009547, -0.005574, -0.942834, -2.494270, -0.007478, 3.734787, 3.702316, -0.471796, -0.087957, 
	-0.585486, -0.050622, 2.840512, 3.409225, -0.533574, -0.089905, 0.833613, -0.631331, -0.193452, -3.928079, 1.220842, -0.352360, -6.112208, -1.086225, 4.676326, 0.582723, 
	-0.021191, -0.003407, -0.061499, 0.063480, 0.900883, -0.000484, 0.568095, -0.003235, -0.001794, -0.616820, -0.962405, -0.000550, 0.201163, 0.503051, -0.557864, -0.007422, 
	-0.026287, -0.010202, 2.362034, -0.982029, -0.007226, -0.002956, -2.133215, -0.013016, -0.006507, -3.499127, 3.528447, -0.003092, -1.014725, 2.393508, -0.523611, -0.061998, 
	-0.079206, -0.023929, -1.791628, -0.460059, -5.032047, -0.002433, 2.739145, -0.011423, -0.007539, -0.210962, -3.980124, -0.002626, 4.985746, 2.390043, 1.766915, -0.279874, 
	-0.004828, -0.005001, 4.263905, -1.232066, 0.426582, -0.001093, 0.269960, -0.006453, -0.003202, 0.906860, -1.806437, -0.001217, 0.113270, -2.868182, -0.025144, -0.026955, 
	-0.001979, 0.001222, -0.536538, 0.450291, -0.454093, -0.000652, 0.656151, -0.003929, -0.001071, -0.114581, 4.229383, -0.000613, -4.087787, -0.237608, 0.112134, -0.010332, 
	-0.058937, -0.017103, -1.387333, 6.705117, -1.428722, -0.002743, 4.719935, -0.014423, -0.008741, -1.039631, -1.690515, -0.024724, -5.854599, 0.938737, -0.598876, -0.237443, 
	-0.007011, -0.002985, -1.056055, 1.499009, -3.738930, -0.002040, -1.234272, -0.007835, -0.002820, -0.254057, -4.996416, -0.002084, 9.669831, -0.356312, 0.512713, -0.020736, 
	-0.006755, -0.005433, -0.985231, 2.884880, 1.893913, -0.001225, -1.457930, -0.018933, -0.013383, -0.588675, 0.379311, -0.001249, -1.648144, -0.782860, 0.538693, -0.186979, 
	-0.035359, -0.015169, 1.749765, -2.633360, 1.849435, -0.004730, -3.553781, -0.013122, -0.009683, 1.739392, 1.740852, -0.005220, 1.237254, -1.337316, -0.433077, -0.275882, 
	-0.019617, -0.008592, -2.714549, -0.544857, -0.853670, -0.003435, -4.291053, -0.009274, -0.005614, 7.159925, 1.561628, -0.132935, 1.209469, -1.321102, 0.035726, -0.062050, 
	-0.005642, -0.002921, -0.055266, -1.280490, -0.170565, -0.001043, -3.699756, -0.006758, -0.002103, 0.102752, -1.135914, -0.001091, 3.883884, 0.209929, 2.190697, -0.025714, 
	-0.074067, -0.022316, -3.671890, 4.578131, 0.161630, -0.004413, -3.442422, -0.018552, -0.011730, 2.136957, 0.675466, -0.004696, 1.939850, -0.669877, -0.917888, -0.654183, 
	-0.014311, -0.016461, 0.093139, 2.196288, -2.210120, -0.008391, -0.608562, -0.094805, 0.583248, -0.743259, 1.194028, -0.008635, 0.882709, -0.933969, -0.267560, -0.043340, 
	-0.244280, -0.086158, -2.664959, -1.486068, -3.550734, -0.019885, 0.252817, -0.042493, -0.034420, -2.871443, 2.686257, -0.020430, 3.459504, 6.726796, -2.636409, 0.531904, 
	-0.070230, -0.047240, 0.988192, -5.303192, 0.418065, -0.008986, 4.472734, -0.102877, -0.028206, 2.290527, 1.097688, -0.010033, -2.419985, 4.803736, -4.576975, -1.503219, 
	-0.001152, -0.001227, 0.666145, 0.023946, -0.434379, -0.000475, 3.131102, -0.001502, -0.000901, -0.599050, 0.340458, -0.000509, -2.634134, -0.144932, -0.283133, -0.060258, 
	-0.748190, -0.395966, 2.002770, 2.834779, 2.606765, -0.102782, -3.020189, -0.698477, -0.247458, -2.369451, -1.540502, -0.459631, -0.675779, 1.541065, -2.546343, 3.819390, 
	-1.003660, -0.387255, 1.501105, 0.138341, 1.998852, 0.337567, 1.443976, -1.331324, -0.358999, -0.624705, 0.822075, 0.988632, 1.249920, -0.862871, -0.287768, -3.623888, 
	-0.027152, 2.720739, 0.189476, 2.079983, -0.727982, -0.004898, -5.197330, -1.798541, -0.761746, -1.202580, 3.070076, -0.005126, 0.884075, 1.516998, -0.653497, -0.082495, 
	-0.001669, -0.001399, -1.028081, 0.289503, -0.148029, -0.000710, 0.005942, -0.001007, -0.000927, 0.365926, 1.392593, -0.000713, -1.353200, -0.511018, 1.038484, -0.045695, 
	-0.031007, -0.024064, 0.251589, -1.760412, -2.722563, -0.004992, 0.845536, -0.025233, -0.008132, 3.105765, 0.382775, -0.005243, 1.219501, 0.317512, -1.026520, -0.514512, 
	-0.001856, -0.001253, 0.146910, -0.273424, 2.551528, -0.000819, -0.849037, -0.001508, -0.001155, -0.052500, 0.562647, -0.000774, -2.478095, -0.112673, 0.543130, -0.031123, 
	-0.007301, -0.008118, 0.739962, 1.641009, -0.364187, -0.001402, 2.225278, -0.008422, -0.003965, -2.150812, -1.110675, -0.001678, -1.217001, 0.570455, -0.261248, -0.041894, 
	-0.009636, -0.001196, -0.257477, -0.160173, 1.571098, -0.000194, 0.951005, -0.000815, -0.000519, 0.111634, -0.206766, -0.000220, -1.578897, -0.332206, -0.042928, -0.042711, 
	-0.340434, -0.041094, 0.905888, -4.520012, 3.736543, -0.024223, -0.748651, -0.085977, -0.039702, 3.922678, 8.773327, -0.038937, -5.105876, -3.465524, -3.932149, 1.004143, 
	-0.005825, -0.002296, 0.579608, 1.768497, -0.700332, -0.000898, 1.065049, -0.002766, -0.001780, -1.561885, -1.728165, -0.000902, 1.058599, 0.315339, -0.747600, -0.034640, 
	-0.019937, -0.011451, 2.388375, 3.756228, -3.031596, -0.005252, -0.884211, -0.019550, -0.009102, 1.678571, -0.974469, -0.005436, -0.498506, -0.739276, -1.510543, -0.113845, 
	-0.016666, -0.008390, 0.208462, -0.193791, -0.150401, -0.001134, -0.247315, -0.017790, -0.004874, -0.573629, 3.043639, -0.001250, -0.177899, -0.691988, -1.158157, -0.008817, 
	-0.042735, -4.550154, -1.559746, 0.731322, 2.363831, -0.005901, -3.270864, 4.665970, 0.059713, 1.514986, 1.230429, -0.007050, -0.877800, -0.253802, -0.920401, 0.922202, 
	-0.018621, -0.007477, 12.849528, -3.519634, -2.461321, -0.004768, -1.871147, -0.009111, -0.006527, -1.279836, -2.017936, -0.004789, 1.613361, -2.347395, -0.833987, -0.080340, 
	2.001910, -0.022169, -0.783103, 2.834352, -0.369731, -0.024483, 5.406265, -0.663228, -0.053750, 1.020223, -0.445716, -0.032553, -4.096252, -5.245779, 0.885926, -0.411910, 
	-0.071389, -0.010630, -1.829890, -1.211735, 1.127997, -0.003090, -4.458454, -0.014939, -0.007233, -1.580221, 1.303810, -0.003314, 5.190268, 2.577075, -0.910544, -0.097710, 
	-0.019971, -0.017565, -0.794482, -1.988549, -1.909076, -0.003373, -0.308277, -0.013299, -0.012804, 0.076301, 3.232999, -0.003769, -0.560767, 1.736976, 0.759458, -0.173802, 
	1.298015, -0.187401, 5.444158, 0.217923, -0.598489, -0.041303, 1.134287, -0.189857, -0.087756, -4.344042, -2.720547, -0.043876, 3.807195, -2.817251, -0.799485, -0.071571, 
	-0.036146, -0.005784, -0.329519, 4.235825, -1.387976, -0.001345, 1.912180, -0.004611, -0.003028, -3.412663, 2.575936, -0.005790, -2.642311, -0.541438, -0.324552, -0.028779, 
	-0.008477, -0.010994, 1.615211, -0.215292, -0.079239, -0.001722, -0.735969, -0.009497, -0.000986, -0.683909, 0.337821, -0.001189, -1.450679, 0.427117, 0.931323, -0.113520, 
	0.559354, 0.019428, -1.323330, 7.186332, -1.177579, -0.121201, -3.108218, -0.546664, -0.230684, -5.001981, -1.387929, -0.257337, 10.037794, -7.674252, 1.052979, 1.973289, 
	-0.026538, -0.006304, -0.241714, -0.905782, -1.396448, -0.002464, -3.578063, -0.010313, -0.004852, -0.730708, 5.994229, -0.002475, 1.507729, -0.448692, -0.118915, -0.028690, 
	-0.021714, -0.012910, 3.406732, 0.739724, 3.034078, -0.003366, -0.881860, -0.015920, -0.008654, -3.043672, -1.935657, -0.003608, -0.312851, -1.929241, 1.195701, -0.206782, 
	-0.001802, -0.001401, -0.001975, 0.692795, -0.503778, -0.000643, -0.092571, -0.001122, -0.000884, -0.192149, -0.402102, -0.000653, -0.145809, -0.048436, 0.730027, -0.029498, 
	-0.034367, -0.020896, 0.621755, 2.276421, 0.345497, -0.005987, -4.967936, -0.041407, -0.026854, 1.540172, 2.542950, -0.006551, 2.082225, -1.887663, -2.599675, 0.182316, 
	-0.076506, -0.010235, 2.669576, 0.196707, -0.224300, -0.002158, -6.877446, -0.043244, -0.007135, -1.461271, 6.984063, -0.002382, 0.729120, -1.881465, 0.201409, -0.194732, 
	-0.009920, -0.025119, 2.288166, -3.590658, 0.432313, -0.001842, -0.606958, -0.012963, -0.005903, -0.537654, 1.635634, -0.002034, -1.870512, 2.048992, 0.369219, -0.110762, 
	-0.003888, -0.003529, -0.700624, -0.318369, -0.031552, -0.000943, -2.144450, -0.004116, -0.002190, 0.145738, 1.271614, -0.001039, 0.856612, -0.258933, 1.230242, -0.034575, 
	-0.060067, -0.030071, -2.297876, 8.813074, -0.481756, -0.008764, -1.765730, -0.045930, -0.018953, 2.555731, -5.993647, -0.009243, -0.083396, 3.236391, -3.487042, -0.322721, 
	-0.033186, -0.022542, -0.936943, 0.807845, -0.411882, -0.005948, -1.927664, -0.035433, -0.013463, -2.045030, 1.305477, -0.135718, 2.200472, -2.669106, 4.266730, -0.343610, 
	-0.013114, -0.013583, -0.543957, 0.697378, -2.244443, -0.002044, 1.276137, -0.011463, -0.004027, -0.545829, 0.889833, -0.002160, -0.770148, 0.291749, 0.640804, 0.354867, 
	-0.055470, -0.008441, 4.042403, 2.843138, -1.547195, -0.002027, 1.916357, -0.008311, -0.004887, -0.029937, -3.493549, -0.131551, -4.786851, -0.306671, 1.667383, -0.094392, 
	-0.062323, -0.045844, -2.107557, -0.283348, 1.085221, -0.012544, 2.721826, -0.040669, -0.022012, 0.727953, 0.595549, -0.013363, -1.350320, -1.207834, 0.832649, -0.817384, 
	-0.053678, -0.027176, -1.043316, 0.768216, -3.534996, -0.012351, -1.079679, -0.030930, -0.020565, -0.362732, 3.151662, -0.017253, 4.398392, 0.279077, -1.905284, -0.509388, 
	-0.010427, -0.004760, -0.694074, 1.504851, -1.437562, -0.000924, -3.865726, -0.003071, -0.002216, -0.745816, 7.169625, -0.000971, -2.623986, 0.292872, 0.511310, -0.089128, 
	-0.000623, -0.001029, 0.583443, -0.062718, -0.030590, -0.000429, -0.643570, -0.001567, -0.000674, 0.087212, -0.872354, -0.000187, 0.622963, -0.476421, 0.798675, -0.002130, 
	-0.017840, -0.012551, -3.541360, 7.709728, -3.838220, -0.006359, 0.394542, -0.018015, -0.008250, -0.520221, -2.579139, -0.006474, 5.476447, -2.732285, -3.398197, 3.098196, 
	-0.010118, -0.005063, -1.065587, -1.645812, -0.073153, -0.000770, 4.489443, -0.003219, -0.001898, 1.220877, -4.692857, -0.000817, 1.370865, -0.317002, 0.786503, -0.051390, 
	-0.016655, -0.013719, -0.566650, -0.347948, 0.155468, -0.005028, -1.167242, -0.016961, -0.009406, 0.291654, -1.592783, -0.005264, -1.741901, 4.438719, 0.888408, -0.290691, 
	-0.068917, -0.006103, -0.363197, -0.274856, -1.447198, -0.002074, 2.009116, -0.017405, -0.000238, 0.209914, 0.457115, -0.002180, -0.905120, -1.872025, 0.497339, 1.785830, 
	-0.159201, -0.011785, -1.953613, 1.178555, 0.272745, -0.002408, 0.814074, -0.010637, -0.005770, 2.764581, -0.704661, -0.002517, 0.330330, -1.169803, -1.294374, -0.045518, 
	-0.087270, -0.007240, 0.556070, -0.435215, -2.892547, -0.002115, 2.037834, -0.007289, -0.004468, -2.376883, -1.479171, -0.002198, 2.021862, -0.222421, 2.996631, -0.095580, 
	-0.009188, -0.001491, -0.554276, -0.865063, -1.319878, -0.000521, -2.444898, -0.001668, -0.001143, 1.737500, 5.113238, -0.000666, -2.841310, -0.016679, 1.277746, -0.071704, 
	-0.010411, -0.013480, -0.429615, -1.644172, -1.287747, -0.001652, 4.022102, -0.007112, -0.003374, 3.546555, 0.751982, -0.001763, -2.877142, -0.620485, -1.388253, -0.035434, 
	-0.023162, -0.021721, -0.802651, 2.841550, -0.999422, -0.006070, 0.305345, -0.012795, -0.008669, -1.590101, -0.686255, -0.006127, 0.300624, 1.198486, -1.327671, 0.838640, 
	-0.013167, -0.006771, 2.440331, 0.628594, 0.973513, -0.001350, -0.445518, -0.006874, -0.004045, -1.553710, 2.568482, -0.001617, -3.185302, -0.338081, -0.774647, -0.279840, 
	-0.013853, -0.002467, 0.230463, 0.133220, 2.645418, -0.000750, -3.154008, -0.002689, -0.001627, -1.066698, -2.798502, -0.000779, 4.486159, -0.087922, -0.351658, -0.014306, 
	-0.221829, -0.098459, -2.278824, -1.970981, 5.258492, -0.039459, 4.593255, -0.186299, -0.078093, -2.040192, -2.901599, -0.041115, 2.404084, -3.070832, 2.966962, -2.295110, 
	-0.001981, -0.002502, 0.209214, 0.422306, -0.637093, -0.000443, 1.498492, -0.002230, -0.001193, -0.169518, -1.606937, -0.000497, 0.518914, -0.737386, 0.526894, -0.016041, 
	-0.021007, 0.003630, -2.284206, -1.469486, -0.111076, -0.003640, -2.476836, -0.035863, -0.007532, 3.531742, 0.871113, -0.003860, 1.877122, 1.924661, -1.513371, -0.281391, 
	-0.001498, -0.001523, 1.092622, -0.136550, -0.608517, 0.000515, 0.868821, -0.002496, -0.001254, -1.997096, -0.252366, -0.000877, 0.003887, 1.043533, -0.000185, -0.007015, 
	-0.025479, -0.023674, -0.055397, 0.553038, 0.674144, -0.006182, -1.731912, -0.025175, -0.013740, -2.220047, 2.546583, -0.006385, 1.094966, 0.173773, -0.805920, -0.128594, 
	-0.002386, -0.001438, 1.214134, 0.639893, -0.286501, -0.000597, 1.033764, -0.001218, -0.000957, -0.836303, -0.110793, -0.000655, -1.149892, -0.847527, 0.356513, -0.006037, 
	-0.015245, -0.003342, -1.077666, -1.087626, 0.971768, -0.000869, -0.477200, -0.002911, -0.001952, 3.791368, 0.637257, -0.000961, -1.558210, -0.661396, -0.507997, -0.005019, 
	-0.033047, -0.020357, 1.022629, 1.008817, 0.392892, -0.006630, 1.366607, -0.032107, -0.013552, -2.957217, -0.505123, -0.006993, -0.428679, -0.419929, 0.427581, 0.205106, 
	-0.008455, -0.005351, -1.553229, -0.837266, -0.846199, -0.001896, -1.824811, -0.054201, -0.003938, 5.567366, 0.296192, -0.131389, -0.298621, -0.210740, -0.042775, -0.044688, 
	-0.038787, -0.007374, 1.762677, 0.267912, 1.193603, -0.002639, 1.609780, -0.010398, -0.005052, -2.248252, -2.607352, -0.002769, 1.063074, -0.552472, -0.352427, -0.069524, 
	-0.125802, 3.243335, -2.032500, 8.073222, -3.747551, -0.013154, -0.447215, -3.303997, -0.030183, -4.666072, -0.211691, -0.018424, 3.796030, 0.884382, -3.767949, 2.367570, 
	-0.001154, -0.001197, 0.263517, 0.335842, 0.014349, -0.000602, 0.504637, -0.001192, -0.000891, -0.589779, -1.952457, -0.000550, 1.834770, -0.517283, 0.129746, -0.017756, 
	-0.008211, -0.004317, -0.683983, 0.671946, 0.884113, -0.001256, 0.724210, -0.003422, -0.002491, -1.807298, -0.538387, -0.001295, -0.812585, 1.864759, -0.233286, -0.048498, 
	-0.035611, 0.007462, -2.168818, -0.976373, 4.208943, -0.003117, 1.213271, -0.033634, -0.008046, 0.085284, -1.535272, -0.003335, -0.050118, 0.300844, -0.787926, -0.213556, 
	-0.015694, -0.012526, 3.702312, -1.749339, -1.579478, -0.003593, -3.036350, -0.019585, -0.007109, -3.000983, 0.128328, -0.003667, 6.302860, -0.367136, -0.103158, -0.234883, 
	-0.032556, -0.001897, -0.115447, -0.446572, -0.305673, -0.000358, 1.491013, -0.001092, -0.000873, 0.642545, 0.703679, -0.000390, -1.142986, -0.446352, -0.320735, -0.022305, 
	-0.013969, -0.001849, -0.295218, -0.608845, -0.614300, -0.001222, 0.357093, -0.004553, -0.001549, -0.087991, 0.264962, -0.001252, 1.110934, 0.024437, -0.119225, -0.007454, 
	-0.007955, -0.007936, 0.506870, -0.692518, -1.551556, -0.002255, 2.042305, -0.007956, -0.005689, -0.915147, 0.058097, 0.021651, -1.701995, 0.303918, 2.057862, -0.097696, 
	-0.040389, -0.022414, -1.519095, -2.115199, -0.352805, -0.002893, -0.475594, -0.014733, -0.007543, 2.440939, 2.306946, -0.003022, -1.986915, 2.706400, -1.016658, 0.102976, 
	-0.035153, -0.015166, -1.401130, 1.633665, 1.949581, -0.002482, 2.932247, -0.059318, -0.008836, 1.558347, -2.004500, -0.001666, -0.449949, -0.691066, -3.500155, 0.095581, 
	-0.003100, -0.001190, 0.524775, -0.521935, 1.219743, -0.000553, -0.058390, -0.001564, -0.000946, -1.483980, -0.514278, -0.000590, -0.091889, 0.027711, 0.965789, -0.059602, 
	-0.061774, -0.033250, 0.580504, -0.968746, 0.390623, -0.016449, 0.352813, -0.051727, -0.024773, -0.065801, -7.375813, -0.016449, 2.580241, -1.705590, 6.821122, -0.404930, 
	-0.004436, -0.004137, -0.842773, 0.753737, 1.762413, -0.001022, -0.218719, -0.002746, -0.002041, 0.912179, -0.320649, -0.001061, -0.256329, -0.839349, -0.765492, -0.169576, 
	-0.051821, -0.004890, 0.122239, -1.928182, 0.025384, -0.001604, 0.225070, -0.014047, -0.003707, 1.500376, 0.303190, -0.001790, -0.643550, -1.234589, 1.745994, -0.038073, 
	-0.003139, -0.003426, 1.322635, -0.587964, -0.205011, -0.000601, 1.107469, -0.003404, -0.001727, -0.522455, -1.059010, -0.000649, -1.252122, 0.531752, 0.696059, -0.018407, 
	-0.036872, -0.007668, 2.506664, -0.602244, 1.417216, -0.002350, -0.355813, -0.009351, -0.005123, -2.198563, -2.827003, -0.136305, 4.648967, -0.460192, -1.789489, -0.141875, 
	-0.003529, -0.002504, 0.491095, -1.409313, 0.141104, -0.000801, 1.827890, -0.003231, -0.001552, -1.017654, 0.495434, -0.000815, -2.715366, 0.403928, 1.945153, -0.149840, 
	-0.612144, -0.041883, -3.347522, 0.731342, 6.209788, -0.068523, 1.278583, -0.336142, -0.150359, 0.266707, -4.837585, -0.072938, 2.285088, -0.186367, 1.011598, -2.129642, 
	-0.063517, -0.005745, -0.642338, 1.033994, -2.150291, -0.002056, 0.804209, -0.006616, -0.003821, 2.225039, 0.057468, -0.002162, -2.146032, 0.117111, 0.839837, -0.055080, 
	-0.056953, -0.033843, 0.291035, 4.030493, 1.540704, -0.012094, -3.498151, -0.048371, -0.032810, 0.899138, -4.726924, -0.012891, 4.288429, -0.745656, -1.482102, -0.400003, 
	-0.007263, -0.003618, 0.342600, -0.364820, -0.721831, -0.001837, 2.432502, -0.006301, -0.002676, -0.993035, 0.325602, -0.001883, -3.190546, -0.338880, 2.573876, -0.041890, 
	-0.007577, -0.005066, 1.312176, 0.903830, -0.373715, -0.001479, -1.417790, -0.006818, -0.003415, 0.880844, -0.304842, -0.001579, -2.244038, 0.569248, 0.728161, -0.027939, 
	-0.020109, -0.008093, -0.892642, 2.151545, 0.221380, -0.002420, -2.815188, -0.023746, -0.006087, 0.125329, -1.464162, -0.007009, 1.977170, -0.739901, 1.597085, -0.093151, 
	-0.010325, -0.007657, 0.182585, -2.961819, -1.184874, -0.002035, 0.744987, -0.007238, -0.004451, 2.343243, -0.064341, -0.002139, -1.107018, 0.679718, 1.460572, -0.059208, 
	-0.007436, -0.006516, 1.339024, -0.522937, -0.156242, -0.002257, -1.363314, -0.012033, -0.006333, 0.670970, -1.400513, -0.002395, -1.082114, -0.184040, 2.815255, -0.079118, 
	-0.004364, -0.001656, 1.214064, 0.606720, 1.382558, -0.000363, -0.591791, -0.001040, -0.000844, -0.629469, -2.034246, -0.000384, 1.292624, -1.337979, 0.129535, -0.023364, 
	-0.024136, 3.377829, -2.175001, -0.511271, 0.250026, -0.006074, -1.405668, -3.319147, -0.011210, 3.776506, -1.845393, -0.004751, 4.303525, -1.826591, -0.435572, -0.143072, 
	-0.019854, -0.009849, -0.053215, 3.413439, -0.948890, -0.002038, -4.608617, -0.008512, -0.005479, 1.309584, 2.085715, -0.002188, 0.807525, -1.143578, -0.756888, -0.057155, 
	-0.003079, -0.001258, -0.027636, -0.729686, -0.548920, -0.000548, 3.408347, -0.001398, -0.000976, 0.039738, 1.264408, -0.000556, -3.320868, 0.323753, -0.389235, -0.012087, 
	-0.120155, -0.024150, -5.819122, -0.381750, 2.013094, -0.007462, -0.859936, -0.022626, -0.013778, 0.750210, -2.894022, -0.007783, 3.880945, 6.728100, -3.062683, -0.158883, 
	-0.007939, -0.004717, 0.665980, 0.046599, 1.853609, -0.001103, 0.978576, -0.005312, -0.002686, -0.486802, -0.122642, -0.001164, -2.047822, -0.398887, -0.432992, -0.032697, 
	-0.027020, -0.025539, 2.340444, -1.918871, -0.417527, -0.004669, -4.112556, -0.025921, -0.012312, -4.217525, 1.454127, -0.004100, 1.996764, 1.610506, 0.417008, 2.947192, 
	-0.021747, -0.010504, 0.810752, 0.393173, -1.477640, -0.001492, 0.562819, -0.018314, -0.006759, -0.582187, -0.361607, -0.001694, 1.617654, 0.175632, -0.838566, -0.239518, 
	-0.018592, -0.017577, 1.588503, -1.055673, 1.245570, -0.003595, 0.996809, -0.029795, -0.012786, -0.327141, 1.059382, -0.004865, -0.062173, -1.053998, -2.057573, -0.246495, 
	-0.057151, -0.025446, -2.959381, 2.342393, -3.124195, -0.005960, -0.488678, -0.025614, -0.015717, 3.420597, -1.946896, -0.006710, 1.817993, 3.256071, -1.759752, -0.421554, 
	-0.003848, -0.003203, 0.786429, 3.181625, 0.098629, -0.000753, -0.852778, -0.006148, -0.001994, -1.846025, -1.568560, -0.000823, 0.087427, 0.156269, 0.014081, -0.040328, 
	-0.036261, -3.723496, -2.269058, -5.503119, -1.974986, -0.023566, 0.094202, 7.982438, -0.075607, 6.559227, -2.242587, -0.023700, 3.523435, -1.462080, -0.650615, -0.174226, 
	-0.001231, -0.000642, -0.251874, 1.009876, -0.204249, -0.000254, -0.111073, -0.002319, -0.000574, -0.328850, -0.114515, -0.000285, -0.224865, 0.269710, -0.032510, -0.006345, 
	-0.078655, -0.016814, 0.739769, 1.545033, -0.884208, -0.003589, 2.506625, -0.016850, -0.009481, -1.608160, 5.423875, -0.003955, -6.187408, -0.581366, -0.703500, -0.121316, 
	-0.070191, -0.020744, -3.016802, -1.826853, -0.981564, -0.007453, 8.084186, -0.028922, -0.014939, -1.052614, 2.330199, -0.007970, -2.035559, -0.608832, -0.357711, -0.384231, 
	-0.021585, -0.015929, -1.729314, 2.667867, 0.114958, -0.002643, -0.016952, -0.013900, -0.007904, -2.309635, 4.868965, -0.002516, -1.109000, -0.320426, -2.029533, -0.072452, 
	-0.067663, -0.048721, 0.769723, -2.326919, -1.756063, -0.010679, 2.246675, -0.057043, -0.028170, 0.262774, -0.952680, -0.011467, 1.214774, -1.156998, 2.383548, -0.461094, 
	-0.004622, -0.004927, 1.662931, 1.337348, 0.116587, -0.001590, -2.231585, -0.003880, -0.002600, -0.084967, -2.206790, -0.001649, -0.121691, -0.255910, 1.820924, -0.017580, 
	-0.005930, -0.006059, 0.469025, -0.688288, -2.975526, -0.000683, 1.926994, -0.003410, -0.002176, 1.695748, -2.939494, -0.000796, 3.433969, -1.139685, 0.291674, -0.055363, 
	-0.003874, -0.002172, -0.595439, 1.374916, 0.326491, -0.000909, 0.493702, -0.004964, -0.001634, -0.658306, -2.542451, -0.000907, 1.189199, 0.724989, -0.510580, 0.211938, 
	-0.045376, -0.011102, 2.319877, 0.559513, -2.506258, -0.002463, -1.680440, -0.013374, -0.006869, 0.085719, 1.105105, -0.002569, 0.024721, 0.256387, 0.075575, -0.158445, 
	-0.003182, -0.001997, -0.935763, 1.462734, -1.327392, -0.000892, -0.082746, -0.002084, -0.001617, -0.244366, -0.079387, -0.000929, 0.737915, 0.299371, 0.203589, -0.023252, 
	-0.068132, -0.009124, -2.727303, -1.251367, -0.228110, -0.002082, 2.050436, -0.012078, -0.005903, 4.479236, -3.392962, -0.002312, -0.142725, 2.318350, -0.832071, -0.173853, 
	-0.048574, -0.006318, -0.507122, 0.302803, 2.138346, -0.001811, 1.771948, -0.011836, -0.004521, 0.490288, -2.544534, -0.001877, -2.288944, 1.669173, -0.898632, -0.058387, 
	-0.040997, -0.026111, -1.056450, 3.159640, -2.097563, -0.015482, -1.007544, -0.037157, -0.022311, -1.368875, -6.309813, -0.015944, 4.450296, -1.152039, 4.742282, 0.798067, 
	-0.016319, -0.003756, -1.361519, -0.707112, 0.208705, -0.002173, -1.045462, -0.007977, -0.003811, 3.415596, -0.050086, -0.002226, 0.759121, -1.305498, 0.166492, -0.043977, 
	-0.009596, -0.006084, 0.162180, 0.722828, -0.897527, -0.002399, 0.502057, -0.010842, -0.004265, -1.158866, 4.413342, -0.002527, -2.035816, -1.042993, -0.575970, -0.053522, 
	-0.001702, -0.001911, 0.785644, -2.871911, -0.388142, -0.000372, 3.564000, -0.003616, -0.001168, -0.838648, -1.684816, -0.000411, 1.566540, -0.390762, 0.295261, -0.027987, 
	-0.021114, -0.017412, -0.421910, -3.293426, 3.413915, -0.002379, -4.186579, -0.024198, -0.009304, 0.947051, 1.293373, -0.002692, 1.693028, 1.084326, -0.369949, -0.082730, 
	-0.004886, -0.001951, 1.455398, 0.023663, -1.036203, -0.000764, 1.556929, -0.001731, -0.001290, -0.270386, 3.296164, -0.000789, -4.536887, -0.406696, -0.042660, -0.027909, 
	-0.001017, -0.000775, -0.595205, -0.330834, -0.039735, -0.000448, -0.221319, -0.001166, -0.000694, 0.420273, -0.280273, -0.000458, -0.107025, -0.049156, 1.212814, -0.004981, 
	-0.003129, -0.001433, 0.068611, 0.388185, 0.007502, -0.000310, -1.017947, -0.001599, -0.000771, 0.461978, -0.219207, -0.000316, 0.693436, -0.137977, -0.225698, -0.011324, 
	-0.064312, -0.011988, 2.389081, 1.302686, -1.562889, -0.001223, 0.931279, -0.029592, -0.007046, -1.621533, 0.227691, -0.001644, 0.217956, -0.850217, -0.877176, -0.041071, 
	-0.011920, -0.008148, -0.338643, 1.250289, 2.676140, -0.002523, -0.837753, -0.019985, 0.073049, -0.942186, -1.760176, -0.002740, 0.858328, -0.207290, -0.702479, -0.023961, 
	-0.016883, -0.005305, -0.092017, 1.317385, 2.102961, -0.002254, -1.546524, -0.007025, -0.003533, -1.211811, -1.639653, -0.002348, 0.965097, -0.567017, 0.730896, -0.021970, 
	-0.006327, -0.005362, -0.024554, 0.890502, 1.409955, -0.001482, -2.037503, -0.005866, -0.003304, 1.075890, -1.368421, -0.001565, 0.235433, -0.385191, 0.285898, -0.058102, 
	-0.015305, -0.008691, 0.539680, 0.945285, 2.657859, -0.003112, -1.268113, -0.046468, -0.007054, -0.801273, -2.153396, -0.003245, 1.782566, 0.000324, -1.371142, -0.247913, 
	-0.009748, -0.006280, -0.760995, -1.889460, -4.433967, -0.002118, 0.887613, -0.024299, -0.005716, 3.052201, 2.155245, -0.002293, -3.035900, 3.091392, 1.007712, -0.023388, 
	-0.025662, -0.006899, 0.015742, -3.619760, 0.143161, -0.001211, 0.194513, -0.012037, -0.004573, -1.776027, 3.919616, -0.001385, -1.484624, 3.117572, -0.424888, -0.033538, 
	-0.014894, -0.004520, 0.289808, -0.840300, -1.845443, -0.000740, -0.971089, -0.043515, -0.003702, -0.800853, 2.618285, -0.000977, 0.635696, 1.028298, -0.031855, -0.014197, 
	-0.007629, -0.005204, -1.973882, 0.375330, -1.195730, -0.001293, 1.601034, -0.005119, -0.003339, -0.572747, 3.789335, -0.001465, -2.856767, 2.380589, -1.471855, -0.051258, 
	-0.023767, -0.015251, -0.858065, 0.748634, -1.527379, -0.005472, -1.910657, -0.054521, 0.270493, 0.002486, 2.703002, -0.005643, 0.151832, -0.613869, -0.545610, 1.683786, 
	-0.021672, -0.002681, -2.217044, 0.561505, -2.207477, -0.000816, 0.636620, -0.002558, -0.001714, 1.955549, 1.462719, -0.000874, 0.708578, -0.732661, -0.129055, -0.008419, 
	-0.004518, -0.005838, 1.495282, 2.202019, -1.217131, -0.001020, -1.375025, -0.011405, -0.002526, 0.494128, 1.253727, -0.001075, -0.961817, -1.513974, -0.333995, -0.016831, 
	-0.003143, -0.001616, 0.404869, -0.292172, 2.376678, -0.000670, -0.275165, -0.003396, -0.001432, 1.458571, -1.151756, -0.000696, -1.189351, -0.681652, -0.620229, -0.018841, 
	-0.006066, -0.007272, -3.052035, 0.748933, 5.782431, -0.001351, 2.363926, -0.008359, -0.004095, -0.776494, -2.872629, -0.001415, -0.818924, -0.757846, -0.359068, -0.229735, 
	-0.149949, -0.038950, 1.981711, -4.794549, 4.756336, -0.012888, -2.483925, -0.052000, -0.017648, 3.384538, -1.442029, -0.013395, -1.841882, 1.555289, -0.491417, -0.339244, 
	-0.005538, -0.001819, 0.047990, -1.273554, 1.002527, -0.000526, -0.055524, -0.002346, -0.001247, -0.194030, 0.321975, -0.000552, 0.011645, -0.219037, 0.400001, -0.029965, 
	-0.013745, -0.011482, 0.399796, 0.065304, -0.427045, -0.002476, 1.719926, -0.025442, -0.007185, -2.045930, -0.998779, -0.002732, 2.184263, -0.315177, -0.419890, -0.099407, 
	-0.011515, -0.004632, 1.256803, 0.404151, -0.350846, -0.002021, -0.907599, -0.007244, -0.003555, -0.125723, 3.405778, -0.002141, -4.640330, -0.703120, 1.771146, -0.079154, 
	-0.159794, -0.025658, 0.381057, 2.473807, 1.154373, -0.010274, 4.797229, -0.072798, -0.018877, -1.824076, 6.302336, -0.010714, -9.331239, -1.228721, -2.183327, -0.243324, 
	-0.093690, -0.014491, -2.026736, -1.535325, 5.564537, -0.004198, 7.896299, -0.018112, -0.009947, -1.742880, -2.995669, 0.043108, -10.399028, -1.225063, 5.138980, 1.422216, 
	-0.010271, -0.002564, -0.209329, 0.240914, 0.489782, -0.001396, -1.630118, -0.008657, 0.049584, 1.437659, 0.789664, -0.001418, -0.628725, -0.341791, -0.153163, -0.020170, 
	-0.010389, -6.695197, 0.030022, 0.454002, -0.882558, -0.003628, 2.616161, 7.082624, -0.008385, -0.680643, -1.432207, -0.003589, -0.252561, -0.342663, 0.162697, -0.033689, 
	-0.004238, -0.001965, -1.445823, -0.904987, -0.148368, -0.001000, 0.589824, -0.002377, -0.001560, 3.889724, -1.913988, -0.001025, 0.936659, -0.264581, -0.701200, -0.025093, 
	-0.030250, -0.010553, 1.371016, -1.897414, -0.493017, -0.002399, -3.811549, -0.013709, -0.006377, -1.901224, 2.262508, -0.002543, 1.339465, 3.574594, -0.313453, -0.065096, 
	-0.003685, -0.002818, 1.821786, -0.475187, -0.459365, -0.000848, 1.095976, -0.003882, -0.001934, -0.898282, 2.479107, -0.000857, -3.228560, -0.237934, -0.068183, -0.015335, 
	-0.075187, 3.350943, 0.769524, -0.095461, -0.417950, -0.017784, 0.267293, -3.337606, -0.012091, -2.967284, 7.483328, -0.019609, -2.202143, -1.075308, -0.128270, -1.522394, 
	-0.003662, 1.664364, -0.189731, 0.169307, 0.213658, -0.002161, 2.203550, -1.593281, -0.002846, -0.418007, -1.430701, -0.002179, -0.323464, -0.188627, -0.086738, -0.009484, 
	-0.016105, -0.016855, 4.561773, -1.594257, 2.043846, -0.002307, -1.858920, -0.013052, -0.006971, -1.169689, -2.994792, -0.002620, 1.946615, 1.374254, -2.198754, -0.052165, 
	15.741884, -0.169921, -2.430730, -0.362065, -2.438267, -2.769329, 0.335230, -0.184158, -0.130609, -0.575970, -1.745708, -2.945566, 1.241199, 2.434060, -2.533606, -3.466445, 
	-0.008936, -0.005972, -0.083710, 2.688277, 2.349842, -0.002409, -2.725792, -0.006062, -0.004112, -1.183922, -1.309296, -0.002475, 0.350896, -0.087958, 0.202266, -0.170637, 
	-0.004213, -0.004291, 2.268068, 0.343582, -1.172090, -0.001476, -0.313155, -0.005067, -0.003159, -0.864669, -1.614702, -0.001838, 4.799836, -2.913142, -0.570180, 0.056496, 
	-0.001675, -0.001531, 1.509252, -1.467253, 3.838424, -0.000930, -2.652464, -0.002243, -0.001295, 1.202730, -0.574889, -0.000950, -1.941918, -0.381926, 0.528530, -0.051861, 
	-0.167097, -0.130373, -5.574596, 10.950721, 6.752456, -0.042758, 1.709153, -0.140042, -0.085373, -10.078866, 3.188926, -0.044619, 2.593153, -5.429723, -2.345717, -1.155244, 
	-0.002574, -0.000952, 0.204620, 0.181006, 0.038736, -0.000193, -1.404741, -0.000675, -0.000536, -0.630041, 0.646938, -0.000213, 0.360549, 0.706927, -0.091707, -0.007146, 
	-0.020852, -0.005462, -1.115848, 2.732375, 5.681484, -0.002369, -4.678443, -0.007891, -0.004208, -3.342661, -1.852746, -0.002458, 1.671509, -0.687501, 1.695532, -0.060458, 
	-0.014761, -0.010794, -1.108744, 0.397393, 1.637571, -0.002754, 1.413035, -0.015976, -0.006579, -1.106370, -1.612296, -0.002957, 0.046016, -0.840996, 1.418782, -0.190570, 
	-0.050816, -0.007527, 0.929826, 0.168536, -1.281691, -0.002681, 0.791002, -0.023574, -0.005910, -0.142850, -1.086954, -0.004558, 2.177108, -1.373866, 0.040752, -0.126798, 
	-0.036475, -0.020950, 0.758027, -2.143403, 3.458892, -0.007679, 0.289837, -0.035954, -0.015236, 4.199868, -2.694268, -0.007974, -2.032172, 0.489221, -1.930901, -0.270834, 
	-0.023706, -0.008399, 0.288046, -1.909270, -1.752395, -0.001881, -0.945721, -0.009417, -0.004718, 0.462390, -2.569283, -0.001992, 5.992956, 0.031964, 0.534962, -0.083535, 
	-0.009761, -0.008481, -1.107223, -0.522927, 2.040481, -0.002429, 0.601785, -0.007817, -0.004252, -0.966350, -0.507433, -0.002812, -2.017404, -1.176359, 3.735537, -0.044555, 
	-0.004450, -0.006468, -1.972440, 6.088416, -0.523809, -0.000576, -3.200666, -0.004510, -0.002064, -2.545053, 1.256688, -0.000645, -0.841145, -0.791161, 0.793476, 1.754406, 
	-0.009678, -0.008259, 1.367129, 1.575468, 0.333797, -0.001384, -2.764386, -0.017730, -0.003627, -1.651684, -0.244372, -0.001482, 1.757103, -0.952517, 0.658228, -0.036606, 
	-0.007623, -0.002561, 0.405990, 2.070794, -0.197668, -0.000455, -1.014666, -0.001841, -0.001309, -0.815009, 1.249824, -0.000368, -1.011808, -1.302954, 0.690384, -0.060730, 
	-0.010691, -0.004885, 0.509836, 0.964863, 0.246925, -0.001727, 0.341288, -0.019271, -0.003559, -0.710721, -4.971446, -0.001789, 3.196561, 0.380178, 0.114828, -0.030390, 
	-0.017079, -0.014438, -1.805724, 0.651362, -2.621246, -0.009030, -1.558279, -0.020361, -0.011984, -0.205985, -2.006304, -0.009198, 4.076887, -1.804918, 5.424021, -0.067722, 
	-0.014966, 0.005465, 0.990750, -0.230167, 0.056658, -0.000721, -2.258040, -0.012240, -0.002054, -1.197930, 2.935482, -0.000817, 0.595597, -0.962804, 0.215554, -0.119766, 
	-0.012361, -0.004652, 0.325861, 1.336705, 1.379859, -0.001464, -1.876551, -0.009719, -0.002967, -1.984705, -5.363464, -0.001564, 6.812775, -0.841829, 0.309158, -0.065082, 
	-0.228926, -0.054477, -1.455598, 3.440454, 0.386288, -0.010460, -0.562177, -0.064538, -0.028571, -2.674441, -4.041376, -0.011425, 4.276379, 4.534890, -3.666520, 0.160497, 
	-0.130088, -0.043983, -8.663111, -6.255538, 2.772379, -0.026405, -7.567538, -0.063412, -0.036195, -6.590072, 8.901484, -0.027263, -15.855916, 19.698486, 15.771571, -1.884401, 
	-0.002929, -0.005024, -0.512765, -0.249653, -0.231638, -0.000451, 0.081682, -0.003667, -0.002331, -0.120673, 0.276549, -0.000566, -0.961420, 2.301793, -0.541983, -0.026923, 
	-0.004703, -0.003709, -0.780909, 3.417196, -1.859568, -0.001405, 1.792386, -0.004437, -0.002625, 3.911034, 0.442693, -0.001447, -4.881582, -1.827793, -0.140638, -0.054493, 
	-0.055721, -0.043385, -3.503544, 0.113589, 1.710179, -0.012479, -1.436507, -0.053926, -0.025594, -1.162972, 0.000594, -0.013202, 0.614010, 4.482278, 0.067287, -0.680607, 
	-0.024539, -0.009199, 8.183471, -4.402877, -3.247653, -0.004917, 5.936844, -0.010836, -0.007135, -2.839940, -3.352998, -0.005022, -1.853817, 2.481890, -0.719632, -0.123640, 
	-0.037965, -0.019212, -0.708768, 0.163238, 2.737308, -0.020678, -1.455753, -0.024426, -0.014141, 8.428953, -6.445859, -0.021296, 1.572763, -4.712942, 0.267485, 0.291292, 
	-0.086446, -0.056638, 1.897220, -0.103704, 5.918160, -0.021444, 2.222714, -0.072485, -0.038253, -6.123752, -3.250010, -0.022599, 0.943018, 1.202018, -1.735512, -0.672288, 
	-0.003559, -0.003996, -1.194299, -2.081860, 0.324947, -0.001557, -0.439369, -0.004809, -0.002789, 1.951089, 1.746517, -0.001606, 0.850825, -0.715078, -0.407242, -0.017215, 
	-0.138096, -0.073149, -0.479176, 9.367504, -3.869150, -0.060136, 1.891530, -0.088705, -0.054856, 2.338412, -6.120642, -0.317439, -1.913057, -0.731057, -1.851323, 2.099341, 
	-0.065117, -0.035924, -3.613944, 0.426575, 1.258992, -0.009614, -0.143564, -0.046245, -0.022085, -3.538685, 3.423032, -0.010347, -0.225289, 0.880381, 1.906240, -0.184405, 
	-0.147325, -0.028901, -2.241119, -1.155901, -2.556349, -0.017715, -1.772646, -0.021169, -0.016417, 0.371252, 3.549793, -0.018074, 1.872357, -0.217147, 0.001328, 2.398032, 
	-0.000626, -0.001304, -0.027046, 1.099439, -0.031742, -0.000123, -0.050227, -0.003727, -0.000718, -0.590063, 0.096967, -0.000167, -0.175727, -0.312615, -0.000499, -0.001820, 
	-0.000859, -0.000642, -0.114863, 0.545150, -0.214349, -0.000298, -0.004648, -0.000959, -0.000468, 0.259254, 0.259305, -0.000307, -0.310534, -0.269851, -0.140873, -0.005059, 
	-0.006265, -0.004825, -0.277975, 1.540977, -1.565277, -0.001239, -4.772442, -0.007905, -0.003098, 0.137586, 3.115645, -0.001339, 0.526860, 0.352875, 1.111599, -0.145177, 
	-0.010341, -0.004381, -0.956859, 1.975875, 2.531649, -0.001059, -0.485658, -0.006964, -0.002566, 1.971101, -1.742996, -0.001155, -3.217397, -0.443851, 0.453359, -0.058758, 
	-0.089602, -0.012900, 1.023240, -1.273864, -1.830280, -0.003785, 1.452654, -0.017413, -0.008297, -3.454863, 3.971256, -0.004097, -1.852797, 4.367507, -2.442221, 0.175462, 
	-0.007809, -0.005194, -0.298032, -1.646085, 0.375825, -0.001287, -3.701499, -0.007381, -0.003425, 0.741221, 4.191880, -0.001352, -1.584392, 2.106832, -0.103279, -0.056024, 
	-0.013359, -0.007105, -0.577326, -1.850989, 6.240059, -0.001922, 1.933075, -0.008716, -0.004271, -0.007833, -0.301491, -0.002541, -4.078009, -0.474194, -0.555306, -0.290073, 
	-0.013760, -0.003489, -0.357220, 1.201376, 0.917425, -0.001248, 1.003558, -0.009828, -0.002954, 0.199204, -0.498011, -0.001311, -1.167396, -0.574688, -0.677019, -0.014640, 
	-0.000220, -0.000340, -0.021587, -0.067571, -0.347333, -0.000229, 0.602416, -0.000418, -0.000274, 0.023898, 1.814844, -0.000220, -2.088839, -0.014206, 0.131242, -0.031163, 
	-0.004751, -0.001556, -0.184889, -0.046713, -0.314619, -0.000580, 0.495929, -0.004884, -0.001198, -0.826532, 0.126695, -0.000609, -0.507752, 2.058420, -0.765657, -0.021303, 
	-0.005688, -0.001370, -0.262899, 0.925063, -0.058926, -0.000561, 1.282331, -0.003135, -0.001013, -0.323031, 0.287496, -0.000570, -2.298808, 0.590128, -0.070232, -0.058785, 
	-0.009643, -4.270739, 0.186916, 0.298355, 1.433461, -0.004931, -1.365935, 4.581666, -0.008164, -0.460080, 0.532492, -0.005047, -1.097095, 0.324666, -0.125502, -0.010421, 
	-0.396223, -0.078830, -0.716520, -0.643817, 2.016624, -0.037155, -3.942944, -0.227510, -0.085808, -1.145917, 3.339336, -0.040150, 1.556333, -1.300236, 1.821052, -0.118236, 
	-0.015134, -0.011280, -0.647528, 8.872860, -2.190333, -0.003710, 1.930430, -0.010172, -0.007387, -3.795003, -5.746115, -0.003920, 2.332952, -2.306232, 1.682207, -0.081635, 
	-0.003054, -0.001640, 0.255143, 0.003958, -0.742753, -0.000723, -0.904960, -0.003369, -0.001326, -1.056094, -1.518906, -0.000756, 2.189338, -0.192792, 2.003014, -0.025081, 
	-0.006398, -0.004361, -0.440969, -2.044645, -0.853817, -0.003276, 0.275495, -0.005375, -0.004015, 4.882945, -0.236812, -0.003299, -1.203176, -0.947740, 0.638274, -0.042829, 
	-0.063139, -0.051243, -2.615457, 3.945544, 1.691788, -0.013258, -0.379663, -0.046114, -0.027089, 0.986306, -1.589459, -0.013998, -2.492706, -2.333518, 3.442754, -0.440748, 
	-0.009670, -0.008093, -2.145340, 2.922745, 2.760011, -0.001749, -2.223938, -0.007692, -0.004233, 0.461755, -1.975305, -0.001808, -1.954942, -0.537687, 2.756837, -0.030891, 
	-0.003094, -0.002381, 3.430621, 0.028515, -0.866083, -0.000616, -0.267517, -0.007056, -0.001651, -1.115077, 0.451545, -0.000677, -2.190768, 1.096642, -0.526535, -0.025866, 
	-0.007395, -0.003873, 0.025866, -1.253585, -0.393772, -0.001687, -0.379471, -0.064039, -0.004073, 1.915120, 2.945909, -0.001752, -1.353092, -0.682977, -0.717559, -0.023620, 
	-0.000881, -0.000860, -0.329469, 0.376421, -0.010737, -0.000758, -0.125097, -0.000929, -0.000821, -0.184557, -0.284465, -0.000749, -0.153580, -0.061089, 0.780068, -0.002496, 
	-0.009046, -0.003613, -1.453366, -0.928531, -0.512058, -0.001417, 3.450954, -0.006526, -0.002671, 2.234352, 1.228133, -0.001446, -4.174227, 1.276066, -1.072317, -0.024288, 
	-0.001880, -0.001883, 0.026823, -1.165696, 0.060643, -0.000524, -0.089086, -0.001125, -0.000920, 1.628150, 0.209810, -0.000560, -0.655002, -0.343986, -0.092208, 0.427445, 
	-0.064705, -0.017636, -1.605766, 3.169091, -1.527112, -0.006275, -1.028943, -0.034926, 0.030280, 4.435451, -1.086841, -0.006658, -3.293429, 2.712610, -1.545765, -0.129376, 
	-0.033729, -0.022872, 3.927098, -2.333586, -3.667416, -0.009643, 0.947992, -0.027122, -0.015741, -0.545534, 1.634205, -0.009795, 2.096718, -1.674048, -2.140108, 1.873582, 
	-0.023427, -0.005834, -3.016928, -1.240013, -2.825762, -0.001477, 0.119071, -0.009494, -0.003307, 4.814029, 5.949080, -0.001595, -1.881069, -1.710453, -0.066964, -0.095856, 
	-0.020136, -0.007841, 0.703890, 1.007063, -0.291100, -0.002096, 0.105677, -0.008205, -0.004540, -0.975142, 1.235170, -0.002302, -1.299552, -0.315575, -0.073608, -0.051702, 
	-0.006183, -0.003219, -0.736033, 0.317134, -1.264027, -0.002395, -0.875565, -0.003584, -0.002267, 0.958502, 2.278509, -0.002454, -1.842921, -0.818367, 1.991161, 0.011708, 
	-0.087401, -0.011985, -0.746293, 1.327242, 0.088094, -0.003192, 1.253117, -0.010244, -0.006560, 2.058606, -3.927774, -0.003503, 0.995231, -0.449339, -0.395903, -0.080097, 
	-0.010790, -0.012349, -0.234260, 0.562727, -0.666304, -0.002984, 4.650959, -0.006925, -0.006985, -1.048918, -1.948575, -0.003119, -2.378307, 1.227176, 0.281071, -0.402418, 
	-0.079209, 1.345723, -1.095060, -0.309688, -0.158764, -0.005539, 0.765333, -1.382297, -0.014756, -0.673402, 1.236816, -0.006166, 0.209808, 1.238757, -0.679444, -0.392111, 
	-0.020577, 0.002116, -0.317535, 5.828697, 1.314513, -0.003152, -1.539434, -0.019645, -0.007027, -3.686547, 2.274381, -0.003338, -3.844847, 0.039678, 0.109848, -0.127131, 
	-0.053490, -0.023336, 5.954489, -0.070688, -3.775209, -0.008269, 0.371367, -0.044830, -0.015467, 0.140756, -2.722015, -0.008680, -0.249242, -0.610707, -0.453934, 1.569254, 
	-0.112400, -0.091178, -4.728280, 2.164385, -0.617732, -0.015851, -3.614286, -0.173373, -0.049407, 2.087725, 4.369031, -0.017932, 2.384186, 3.405825, -3.989748, -1.000966, 
	-0.032557, -0.005598, 0.295473, 1.193698, 1.383298, -0.001739, -2.415968, -0.020541, -0.004174, -0.429090, 2.007246, -0.001864, -2.508809, 0.054037, 0.633115, -0.146528, 
	-0.009574, -0.008927, 0.553003, 1.049791, -1.717922, -0.002577, -1.920164, -0.008857, -0.006892, -1.256115, 1.999192, -0.002760, 1.398176, 0.161156, -0.165986, -0.061543, 
	-0.040485, -0.013247, -3.281620, -0.660994, -2.709598, -0.003508, -1.081693, -0.014852, -0.008317, 2.163174, 2.023487, -0.003727, 2.989744, -1.158726, 1.911229, -0.110867, 
	-0.006729, -0.005867, -0.379668, 0.578089, 2.916514, -0.000902, -0.905833, -0.009512, -0.003583, 1.709595, 0.069500, -0.000991, -0.086316, -2.867902, -0.630841, -0.375555, 
	-0.005264, -0.004132, 1.150847, -0.777571, -0.977299, -0.000909, 2.875374, -0.004594, -0.002469, 1.023644, -0.042258, -0.000987, -2.418072, -0.806706, 0.010212, -0.019816, 
	-0.010562, -0.003463, 2.824312, 0.089241, -0.406053, -0.001437, -0.384674, -0.003500, -0.002329, -1.906705, -0.025071, -0.001481, -0.355264, -0.003573, 0.213730, -0.023172, 
	-0.034170, -0.008006, 2.365954, -1.045216, 1.307252, -0.002423, -4.599211, -0.049089, -0.006141, -1.634499, 5.277538, -0.002600, -3.838783, 3.468805, -1.131508, -0.067903, 
	-0.055718, -0.009623, -1.165323, -1.083764, -0.524331, -0.003084, 5.165364, -0.058276, -0.010408, -0.343637, -0.228374, -0.005691, -0.197934, -1.004003, -0.331763, -0.143434, 
	-0.006581, 0.288374, -0.949609, 3.047032, 1.376081, -0.001748, -2.083432, -0.274511, -0.002780, -0.301155, -5.557625, -0.001761, 5.895051, -0.778077, -0.847852, 0.198593, 
	-0.045680, -0.016079, 0.463783, 4.805462, 3.072135, -0.006156, 0.159148, -0.030847, -0.011759, -2.235752, 5.710691, -0.006343, -10.423105, -0.359316, -0.966528, -0.109656, 
	-0.022543, -0.007439, 0.187018, 0.351283, 1.037004, -0.001749, -1.043330, -0.015088, -0.004805, 2.181279, -0.160986, -0.001886, -0.381962, -0.943443, -1.091835, -0.081518, 
	-0.021393, -0.006664, -0.054668, -3.073524, -0.529162, -0.002935, -4.238768, -0.007416, -0.004653, 0.161782, 4.220344, -0.003003, 0.154555, 3.764816, -1.107868, 0.748557, 
	-0.013406, -0.012917, 0.560390, -1.545662, 0.344581, -0.001926, 3.257120, -0.006360, -0.005001, -0.996244, 0.197066, -0.006631, 0.250305, -0.382165, -1.610454, -0.028697, 
	-0.194402, -0.016600, -2.136004, -1.645246, -6.823439, -0.005896, 10.545770, -0.015988, -0.011175, -0.702474, 11.795455, -0.006057, -14.955440, 1.128618, 3.218138, -0.175260, 
	-0.001851, -0.001757, 0.416630, -0.181340, -0.032831, -0.000495, -0.577622, -0.002336, -0.000974, -0.068585, -1.810609, -0.000527, 1.938263, -0.330545, 0.672291, -0.017712, 
	-0.054486, -0.010010, 2.665369, -3.818035, -1.095877, -0.004350, 4.486169, -0.088260, -0.009875, -0.023264, 0.058937, -0.004692, -0.080273, -1.107009, -0.793709, -0.120634, 
	-0.008750, -0.004416, -0.946358, 0.746142, -0.230673, -0.000667, -0.594368, -0.004885, -0.001971, 2.085907, 1.838669, -0.000759, -1.148859, -0.331483, -1.377453, -0.020075, 
	-0.011368, -0.006670, 1.155686, -1.168717, -0.337119, -0.002283, 0.185145, -0.012346, -0.000553, 1.266652, 0.036228, -0.002433, 0.267625, 0.300888, -1.605373, -0.065362, 
	-0.012450, -0.012197, -1.284656, 1.053161, -0.591144, -0.001706, 0.655156, -0.007414, -0.004951, 1.751210, 1.346241, -0.001964, -4.191948, 1.531003, -0.132584, -0.095757, 
	-0.007905, -0.007174, -0.197608, -0.056083, 3.361578, -0.001559, -0.361366, -0.006939, -0.003780, -0.143727, -1.690764, -0.001689, 0.096508, -0.599313, -0.340359, -0.039821, 
	-0.000604, -0.000401, 0.277052, 0.480321, -0.111318, -0.000173, 1.632150, -0.000576, -0.000356, 0.115243, -0.695256, -0.000158, -0.827611, -0.967417, 0.105931, -0.006829, 
	-0.005605, -0.005087, 3.434559, 0.360958, -2.955804, -0.001748, 2.306593, -0.006112, -0.003283, -2.396248, 4.391517, -0.001810, -4.864775, -0.718701, 0.526943, -0.061395, 
	-0.051437, -0.027066, 0.047207, 0.980165, 1.387431, -0.005221, -0.174317, -0.026448, -0.013659, 0.726540, 1.587025, -0.005485, 1.129111, -2.827972, -2.411417, -0.314459, 
	-0.029734, -0.009974, -0.843170, 1.554678, -2.298517, -0.001607, -1.713128, -0.012434, -0.005457, 1.521781, -0.433172, -0.001868, 0.958677, 0.305426, 1.079243, -0.070744, 
	-0.002958, -0.000849, 0.019806, 0.650535, -1.090242, -0.000483, -0.295656, -0.000946, -0.000679, -0.647465, 0.253505, -0.000493, 1.118386, -0.042603, 0.042307, -0.002165, 
	-0.041478, -0.034677, 2.845568, -0.200362, -2.622670, -0.012840, -0.898677, -0.048813, -0.024494, 6.696142, 0.806771, -0.017494, -4.727401, -2.898234, 1.676648, -0.497990, 
	-0.007513, -0.003994, -0.444549, 1.724203, -0.615905, -0.000603, -1.867686, -0.009719, -0.001907, -0.756174, 2.852967, -0.000682, -0.245009, -0.642245, 0.062026, -0.043209, 
	-0.008975, -0.009248, 0.610518, -0.833670, -0.643781, -0.001981, -0.944800, -0.040487, -0.004907, -1.334574, 7.144724, -0.002084, -4.382165, 0.921892, -0.421123, -0.049339, 
	-0.270021, 4.751843, 4.489847, -1.160108, -2.030910, -0.043535, 2.693908, -4.707682, -0.097447, -3.615365, -0.440677, -0.045376, -2.159658, 0.275809, 3.985615, -1.626242, 
	-0.005448, -0.002556, -1.695369, 0.504629, 0.207433, -0.000883, -0.355839, -0.003313, -0.001764, 2.167422, -1.448540, -0.000937, 1.125870, -0.031180, -0.433612, -0.025913, 
	-0.170875, -0.004330, -0.055677, -0.198223, -1.130913, -0.009848, 1.691939, -0.005415, -0.002579, -0.643251, -2.111682, -0.011028, -0.242413, -0.457143, 3.476322, -0.124883, 
	-0.005349, -0.004737, 0.206818, -0.342445, 1.363899, -0.001102, 1.817817, -0.003174, -0.002041, -0.596581, -1.539774, -0.001192, -2.118831, 0.429862, 0.809385, -0.012555, 
	-0.030737, -0.009403, -0.989027, -1.242374, 7.532707, -0.003473, -0.348026, -0.026556, -0.005987, -0.765999, -3.372672, -0.003589, 0.061492, -0.734231, 0.011253, -0.073376, 
	-0.029152, -0.010744, -0.368493, -1.869480, -2.737391, -0.003676, 1.801733, -0.009886, -0.006634, 2.198286, -0.388491, -0.008182, 0.589062, 0.853727, 0.294960, -0.305640, 
	-0.015219, -0.004836, 0.242735, 0.217011, -0.427224, -0.001793, -1.001376, -0.006068, -0.003290, -1.054778, 2.365368, -0.001946, -1.623881, -0.871428, 2.242233, -0.055507, 
	-0.007517, -0.002440, -2.184236, -0.013839, -1.855715, -0.000918, -0.477849, -0.004388, -0.001941, 4.084126, 2.762442, -0.000999, -2.818530, 0.686387, -0.082617, -0.081967, 
	-0.032334, -0.001251, -0.013199, -0.175546, 0.155787, -0.000450, 1.001247, -0.000918, -0.000774, -0.401833, 0.947167, -0.000433, -1.286092, 0.147523, -0.330197, -0.008699, 
	-0.325963, -0.179537, 1.242602, 0.917988, -2.156931, -0.084396, 7.062168, -0.263915, -0.114382, -1.981466, 1.732675, -0.476121, -2.209894, -1.100298, -9.606336, 7.543807, 
	-0.037330, -0.015796, -1.576017, 4.354342, -0.780160, -0.004376, -6.840953, -0.053216, -0.009332, 0.335518, 3.101903, -0.004563, 1.400352, 1.052153, -0.892891, -0.029632, 
	-0.049361, -0.016996, 0.648511, -3.256896, 1.253116, -0.004041, 2.614779, -0.030656, -0.010392, 0.416383, 1.241691, -0.004358, -1.956223, -0.478385, -0.266190, -0.100981, 
	-0.013824, -0.014660, -2.106414, 1.248870, 6.811117, -0.005279, -2.764061, -0.008880, -0.007246, 0.313496, -0.102011, -0.005483, -2.349490, 0.323294, -4.354172, 3.034741, 
	-0.034646, -0.008365, 9.817099, -0.966243, -0.477812, -0.002966, 3.599344, -0.011700, -0.005836, -2.353160, -4.062973, -0.003183, 0.521834, -3.086659, -2.856019, -0.068713, 
	-0.373603, -0.137856, 4.254382, 3.810204, 1.898896, -0.040027, -0.283439, -0.200384, -0.079772, -2.121487, -12.246697, -0.042158, 4.862052, 6.551877, -4.238843, -1.613145, 
	2.160989, -0.062630, -4.455677, 0.570282, 11.360298, -0.025646, 2.142849, -0.081524, -0.041707, -2.561174, 6.818089, -0.026567, -5.981987, -5.267756, -4.399697, -0.148145, 
	-0.006489, -0.003940, -0.555249, -0.305574, 0.345933, -0.001075, 2.813831, -0.003390, -0.002277, -0.222904, -0.549456, -0.001203, -1.304719, -0.052039, -0.128775, -0.022676, 
	-0.022938, -0.013233, -0.817316, -0.112305, 3.197379, -0.001628, 1.017596, -0.023878, -0.006274, -1.170592, 0.882647, -0.001862, -2.302046, 0.327856, -0.855142, -0.098264, 
	-0.001110, -0.001046, 0.668951, 0.601168, 0.194250, -0.000459, -0.326022, -0.001134, -0.000777, -1.245460, -0.529393, -0.000477, 0.749714, 0.253787, -0.311307, -0.050686, 
	-0.105722, 0.528062, -1.089245, 4.208406, -1.835494, -0.011252, -2.647506, -0.162132, -0.028438, 5.417213, -5.588939, -0.012612, 3.678204, -3.150359, 1.421402, -0.621589, 
	-0.010981, -0.004003, -0.968586, -0.554933, 0.907589, -0.001815, -3.276040, -0.004881, -0.002601, 0.752954, -1.229002, -0.001923, 3.644590, 1.220895, -0.455174, -0.016087, 
	-0.027502, -0.043415, -1.267096, 0.754377, -1.585451, -0.003913, 0.541491, -0.022017, -0.010242, -0.805479, 0.833415, -0.004181, 2.426191, 0.378131, -0.842715, -0.321594, 
	-0.010588, -0.012926, 1.944976, -3.122875, -0.114035, -0.002305, -2.442352, -0.011597, -0.005294, 2.236114, -0.195436, -0.002592, 0.043643, 1.645396, 0.117536, -0.067663, 
	-0.002684, -0.001712, -0.130731, -0.445970, 0.320822, -0.000481, 1.636414, -0.001036, -0.000852, 1.449621, 0.084659, -0.000484, -1.686856, -0.870476, -0.340777, -0.009457, 
	-0.099623, -0.057227, -1.588426, -1.491958, 2.077900, -0.020192, -5.908458, -0.102235, -0.033705, -1.283054, 4.376993, -0.020892, -2.621787, 1.505241, 6.333247, -1.065824, 
	-0.009837, -0.007738, -1.403707, -1.156462, 4.513834, -0.002278, -2.949792, -0.005653, -0.004384, 0.751538, 2.839598, -0.002413, -2.494869, 1.771401, -1.634708, -0.204528, 
	-0.021083, 0.267337, 4.387764, -2.272692, -3.897626, -0.003474, -2.274604, -0.142584, -0.008992, -0.480772, -0.401066, -0.003839, -2.314372, 3.808583, 3.449040, -0.091620, 
	-0.016481, -0.004112, 1.794590, -0.712921, -0.721088, -0.001820, -3.142615, -0.005935, -0.003138, -0.231419, 0.701361, -0.001880, 0.061031, 0.413676, 1.884987, -0.014237, 
	-0.019208, -0.007664, 0.608536, -1.389975, -0.957013, -0.003142, 1.578321, -0.014262, 0.035358, -0.974089, 1.124408, -0.003264, 1.006234, -0.486845, -0.354364, -0.143032, 
	-0.036599, -0.017275, -0.312968, -0.764982, 2.347324, -0.006141, 0.632931, -0.023573, -0.012371, 4.996589, -1.234727, -0.006601, -4.550021, 0.404449, -1.332952, -0.083083, 
	-0.009155, -0.002294, 0.329693, 0.622163, 1.337237, -0.000520, -1.147964, -0.004654, -0.001657, -0.576739, 0.619478, -0.000558, -0.677580, -0.753773, 0.291684, -0.025361, 
	-0.343884, -0.098212, -5.518331, -5.379858, 12.975904, -0.030759, -8.736744, -0.151709, -0.060106, 2.668643, 7.647450, -0.040147, 10.130713, -3.849136, -6.664507, -2.549318, 
	-0.011690, -0.005212, -1.199860, 0.423531, 2.745948, -0.001507, -3.852309, -0.011900, -0.003508, -0.524950, -0.510709, -0.001636, 3.804771, -0.504754, -0.316526, -0.029689, 
	-0.034718, -0.007654, 6.537249, 0.539847, -1.391220, -0.005021, -1.829049, -0.007850, -0.006634, -1.670069, -0.236501, -0.005075, -0.650372, -1.383561, -1.096863, 1.247489, 
	-0.001758, -0.002073, 0.454000, -0.008582, -0.718109, -0.000477, 0.022669, -0.002181, -0.001286, 0.721305, 2.164381, -0.000508, -1.997594, -0.150953, -0.458599, -0.020235, 
	-0.024598, -0.015791, -2.627591, -0.307332, 0.842609, -0.004137, -3.089018, -0.051143, -0.010131, 3.832451, 1.682843, -0.004484, 0.005813, -1.034349, 0.962917, -0.158058, 
	2.373531, -0.000038, 1.018199, 0.175378, -7.948397, -0.005128, 11.350974, -0.054026, -0.013612, -3.784580, -1.606844, -0.005789, 1.222758, -2.267148, -0.207567, -0.247713, 
	-0.172587, 0.148242, 0.044170, 0.279565, 0.753229, -0.015515, 1.744962, -0.145177, -0.040240, 2.324554, -2.411842, -0.021389, 1.081325, 3.994283, -5.490865, -2.072717, 
	-0.032577, -0.019593, 0.255520, -2.204485, 1.414515, -0.004120, -3.470471, -0.031467, -0.010499, 1.654486, 6.041717, -0.004234, -0.457848, -1.573282, -1.147080, -0.410581, 
	-0.004134, -0.003919, 0.123343, -0.969514, 0.790767, -0.000405, -0.227251, -0.020746, -0.001829, -0.090831, -1.292524, -0.000495, -0.309826, 1.932817, 0.077625, -0.003078, 
	-0.033404, -0.017223, -0.986216, 2.047933, 5.634499, -0.005106, -1.032628, -0.019865, -0.011441, 1.031519, 0.983246, -0.005439, -2.645823, -1.631353, -2.977495, -0.331204, 
	-0.413850, -0.086067, 0.852949, -2.930311, -0.913404, -0.042798, 3.676684, -0.319076, -0.098697, -0.984336, 1.087578, -0.050430, -3.253528, 1.565020, 2.634594, -0.724327, 
	-0.005191, -0.004988, -0.352724, 1.692749, -1.178662, -0.001342, 2.529830, -0.007476, -0.003066, -1.534490, 2.593273, -0.001422, -2.207141, -0.246753, -1.240248, -0.032349, 
	-0.012604, -0.002701, -0.216843, 0.806335, 3.063440, -0.001113, -1.654779, -0.004725, -0.002035, -0.184195, -4.472617, -0.001165, 1.692543, -0.355395, 1.381993, -0.036138, 
	-0.002563, -0.001666, 2.089458, -0.421326, -0.339305, -0.000736, -1.393273, -0.003374, -0.001706, 0.381212, 0.149388, -0.000663, -0.173910, -0.142287, -0.132116, -0.007132, 
	-0.005568, 0.000321, -0.582623, -0.354918, -0.824786, -0.000897, -0.556406, -0.006147, -0.001891, 0.476381, -2.759440, -0.001150, 4.454162, 0.449002, -0.274239, -0.011800, 
	-0.004505, -0.005045, 1.705711, -0.011903, -0.673212, -0.001818, -0.173137, -0.005872, -0.003211, -0.420574, 0.541366, -0.001882, -1.617837, 1.101220, -0.376874, -0.052426, 
	-0.005442, -0.003707, -1.102988, 1.231983, -2.549544, -0.001106, 1.102943, -0.004717, -0.002625, 2.823920, 0.910646, -0.001158, -2.664468, -0.366629, 0.685293, -0.052400, 
	-0.036105, -0.016021, -2.475577, 1.157076, -1.982197, -0.003663, -2.569992, -0.054683, -0.009379, 0.703731, -0.465892, -0.004386, 2.321397, 1.346383, 2.246477, -0.157169, 
	-0.005698, -0.008653, 1.209606, 0.898105, 0.556086, -0.002079, -1.906602, -0.005257, -0.003681, 0.146427, -0.851720, -0.001684, 0.819154, -1.279787, 0.487422, -0.051640, 
	-0.166233, -0.062837, -3.289019, 4.478627, -1.908596, -0.016244, 1.811822, -0.093645, -0.040407, 1.012889, -0.634306, -0.017211, 6.300966, -3.294882, -2.942219, -1.138708, 
	-0.034850, -0.012604, 5.096849, 2.114691, 0.054760, -0.003632, -1.710135, -0.015511, -0.008184, -1.793878, -4.080343, -0.003798, 2.469383, -2.273659, 0.332264, -0.131356, 
	-0.020477, -0.008897, -1.950363, -2.595792, 0.668060, -0.001993, -0.481850, -0.010860, -0.004602, 3.078154, -4.335611, -0.002231, 3.826567, 2.694199, -0.822092, -0.032213, 
	-0.003208, -0.001407, 1.023654, -0.417301, 0.683342, -0.001128, -0.052646, -0.001667, -0.001173, -0.195470, -0.930769, -0.001149, 0.104330, -0.675740, -0.377583, 0.847912, 
	-0.030711, -0.007611, -1.163572, -0.401769, -0.676784, -0.002968, -0.846979, -0.056112, -0.007017, -0.440214, -2.828971, -0.003124, 3.095655, 1.793076, 1.618206, -0.041104, 
	-0.033265, -0.033543, -2.220415, 0.103410, 5.211501, -0.005904, -0.349691, -0.019229, -0.014206, -2.739366, -1.353636, -0.006015, 2.432747, -0.273771, -2.779600, 2.080984, 
	-0.173894, 0.182649, -7.773275, -4.823589, -0.930717, -0.026938, 2.225130, -0.224372, -0.057962, 0.361086, 2.149396, -0.031489, 5.937169, 4.516628, 0.461526, -1.791350, 
	-0.056751, -0.012168, 3.260806, -2.139518, 2.004426, -0.003677, -3.129967, -0.031431, -0.013618, 0.133189, 2.775808, -0.004210, -0.183130, -0.811739, -1.708743, -0.079275, 
	-0.009442, -0.008912, 2.339592, -0.519058, -1.023360, -0.002671, 1.803292, -0.006367, -0.004574, -2.208614, 6.454080, -0.002805, -7.623173, 0.864280, 0.319712, -0.371980, 
	-0.008346, -0.003604, 2.144382, 0.568402, 0.778991, -0.001481, -2.987011, -0.004081, -0.002527, -1.022246, 1.348885, -0.001523, -0.308609, -0.659283, 0.182293, -0.024241, 
	-0.007843, -0.004101, -0.406177, 1.559695, -3.484578, -0.002090, 0.281327, -0.005136, -0.003251, -0.376884, -0.500856, -0.002158, 3.365136, -0.263652, -0.095651, -0.053782, 
	-0.005398, -0.001693, -0.217219, 1.774063, -0.486925, -0.000769, 1.443479, -0.003046, -0.001340, 0.252004, 1.736015, -0.000803, -4.011537, -0.009141, -0.459864, -0.007826, 
	-0.039827, -0.026909, -3.287266, -3.114772, 0.407042, -0.006738, 21.889378, -0.031892, -0.014670, 1.390784, -4.921159, -0.007186, -8.957577, -2.414283, -0.013087, -0.851837, 
	-0.027567, -0.012137, 4.455871, 0.986921, -1.797477, -0.004051, 2.019386, -0.027588, -0.008898, -3.321045, 0.237578, -0.004459, -0.191826, -1.267769, -0.755229, -0.281711, 
	-0.008806, -0.002769, 1.392662, 0.112217, -0.030291, -0.001182, -1.102538, -0.004579, -0.002111, -0.372614, -2.438245, -0.001225, 0.528939, 0.674805, 1.278959, -0.023220, 
	-0.010938, -0.009649, -0.819116, -0.886324, -0.746896, -0.002853, -5.490667, -0.014751, -0.006173, -1.474933, 2.880784, -0.002786, 3.579770, 0.920426, 2.234688, -0.150582, 
	-0.037533, -0.016321, 5.293926, -0.406997, -0.987816, -0.008843, -1.080312, -0.018084, -0.012902, -3.385115, -3.785002, -0.009215, -0.799163, 0.673023, 4.785758, -0.205402, 
	-0.001498, -0.000613, -0.174228, 0.003121, 0.417256, -0.000208, -0.510546, -0.001159, -0.000398, -0.778403, -1.158465, -0.000178, 2.222608, -0.032764, 0.019320, -0.003844, 
	-0.022211, -0.025249, -2.203140, 2.131392, -2.452155, -0.007131, -1.342812, -0.025294, -0.014196, 3.427275, 0.954338, -0.136824, -4.212707, -0.094353, 4.762859, -0.739793, 
	-0.039135, -0.016929, -0.665768, -0.860021, -0.927912, -0.003914, -1.157481, -0.013914, -0.007321, -0.549029, 3.681701, -0.004158, -2.728930, 1.779715, 1.572409, -0.059313, 
	-0.001880, -0.001566, -1.515979, 0.955058, 0.973089, -0.000403, -0.266815, -0.002435, -0.000909, 1.814951, -0.596346, -0.000518, -1.046072, -0.265516, -0.012708, -0.031952, 
	-0.022904, -0.010194, -3.137776, -2.274012, -0.719445, -0.005753, 1.603308, -0.029282, -0.008321, 6.198483, -0.561877, -0.139632, -2.147086, -0.219322, 1.536310, -0.062498, 
	-0.067676, -0.008275, 0.637350, 0.906370, 2.263149, -0.002070, 1.304914, -0.010659, -0.005063, -2.263468, 2.289620, -0.002199, -4.446053, -0.881188, 0.300837, -0.015589, 
	-0.060007, -0.010389, 1.154502, 0.046926, -0.831621, -0.002216, 0.560620, -0.052504, -0.006434, -2.815385, 3.138317, -0.002543, -2.977724, 0.951369, 0.991769, -0.084680, 
	-0.005050, -0.004522, 0.375494, -2.173203, -0.626723, -0.001073, 3.431988, -0.006281, -0.008186, 0.374363, -0.014605, -0.001156, -0.144130, -0.058804, -1.091442, -0.046672, 
	-0.006578, -0.003196, 1.380654, 1.341392, 2.745276, -0.001146, -2.585740, -0.004675, -0.002304, -2.464831, -0.512904, -0.001189, 0.740015, -0.081767, -0.520192, -0.022816, 
	-0.022803, -7.288089, -1.445698, -0.503774, 4.665954, -0.005625, -0.656708, 7.522412, -0.008546, 0.313508, 5.870913, 0.043121, -8.306195, -0.159666, -0.037127, 0.018324, 
	-0.070249, -0.031155, -2.678552, -1.300702, -3.007047, -0.005600, 0.014269, -0.023498, -0.012790, -2.124643, 3.084197, -0.005890, 4.443193, 1.376443, 0.659732, -0.317709, 
	2.428649, -0.004633, 0.404359, -0.889959, 1.951651, -0.002886, -0.875568, -0.005494, -0.003407, 0.751294, -1.517065, -0.003079, -1.258137, -0.057729, -0.807806, -0.110189, 
	-0.011617, -0.004249, -1.717719, -0.653543, -0.590342, -0.002274, -1.011837, -0.004893, -0.003403, 3.505439, -1.341376, -0.002559, 2.293452, -0.311230, -0.109691, -0.034157, 
	-0.096169, -0.029414, -4.672811, -0.130477, -3.818209, -0.009735, 1.066680, -0.053066, -0.020181, 2.530863, 0.381304, -0.010204, -2.150187, 1.628539, 5.810127, -0.427059, 
	-0.015756, 0.023889, 0.875571, 1.382532, 0.141577, -0.004071, 0.193101, -0.007449, -0.006469, -0.877167, -3.578402, -0.004131, 2.918144, -1.837521, 0.173948, 0.622204, 
	-0.025979, -0.010546, -0.741234, -0.727685, -2.554136, -0.004409, -0.231796, -0.009712, -0.007082, 1.027156, 7.619093, -0.004488, -6.337124, 2.826348, -0.688926, -0.129482, 
	-0.044785, -0.018214, -0.119888, -4.264149, 4.227727, -0.007354, -3.750844, -0.062442, -0.014897, -3.156784, 6.453877, -0.007749, -1.841593, -1.756750, 4.624077, -0.260232, 
	-0.009852, -0.005890, 0.555440, -2.640825, -2.035186, -0.001948, -0.476924, -0.006616, -0.003682, -0.153310, -1.929938, -0.002059, 4.335122, 1.740620, 0.772559, -0.137512, 
	-0.001584, -0.000863, 0.275704, 0.607578, 0.065144, -0.000229, -0.251776, -0.000727, -0.000538, -0.183043, 0.908383, -0.000246, -1.362319, -0.091178, 0.042841, -0.007146, 
	-0.004446, -0.004158, -0.510741, -1.443386, 1.907590, -0.001591, 0.971061, -0.003950, -0.002548, 0.832885, -2.619136, -0.001619, 0.596017, 0.516986, -0.164128, -0.068836, 
	-0.062942, 0.779713, 4.921223, -1.319670, -1.784981, -0.009742, -2.235876, -0.174568, -0.015395, 3.592360, -1.180740, -0.009791, -1.061281, -3.327816, 0.961688, 0.927817, 
	-0.004743, -0.003295, -0.015325, -0.458619, -0.249482, -0.001583, 5.208591, -0.004146, -0.002451, -0.216949, -8.069139, -0.001601, 4.568531, -0.156663, -0.507942, -0.085186, 
	-0.006109, -0.004944, 1.071000, -0.635500, 0.616394, -0.001264, 0.213913, -0.004262, -0.002825, 0.052889, -0.055710, -0.001406, -1.309211, -1.310730, 1.468331, -0.090566, 
	-0.000740, -0.000569, -0.093194, -0.048236, 2.869598, -0.000344, 0.703233, -0.000556, -0.000449, -0.275276, -0.513100, -0.000350, -2.452369, -0.076449, -0.017292, -0.093907, 
	-0.013813, -0.005262, -1.197567, 3.030044, 3.510382, -0.002659, -1.598807, -0.017556, -0.004330, -1.202487, 0.832781, -0.002752, -3.571890, -1.297864, -0.219664, 1.761445, 
	-0.656480, -0.233887, -2.239582, 0.522824, -0.950920, -0.093912, -0.857760, -0.554647, -0.207236, 2.364347, -0.182365, -0.053591, -0.913243, 2.044600, 1.170521, 0.841329, 
	-0.039074, -0.010599, -1.568775, 2.075118, -1.119213, -0.002500, 1.135017, -0.021696, -0.006866, 4.436645, -1.485016, -0.002767, -0.196898, -1.787169, -1.283252, -0.122952, 
	-0.001942, -0.001690, -0.617782, -1.299032, -0.315792, -0.001028, 0.017732, -0.001361, -0.001326, 2.228785, 0.019093, -0.001035, -0.045917, -0.193697, 0.223890, -0.008899, 
	-0.064239, -0.014880, -0.060155, 2.195012, 0.371700, -0.004615, -2.820282, -0.021881, -0.010583, 0.316758, -0.992672, -0.004904, -1.696921, -0.332437, 3.285831, -0.145734, 
	-0.017273, -0.010272, -0.777267, 7.184725, -2.638595, -0.003281, -0.333785, -0.016225, -0.007260, -2.533999, 2.520180, -0.003410, -0.817639, -4.014229, 1.648155, -0.179826, 
	-0.023099, -0.013234, 1.244749, -0.171933, 0.873831, -0.003215, 2.047163, -0.011016, -0.006799, -0.937278, -0.996718, -0.003322, -5.069901, 2.156843, 1.084545, -0.170617, 
	-0.148259, -0.009589, -0.834976, -1.016942, 3.594460, -0.003770, 3.992359, -0.008604, -0.006253, -1.939007, -0.780437, -0.003869, -0.364843, -0.988899, -1.340539, -0.140834, 
	-0.323413, -0.105130, 2.020528, 3.207237, -1.035231, -0.038762, 1.616672, -0.233496, -0.081342, -1.209844, -0.772679, -0.043351, 0.511668, 1.582266, -3.946429, -1.148695, 
	-0.081226, -0.022421, -0.039351, -4.260323, 1.108092, -0.004342, 0.118745, -0.011153, -0.008970, 5.163095, 0.809107, -0.004472, -3.423798, 2.063460, -0.581378, -0.825064, 
	-0.059253, -0.004514, -0.774214, 0.174683, -1.108383, -0.001289, -3.028982, -0.006174, -0.002823, 0.024389, -0.508441, -0.001430, -0.324540, 1.964938, 3.705617, -0.049585, 
	-0.018111, -0.013368, -1.074386, -0.163812, -0.008298, -0.002902, 0.675881, -0.016203, -0.008888, 1.635043, -0.457912, -0.003097, -1.648241, 1.223655, 0.137893, -0.257254, 
	-0.008006, 0.122725, 0.253404, 0.393384, 0.315217, -0.001070, -1.757309, -0.129632, -0.002764, 0.838314, -3.236589, -0.001237, 4.177267, -0.677490, -0.220185, -0.066032, 
	-0.030408, -0.014630, -1.461150, 0.469558, 0.325669, -0.003672, 1.645752, -0.013832, -0.008450, 4.063190, -2.339833, -0.003807, -0.766851, -0.373669, -1.157457, -0.330410, 
	-0.027672, -0.018674, -2.017422, -0.467602, -2.492348, -0.003108, 4.804243, -0.016524, -0.008516, -0.607799, 1.837196, -0.003443, -1.506619, -0.578217, -0.022425, 1.128930, 
	-0.002108, -0.002246, 0.130065, 1.074871, -0.264552, -0.000368, -0.800124, -0.002549, -0.001090, -0.208837, -0.797731, -0.000422, -0.071682, 0.776131, 0.183653, -0.013011, 
	-0.077772, -0.012824, -2.360583, -0.838760, 2.725674, -0.004327, -1.247870, -0.015886, -0.008417, -1.849576, 4.527539, -0.004615, -4.447630, -1.015974, 4.802353, -0.171331, 
	-0.060703, -0.030494, 2.659984, 0.195496, -1.624844, -0.006064, -1.124367, -0.042851, -0.017309, 3.505573, 0.435955, -0.006734, -5.684496, 1.747363, 0.146122, -0.092629, 
	-0.014010, -0.006074, -1.074636, -0.384668, 1.576112, -0.001561, 0.138724, -0.009766, -0.004561, 1.353166, -0.025230, -0.001615, -0.296508, -0.535436, -0.665095, -0.048841, 
	-0.011324, -0.005195, -2.119402, -0.398204, -2.412454, -0.002789, -3.347183, -0.035518, -0.005642, 1.603891, 1.780462, -0.002822, 1.357259, 2.053991, 1.592048, -0.047118, 
	-0.020481, -0.022443, 0.349210, -1.761160, 2.827723, -0.007208, 4.516150, -0.019051, -0.012554, -1.450748, -4.132938, -0.007549, -4.911545, 4.867995, -0.054712, -0.160689, 
	-0.091838, -0.040171, 3.762395, 0.527412, 0.272035, -0.014140, -2.308889, -0.069696, -0.027221, -4.102891, 4.335526, -0.023662, -3.187877, -3.379366, 4.766499, -0.418114, 
	-0.135981, -0.057195, 1.526451, -3.038638, -1.207034, -0.025536, 4.875859, -0.099230, -0.046587, -2.599798, -3.363170, -0.027148, 2.126645, -3.630040, 6.191122, -0.489721, 
	-0.003579, -0.002984, 0.618473, -5.360650, 0.274518, -0.001233, 1.102213, -0.010075, 0.040837, 1.660211, 2.747418, 0.047560, -1.436693, 0.331697, 0.005888, -0.013600, 
	-0.018601, 0.004883, 0.365732, -2.707266, -0.068157, -0.001585, -0.112628, -0.016295, -0.003564, 4.127987, 1.709803, -0.001667, -2.823711, 0.075924, -0.485727, -0.045129, 
	-0.229077, -0.043493, 8.844840, 1.844090, 9.725645, -0.015161, 1.776433, -0.079545, -0.025458, -2.285239, -4.454716, -0.020103, -8.128648, -5.095530, -1.715340, -0.098698, 
	-0.000358, -0.000340, -0.059171, 0.095766, -0.121977, -0.000256, -0.130921, -0.000605, -0.000302, 0.230984, -0.863206, -0.000252, 0.929022, -0.134639, 0.058397, -0.002142, 
	-0.014402, -0.004725, 0.977859, 0.531237, 0.000793, -0.001595, -1.987796, -0.011876, -0.003407, -0.461895, -3.577296, -0.001648, 0.648301, -1.221606, 5.302094, -0.174038, 
	-0.077081, -0.029292, 7.628927, -2.239913, -2.861063, -0.013117, 2.026986, -0.051357, -0.021073, 2.686487, -0.949500, -0.013466, -4.104434, -2.915576, 1.368710, -0.435239, 
	-0.008391, -0.008312, -1.280930, -6.220081, -0.251811, -0.005218, -4.034461, -0.011058, -0.006746, 9.764348, -0.988206, -0.005271, 5.019886, -0.927926, -0.950728, -0.085094, 
	-0.004692, -0.003555, -2.529229, 5.904275, -1.708563, -0.002264, -0.233029, -0.008373, -0.003017, -1.026217, -0.968949, -0.002279, 2.199889, -1.446289, -0.117934, -0.049775, 
	-0.011294, -0.011284, -0.542435, -1.135953, -0.783416, -0.003119, 13.581441, -0.012125, -0.006101, -0.782431, -4.212408, -0.003352, -2.856888, -1.891401, -1.243907, -0.085327, 
	2.193768, -0.043332, -4.013514, -1.710244, -12.308197, -0.026973, -12.100363, -0.041759, -0.029777, -0.701376, 11.262962, -0.027884, 22.487284, -4.085846, -5.722009, 4.867258, 
	-0.253285, -0.136662, -1.640887, -1.469579, 0.470317, -0.069511, 2.838399, -0.141991, -0.094093, -4.094986, 0.330107, -0.010811, 1.101739, -1.750888, -0.629160, 5.551291, 
	-0.010838, 0.194859, 0.963306, -3.138256, 4.851079, -0.002365, 2.095697, -0.078772, -0.004804, 2.572810, -2.415905, -0.002503, -3.534739, -1.025558, -0.372801, -0.091211, 
	-0.055192, -0.011150, 0.068336, 0.278601, 2.173267, -0.003119, -2.756301, -0.012185, -0.007226, -2.834643, 3.196244, -0.003279, 2.647039, -1.725486, -0.791609, -0.163298, 
	-0.013087, -0.008047, 2.436162, 0.917928, 0.342591, -0.001861, -0.986337, -0.013282, -0.004416, -3.225292, -2.750191, -0.002006, 2.050661, 0.328987, 0.993800, -0.065609, 
	-0.022396, -0.008354, 0.659310, -0.037914, 1.794414, -0.002330, -1.546674, -0.011066, -0.004612, 0.354109, -2.143922, -0.002391, -0.809580, 0.739197, 1.092602, -0.050393, 
	-0.042635, -0.027793, 2.118182, 3.416811, -2.832757, -0.005912, -1.652003, -0.051594, -0.015288, 3.830985, -1.378788, -0.006143, -1.570837, -0.973694, -0.576708, -0.231827, 
	-0.017950, -0.006020, -0.396735, 0.778509, 1.877523, -0.001876, 0.747358, -0.012509, -0.004327, -1.261684, -1.360524, -0.001908, 0.318691, -0.108022, -0.507283, -0.043245, 
	-0.154729, -0.017651, -0.759136, -1.990877, -5.697675, -0.007978, 0.638767, -0.044581, -0.013351, -2.320920, -6.685293, -0.008171, 19.202559, -1.390844, -1.831617, 1.081497, 
	-0.016227, -0.007583, -0.696075, 1.545052, -2.025031, -0.002268, 2.743041, -0.023290, -0.005864, 0.293016, 4.315387, -0.002509, -4.432361, -0.432958, -1.162466, -0.089865, 
	-0.054128, -0.023821, -2.028238, -0.121559, 4.321730, -0.007142, 3.793581, -0.034898, -0.014074, -2.506377, -1.939026, -0.011836, 0.131547, 0.495902, -1.857582, -0.144078, 
	-0.082283, -0.011133, -1.779012, -2.727283, -0.428656, -0.003320, -3.472973, -0.007704, -0.005998, 4.362119, 1.879468, -0.003396, 1.826157, -0.762984, 1.335547, -0.118551, 
	-0.004207, -0.000383, -0.129967, 0.780374, -0.108919, -0.000141, -0.309192, -0.000477, -0.000260, -0.178800, -0.145200, -0.000145, 0.211288, -0.075405, -0.031497, -0.007070, 
	-0.001983, -0.001574, -0.584914, -0.758917, 1.648606, -0.000376, 1.013169, -0.001538, -0.001071, 1.020464, -0.588837, -0.000612, -1.129659, -0.145669, -0.457754, -0.009335, 
	-0.014686, -0.004867, -1.110871, -0.311297, 0.709317, -0.001506, -1.591287, -0.006503, -0.002844, -0.296895, -1.974733, -0.001588, 4.614048, 0.174884, -0.143868, -0.037305, 
	-0.003626, -0.002846, 1.373111, -2.472096, 1.880646, -0.000884, -3.283414, -0.006544, -0.002131, -0.562684, 1.946625, -0.000952, 0.700740, 0.029259, 0.423486, -0.018689, 
	-0.017337, -0.007177, 0.278379, -0.275205, -0.751984, -0.001785, -0.779913, -0.050492, -0.004410, -1.864277, 4.211602, -0.001963, -1.044240, 0.147594, 0.274167, -0.112959, 
	-0.048029, -0.010021, -0.361521, -0.590041, -1.109544, -0.001387, 1.193524, -0.023609, -0.004421, -1.257834, -0.893834, -0.001528, -0.006554, 4.481663, -1.132043, -0.234821, 
	-0.058780, -0.006021, 0.150978, 0.558138, -0.872866, -0.000556, -1.417988, -0.002544, -0.001553, -0.106880, 6.156277, -0.000600, -5.068265, 0.135307, 0.573583, -0.038230, 
	-0.037405, -0.038277, -2.780954, -0.099555, -1.951369, -0.023387, -0.004802, -0.204243, 1.434870, 4.336342, -0.928459, -0.023681, 1.150332, -0.004499, -0.733475, -0.091437, 
	-0.109565, -0.046869, 5.701127, -3.849680, -2.649109, -0.012777, 3.426719, -0.070673, -0.028706, -3.121912, 0.373037, -0.013566, 2.648675, 1.475007, -3.285471, -0.436237, 
	-0.022993, -0.010466, -1.128877, -3.735734, -0.097809, -0.001751, 0.099588, -0.008129, -0.008544, 1.183462, 0.403439, -0.001809, 1.855069, 4.111702, -2.514907, -0.122241, 
	-0.010865, -0.011643, -2.650035, -0.990520, 0.213196, -0.001994, -3.072282, -0.011661, -0.006844, 0.087590, -1.224288, -0.002287, 8.409563, 0.562815, -1.196767, -0.093977, 
	-0.063164, 0.109480, 0.933019, -1.899357, -1.327333, -0.006186, -0.804357, -0.170585, -0.016957, -0.930790, 5.359106, -0.006976, 3.688887, -1.277868, -3.289712, -0.297205, 
	-0.012408, 0.046323, -0.390978, 0.090384, -1.200124, -0.000912, 2.006399, -0.044591, -0.002033, 0.641326, -0.694111, -0.001018, -0.706816, -0.740429, 1.400788, -0.391799, 
	-0.014150, -0.007010, -0.241260, 3.312185, -1.571259, -0.001350, -0.333519, -0.011848, -0.004061, 1.419264, -0.812499, -0.001522, 1.750047, -1.216424, -2.216985, -0.049609, 
	-0.060811, -0.033412, 2.252290, -0.286757, -0.764258, -0.011790, -5.093650, -0.071212, -0.022733, 1.593577, -0.296070, -0.012253, 5.036523, -0.734192, -1.210585, -0.284666, 
	-0.020490, -0.008588, 3.181507, 1.541707, -1.200189, -0.003048, 0.115787, -0.009840, -0.005883, -4.253198, 2.009396, -0.003206, -0.850205, -0.377546, -0.029620, -0.086585, 
	-0.059102, 0.041581, -1.342413, -2.711924, 7.979719, -0.012865, 4.967018, -0.065733, -0.025452, -0.602263, -0.265429, -0.013353, -2.869567, -1.378022, -2.453733, -1.188461, 
	-0.032354, -0.012612, 3.560199, 0.200355, -2.585892, -0.004957, 1.035550, -0.026376, -0.009364, -0.848994, -4.083103, -0.005126, -1.644614, 6.731907, -2.025215, -0.249405, 
	-0.027167, -0.005044, -1.377182, 0.303387, -0.363134, -0.002543, 6.359395, -0.018262, -0.004650, 1.090732, -4.166274, -0.002655, -0.461123, 0.725903, -2.009447, -0.041936, 
	-0.211383, -0.053408, -1.458460, -1.190966, -4.657261, -0.017076, 3.156635, -0.088770, -0.034026, -2.992226, 6.388447, -0.146768, 3.011738, -2.274148, -0.352062, 0.919735, 
	-0.005690, 0.365811, -0.477655, 1.394495, -0.542462, -0.000501, 1.489179, -0.201873, -0.002841, -0.097804, -0.249606, -0.000528, -1.113520, -0.342214, -0.184026, -0.030763, 
	-0.002012, -0.001361, -0.362316, 2.326688, -0.109225, -0.000568, -0.150745, -0.002635, -0.000897, -0.637441, -0.405954, -0.000582, 0.212218, -0.034470, -0.813236, -0.017464, 
	-0.000622, -0.000404, 0.223850, 0.188625, -0.158086, -0.000263, 0.346560, -0.000663, -0.000377, -0.169318, -0.148967, -0.000265, -0.251960, -0.023632, 0.000364, -0.004841, 
	-0.020940, -0.005454, -0.659577, -0.054661, -1.265674, -0.001834, -0.196339, -0.039846, -0.003906, 3.931183, -0.904960, -0.006302, -0.522442, 0.182260, -0.376985, -0.054524, 
	-0.004262, -0.004839, 0.983644, -1.157420, -1.753433, -0.001178, -0.871802, -0.004394, -0.002432, -1.537577, 2.271177, -0.001291, -0.464388, 0.388272, 2.205328, -0.045405, 
	-0.080990, -0.003409, -0.480111, -0.035026, -2.017524, -0.000531, -0.756046, -0.003615, -0.001607, -0.094204, 1.557521, -0.000569, 1.392829, -0.134426, 0.694018, -0.036310, 
	-0.012994, -0.003789, 0.076280, 1.166479, -0.452646, -0.001116, -1.093274, -0.006707, -0.002658, 1.579596, -5.076060, -0.001198, 3.962945, -0.359320, 0.246331, -0.021868, 
	-0.025487, -0.012705, 4.730200, 0.358837, -1.087505, -0.004313, 1.236940, -0.011969, -0.007938, -0.848402, -1.702864, -0.004456, -1.399021, -1.270805, 0.233737, -0.184248, 
	-0.002609, -0.001022, 0.240124, 0.329305, -0.198220, -0.000481, 0.317061, -0.001093, -0.000732, -0.478469, 0.209995, -0.000489, -0.845448, 0.542866, -0.103937, -0.006851, 
	-0.001837, -0.001276, -0.658865, -0.114458, 0.373717, -0.000549, -0.089444, -0.001039, -0.000786, 1.969292, -0.085440, -0.000535, -0.239576, -1.390760, 0.250356, -0.008800, 
	-0.005182, 0.004075, 2.632692, -3.205984, 0.388844, -0.001101, -3.442085, -0.013046, -0.003086, -0.121612, 3.777473, -0.001166, -0.284214, -0.172121, 0.486207, -0.039696, 
	-0.021060, -0.010052, 1.771608, 0.249308, -1.513008, -0.004551, 3.934446, -0.018588, -0.008123, 2.208896, -3.257413, -0.003675, -2.969203, -0.630244, 0.332481, -0.060824, 
	-0.034774, -0.015359, -0.102721, -2.573519, 3.247347, -0.003201, -1.347724, -0.114110, -0.013731, 3.636844, 1.709304, -0.007266, -0.767138, -1.700178, -0.991878, -0.921895, 
	-0.021763, -0.017479, 3.038050, -1.423598, 1.166011, -0.001929, 1.973698, -0.016071, -0.007434, -1.207950, -0.416655, -0.002213, -2.722136, -0.667822, 0.383544, -0.056253, 
	-0.008987, -0.006128, -0.930840, 0.924826, -0.851221, -0.002623, -1.163041, -0.004519, -0.003506, -0.506406, -2.104448, -0.002735, 2.693476, 1.271757, 0.229778, 0.464615, 
	-0.011402, -0.008038, 2.024010, -1.361959, 0.379373, -0.001927, -1.923410, -0.010523, -0.005061, -0.639653, -2.998617, -0.002180, 3.659759, -0.213646, -0.114269, 1.227543, 
	-0.011679, -0.007082, -0.028599, -0.709297, -1.822296, -0.001120, 0.101195, -0.005862, -0.003046, -0.381273, 1.102324, -0.001220, 2.523167, 0.375154, -0.377425, -0.752941, 
	-0.145590, -0.050848, -1.918041, 0.242568, 7.267014, -0.012481, 0.019370, -0.061750, -0.029106, -1.506581, 1.244599, -0.024804, -4.396355, -4.331157, 2.347508, 1.355654, 
	-0.018960, -0.028551, -1.038066, 0.584194, 6.670373, -0.004521, -6.130658, -0.026073, -0.012781, -2.030495, 2.664150, -0.005299, -0.216464, 1.668936, -1.801974, -0.273811, 
	-0.151801, -0.064173, 5.507005, 3.031653, -0.634179, -0.019841, 3.120474, -0.066737, -0.040111, 8.229313, -9.274128, -0.020837, -8.226205, 1.767158, -2.807257, -0.350333, 
	-0.074260, -0.028832, 8.098732, -1.752313, 2.411419, -0.013249, -2.373241, -0.044315, -0.022248, -0.370974, 2.909981, -0.013303, -4.887652, -2.026712, -1.395126, -0.417908, 
	-0.017150, -0.006017, 0.397729, 0.393394, -1.550349, -0.001638, -0.386683, -0.025118, -0.004702, -2.209975, -0.777061, -0.000890, 5.202620, -0.480210, -0.922957, 0.389008, 
	-0.027943, -0.017284, 1.060936, -0.365333, -3.703768, -0.009967, 16.508751, -0.031969, -0.011961, -3.088701, -5.439683, -0.010289, -5.358041, -0.752621, 0.266568, 0.981305, 
	-0.030617, -0.010225, 1.816600, 1.232662, -1.481189, -0.001735, -1.461441, -0.008500, -0.004571, -1.578454, -1.568325, -0.001822, 1.217349, 1.077100, 0.894576, -0.091409, 
	-0.026674, -0.016187, 1.427455, -1.939521, -0.968067, -0.005508, -2.226901, -0.020750, -0.009610, 0.499066, -0.473403, -0.005708, 0.413916, -0.104508, 3.535988, -0.079586, 
	-0.015278, -0.008256, 0.782347, 4.344335, 0.653530, -0.002428, -4.538854, -0.013554, -0.004973, -1.131307, -4.028959, -0.002536, 5.195716, -1.549922, 0.366144, -0.046003, 
	-0.021095, -0.012977, -1.306843, -0.322980, -0.776412, -0.002720, 0.812562, -0.011276, -0.006653, 1.812361, 3.764001, -0.002931, -3.736176, -1.454838, 1.404710, -0.138732, 
	-0.002466, -0.001536, 2.144288, 0.386304, -0.388990, -0.000376, -0.745722, -0.001328, -0.000881, -0.327991, -2.286010, -0.000363, 1.494460, 0.219455, -0.484625, -0.004218, 
	-0.081505, -0.054282, 3.179798, 1.124765, -4.414241, -0.023916, -3.796163, -0.078474, -0.038395, -0.512851, -1.178125, -0.024682, 7.709002, 1.092243, -1.697973, -1.205202, 
	-0.018316, -0.009134, 1.181414, 0.397634, 1.890603, -0.003033, 0.276114, -0.010443, -0.005283, -0.925068, 0.131966, -0.003062, -1.234959, -0.625047, -1.110316, 0.066930, 
	-1.014407, -0.590239, -0.413103, 2.891750, 3.218047, -0.205170, -0.819133, -0.817445, -0.403298, -1.155630, 0.661770, -0.154375, -0.568830, 2.772490, -1.847841, -1.554587, 
	-0.022974, -0.006840, 0.727464, -3.286257, -2.089833, -0.003395, -2.079420, -0.008207, -0.004544, 0.708943, 5.495717, -0.003512, -2.263576, 2.301833, 0.607615, -0.073016, 
	-0.125454, -0.046444, -0.546266, -3.080324, -3.034131, -0.014666, -1.072006, -0.051260, -0.028512, 2.629661, 1.524425, -0.015195, 3.778384, 1.179976, -0.384054, -0.714134, 
	-0.003231, -0.002408, 2.984303, -0.779296, -0.188211, -0.000617, -1.288308, -0.004909, -0.001360, -1.557566, 0.304242, -0.000662, 0.764165, -0.071629, -0.136991, -0.017521, 
	-0.006207, -0.003888, 2.671237, -1.001508, -0.435393, -0.001830, 0.464128, -0.004322, -0.002735, -1.224295, -2.239702, -0.001872, 0.402936, 1.392800, 0.035811, -0.045161, 
	-0.016843, -0.010866, -2.574764, 0.347065, 0.853690, -0.002420, -0.485756, -0.009634, -0.005488, 1.661661, 3.490206, -0.002551, -3.420600, 1.813213, -1.393282, -0.243631, 
	-0.005659, -0.003026, 2.713701, -0.824518, -0.046516, -0.001340, -1.079270, -0.009466, -0.002240, -0.524621, 0.879479, -0.001415, -0.868064, 0.139944, -0.350892, -0.016096, 
	-0.005011, -0.002238, -1.035000, -1.895351, -1.639889, -0.001225, -0.081650, -0.002516, -0.001788, 2.442599, 1.791203, -0.001225, -0.309420, -0.658230, 1.422425, -0.022684, 
	-0.004746, -0.004659, -2.538177, -1.452388, -0.610958, -0.001591, 1.727573, -0.009019, -0.003962, 3.141744, -1.302580, -0.001820, -0.473890, -0.236580, 1.867316, -0.096262, 
	-0.016879, -0.006998, -0.341172, -0.823963, 0.442222, -0.002879, 2.158256, -0.014895, -0.005323, -0.564174, 4.767813, -0.007349, -2.185186, -0.949838, -2.388800, -0.060835, 
	-0.137378, -0.020374, -1.294892, 0.793384, -1.914877, -0.003588, 0.848042, -0.026766, -0.010054, 1.022002, -0.470837, -0.004044, 3.248582, 0.657497, -1.968680, -0.718018, 
	-0.009358, -0.008367, 1.054926, -0.512933, -3.325409, -0.002007, 3.813774, -0.005142, -0.003961, -1.161407, -2.812039, -0.002050, -1.389719, 0.704284, 3.854687, -0.195278, 
	-0.066009, -0.054425, 7.007654, -1.672129, 0.658846, -0.012497, 1.082146, -0.046436, -0.027349, 5.113503, -3.858761, -0.013438, -1.615174, -4.430701, -1.382197, -0.683033, 
	0.954408, -4.568535, 1.163923, 2.061558, 1.181224, -0.171992, -2.743167, 4.635071, -0.387930, -3.375507, 1.205624, -0.503538, -0.697942, 3.586881, -3.072253, 0.732176, 
	-0.034872, -0.021372, 6.116292, -1.126929, 0.910468, -0.005448, -3.004006, -0.028703, -0.013829, 4.315060, -2.254201, -0.005945, -0.738391, -1.377903, -2.318637, -0.411584, 
	2.402376, -0.007494, 0.108718, 0.179025, 1.451785, -0.001655, -0.863142, -0.013701, -0.004565, 0.452253, -5.995842, -0.001773, 2.224939, -1.187030, 1.317232, -0.061125, 
	-0.407412, 0.205188, 2.821194, -2.878237, -0.978755, -0.019609, 6.205544, -0.151112, -0.036454, -0.577976, 2.288152, -0.024639, -0.039380, -0.345483, -5.247262, -0.813760, 
	-0.008772, -0.002699, -0.336357, 0.713881, 1.130311, -0.000830, -0.597665, -0.003121, -0.001666, -1.706991, -1.421203, -0.000880, 2.621796, -0.241310, -0.101094, -0.043401, 
	-0.001955, -0.001193, -0.284253, -0.177423, -0.473813, -0.000420, -0.268868, -0.015413, -0.001470, -0.110204, -0.609830, -0.000477, -0.137564, 1.577011, 0.520697, -0.014826, 
	-0.002630, -0.002557, -0.100107, 1.623212, -0.546928, -0.001321, 0.056317, -0.003585, -0.001892, -1.430040, -1.623612, -0.001349, 0.697974, -0.436561, 1.822298, -0.049218, 
	-0.045491, -0.013845, -0.424638, -1.344986, -1.795062, -0.003883, 2.286338, -0.019242, -0.009729, 0.524342, -1.147445, -0.004292, -0.689850, -1.217753, 4.157640, -0.252104, 
	-0.137648, -0.051662, -3.600570, -2.615480, 0.576477, -0.013688, 7.190351, -0.048189, -0.029160, -1.178053, -0.985862, -0.014663, -1.271534, -2.889090, 5.318551, -0.249780, 
	-0.011856, -0.004338, 1.240793, -1.521760, -0.871391, -0.001688, -0.644754, -0.011350, -0.003316, -1.001962, -1.187042, -0.001857, 2.378391, -0.595339, 2.259467, -0.021998, 
	-0.008510, -0.008929, 1.229535, -1.582119, 0.792126, -0.001436, -0.618092, -0.026542, -0.003518, -0.258772, -0.091043, -0.001535, 1.956622, -0.585118, -0.776870, -0.015799, 
	-0.014247, -0.017826, -0.315143, 0.179930, 1.185087, -0.002499, -1.702801, -0.046673, -0.010039, -0.726231, -1.716034, -0.003007, 3.212696, 0.925612, -0.790243, -0.158583, 
	-0.009149, -0.006146, -0.873031, -2.218503, -0.832270, -0.001737, 5.073809, -0.070607, -0.006366, -0.941468, -1.692991, -0.002469, -1.372089, -0.178165, 3.158749, -0.027567, 
	-0.010806, -0.001728, 0.245813, -0.701939, 0.625583, -0.000455, 1.780802, -0.008936, -0.001352, 0.321733, -0.711994, -0.000522, -1.784432, -0.360159, 0.629292, -0.020899, 
	-0.046339, -0.035912, 0.461496, 6.856256, -2.119574, -0.016286, -3.816199, -0.042709, -0.024441, -0.959349, -3.208579, -0.017128, 3.131062, -2.930887, 2.318022, 0.450566, 
	-0.005525, -0.002794, 1.256028, 1.454927, 1.281792, -0.001150, 0.355651, -0.002647, -0.001912, -2.362185, -1.452984, -0.001192, -0.650830, -0.096812, 0.299482, -0.069850, 
	-0.002674, -0.001835, -1.487917, 3.001620, -1.316001, -0.000955, 2.398460, -0.003557, -0.001340, 0.250364, -2.565509, -0.000985, -0.245655, -0.120412, 0.007392, 0.089004, 
	-0.012622, -0.003360, -0.608740, 0.313456, -0.692526, -0.001002, -0.514460, -0.005541, -0.002454, 1.438145, 0.298590, -0.001060, -0.193754, 0.386519, -0.369328, -0.031865, 
	-0.044494, -0.014810, -0.579003, 1.982093, 4.033063, -0.003548, -1.461221, -0.027092, -0.008370, -0.271653, 1.834868, -0.004000, -2.106745, -3.047551, -0.079125, -0.202412, 
	-0.002955, -0.001620, -0.322684, 0.886280, -0.474878, -0.000684, -0.547911, -0.007776, -0.001720, 0.796688, -0.994088, -0.000754, 1.812657, -1.091125, 0.143533, -0.192962, 
	-0.025747, -0.008389, -1.577826, 2.345269, -0.149282, -0.002960, -2.155519, -0.011754, -0.005927, 2.201077, 2.854338, -0.003117, -1.921202, -0.681438, -0.792325, -0.065198, 
	-0.090891, -0.029254, -2.313883, 7.167174, 1.627029, -0.004234, -4.888826, -0.069706, -0.016028, 3.931632, -3.287326, -0.004746, -1.073569, -0.766081, 0.002750, -0.184039, 
	-0.010825, -0.003360, -0.942620, 0.204903, -1.466185, -0.001281, 2.087890, -0.003846, -0.002429, 0.065825, 1.390891, -0.001339, -2.437598, 2.113591, -0.957689, -0.035928, 
	-0.045288, -0.017151, 0.036386, -1.162382, -0.927994, -0.004721, 1.184902, -0.030749, -0.010021, -0.616915, 2.207158, -0.005191, -2.867992, 4.219886, -1.684091, -0.275837, 
	-0.069466, -0.004945, -1.213439, 6.405585, -1.793437, -0.002758, -1.305560, -0.006596, -0.004265, -2.808279, -2.322325, -0.002789, 0.608996, 2.815009, -0.247537, -0.048195, 
	-0.001997, -0.001573, -0.034990, 1.738491, -0.598065, -0.000506, 0.245307, -0.001600, -0.000846, -1.395408, -0.003757, -0.000516, -0.132294, 0.268640, -0.066804, -0.014082, 
	-0.043938, -0.004294, -0.645663, -0.789675, -0.156076, -0.000913, 3.822157, -0.021309, -0.003706, -0.320881, -1.537362, -0.001037, -2.280007, 2.452623, -0.529215, 0.059297, 
	-0.029349, -0.014891, -0.563527, 5.724275, 2.749189, -0.006884, -5.055209, -0.015343, -0.010331, 0.363804, -3.251128, -0.006979, 0.894591, 0.961408, -1.579576, -0.160050, 
	-0.006274, -0.003774, 1.844993, 1.121257, 1.561222, -0.001216, -2.771667, -0.009360, -0.002995, -0.555898, -0.879914, -0.001359, -0.852103, -0.452627, 1.088769, -0.079055, 
	-0.010055, -0.002924, -0.640545, -0.371942, -0.235388, -0.000124, -0.537315, -0.006490, -0.000754, 0.133063, 0.711712, -0.000138, -0.397654, -0.357628, 1.718180, -0.001998, 
	-0.024153, -0.013595, 0.352960, 1.445984, 0.730578, -0.003206, -0.551555, -0.023027, -0.008905, -1.329159, -1.163950, -0.003606, 0.846137, 0.051112, 0.196962, -0.502577, 
	-0.040219, -0.011729, -2.346599, 0.285031, 1.912802, -0.003325, -2.769031, -0.018161, -0.008006, 1.700720, -3.731684, -0.003460, 1.270345, 2.431350, 1.584865, -0.252897, 
	-0.012640, -0.010335, 3.175265, -0.654298, -0.288717, -0.003553, 4.131903, -0.012398, -0.006434, -0.884791, 0.859687, -0.003699, -4.066484, -0.909516, -1.267480, -0.046511, 
	-0.090055, -3.736712, 0.875518, -2.847674, -5.073431, -0.012509, -2.428456, 4.072108, -0.026110, 3.868709, -4.515839, -0.013617, -0.186604, 5.135080, 4.089567, 0.890023, 
	-0.034502, -0.009309, 3.700081, 0.671509, -0.906624, -0.001769, -0.066346, -0.007608, -0.004121, 0.830553, -0.081065, -0.001889, -2.101783, 0.123092, -2.020555, -0.089665, 
	-0.176504, -0.092269, -0.736580, 1.186212, 1.616509, -0.048805, -2.625029, -0.093638, -0.063561, -2.886927, 0.657801, -0.058610, 3.239649, -3.173778, -1.047926, 4.303457, 
	-0.020805, -0.006588, 0.683265, 6.715034, -2.291176, -0.003088, -4.939430, -0.014827, -0.005472, -1.616135, 2.293852, -0.003201, -0.563159, -1.894854, 1.767318, -0.100734, 
	-0.337203, -0.074840, 5.447750, -1.148968, 4.378654, -0.023521, -9.432035, -0.111200, -0.049126, -0.137569, -3.200198, -0.024696, 8.904760, -0.753782, -2.538096, -0.899932, 
	-0.019213, -0.012037, -1.876411, -1.498791, -0.621618, -0.002846, -4.853880, -0.012667, -0.006547, -0.436424, 1.097029, -0.002972, 8.682763, 1.155980, -1.716326, 0.123961, 
	-0.003995, -0.002622, -0.922481, 1.833994, -1.768594, -0.000815, 1.188956, -0.004792, -0.001866, 0.379475, 0.126596, -0.000918, -1.018850, -0.751695, 0.824162, 0.123446, 
	-0.074997, -0.021923, 0.248875, -0.288447, -2.875492, -0.005907, -1.328194, -0.035107, -0.014328, 0.193261, 3.654969, -0.011010, 2.554035, -1.966663, 0.253105, -0.282177, 
	2.420302, -0.006383, -1.107154, -0.611405, -1.036219, -0.001562, 2.650550, -0.005652, -0.003651, -1.407183, -7.439424, -0.001663, 7.326945, 0.819663, -1.351589, -0.245574, 
	-0.003618, -0.004177, 0.213511, -0.637524, -0.843648, -0.000781, 0.585627, -0.004652, -0.001612, 1.047265, -0.703930, -0.000831, 0.517880, 0.052097, -0.208541, -0.007067, 
	-0.230236, -0.100587, -5.810724, -0.134391, 2.204411, -0.022503, 2.290195, -0.282945, -0.060775, -2.606629, 2.376168, -0.031972, 1.727883, -2.490542, 3.697026, -0.524378, 
	-0.018989, 0.240542, -0.189547, -0.866708, 0.970934, -0.004426, 1.055776, -0.103624, -0.014215, 0.774895, -1.288544, -0.004787, 1.607667, -0.476036, -1.328349, -0.354588, 
	-0.011153, -0.008261, -0.559300, -1.267241, 1.313277, -0.002425, -0.551446, -0.027368, -0.006294, -0.684652, 2.430995, -0.002642, -0.678400, -1.489014, 1.589377, -0.045453, 
	3.668035, -0.078283, -3.374503, -0.207588, 1.897255, -0.018971, -2.408717, -0.161428, -0.046904, 1.002708, 4.137937, -0.021479, 5.304714, -1.409104, -5.944657, -2.339014, 
	-0.007973, -0.004383, 0.210676, 1.161395, 2.518762, -0.002101, -1.845390, -0.005911, -0.003366, -0.517818, 0.745062, -0.002392, -2.884446, -0.457238, 1.188306, -0.093181, 
	-0.014014, -0.007401, -0.342507, 4.205221, -1.254981, -0.001644, -1.636497, -0.011811, -0.004246, 1.183914, -0.059150, -0.001802, 0.779811, -0.775334, -2.009265, -0.050294, 
	-0.024222, -0.007673, 1.014316, 0.560163, 0.467377, -0.001608, 0.993555, -0.016221, -0.004246, -2.267773, 1.027663, -0.001766, 0.408688, -1.061967, -1.038911, -0.047376, 
	-0.009365, -0.004724, 2.057661, -0.169183, 3.692891, -0.001232, -0.463359, -0.007386, -0.003307, -1.300820, -2.981039, -0.001337, -1.551464, 0.001931, 0.781523, -0.040789, 
	-0.002807, -0.001498, 3.597525, -0.754422, 0.020201, -0.000575, -0.138170, -0.001249, -0.000972, -0.907187, 0.342771, -0.000601, -1.356311, -0.619938, -0.168265, -0.008501, 
	-0.008562, -0.003559, 0.048956, -1.000519, -1.006849, -0.001258, -1.446669, -0.003235, -0.002295, -1.016726, -1.174217, -0.001290, 0.802097, -0.156200, 5.000344, -0.030021, 
	-0.045677, -0.020926, -1.660560, 0.939795, -3.325356, -0.018126, -1.692639, -0.018508, -0.016187, -0.772818, 23.173803, -0.022705, -16.221004, -0.840029, -3.186102, 3.727039, 
	-0.052449, -0.030642, -0.278036, 0.220690, -3.279700, -0.004109, -0.452629, -0.026042, -0.015979, 1.532821, 3.260235, -0.004581, -1.563462, 1.242122, -0.405041, -0.143198, 
	-0.010928, -0.009074, 12.314517, -1.889778, -2.596975, -0.004977, 1.391085, -0.012264, -0.007388, -6.241626, -0.427886, -0.005021, -1.544096, -1.100730, 0.198974, -0.053833, 
	-0.388261, -0.174410, -5.750398, 3.882422, 0.399882, -0.043624, 1.972615, -0.230042, -0.104095, -0.457353, 5.815011, -0.176167, 0.344822, -0.646449, -2.263103, -2.180849, 
	-0.014999, -0.011782, 1.793666, -0.749045, 0.917900, -0.003352, 5.880771, -0.024392, 0.080981, -1.141740, -0.307021, -0.003482, -6.460067, 1.432783, -0.938162, -0.452058, 
	-0.001831, -0.000626, -0.523841, -0.190258, -0.111346, -0.000314, -0.213919, -0.000814, -0.000488, -0.131733, -0.380519, -0.000320, 0.010358, 0.325439, 0.984663, 0.235548, 
	-0.004639, -0.003691, 3.333480, -1.318719, 0.675795, -0.000991, -0.121121, -0.001702, -0.001548, 0.493475, -0.014286, -0.001015, -1.498387, -1.400962, -0.118395, -0.017295, 
	-0.007079, -0.006359, 5.236867, -1.036008, 0.342517, -0.001585, -1.549095, -0.007077, -0.004014, -0.825494, -1.276352, -0.001680, 0.240208, -1.390644, 0.363405, -0.077608, 
	-0.007003, -0.002009, 0.219424, -0.050278, -0.263113, -0.000739, -0.374505, -0.002849, -0.001206, 0.041975, -0.116416, -0.000755, -0.210979, 0.118938, 0.675415, -0.025901, 
	-0.021838, -0.008703, 0.564261, 0.667562, 0.167960, -0.002580, 0.589094, -0.012714, -0.005758, -1.144353, 0.336371, -0.002736, 0.484539, -0.849120, -0.637694, -0.124290, 
	-0.004153, -0.002904, 1.904860, -2.361929, -0.754196, -0.001172, 3.128793, -0.002952, -0.002205, 2.915023, 1.269807, -0.001213, -5.181211, -0.519908, -0.366638, -0.020003, 
	-0.040525, 0.245458, -0.911398, -0.687581, 2.380053, -0.002590, 0.889325, -0.088483, -0.006188, 1.673826, -1.862725, -0.002794, 0.297460, -1.380031, -0.333887, -0.169919, 
	-0.028664, -0.007241, -1.034791, 3.987692, -2.972956, -0.001734, -2.874617, -0.010762, -0.004537, -1.145186, 0.573703, -0.131305, 4.744312, -0.321608, -1.240124, 0.467820, 
	-0.015056, -0.009365, -0.965114, 0.039727, -3.024682, -0.001762, -1.739095, -0.010922, -0.004897, 3.071549, 3.411657, -0.001801, -0.252761, 0.835597, -1.251447, -0.081627, 
	-0.004559, -0.002062, -0.134100, 0.846747, 0.539538, -0.000891, -0.643887, -0.003341, -0.001603, -0.944096, -0.940534, -0.000913, 2.066832, -0.370631, -0.372444, -0.034055, 
	-0.060815, -0.021817, -1.248809, 4.799639, -1.179989, -0.005686, -3.946347, -0.019651, -0.012577, -2.258608, 5.725374, -0.005740, -0.061678, 0.451363, -0.778979, -1.375680, 
	-0.004406, -0.003999, 0.228741, 3.949731, -1.029796, -0.001317, -1.445440, -0.003594, -0.002314, -1.440508, 0.408073, -0.001365, -0.024477, -0.121968, -0.454718, -0.052643, 
	-0.017562, 0.257143, -0.931895, -0.186085, -1.301308, -0.011666, -2.543697, -0.360169, 0.606395, -0.198006, 2.947089, -0.011861, 1.115790, 0.229873, 0.505964, -0.100006, 
	-0.029343, -0.013025, -1.890989, 0.957585, 0.404992, -0.003250, -1.080272, -0.017347, -0.008165, 3.307406, 5.879172, -0.003508, -2.786475, -2.076258, -2.554020, -0.086505, 
	-0.107091, -0.024182, 0.192305, 0.256078, -0.060507, -0.008013, -7.982848, -0.099246, -0.018674, -2.538152, 4.170547, -0.012829, 3.101315, -3.934777, 7.382216, -0.316140, 
	-0.006615, -0.004238, -1.118262, -0.111313, -0.972635, -0.000877, 1.290349, -0.005649, -0.002215, 0.822241, 2.164155, -0.000970, -1.923545, 1.218679, -1.326630, -0.022476, 
	-0.013502, 2.451176, -0.676890, 0.270861, -1.994138, -0.002328, 0.606978, -2.418281, -0.004683, 1.237253, 0.053037, -0.002411, 0.440812, 0.384710, -0.315509, -0.017085, 
	-0.001887, -0.001031, 2.079025, -0.400077, -0.135095, -0.000482, -0.168936, -0.001241, -0.000734, -0.952961, -0.104250, -0.000478, 0.088360, -0.465307, 0.068427, -0.003335, 
	-0.041909, -0.013052, 0.289052, 1.277100, -0.774720, -0.002453, 3.510059, -0.044522, -0.006124, -2.115149, -1.904072, -0.002734, 0.303613, -0.077034, -0.398802, 0.000748, 
	-0.023590, -0.020330, 0.889939, 0.612500, 0.208413, -0.005588, 0.502899, -0.021848, -0.012234, -1.970437, -1.014909, 0.043172, -0.082707, 2.930790, -1.716347, -0.319724, 
	-0.045171, -0.034290, -0.312894, -1.437428, 2.100116, -0.005732, -4.146147, -0.045311, -0.018440, -4.048788, 3.553517, -0.006694, -2.272056, 2.625754, 4.599778, -0.506215, 
	-0.021568, 0.204217, 1.922484, -2.821710, 0.081045, -0.006588, 3.338635, -0.222703, -0.010096, 0.013689, 2.498877, -0.015556, -3.932138, 0.196526, -1.148667, -0.076445, 
	-0.033226, -0.011619, 0.211203, -0.405784, -1.622350, -0.003620, -0.368111, -0.010905, -0.006305, -1.360359, 2.083107, -0.003719, 3.621001, -0.791111, -0.764455, -0.533746, 
	-0.003618, -0.001441, 0.232895, 0.810566, 0.142161, -0.000461, -0.193599, -0.001992, -0.000994, -0.181203, -0.512236, -0.000484, 0.880162, -0.325933, -0.833049, -0.010771, 
	-0.072971, -0.020046, -2.524593, -4.796913, 7.852708, -0.006264, 4.999717, -0.031695, -0.013204, -2.814492, -9.085348, -0.006756, 9.138876, -0.754380, -1.684892, -0.179745, 
	-0.024618, -0.009234, -0.191259, -0.763664, -0.297040, -0.001327, -0.730590, -0.011120, -0.005257, 0.980569, 4.241865, -0.001547, -0.105901, -1.841343, -1.085849, -0.153685, 
	-0.010852, -0.007842, -1.544514, 0.249586, -1.032807, -0.001504, -1.022137, -0.006440, -0.005672, -0.449979, 0.107467, -0.001574, 2.597642, 1.578491, -0.376748, -0.073119, 
	-0.040410, -0.019076, -1.520172, 1.106311, -0.048941, -0.005079, 2.188757, -0.037925, -0.012061, -0.251635, -3.047723, -0.005487, 2.906823, -0.468743, -0.162359, -0.582280, 
	-0.007208, -0.004358, -0.848705, -0.935913, -1.219519, -0.002167, 2.616212, -0.005650, -0.003530, 1.376781, -1.918234, -0.002199, 0.471704, 0.580418, -0.065260, -0.032370, 
	-0.103412, -0.037938, -0.595437, 1.810692, 3.810658, -0.010461, -2.385598, -0.094425, -0.022576, -3.362943, -1.437811, -0.009381, 1.318530, -0.732069, 1.333447, 0.518722, 
	-0.011529, -0.005415, 1.140765, -1.546175, -1.667831, -0.002313, 3.626252, -0.011796, -0.004195, -0.128812, 1.844418, -0.002433, -4.370240, -1.236822, 2.609419, -0.233294, 
	-0.003035, -0.003895, -0.176324, -2.112006, -2.179631, -0.000709, 2.934155, -0.007568, -0.002402, -0.201499, 4.050898, -0.000805, -0.603910, -0.873497, -0.796744, -0.023029, 
	-0.017749, -0.011503, 0.580382, 0.607100, -1.163446, -0.006338, -2.409967, -0.014887, -0.007807, -3.126294, -4.651335, -0.006341, 5.017361, -0.978852, 6.071921, 0.117756, 
	-0.015726, -0.008465, -4.065236, -2.006160, -1.092984, -0.002564, -3.026467, -0.009805, -0.005827, 2.679590, -1.353529, 0.021713, 3.572365, 1.439794, 3.915279, -0.041977, 
	-0.007164, -0.003643, 0.635003, -1.167262, -0.259987, -0.001555, -1.471849, -0.007556, -0.003202, -0.892134, -4.069334, -0.001518, 4.220325, -1.038276, 4.110787, -0.042635, 
	-0.011112, -0.009587, 1.274888, -2.036263, -0.077024, -0.003723, -1.020074, -0.056739, -0.006581, -1.162450, -1.632097, -0.003979, 0.911053, 5.136913, -1.158203, -0.145022, 
	-0.026627, -0.005079, 0.338028, -0.373323, -1.212177, -0.002480, -2.150084, -0.005919, -0.003877, -0.266919, -2.039226, -0.011421, 1.823318, 0.946229, 3.162197, -0.172640, 
	-1.066323, 0.075504, -1.895720, -0.399061, 0.599614, -0.092751, 1.654518, -1.095798, -0.271731, 2.219523, -2.724462, -0.241657, 1.019574, 4.447618, -1.664762, -0.564087, 
	-0.033702, -0.021612, -0.878949, 3.061585, -1.138777, -0.004074, -1.402588, -0.016647, -0.009669, -0.399353, 0.749474, -0.004430, -2.413043, 1.873746, 0.716834, -0.078794, 
	-0.222031, -0.046395, -2.118590, 1.648810, 0.214168, -0.008962, -6.636382, -0.236088, -0.029535, -2.371080, 0.586195, -0.014286, 3.988887, 3.727344, 2.342297, -0.824351, 
	-0.004212, -0.003343, 0.111602, 2.976878, -0.426085, -0.001055, -0.022905, -0.004293, -0.002309, -1.922474, 1.036245, -0.001160, -0.462080, -0.729042, -0.363654, -0.182114, 
	-0.009701, -0.008099, -0.399820, -1.697556, -3.402874, -0.001640, 0.692551, -0.014977, -0.004307, 1.372052, 2.443854, -0.001707, 0.448233, 0.655748, -0.042085, -0.029675, 
	-0.016818, 0.968175, -0.423664, -2.084184, -1.383927, -0.002628, -0.870210, -0.950974, -0.004429, 1.329234, -0.892362, -0.000825, 3.407088, 1.056845, 0.017987, -0.149308, 
	-0.043573, -0.009435, 2.897099, -0.267374, -1.702098, -0.003296, 1.291185, -0.008668, -0.005665, -1.560879, 1.266410, -0.003294, -1.937969, -1.233557, 1.497218, -0.176104, 
	-0.187184, -0.050091, 4.564156, -1.715829, 1.551281, -0.017033, 1.266334, -0.050701, -0.031720, -2.225008, -3.871494, -0.017856, 0.476608, -5.491504, 4.760944, 1.039097, 
	-0.046912, -0.025585, 1.109665, -0.000879, -1.866986, -0.015921, 1.791680, -0.059529, -0.021674, 3.018208, -1.991736, -0.274812, 1.876979, -1.950587, -1.837408, 0.295496, 
	-0.029258, -0.007621, -0.118066, 1.951291, -0.068495, -0.002145, -3.341444, -0.012621, -0.004849, 0.652616, -4.241940, -0.002251, 5.214275, -1.932590, 0.300875, 1.642224, 
	-0.010502, -0.012649, 2.461004, -2.996433, -5.048826, -0.002011, -1.203010, -0.026065, -0.007589, -0.994965, 6.673324, -0.002178, -0.887257, -0.408024, 2.744972, -0.279792, 
	-0.032993, -0.025298, -0.493806, -2.341210, -1.034036, -0.001434, -1.327438, -0.008474, -0.005221, -0.296542, 2.901078, -0.001590, 2.467876, 0.157655, 0.751014, -0.709582, 
	-0.012563, -0.004746, 2.468900, -0.757989, 0.796322, -0.001839, 1.269220, -0.004627, -0.003123, -1.383236, 1.165239, -0.006367, -2.047493, -0.655139, -0.773412, -0.049148, 
	-0.063925, -0.034778, -0.788403, 2.088465, 1.065825, -0.006532, 2.298929, -0.031922, -0.017829, -1.055967, 0.193932, -0.007283, -2.091492, -1.489620, -0.007190, -0.052210, 
	-0.029130, -0.006784, -1.897209, 1.037539, -1.513191, -0.003590, 0.120586, -0.019893, -0.005624, 1.104248, -3.588907, -0.003675, 3.063189, 0.808215, 1.026113, -0.091888, 
	2.138192, -0.031720, 2.054891, 1.330441, 1.196487, -0.016561, -4.799327, -0.102873, -0.046401, -2.352079, -1.511383, -0.018245, 6.572304, -4.123121, 0.025830, -0.316434, 
	-0.221977, -0.074190, -1.977135, -1.814454, -0.435327, -0.024508, 1.021310, -0.119821, -0.055126, -2.629361, -3.645937, -0.024368, 2.754113, -0.858248, 7.116953, 0.988077, 
	-0.054750, 0.247895, 3.148466, -0.439281, 2.451329, -0.002921, -1.931982, -0.086824, -0.005744, -0.047590, -1.529840, -0.002967, -2.275671, -1.333285, 2.035479, -0.172315, 
	-0.007183, -0.002284, -0.765087, -0.502241, -0.774252, -0.001616, -2.149955, -0.001947, -0.001315, 0.725420, 3.303406, -0.001996, -0.831415, -0.265249, 1.000664, 0.275050, 
	-0.004158, -0.001267, -0.436038, 0.987363, -0.369986, -0.000210, -0.414105, -0.001303, -0.000728, -0.223699, -0.157035, -0.000222, 0.090973, -0.189786, 0.736112, -0.015910, 
	-0.037202, -0.023636, -9.232563, 7.039875, -4.588809, -0.009671, -4.917351, -0.029838, -0.016003, 19.343245, -4.259185, -0.009944, 0.502258, 0.439213, -4.061697, -0.138690, 
	-0.020389, 1.380716, -0.476220, -0.449833, -1.857385, -0.002049, 1.274851, -1.330084, -0.013666, 1.174282, -0.138568, -0.002096, 1.249043, 0.428378, -1.085404, -0.131574, 
	-0.011461, -0.008124, -2.967357, 1.839385, 0.543346, -0.002504, -3.268660, -0.016181, -0.005874, -0.669968, -1.000181, -0.002668, 2.183561, 5.109505, -1.591863, -0.130955, 
	1.984039, -0.068795, -12.999306, -6.669842, 5.733682, -0.023681, -16.394701, -0.096911, -0.047641, 18.439983, 1.244463, -0.024874, 10.304895, -1.681278, -0.230578, 0.530543, 
	-0.035079, -0.007963, 2.138078, -0.419550, -0.948443, -0.002095, -2.080457, -0.011246, -0.004630, -1.529887, -0.114527, -0.006621, 4.518681, -0.886708, -0.517417, -0.092136, 
	-0.734792, 0.536307, -3.025180, -3.891766, -1.567882, -0.057683, 2.092607, -0.323016, -0.135616, 0.028181, 3.167637, -0.074361, 3.513938, 2.930279, 0.393251, -2.851907, 
	-0.002754, -0.004245, -1.677517, -0.132890, -1.872262, -0.000813, -0.817123, -0.005082, -0.002531, 0.345693, 3.048166, -0.000927, -1.638541, 0.002347, 2.805659, -0.047179, 
	-0.017716, -0.007880, 2.327339, -2.367170, -1.809408, -0.002743, -0.783722, -0.008648, -0.005366, 1.338153, 0.194412, -0.002900, 1.129725, -0.606725, 0.689585, -0.066937, 
	-0.047134, -0.012791, -2.070205, 0.072295, 0.126823, -0.005443, 0.396430, -0.024495, -0.009911, 3.707798, -3.383621, -0.005631, 1.230331, -0.730683, 0.904775, -0.148539, 
	-0.008193, -0.002987, 0.994326, -0.595953, 1.714856, -0.000955, -0.867463, -0.003500, -0.002188, -0.382283, 0.683422, -0.000971, -1.840905, -0.014990, 0.369190, -0.041406, 
	-0.003830, -0.002036, 0.583460, -0.276282, -0.041585, -0.000745, 0.934594, -0.003761, -0.001574, -0.463500, 1.661457, -0.000783, -2.371220, -0.351028, 0.373348, -0.036514, 
	-0.009932, -0.019123, 0.232454, -1.752169, -0.606675, -0.002459, -0.991911, -0.019917, -0.004319, 1.128216, 4.440370, -0.002903, 0.170274, -0.529140, -2.003380, -0.029386, 
	-0.068278, -0.023560, -2.763751, 1.627542, 1.858042, -0.007603, 0.436700, -0.031280, -0.014170, -1.386562, -2.183086, -0.012245, -1.880841, 1.332565, 2.592144, 0.524382, 
	-0.074478, -0.013441, -1.684489, -0.311140, 2.416785, -0.001979, 0.499359, -0.019912, -0.007434, 0.075574, 0.701392, -0.002387, 0.249211, -1.681821, 0.019934, -0.165175, 
	-0.026245, -0.006165, 0.434481, -0.137657, 3.252182, -0.001802, -4.674629, -0.005494, -0.003604, -1.300114, 1.514463, -0.001715, 0.165320, 0.329927, 0.546203, -0.085150, 
	-0.154790, -0.026837, -1.071146, 1.113582, -5.191259, -0.007447, 1.482365, -0.046162, -0.017021, 0.885787, 1.782701, -0.007818, 4.550751, -3.349658, 0.310744, -0.253791, 
	-0.048607, -0.010915, 1.167686, 0.049289, -2.037005, -0.003357, 7.407023, -0.029410, -0.007603, -3.423044, -0.050874, -0.003593, -5.045594, 3.046480, -0.857261, -0.153216, 
	-0.006923, -0.006308, -0.745161, -0.185914, -1.369654, -0.001865, -1.107044, -0.006411, -0.003750, 2.197140, 5.743288, -0.002027, -3.471587, -1.100640, 0.090248, -0.023391, 
	-0.036549, -0.016933, 0.476793, -3.849967, 12.155732, -0.007717, -4.860417, -0.029766, -0.014943, -0.303356, 1.143787, -0.005237, -4.936954, 0.035751, 0.701630, -0.451854, 
	-0.117344, -0.008755, 1.899243, -0.029754, -2.745657, -0.004094, -0.107897, -0.012619, -0.007307, 5.980186, -1.724996, -0.004126, -1.733213, 0.594216, -1.836425, -0.141458, 
	-0.005334, -0.002834, 2.117041, -0.196526, -2.738782, -0.001222, 0.372575, -0.003497, -0.001990, 1.020362, 1.661195, -0.001289, -2.975665, -0.783131, 1.565545, -0.026447, 
	-0.058150, -0.024724, -1.122578, -2.994657, -1.973882, -0.011326, 3.837796, -0.053144, -0.018926, -0.732822, 0.184748, -0.011623, -1.755152, 4.923618, 0.023702, -0.212879, 
	-0.028067, -0.020882, 0.441662, 2.556151, 1.613807, -0.006203, -2.223546, -0.020486, -0.011099, -0.442762, -4.491326, -0.006451, 1.591507, -3.308587, 4.524380, -0.168099, 
	-0.027344, -0.003305, -0.339001, -0.245614, 0.858547, -0.001106, -0.478587, -0.006386, -0.002393, 0.031926, -2.583306, -0.001182, 3.813575, -1.538632, 0.561849, -0.039041, 
	-0.000551, -0.000646, 0.018155, 1.137526, 0.068653, -0.000146, 0.200635, -0.000562, -0.000355, 0.012673, -0.739629, -0.000117, -0.076471, -0.055885, -0.555989, -0.007290, 
	-0.005316, -0.004843, 0.012721, 3.103548, -1.234138, -0.002078, 3.611435, -0.015321, -0.003610, -2.008450, -0.629114, -0.002142, -0.765807, -1.336621, -0.590692, -0.129570, 
	-0.019881, -0.004115, -0.561757, 1.001203, 0.499556, -0.001121, -3.047600, -0.002972, -0.002251, 1.438132, -1.253664, -0.001143, 2.558799, 0.028096, -0.602006, -0.029277, 
	-0.039328, -0.004247, 1.338406, 1.424538, -1.889727, -0.001600, 0.584986, -0.021065, -0.003357, -0.219182, 2.826718, -0.001620, -2.972494, -0.144625, -0.833417, -0.043985, 
	-0.016989, -0.010730, -0.605014, 2.637051, -1.977580, -0.002319, -0.417460, -0.015403, -0.007756, 6.697005, -1.061627, 0.021384, -3.029013, -1.109047, -0.951934, -0.150566, 
	-0.006518, -0.004894, 0.182624, 2.531775, 2.111287, -0.001058, -3.653449, -0.011010, -0.003717, -0.744397, -3.962459, -0.001063, 2.842123, 1.533052, -0.760047, -0.052251, 
	-0.013744, 0.172354, 2.743181, 0.413319, -1.281603, -0.001495, -1.212392, -0.170141, -0.003209, -1.282339, -0.237494, -0.001568, 0.714248, -0.393535, -1.176049, 1.730466, 
	-0.082516, -0.034101, -3.699644, -1.840144, 0.556754, -0.009128, -2.260873, -0.034362, -0.019822, -0.266627, 1.632935, -0.009634, 1.229032, -1.296912, 6.419400, -0.284358, 
	-0.004961, -0.003145, -0.851906, -0.112439, -1.658610, -0.001138, -0.263986, -0.005106, -0.002133, 1.049619, 0.401884, -0.001159, -1.110337, 2.706670, -0.084258, -0.058996, 
	-0.018892, -0.004942, -0.552863, -0.129600, -1.697207, -0.002272, 3.700067, -0.006782, -0.003810, 1.370324, 0.069855, -0.002265, -3.849497, -0.681779, 1.928724, -0.119059, 
	-0.060078, -0.048678, 0.337171, -0.396717, -2.985951, -0.008280, 2.818892, -0.029874, -0.019980, -0.814096, 0.427026, -0.008782, 1.662987, 1.284667, -1.463787, -0.694520, 
	-0.006043, -0.004314, 1.146221, -0.796389, 0.408325, -0.000536, -1.111629, -0.007169, -0.002068, -0.705350, 2.196579, -0.000623, -0.903188, -0.086945, -0.104814, -0.022057, 
	-0.037082, -0.050478, -2.115676, 0.866103, -7.549598, -0.004730, 6.766656, -0.100763, -0.021627, -3.880249, 4.296258, -0.006015, -2.260228, 0.844445, 3.340770, -0.087789, 
	-0.031224, -0.008478, 1.947093, -0.322647, -1.425491, -0.003062, 3.156810, -0.104479, -0.006041, -0.923985, 0.548440, -0.003192, -0.164528, -3.494821, 0.906738, -0.071132, 
	-0.008621, -0.004109, 0.010013, 0.998644, 0.395328, -0.000914, -4.686992, -0.004363, -0.002417, 1.358318, 4.880663, -0.000968, -2.006918, -0.492594, -0.373281, -0.061789, 
	-0.009856, -0.003483, -0.208093, -0.012616, 2.030825, -0.001618, -1.322768, -0.003921, -0.002594, 3.001297, 0.739905, -0.001658, -2.143691, -1.773438, -0.239866, -0.048425, 
	-0.010908, -0.005080, 0.716749, 0.390338, 0.779952, -0.001636, 1.175631, -0.006605, -0.003054, 0.423309, 0.946092, -0.001599, -2.164813, -1.925135, -0.208965, -0.104275, 
	-0.053634, -0.019539, 1.677849, 0.095104, -4.114283, -0.001901, 2.788884, -0.016979, -0.009419, -1.120770, 0.450151, -0.002430, 0.972788, 0.988185, -1.547983, -0.086023, 
	-0.003962, -0.002063, -0.687013, -0.136471, 1.155002, -0.000762, 0.437155, -0.002809, -0.001452, 0.608698, -1.128792, -0.000795, -0.601078, 0.667354, -0.262337, -0.040675, 
	-0.029601, -0.010394, 0.791523, 0.073421, 0.438941, -0.002229, -2.743018, -0.037299, -0.006025, 0.848051, -3.822371, -0.002594, 5.210604, 0.377087, -0.921558, -0.164537, 
	-0.025818, -0.011059, -0.733444, 0.036879, -1.713217, -0.002986, -2.174206, -0.018452, -0.007326, -1.183207, -1.292122, -0.007537, 5.878430, -0.304093, 1.976734, -0.418577, 
	-0.001143, -0.001143, 0.288190, -0.214373, -0.381657, -0.000332, -0.169477, -0.001449, -0.000762, 1.178686, -0.095229, -0.000345, -0.262313, -0.235397, -0.101577, -0.001680, 
	-0.066360, -0.016347, -0.304063, 0.069716, -3.491755, -0.004881, 2.562455, -0.026913, -0.010538, -2.459950, -1.502146, -0.005019, 3.428258, 0.765722, 1.270093, -0.208272, 
	-0.024442, -0.009118, 0.070967, 2.469764, -1.435220, -0.002871, 7.491612, -0.039344, 0.079614, -0.715666, -0.001506, -0.003065, -5.956955, 0.017564, -1.692824, -0.248511, 
	-0.029200, -0.021483, 0.008007, 2.723017, 0.459462, -0.009820, -4.041245, -0.041676, -0.015772, -2.581494, 0.031684, -0.010311, 2.531581, 0.467145, 0.507912, 0.022193, 
	-0.005996, -0.006387, 0.026958, 0.174577, -1.819498, -0.001517, -5.267841, -0.006762, -0.003707, 0.584137, 1.139679, -0.001682, 3.651732, 2.507815, -0.944667, -0.026841, 
	-0.034925, -0.029547, -3.062757, 0.077982, -2.854223, -0.006286, -2.173578, -0.028582, -0.015168, 6.328274, 5.635379, -0.136047, 1.016654, -3.826423, -0.982510, 0.091757, 
	-0.139323, -0.064249, -0.445553, 3.555113, 2.726069, -0.013348, -1.422290, -0.161820, -0.038803, -3.570571, -4.080528, -0.017451, 3.002128, 1.978184, -1.719090, 0.411532, 
	-0.033267, -0.033836, -0.469250, 1.663879, -0.844625, -0.007260, 3.569510, -0.114769, -0.023343, 0.702810, 0.074687, -0.009010, -1.396255, 1.533072, -4.743056, 0.130713, 
	-0.003035, -0.002292, 0.025912, 0.965898, 0.924423, -0.001029, -1.466253, -0.017457, -0.002318, 0.662026, -0.307123, -0.130510, 0.467092, -1.051127, 0.009423, -0.073630, 
	-0.019706, -0.010650, -1.719479, 0.094380, 3.211438, -0.003233, -2.226321, -0.010552, -0.006567, 0.420197, 1.567342, -0.003302, -0.265712, -2.600950, 1.724116, -0.151002, 
	-0.016595, -0.011590, -1.087027, 3.894619, -0.682571, -0.004424, -2.361188, -0.012522, -0.007563, 1.452403, 11.024375, -0.004542, -9.757285, -1.167044, -1.141364, -0.117680, 
	-0.009325, -0.007871, 4.093719, -1.057577, 1.164115, -0.002524, 2.496633, -0.008329, -0.004906, -1.945658, -4.217401, -0.002637, 0.155547, -1.488895, 0.966018, -0.130908, 
	-0.018772, -0.015619, -1.136469, -0.649019, 0.683708, -0.002659, 5.408364, -0.017454, 0.051443, 2.369431, -2.118824, -0.003337, -1.801831, -1.057148, -1.366906, -0.324907, 
	-0.081939, -0.021061, 1.026433, 1.338696, -1.686644, -0.004531, -1.514726, -0.035153, -0.012813, 0.751664, -2.334829, -0.005203, 1.486983, 0.878940, -1.133825, 1.348008, 
	-0.021900, -0.008856, -0.742405, 5.418282, 0.830449, -0.003643, -1.166116, -0.011619, -0.006302, 0.407067, -3.045740, -0.003783, 0.447307, -1.174637, -0.707497, -0.210608, 
	-0.009132, 0.013076, 4.249300, -0.587866, 0.320670, -0.003289, -0.524855, -0.034045, -0.005862, -3.033226, -2.250207, -0.003440, 5.006846, -0.924081, -2.014676, -0.199214, 
	-0.027472, 0.235432, 0.808641, 0.364040, -0.909529, -0.002647, -0.773486, -0.085509, -0.005193, 1.597461, 0.048030, -0.002367, 0.486174, -0.376208, -2.212809, 0.855442, 
	-0.042626, -0.017771, 5.116973, 0.064733, 2.854434, -0.005905, -5.802773, -0.031742, -0.011834, -0.385099, -2.063844, -0.006097, 1.108373, 0.360678, -1.017899, -0.119601, 
	-0.024131, -0.019402, -0.710290, 2.989828, -6.790172, -0.005060, 2.453069, -0.018816, -0.009881, 3.594771, -3.912720, -0.005177, 0.915912, 0.873210, 0.581571, 0.087288, 
	-0.026290, -0.023759, 0.114734, -2.674738, 1.402272, -0.003588, -0.467731, -0.061752, -0.013614, -3.593081, -2.286681, -0.004093, 4.978476, 3.404672, -0.536619, -0.208209, 
	-0.004838, -0.001720, -0.858288, 0.649236, -1.577985, -0.000634, 4.025035, -0.005023, -0.001445, -0.451209, -3.064604, -0.000669, 1.486153, 0.297279, -0.446722, -0.044566, 
	-0.545418, 0.075180, 5.047121, -0.714762, 1.402734, -0.044352, -0.765254, -0.246688, -0.103210, -0.199805, -3.055234, -0.057561, 0.263913, -2.483402, 0.486228, 0.940510, 
	-0.009397, -0.005955, -0.764110, -0.387011, -0.591454, -0.001179, -0.510619, -0.004110, -0.002736, 1.705597, -0.147841, -0.001228, 0.911029, -0.625056, 0.489030, -0.054959, 
	-0.021388, -0.015661, 0.312265, -1.154922, 2.596531, -0.003816, -0.561121, -0.034894, -0.011227, -0.843218, -0.630122, -0.003809, 4.927009, 0.025817, -4.400576, -0.180869, 
	-0.009444, -0.007190, 0.339868, -1.031865, -8.235274, -0.003795, 10.072739, -0.009832, -0.004882, 0.034760, -6.502394, -0.003904, 5.830265, -0.780700, 0.113449, 0.198198, 
	-0.007187, -0.002864, -0.887655, -0.478732, -0.579341, -0.001128, -1.174722, -0.003700, -0.002424, 0.147660, 0.030728, -0.000965, 0.198023, 0.099198, 2.675909, -0.012801, 
	-0.010745, -0.009860, 4.154963, -0.544306, -0.289671, -0.004117, 3.541026, -0.008630, -0.005641, -2.988641, -5.502182, -0.004254, 2.608934, -0.830943, -0.043272, -0.062659, 
	-0.014259, -0.006010, 0.874541, -1.414559, 0.405583, -0.002465, -0.511049, -0.011181, -0.004747, 0.842461, -1.271534, -0.007057, 2.468866, -0.004666, -1.324359, -0.019565, 
	-0.010428, -0.008474, 1.263265, 3.377224, -2.398868, -0.002365, -0.453585, -0.011868, -0.005268, -0.826358, 0.201571, -0.002492, 1.431173, -0.639770, -1.676155, -0.237601, 
	-0.011287, -0.008075, 2.540505, -0.645133, -1.192433, -0.002192, 1.637330, -0.016777, -0.005627, -1.901289, -1.851043, -0.002296, 4.432537, -2.287258, -0.423000, -0.263963, 
	-0.012081, -0.006419, -0.763698, 3.756835, 0.055601, -0.001400, -0.371840, -0.022168, -0.003993, 0.103882, 2.237245, -0.001770, -3.766208, -0.982558, -0.185109, -0.036319, 
	-0.000542, -0.000473, -0.247908, 0.528771, -0.357603, -0.000209, -0.488697, -0.000761, -0.000394, -0.044598, -0.005344, -0.000219, 0.322823, -0.090864, 0.388231, -0.002213, 
	-0.147154, -0.035413, 1.139244, -1.747020, 1.151222, -0.008099, 0.695244, -0.037818, -0.022888, -0.269042, -1.893506, -0.008677, -0.249411, 1.108473, 0.476736, -0.151890, 
	-0.018800, -0.011608, 0.690257, -2.575500, -2.639986, -0.003689, 2.458157, -0.036063, -0.007579, 1.258222, 8.715965, -0.004315, -7.974833, -0.547402, 0.796390, -0.099217, 
	-0.006833, -0.003949, -0.076590, -0.125761, 0.755181, -0.001316, 2.777287, -0.009999, -0.002780, -1.075860, -3.254725, -0.001364, 0.180830, 2.031898, -1.121002, -0.065017, 
	-0.009574, -0.002636, 0.096745, 1.324185, -0.006810, -0.000641, 0.362605, -0.003208, -0.001512, 0.027522, -0.715654, -0.000683, 0.930975, -1.961270, 0.030044, -0.070088, 
	-0.001351, -0.002373, 0.279132, 0.358230, -0.076564, -0.000480, 0.003830, -0.002761, -0.001169, -1.153805, -0.170346, -0.000527, -0.862840, -0.035862, 1.813471, -0.146586, 
	-0.021065, -0.014595, -0.561328, -3.470124, -0.283333, -0.003997, -2.445268, -0.040026, -0.000100, 3.492357, 1.681878, -0.004179, -1.353399, 3.705567, -0.613861, -0.068529, 
	-0.013939, -0.006148, -1.660874, -0.495990, 0.868181, -0.001184, 2.168041, -0.009038, -0.003966, 2.419401, 0.026759, -0.001336, -2.366869, -1.246961, 0.868781, -0.544859, 
	-0.000527, -0.000490, -0.612343, -0.015376, -0.099773, -0.000312, 0.213715, -0.000657, -0.000473, 0.307183, -0.796559, -0.000315, -0.131659, 0.760798, 0.377816, -0.001028, 
	-0.012443, -0.009322, -0.435774, -3.363732, 1.561710, -0.002830, 0.945121, -0.015968, -0.016232, -3.128721, -0.963222, -0.002993, -1.061339, 6.256047, 0.319852, -0.070154, 
	-0.031490, -0.015043, 1.043209, -0.041265, 0.457168, -0.003804, 0.071408, -0.061198, -0.009474, 0.031623, -5.183808, -0.004191, 2.975075, 1.336371, -0.491870, -0.072712, 
	-0.022443, -0.006367, 3.447400, -2.280722, -1.923295, -0.002128, 0.390328, -0.012043, -0.004774, 1.779922, -0.775763, -0.002318, -0.822308, -1.154608, 1.592387, -0.203268, 
	-0.083998, -0.013144, -0.472111, 1.238294, 0.902673, -0.004328, -3.311459, -0.016692, -0.009133, -1.488894, 3.955080, 0.044208, -0.498355, 1.209499, -1.320504, -0.131135, 
	-0.002105, -0.002092, 0.215499, -0.104147, -0.887509, -0.000597, 0.505614, -0.002855, -0.001304, 0.018056, -1.475312, -0.000599, 1.943504, -1.042270, 0.863339, -0.027223, 
	-0.011785, 1.994179, -0.226859, -0.439662, 2.758095, -0.005281, -4.651762, -1.851451, -0.008182, -0.585493, 1.408819, -0.005362, 2.127369, -0.314422, -0.159357, -0.028846, 
	-0.001625, -0.002112, -0.339172, 0.398610, 1.271746, -0.000417, -0.912057, -0.002151, -0.001360, 0.960833, -1.746566, -0.000666, 0.745880, -0.054278, -0.308903, -0.007762, 
	-0.000661, -0.001413, 0.173905, 0.228463, 0.002155, -0.000276, -0.244900, -0.001046, -0.000666, -0.074081, 0.502103, -0.000299, -0.015260, -0.057348, -0.491914, -0.018762, 
	-0.000569, -0.000531, -0.921383, -0.976889, 0.047765, -0.000329, -0.088483, -0.001024, -0.000506, 1.477418, 0.082715, -0.000333, -0.028715, 0.521194, -0.104740, -0.005590, 
	-0.000852, -0.001245, 3.333090, -0.516771, -0.486895, -0.000351, 0.002820, -0.006844, -0.000978, -1.078024, 0.061974, -0.000353, -0.720771, -0.335836, -0.243081, -0.005883, 
	-0.037740, -0.021550, -5.833897, -1.390803, -0.092678, -0.008374, 4.204387, -0.033538, -0.015619, 4.358071, -1.908918, -0.008471, -3.409942, -1.949017, 3.448040, 2.700051, 
	-0.017223, -0.009852, 3.148475, 2.697048, -1.622703, -0.003389, 4.150239, -0.011616, -0.006603, 2.760250, -1.868516, -0.003528, -5.524024, -1.701254, -1.695778, -0.291525, 
	-0.007740, 2.792022, -0.156951, -0.393942, -1.254857, -0.004520, 0.160844, -2.618760, -0.038205, 0.203207, 2.276917, -0.004569, -1.220479, -0.569899, 0.865663, -0.028730, 
	-0.010059, -0.005498, -2.035080, 1.407897, 0.030409, -0.001643, -1.028856, -0.011311, -0.003702, -1.634012, -4.247867, -0.001631, 7.647763, -1.280673, 1.369706, -0.195443, 
	-0.175193, -0.082851, 0.682404, 1.828315, -1.654311, -0.017300, 1.061903, -0.140617, -0.061729, 0.302076, 1.734029, -0.019621, 2.873868, 0.819816, -4.850865, -2.299923, 
	-0.021782, 0.010923, -1.702715, 1.139050, 0.655338, -0.002119, -2.595957, -0.039368, -0.006306, 4.271396, -1.625315, -0.002443, 0.539661, -0.466882, 0.028929, -0.182410, 
	-0.016332, -0.007168, 0.657586, -1.026411, -0.760219, -0.001048, -0.987882, -0.014277, -0.003437, 0.349077, 5.010921, -0.000980, -2.005297, -0.460512, -0.610867, -0.123152, 
	-0.068925, -0.012005, 5.450024, -2.910501, -3.707002, -0.004620, 0.329399, -0.039157, -0.009861, -0.052889, 3.731739, -0.004949, -5.936320, 0.752841, 0.768350, 1.713876, 
	-0.046522, -0.020263, -2.644885, -2.209524, -7.897600, -0.008140, 24.548532, -0.019142, -0.011592, -3.810345, -14.939591, -0.009071, 9.239522, -1.261616, -1.188356, 0.278593, 
	-0.002207, -0.002894, 0.230572, 1.890250, -0.869996, -0.000475, 0.621812, -0.003666, -0.001276, -0.127318, -0.471392, -0.000529, -0.509472, -0.548706, -0.197755, -0.006950, 
	-0.020107, -0.011814, 0.326386, 1.932045, 0.839975, -0.003567, -1.100399, -0.019279, -0.008125, 0.366463, -3.192243, -0.003849, 0.274056, -0.166169, -0.258132, 1.044756, 
	-0.015890, -0.004429, -0.094139, -1.309986, 0.066079, -0.001598, -2.055707, -0.004409, -0.002970, -0.162991, 4.933245, -0.001677, -4.432673, -0.336418, 3.458653, -0.035089, 
	-0.033649, -1.418668, 5.148877, 4.255276, -4.803141, -0.011266, 7.583883, 1.368323, -0.024546, 5.818543, -2.683851, -0.011710, -5.642580, -4.300354, -4.450384, -0.794754, 
	-0.027024, -0.019993, 2.668365, 0.524770, -3.840945, -0.004903, 0.907178, -0.041465, -0.012673, -1.336699, 0.490119, 0.043323, 2.021281, 1.169190, -2.279319, -0.261205, 
	-0.048765, -0.013346, 7.249823, -1.502546, -1.974983, -0.005176, -2.899178, -0.009569, -0.007771, -1.631025, 2.082933, -0.005266, 0.354262, -0.256612, -1.182429, -0.150351, 
	-0.007747, -0.001863, 1.610299, -0.057803, -1.114336, -0.000507, -1.679412, -0.004174, -0.001426, -1.075380, -0.908925, -0.000554, 3.323710, -0.414447, 0.348466, -0.015903, 
	-0.005858, -0.002676, -1.729697, 2.095864, -0.461424, -0.000862, 0.272333, -0.004464, -0.001652, 1.397639, -2.784527, -0.000901, 1.316401, -0.354256, 0.301199, -0.037120, 
	-0.773791, -0.468509, 0.565107, 3.302051, 0.363060, -0.215372, -0.817282, -0.971577, -0.383513, 0.760373, -1.848985, -0.536900, -1.792676, 1.846022, 1.860729, -0.888739, 
	-0.024268, -0.012107, 0.148910, -1.902850, 4.086755, -0.003035, -0.147258, -0.010069, -0.006664, 0.882485, 0.279174, -0.003185, -2.679255, -2.258511, 1.691641, -0.041764, 
	-0.038559, -0.001717, -0.477259, 0.391898, -0.369300, -0.000386, 0.293149, -0.002632, -0.001197, 0.046047, 2.945655, -0.000407, -2.309218, -0.262451, -0.118140, -0.095482, 
	-0.006697, -0.005934, 1.221090, -0.687920, -1.399395, -0.001119, 2.691750, -0.006365, -0.004005, 0.595304, -1.577715, -0.001777, 1.195023, -1.087856, -1.185789, 0.261404, 
	-0.010102, -0.012959, 5.613638, -2.940986, -1.802685, -0.001922, -3.125561, -0.017202, -0.007622, -0.998789, 4.778740, -0.002075, -0.993899, 0.910129, -1.297851, -0.090854, 
	-0.022851, -0.015765, 1.265259, 0.009935, -2.564697, -0.003880, 4.253104, -0.021892, -0.009310, 3.165693, -0.438711, -0.004162, -1.549051, -0.967920, -2.759416, -0.336336, 
	-0.090942, -0.006809, -0.980523, -0.371331, -4.318492, -0.001457, -0.255862, -0.006195, -0.003696, -1.416879, 4.789251, -0.001579, 1.567218, 1.761771, -0.632020, -0.032455, 
	-0.097657, -0.029735, -1.355368, -2.053424, -0.661597, -0.015642, -4.789154, -0.044177, -0.022187, 7.205619, -4.359746, -0.016078, -0.215542, 0.594831, 5.656223, 0.203634, 
	-0.004581, -0.003861, 0.875751, -0.182119, 1.367603, -0.001108, -0.679147, -0.002993, -0.002359, -0.984764, 0.524546, -0.001182, -1.207305, 0.166681, 0.157857, -0.023020, 
	-0.021247, -0.022918, 2.657827, -1.163546, -2.222319, -0.003829, -0.437296, -0.085677, -0.014729, 2.349669, 0.727572, -0.004635, -2.155203, -2.416816, 3.360932, -0.547785, 
	-0.005092, -0.003809, 1.773557, 1.559494, -0.858897, -0.001076, 0.992186, -0.004179, -0.001931, -1.034332, -2.674624, -0.001107, -0.974717, -0.673386, 1.656754, 0.251158, 
	-0.011970, -0.014961, 0.562303, -0.111500, -0.649270, -0.001443, 2.296622, -0.023607, -0.006882, -0.949863, -0.530867, -0.001572, -2.752825, 2.174002, 0.448198, -0.426363, 
	-0.011276, -0.004971, -1.062364, -1.383360, -0.574155, -0.001971, 1.663853, -0.005900, -0.003417, 1.053556, 2.609417, -0.002061, -2.074014, -0.880803, 0.736121, -0.058655, 
	-0.010810, -0.004375, -0.896542, -0.973005, 1.591972, -0.001598, 13.387414, -0.010210, -0.003491, -0.554216, -9.186565, -0.001683, -2.049248, -0.287200, -0.885693, -0.114748, 
	-0.052577, -0.018750, -4.992800, -0.578561, -1.489542, -0.005553, 5.024895, -0.022926, -0.011335, -0.907462, 1.779546, -0.005871, 0.577155, 0.518691, -0.893534, 1.078627, 
	-0.018641, -0.015026, -1.398260, 0.489087, 0.295285, -0.003468, -4.203725, -0.016700, -0.008158, 0.378334, 5.252590, -0.003657, -3.086550, 3.831256, -1.243310, -0.249054, 
	-0.005043, 0.010037, -1.816763, -1.517049, -1.264678, -0.001340, 1.191530, -0.013297, -0.002553, 0.716336, -3.423920, -0.001452, 5.010190, -0.246374, 1.625050, -0.260673, 
	-0.007905, -0.011085, -1.527621, 1.354953, -0.283651, -0.001859, -2.567147, -0.014616, -0.006102, -0.006549, 3.538750, -0.001957, -2.023515, 1.810409, -0.089644, -0.162462, 
	-0.007229, -0.006127, -0.549330, -0.694903, 0.929176, -0.002474, 2.246728, -0.009790, -0.004836, 0.308792, -2.863752, -0.002475, -1.233536, 0.865153, 1.105263, -0.080661, 
	-0.001377, -0.001108, -0.110175, 0.634763, -0.196972, -0.000358, 0.150729, -0.000790, -0.000603, -0.183707, -2.391512, -0.000368, 1.895597, -0.132111, 0.340340, -0.002347, 
	-0.028268, -0.002183, 0.899331, 0.117654, 0.039511, -0.000801, 0.044900, -0.011389, -0.001680, -1.290990, -1.342012, -0.000844, 1.096124, 0.816230, -0.308695, -0.026889, 
	-0.021031, -0.008412, 1.596999, 1.907413, 3.356891, -0.002454, -1.741511, -0.038945, -0.006060, -1.531275, -2.950294, -0.002572, 0.722774, -0.334406, -0.844302, -0.102814, 
	-0.040671, -0.016201, 0.103599, 0.221601, -0.811570, -0.004632, 1.534375, -0.025183, -0.009904, 1.067548, 2.675137, -0.005030, -7.295331, 1.808616, 0.620286, 0.177362, 
	-0.047520, -0.007497, 0.831144, 0.834840, -1.503029, -0.002850, 1.115580, -0.007611, -0.005276, -0.786963, -3.403285, -0.002776, 0.912861, 0.412241, 1.761931, -0.101791, 
	-0.021786, 1.285583, -0.668220, 1.163124, -1.892476, -0.002418, 0.409136, -1.305895, -0.004662, 1.326485, -0.321855, -0.011145, -1.706314, -0.248771, 2.209305, -0.210090, 
	-0.039251, -0.011224, -0.220804, -2.052761, 1.869352, -0.002266, 5.811658, -0.014724, -0.005897, 0.151979, -0.472932, -0.002465, -4.330970, 0.371658, -0.782535, -0.268819, 
	-0.008942, -0.004248, -0.399490, 0.482770, 5.181994, -0.002436, -2.319827, -0.009971, -0.003689, -1.226957, -1.547858, -0.002443, -0.522889, 0.025283, 0.395410, -0.036708, 
	-0.018285, -0.011134, 2.607108, 1.319063, -5.460248, -0.002992, -2.175380, -0.036415, -0.007692, -2.525927, -4.314741, -0.003258, 10.678436, -1.485282, 1.577184, -0.140440, 
	-0.011923, 1.188306, -0.231838, -0.736204, 1.286997, -0.003669, 2.601684, -1.149955, -0.006267, -2.187914, 1.982082, -0.003811, -5.348442, 1.893261, 0.850410, -0.122719, 
	-0.022423, -0.004703, 0.698981, -0.643716, 5.930633, -0.002106, 1.570952, -0.027424, -0.004075, -1.645112, -3.253826, -0.002201, -0.985548, 0.405075, -1.953894, -0.060613, 
	-0.041818, 0.474520, -0.751399, 0.279987, -2.800770, -0.008270, -4.273604, -0.488646, -0.011245, -2.434950, 2.785190, -0.008279, -4.594854, -0.744663, 12.661692, -0.042890, 
	-0.013062, 1.258846, 1.295358, 1.165059, -0.191222, -0.011673, -1.169037, -0.704818, -0.046095, -1.249281, 0.097572, -0.011862, 0.354341, 0.039007, -0.799441, -0.013691, 
	-0.020242, -0.007810, 0.099947, 2.449168, -1.765429, -0.001953, 1.316754, -0.016717, -0.004592, -1.075339, -1.682011, -0.002038, 2.271797, -1.669569, 0.232787, -0.124751, 
	-0.020707, -0.007471, 1.802206, 1.591981, -3.482776, -0.001789, -0.271362, -0.020196, -0.004690, -0.071132, -2.146189, -0.001895, 3.072273, -1.448491, 1.045135, -0.034897, 
	-0.017344, -0.011694, -1.462121, -1.353177, -1.621352, -0.001121, 2.435832, -0.010867, -0.004159, 1.796440, 1.235549, -0.001220, -0.180272, -0.027844, -0.708289, -0.068361, 
	-0.014531, -0.007546, 0.622833, 0.957489, 2.806734, -0.007259, -0.689388, -0.010898, -0.006084, -0.957228, -1.356226, -0.007558, -0.691559, -1.044757, -0.511900, 0.917878, 
	-0.019074, -0.004733, 0.075198, 0.969820, -1.106656, -0.001665, 1.773160, -0.010628, 0.036105, -0.619347, 1.391311, -0.001726, -1.426607, -0.749421, -0.275280, -0.030458, 
	-0.012854, -0.007328, -1.810893, 1.328222, 2.594027, -0.002029, -0.813092, -0.007511, -0.004413, 0.678596, 1.630607, -0.002405, -1.780746, -0.874135, -0.824149, -0.091897, 
	-0.110204, -0.099373, 4.600011, -2.335673, 1.500697, -0.045108, -2.444762, -0.091952, -0.066846, 6.748817, -5.009316, 0.027347, 0.239287, -4.712605, 2.363873, -0.564193, 
	-0.003763, -0.001970, 1.044794, 0.176253, -0.797699, -0.001086, -0.410235, -0.001908, -0.001456, -1.470740, 0.943347, -0.001103, 0.486010, -0.150571, 0.206688, -0.016560, 
	-0.028751, -0.011688, -0.296088, 2.403103, -2.580167, -0.004313, 0.231451, -0.015002, -0.008855, 0.056367, -3.259342, -0.004595, 2.053619, 1.477965, 0.116593, -0.130300, 
	-0.031031, -0.007847, -0.878352, 6.362845, -0.677068, -0.002905, -0.778095, -0.006773, -0.004844, -1.203981, 0.568079, -0.002946, -1.744737, -0.745370, -0.796414, -0.050561, 
	-0.044001, -0.036066, 3.078870, 3.378176, -0.714691, -0.009788, -2.952335, -0.063102, -0.021464, -1.990031, -3.132142, -0.010480, 0.739386, 1.983780, 0.365254, -0.571367, 
	-0.124632, -0.062886, -1.014775, -2.703586, 3.991581, -0.021940, 0.620890, -0.089582, -0.042093, 3.785352, -2.960867, -0.022768, 3.352626, -1.098034, -1.851528, -1.757757, 
	-0.036754, -0.020178, -4.325094, 2.868165, 1.630153, -0.006470, 1.803878, -0.039632, -0.013065, 1.096240, -1.748082, -0.006687, -3.215583, -0.485958, 2.646099, -0.147033, 
	-1.070462, -0.397381, -3.866021, 2.705472, 3.342220, -0.257990, 0.256311, -0.683617, -0.366687, -2.219959, 1.299173, -0.197779, 1.416204, -3.174230, -1.498760, 4.713505, 
	-0.062206, -0.005908, 4.350813, 0.415589, -2.628289, -0.001372, 0.724070, -0.006269, -0.003306, -1.137390, 2.316473, -0.001565, -2.979432, -0.576211, -0.353628, -0.051371, 
	-0.950312, -0.531287, 0.835420, 2.445925, 1.865836, -0.202112, -2.175479, -0.785406, -0.375235, 0.319247, -0.948799, -0.526920, 1.046258, 1.222631, -4.372127, 3.132362, 
	-0.013751, -0.002742, -0.380381, 0.364875, 0.448394, -0.000739, -0.433394, -0.008486, -0.002134, -0.666646, -1.405629, -0.000836, 2.750552, 0.236810, -1.383948, 0.498057, 
	-0.003927, -0.002100, -0.183342, 3.926735, -0.431851, -0.000764, 0.885091, -0.003266, -0.001492, -2.799049, 0.289794, -0.000813, -1.078861, -0.146024, -0.444796, -0.005335, 
	-0.022635, -0.006060, 0.079061, 0.575579, 3.047113, -0.002704, -2.220669, -0.085359, -0.007438, -2.222754, 1.238151, -0.002810, -0.674468, 0.145072, -0.951678, 1.111598, 
	-0.009862, 0.130318, 0.808655, 0.798958, -2.799536, -0.002440, 2.310976, -0.147121, -0.005588, 0.133882, 2.172708, -0.002607, -3.475403, -0.441289, 1.062964, -0.534614, 
	-0.006639, -0.003849, 0.757899, 0.632412, -1.459853, -0.001419, -0.615058, -0.004088, -0.002739, -0.224042, 1.204468, 0.047357, -0.167920, -0.435212, 0.365512, -0.086829, 
	-0.014415, -0.003801, -0.134933, 1.696687, 2.068844, -0.001756, -0.328527, -0.007139, -0.003261, -1.169191, -1.652199, -0.001775, 1.952451, -0.911581, -1.400032, -0.089372, 
	-0.002447, -0.003066, -0.368915, -0.354714, 0.482851, -0.000709, -0.034389, -0.003601, -0.001757, -0.134692, 3.720058, -0.000733, -2.551292, -0.428348, -0.298747, -0.019499, 
	-0.005034, -0.003518, -0.141650, -0.823483, -0.198449, -0.000891, -0.518893, -0.004685, -0.002069, 0.324069, 1.300799, -0.000950, 0.176837, -0.186703, 0.111514, -0.026892, 
	-0.001801, -0.001156, -0.076559, 0.851568, -0.628795, -0.000326, -0.585006, -0.001012, -0.000646, -0.438789, 2.164590, -0.000344, -1.469172, -0.235344, 0.465380, -0.042588, 
	-0.022796, -0.006900, -0.346553, 1.732065, 2.686620, -0.000918, -1.908507, -0.004146, -0.001986, -1.084544, -2.211683, -0.000928, 1.489923, 0.060666, -0.255721, -0.124592, 
	-0.004269, -0.003390, 3.400211, -0.621360, -0.074728, -0.001978, -0.117962, -0.003864, -0.002718, -2.300646, -1.874821, -0.002314, 1.157485, 0.161890, 0.321970, -0.033506, 
	-0.083047, -0.034479, -2.505716, -3.831046, 6.995044, -0.008713, 22.490923, -0.032189, -0.018317, 13.513316, -10.724420, -0.009231, -16.588531, -4.267290, -3.880449, -1.015856, 
	-0.021501, -0.007506, -0.100244, 0.045907, -2.593564, -0.002585, -2.221817, -0.007766, -0.004833, 0.298525, 4.921299, -0.007110, -1.533327, -1.300206, 2.687703, -0.152975, 
	-0.074358, -0.041426, -0.708296, 2.703358, -0.601244, -0.006134, -0.020287, -0.027585, -0.014769, -0.016804, 2.321899, -0.006586, -4.265478, -2.367232, 2.097556, 1.027389, 
	-0.009826, -0.007653, 1.588391, -1.293530, -1.952285, -0.001240, 0.191357, -0.013658, -0.004204, -0.830789, 0.000190, -0.001354, 1.111641, -0.470862, 1.837981, -0.144158, 
	-0.033855, -0.013599, 2.681773, -2.800978, -2.387528, -0.003858, 0.404063, -0.018954, -0.009087, -0.989753, 2.170656, -0.004100, -0.678908, 1.351820, 0.628484, -0.296173, 
	-0.011032, -0.005828, 1.563508, -1.523891, 0.175911, -0.001604, -0.840696, -0.031432, -0.000499, 0.275287, -2.061106, -0.005996, 1.736004, 0.915624, -1.609782, 1.425530, 
	-0.011307, -0.004888, -0.739540, 3.782740, -0.061487, -0.001929, 2.814418, -0.007751, -0.003849, -2.295075, -0.136362, -0.001964, -2.368032, -0.841873, -0.082743, -0.040359, 
	-0.002639, -0.000800, 0.160857, 0.113975, 0.083139, -0.000360, 0.084122, -0.001068, -0.000603, -0.404213, -2.261032, -0.000376, 1.930375, -0.161562, 0.465914, -0.005728, 
	-0.035963, -0.013777, 1.254229, 0.040612, 5.214197, -0.004972, 3.118574, -0.016718, -0.008906, -3.632164, -4.066706, -0.134455, 0.205966, 1.857736, -3.674136, -0.103517, 
	-0.012800, -0.296849, -0.740399, 2.339349, -1.020295, -0.002465, -0.999225, 0.273276, -0.005181, -0.840916, -0.486014, -0.002607, -0.230162, 0.332383, 1.291302, 0.400603, 
	-0.740435, -0.194691, -0.387077, -3.222962, 2.722116, -0.063998, 3.497260, -0.252757, -0.126768, 0.559939, 2.338334, -0.204070, 2.323910, -3.691906, -0.600350, -1.956546, 
	-0.005808, -0.004614, -1.146884, 7.494232, 1.272647, -0.001525, -1.082424, -0.004891, -0.002925, -2.989082, -5.122519, -0.001585, 3.456897, -0.899313, -0.817066, -0.145141, 
	-0.005297, -0.004005, -0.851177, 0.042489, 0.043387, -0.001669, -1.852547, -0.005099, -0.002896, 5.288939, -2.173239, -0.001720, 1.316901, -1.148829, -0.612372, -0.032866, 
	-0.119627, 0.329678, -5.102110, -0.235222, -0.354481, -0.009543, -0.737344, -0.271866, -0.027299, -2.824286, 1.322412, -0.010483, 4.215219, 4.014426, 0.178051, -0.367526, 
	-0.086116, -0.025856, 1.474420, 2.196938, 1.127244, -0.010288, -0.183901, -0.217724, -0.023652, 0.698368, -0.243303, -0.015506, -2.902533, 1.352298, -2.610489, -0.529901, 
	-0.048593, -0.032728, -2.134856, 2.226868, 1.705251, -0.004466, -4.837790, -0.047536, -0.016042, -2.629534, -0.341479, -0.005032, 1.324436, 5.629249, -0.472280, -0.315468, 
	-0.007521, -0.002167, -0.646945, -0.569007, -0.394998, -0.000523, 1.394087, -0.003614, -0.001278, -0.375725, 0.727892, -0.000579, 0.232159, -0.116820, -0.214028, -0.020933, 
	-0.003114, -0.002585, -0.464307, 1.279226, 0.983884, -0.000924, -0.762392, -0.002882, -0.001856, -0.089634, 0.126352, -0.000981, 0.141261, -1.040023, -0.140872, -0.021154, 
	-0.016381, -0.011602, 6.662906, -2.503260, -0.948902, -0.008394, -0.755675, -0.012438, -0.010448, 1.360545, -0.803964, 0.015905, -0.229718, -1.649899, -0.889568, -0.199108, 
	-0.071582, -0.017425, -1.438579, -1.041396, -2.784835, -0.006118, 2.795023, -0.036252, -0.011968, -3.926420, -5.071481, -0.135949, 7.529030, 3.856553, 0.801540, -0.440140, 
	-0.059263, -0.014464, -1.369849, 0.542349, -1.380453, -0.003645, -3.707903, -0.017139, -0.008035, 2.075768, 5.951496, -0.003806, -1.893475, 0.778156, -0.682745, -0.206991, 
	-0.156515, -0.060133, 5.734828, -2.656370, -0.104229, -0.021737, 1.007748, -0.086195, -0.043485, -1.413621, -0.695716, -0.152180, -1.669863, 5.220018, -3.971056, -0.931495, 
	-0.048106, -0.013804, 2.497511, 0.826834, -2.635228, -0.002518, -2.729919, -0.028603, -0.008784, 0.558280, 3.993603, -0.002923, -3.662860, 2.483685, -1.088926, -0.138242, 
	-0.026934, -0.034367, 1.835469, -0.505549, 0.842077, -0.002287, -0.925529, -0.010661, -0.005362, -1.143361, 0.782054, -0.002528, -3.810051, 2.261833, 0.864481, -0.119286, 
	-0.007801, -0.003492, 0.330638, 1.551476, 0.052213, -0.000851, 0.869999, -0.003453, -0.001895, -0.286162, -4.909185, -0.000882, 1.243606, -0.146344, 1.347720, -0.035586, 
	-0.662643, -0.141651, -4.877119, -2.192003, -0.041230, -0.061988, -0.496865, -0.284111, -0.128969, 1.670815, 9.079416, -0.064648, 1.308141, 1.455427, -2.686378, -1.876195, 
	-0.004275, -0.002837, 4.920363, 0.076915, 0.143271, -0.001813, -0.039652, -0.006116, -0.002514, -2.932395, -0.220460, -0.001798, -0.936778, -0.339977, -0.498630, -0.153305, 
	-0.003730, -0.002446, -0.046353, 0.539694, 1.623550, -0.000799, -1.175254, -0.004580, -0.001930, -0.371202, -4.965790, -0.000900, 3.374927, 0.989005, 0.059243, -0.013435, 
	-0.002808, -0.001227, 1.108867, -0.003157, -0.073479, -0.000511, -1.919193, -0.003669, -0.001006, -0.487029, -0.616830, -0.000530, -0.155248, 1.883294, 0.286742, -0.014218, 
	-0.111370, -0.063723, 5.127405, 0.447764, 3.048774, -0.024455, 2.475593, -0.070860, -0.045191, -2.599195, -10.176950, -0.025438, 1.143258, -2.235333, 1.297416, 1.812305, 
	2.215259, -0.067404, 1.870587, -0.682213, 1.715233, -0.020931, -1.762694, -0.124346, -0.057409, 2.225328, -1.508350, -0.022299, 0.611648, 1.219443, -5.578290, -0.033561, 
	-0.017390, 0.004660, -0.797261, 0.327517, 2.395690, -0.001540, -0.185786, -0.011983, -0.002712, 0.616722, -4.356692, -0.001570, 3.753531, -0.492799, -1.115404, -0.114982, 
	-0.008469, -0.003210, -1.331951, -1.634964, 1.514853, -0.001116, 2.912642, -0.014588, -0.002618, 2.579087, -1.029041, -0.001174, -1.926422, -0.272934, -0.758388, -0.021707, 
	-0.003606, -0.000938, -0.022063, -0.667713, -0.113989, -0.000384, -0.126546, -0.001167, -0.000694, -0.011601, -0.398001, -0.000400, 1.618644, -0.133791, -0.133845, -0.003906, 
	-0.077989, 7.482930, -2.492944, -4.306924, 5.056216, -0.022934, -3.227631, -6.242677, -0.031419, 1.485636, 0.072220, -0.023431, -2.587446, -0.574737, 5.751567, -0.260438, 
	-0.005658, 0.046531, 0.662531, 1.326678, -1.021621, -0.001102, -2.189150, -0.050253, -0.002505, -1.675769, 1.936855, -0.001148, 1.483996, -0.267505, -0.187046, -0.054835, 
	-0.012672, -0.006971, -0.374351, 1.636173, 2.558909, -0.001577, -0.291923, -0.015483, -0.005003, -1.929592, -0.276863, -0.001727, 0.461239, 0.005135, -1.655348, -0.089946, 
	-0.042667, -0.025086, -3.418903, 3.176760, -0.562519, -0.007824, 2.381396, -0.023659, -0.014227, 2.830731, -5.647163, -0.007926, 1.918831, -1.709471, 1.055778, 0.095949, 
	-0.088306, -0.050059, -0.800865, -3.086159, -1.794050, -0.014624, 5.873179, -0.110614, -0.030368, -0.848172, 3.811201, -0.015325, -1.237338, 0.992128, -2.196201, -0.404427, 
	-0.010254, -0.008682, 2.129157, -0.533621, -0.321812, -0.001322, 2.357142, -0.006518, -0.003948, -0.409486, 1.520103, -0.001442, -2.584680, -0.751849, -1.120174, -0.252614, 
	-0.064733, -0.022208, 3.927454, -5.173610, -0.784534, -0.005845, -1.017797, -0.032484, -0.014028, -0.415053, 1.431161, -0.006245, 0.320534, -1.103201, 3.286302, -0.325712, 
	-0.007684, -0.003083, 0.772624, -0.355519, -2.764287, -0.001043, -0.197757, -0.005475, -0.002196, 3.432685, -2.937010, -0.001102, 3.280053, -1.497695, 0.371057, -0.083568, 
	-0.014066, -0.004196, -0.463297, -1.196183, -0.353135, -0.001477, -0.760633, -0.006069, -0.002940, 0.175072, 1.164061, -0.001611, 0.797807, 1.457102, -1.018601, 0.228167, 
	-0.003591, -0.002822, 0.450595, 1.637601, 1.194188, -0.000763, -0.594711, -0.002121, -0.001334, -0.789591, -1.392154, -0.000789, -0.180209, -0.056323, -0.246818, -0.011157, 
	-0.702018, 0.289778, -0.437624, 0.788057, -1.350167, -0.100885, -1.340357, -0.589958, -0.212766, 1.399461, -1.055080, -0.239886, 0.798933, 0.174176, 3.259965, -0.681630, 
	-0.060210, -0.012198, 0.035330, 0.770038, -2.067732, -0.003529, -0.183943, -0.019811, -0.006758, 0.265263, 3.863493, -0.003861, 0.224979, -1.141303, -1.535208, -0.124549, 
	-0.319599, -0.096016, 2.145551, -5.157330, 2.496728, -0.028576, 8.439925, -0.156013, -0.060806, -2.285001, -0.825667, -0.030006, 0.178515, -2.694721, -0.820846, -0.786139, 
	-0.013507, -0.008501, 2.236651, 0.724552, -1.095357, -0.003573, -2.287862, -0.012372, -0.006137, -0.333025, 2.660153, -0.003792, 0.166071, -1.159260, -0.827039, -0.037002, 
	-0.012283, -0.003303, -1.461346, -0.968907, -0.852158, -0.001107, 0.822056, -0.003040, -0.002332, 1.379370, -1.949290, -0.001170, 1.925710, 0.673812, 0.476861, -0.022872, 
	-0.020240, -0.014811, -0.314084, 0.552643, -1.225477, -0.004147, -2.950429, -0.012483, -0.008348, 2.178737, 2.268189, 0.044447, 1.750638, -1.749215, -0.385979, -0.109441, 
	-0.013803, -0.010281, 1.294149, 1.139575, 1.356950, -0.002585, 0.714857, -0.012610, -0.002557, -0.584655, -0.722894, -0.132137, -2.690823, 0.603829, -0.767892, -0.169124, 
	-0.002936, -0.001157, -0.216523, 1.128898, 0.769797, -0.000420, -0.675512, -0.001522, -0.000737, -0.771400, 1.452332, -0.000438, -2.476120, -0.081135, 0.911344, -0.034472, 
	-0.011342, -2.236614, 0.231002, -0.701428, -1.144808, -0.003650, -1.560033, 2.409448, -0.005208, 0.099960, 2.716218, -0.003766, -1.079018, -0.519771, 1.845420, -0.036409, 
	-0.068674, -0.006813, -1.859809, -0.327801, -2.310888, -0.001486, -2.330404, -0.005284, -0.003261, -0.384740, 1.989282, -0.001574, 5.694930, -0.525651, 0.165697, -0.023525, 
	-0.042095, -0.014887, 0.379783, 5.959192, -3.630843, -0.005922, -17.885649, -0.017275, -0.010689, -0.048895, -1.380185, -0.006103, 17.393969, 0.676866, -0.743452, -0.623817, 
	-0.703718, 0.604681, -0.609685, 0.475367, -0.410407, -0.063902, 3.611720, -0.332900, -0.139284, 1.037129, -1.027577, -0.068746, -2.891030, 0.136568, 1.759541, -1.377758, 
	-0.000379, -0.000705, -0.004457, 0.118644, 0.203744, -0.000071, 0.001968, -0.000231, -0.000224, -0.010456, 0.131340, -0.000082, -0.149774, -0.002528, -0.284813, -0.001977, 
	-0.067958, -0.022203, -0.151516, -0.859674, -0.806622, -0.005470, -0.575129, -0.048010, -0.014712, -1.278469, 0.802858, -0.005943, 3.749350, 1.847400, -2.343360, -0.220542, 
	-0.027221, -0.011406, -0.569557, -1.108560, 0.671339, -0.002312, -0.282424, -0.008025, -0.005688, -0.215519, 2.769316, -0.002455, -2.611022, -0.463623, 2.010506, -0.143348, 
	-0.062290, -0.012522, 0.191268, -1.126891, 2.670053, -0.007201, 10.982127, -0.013196, -0.010540, -1.036974, -4.163402, -0.007936, -7.295486, 0.422903, -0.266377, -0.263535, 
	1.500328, -0.141036, -6.718345, -6.160263, -2.978615, -0.041921, -4.686984, -0.171274, -0.090725, 3.678443, 11.696877, -0.044126, -1.254446, 7.343999, -1.452936, -0.478976, 
	-0.020627, -0.012695, -3.838338, -6.031247, -1.552902, -0.004123, 2.314698, -0.010350, -0.007220, 6.458457, -2.243278, -0.004280, -4.430401, 7.072039, 2.440347, -0.130079, 
	-0.027696, -0.010619, -1.734934, 0.120678, -0.612460, -0.002320, 1.308101, -0.021536, -0.007368, 1.752683, 2.585909, -0.002567, -2.050846, 0.235319, -1.320781, -0.211562, 
	-0.004916, -0.002790, -0.170564, -1.470601, 0.112606, -0.000921, 0.611686, -0.002043, -0.001697, 0.092841, -2.846499, -0.000900, 1.573886, 1.930303, 0.268938, -0.089329, 
	-0.003091, -0.001756, -0.819969, 2.495279, -0.114957, -0.000546, -0.573771, -0.001131, -0.000962, -1.372188, 0.626206, -0.000554, -0.096017, -0.037823, -0.036399, -0.062320, 
	-0.022034, -0.014523, -0.717515, -1.982083, -0.604348, -0.005480, 3.703811, -0.020141, -0.010551, -1.750233, 0.748975, -0.005909, 3.157746, -1.121320, -1.162701, -0.193694, 
	-0.112104, 0.223393, -0.302238, 3.928550, -0.367628, -0.007566, 0.950600, -0.134953, -0.022513, -0.290301, -1.047948, -0.008190, -0.739346, -2.914024, 1.268481, -0.424214, 
	-0.006192, -0.005615, -1.363525, -1.344485, -0.004204, -0.000864, -1.178199, -0.003777, -0.002403, 0.938033, 0.352493, -0.000938, 2.706479, 0.351021, -0.418768, -0.019054, 
	-0.034120, -0.011787, -1.155050, 1.861777, 1.983020, -0.003393, -0.680485, -0.019514, -0.008117, -2.938257, 0.645819, -0.003674, 0.902147, 3.795635, -4.100725, -0.233276, 
	-0.006110, -0.006723, -0.049232, 0.650447, -0.964540, -0.001063, -3.274719, -0.007218, -0.002971, -2.119365, 4.025575, -0.001171, 1.571266, -0.380412, 0.629583, -0.063349, 
	-0.020951, -0.007719, -1.280340, 0.432256, -2.462211, -0.002193, -1.412967, -0.029459, -0.006530, 1.852585, -2.053914, -0.001939, 4.047822, -0.384515, 1.583897, -0.253822, 
	-0.007278, -0.005815, -2.139523, 0.398844, 7.207215, -0.002740, -4.149066, -0.007075, -0.004006, 0.791046, 1.492161, -0.002816, -2.109293, -0.771493, -0.609993, -0.080169, 
	-0.007355, -0.005849, 2.535765, -1.722626, 0.318599, -0.001366, 3.386461, -0.008257, -0.003982, -2.433685, -1.177289, -0.001125, -1.611024, -1.499930, 2.307213, -0.075552, 
	-0.552982, -0.187021, 13.264211, 7.719871, 10.439996, -0.112137, -13.524487, -0.237528, -0.144507, 12.691201, -15.525274, -0.242594, -19.380987, 5.121633, -3.349784, 4.020391, 
	-0.408042, -0.233200, 2.374062, -2.883187, 1.131783, -0.060561, 0.617935, -0.276585, -0.154946, 1.865670, 2.564258, -0.063276, 0.268922, -1.129710, -2.890905, -0.722218, 
	-0.050235, -0.003066, 0.748594, 0.885871, 1.295895, -0.001192, -2.532965, -0.040536, -0.003202, -0.862863, 0.398816, -0.001284, -0.839006, 1.600577, -0.571925, -0.023477, 
	-0.087451, -0.005602, -0.445379, -0.528200, -1.130042, -0.002343, 5.569478, -0.008303, -0.004038, -0.497415, -0.764078, -0.002489, -0.945490, -0.296795, -0.833166, -0.018688, 
	-0.023028, -0.015787, -1.387292, 4.387051, -0.467230, -0.002751, 3.612405, -0.007884, -0.005790, -2.427583, -5.309608, -0.002921, -2.345483, 4.756014, -0.672924, -0.087191, 
	-0.053479, -0.010567, -0.309588, -0.130664, -3.327703, -0.002013, 3.458777, -0.012046, -0.005725, -1.469984, -0.845848, -0.002403, 1.243911, 0.641583, 0.837483, -0.011734, 
	-0.023953, -0.013153, -0.448846, 1.327345, 2.703981, -0.003155, -3.615033, -0.020204, -0.007148, 5.569627, -0.332224, -0.003325, -3.324646, 0.139734, -1.827016, -0.121987, 
	-0.086219, -0.031534, 0.405691, -7.074461, -2.120487, -0.007783, -1.170214, -0.046256, -0.017807, 3.700826, 3.290130, -0.008633, 3.334213, -2.107494, 2.097553, -0.157524, 
	-0.012237, -0.005941, 0.586357, 0.842914, 2.148025, -0.002572, 0.316758, -0.015655, -0.004183, -1.431805, -0.295603, -0.002664, -0.972544, -1.052750, -0.035929, -0.062170, 
	-0.015025, -0.003252, 0.304117, 1.941315, -1.553692, -0.001511, 1.097993, -0.003442, -0.002459, 0.339687, -4.911833, -0.001547, 3.137354, 0.049996, -0.334396, -0.043305, 
	-0.049820, -0.008210, 2.421549, 0.251213, 2.288073, -0.002904, -1.831363, -0.010957, -0.006110, -2.610788, -0.844185, -0.003049, -0.650187, -0.184478, 1.335757, -0.094542, 
	-0.130046, 1.614627, -0.854877, 0.066459, -0.152523, -0.019028, -2.746797, -1.714576, -0.051463, -1.313997, 4.844736, -0.023435, -0.494501, 1.230740, 0.454500, -0.709819, 
	-0.005071, -0.002878, -1.025488, 2.752059, -1.106711, -0.000651, -1.076581, -0.003886, -0.001783, 0.081374, -2.384121, -0.000716, 0.952311, 1.914632, -0.036163, -0.056326, 
	-0.004773, -0.004344, -0.829152, -1.041840, 0.635903, -0.001133, -0.788410, -0.007529, -0.002993, -1.156011, -1.051263, -0.001142, 0.742587, 3.541752, -0.007464, -0.024187, 
	-0.014020, -0.004280, -2.689924, -2.821302, -1.362529, -0.001111, 0.460439, -0.004460, -0.002775, 9.926177, 1.982447, -0.001230, -3.889365, 0.069503, -1.598853, -0.048717, 
	-0.029659, -0.018618, 1.112957, 1.242117, -2.111916, -0.002978, -2.188158, -0.018291, -0.010179, -1.390147, 2.063525, -0.003495, -0.289346, 2.701908, -0.978648, -0.079071, 
	-0.019264, -0.009794, -2.468019, -2.594272, -1.626602, -0.002548, 1.516289, -0.008747, -0.005592, 3.061513, -0.212283, -0.002746, -0.037240, 3.029731, -0.375927, -0.244499, 
	-0.041132, -0.023560, 1.632891, -2.527109, 0.302699, -0.005861, -6.159559, -0.042627, -0.014432, 1.761504, 3.870060, -0.006163, 1.498703, 0.807221, -0.905411, -0.147224, 
	-0.002321, -0.002821, -2.076652, 2.547356, -0.560612, -0.001659, -0.193239, -0.003270, -0.002380, 1.964810, -0.420543, -0.001694, -0.108950, -0.725515, -0.293669, -0.118841, 
	-0.016395, -0.001513, -1.395804, 0.130042, -0.533218, -0.000661, -0.275949, -0.001820, -0.001180, 0.873149, 0.327270, -0.000689, 1.784976, -0.307039, -0.557769, -0.023400, 
	-0.022841, -0.007501, -1.751576, -2.012739, 2.773092, -0.001798, 1.616024, -0.008219, -0.004492, 0.350920, -0.407735, -0.001807, -2.327179, 2.312169, -0.427467, -0.078852, 
	-0.012697, -0.006438, -1.131273, 1.912604, -3.536431, -0.002204, -3.441613, -0.011835, -0.004691, 2.320072, -2.163172, -0.002269, 4.045204, 1.595048, 0.505593, -0.065897, 
	1.246748, -0.275446, -0.695142, -3.022007, 2.609616, -0.065060, 2.689958, -0.402275, -0.156730, -0.922167, 3.892195, -0.078453, -0.816351, -0.698400, -1.254459, -2.052026, 
];

pub const INTERCEPTS: [f32; 16] = [
	-2.306742, -2.258932, 0.523372, 1.777966, 1.053884, -2.673501, 2.530283, -0.639573, -1.692796, 2.483821, 1.158584, -2.405218, 0.882742, 1.775545, 1.994673, -2.204108, ];

