% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\name{sequences}
\alias{sequences}
\title{DNA sequence associated with each taxonomic identifier.}
\usage{
sequences(biom)
}
\arguments{
\item{biom}{A \code{BIOM} object, as returned from \link{read.biom}.}
}
\value{
A named character vector of sequences in \code{biom}. If this data
          is not present, then returns \code{NULL}.
}
\description{
DNA sequence associated with each taxonomic identifier.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.bz2", package = "rbiom")
    biom <- read.biom(infile)
    
    sequences(biom)[1:4]
    
    # Write to a compressed fasta file in the temporary directory:
    seqs <- sequences(biom)
    conn <- bzfile(file.path(tempdir(), "Sequences.fa.bz2"), "w")
    cat(sprintf(">\%s\n\%s", names(seqs), seqs), file=conn, sep="\n")
    close(conn)
    
    # You can also use the write.fasta function for this task:
    write.fasta(biom, file.path(tempdir(), "Sequences.fa.gz"))

}
\seealso{
Other accessor functions: 
\code{\link{counts}()},
\code{\link{info}()},
\code{\link{metadata}()},
\code{\link{nsamples}()},
\code{\link{ntaxa}()},
\code{\link{phylogeny}()},
\code{\link{sample.names}()},
\code{\link{taxa.names}()},
\code{\link{taxa.ranks}()},
\code{\link{taxonomy}()}
}
\concept{accessor functions}
