% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mieaa.R
\name{rba_mieaa_enrich_results}
\alias{rba_mieaa_enrich_results}
\title{Retrieve Results of a finished Enrichment Analysis from miEAA}
\usage{
rba_mieaa_enrich_results(job_id, sort_by = "p_adjusted", sort_asc = TRUE, ...)
}
\arguments{
\item{job_id}{The job-id (a character string) of a submitted enrichment
analysis.}

\item{sort_by}{A column name to the result's table based on that. one of:
"category", "subcategory", "enrichment", "p_value", "p_adjusted" (default),
"q_value" or "observed" .}

\item{sort_asc}{(logical) If TRUE, the results will be sorted in ascending
order. If FALSE, the results will be sorted in descending order.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame with your enrichment analysis results.
}
\description{
After your submitted enrichment analysis request has finished (check
  using \code{\link{rba_mieaa_enrich_status}}), you can retrieve the results
  using this function.
}
\details{
Note that using \code{\link{rba_mieaa_enrich}} is a more convenient way to
  automatically perform this and other required function calls to
  perform enrichment analysis on your input miRNA-set using miEAA.
}
\section{Corresponding API Resources}{

 "GET https://ccb-compute2.cs.uni-saarland.de/mieaa2/api/v1/results/{job_id}"
}

\examples{
\dontrun{
rba_mieaa_enrich_results("f52d1aef-6d3d-4d51-9020-82e68fe99012")
}

}
\references{
\itemize{
  \item Fabian Kern, Tobias Fehlmann, Jeffrey Solomon, Louisa Schwed,
  Nadja Grammes, Christina Backes, Kendall Van Keuren-Jensen,
  David Wesley Craig,Eckart Meese, Andreas Keller, miEAA 2.0:
  integrating multi-species microRNA enrichment analysis and workflow
  management systems, Nucleic Acids Research, Volume 48, Issue W1,
  02 July 2020, Pages W521–W528, https://doi.org/10.1093/nar/gkaa309
  \item
  \href{https://ccb-compute2.cs.uni-saarland.de/mieaa2/tutorial/api/}{miEAA
  browsable API tutorial}
  \item \href{https://ccb-compute2.cs.uni-saarland.de/mieaa2/}{Citations note
  on miEAA website}
  }
}
\seealso{
Other "miEAA": 
\code{\link{rba_mieaa_cats}()},
\code{\link{rba_mieaa_convert_type}()},
\code{\link{rba_mieaa_convert_version}()},
\code{\link{rba_mieaa_enrich_status}()},
\code{\link{rba_mieaa_enrich_submit}()},
\code{\link{rba_mieaa_enrich}()}
}
\concept{"miEAA"}
