% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbin-manual.R
\name{rbin_manual}
\alias{rbin_manual}
\alias{plot.rbin_manual}
\title{Manual binning}
\usage{
rbin_manual(data = NULL, response = NULL, predictor = NULL,
  cut_points = NULL, include_na = TRUE)

\method{plot}{rbin_manual}(x, ...)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble}.}

\item{response}{Response variable.}

\item{predictor}{Predictor variable.}

\item{cut_points}{Cut points for binning.}

\item{include_na}{logical; if \code{TRUE}, a separate bin is created for missing values.}

\item{x}{An object of class \code{rbin_manual}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A \code{tibble}.
}
\description{
Bin continuous data manually.
}
\details{
Specify the upper open interval for each bin. `rbin`
  follows the left closed and right open interval. If you want to create_bins
  10 bins, the app will show you only 9 input boxes. The interval for the 10th bin 
  is automatically computed. For example, if you want the first bin to have all the
  values between the minimum and including 36, then you will enter the value 37.
}
\examples{
bins <- rbin_manual(mbank, y, age, c(29, 31, 34, 36, 39, 42, 46, 51, 56))
bins

# plot
plot(bins)

}
