% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bhl_gettitlebibtex.R
\name{bhl_gettitlebibTex}
\alias{bhl_gettitlebibTex}
\title{Return a citation for a title, using the BibTeX format.}
\usage{
bhl_gettitlebibTex(titleid = NULL, as = "list", key = NULL, ...)
}
\arguments{
\item{titleid}{the identifier of an individual title (numeric)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Return a citation for a title, using the BibTeX format.
}
\examples{
\dontrun{
bhl_gettitlebibTex(1726)
bhl_gettitlebibTex(1726, 'xml')
bhl_gettitlebibTex(1726, 'json')
}
}

