% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial.r
\name{boxSpatial}
\alias{boxSpatial}
\alias{boundarySpatial}
\alias{faceSpatial}
\title{Convert to Spatial}
\usage{
boxSpatial(bgm)

boundarySpatial(bgm)

faceSpatial(bgm)
}
\arguments{
\item{bgm}{output of a BGM file, as returned by \code{\link{bgmfile}}}
}
\value{
Spatial* object 
\itemize{
\item boxSpatial \code{\link[sp]{SpatialPolygonsDataFrame}} 
\item faceSpatial  \code{\link[sp]{SpatialLinesDataFrame}} 
\item boundarySpatial \code{\link[sp]{SpatialPolygonsDataFrame}} 
}
}
\description{
Take the output of \code{\link{bgmfile}} and return a \code{\link[sp]{Spatial}} object.
}
\examples{
fname <- bgmfiles::bgmfiles(pattern = "antarctica_28")
bgm <- bgmfile(fname)
spdf <- boxSpatial(bgm)
sldf <- faceSpatial(bgm)

plot(boxSpatial(bgm), col = grey(seq(0, 1, length = nrow(bgm$boxes))))
plot(faceSpatial(bgm), col = rainbow(nrow(bgm$faces)), lwd = 2,  add = TRUE)
}
