% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{clam2bacon}
\alias{clam2bacon}
\title{Translate clam .csv files to Bacon .csv files.}
\usage{
clam2bacon(
  core,
  clamdir = "clam_runs",
  bacondir = "Bacon_runs",
  sep = ",",
  cc = 1
)
}
\arguments{
\item{core}{The name of the core for which a clam .csv.file needs to be translated into a Bacon .csv file}

\item{clamdir}{The directory where the clam runs reside. Defaults to \code{coredir="clam_runs"}.}

\item{bacondir}{The directory where the Bacon runs reside. Defaults to \code{coredir="Bacon_runs"}.}

\item{sep}{The separator for the .csv files. Defaults to \code{sep=","}.}

\item{cc}{Calibration curve for C-14 dates: \code{cc=1} for IntCal20 (northern hemisphere terrestrial), \code{cc=2} for Marine20 (marine),}
}
\value{
A Bacon .csv file
}
\description{
Reads a clam .csv file containing the dates, and transforms it into a Bacon .csv file.
}
\details{
Please ensure that if the clam file has offset (d.R) estimates, that errors (d.STD) are provided manually, since these values cannot be determined automatically from the clam .csv file.
}
\seealso{
\url{http://www.qub.ac.uk/chrono/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
