% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bacon.R
\name{flux.age}
\alias{flux.age}
\title{Plot flux rates for proxies.}
\usage{
flux.age(proxy = 1, yr.lim = c(), yr.res = 200, set = get("info"),
  flux = c(), flux.lim = c(), flux.lab = "flux", upper = 0.95,
  dark = set$dark, BCAD = set$BCAD, yr.lab = c(), rotate.axes = FALSE,
  rev.flux = FALSE, rev.yr = FALSE)
}
\arguments{
\item{proxy}{Which proxy to use (counting from the column number in the .csv file after the depths column).}

\item{yr.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{yr.lim=c()}).}

\item{yr.res}{Resolution or amount of greyscale pixels to cover the age scale of the plot. Default \code{yr.res=200}.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{flux}{Define a flux variable within the R session (consisting of depths and their proxy concentrations in two columns) and provide the name of this variable, e.g.: 
\code{flux.age(flux=flux1)}. If left empty (\code{flux=c()}), a flux file is expected (see \code{proxy}).}

\item{flux.lim}{The limits of the axes can also be adapted.}

\item{flux.lab}{Axis labels can also be adapted. Default values are defined automatically.}

\item{upper}{Maximum flux rates to plot. Defaults to the upper 99\%; \code{upper=0.99}.}

\item{dark}{The darkest grey value is \code{dark=1} by default; lower values will result in lighter grey but \code{values >1} are not allowed.}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{yr.lab}{The labels for the calendar axis (default \code{yr.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{rotate.axes}{The default of plotting calendar year on the horizontal axis and fluxes on the vertical one can be changed with \code{rotate.axes=TRUE}.}

\item{rev.flux}{The flux axis can be reversed with \code{rev.flux=TRUE}.}

\item{rev.yr}{The direction of the age axis, which can be reversed using \code{rev.yr=TRUE}.}
}
\value{
A plot of flux rates.
}
\description{
Plot grey-scale representation of estimated flux rates for proxies against calendar age.
}
\details{
doesn't deal with hiatus yet

To plot flux rates (e.g. pollen grains/cm2/yr) as greyscales, 
provide a plain text file with headers and the data in columns separated by commas, ending in '_flux.csv'
and saved in your core's folder. The first column should contain the depths, and the next columns should contain 
the proxy concentration values (leaving missing values empty). Then type for example \code{flux.age(1)} to plot the 
flux values for the first proxy in the .csv file. Instead of using a _flux.csv file, a flux variable can also be defined
 within the R session (consisting of depths and their proxy concentrations in two columns). Then provide the name of this variable, e.g.: \code{flux.age(flux=flux1)}. 
See Cores/MSB2K/MSB2K_flux.csv for an example.
}
\examples{
\donttest{
Bacon(run=FALSE)
agedepth(yr.res=50)
flux.age(1)
}
}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive 
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474. 
\url{https://projecteuclid.org/download/pdf_1/euclid.ba/1339616472}
}
\seealso{
\url{http://www.chrono.qub.ac.uk/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
