% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bacon.R
\name{copyCalibrationCurve}
\alias{copyCalibrationCurve}
\title{Copy a calibration curve.}
\usage{
copyCalibrationCurve(cc = 1, inmemory = FALSE, destinationDir = "Curves/")
}
\arguments{
\item{cc}{Calibration curve for 14C dates: \code{cc=1} for IntCal13 (northern hemisphere terrestrial), \code{cc=2} for Marine13 (marine), 
\code{cc=3} for SHCal13 (southern hemisphere terrestrial).}

\item{inmemory}{The curve is copied to a file by default, but will be listed as output to this function if \code{inmemory=TRUE}.}

\item{destinationDir}{Directory where the calibration curve \code{cc} will be located. By default \code{destinationDir="Curves/"}.
Use \code{destinationDir="."} to choose current working directory.}
}
\value{
the file of calibration curve defined by cc.
}
\description{
Copy the calibration curve defined by cc to destination directory(destinationDir), or into memory.
}
\details{
Copy the calibration curve defined by cc to destination directory(destinationDir).
}
\examples{
copyCalibrationCurve(cc=2) 
cc1 <- copyCalibrationCurve(1, TRUE)
}
\seealso{
\url{http://www.chrono.qub.ac.uk/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
