% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/displacement_sphere.R
\name{displacement_sphere}
\alias{displacement_sphere}
\title{Construct Displacement Sphere}
\usage{
displacement_sphere(
  displacement_texture,
  displacement_scale = 1,
  use_cube = FALSE,
  cube_subdivision_levels = NA,
  displace = TRUE,
  verbose = TRUE,
  position = c(0, 0, 0),
  scale = c(1, 1, 1),
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  material = material_list()
)
}
\arguments{
\item{displacement_texture}{Image or matrix/array that will be used to displace the sphere.}

\item{displacement_scale}{Default \code{1}. Scale of the displacement.}

\item{use_cube}{Default \code{FALSE}. Whether to use a subdivided cube instead of a UV sphere. Use this
if you want to visualize areas near the poles.}

\item{cube_subdivision_levels}{Default \code{NA}. Uses the dimensions of the displacement texture
to automatically calculate the number of subdivision levels.}

\item{displace}{Default \code{TRUE}. Whether to displace the sphere, or just generate the initial mesh
for later displacement.}

\item{verbose}{Default \code{TRUE}. Whether to print displacement texture information.}

\item{position}{Default \code{c(0,0,0)}. Position of the mesh.}

\item{scale}{Default \code{c(1,1,1)}. Scale of the mesh. Can also be a single numeric value scaling all axes uniformly.}

\item{angle}{Default \code{c(0,0,0)}. Angle to rotate the mesh.}

\item{pivot_point}{Default \code{c(0,0,0)}. Point around which to rotate the mesh.}

\item{order_rotation}{Default \code{c(1,2,3)}. Order to rotate the axes.}

\item{material}{Default \code{material_list()} (default values). Specify the material of the object.}
}
\value{
raymesh object
}
\description{
Construct Displacement Sphere
}
\examples{
if(run_documentation()) {

}
}
