% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ray_shade.R
\name{ray_shade}
\alias{ray_shade}
\title{Rayshade}
\usage{
ray_shade(heightmap, anglebreaks = seq(40, 50, 1), sunangle = 315,
  maxsearch = 100, lambert = TRUE, zscale = 1, multicore = FALSE,
  cache_mask = NULL, shadow_cache = NULL, progbar = TRUE, ...)
}
\arguments{
\item{heightmap}{A two-dimensional matrix, where each entry in the matrix is the elevation at that point. All points are assumed to be evenly spaced.}

\item{anglebreaks}{Default `seq(40,50,1)`. The azimuth angle(s), in degrees, as measured from the horizon from which the light originates.}

\item{sunangle}{Default `315` (NW). The angle, in degrees, around the matrix from which the light originates. Zero degrees is North, increasing clockwise.}

\item{maxsearch}{Default `100`. The maximum distance that the system should propogate rays to check. For longer}

\item{lambert}{Default `TRUE`. Changes the intensity of the light at each point based proportional to the
dot product of the ray direction and the surface normal at that point. Zeros out all values directed away from
the ray.}

\item{zscale}{Default `1`. The ratio between the x and y spacing (which are assumed to be equal) and the z axis. For example, if the elevation levels are in units
of 1 meter and the grid values are separated by 10 meters, `zscale` would be 10.}

\item{multicore}{Default `FALSE`. If `TRUE`, multiple cores will be used to compute the shadow matrix. By default, this uses all cores available, unless the user has
set `options("cores")` in which the multicore option will only use that many cores.}

\item{cache_mask}{Default `NULL`. A matrix of 1 and 0s, indicating which points on which the raytracer will operate.}

\item{shadow_cache}{Default `NULL`. The shadow matrix to be updated at the points defined by the argument `cache_mask`.
If present, this will only compute the raytraced shadows for those points with value `1` in the mask.}

\item{progbar}{Default `TRUE`. If `FALSE`, turns off progress bar.}

\item{...}{Additional arguments to pass to the `makeCluster` function when `multicore=TRUE`.}
}
\value{
Matrix of light intensities at each point.
}
\description{
Calculates global shadow map for a elevation matrix by propogating rays from each matrix point to the light source(s),
lowering the brightness at each point for each ray that intersects the surface.
}
\examples{
#Here we produce an shadow map of the `volcano` elevation map with the light from the NE.
#The default angle is from 40-50 degrees azimuth, from the north east.
volcanoshadow = ray_shade(volcano)
   
#Turn off Lambertian shading to get a shadow map solely based on the raytraced shadows.
volcanoshadow = ray_shade(heightmap = volcano, 
   anglebreaks = seq(30,40,10), 
   sunangle = 45, 
   maxsearch = 100,
   lambert = FALSE)
   
plot_map(volcanoshadow)
}
