% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_rotate}
\alias{csg_rotate}
\title{CSG Rotate}
\usage{
csg_rotate(
  object,
  pivot_point = c(0, 0, 0),
  angles = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  up = c(0, 1, 0),
  axis_x = NULL,
  axis_z = NULL
)
}
\arguments{
\item{object}{CSG object.}

\item{pivot_point}{Default `c(0,0,0)`. Pivot point for the rotation.}

\item{angles}{Default `c(0, 0, 0)`. Angle of rotation around the x, y, and z axes, applied in the order specified in `order_rotation`.}

\item{order_rotation}{Default `c(1, 2, 3)`. The order to apply the rotations, referring to "x", "y", and "z".}

\item{up}{Default `c(0,1,0). Alternative method for specifying rotation--change the new "up" vector.}

\item{axis_x}{Default `NULL`, computed automatically if not passed. Given the `up` vector as the y-axis, this is the x vector.}

\item{axis_z}{Default `NULL`, computed automatically if not passed. Given the `up` vector as the y-axis, this is the z vector.}
}
\value{
List describing the triangle in the scene.
}
\description{
CSG Rotate
}
\examples{
\donttest{
#Rotate a pyramid (translating it upwards because the object is scaled from the center):
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_pyramid(z=1,y=-0.99),
                        material=glossy(color="red"))) \%>\% 
  add_object(csg_object(csg_rotate(csg_pyramid(z=-1.5,y=-0.99),
                        pivot_point = c(0,-0.99,-1.5),angle=c(0,45,0)),
                        material=glossy(color="green"))) \%>\% 
  add_object(sphere(y=5,x=5,z=5,material=light(intensity=40))) \%>\% 
  render_scene(lookfrom=c(-3,4,10), fov=15, 
               lookat=c(0,-0.5,0),clamp_value=10)
  
#Rotate by specifying a new up vector:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_pyramid(z=1,y=-0.99),
                        material=glossy(color="red"))) \%>\% 
  add_object(csg_object(csg_rotate(csg_pyramid(z=-1.5,y=-0.49),
                        pivot_point = c(0,-0.49,-1.5), up =c(1,1,0)),
                        material=glossy(color="green"))) \%>\% 
  add_object(sphere(y=5,x=5,z=5,material=light(intensity=40))) \%>\% 
  render_scene(lookfrom=c(-3,4,10), fov=15, 
               lookat=c(0,-0.5,0),clamp_value=10)
}
}
