% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwelch-diagnosis.R
\name{diagnose_channel}
\alias{diagnose_channel}
\title{Show channel signals with diagnostic plots}
\usage{
diagnose_channel(
  s1,
  s2 = NULL,
  sc = NULL,
  srate,
  name = "",
  try_compress = TRUE,
  max_freq = 300,
  window = ceiling(srate * 2),
  noverlap = window/2,
  std = 3,
  which = NULL,
  main = "Channel Inspection",
  col = c("black", "red"),
  cex = 1.2,
  cex.lab = 1,
  lwd = 0.5,
  plim = NULL,
  nclass = 100,
  start_time = 0,
  boundary = NULL,
  mar = c(3.1, 4.1, 2.1, 0.8) * (0.25 + cex * 0.75) + 0.1,
  mgp = cex * c(2, 0.5, 0),
  xaxs = "i",
  yaxs = "i",
  xline = 1.66 * cex,
  yline = 2.66 * cex,
  tck = -0.005 * (3 + cex),
  ...
)
}
\arguments{
\item{s1}{the main signal to draw}

\item{s2}{the comparing signal to draw; usually \code{s1} after some filters;
must be in the same sampling rate with \code{s1}; can be \code{NULL}}

\item{sc}{decimated \code{s1} to show if \code{srate} is too high; will
be automatically generated if \code{NULL}}

\item{srate}{sampling rate}

\item{name}{name of \code{s1}, or a vector of two names of \code{s1} and
\code{s2} if \code{s2} is provided}

\item{try_compress}{whether try to compress (decimate) \code{s1} if
\code{srate} is too high for performance concerns}

\item{max_freq}{the maximum frequency to display in 'Welch Periodograms'}

\item{window, noverlap}{see \code{\link{pwelch}}}

\item{std}{the standard deviation of the channel signals used to determine
\code{boundary}; default is plus-minus 3 standard deviation}

\item{which}{\code{NULL} or integer from 1 to 4; if \code{NULL}, all plots
will be displayed; otherwise only the subplot will be displayed}

\item{main}{the title of the signal plot}

\item{col}{colors of \code{s1} and \code{s2}}

\item{cex, lwd, mar, cex.lab, mgp, xaxs, yaxs, tck, ...}{graphical parameters; see
\code{\link[graphics]{par}}}

\item{plim}{the y-axis limit to draw in 'Welch Periodograms'}

\item{nclass}{number of classes to show in histogram
(\code{\link[graphics]{hist}})}

\item{start_time}{the starting time of channel (will only be used to draw
signals)}

\item{boundary}{a red boundary to show in channel plot; default is
to be automatically determined by \code{std}}

\item{xline, yline}{distance of axis labels towards ticks}
}
\value{
A list of boundary and y-axis limit used to draw the channel
}
\description{
The diagnostic plots include 'Welch Periodogram'
(\code{\link{pwelch}}) and histogram (\code{\link[graphics]{hist}})
}
\examples{
library(ravetools)

# Generate 20 second data at 2000 Hz
time <- seq(0, 20, by = 1 / 2000)
signal <- sin( 120 * pi * time) +
  sin(time * 20*pi) +
  exp(-time^2) *
  cos(time * 10*pi) +
  rnorm(length(time))

signal2 <- notch_filter(signal, 2000)

diagnose_channel(signal, signal2, srate = 2000,
                 name = c("Raw", "Filtered"), cex = 1)

}
