% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs-api-functions.R
\name{abs_dimensions}
\alias{abs_dimensions}
\title{Return available dimensions of ABS series}
\usage{
abs_dimensions(dataset, update_cache = FALSE)
}
\arguments{
\item{dataset}{Character vector of dataset codes. These codes correspond to the
\code{indicatorID} column from the indicator data frame of \code{abs_cache} or
\code{abs_cachelist}, or the result of \code{abs_indicators}.}

\item{update_cache}{Logical expression, if FALSE (default), use the cached list of available
ABS.Stat datasets, if TRUE, update the list of available datasets.}
}
\value{
a data frame with available dataset dimensions.
}
\description{
This function returns the available dimeninsions for a specified ABS API dataset.
}
\examples{
  \donttest{
    ## CPI - Consumer Price Index
    x <- abs_dimensions("CPI");
    str(x)
    ## LF - Labour Force
    x <- abs_dimensions("LF");
    str(x)
  }
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
