% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subfunctions.R
\name{relError_dataset}
\alias{relError_dataset}
\title{relError_dataset}
\usage{
relError_dataset(Data, vars, group1.vars, group2.vars = NULL, minNr = 7,
  STD)
}
\arguments{
\item{Data}{a data.frame or matrix with samples (observations) as rows.}

\item{vars}{optional, character vector of variables of 'Data' for which the error should be calculated.
If left empty the function \code{\link{select.VarsElements}} will try to find element abbreviations in the variables of 'Data' and 'STD' if STD is provided.}

\item{group1.vars}{character vector of variables in 'Data' for splitting 'Data' into subsets. Error will be calculated for each subset.}

\item{group2.vars}{optional, if a variable name of 'Data' is given here a second splitting by \code{group1.vars} + \code{group2.vars} into subsets is performed.
If for grouping by \code{group1.vars} for one subset there are less entries than 'minNr' the function will look up in the second subset
if there are enough entries (> minNr) in the group2 corresponding to group1.
For example if \code{group1.vars} = "Month" then \code{group2.vars} = "Year" would fill up the gaps if in one month there had been less than 'minNr' observations.}

\item{minNr}{minimum numbers of samples/observations for calculating a relative error of observations.
If the number of samples of "Data" is smaller than "minNr" the error is calculated via the data set STD.}

\item{STD}{replacement data set for calculating errors, e.g. the standards.}
}
\value{
data.frame or data.table with relative errors for each observation of 'Data'.
}
\description{
The function calculates for each observation for every variable 'vars' in 'Data' the relative error by median absolute deviation (\code{\link{mad}}) and median (\code{\link{median}}):
\deqn{
\delta Data[vars_{i}] = \frac{mad(Data[vars_{i}], na.rm = T)}{median(Data[vars_{i}], na.rm = T)}
}
The observations (e.g. samples) are subset into groups by the column \code{group1.vars}.
The relative error is calculated by 'Data' if there are more than 'minNr' entries for each subset of observations.
If there are less observations than 'minNr' for a group in 'Data' than the relative error will be calculated by a replacement data set 'STD',
e.g. you could use a data set of standard reference samples measured at the same machine as your samples.
If you would like to calculate the relative error of all observations in 'Data' set \code{group1.vars} to the column of your sample ID (column with unique entries) and set minNr = 1.
}
\seealso{
Other sub functions: \code{\link{check_readline}},
  \code{\link{select.VarsElements}}
}
\author{
Solveig Pospiech
}
