% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateTimeMCMC.R
\name{estimateTimeMCMC}
\alias{estimateTimeMCMC}
\title{Time estimate to complete a MCMC chain}
\usage{
estimateTimeMCMC(data, phy, gen, eval.times = 5, singlerate = FALSE)
}
\arguments{
\item{data}{a matrix with the data. Each column is a different trait and species names need to be provided as rownames (rownames(data) == phy$tip.label).}

\item{phy}{a phylogeny of the class "simmap" with the mapped regimes for two or more R regimes OR a phylogeny of the class "phylo" for a single regime. The number of evolutionary rate matrices fitted to the phylogeny is equal to the number of regimes in 'phy'. Regime names will also be used.}

\item{gen}{number of generations of the complete MCMC chain. This is used to create the time estimate for the analysis.}

\item{eval.times}{number of replicates to compute the likelihood (default is 5). A time average across replicates will be used in order to account for the uncertainty associated with computing times.}

\item{singlerate}{whether the function should fit a single regime and ignore the number of regimes painted to the tree (default is FALSE).}
}
\value{
Function returns a numeric value with the time estimate in hours and prints a message to the screen with the result.
}
\description{
Estimate time minimum time needed to run the MCMC.
}
\details{
Function will estimate the time based on the computation of the log-likelihood, prior density, and the Jacobian of the proposal step. The time estimated is a minimum bound based on the processing power of the current computer. Running the MCMC in different computers might change the time. Other factors, such as writing the posterior samples to large files, can influence the time to run the MCMC.
}
\author{
Daniel S. Caetano and Luke J. Harmon
}
