% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSimmap.R
\name{mergeSimmap}
\alias{mergeSimmap}
\title{Merge two or more regimes of a 'simmap' tree}
\usage{
mergeSimmap(phy, merge.regimes = NULL, new.regime = NULL, drop.regimes = FALSE)
}
\arguments{
\item{phy}{a phylogeny of the 'simmap' format.}

\item{merge.regimes}{a vector with the names of the regimes to be merged.}

\item{new.regime}{the name of the new regime.}

\item{drop.regimes}{whether to simply drop all information about the regimes and return a phylogeny of class 'phylo'.}
}
\value{
A phylogeny of the format 'simmap' with merged regimes or a phylogeny of class 'phylo' with no regime information.
}
\description{
Function will merge stochastic mapped regimes together to form a new regime. This can be used to decrease the number of regimes in the phylogeny. Additionally, the function can drop all regimes and return a phylogeny of the class 'phylo'.
}
\details{
The distribution of the regimes across the tree will not change. The function only modify the labels of the regimes such that two or more regimes become one (with a new label). \cr
\cr
Function takes the elements of the 'merge.regimes' vector and collapse all those regimes into a single one. The branch length associated with 'merge.regimes' are summed and assigned to the regime correspondent to the first element of the 'merge.regimes' vector. Then this new regime is renamed as 'new.regime'.\cr
\cr
If the original phylogeny has only two regimes or if 'drop.regimes' is set to TRUE, then the output will be of class 'phylo' with no regime information.
}
\examples{
\donttest{
library( phytools ) ## Need phytools for this example.
data(centrarchidae)
plot( centrarchidae$phy.map )
class( centrarchidae$phy.map )
## Now drop all regime information:
no.regime.phy <- mergeSimmap(centrarchidae$phy.map, drop.regimes=TRUE)
plot( no.regime.phy )
class( no.regime.phy )
## Create a new regime with three states:
dt <- c(rep( c("water","earth"), each=10 ), rep("fire", times=7))
names(dt) <- no.regime.phy$tip.label
map.phy <- phytools::make.simmap(tree=no.regime.phy, x=dt)
plot( map.phy )
## Merge two regimes:
merged.phy <- mergeSimmap(phy=map.phy, merge.regimes=c("water","earth"), new.regime="mud")
plot( merged.phy )
}
}
\author{
Daniel S. Caetano and Luke J. Harmon
}
