#' @title rasterly_guides
#' @description Guides layer for "rasterly".
#' @param rastObj  A "rasterly" object. 
#' @param x_pretty The pretty on x. Compute a sequence of about n+1 equally spaced 'round' values 
#' which cover the range of the values in x. If it is not provided, \code{x_pretty} will 
#' be generated by the x range
#' @param y_pretty The pretty on y. 
#' @param panel_background Panel background.
#' @param panel_line Panel line color
#' @details When an image has a 'complicated' background, the drawing time increases significantly.
#' So it is not recommended. A suggestion to draw grid guides is to transform image data to a data frame 
#' via \link{image2data}, then use \code{ggplot} or \code{plotly} to display.
#' @seealso \link{ggRasterly}
#' @export
rasterly_guides <- function(rastObj, 
                            x_pretty = NULL, 
                            y_pretty = NULL, 
                            panel_background = "grey92",
                            panel_line = "white") {
  
  x_pretty <- get_x_pretty(envir = rastObj$rasterly_env, x_pretty)
  y_pretty <- get_x_pretty(envir = rastObj$rasterly_env, y_pretty)
  
  panel_background <- get_panel_background(envir = rastObj$rasterly_env, panel_background)
  panel_line <- get_panel_line(envir = rastObj$rasterly_env, panel_line)
  
  p <- structure(
    list(rasterly_guides = environment()),
    class = c("rasterlyGuides")
  )
  rastObj <- c(
    rastObj, 
    p
  )
  class(rastObj) <- c("rasterly")
  invisible(return(rastObj))
}


get_panel_background <- function(envir, panel_background) {
  
  parent_args <- .get("args", envir = envir)
  panel_background <- panel_background %||% parent_args$panel_background %||% "grey92"
  
  return(panel_background)
}

get_panel_line <- function(envir, panel_line) {
  
  parent_args <- .get("args", envir = envir)
  panel_line <- panel_line %||% parent_args$panel_line %||% "white"
  
  return(panel_line)
}