% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3d.r
\name{plot3D}
\alias{plot3D}
\title{Interactive Maps of 3D surfaces}
\usage{
plot3D(
  var.rast,
  z,
  ex = 0.1,
  agg = FALSE,
  fact = NULL,
  spext = NULL,
  pals = NA,
  rev = NA
)
}
\arguments{
\item{var.rast}{SpatRaster, as in \code{\link[terra]{rast}}. Multi-layer
SpatRaster of \emph{n} continuous variables and one layer representing the
surface/terrain elevation.}

\item{z}{Integer. Position (index) of the raster layer of elevation in
\emph{var.rast}.}

\item{ex}{Numeric. Value indicating the \emph{exaggeration} factor for the
\emph{Z} axis. This can be useful to enhance the visualization of subtle
topographic variability. Default: 0.1}

\item{agg}{Boolean. Should the spatial resolution be aggregated to reduce
processing time? Default: FALSE}

\item{fact}{Numeric. If \emph{agg = TRUE}, value indicating the aggregation
factor. Default: NULL}

\item{spext}{Numeric. List with the coordinates of the bounding box for
spatial subset (xmin, xmax, ymin, ymax). SpatRaster or SpatVector from
which a spatial extent can be calculated are also an acceptable input.
Default: NULL}

\item{pals}{Character. List of strings with the names of the \emph{n} color
ramps (one per continuous variable). See
\code{\link[grDevices]{hcl.colors}}. Default: NA}

\item{rev}{Character. List of \emph{n} Booleans indicating whether or not to
reverse the color ramp for each continuous variable. Default: NA}
}
\value{
List with \strong{plotly-htmlwidget} objects. Each object calls the 3D map
for a continuous variable in \emph{var.rast}.
}
\description{
Interactive maps showing the 3-dimensional (\emph{XYZ}) variability in raster
layers representing continuous variables. The \emph{XYZ} reference positions
will be obtained from an elevation layer and the values of the continuous
variables will be used as a surface color gradient. For this function to
work, there must be a raster layer of elevation (e.g., digital terrain model)
and at least one continuous variable among the raster layers to map. The maps
produced are interactive, meaning that manual axis rotation and zoom are
possible. Special consideration must be taken with large raster layers (large
spatial coverage and/or high spatial resolution). This function can
aggregates the spatial resolution (i.e., cell size) in order to handle large
raster layers. This is achieved by internally calling
\code{\link[terra]{aggregate}}. An aggregation factor will determine the
final cell size, where \emph{final cell size = cell size*aggregation factor}.
In addition, a spatial extent can be provided to reduce the total mapping
area and thus, to further reduce processing time. This function uses the
\strong{plotly} library. See \strong{Details} for current limitations.
}
\details{
Currently, this function does not allow to adjust the labels for \emph{XY}
axes so that actual coordinates are shown. Instead, the relative position
values are shown on these axes.
}
\examples{
require(terra)
p <- system.file("exdat", package = "rassta")
# Multi-layer SpatRaster of topographic variables
ft <- list.files(path = p, pattern = "^height|^slope|^wetness",
                 full.names = TRUE
                )
tvars <- terra::rast(ft)
# Single-layer SpatRaster of terrain elevation
fe <- list.files(path = p, pattern = "^elevation", full.names = TRUE)
e <- terra::rast(fe)
# Add elevation to the SpatRaster of topographic variables
etvars <- c(e, tvars)
# Interactive 3D maps
maps <- plot3D(var.rast = etvars, z = 1, ex = 0.2,
               pals = c("Zissou", "Plasma", "Spectral")
              )
if(interactive()){maps}

}
\seealso{
Other Miscellaneous Functions: 
\code{\link{dummies}()},
\code{\link{figure}()}
}
\concept{Miscellaneous Functions}
