% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneSurvSampleSize.R
\name{oneSurvSampleSize}
\alias{oneSurvSampleSize}
\title{One-Sample Survival Study Sample Size or Power Calculation}
\usage{
oneSurvSampleSize(
  survTime,
  p1,
  p2,
  accrualTime,
  followTime,
  alpha,
  power,
  side = c("two.sided", "one.sided"),
  method = c("arcsin", "log-log", "logit", "log", "log-swog", "identity")
)
}
\arguments{
\item{survTime}{Time point at which survival is evaluated (e.g., median follow-up time).}

\item{p1}{Expected survival probability under the alternative hypothesis.}

\item{p2}{Survival probability under the null hypothesis.}

\item{accrualTime}{Patient accrual period.}

\item{followTime}{Additional follow-up period after accrual ends.}

\item{alpha}{Significance level (e.g., 0.05).}

\item{power}{Desired statistical power (e.g., 0.8).}

\item{side}{Type of hypothesis test. Either \code{"two.sided"} (default) or \code{"one.sided"}.}

\item{method}{Transformation method for comparison. One of \code{"arcsin"}, \code{"log-log"}, \code{"logit"}, \code{"log"}, \code{"log-swog"}, \code{"identity"}.}
}
\value{
A named numeric vector with:
\describe{
\item{SampleSize}{Calculated required sample size.}
\item{Power}{Achieved power with the calculated sample size.}
}
}
\description{
Calculates the required sample size or power for a single-arm survival study using various transformation-based methods,
including arcsine-square root, log-log, logit, and others. This function assumes an exponential survival model.
}
\examples{
oneSurvSampleSize(
  survTime = 2,
  p1 = 0.75,
  p2 = 0.6,
  accrualTime = 1,
  followTime = 1,
  alpha = 0.05,
  power = 0.8,
  side = "two.sided",
  method = "log-log"
)


}
\references{
Fleming TR, Harrington DP. (1991). \emph{Counting Processes and Survival Analysis}.
New York: Wiley, pp. 236–237, Example 6.3.1.

Andersen PK, Borgan O, Gill RD, Keiding N. (1993). \emph{Statistical Models Based on Counting Processes}.
New York: Springer-Verlag, pp. 176–287, Section IV.1–3.

Bie O, Borgan O, Liestol K. (1987). Confidence intervals and confidence bands for the cumulative hazard rate function and their small sample properties.
\emph{Scandinavian Journal of Statistics}, 14(3), 221–233.

Borgan O, Liestol K. (1990). A note on confidence intervals and bands for the survival function based on transformations.
\emph{Scandinavian Journal of Statistics}, 17(1), 35–41.

Nagashima K, Noma H, Sato Y, Gosho M. (2020). Sample size calculations for single-arm survival studies
using transformations of the Kaplan–Meier estimator. \emph{Pharmaceutical Statistics}. https://doi.org/10.1002/pst.2090
Available at: https://arxiv.org/abs/2012.03355

Web calculator (One-sample):
https://nshi.jp/en/js/onesurvyr/
}
