% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangemap_enm.R
\name{rangemap_enm}
\alias{rangemap_enm}
\title{Species distributional ranges based on ENMs/SDMs outputs}
\usage{
rangemap_enm(model_output, occurrences = NULL, threshold_value = NULL,
             threshold_omission = NULL, min_polygon_area = 0,
             simplify = FALSE, simplify_level = 0, polygons = NULL,
             extent_of_occurrence = TRUE, area_of_occupancy = TRUE,
             final_projection = NULL, save_shp = FALSE, name,
             overwrite = FALSE, verbose = TRUE)
}
\arguments{
\item{model_output}{a RasterLayer of suitability for the species of interest
generated using a ENM or SDM algorithm, that will be binarized using the a
user-defined \code{threshold_value} or a value calculated based on a percentage
of omission (0 - 100) defined in \code{threshold_omission}. If the layer is
projected, this projection must be WGS84 (EPSG:4326); if not projected, WGS84
projection will be assigned for the analysis.}

\item{occurrences}{a data.frame containing geographic coordinates of species
occurrences, columns must be: Species, Longitude, and Latitude. Geographic
coordinates must be in decimal degrees. \code{occurrences} may not be defined,
but if so, \code{threshold_value} must be defined. Default = \code{NULL}.}

\item{threshold_value}{(numeric) value used for reclassifying the
\code{model_output}. This value will be the lowest considered as suitable for
the species and must be inside the range of values present in \code{model_output}.
If defined, \code{threshold_omission} will be ignored. If \code{occurrences}
is not defined, this parameter is required. Default = \code{NULL}.}

\item{threshold_omission}{(numeric) percentage of occurrence records to be
excluded from suitable areas considering their values of suitability in the
continuous model (e.g., 0, 5, or 10). Ignored if \code{threshold_value} is
provided. Default = \code{NULL}.}

\item{min_polygon_area}{(numeric) minimum area of polygons that will be kept
as part of the species ranges after defining suitable areas and convert
raster layer to polygon. Default = 0. A value of 0 will keep all polygons.}

\item{simplify}{(logical) if \code{TRUE}, polygons of suitable areas will be
simplified at a tolerance defined in \code{simplify_level}. Default =
\code{FALSE}.}

\item{simplify_level}{(numeric) tolerance to consider when simplifying polygons
created from suitable areas in \code{model_output}. Lower values will produce
polygons more similar to the original geometry. Default = 0. If simplifying is
needed, try numbers 0-1 first. Ignored if \code{simplify} = \code{FALSE}.}

\item{polygons}{(optional) a SpatialPolygons* object to clip polygons and
adjust extent of occurrence to these limits. Projection must be WGS84
(EPSG:4326). If \code{NULL}, the default, a simplified world map will be used.}

\item{extent_of_occurrence}{(logical) whether to obtain the extent of occurrence
of the species based on a simple convex hull polygon; default = \code{TRUE}.}

\item{area_of_occupancy}{(logical) whether to obtain the area of occupancy
of the species based on a simple grid of 4 km^2 resolution;
default = \code{TRUE}.}

\item{final_projection}{(character) string of projection arguments for
resulting Spatial objects. Arguments must be as in the PROJ.4 documentation.
See \code{\link[sp]{CRS-class}} for details. If \code{NULL}, the default,
projection used is WGS84 (EPSG:4326).}

\item{save_shp}{(logical) if \code{TRUE}, shapefiles of the species range,
occurrences, extent of occurrence, and area of occupancy will be written in
the working directory. Default = \code{FALSE}.}

\item{name}{(character) valid if \code{save_shp} = \code{TRUE}. The name of
the shapefile to be exported. A suffix will be added to \code{name} depending
on the object, as follows: species extent of occurrence = "_extent_occ", area
of occupancy = "_area_occ", and occurrences = "_unique_records".}

\item{overwrite}{(logical) whether or not to overwrite previous results with
the same name. Default = \code{FALSE}.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}
}
\value{
If \code{occurrences} and \code{threshold_omission} are defined, a  sp_range
object (S4) containing: (1) a data.frame with information about the species
range, and Spatial objects of (2) unique occurrences, (3) species range,
(4) extent of occurrence, and (5) area of occupancy.

If instead of \code{occurrences} and \code{threshold_omission},
\code{threshold_value} is provided, the result will be a sp_range object
(S4) of two elements: (1) a data.frame with information about the species
range, and (2) a SpatialPolygons object of the species range.

If \code{extent_of_occurrence} and/or \code{area_of_occupancy} = \code{FALSE},
the corresponding spatial objects in the resulting sp_range object will be
empty, an areas will have a value of 0.
}
\description{
rangemap_enm generates a distributional range for a given species
using a continuous raster layer produced using ecological niche modeling or
species distribution modeling tools. This function binarizes the model in
suitable and unsuitable areas using a user specified level of omission or a
given threshold value. Optionally, representations of the species extent of
occurrence (using convex hulls) and the area of occupancy according to the
IUCN criteria can also be generated. Shapefiles can be saved in the working
directory if it is needed.
}
\details{
All resulting Spatial objects in the list of results will be projected to the
\code{final_projection}. Areas are calculated in square kilometers using the
Lambert Azimuthal Equal Area projection, centered on the centroid of occurrence
points given as inputs or, if points are not provided, the resulting range.
}
\examples{
\donttest{
# parameters
sp_mod <- raster::raster(list.files(system.file("extdata", package = "rangemap"),
                                    pattern = "sp_model", full.names = TRUE))
data("occ_train", package = "rangemap")

thres <- 5
save <- TRUE
name <- "test"

enm_range <- rangemap_enm(model_output = sp_mod, occurrences = occ_train,
                          threshold_omission = thres)

summary(enm_range)
}
}
