% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_ra_probabilities.R
\name{simple_ra_probabilities}
\alias{simple_ra_probabilities}
\title{Probabilties of assignment: Simple Random Assignment}
\usage{
simple_ra_probabilities(N, prob = NULL, prob_each = NULL, num_arms = NULL,
  condition_names = NULL)
}
\arguments{
\item{N}{The number of units. N must be a positive integer. (required)}

\item{prob}{Use for a two-arm design. prob is the probability of assignment to treatment and must be a real number between 0 and 1 inclusive. (optional)}

\item{prob_each}{Use for a multi-arm design in which the values of prob_each determine the probabilties of assignment to each treatment condition. prob_each must be a numeric vector giving the probability of assignment to each condition. All entries must be nonnegative real numbers between 0 and 1 inclusive and the total must sum to 1.  (optional)}

\item{num_arms}{The number of treatment arms. If unspecified, num_arms will be determined from the other arguments. (optional)}

\item{condition_names}{A character vector giving the names of the treatment groups. If unspecified, the treatment groups will be named 0 (for control) and 1 (for treatment) in a two-arm trial and T1, T2, T3, in a multi-arm trial. An execption is a two-group design in which num_arms is set to 2, in which case the condition names are T1 and T2, as in a multi-arm trial with two arms. (optional)}
}
\value{
A matrix of probabilities of assignment
}
\description{
Probabilties of assignment: Simple Random Assignment
}
\examples{
# Two Group Designs
simple_ra_probabilities(N=100)
simple_ra_probabilities(N=100, prob=0.5)
simple_ra_probabilities(N=100, prob_each = c(0.3, 0.7),
                        condition_names = c("control", "treatment"))
# Multi-arm Designs
simple_ra_probabilities(N=100, num_arms=3)
simple_ra_probabilities(N=100, prob_each=c(0.3, 0.3, 0.4))
simple_ra_probabilities(N=100, prob_each=c(0.3, 0.3, 0.4),
                        condition_names=c("control", "placebo", "treatment"))
simple_ra_probabilities(N=100, condition_names=c("control", "placebo", "treatment"))

}

