% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ra_probabilities.R
\name{cluster_ra_probabilities}
\alias{cluster_ra_probabilities}
\title{Probabilties of assignment: Cluster Random Assignment}
\usage{
cluster_ra_probabilities(clust_var, m = NULL, num_arms = NULL,
  m_each = NULL, prob_each = NULL, condition_names = NULL)
}
\arguments{
\item{clust_var}{A vector of length N that indicates which cluster each unit belongs to.}

\item{m}{The total number clusters to be treated. Should only be specified for a two group design in which exactly m of N clusters is assigned to treatment. If not specified, half of the clusters will be assigned to treatment. Is NULL by default.}

\item{num_arms}{The total number of treatment arms. If unspecified, will be determined from the length of m_each or condition_names.}

\item{m_each}{A numeric vector giving the number of clusters to be assigned to each treatment group. Must sum to the total number of clusters. If unspecified, equally sized (rounded) groups will be assumed.}

\item{prob_each}{A numeric vector giving the probability of assignment to each treatment arm. Must sum to 1. Please note that due to rounding, these probabilities are approximate. For finer control, please use m_each.}

\item{condition_names}{A character vector giving the names of the treatment groups.  If unspecified, the treatment groups will be named T1, T2, T3, etc.}
}
\value{
A matrix of probabilities of assignment
}
\description{
Probabilties of assignment: Cluster Random Assignment
}
\examples{

# Two Group Designs
clust_var <- rep(letters, times=1:26)
cluster_ra_probabilities(clust_var=clust_var)

cluster_ra_probabilities(clust_var=clust_var, m=10)

cluster_ra_probabilities(clust_var=clust_var, m_each = c(9, 17), 
                         condition_names = c("control", "treatment"))

# Multi-arm Designs
cluster_ra_probabilities(clust_var=clust_var, num_arms=3)
cluster_ra_probabilities(clust_var=clust_var, m_each=c(7, 7, 12))

cluster_ra_probabilities(clust_var=clust_var, m_each=c(7, 7, 12), 
                         condition_names=c("control", "placebo", "treatment"))

cluster_ra_probabilities(clust_var=clust_var, 
                         condition_names=c("control", "placebo", "treatment"))

cluster_ra_probabilities(clust_var=clust_var, prob_each = c(.1, .2, .7))



}

