% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desScores.R
\name{getDesScores}
\alias{getDesScores}
\alias{getDesScores,assessment,missing-method}
\alias{getDesScores,assessment,numeric-method}
\title{Applying desirability functions on issues of individual randomization sequences}
\usage{
getDesScores(assess, ..., weights)

\S4method{getDesScores}{assessment,missing}(assess, ..., weights)

\S4method{getDesScores}{assessment,numeric}(assess, ..., weights)
}
\arguments{
\item{assess}{object of class \code{assessment}.}

\item{...}{at least one object of class \code{\link{derFunc}} or a list of objects of
the class \code{\link{derFunc}}.}

\item{weights}{weights for computing the geometric mean of several desirability
scores. If missing, the issues are automatically equally weighted.}
}
\value{
\code{S4} object of class \code{desirability} summarizing the desirability of the
randomization procedure.
}
\description{
Applying desirability function on issues of individual randomization sequences.
}
\details{
Randomization sequences behave differently with respect to issues
like selection bias, chronological bias, or loss in power estimation.
The \code{getDesScores} function evaluates the behavior of randomization
sequences with respect to these issues. The difference to the assess
function is that it scales them to \[0,1\] and makes them easier interpretable.
The first argument should be a result of the \code{\link{assess}} function.
The second argument should be any number of \code{\link{derFunc}} objects
that represent the desirability functions. The last argument \code{weights}
may be provided if the desirability functions should be weighted differently.
}
\examples{
# compute the desire-function for the full set of Random Allocation Rule for N = 4
sequences <- getAllSeq(rarPar(4))
issue1 <- corGuess("CS")
issue2 <- chronBias("linT", 0.25, "exact")
endp <- normEndp(mu = c(0,0), sigma = c(1,1))
A <- assess(sequences, issue1, issue2, endp = endp)
d1 <- derFunc(0.5, 0.75, 1)
d2 <- derFunc(0.05, 0.1, 1)

D1 <- getDesScores(A, d1, d2)
summary(D1)

D2 <- getDesScores(A, d1, d2, weights = c(3/4, 1/4))
summary(D2)

}
\seealso{
Representation of randomization procedures: \code{\link{randPar}}

Generation of randomization sequences: \code{\link{genSeq}}

\code{\link{issues}} for the desirability of randomization sequences

Other desirability topics: 
\code{\link{derFunc}},
\code{\link{evaluate}()},
\code{\link{plotDes}()},
\code{\link{plotEv}()},
\code{\link{probUnDes}()}
}
\concept{desirability topics}
