% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary,assessment-method}
\title{Summary of assessments of a randomization procedure}
\usage{
summary(object, ...)

\S4method{summary}{assessment}(object)
}
\arguments{
\item{object}{assessment object.}

\item{...}{additional arguments affecting the summary that will be produced.}
}
\value{
Data frame with a summary of the assessment object.
}
\description{
Summary of assessments of a randomization procedure
}
\details{
For each issue the assessment of the sequences is summarized to permit a design-based 
assessment of the randomization procedure.
This approach uses the sequence-wise values of the assessment and the probabilities
in order to give an overall summary.
}
\examples{
# assess the full set of PBR(4)
seq <- getAllSeq(pbrPar(4))
issue <- corGuess("CS")
A <- assess(seq, issue)
summary(A)

}

