% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rtexp}
\alias{rtexp}
\title{Truncated Exponential Distribution}
\usage{
rtexp(n, rate, l = NULL, r = NULL)
}
\arguments{
\item{n}{(\code{numeric})\cr Number of random numbers.}

\item{rate}{(\code{numeric})\cr Non-negative rate.}

\item{l}{(\code{numeric})\cr Positive left-hand truncation parameter.}

\item{r}{(\code{numeric})\cr Positive right-hand truncation parameter.}
}
\value{
The random numbers. If neither \code{l} nor \code{r} are provided then the usual Exponential
distribution is used.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This generates random numbers from a truncated Exponential distribution,
i.e. from \code{X | X > l} or \code{X | X < r} when \code{X ~ Exp(rate)}. The advantage here is that
we guarantee to return exactly \code{n} numbers and without using a loop internally.
This can be derived from the quantile functions of the left- and right-truncated
Exponential distributions.
}
\examples{
x <- stats::rexp(1e6, rate = 5)
x <- x[x > 0.5]
hist(x)

y <- rtexp(1e6, rate = 5, l = 0.5)
hist(y)

z <- rtexp(1e6, rate = 5, r = 0.5)
hist(z)
}
