% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ram_dir}
\alias{ram_dir}
\title{Output OS-independent path to the rappdirs directory on user's computer where
the RAM Legacy database is downloaded by default}
\usage{
ram_dir(vers = NULL)
}
\arguments{
\item{vers}{character, version number of the database. As of writing this
package, the available versions are "1.0", "2.0", "2.5", "3.0", "4.3","4.40",
"4.41", and "4.44". If version is not specified the \code{ram_dir()}
returns the path to the rappdirs top-level directory which stores
all the version subdirectories.}
}
\description{
Provides the download location for \code{\link{download_ramlegacy}}
in an OS independent manner. This is also the location from where
\code{\link{load_ramlegacy}} loads the database from.
}
\examples{
# return the path to the rappdirs directory where
# all version subdirectories are stored
ram_dir()

# Returns the path of the subdirectory where v4.3
# of the database is downloaded to and read from.
ram_dir(vers = "4.3")
}
\seealso{
Other ramlegacy functions: \code{\link{download_ramlegacy}},
  \code{\link{load_ramlegacy}}
}
\concept{ramlegacy functions}
