/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.HashMapAssignment;
import eu.amidst.core.variables.Variable;
import java.util.List;

public final class MultinomialIndex {
    public static int getIndexFromVariableAssignment(List<Variable> vars, Assignment assignment) {
        int lastPhiStride = 1;
        int index = 0;
        for (Variable var : vars) {
            index += (int)assignment.getValue(var) * lastPhiStride;
            lastPhiStride *= var.getNumberOfStates();
        }
        return index;
    }

    public static int getIndexFromVariableAssignment(List<Variable> vars, List<Double> assignment) {
        int n = vars.size();
        int lastPhiStride = 1;
        int index = 0;
        for (int i = 0; i < n; ++i) {
            index += (int)assignment.get(i).doubleValue() * lastPhiStride;
            lastPhiStride *= vars.get(i).getNumberOfStates();
        }
        return index;
    }

    public static int getIndexFromDataInstance(List<Variable> vars, DataInstance dataInstance) {
        int lastPhiStride = 1;
        int index = 0;
        for (Variable var : vars) {
            index += (int)dataInstance.getValue(var) * lastPhiStride;
            lastPhiStride *= var.getNumberOfStates();
        }
        return index;
    }

    public static int getIndexFromVariableAssignment(List<Variable> vars, double[] assignment) {
        int n = vars.size();
        int lastPhiStride = 1;
        int index = 0;
        for (int i = 0; i < n; ++i) {
            index += (int)assignment[i] * lastPhiStride;
            lastPhiStride *= vars.get(i).getNumberOfStates();
        }
        return index;
    }

    public static double[] getVariableArrayAssignmentFromIndex(List<Variable> vars, int index) {
        double[] assignment = new double[vars.size()];
        int n = vars.size();
        int lastPhiStride = 1;
        for (int i = 0; i < n; ++i) {
            assignment[i] = Math.floor((double)index / (double)lastPhiStride) % (double)vars.get(i).getNumberOfStates();
            lastPhiStride *= vars.get(i).getNumberOfStates();
        }
        return assignment;
    }

    public static Assignment getVariableAssignmentFromIndex(List<Variable> vars, int index) {
        HashMapAssignment assignment = new HashMapAssignment(vars.size());
        int n = vars.size();
        int lastPhiStride = 1;
        for (int i = 0; i < n; ++i) {
            assignment.setValue(vars.get(i), Math.floor((double)index / (double)lastPhiStride) % (double)vars.get(i).getNumberOfStates());
            lastPhiStride *= vars.get(i).getNumberOfStates();
        }
        return assignment;
    }

    public static int getNumberOfPossibleAssignments(List<Variable> vars) {
        int n = 1;
        for (Variable v : vars) {
            n *= v.getNumberOfStates();
        }
        return n;
    }
}

