/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.learning.parametric.bayesian.utils;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.inference.messagepassing.Node;
import eu.amidst.core.learning.parametric.bayesian.utils.PlateuStructure;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class PlateuIIDReplication
extends PlateuStructure {
    public PlateuIIDReplication() {
    }

    public PlateuIIDReplication(List<Variable> initialNonReplicatedVariablesList) {
        super(initialNonReplicatedVariablesList);
    }

    @Override
    public void setEvidence(List<? extends DataInstance> data) {
        int i;
        if (data.size() > this.nReplications) {
            throw new IllegalArgumentException("The size of the data is bigger than the number of repetitions");
        }
        for (i = 0; i < this.nReplications && i < data.size(); ++i) {
            int slice = i;
            ((List)this.replicatedNodes.get(i)).forEach(node -> {
                node.setAssignment((Assignment)data.get(slice));
                node.setActive(true);
            });
        }
        for (i = data.size(); i < this.nReplications; ++i) {
            ((List)this.replicatedNodes.get(i)).forEach(node -> {
                node.setAssignment(null);
                node.setActive(false);
            });
        }
        for (Node nonReplictedNode : this.nonReplictedNodes) {
            nonReplictedNode.setAssignment(data.get(0));
        }
    }

    @Override
    public void replicateModel() {
        int i;
        this.nonReplictedNodes = this.ef_learningmodel.getDistributionList().stream().filter(dist -> this.isNonReplicatedVar(dist.getVariable())).map(dist -> {
            Node node = new Node((EF_ConditionalDistribution)dist);
            this.nonReplicatedVarsToNode.put(dist.getVariable(), node);
            return node;
        }).collect(Collectors.toList());
        for (i = 0; i < this.nReplications; ++i) {
            ConcurrentHashMap map = new ConcurrentHashMap();
            List tmpNodes = this.ef_learningmodel.getDistributionList().stream().filter(dist -> this.isReplicatedVar(dist.getVariable())).map(dist -> {
                Node node = new Node((EF_ConditionalDistribution)dist);
                map.put(dist.getVariable(), node);
                return node;
            }).collect(Collectors.toList());
            this.replicatedVarsToNode.add(map);
            this.replicatedNodes.add(tmpNodes);
        }
        for (i = 0; i < this.nReplications; ++i) {
            for (Node node : (List)this.replicatedNodes.get(i)) {
                int slice = i;
                node.setParents(node.getPDist().getConditioningVariables().stream().map(var -> this.getNodeOfVar((Variable)var, slice)).collect(Collectors.toList()));
                node.getPDist().getConditioningVariables().stream().forEach(var -> this.getNodeOfVar((Variable)var, slice).getChildren().add(node));
            }
        }
        ArrayList<Node> allNodes = new ArrayList<Node>();
        allNodes.addAll(this.nonReplictedNodes);
        for (int i2 = 0; i2 < this.nReplications; ++i2) {
            allNodes.addAll((Collection)this.replicatedNodes.get(i2));
        }
        this.vmp.setNodes(allNodes);
    }
}

