/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.inference;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.inference.PointEstimator;
import eu.amidst.core.io.BayesianNetworkLoader;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.models.DAG;
import eu.amidst.core.models.ParentSet;
import eu.amidst.core.utils.BayesianNetworkSampler;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.HashMapAssignment;
import eu.amidst.core.variables.Variable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MAPInference
implements PointEstimator {
    private BayesianNetwork model;
    private List<Variable> causalOrder;
    private int sampleSize = 10;
    private int seed = 0;
    private Random MAPrandom;
    private int numberOfIterations = 100;
    private Assignment evidence = new HashMapAssignment(0);
    private long numberOfDiscreteVariables = 0L;
    private long numberOfDiscreteVariablesInEvidence = 0L;
    private boolean parallelMode = true;
    private List<Variable> MAPvariables;
    private Assignment MAPestimate;
    private double MAPestimateLogProbability;

    public MAPInference() {
        this.MAPrandom = new Random();
    }

    @Override
    public void setParallelMode(boolean parallelMode_) {
        this.parallelMode = parallelMode_;
    }

    @Override
    public void setSeed(int seed) {
        this.seed = seed;
        this.MAPrandom = new Random(seed);
    }

    @Override
    public void setModel(BayesianNetwork model_) {
        this.model = model_;
        this.causalOrder = Utils.getTopologicalOrder(this.model.getDAG());
    }

    @Override
    public void setEvidence(Assignment evidence_) {
        this.evidence = evidence_;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public void setMAPVariables(List<Variable> varsOfInterest1) {
        this.MAPvariables = varsOfInterest1;
    }

    public void setNumberOfIterations(int numberOfIterations) {
        this.numberOfIterations = numberOfIterations;
    }

    @Override
    public BayesianNetwork getOriginalModel() {
        return this.model;
    }

    @Override
    public Assignment getEstimate() {
        return this.MAPestimate;
    }

    @Override
    public double getLogProbabilityOfEstimate() {
        return this.MAPestimateLogProbability;
    }

    private double getProbabilityOf(Assignment as1) {
        return Math.exp(this.model.getLogProbabiltyOf(as1));
    }

    private String getMAPVariablesFromAssignment(Assignment assignment) {
        if (this.MAPvariables != null) {
            HashMapAssignment MAPVarsValues = new HashMapAssignment(this.MAPvariables.size());
            for (Variable var : this.MAPvariables) {
                MAPVarsValues.setValue(var, assignment.getValue(var));
            }
            return MAPVarsValues.outputString();
        }
        return assignment.outputString();
    }

    private Assignment fullAssignmentToMAPassignment(Assignment fullAssignment) {
        HashMapAssignment MAPassignment = new HashMapAssignment(this.MAPvariables.size());
        this.MAPvariables.stream().forEach(MAPvar -> MAPassignment.setValue((Variable)MAPvar, fullAssignment.getValue((Variable)MAPvar)));
        return MAPassignment;
    }

    @Override
    public void runInference() {
        this.runInference(SearchAlgorithm.HC_LOCAL);
    }

    public void runInference(SearchAlgorithm searchAlgorithm) {
        BayesianNetworkSampler bnSampler = new BayesianNetworkSampler(this.model);
        Stream<Assignment> samples = bnSampler.sampleToDataStream(this.sampleSize).stream().map(sample -> sample);
        switch (searchAlgorithm) {
            case SAMPLING: {
                Map<Assignment, List> groupedSamples = samples.collect(Collectors.groupingBy(this::getMAPVariablesFromAssignment)).values().stream().collect(Collectors.toMap(lst -> (Assignment)lst.get(0), lst -> lst));
                HashMap<Assignment, Double> newMap = new HashMap<Assignment, Double>();
                for (Map.Entry<Assignment, List> entry : groupedSamples.entrySet()) {
                    newMap.put(this.fullAssignmentToMAPassignment(entry.getKey()), entry.getValue().stream().mapToDouble(this::getProbabilityOf).average().getAsDouble());
                }
                Map.Entry MAPentry = (Map.Entry)newMap.entrySet().stream().reduce((e1, e2) -> (Double)e1.getValue() > (Double)e2.getValue() ? e1 : e2).get();
                this.MAPestimate = (Assignment)MAPentry.getKey();
                this.MAPestimateLogProbability = Math.log((Double)MAPentry.getValue());
                break;
            }
            default: {
                WeightedAssignment weightedAssignment = samples.map(sample -> this.runOptimizationAlgorithm((Assignment)sample, searchAlgorithm)).filter(partialResult -> Double.isFinite(((WeightedAssignment)partialResult).weight)).reduce((wa1, wa2) -> ((WeightedAssignment)wa1).weight > ((WeightedAssignment)wa2).weight ? wa1 : wa2).get();
                this.MAPestimate = this.fullAssignmentToMAPassignment(weightedAssignment.assignment);
                this.MAPestimateLogProbability = Math.log(weightedAssignment.weight);
            }
        }
    }

    private Assignment obtainValues(Assignment initialGuess, Assignment evidence, Random random) {
        Variable selectedVariable;
        int numberOfVariables = this.model.getNumberOfVars();
        HashMapAssignment result = new HashMapAssignment(initialGuess);
        ArrayList<Variable> contVarEvidence = new ArrayList<Variable>();
        double selectedVariableNewValue = 0.0;
        for (int i = 0; i < numberOfVariables; ++i) {
            selectedVariable = this.causalOrder.get(i);
            Object conDist = this.model.getConditionalDistribution(selectedVariable);
            if (!selectedVariable.isMultinomial() || !Double.isNaN(evidence.getValue(selectedVariable))) continue;
            try {
                HashMapAssignment parentsConfiguration = new HashMapAssignment(1);
                ((ConditionalDistribution)conDist).getConditioningVariables().forEach(parent -> parentsConfiguration.setValue((Variable)parent, result.getValue((Variable)parent)));
                UnivariateDistribution uniDist = ((ConditionalDistribution)conDist).getUnivariateDistribution(parentsConfiguration);
                selectedVariableNewValue = uniDist.sample(random);
                result.setValue(selectedVariable, selectedVariableNewValue);
                continue;
            }
            catch (Exception parentsConfiguration) {
                // empty catch block
            }
        }
        DAG graph = this.model.getDAG();
        for (int i = 0; i < numberOfVariables; ++i) {
            selectedVariable = this.causalOrder.get(i);
            if (!selectedVariable.isNormal() || Double.isNaN(evidence.getValue(selectedVariable))) continue;
            contVarEvidence.add(selectedVariable);
        }
        boolean ended = false;
        int indexCheckedVars = 0;
        while (!ended) {
            ended = true;
            while (indexCheckedVars < contVarEvidence.size()) {
                Variable currentVariable = (Variable)contVarEvidence.get(indexCheckedVars);
                ParentSet parents = graph.getParentSet(currentVariable);
                for (Variable currentParent : parents.getParents()) {
                    if (!currentParent.isNormal() || contVarEvidence.contains(currentParent)) continue;
                    ended = false;
                    contVarEvidence.add(currentParent);
                }
                ++indexCheckedVars;
            }
        }
        Collections.reverse(contVarEvidence);
        for (Variable current : contVarEvidence) {
            if (!Double.isNaN(evidence.getValue(current))) continue;
            HashMapAssignment parentsConfiguration = new HashMapAssignment(1);
            ((ConditionalDistribution)this.model.getConditionalDistribution(current)).getConditioningVariables().forEach(parent -> parentsConfiguration.setValue((Variable)parent, result.getValue((Variable)parent)));
            UnivariateDistribution univariateDistribution = ((ConditionalDistribution)this.model.getConditionalDistribution(current)).getUnivariateDistribution(parentsConfiguration);
            double newValue = univariateDistribution.sample(random);
            result.setValue(current, newValue);
        }
        for (int i = 0; i < numberOfVariables; ++i) {
            selectedVariable = this.causalOrder.get(i);
            if (!selectedVariable.isNormal() || !Double.isNaN(result.getValue(selectedVariable))) continue;
            HashMapAssignment parentsConfiguration = new HashMapAssignment(1);
            ((ConditionalDistribution)this.model.getConditionalDistribution(selectedVariable)).getConditioningVariables().forEach(parent -> parentsConfiguration.setValue((Variable)parent, result.getValue((Variable)parent)));
            UnivariateDistribution univariateDistribution = ((ConditionalDistribution)this.model.getConditionalDistribution(selectedVariable)).getUnivariateDistribution(parentsConfiguration);
            double newValue = univariateDistribution.getParameters()[0];
            result.setValue(selectedVariable, newValue);
        }
        return result;
    }

    private Assignment obtainValuesRandomly(Assignment initialGuess, Assignment evidence, Random random) {
        Variable selectedVariable;
        int numberOfVariables = this.model.getNumberOfVars();
        HashMapAssignment result = new HashMapAssignment(initialGuess);
        ArrayList<Variable> contVarEvidence = new ArrayList<Variable>();
        evidence.getVariables().stream().filter(Variable::isMultinomial).forEach(va -> result.setValue((Variable)va, evidence.getValue((Variable)va)));
        this.causalOrder.stream().filter(va -> va.isMultinomial() && Double.isNaN(evidence.getValue((Variable)va))).forEach(va -> result.setValue((Variable)va, random.nextInt(va.getNumberOfStates())));
        DAG graph = this.model.getDAG();
        for (int i = 0; i < numberOfVariables; ++i) {
            selectedVariable = this.causalOrder.get(i);
            if (!selectedVariable.isNormal() || Double.isNaN(evidence.getValue(selectedVariable))) continue;
            contVarEvidence.add(selectedVariable);
        }
        boolean ended = false;
        int indexCheckedVars = 0;
        while (!ended) {
            ended = true;
            while (indexCheckedVars < contVarEvidence.size()) {
                Variable currentVariable = (Variable)contVarEvidence.get(indexCheckedVars);
                ParentSet parents = graph.getParentSet(currentVariable);
                for (Variable currentParent : parents.getParents()) {
                    if (!currentParent.isNormal() || contVarEvidence.contains(currentParent)) continue;
                    ended = false;
                    contVarEvidence.add(currentParent);
                }
                ++indexCheckedVars;
            }
        }
        Collections.reverse(contVarEvidence);
        for (Variable current : contVarEvidence) {
            if (!Double.isNaN(evidence.getValue(current))) continue;
            UnivariateDistribution univariateDistribution = ((ConditionalDistribution)this.model.getConditionalDistribution(current)).getUnivariateDistribution(result);
            double univDistMean = univariateDistribution.getParameters()[0];
            double univDistStDev = univariateDistribution.getParameters()[1];
            double newValue = univDistMean - 3.0 * univDistStDev + random.nextDouble() * 6.0 * univDistStDev;
            result.setValue(current, newValue);
        }
        for (int i = 0; i < numberOfVariables; ++i) {
            selectedVariable = this.causalOrder.get(i);
            if (!selectedVariable.isNormal() || !Double.isNaN(result.getValue(selectedVariable))) continue;
            UnivariateDistribution univariateDistribution = ((ConditionalDistribution)this.model.getConditionalDistribution(selectedVariable)).getUnivariateDistribution(result);
            double univDistMean = univariateDistribution.getParameters()[0];
            double univDistStDev = univariateDistribution.getParameters()[1];
            double newValue = univDistMean - 3.0 * univDistStDev + random.nextDouble() * 6.0 * univDistStDev;
            result.setValue(selectedVariable, newValue);
        }
        return result;
    }

    protected double estimateProbabilityOfPartialAssignment(Assignment MAPassignment) {
        return this.estimateProbabilityOfPartialAssignment(MAPassignment, true);
    }

    private double estimateProbabilityOfPartialAssignment(Assignment MAPassignment, boolean useConditionalDistributions) {
        double probabilityEstimate;
        int numSamplesAverage = 150;
        HashMapAssignment evidenceAugmented = new HashMapAssignment(this.evidence);
        this.MAPvariables.forEach(voi -> evidenceAugmented.setValue((Variable)voi, MAPassignment.getValue((Variable)voi)));
        HashMapAssignment finalAssignment = new HashMapAssignment(MAPassignment);
        IntStream auxIntStream = IntStream.range(0, 150);
        try {
            probabilityEstimate = auxIntStream.mapToObj(i -> {
                if (useConditionalDistributions) {
                    return this.obtainValues(finalAssignment, evidenceAugmented, new Random(this.MAPrandom.nextInt()));
                }
                return this.obtainValuesRandomly(finalAssignment, evidenceAugmented, new Random(this.MAPrandom.nextInt()));
            }).mapToDouble(as -> Math.exp(this.model.getLogProbabiltyOf((Assignment)as))).filter(Double::isFinite).average().getAsDouble();
        }
        catch (Exception e) {
            probabilityEstimate = 0.0;
        }
        return probabilityEstimate;
    }

    private WeightedAssignment runOptimizationAlgorithm(Assignment initialGuess, SearchAlgorithm optAlgorithm) {
        double alpha;
        double eps;
        double R;
        int optAlg;
        int movingVariablesLocalSearch = 3;
        switch (optAlgorithm) {
            case SA_GLOBAL: {
                optAlg = -2;
                break;
            }
            case SA_LOCAL: {
                optAlg = -1;
                break;
            }
            case HC_GLOBAL: {
                optAlg = 2;
                break;
            }
            default: {
                optAlg = 1;
            }
        }
        if (optAlg > 0) {
            R = this.numberOfIterations;
            eps = 0.0;
            alpha = 0.0;
        } else {
            R = 1000.0;
            alpha = 0.9;
            eps = R * Math.pow(alpha, this.numberOfIterations);
        }
        Assignment currentAssignment = new HashMapAssignment(initialGuess);
        double currentProbability = this.estimateProbabilityOfPartialAssignment(currentAssignment, false);
        Random random = new Random(this.MAPrandom.nextInt());
        while (R > eps) {
            Assignment nextAssignment;
            if (optAlg % 2 == 0) {
                nextAssignment = this.obtainValues(currentAssignment, this.evidence, random);
            } else {
                nextAssignment = this.moveDiscreteVariables(currentAssignment, 3);
                nextAssignment = this.assignContinuousVariables(nextAssignment);
            }
            double nextProbability = this.estimateProbabilityOfPartialAssignment(nextAssignment, false);
            if (nextProbability > currentProbability) {
                currentAssignment = nextAssignment;
                currentProbability = nextProbability;
            } else if (optAlg < 0) {
                double diff = currentProbability - nextProbability;
                double aux = random.nextDouble();
                if (aux < Math.exp(-diff / R)) {
                    currentAssignment = nextAssignment;
                    currentProbability = nextProbability;
                }
            }
            if (optAlg > 0) {
                R -= 1.0;
                continue;
            }
            R = alpha * R;
        }
        return new WeightedAssignment(currentAssignment, currentProbability);
    }

    private Assignment moveDiscreteVariables(Assignment initialGuess, int numberOfMovements) {
        HashMapAssignment result = new HashMapAssignment(initialGuess);
        Random random = new Random(this.MAPrandom.nextInt());
        ArrayList<Integer> indicesVariablesMoved = new ArrayList<Integer>();
        if ((long)numberOfMovements > this.numberOfDiscreteVariables - this.numberOfDiscreteVariablesInEvidence) {
            numberOfMovements = (int)(this.numberOfDiscreteVariables - this.numberOfDiscreteVariablesInEvidence);
        }
        while (indicesVariablesMoved.size() < numberOfMovements) {
            int indexSelectedVariable = random.nextInt(this.model.getNumberOfVars());
            Variable selectedVariable = this.model.getVariables().getVariableById(indexSelectedVariable);
            if (indicesVariablesMoved.contains(indexSelectedVariable) || selectedVariable.isNormal() || !Double.isNaN(this.evidence.getValue(selectedVariable))) continue;
            indicesVariablesMoved.add(indexSelectedVariable);
            int newValue = random.nextInt(selectedVariable.getNumberOfStates());
            result.setValue(selectedVariable, newValue);
        }
        return result;
    }

    private Assignment assignContinuousVariables(Assignment initialGuess) {
        Variable selectedVariable;
        HashMapAssignment result = new HashMapAssignment(initialGuess);
        int numberOfVariables = this.model.getNumberOfVars();
        Random random = new Random(this.MAPrandom.nextInt());
        ArrayList<Variable> contVarEvidence = new ArrayList<Variable>();
        DAG graph = this.model.getDAG();
        for (int i = 0; i < numberOfVariables; ++i) {
            selectedVariable = this.causalOrder.get(i);
            if (!selectedVariable.isNormal() || Double.isNaN(this.evidence.getValue(selectedVariable))) continue;
            contVarEvidence.add(selectedVariable);
        }
        boolean ended = false;
        int indexCheckedVars = 0;
        while (!ended) {
            ended = true;
            while (indexCheckedVars < contVarEvidence.size()) {
                Variable currentVariable = (Variable)contVarEvidence.get(indexCheckedVars);
                ParentSet parents = graph.getParentSet(currentVariable);
                for (Variable currentParent : parents.getParents()) {
                    if (!currentParent.isNormal() || contVarEvidence.contains(currentParent)) continue;
                    ended = false;
                    contVarEvidence.add(currentParent);
                }
                ++indexCheckedVars;
            }
        }
        Collections.reverse(contVarEvidence);
        for (Variable current : contVarEvidence) {
            if (!Double.isNaN(this.evidence.getValue(current))) continue;
            UnivariateDistribution univariateDistribution = ((ConditionalDistribution)this.model.getConditionalDistribution(current)).getUnivariateDistribution(result);
            double newValue = univariateDistribution.sample(random);
            result.setValue(current, newValue);
        }
        for (int i = 0; i < numberOfVariables; ++i) {
            selectedVariable = this.causalOrder.get(i);
            if (!selectedVariable.isNormal() || !Double.isNaN(this.evidence.getValue(selectedVariable))) continue;
            UnivariateDistribution univariateDistribution = ((ConditionalDistribution)this.model.getConditionalDistribution(selectedVariable)).getUnivariateDistribution(result);
            double newValue = univariateDistribution.getParameters()[0];
            result.setValue(selectedVariable, newValue);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        BayesianNetwork bn = BayesianNetworkLoader.loadFromFile("./networks/dataWeka/asia.bn");
        System.out.println(bn.toString());
        MAPInference mapInference = new MAPInference();
        mapInference.setModel(bn);
        mapInference.setParallelMode(true);
        System.out.println("CausalOrder: " + Arrays.toString(mapInference.causalOrder.stream().map(v -> v.getName()).toArray()));
        System.out.println();
        int parallelSamples = 20;
        int samplingMethodSize = 1000;
        mapInference.setSampleSize(parallelSamples);
        Variable variable1 = mapInference.causalOrder.get(1);
        Variable variable2 = mapInference.causalOrder.get(2);
        Variable variable3 = mapInference.causalOrder.get(4);
        int var1value = 0;
        int var2value = 1;
        int var3value = 1;
        System.out.println("Evidence: Variable " + variable1.getName() + " = " + var1value + ", Variable " + variable2.getName() + " = " + var2value + ", " + " and Variable " + variable3.getName() + " = " + var3value);
        System.out.println();
        HashMapAssignment evidenceAssignment = new HashMapAssignment(3);
        evidenceAssignment.setValue(variable1, var1value);
        evidenceAssignment.setValue(variable2, var2value);
        evidenceAssignment.setValue(variable3, var3value);
        mapInference.setEvidence(evidenceAssignment);
        Variable varInterest1 = mapInference.causalOrder.get(6);
        Variable varInterest2 = mapInference.causalOrder.get(7);
        ArrayList<Variable> varsInterest = new ArrayList<Variable>();
        varsInterest.add(varInterest1);
        varsInterest.add(varInterest2);
        mapInference.setMAPVariables(varsInterest);
        System.out.println("MAP Variables of Interest: " + Arrays.toString(mapInference.MAPvariables.stream().map(Variable::getName).toArray()));
        System.out.println();
        long timeStart = System.nanoTime();
        mapInference.runInference(SearchAlgorithm.SA_GLOBAL);
        Assignment mapEstimate = mapInference.getEstimate();
        System.out.println("MAP estimate  (SA.All): " + mapEstimate.outputString(varsInterest));
        System.out.println("with (unnormalized) probability: " + Math.exp(mapInference.getLogProbabilityOfEstimate()));
        long timeStop = System.nanoTime();
        double execTime = (double)(timeStop - timeStart) / 1.0E9;
        System.out.println("computed in: " + Double.toString(execTime) + " seconds");
        System.out.println();
        timeStart = System.nanoTime();
        mapInference.runInference(SearchAlgorithm.SA_LOCAL);
        mapEstimate = mapInference.getEstimate();
        System.out.println("MAP estimate  (SA.Some): " + mapEstimate.outputString(varsInterest));
        System.out.println("with (unnormalized) probability: " + Math.exp(mapInference.getLogProbabilityOfEstimate()));
        timeStop = System.nanoTime();
        execTime = (double)(timeStop - timeStart) / 1.0E9;
        System.out.println("computed in: " + Double.toString(execTime) + " seconds");
        System.out.println();
        timeStart = System.nanoTime();
        mapInference.runInference(SearchAlgorithm.HC_GLOBAL);
        mapEstimate = mapInference.getEstimate();
        System.out.println("MAP estimate  (HC.All): " + mapEstimate.outputString(varsInterest));
        System.out.println("with (unnormalized) probability: " + Math.exp(mapInference.getLogProbabilityOfEstimate()));
        timeStop = System.nanoTime();
        execTime = (double)(timeStop - timeStart) / 1.0E9;
        System.out.println("computed in: " + Double.toString(execTime) + " seconds");
        System.out.println();
        timeStart = System.nanoTime();
        mapInference.runInference(SearchAlgorithm.HC_LOCAL);
        mapEstimate = mapInference.getEstimate();
        System.out.println("MAP estimate  (HC.Some): " + mapEstimate.outputString(varsInterest));
        System.out.println("with (unnormalized) probability: " + Math.exp(mapInference.getLogProbabilityOfEstimate()));
        timeStop = System.nanoTime();
        execTime = (double)(timeStop - timeStart) / 1.0E9;
        System.out.println("computed in: " + Double.toString(execTime) + " seconds");
        System.out.println();
        mapInference.setSampleSize(samplingMethodSize);
        timeStart = System.nanoTime();
        mapInference.runInference(SearchAlgorithm.SAMPLING);
        mapEstimate = mapInference.getEstimate();
        System.out.println("MAP estimate (SAMPLING): " + mapEstimate.outputString(varsInterest));
        System.out.println("with probability: " + Math.exp(mapInference.getLogProbabilityOfEstimate()));
        timeStop = System.nanoTime();
        execTime = (double)(timeStop - timeStart) / 1.0E9;
        System.out.println("computed in: " + Double.toString(execTime) + " seconds");
        System.out.println();
        Variable varB = bn.getVariables().getVariableByName("B");
        Variable varD = bn.getVariables().getVariableByName("D");
        double s1 = mapInference.estimateProbabilityOfPartialAssignment(mapEstimate);
        System.out.println(mapEstimate.outputString(varsInterest) + " with prob. " + s1);
        mapEstimate.setValue(varD, 1.0);
        double s2 = mapInference.estimateProbabilityOfPartialAssignment(mapEstimate);
        System.out.println(mapEstimate.outputString(varsInterest) + " with prob. " + s2);
        mapEstimate.setValue(varB, 1.0);
        mapEstimate.setValue(varD, 0.0);
        double s3 = mapInference.estimateProbabilityOfPartialAssignment(mapEstimate);
        System.out.println(mapEstimate.outputString(varsInterest) + " with prob. " + s3);
        mapEstimate.setValue(varD, 1.0);
        double s4 = mapInference.estimateProbabilityOfPartialAssignment(mapEstimate);
        System.out.println(mapEstimate.outputString(varsInterest) + " with prob. " + s4);
        double sum = s1 + s2 + s3 + s4;
        System.out.println();
        System.out.println("Sum = " + sum + "; Normalized probs: [B=0,D=0]=" + s1 / sum + ", [B=0,D=1]=" + s2 / sum + ", [B=1,D=0]=" + s3 / sum + ", [B=1,D=1]=" + s4 / sum);
        System.out.println("Exact probs: 0.48, 0.12, 0.04, 0.36");
    }

    private class WeightedAssignment {
        private Assignment assignment;
        private double weight;

        public WeightedAssignment(Assignment assignment_, double weight_) {
            this.assignment = assignment_;
            this.weight = weight_;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("[ ");
            str.append(this.assignment.outputString());
            str.append("Weight = " + this.weight + " ]");
            return str.toString();
        }
    }

    public static enum SearchAlgorithm {
        SAMPLING,
        SA_LOCAL,
        SA_GLOBAL,
        HC_LOCAL,
        HC_GLOBAL;

    }
}

