/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.distribution;

import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.variables.Variable;
import java.util.Random;

public class DeltaDistribution
extends UnivariateDistribution {
    double deltaValue;

    public DeltaDistribution(Variable var1, double deltaValue1) {
        this.var = var1;
        this.deltaValue = deltaValue1;
    }

    public double getDeltaValue() {
        return this.deltaValue;
    }

    @Override
    public double getLogProbability(double value) {
        return this.deltaValue == value ? 1.0 : 0.0;
    }

    @Override
    public double sample(Random rand) {
        return this.deltaValue;
    }

    @Override
    public <E extends EF_UnivariateDistribution> E toEFUnivariateDistribution() {
        throw new UnsupportedOperationException("This distribution is not supported yet in exponential form");
    }

    @Override
    public UnivariateDistribution deepCopy(Variable variable) {
        return new DeltaDistribution(variable, this.getDeltaValue());
    }

    @Override
    public double[] getParameters() {
        return new double[1];
    }

    @Override
    public int getNumberOfParameters() {
        return 1;
    }

    @Override
    public String label() {
        return "Delta of " + this.deltaValue;
    }

    @Override
    public void randomInitialization(Random random) {
    }

    @Override
    public boolean equalDist(Distribution dist, double threshold) {
        if (dist instanceof DeltaDistribution) {
            return this.equalDist((DeltaDistribution)dist, threshold);
        }
        return false;
    }

    @Override
    public String toString() {
        return null;
    }

    public boolean equalDist(DeltaDistribution dist) {
        if (dist.getVariable() != dist.getVariable()) {
            return false;
        }
        return this.deltaValue == dist.getDeltaValue();
    }
}

