% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing.R
\name{td_priceHistory}
\alias{td_priceHistory}
\title{Get price history for a multiple securities}
\usage{
td_priceHistory(
  tickers = c("AAPL", "MSFT"),
  startDate = Sys.Date() - 30,
  endDate = Sys.Date(),
  freq = c("daily", "1min", "5min", "10min", "15min", "30min"),
  accessToken = NULL
)
}
\arguments{
\item{tickers}{a vector of tickers - no more than 15 will be pulled. for
bigger requests, split up the request or use Tiingo, FMP Cloud, or other
free data providers}

\item{startDate}{the Starting point of the data}

\item{endDate}{the Ending point of the data}

\item{freq}{the frequency of the interval. Can be daily, 1min, 5min, 10min,
15min, or 30min}

\item{accessToken}{A valid Access Token must be set using
\code{\link{td_auth_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
a tibble of historical price data
}
\description{
Open, Close, High, Low, and Volume for one or more securities
}
\details{
Pulls price history for a list of security based on the parameters that
include a date range and frequency of the interval. Depending on the
frequency interval, data can only be pulled back to a certain date. For
example, at a one minute interval, data can only be pulled for 30-35 days.
Prices are adjusted for splits but not dividends.

PLEASE NOTE: Large data requests will take time to pull back because of the
looping nature. TD Does not allow bulk ticker request, so this is simply
running each ticker individually. For faster and better historical data
pulls, try Tiingo or FMP Cloud
}
\examples{
\dontrun{

# Set the access token and a provide a vector of one or more tickers
refreshToken = readRDS('/secure/location/')
accessToken = td_auth_accessToken(refreshToken, 'consumerKey')
tickHist5min = td_priceHistory(c('TSLA','AAPL'), freq='5min')

# The default is daily. Access token is optional once it's been set
tickHistDay = td_priceHistory(c('SPY','IWM'), startDate = '1990-01-01')

}
}
