% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainette_explor.R
\name{rainette_explor}
\alias{rainette_explor}
\title{Shiny gadget for rainette clustering exploration}
\usage{
rainette_explor(res, dtm)
}
\arguments{
\item{res}{result object of a \code{rainette} clustering}

\item{dtm}{the dfm object used to compute the clustering}
}
\value{
No return value, called for side effects.
}
\description{
Shiny gadget for rainette clustering exploration
}
\examples{
\dontrun{
library(quanteda)
corpus <- data_corpus_inaugural
corpus <- head(corpus, n = 10)
corpus <- split_segments(corpus)
dtm <- dfm(corpus, remove = stopwords("en"), tolower = TRUE, remove_punct = TRUE)
dtm <- dfm_trim(dtm, min_termfreq = 3)
res <- rainette(dtm, k = 3)
rainette_explor(dtm, res)
}

}
\seealso{
\code{rainette_plot}
}
