% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/railtrails.R
\docType{data}
\name{railtrails}
\alias{railtrails}
\title{Rail-trail trail data}
\format{Data frame with columns
\describe{
\item{name}{Name of rail trail}
\item{distance}{distance (miles)}
\item{surface}{surface material}
\item{category}{trail category}
\item{mean_review}{mean review rating}
\item{description}{text description of trail}
\item{n_reviews}{number of reviews}
\item{raw_reviews}{list column with a vector of reviews}
\item{lat}{the latitude for the trailhead (from Google Maps search of the trail's name)}
\item{lng}{the longitude for the trailhead (from Google Maps search of the trail's name)}
}}
\source{
https://www.traillink.com/
}
\usage{
railtrails
}
\description{
Information and reviews for rail-trails in the United States
}
\examples{
railtrails

# to expand vector of review ratings in raw_reviews column:
library(tidyr)
railtrails <- railtrails \%>\% unnest(raw_reviews)
}
\keyword{datasets}
