% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{american_implied_volatility}
\alias{american_implied_volatility}
\title{Implied volatility of an american option with equity-independent term structures}
\usage{
american_implied_volatility(option_price, callput, S0, K, time,
  const_default_intensity = 0, survival_probability_fcn = function(T,
  t, ...) {     exp(-const_default_intensity * (T - t)) },
  default_intensity_fcn = function(t, S, ...) {    
  const_default_intensity + 0 * S }, ..., num_time_steps = 30,
  structure_constant = 2, std_devs_width = 5,
  relative_tolerance = 1e-04, max.iter = 100, max_vola = 4)
}
\arguments{
\item{option_price}{Option price to match}

\item{callput}{1 for calls, -1 for puts}

\item{S0}{An initial stock price, for setting grid scale}

\item{K}{strike}

\item{time}{Time from \code{0} until expiration}

\item{const_default_intensity}{A constant to use for the instantaneous default intensity in case \code{default_intensity_fcn}
is not given}

\item{survival_probability_fcn}{(Implied argument) A function for probability of survival, with
arguments \code{T}, \code{t} and \code{T>t}.}

\item{default_intensity_fcn}{A function for computing default intensity
occurring at a given time, dependent on time and stock price, with
arguments \code{t}, \code{S}.  Should be matched to \code{survival_probability_fcn}}

\item{...}{Additional arguments to be passed on to \code{\link{implied_volatility_with_term_struct}}
and \code{\link{american}}}

\item{num_time_steps}{Minimum number of time steps in the grid}

\item{structure_constant}{The maximum ratio between time intervals \code{dt}
and the square of space intervals \code{dz^2}}

\item{std_devs_width}{The number of standard deviations, in \code{sigma * sqrt(T)}
units, to incorporate into the grid}

\item{relative_tolerance}{Relative tolerance in instrument price defining the root-finder halting condition}

\item{max.iter}{Maximum number of root-finder iterations allowed}

\item{max_vola}{Maximum volatility to try}
}
\value{
Estimated volatility
}
\description{
Use the grid solver to generate american option values under
  a default model with survival probabilities not linked to equity prices. and run them
  through a bisective root search method until a constant volatility matching the provided
  option price has been found.
}
\examples{
american_implied_volatility(25,CALL,S0=100,K=100,time=2.2,
  const_short_rate=0.03, num_time_steps=5)
df250 =  function(t) ( exp(-0.02*t)*exp(-0.03*max(0,t-1.0))) # Simple term structure
df25 = function(T,t){df250(T)/df250(t)} # Relative discount factors
american_implied_volatility(25,-1,100,100,2.2,
  discount_factor_fcn=df25, num_time_steps=5)
}
\seealso{
\code{\link{implied_volatility_with_term_struct}} for implied volatility
  of European options under the same conditions, \code{\link{american}} for the
  underlying pricing algorithm

Other Implied Volatilities: \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{fit_variance_cumulation}},
  \code{\link{implied_jump_process_volatility}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}},
  \code{\link{implied_volatility}}

Other Equity Independent Default Intensity: \code{\link{american}},
  \code{\link{black_scholes_on_term_structures}},
  \code{\link{blackscholes}},
  \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}},
  \code{\link{implied_volatility}}

Other American Exercise Equity Options: \code{\link{american}},
  \code{\link{control_variate_pairs}}
}
\concept{American Exercise Equity Options}
\concept{Equity Independent Default Intensity}
\concept{Implied Volatilities}
\concept{implied volatility}
\keyword{calibration}
