% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnp_scan_save.R
\name{mcnp_scan_save}
\alias{mcnp_scan_save}
\title{Copy and paste MCNP output spectral data for use with \code{mcnp_plot_out_spec()}}
\usage{
mcnp_scan_save()
}
\value{
spectrum file with maximum energy and MCNP bin value
}
\description{
Provides quick copy-and-paste conversion to data frame.
Paste either a source histogram distribution or tally spectrum from MCNP outputs.
Three-column output tally spectra have columns of maximum energy, bin tally, and 
relative Monte Carlo uncertainty for the bin tally value. 
Four-column  source histogram distributions have columns of entry number, maximum 
energy, cumulative probability, and bin probability.
Seven-column biased histogram distributions have columns of entry
number, maximum energy, cumulative probability, biased cumulative
probability, probability of bin, biased probability, and weight
multiplier.
In all cases, only the maximum energy and bin probability or result values are used.
}
\examples{
# Since this function requires the user
# to copy and paste input, this example
# is set up to provide data for this purpose.
# To run the example, copy and paste the following
# into an input file and delete the hash tags to run.
# my_hist_data <- mcnp_scan_save()
# 0.1000000 3.133122e-05 0.3348260
# 0.4222222 6.731257e-05 0.2017546
# 0.7444444 5.249198e-05 0.4524577
# 1.0666667 2.046046e-04 0.4201954
# 1.3888889 1.525125e-03 0.8049388
# 1.7111111 2.922743e-05 0.7985399
# 2.0333333 5.162954e-03 0.1974694
# 2.3555556 2.048186e-05 0.5011170
# 2.6777778 1.468040e-04 0.7248116
# 3.0000000 1.037092e-04 0.7659850
}
\seealso{
Other mcnp tools: 
\code{\link{mcnp_cone_angle}()},
\code{\link{mcnp_est_nps}()},
\code{\link{mcnp_matrix_rotations}()},
\code{\link{mcnp_plot_out_spec}()},
\code{\link{mcnp_scan2plot}()},
\code{\link{mcnp_si_sp_RD}()},
\code{\link{mcnp_si_sp_hist_scan}()},
\code{\link{mcnp_si_sp_hist}()}
}
\concept{mcnp tools}
