% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_factor.R
\name{plot.pre_factor}
\alias{plot.pre_factor}
\title{Plot method for the pre_factor function}
\usage{
\method{plot}{pre_factor}(x, plots = c("scree", "change"),
  cutoff = 0.2, shiny = FALSE, custom = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{pre_factor}}}

\item{plots}{Plots to return. "change" shows the change in eigenvalues as variables are grouped into different number of factors, "scree" shows a scree plot of eigenvalues}

\item{cutoff}{For large datasets plots can take time to render and become hard to interpret. By selection a cutoff point (e.g., eigenvalues of .8 or higher) factors with the least explanatory power are removed from the plot}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the pre_factor function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/pre_factor.html} for an example in Radiant
}
\examples{
result <- pre_factor(shopping, "v1:v6")
plot(result, plots = c("change", "scree"), cutoff = .05)

}
\seealso{
\code{\link{pre_factor}} to calculate results

\code{\link{summary.pre_factor}} to summarize results
}
