% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforest.R
\name{cv.rforest}
\alias{cv.rforest}
\title{Cross-validation for a Random Forest}
\usage{
cv.rforest(
  object,
  K = 5,
  repeats = 1,
  mtry = 1:5,
  num.trees = NULL,
  min.node.size = 1,
  sample.fraction = NA,
  trace = TRUE,
  seed = 1234,
  fun,
  ...
)
}
\arguments{
\item{object}{Object of type "rforest" or "ranger"}

\item{K}{Number of cross validation passes to use}

\item{repeats}{Repeated cross validation}

\item{mtry}{Number of variables to possibly split at in each node. Default is the (rounded down) square root of the number variables}

\item{num.trees}{Number of trees to create}

\item{min.node.size}{Minimal node size}

\item{sample.fraction}{Fraction of observations to sample. Default is 1 for sampling with replacement and 0.632 for sampling without replacement}

\item{trace}{Print progress}

\item{seed}{Random seed to use as the starting point}

\item{fun}{Function to use for model evaluation (i.e., auc for classification and RMSE for regression)}

\item{...}{Additional arguments to be passed to 'fun'}
}
\value{
A data.frame sorted by the mean of the performance metric
}
\description{
Cross-validation for a Random Forest
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/rforest.html} for an example in Radiant
}
\examples{
\dontrun{
result <- rforest(dvd, "buy", c("coupon", "purch", "last"))
cv.rforest(
  result, mtry = 1:3, min.node.size = seq(1, 10, 5),
  num.trees = c(100, 200), sample.fraction = 0.632
)
result <- rforest(titanic, "survived", c("pclass", "sex"), max.depth = 1)
cv.rforest(result, mtry = 1:3, min.node.size = seq(1, 10, 5))
cv.rforest(result, mtry = 1:3, num.trees = c(100, 200), fun = profit, cost = 1, margin = 5)
result <- rforest(diamonds, "price", c("carat", "color", "clarity"), type = "regression")
cv.rforest(result, mtry = 1:3, min.node.size = 1)
cv.rforest(result, mtry = 1:3, min.node.size = 1, fun = Rsq)
}

}
\seealso{
\code{\link{rforest}} to generate an initial model that can be passed to cv.rforest

\code{\link{Rsq}} to calculate an R-squared measure for a regression

\code{\link{RMSE}} to calculate the Root Mean Squared Error for a regression

\code{\link{MAE}} to calculate the Mean Absolute Error for a regression

\code{\link{auc}} to calculate the area under the ROC curve for classification

\code{\link{profit}} to calculate profits for classification at a cost/margin threshold
}
