% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtree.R
\name{plot.dtree}
\alias{plot.dtree}
\title{Plot method for the dtree function}
\usage{
\method{plot}{dtree}(x, symbol = "$", dec = 2, final = FALSE,
  orient = "LR", width = "900px", ...)
}
\arguments{
\item{x}{Return value from \code{\link{dtree}}}

\item{symbol}{Monetary symbol to use ($ is the default)}

\item{dec}{Decimal places to round results to}

\item{final}{If TRUE plot the decision tree solution, else the initial decision tree}

\item{orient}{Plot orientation: LR for vertical and TD for horizontal}

\item{width}{Plot width in pixels (default is "900px")}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the dtree function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/dtree.html} for an example in Radiant
}
\examples{
dtree(movie_contract, opt = "max") \%>\% plot()
dtree(movie_contract, opt = "max") \%>\% plot(final = TRUE, orient = "TD")

}
\seealso{
\code{\link{dtree}} to generate the result

\code{\link{summary.dtree}} to summarize results

\code{\link{sensitivity.dtree}} to plot results
}
